/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.facebook.share.model.ShareMedia;
import java.util.ArrayList;
import java.util.List;

public final class SharePhoto
extends ShareMedia {
    public static final Parcelable.Creator<SharePhoto> CREATOR = new Parcelable.Creator<SharePhoto>(){

        public SharePhoto createFromParcel(Parcel parcel) {
            return new SharePhoto(parcel);
        }

        public SharePhoto[] newArray(int n2) {
            return new SharePhoto[n2];
        }
    };
    private final Bitmap bitmap;
    private final String caption;
    private final Uri imageUrl;
    private final boolean userGenerated;

    SharePhoto(Parcel parcel) {
        super(parcel);
        this.bitmap = (Bitmap)parcel.readParcelable(Bitmap.class.getClassLoader());
        this.imageUrl = (Uri)parcel.readParcelable(Uri.class.getClassLoader());
        boolean bl = parcel.readByte() != 0;
        this.userGenerated = bl;
        this.caption = parcel.readString();
    }

    private SharePhoto(Builder builder) {
        super((ShareMedia.Builder)builder);
        this.bitmap = builder.bitmap;
        this.imageUrl = builder.imageUrl;
        this.userGenerated = builder.userGenerated;
        this.caption = builder.caption;
    }

    public int describeContents() {
        return 0;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public String getCaption() {
        return this.caption;
    }

    public Uri getImageUrl() {
        return this.imageUrl;
    }

    public ShareMedia.Type getMediaType() {
        return ShareMedia.Type.PHOTO;
    }

    public boolean getUserGenerated() {
        return this.userGenerated;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        super.writeToParcel(parcel, n2);
        parcel.writeParcelable((Parcelable)this.bitmap, 0);
        parcel.writeParcelable((Parcelable)this.imageUrl, 0);
        parcel.writeByte((byte)(this.userGenerated ? 1 : 0));
        parcel.writeString(this.caption);
    }

    public static final class Builder
    extends ShareMedia.Builder<SharePhoto, Builder> {
        private Bitmap bitmap;
        private String caption;
        private Uri imageUrl;
        private boolean userGenerated;

        static List<SharePhoto> readPhotoListFrom(Parcel object) {
            List list2 = Builder.readListFrom((Parcel)object);
            object = new ArrayList();
            for (List list2 : list2) {
                if (!(list2 instanceof SharePhoto)) continue;
                object.add((SharePhoto)((Object)list2));
            }
            return object;
        }

        static void writePhotoListTo(Parcel parcel, int n2, List<SharePhoto> list) {
            ShareMedia[] shareMediaArray = new ShareMedia[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                shareMediaArray[i2] = list.get(i2);
            }
            parcel.writeParcelableArray((Parcelable[])shareMediaArray, n2);
        }

        public SharePhoto build() {
            return new SharePhoto(this);
        }

        Bitmap getBitmap() {
            return this.bitmap;
        }

        Uri getImageUrl() {
            return this.imageUrl;
        }

        Builder readFrom(Parcel parcel) {
            return this.readFrom((SharePhoto)parcel.readParcelable(SharePhoto.class.getClassLoader()));
        }

        public Builder readFrom(SharePhoto sharePhoto) {
            if (sharePhoto == null) {
                return this;
            }
            return ((Builder)super.readFrom((ShareMedia)sharePhoto)).setBitmap(sharePhoto.getBitmap()).setImageUrl(sharePhoto.getImageUrl()).setUserGenerated(sharePhoto.getUserGenerated()).setCaption(sharePhoto.getCaption());
        }

        public Builder setBitmap(Bitmap bitmap) {
            this.bitmap = bitmap;
            return this;
        }

        public Builder setCaption(String string2) {
            this.caption = string2;
            return this;
        }

        public Builder setImageUrl(Uri uri) {
            this.imageUrl = uri;
            return this;
        }

        public Builder setUserGenerated(boolean bl) {
            this.userGenerated = bl;
            return this;
        }
    }
}

