/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.AccessTokenTracker;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookGraphResponseException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.internal.WorkQueue;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.share.Sharer;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.ShareVideoContent;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoUploader {
    private static final String ERROR_BAD_SERVER_RESPONSE = "Unexpected error in server response";
    private static final String ERROR_UPLOAD = "Video upload failed";
    private static final int MAX_RETRIES_PER_PHASE = 2;
    private static final String PARAM_DESCRIPTION = "description";
    private static final String PARAM_END_OFFSET = "end_offset";
    private static final String PARAM_FILE_SIZE = "file_size";
    private static final String PARAM_REF = "ref";
    private static final String PARAM_SESSION_ID = "upload_session_id";
    private static final String PARAM_START_OFFSET = "start_offset";
    private static final String PARAM_TITLE = "title";
    private static final String PARAM_UPLOAD_PHASE = "upload_phase";
    private static final String PARAM_VALUE_UPLOAD_FINISH_PHASE = "finish";
    private static final String PARAM_VALUE_UPLOAD_START_PHASE = "start";
    private static final String PARAM_VALUE_UPLOAD_TRANSFER_PHASE = "transfer";
    private static final String PARAM_VIDEO_FILE_CHUNK = "video_file_chunk";
    private static final String PARAM_VIDEO_ID = "video_id";
    private static final int RETRY_DELAY_BACK_OFF_FACTOR = 3;
    private static final int RETRY_DELAY_UNIT_MS = 5000;
    private static final String TAG = "VideoUploader";
    private static final int UPLOAD_QUEUE_MAX_CONCURRENT = 8;
    private static AccessTokenTracker accessTokenTracker;
    private static Handler handler;
    private static boolean initialized;
    private static Set<UploadContext> pendingUploads;
    private static WorkQueue uploadQueue;

    static {
        uploadQueue = new WorkQueue(8);
        pendingUploads = new HashSet<UploadContext>();
    }

    private static void cancelAllRequests() {
        synchronized (VideoUploader.class) {
            try {
                Iterator<UploadContext> iterator2 = pendingUploads.iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().isCanceled = true;
                }
            }
            catch (Throwable throwable) {}
            {
                throw throwable;
            }
            return;
        }
    }

    private static void enqueueRequest(UploadContext uploadContext, Runnable runnable2) {
        synchronized (VideoUploader.class) {
            uploadContext.workItem = uploadQueue.addActiveWorkItem(runnable2);
            return;
        }
    }

    private static void enqueueUploadChunk(UploadContext uploadContext, String string2, String string3, int n2) {
        VideoUploader.enqueueRequest(uploadContext, new TransferChunkWorkItem(uploadContext, string2, string3, n2));
    }

    private static void enqueueUploadFinish(UploadContext uploadContext, int n2) {
        VideoUploader.enqueueRequest(uploadContext, new FinishUploadWorkItem(uploadContext, n2));
    }

    private static void enqueueUploadStart(UploadContext uploadContext, int n2) {
        VideoUploader.enqueueRequest(uploadContext, new StartUploadWorkItem(uploadContext, n2));
    }

    private static byte[] getChunk(UploadContext uploadContext, String object, String string2) throws IOException {
        int n2;
        if (!Utility.areObjectsEqual((Object)object, (Object)uploadContext.chunkStart)) {
            VideoUploader.logError(null, "Error reading video chunk. Expected chunk '%s'. Requested chunk '%s'.", uploadContext.chunkStart, object);
            return null;
        }
        long l2 = Long.parseLong((String)object);
        int n3 = (int)(Long.parseLong(string2) - l2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object = new byte[Math.min(8192, n3)];
        while ((n2 = uploadContext.videoStream.read((byte[])object)) != -1) {
            byteArrayOutputStream.write((byte[])object, 0, n2);
            int n4 = n3 - n2;
            if (n4 == 0) break;
            n3 = n4;
            if (n4 >= 0) continue;
            VideoUploader.logError(null, "Error reading video chunk. Expected buffer length - '%d'. Actual - '%d'.", n4 + n2, n2);
            return null;
        }
        uploadContext.chunkStart = string2;
        return byteArrayOutputStream.toByteArray();
    }

    private static Handler getHandler() {
        synchronized (VideoUploader.class) {
            Handler handler;
            if (VideoUploader.handler == null) {
                VideoUploader.handler = handler = new Handler(Looper.getMainLooper());
            }
            handler = VideoUploader.handler;
            return handler;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void issueResponse(UploadContext uploadContext, FacebookException facebookException, GraphResponse graphResponse, String string2) {
        VideoUploader.removePendingUpload(uploadContext);
        Utility.closeQuietly((Closeable)uploadContext.videoStream);
        if (uploadContext.callback != null) {
            if (facebookException != null) {
                ShareInternalUtility.invokeOnErrorCallback(uploadContext.callback, (FacebookException)facebookException);
            } else if (uploadContext.isCanceled) {
                ShareInternalUtility.invokeOnCancelCallback(uploadContext.callback);
            } else {
                ShareInternalUtility.invokeOnSuccessCallback(uploadContext.callback, (String)string2);
            }
        }
        if (uploadContext.progressCallback != null) {
            if (graphResponse != null) {
                try {
                    if (graphResponse.getJSONObject() != null) {
                        graphResponse.getJSONObject().put(PARAM_VIDEO_ID, (Object)string2);
                    }
                }
                catch (JSONException jSONException) {}
            }
            uploadContext.progressCallback.onCompleted(graphResponse);
        }
    }

    private static void logError(Exception exception, String string2, Object ... objectArray) {
        Log.e((String)TAG, (String)String.format(Locale.ROOT, string2, objectArray), (Throwable)exception);
    }

    private static void registerAccessTokenTracker() {
        accessTokenTracker = new AccessTokenTracker(){

            @Override
            protected void onCurrentAccessTokenChanged(AccessToken accessToken, AccessToken accessToken2) {
                if (accessToken == null) {
                    return;
                }
                if (accessToken2 == null || !Utility.areObjectsEqual((Object)accessToken2.getUserId(), (Object)accessToken.getUserId())) {
                    VideoUploader.cancelAllRequests();
                }
            }
        };
    }

    private static void removePendingUpload(UploadContext uploadContext) {
        synchronized (VideoUploader.class) {
            pendingUploads.remove(uploadContext);
            return;
        }
    }

    public static void uploadAsync(ShareVideoContent shareVideoContent, String string2, FacebookCallback<Sharer.Result> facebookCallback) throws FileNotFoundException {
        synchronized (VideoUploader.class) {
            VideoUploader.uploadAsync(shareVideoContent, string2, facebookCallback, null);
            return;
        }
    }

    private static void uploadAsync(ShareVideoContent shareVideoContent, String string2, FacebookCallback<Sharer.Result> facebookCallback, GraphRequest.OnProgressCallback onProgressCallback) throws FileNotFoundException {
        synchronized (VideoUploader.class) {
            if (!initialized) {
                VideoUploader.registerAccessTokenTracker();
                initialized = true;
            }
            Validate.notNull((Object)((Object)shareVideoContent), (String)"videoContent");
            Validate.notNull((Object)string2, (String)"graphNode");
            Object object = shareVideoContent.getVideo();
            Validate.notNull((Object)object, (String)"videoContent.video");
            Validate.notNull((Object)object.getLocalUrl(), (String)"videoContent.video.localUrl");
            object = new UploadContext(shareVideoContent, string2, facebookCallback, onProgressCallback);
            ((UploadContext)object).initialize();
            pendingUploads.add((UploadContext)object);
            VideoUploader.enqueueUploadStart((UploadContext)object, 0);
            return;
        }
    }

    public static void uploadAsyncWithProgressCallback(ShareVideoContent shareVideoContent, GraphRequest.OnProgressCallback onProgressCallback) throws FileNotFoundException {
        synchronized (VideoUploader.class) {
            VideoUploader.uploadAsync(shareVideoContent, "me", null, onProgressCallback);
            return;
        }
    }

    public static void uploadAsyncWithProgressCallback(ShareVideoContent shareVideoContent, String string2, GraphRequest.OnProgressCallback onProgressCallback) throws FileNotFoundException {
        synchronized (VideoUploader.class) {
            VideoUploader.uploadAsync(shareVideoContent, string2, null, onProgressCallback);
            return;
        }
    }

    private static class FinishUploadWorkItem
    extends UploadWorkItemBase {
        static final Set<Integer> transientErrorCodes = new HashSet<Integer>(){
            {
                this.add(1363011);
            }
        };

        public FinishUploadWorkItem(UploadContext uploadContext, int n2) {
            super(uploadContext, n2);
        }

        @Override
        protected void enqueueRetry(int n2) {
            VideoUploader.enqueueUploadFinish(this.uploadContext, n2);
        }

        @Override
        public Bundle getParameters() {
            Bundle bundle = new Bundle();
            if (this.uploadContext.params != null) {
                bundle.putAll(this.uploadContext.params);
            }
            bundle.putString(VideoUploader.PARAM_UPLOAD_PHASE, VideoUploader.PARAM_VALUE_UPLOAD_FINISH_PHASE);
            bundle.putString(VideoUploader.PARAM_SESSION_ID, this.uploadContext.sessionId);
            Utility.putNonEmptyString((Bundle)bundle, (String)VideoUploader.PARAM_TITLE, (String)this.uploadContext.title);
            Utility.putNonEmptyString((Bundle)bundle, (String)VideoUploader.PARAM_DESCRIPTION, (String)this.uploadContext.description);
            Utility.putNonEmptyString((Bundle)bundle, (String)VideoUploader.PARAM_REF, (String)this.uploadContext.ref);
            return bundle;
        }

        @Override
        protected Set<Integer> getTransientErrorCodes() {
            return transientErrorCodes;
        }

        @Override
        protected void handleError(FacebookException facebookException) {
            VideoUploader.logError((Exception)facebookException, "Video '%s' failed to finish uploading", new Object[]{this.uploadContext.videoId});
            this.endUploadWithFailure(facebookException);
        }

        @Override
        protected void handleSuccess(JSONObject jSONObject) throws JSONException {
            if (jSONObject.getBoolean("success")) {
                this.issueResponseOnMainThread(null, this.uploadContext.videoId);
            } else {
                this.handleError(new FacebookException(VideoUploader.ERROR_BAD_SERVER_RESPONSE));
            }
        }
    }

    private static class StartUploadWorkItem
    extends UploadWorkItemBase {
        static final Set<Integer> transientErrorCodes = new HashSet<Integer>(){
            {
                this.add(6000);
            }
        };

        public StartUploadWorkItem(UploadContext uploadContext, int n2) {
            super(uploadContext, n2);
        }

        @Override
        protected void enqueueRetry(int n2) {
            VideoUploader.enqueueUploadStart(this.uploadContext, n2);
        }

        @Override
        public Bundle getParameters() {
            Bundle bundle = new Bundle();
            bundle.putString(VideoUploader.PARAM_UPLOAD_PHASE, VideoUploader.PARAM_VALUE_UPLOAD_START_PHASE);
            bundle.putLong(VideoUploader.PARAM_FILE_SIZE, this.uploadContext.videoSize);
            return bundle;
        }

        @Override
        protected Set<Integer> getTransientErrorCodes() {
            return transientErrorCodes;
        }

        @Override
        protected void handleError(FacebookException facebookException) {
            VideoUploader.logError((Exception)facebookException, "Error starting video upload", new Object[0]);
            this.endUploadWithFailure(facebookException);
        }

        @Override
        protected void handleSuccess(JSONObject object) throws JSONException {
            this.uploadContext.sessionId = object.getString(VideoUploader.PARAM_SESSION_ID);
            this.uploadContext.videoId = object.getString(VideoUploader.PARAM_VIDEO_ID);
            String string2 = object.getString(VideoUploader.PARAM_START_OFFSET);
            object = object.getString(VideoUploader.PARAM_END_OFFSET);
            if (this.uploadContext.progressCallback != null) {
                long l2 = Long.parseLong(string2);
                this.uploadContext.progressCallback.onProgress(l2, this.uploadContext.videoSize);
            }
            VideoUploader.enqueueUploadChunk(this.uploadContext, string2, (String)object, 0);
        }
    }

    private static class TransferChunkWorkItem
    extends UploadWorkItemBase {
        static final Set<Integer> transientErrorCodes = new HashSet<Integer>(){
            {
                this.add(1363019);
                this.add(1363021);
                this.add(1363030);
                this.add(1363033);
                this.add(1363041);
            }
        };
        private String chunkEnd;
        private String chunkStart;

        public TransferChunkWorkItem(UploadContext uploadContext, String string2, String string3, int n2) {
            super(uploadContext, n2);
            this.chunkStart = string2;
            this.chunkEnd = string3;
        }

        @Override
        protected void enqueueRetry(int n2) {
            VideoUploader.enqueueUploadChunk(this.uploadContext, this.chunkStart, this.chunkEnd, n2);
        }

        @Override
        public Bundle getParameters() throws IOException {
            Bundle bundle = new Bundle();
            bundle.putString(VideoUploader.PARAM_UPLOAD_PHASE, VideoUploader.PARAM_VALUE_UPLOAD_TRANSFER_PHASE);
            bundle.putString(VideoUploader.PARAM_SESSION_ID, this.uploadContext.sessionId);
            bundle.putString(VideoUploader.PARAM_START_OFFSET, this.chunkStart);
            byte[] byArray = VideoUploader.getChunk(this.uploadContext, this.chunkStart, this.chunkEnd);
            if (byArray != null) {
                bundle.putByteArray(VideoUploader.PARAM_VIDEO_FILE_CHUNK, byArray);
                return bundle;
            }
            throw new FacebookException("Error reading video");
        }

        @Override
        protected Set<Integer> getTransientErrorCodes() {
            return transientErrorCodes;
        }

        @Override
        protected void handleError(FacebookException facebookException) {
            VideoUploader.logError((Exception)facebookException, "Error uploading video '%s'", new Object[]{this.uploadContext.videoId});
            this.endUploadWithFailure(facebookException);
        }

        @Override
        protected void handleSuccess(JSONObject object) throws JSONException {
            String string2 = object.getString(VideoUploader.PARAM_START_OFFSET);
            object = object.getString(VideoUploader.PARAM_END_OFFSET);
            if (this.uploadContext.progressCallback != null) {
                long l2 = Long.parseLong(string2);
                this.uploadContext.progressCallback.onProgress(l2, this.uploadContext.videoSize);
            }
            if (Utility.areObjectsEqual((Object)string2, (Object)object)) {
                VideoUploader.enqueueUploadFinish(this.uploadContext, 0);
            } else {
                VideoUploader.enqueueUploadChunk(this.uploadContext, string2, (String)object, 0);
            }
        }
    }

    private static class UploadContext {
        public final AccessToken accessToken = AccessToken.getCurrentAccessToken();
        public final FacebookCallback<Sharer.Result> callback;
        public String chunkStart = "0";
        public final String description;
        public final String graphNode;
        public boolean isCanceled;
        public Bundle params;
        public final GraphRequest.OnProgressCallback progressCallback;
        public final String ref;
        public String sessionId;
        public final String title;
        public String videoId;
        public long videoSize;
        public InputStream videoStream;
        public final Uri videoUri;
        public WorkQueue.WorkItem workItem;

        private UploadContext(ShareVideoContent shareVideoContent, String string2, FacebookCallback<Sharer.Result> facebookCallback, GraphRequest.OnProgressCallback onProgressCallback) {
            this.videoUri = shareVideoContent.getVideo().getLocalUrl();
            this.title = shareVideoContent.getContentTitle();
            this.description = shareVideoContent.getContentDescription();
            this.ref = shareVideoContent.getRef();
            this.graphNode = string2;
            this.callback = facebookCallback;
            this.progressCallback = onProgressCallback;
            this.params = shareVideoContent.getVideo().getParameters();
            if (!Utility.isNullOrEmpty((Collection)shareVideoContent.getPeopleIds())) {
                this.params.putString("tags", TextUtils.join((CharSequence)", ", (Iterable)shareVideoContent.getPeopleIds()));
            }
            if (!Utility.isNullOrEmpty((String)shareVideoContent.getPlaceId())) {
                this.params.putString("place", shareVideoContent.getPlaceId());
            }
            if (!Utility.isNullOrEmpty((String)shareVideoContent.getRef())) {
                this.params.putString(VideoUploader.PARAM_REF, shareVideoContent.getRef());
            }
        }

        private void initialize() throws FileNotFoundException {
            try {
                block6: {
                    block5: {
                        block4: {
                            if (!Utility.isFileUri((Uri)this.videoUri)) break block4;
                            File file = new File(this.videoUri.getPath());
                            file = ParcelFileDescriptor.open((File)file, (int)0x10000000);
                            this.videoSize = file.getStatSize();
                            ParcelFileDescriptor.AutoCloseInputStream autoCloseInputStream = new ParcelFileDescriptor.AutoCloseInputStream((ParcelFileDescriptor)file);
                            this.videoStream = autoCloseInputStream;
                            break block5;
                        }
                        if (!Utility.isContentUri((Uri)this.videoUri)) break block6;
                        this.videoSize = Utility.getContentSize((Uri)this.videoUri);
                        this.videoStream = FacebookSdk.getApplicationContext().getContentResolver().openInputStream(this.videoUri);
                    }
                    return;
                }
                FacebookException facebookException = new FacebookException("Uri must be a content:// or file:// uri");
                throw facebookException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Utility.closeQuietly((Closeable)this.videoStream);
                throw fileNotFoundException;
            }
        }
    }

    private static abstract class UploadWorkItemBase
    implements Runnable {
        protected int completedRetries;
        protected GraphResponse response;
        protected UploadContext uploadContext;

        protected UploadWorkItemBase(UploadContext uploadContext, int n2) {
            this.uploadContext = uploadContext;
            this.completedRetries = n2;
        }

        private boolean attemptRetry(int n2) {
            if (this.completedRetries < 2 && this.getTransientErrorCodes().contains(n2)) {
                n2 = (int)Math.pow(3.0, this.completedRetries);
                VideoUploader.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                            return;
                        }
                        try {
                            UploadWorkItemBase.this.enqueueRetry(UploadWorkItemBase.this.completedRetries + 1);
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                            return;
                        }
                    }
                }, (long)(n2 * 5000));
                return true;
            }
            return false;
        }

        protected void endUploadWithFailure(FacebookException facebookException) {
            this.issueResponseOnMainThread(facebookException, null);
        }

        protected abstract void enqueueRetry(int var1);

        protected void executeGraphRequestSynchronously(Bundle bundle) {
            this.response = new GraphRequest(this.uploadContext.accessToken, String.format(Locale.ROOT, "%s/videos", this.uploadContext.graphNode), bundle, HttpMethod.POST, null).executeAndWait();
            bundle = this.response;
            if (bundle != null) {
                FacebookRequestError facebookRequestError = bundle.getError();
                bundle = this.response.getJSONObject();
                if (facebookRequestError != null) {
                    if (!this.attemptRetry(facebookRequestError.getSubErrorCode())) {
                        this.handleError((FacebookException)new FacebookGraphResponseException(this.response, VideoUploader.ERROR_UPLOAD));
                    }
                } else if (bundle != null) {
                    try {
                        this.handleSuccess((JSONObject)bundle);
                    }
                    catch (JSONException jSONException) {
                        this.endUploadWithFailure(new FacebookException(VideoUploader.ERROR_BAD_SERVER_RESPONSE, (Throwable)jSONException));
                    }
                } else {
                    this.handleError(new FacebookException(VideoUploader.ERROR_BAD_SERVER_RESPONSE));
                }
            } else {
                this.handleError(new FacebookException(VideoUploader.ERROR_BAD_SERVER_RESPONSE));
            }
        }

        protected abstract Bundle getParameters() throws Exception;

        protected abstract Set<Integer> getTransientErrorCodes();

        protected abstract void handleError(FacebookException var1);

        protected abstract void handleSuccess(JSONObject var1) throws JSONException;

        protected void issueResponseOnMainThread(final FacebookException facebookException, final String string2) {
            VideoUploader.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                        return;
                    }
                    try {
                        VideoUploader.issueResponse(UploadWorkItemBase.this.uploadContext, facebookException, UploadWorkItemBase.this.response, string2);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                        return;
                    }
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return;
            }
            try {
                boolean bl = this.uploadContext.isCanceled;
                if (bl) {
                    this.endUploadWithFailure(null);
                    return;
                }
                try {
                    this.executeGraphRequestSynchronously(this.getParameters());
                    return;
                }
                catch (Exception exception) {
                    FacebookException facebookException = new FacebookException(VideoUploader.ERROR_UPLOAD, (Throwable)exception);
                    this.endUploadWithFailure(facebookException);
                    return;
                }
                catch (FacebookException facebookException) {
                    this.endUploadWithFailure(facebookException);
                    return;
                }
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return;
            }
        }
    }
}

