/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.share.model.ShareCameraEffectContent;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareMedia;
import com.facebook.share.model.ShareMediaContent;
import com.facebook.share.model.ShareMessengerActionButton;
import com.facebook.share.model.ShareMessengerGenericTemplateContent;
import com.facebook.share.model.ShareMessengerMediaTemplateContent;
import com.facebook.share.model.ShareMessengerOpenGraphMusicTemplateContent;
import com.facebook.share.model.ShareMessengerURLActionButton;
import com.facebook.share.model.ShareOpenGraphAction;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.ShareOpenGraphObject;
import com.facebook.share.model.ShareOpenGraphValueContainer;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareStoryContent;
import com.facebook.share.model.ShareVideo;
import com.facebook.share.model.ShareVideoContent;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class ShareContentValidation {
    private static Validator ApiValidator;
    private static Validator DefaultValidator;
    private static Validator StoryValidator;
    private static Validator WebShareValidator;

    private static Validator getApiValidator() {
        if (ApiValidator == null) {
            ApiValidator = new ApiValidator();
        }
        return ApiValidator;
    }

    private static Validator getDefaultValidator() {
        if (DefaultValidator == null) {
            DefaultValidator = new Validator();
        }
        return DefaultValidator;
    }

    private static Validator getStoryValidator() {
        if (StoryValidator == null) {
            StoryValidator = new StoryShareValidator();
        }
        return StoryValidator;
    }

    private static Validator getWebShareValidator() {
        if (WebShareValidator == null) {
            WebShareValidator = new WebShareValidator();
        }
        return WebShareValidator;
    }

    private static void validate(ShareContent shareContent, Validator validator) throws FacebookException {
        if (shareContent != null) {
            if (shareContent instanceof ShareLinkContent) {
                validator.validate((ShareLinkContent)shareContent);
            } else if (shareContent instanceof SharePhotoContent) {
                validator.validate((SharePhotoContent)shareContent);
            } else if (shareContent instanceof ShareVideoContent) {
                validator.validate((ShareVideoContent)shareContent);
            } else if (shareContent instanceof ShareOpenGraphContent) {
                validator.validate((ShareOpenGraphContent)shareContent);
            } else if (shareContent instanceof ShareMediaContent) {
                validator.validate((ShareMediaContent)shareContent);
            } else if (shareContent instanceof ShareCameraEffectContent) {
                validator.validate((ShareCameraEffectContent)shareContent);
            } else if (shareContent instanceof ShareMessengerOpenGraphMusicTemplateContent) {
                validator.validate((ShareMessengerOpenGraphMusicTemplateContent)shareContent);
            } else if (shareContent instanceof ShareMessengerMediaTemplateContent) {
                validator.validate((ShareMessengerMediaTemplateContent)shareContent);
            } else if (shareContent instanceof ShareMessengerGenericTemplateContent) {
                validator.validate((ShareMessengerGenericTemplateContent)shareContent);
            } else if (shareContent instanceof ShareStoryContent) {
                validator.validate((ShareStoryContent)shareContent);
            }
            return;
        }
        throw new FacebookException("Must provide non-null content to share");
    }

    private static void validateCameraEffectContent(ShareCameraEffectContent shareCameraEffectContent, Validator validator) {
        if (!Utility.isNullOrEmpty((String)shareCameraEffectContent.getEffectId())) {
            return;
        }
        throw new FacebookException("Must specify a non-empty effectId");
    }

    public static void validateForApiShare(ShareContent shareContent) {
        ShareContentValidation.validate(shareContent, ShareContentValidation.getApiValidator());
    }

    public static void validateForMessage(ShareContent shareContent) {
        ShareContentValidation.validate(shareContent, ShareContentValidation.getDefaultValidator());
    }

    public static void validateForNativeShare(ShareContent shareContent) {
        ShareContentValidation.validate(shareContent, ShareContentValidation.getDefaultValidator());
    }

    public static void validateForStoryShare(ShareContent shareContent) {
        ShareContentValidation.validate(shareContent, ShareContentValidation.getStoryValidator());
    }

    public static void validateForWebShare(ShareContent shareContent) {
        ShareContentValidation.validate(shareContent, ShareContentValidation.getWebShareValidator());
    }

    private static void validateLinkContent(ShareLinkContent shareLinkContent, Validator validator) {
        if ((shareLinkContent = shareLinkContent.getImageUrl()) != null && !Utility.isWebUri((Uri)shareLinkContent)) {
            throw new FacebookException("Image Url must be an http:// or https:// url");
        }
    }

    private static void validateMediaContent(ShareMediaContent object, Validator validator) {
        if ((object = object.getMedia()) != null && !object.isEmpty()) {
            if (object.size() <= 6) {
                object = object.iterator();
                while (object.hasNext()) {
                    validator.validate((ShareMedia)object.next());
                }
                return;
            }
            throw new FacebookException(String.format(Locale.ROOT, "Cannot add more than %d media.", 6));
        }
        object = new FacebookException("Must specify at least one medium in ShareMediaContent.");
        throw object;
    }

    public static void validateMedium(ShareMedia shareMedia, Validator validator) {
        block4: {
            block3: {
                block2: {
                    if (!(shareMedia instanceof SharePhoto)) break block2;
                    validator.validate((SharePhoto)shareMedia);
                    break block3;
                }
                if (!(shareMedia instanceof ShareVideo)) break block4;
                validator.validate((ShareVideo)shareMedia);
            }
            return;
        }
        throw new FacebookException(String.format(Locale.ROOT, "Invalid media type: %s", shareMedia.getClass().getSimpleName()));
    }

    private static void validateMessengerOpenGraphMusicTemplate(ShareMessengerOpenGraphMusicTemplateContent shareMessengerOpenGraphMusicTemplateContent) {
        if (!Utility.isNullOrEmpty((String)shareMessengerOpenGraphMusicTemplateContent.getPageId())) {
            if (shareMessengerOpenGraphMusicTemplateContent.getUrl() != null) {
                ShareContentValidation.validateShareMessengerActionButton(shareMessengerOpenGraphMusicTemplateContent.getButton());
                return;
            }
            throw new FacebookException("Must specify url for ShareMessengerOpenGraphMusicTemplateContent");
        }
        throw new FacebookException("Must specify Page Id for ShareMessengerOpenGraphMusicTemplateContent");
    }

    private static void validateOpenGraphAction(ShareOpenGraphAction shareOpenGraphAction, Validator validator) {
        if (shareOpenGraphAction != null) {
            if (!Utility.isNullOrEmpty((String)shareOpenGraphAction.getActionType())) {
                validator.validate((ShareOpenGraphValueContainer)shareOpenGraphAction, false);
                return;
            }
            throw new FacebookException("ShareOpenGraphAction must have a non-empty actionType");
        }
        throw new FacebookException("Must specify a non-null ShareOpenGraphAction");
    }

    private static void validateOpenGraphContent(ShareOpenGraphContent object, Validator object2) {
        ((Validator)object2).validate(object.getAction());
        object2 = object.getPreviewPropertyName();
        if (!Utility.isNullOrEmpty((String)object2)) {
            if (object.getAction().get((String)object2) != null) {
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Property \"");
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append("\" was not found on the action. The name of the preview property must match the name of an action property.");
            throw new FacebookException(((StringBuilder)object).toString());
        }
        throw new FacebookException("Must specify a previewPropertyName.");
    }

    private static void validateOpenGraphKey(String string2, boolean bl) {
        if (!bl) {
            return;
        }
        String[] stringArray = string2.split(":");
        if (stringArray.length >= 2) {
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!stringArray[i2].isEmpty()) {
                    continue;
                }
                throw new FacebookException("Invalid key found in Open Graph dictionary: %s", new Object[]{string2});
            }
            return;
        }
        string2 = new FacebookException("Open Graph keys must be namespaced: %s", new Object[]{string2});
        throw string2;
    }

    private static void validateOpenGraphObject(ShareOpenGraphObject shareOpenGraphObject, Validator validator) {
        if (shareOpenGraphObject != null) {
            validator.validate((ShareOpenGraphValueContainer)shareOpenGraphObject, true);
            return;
        }
        throw new FacebookException("Cannot share a null ShareOpenGraphObject");
    }

    private static void validateOpenGraphValueContainer(ShareOpenGraphValueContainer shareOpenGraphValueContainer, Validator validator, boolean bl) {
        for (String string2 : shareOpenGraphValueContainer.keySet()) {
            ShareContentValidation.validateOpenGraphKey(string2, bl);
            Object object = shareOpenGraphValueContainer.get(string2);
            if (object instanceof List) {
                for (Object e2 : (List)object) {
                    if (e2 != null) {
                        ShareContentValidation.validateOpenGraphValueContainerObject(e2, validator);
                        continue;
                    }
                    throw new FacebookException("Cannot put null objects in Lists in ShareOpenGraphObjects and ShareOpenGraphActions");
                }
                continue;
            }
            ShareContentValidation.validateOpenGraphValueContainerObject(object, validator);
        }
    }

    private static void validateOpenGraphValueContainerObject(Object object, Validator validator) {
        if (object instanceof ShareOpenGraphObject) {
            validator.validate((ShareOpenGraphObject)object);
        } else if (object instanceof SharePhoto) {
            validator.validate((SharePhoto)((Object)object));
        }
    }

    private static void validatePhoto(SharePhoto sharePhoto) {
        if (sharePhoto != null) {
            Bitmap bitmap = sharePhoto.getBitmap();
            sharePhoto = sharePhoto.getImageUrl();
            if (bitmap == null && sharePhoto == null) {
                throw new FacebookException("SharePhoto does not have a Bitmap or ImageUrl specified");
            }
            return;
        }
        throw new FacebookException("Cannot share a null SharePhoto");
    }

    private static void validatePhotoContent(SharePhotoContent object, Validator validator) {
        if ((object = object.getPhotos()) != null && !object.isEmpty()) {
            if (object.size() <= 6) {
                object = object.iterator();
                while (object.hasNext()) {
                    validator.validate((SharePhoto)((Object)object.next()));
                }
                return;
            }
            throw new FacebookException(String.format(Locale.ROOT, "Cannot add more than %d photos.", 6));
        }
        object = new FacebookException("Must specify at least one Photo in SharePhotoContent.");
        throw object;
    }

    private static void validatePhotoForApi(SharePhoto sharePhoto, Validator validator) {
        ShareContentValidation.validatePhoto(sharePhoto);
        Bitmap bitmap = sharePhoto.getBitmap();
        sharePhoto = sharePhoto.getImageUrl();
        if (bitmap == null && Utility.isWebUri((Uri)sharePhoto) && !validator.isOpenGraphContent()) {
            throw new FacebookException("Cannot set the ImageUrl of a SharePhoto to the Uri of an image on the web when sharing SharePhotoContent");
        }
    }

    private static void validatePhotoForNativeDialog(SharePhoto sharePhoto, Validator validator) {
        ShareContentValidation.validatePhotoForApi(sharePhoto, validator);
        if (sharePhoto.getBitmap() != null || !Utility.isWebUri((Uri)sharePhoto.getImageUrl())) {
            Validate.hasContentProvider((Context)FacebookSdk.getApplicationContext());
        }
    }

    private static void validatePhotoForWebDialog(SharePhoto sharePhoto, Validator validator) {
        ShareContentValidation.validatePhoto(sharePhoto);
    }

    private static void validateShareMessengerActionButton(ShareMessengerActionButton shareMessengerActionButton) {
        if (shareMessengerActionButton == null) {
            return;
        }
        if (!Utility.isNullOrEmpty((String)shareMessengerActionButton.getTitle())) {
            if (shareMessengerActionButton instanceof ShareMessengerURLActionButton) {
                ShareContentValidation.validateShareMessengerURLActionButton((ShareMessengerURLActionButton)shareMessengerActionButton);
            }
            return;
        }
        throw new FacebookException("Must specify title for ShareMessengerActionButton");
    }

    private static void validateShareMessengerGenericTemplateContent(ShareMessengerGenericTemplateContent shareMessengerGenericTemplateContent) {
        if (!Utility.isNullOrEmpty((String)shareMessengerGenericTemplateContent.getPageId())) {
            if (shareMessengerGenericTemplateContent.getGenericTemplateElement() != null) {
                if (!Utility.isNullOrEmpty((String)shareMessengerGenericTemplateContent.getGenericTemplateElement().getTitle())) {
                    ShareContentValidation.validateShareMessengerActionButton(shareMessengerGenericTemplateContent.getGenericTemplateElement().getButton());
                    return;
                }
                throw new FacebookException("Must specify title for ShareMessengerGenericTemplateElement");
            }
            throw new FacebookException("Must specify element for ShareMessengerGenericTemplateContent");
        }
        throw new FacebookException("Must specify Page Id for ShareMessengerGenericTemplateContent");
    }

    private static void validateShareMessengerMediaTemplateContent(ShareMessengerMediaTemplateContent shareMessengerMediaTemplateContent) {
        if (!Utility.isNullOrEmpty((String)shareMessengerMediaTemplateContent.getPageId())) {
            if (shareMessengerMediaTemplateContent.getMediaUrl() == null && Utility.isNullOrEmpty((String)shareMessengerMediaTemplateContent.getAttachmentId())) {
                throw new FacebookException("Must specify either attachmentId or mediaURL for ShareMessengerMediaTemplateContent");
            }
            ShareContentValidation.validateShareMessengerActionButton(shareMessengerMediaTemplateContent.getButton());
            return;
        }
        throw new FacebookException("Must specify Page Id for ShareMessengerMediaTemplateContent");
    }

    private static void validateShareMessengerURLActionButton(ShareMessengerURLActionButton shareMessengerURLActionButton) {
        if (shareMessengerURLActionButton.getUrl() != null) {
            return;
        }
        throw new FacebookException("Must specify url for ShareMessengerURLActionButton");
    }

    private static void validateStoryContent(ShareStoryContent shareStoryContent, Validator validator) {
        if (shareStoryContent != null && (shareStoryContent.getBackgroundAsset() != null || shareStoryContent.getStickerAsset() != null)) {
            if (shareStoryContent.getBackgroundAsset() != null) {
                validator.validate(shareStoryContent.getBackgroundAsset());
            }
            if (shareStoryContent.getStickerAsset() != null) {
                validator.validate(shareStoryContent.getStickerAsset());
            }
            return;
        }
        throw new FacebookException("Must pass the Facebook app a background asset, a sticker asset, or both");
    }

    private static void validateVideo(ShareVideo shareVideo, Validator validator) {
        if (shareVideo != null) {
            if ((shareVideo = shareVideo.getLocalUrl()) != null) {
                if (!Utility.isContentUri((Uri)shareVideo) && !Utility.isFileUri((Uri)shareVideo)) {
                    throw new FacebookException("ShareVideo must reference a video that is on the device");
                }
                return;
            }
            throw new FacebookException("ShareVideo does not have a LocalUrl specified");
        }
        throw new FacebookException("Cannot share a null ShareVideo");
    }

    private static void validateVideoContent(ShareVideoContent object, Validator validator) {
        validator.validate(object.getVideo());
        object = object.getPreviewPhoto();
        if (object != null) {
            validator.validate((SharePhoto)((Object)object));
        }
    }

    private static class ApiValidator
    extends Validator {
        private ApiValidator() {
        }

        @Override
        public void validate(ShareLinkContent shareLinkContent) {
            if (Utility.isNullOrEmpty((String)shareLinkContent.getQuote())) {
                return;
            }
            throw new FacebookException("Cannot share link content with quote using the share api");
        }

        @Override
        public void validate(ShareMediaContent shareMediaContent) {
            throw new FacebookException("Cannot share ShareMediaContent using the share api");
        }

        @Override
        public void validate(SharePhoto sharePhoto) {
            ShareContentValidation.validatePhotoForApi(sharePhoto, this);
        }

        @Override
        public void validate(ShareVideoContent shareVideoContent) {
            if (Utility.isNullOrEmpty((String)shareVideoContent.getPlaceId())) {
                if (Utility.isNullOrEmpty((Collection)shareVideoContent.getPeopleIds())) {
                    if (Utility.isNullOrEmpty((String)shareVideoContent.getRef())) {
                        return;
                    }
                    throw new FacebookException("Cannot share video content with referrer URL using the share api");
                }
                throw new FacebookException("Cannot share video content with people IDs using the share api");
            }
            throw new FacebookException("Cannot share video content with place IDs using the share api");
        }
    }

    private static class StoryShareValidator
    extends Validator {
        private StoryShareValidator() {
        }

        @Override
        public void validate(ShareStoryContent shareStoryContent) {
            ShareContentValidation.validateStoryContent(shareStoryContent, this);
        }
    }

    private static class Validator {
        private boolean isOpenGraphContent = false;

        private Validator() {
        }

        public boolean isOpenGraphContent() {
            return this.isOpenGraphContent;
        }

        public void validate(ShareCameraEffectContent shareCameraEffectContent) {
            ShareContentValidation.validateCameraEffectContent(shareCameraEffectContent, this);
        }

        public void validate(ShareLinkContent shareLinkContent) {
            ShareContentValidation.validateLinkContent(shareLinkContent, this);
        }

        public void validate(ShareMedia shareMedia) {
            ShareContentValidation.validateMedium(shareMedia, this);
        }

        public void validate(ShareMediaContent shareMediaContent) {
            ShareContentValidation.validateMediaContent(shareMediaContent, this);
        }

        public void validate(ShareMessengerGenericTemplateContent shareMessengerGenericTemplateContent) {
            ShareContentValidation.validateShareMessengerGenericTemplateContent(shareMessengerGenericTemplateContent);
        }

        public void validate(ShareMessengerMediaTemplateContent shareMessengerMediaTemplateContent) {
            ShareContentValidation.validateShareMessengerMediaTemplateContent(shareMessengerMediaTemplateContent);
        }

        public void validate(ShareMessengerOpenGraphMusicTemplateContent shareMessengerOpenGraphMusicTemplateContent) {
            ShareContentValidation.validateMessengerOpenGraphMusicTemplate(shareMessengerOpenGraphMusicTemplateContent);
        }

        public void validate(ShareOpenGraphAction shareOpenGraphAction) {
            ShareContentValidation.validateOpenGraphAction(shareOpenGraphAction, this);
        }

        public void validate(ShareOpenGraphContent shareOpenGraphContent) {
            this.isOpenGraphContent = true;
            ShareContentValidation.validateOpenGraphContent(shareOpenGraphContent, this);
        }

        public void validate(ShareOpenGraphObject shareOpenGraphObject) {
            ShareContentValidation.validateOpenGraphObject(shareOpenGraphObject, this);
        }

        public void validate(ShareOpenGraphValueContainer shareOpenGraphValueContainer, boolean bl) {
            ShareContentValidation.validateOpenGraphValueContainer(shareOpenGraphValueContainer, this, bl);
        }

        public void validate(SharePhoto sharePhoto) {
            ShareContentValidation.validatePhotoForNativeDialog(sharePhoto, this);
        }

        public void validate(SharePhotoContent sharePhotoContent) {
            ShareContentValidation.validatePhotoContent(sharePhotoContent, this);
        }

        public void validate(ShareStoryContent shareStoryContent) {
            ShareContentValidation.validateStoryContent(shareStoryContent, this);
        }

        public void validate(ShareVideo shareVideo) {
            ShareContentValidation.validateVideo(shareVideo, this);
        }

        public void validate(ShareVideoContent shareVideoContent) {
            ShareContentValidation.validateVideoContent(shareVideoContent, this);
        }
    }

    private static class WebShareValidator
    extends Validator {
        private WebShareValidator() {
        }

        @Override
        public void validate(ShareMediaContent shareMediaContent) {
            throw new FacebookException("Cannot share ShareMediaContent via web sharing dialogs");
        }

        @Override
        public void validate(SharePhoto sharePhoto) {
            ShareContentValidation.validatePhotoForWebDialog(sharePhoto, this);
        }

        @Override
        public void validate(ShareVideoContent shareVideoContent) {
            throw new FacebookException("Cannot share ShareVideoContent via web sharing dialogs");
        }
    }
}

