/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.AccessToken;
import com.facebook.AccessTokenTracker;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.AppCall;
import com.facebook.internal.BundleJSONConverter;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.Logger;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.PlatformServiceClient;
import com.facebook.internal.Utility;
import com.facebook.internal.WorkQueue;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.share.internal.LikeContent;
import com.facebook.share.internal.LikeDialog;
import com.facebook.share.internal.LikeStatusClient;
import com.facebook.share.internal.ResultProcessor;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.widget.LikeView;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class LikeActionController {
    @Deprecated
    public static final String ACTION_LIKE_ACTION_CONTROLLER_DID_ERROR = "com.facebook.sdk.LikeActionController.DID_ERROR";
    @Deprecated
    public static final String ACTION_LIKE_ACTION_CONTROLLER_DID_RESET = "com.facebook.sdk.LikeActionController.DID_RESET";
    @Deprecated
    public static final String ACTION_LIKE_ACTION_CONTROLLER_UPDATED = "com.facebook.sdk.LikeActionController.UPDATED";
    @Deprecated
    public static final String ACTION_OBJECT_ID_KEY = "com.facebook.sdk.LikeActionController.OBJECT_ID";
    private static final int ERROR_CODE_OBJECT_ALREADY_LIKED = 3501;
    @Deprecated
    public static final String ERROR_INVALID_OBJECT_ID = "Invalid Object Id";
    @Deprecated
    public static final String ERROR_PUBLISH_ERROR = "Unable to publish the like/unlike action";
    private static final String JSON_BOOL_IS_OBJECT_LIKED_KEY = "is_object_liked";
    private static final String JSON_BUNDLE_FACEBOOK_DIALOG_ANALYTICS_BUNDLE = "facebook_dialog_analytics_bundle";
    private static final String JSON_INT_OBJECT_TYPE_KEY = "object_type";
    private static final String JSON_INT_VERSION_KEY = "com.facebook.share.internal.LikeActionController.version";
    private static final String JSON_STRING_LIKE_COUNT_WITHOUT_LIKE_KEY = "like_count_string_without_like";
    private static final String JSON_STRING_LIKE_COUNT_WITH_LIKE_KEY = "like_count_string_with_like";
    private static final String JSON_STRING_OBJECT_ID_KEY = "object_id";
    private static final String JSON_STRING_SOCIAL_SENTENCE_WITHOUT_LIKE_KEY = "social_sentence_without_like";
    private static final String JSON_STRING_SOCIAL_SENTENCE_WITH_LIKE_KEY = "social_sentence_with_like";
    private static final String JSON_STRING_UNLIKE_TOKEN_KEY = "unlike_token";
    private static final String LIKE_ACTION_CONTROLLER_STORE = "com.facebook.LikeActionController.CONTROLLER_STORE_KEY";
    private static final String LIKE_ACTION_CONTROLLER_STORE_OBJECT_SUFFIX_KEY = "OBJECT_SUFFIX";
    private static final String LIKE_ACTION_CONTROLLER_STORE_PENDING_OBJECT_ID_KEY = "PENDING_CONTROLLER_KEY";
    private static final int LIKE_ACTION_CONTROLLER_VERSION = 3;
    private static final String LIKE_DIALOG_RESPONSE_LIKE_COUNT_STRING_KEY = "like_count_string";
    private static final String LIKE_DIALOG_RESPONSE_OBJECT_IS_LIKED_KEY = "object_is_liked";
    private static final String LIKE_DIALOG_RESPONSE_SOCIAL_SENTENCE_KEY = "social_sentence";
    private static final String LIKE_DIALOG_RESPONSE_UNLIKE_TOKEN_KEY = "unlike_token";
    private static final int MAX_CACHE_SIZE = 128;
    private static final int MAX_OBJECT_SUFFIX = 1000;
    private static final String TAG = LikeActionController.class.getSimpleName();
    private static AccessTokenTracker accessTokenTracker;
    private static final ConcurrentHashMap<String, LikeActionController> cache;
    private static FileLruCache controllerDiskCache;
    private static WorkQueue diskIOWorkQueue;
    private static Handler handler;
    private static boolean isInitialized;
    private static WorkQueue mruCacheWorkQueue;
    private static String objectIdForPendingController;
    private static volatile int objectSuffix;
    private Bundle facebookDialogAnalyticsBundle;
    private boolean isObjectLiked;
    private boolean isObjectLikedOnServer;
    private boolean isPendingLikeOrUnlike;
    private String likeCountStringWithLike;
    private String likeCountStringWithoutLike;
    private InternalAppEventsLogger logger;
    private String objectId;
    private boolean objectIsPage;
    private LikeView.ObjectType objectType;
    private String socialSentenceWithLike;
    private String socialSentenceWithoutLike;
    private String unlikeToken;
    private String verifiedObjectId;

    static {
        cache = new ConcurrentHashMap();
        mruCacheWorkQueue = new WorkQueue(1);
        diskIOWorkQueue = new WorkQueue(1);
    }

    private LikeActionController(String string2, LikeView.ObjectType objectType) {
        this.objectId = string2;
        this.objectType = objectType;
    }

    static /* synthetic */ String access$1102(LikeActionController likeActionController, String string2) {
        likeActionController.unlikeToken = string2;
        return string2;
    }

    static /* synthetic */ String access$1602(LikeActionController likeActionController, String string2) {
        likeActionController.verifiedObjectId = string2;
        return string2;
    }

    static /* synthetic */ boolean access$1802(LikeActionController likeActionController, boolean bl) {
        likeActionController.isPendingLikeOrUnlike = bl;
        return bl;
    }

    static /* synthetic */ boolean access$2002(LikeActionController likeActionController, boolean bl) {
        likeActionController.isObjectLikedOnServer = bl;
        return bl;
    }

    static /* synthetic */ boolean access$2302(LikeActionController likeActionController, boolean bl) {
        likeActionController.objectIsPage = bl;
        return bl;
    }

    static /* synthetic */ int access$302(int n2) {
        objectSuffix = n2;
        return n2;
    }

    private static void broadcastAction(LikeActionController likeActionController, String string2) {
        LikeActionController.broadcastAction(likeActionController, string2, null);
    }

    private static void broadcastAction(LikeActionController likeActionController, String string2, Bundle bundle) {
        Intent intent = new Intent(string2);
        string2 = bundle;
        if (likeActionController != null) {
            string2 = bundle;
            if (bundle == null) {
                string2 = new Bundle();
            }
            string2.putString(ACTION_OBJECT_ID_KEY, likeActionController.getObjectId());
        }
        if (string2 != null) {
            intent.putExtras((Bundle)string2);
        }
        LocalBroadcastManager.getInstance((Context)FacebookSdk.getApplicationContext()).sendBroadcast(intent);
    }

    private boolean canUseOGPublish() {
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        boolean bl = !this.objectIsPage && this.verifiedObjectId != null && AccessToken.isCurrentAccessTokenActive() && accessToken.getPermissions() != null && accessToken.getPermissions().contains("publish_actions");
        return bl;
    }

    private void clearState() {
        this.facebookDialogAnalyticsBundle = null;
        LikeActionController.storeObjectIdForPendingController(null);
    }

    private static void createControllerForObjectIdAndType(String string2, LikeView.ObjectType objectType, CreationCallback creationCallback) {
        LikeActionController likeActionController;
        final LikeActionController likeActionController2 = LikeActionController.getControllerFromInMemoryCache(string2);
        if (likeActionController2 != null) {
            LikeActionController.verifyControllerAndInvokeCallback(likeActionController2, objectType, creationCallback);
            return;
        }
        likeActionController2 = likeActionController = LikeActionController.deserializeFromDiskSynchronously(string2);
        if (likeActionController == null) {
            likeActionController2 = new LikeActionController(string2, objectType);
            LikeActionController.serializeToDiskAsync(likeActionController2);
        }
        LikeActionController.putControllerInMemoryCache(string2, likeActionController2);
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                    return;
                }
                try {
                    likeActionController2.refreshStatusAsync();
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                    return;
                }
            }
        });
        LikeActionController.invokeCallbackWithController(creationCallback, likeActionController2, null);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LikeActionController deserializeFromDiskSynchronously(String object) {
        void var0_3;
        Object object2;
        block9: {
            Object object3;
            block10: {
                Object var2_5;
                Object var1_4;
                block8: {
                    block7: {
                        var1_4 = null;
                        var2_5 = null;
                        Object var3_6 = null;
                        object = LikeActionController.getCacheKeyForObjectId((String)object);
                        object3 = controllerDiskCache.get((String)object);
                        object = var3_6;
                        if (object3 == null) break block7;
                        object2 = object3;
                        try {
                            String string2 = Utility.readStreamToString((InputStream)object3);
                            object = var3_6;
                            object2 = object3;
                            if (Utility.isNullOrEmpty((String)string2)) break block7;
                            object2 = object3;
                            object = LikeActionController.deserializeFromJson(string2);
                        }
                        catch (IOException iOException) {
                            object = object3;
                            break block8;
                        }
                    }
                    object2 = object;
                    if (object3 == null) return object2;
                    object2 = object;
                    break block10;
                    catch (Throwable throwable) {
                        object2 = null;
                        break block9;
                    }
                    catch (IOException iOException) {
                        object = null;
                    }
                }
                object2 = object;
                try {
                    void var3_9;
                    Log.e((String)TAG, (String)"Unable to deserialize controller from disk", (Throwable)var3_9);
                    object2 = var2_5;
                    if (object == null) return object2;
                    object2 = var1_4;
                    object3 = object;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Utility.closeQuietly((Closeable)object3);
            return object2;
        }
        if (object2 == null) throw var0_3;
        Utility.closeQuietly((Closeable)object2);
        throw var0_3;
    }

    private static LikeActionController deserializeFromJson(String object) {
        block5: {
            JSONObject jSONObject;
            Object var1_2;
            block4: {
                var1_2 = null;
                jSONObject = new JSONObject((String)object);
                if (jSONObject.optInt(JSON_INT_VERSION_KEY, -1) == 3) break block4;
                return null;
            }
            String string2 = jSONObject.getString(JSON_STRING_OBJECT_ID_KEY);
            int n2 = jSONObject.optInt(JSON_INT_OBJECT_TYPE_KEY, LikeView.ObjectType.UNKNOWN.getValue());
            object = new LikeActionController(string2, LikeView.ObjectType.fromInt((int)n2));
            ((LikeActionController)object).likeCountStringWithLike = jSONObject.optString(JSON_STRING_LIKE_COUNT_WITH_LIKE_KEY, null);
            ((LikeActionController)object).likeCountStringWithoutLike = jSONObject.optString(JSON_STRING_LIKE_COUNT_WITHOUT_LIKE_KEY, null);
            ((LikeActionController)object).socialSentenceWithLike = jSONObject.optString(JSON_STRING_SOCIAL_SENTENCE_WITH_LIKE_KEY, null);
            ((LikeActionController)object).socialSentenceWithoutLike = jSONObject.optString(JSON_STRING_SOCIAL_SENTENCE_WITHOUT_LIKE_KEY, null);
            ((LikeActionController)object).isObjectLiked = jSONObject.optBoolean(JSON_BOOL_IS_OBJECT_LIKED_KEY);
            ((LikeActionController)object).unlikeToken = jSONObject.optString("unlike_token", null);
            jSONObject = jSONObject.optJSONObject(JSON_BUNDLE_FACEBOOK_DIALOG_ANALYTICS_BUNDLE);
            if (jSONObject == null) break block5;
            try {
                ((LikeActionController)object).facebookDialogAnalyticsBundle = BundleJSONConverter.convertToBundle(jSONObject);
            }
            catch (JSONException jSONException) {
                Log.e((String)TAG, (String)"Unable to deserialize controller from JSON", (Throwable)jSONException);
                object = var1_2;
            }
        }
        return object;
    }

    private void fetchVerifiedObjectId(final RequestCompletionCallback requestCompletionCallback) {
        if (!Utility.isNullOrEmpty((String)this.verifiedObjectId)) {
            if (requestCompletionCallback != null) {
                requestCompletionCallback.onComplete();
            }
            return;
        }
        final GetOGObjectIdRequestWrapper getOGObjectIdRequestWrapper = new GetOGObjectIdRequestWrapper(this.objectId, this.objectType);
        final GetPageIdRequestWrapper getPageIdRequestWrapper = new GetPageIdRequestWrapper(this.objectId, this.objectType);
        GraphRequestBatch graphRequestBatch = new GraphRequestBatch();
        getOGObjectIdRequestWrapper.addToBatch(graphRequestBatch);
        getPageIdRequestWrapper.addToBatch(graphRequestBatch);
        graphRequestBatch.addCallback(new GraphRequestBatch.Callback(){

            public void onBatchCompleted(GraphRequestBatch object) {
                LikeActionController.access$1602(LikeActionController.this, getOGObjectIdRequestWrapper.verifiedObjectId);
                if (Utility.isNullOrEmpty((String)LikeActionController.this.verifiedObjectId)) {
                    LikeActionController.access$1602(LikeActionController.this, getPageIdRequestWrapper.verifiedObjectId);
                    LikeActionController.access$2302(LikeActionController.this, getPageIdRequestWrapper.objectIsPage);
                }
                if (Utility.isNullOrEmpty((String)LikeActionController.this.verifiedObjectId)) {
                    Logger.log((LoggingBehavior)LoggingBehavior.DEVELOPER_ERRORS, (String)TAG, (String)"Unable to verify the FB id for '%s'. Verify that it is a valid FB object or page", (Object[])new Object[]{LikeActionController.this.objectId});
                    LikeActionController likeActionController = LikeActionController.this;
                    object = getPageIdRequestWrapper.getError() != null ? getPageIdRequestWrapper.getError() : getOGObjectIdRequestWrapper.getError();
                    likeActionController.logAppEventForError("get_verified_id", (FacebookRequestError)object);
                }
                if ((object = requestCompletionCallback) != null) {
                    object.onComplete();
                }
            }
        });
        graphRequestBatch.executeAsync();
    }

    private InternalAppEventsLogger getAppEventsLogger() {
        if (this.logger == null) {
            this.logger = new InternalAppEventsLogger(FacebookSdk.getApplicationContext());
        }
        return this.logger;
    }

    private static String getCacheKeyForObjectId(String string2) {
        Object object = AccessToken.getCurrentAccessToken();
        object = AccessToken.isCurrentAccessTokenActive() ? object.getToken() : null;
        Object object2 = object;
        if (object != null) {
            object2 = Utility.md5hash((String)object);
        }
        return String.format(Locale.ROOT, "%s|%s|com.fb.sdk.like|%d", string2, Utility.coerceValueIfNullOrEmpty((String)object2, (String)""), objectSuffix);
    }

    @Deprecated
    public static void getControllerForObjectId(String string2, LikeView.ObjectType objectType, CreationCallback creationCallback) {
        LikeActionController likeActionController;
        if (!isInitialized) {
            LikeActionController.performFirstInitialize();
        }
        if ((likeActionController = LikeActionController.getControllerFromInMemoryCache(string2)) != null) {
            LikeActionController.verifyControllerAndInvokeCallback(likeActionController, objectType, creationCallback);
        } else {
            diskIOWorkQueue.addActiveWorkItem((Runnable)new CreateLikeActionControllerWorkItem(string2, objectType, creationCallback));
        }
    }

    private static LikeActionController getControllerFromInMemoryCache(String string2) {
        LikeActionController likeActionController = cache.get(string2 = LikeActionController.getCacheKeyForObjectId(string2));
        if (likeActionController != null) {
            mruCacheWorkQueue.addActiveWorkItem((Runnable)new MRUCacheWorkItem(string2, false));
        }
        return likeActionController;
    }

    private ResultProcessor getResultProcessor(final Bundle bundle) {
        return new ResultProcessor(null){

            public void onCancel(AppCall appCall) {
                this.onError(appCall, (FacebookException)new FacebookOperationCanceledException());
            }

            public void onError(AppCall appCall, FacebookException facebookException) {
                Bundle bundle3;
                Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Like Dialog failed with error : %s", (Object[])new Object[]{facebookException});
                Bundle bundle2 = bundle3 = bundle;
                if (bundle3 == null) {
                    bundle2 = new Bundle();
                }
                bundle2.putString("call_id", appCall.getCallId().toString());
                LikeActionController.this.logAppEventForError("present_dialog", bundle2);
                LikeActionController.broadcastAction(LikeActionController.this, LikeActionController.ACTION_LIKE_ACTION_CONTROLLER_DID_ERROR, NativeProtocol.createBundleForException(facebookException));
            }

            public void onSuccess(AppCall appCall, Bundle object) {
                if (object != null && object.containsKey(LikeActionController.LIKE_DIALOG_RESPONSE_OBJECT_IS_LIKED_KEY)) {
                    Bundle bundle3;
                    boolean bl = object.getBoolean(LikeActionController.LIKE_DIALOG_RESPONSE_OBJECT_IS_LIKED_KEY);
                    String string2 = LikeActionController.this.likeCountStringWithLike;
                    String string3 = LikeActionController.this.likeCountStringWithoutLike;
                    if (object.containsKey(LikeActionController.LIKE_DIALOG_RESPONSE_LIKE_COUNT_STRING_KEY)) {
                        string3 = string2 = object.getString(LikeActionController.LIKE_DIALOG_RESPONSE_LIKE_COUNT_STRING_KEY);
                    }
                    String string4 = LikeActionController.this.socialSentenceWithLike;
                    String string5 = LikeActionController.this.socialSentenceWithoutLike;
                    if (object.containsKey(LikeActionController.LIKE_DIALOG_RESPONSE_SOCIAL_SENTENCE_KEY)) {
                        string5 = string4 = object.getString(LikeActionController.LIKE_DIALOG_RESPONSE_SOCIAL_SENTENCE_KEY);
                    }
                    object = object.containsKey(LikeActionController.LIKE_DIALOG_RESPONSE_OBJECT_IS_LIKED_KEY) ? object.getString("unlike_token") : LikeActionController.this.unlikeToken;
                    Bundle bundle2 = bundle3 = bundle;
                    if (bundle3 == null) {
                        bundle2 = new Bundle();
                    }
                    bundle2.putString("call_id", appCall.getCallId().toString());
                    LikeActionController.this.getAppEventsLogger().logEventImplicitly("fb_like_control_dialog_did_succeed", bundle2);
                    LikeActionController.this.updateState(bl, string2, string3, string4, string5, (String)object);
                }
            }
        };
    }

    @Deprecated
    public static boolean handleOnActivityResult(final int n2, final int n3, final Intent intent) {
        if (Utility.isNullOrEmpty((String)objectIdForPendingController)) {
            objectIdForPendingController = FacebookSdk.getApplicationContext().getSharedPreferences(LIKE_ACTION_CONTROLLER_STORE, 0).getString(LIKE_ACTION_CONTROLLER_STORE_PENDING_OBJECT_ID_KEY, null);
        }
        if (Utility.isNullOrEmpty((String)objectIdForPendingController)) {
            return false;
        }
        LikeActionController.getControllerForObjectId(objectIdForPendingController, LikeView.ObjectType.UNKNOWN, new CreationCallback(){

            @Override
            public void onComplete(LikeActionController likeActionController, FacebookException facebookException) {
                if (facebookException == null) {
                    likeActionController.onActivityResult(n2, n3, intent);
                } else {
                    Utility.logd((String)TAG, (Exception)facebookException);
                }
            }
        });
        return true;
    }

    private static void invokeCallbackWithController(final CreationCallback creationCallback, final LikeActionController likeActionController, final FacebookException facebookException) {
        if (creationCallback == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                    return;
                }
                try {
                    creationCallback.onComplete(likeActionController, facebookException);
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                    return;
                }
            }
        });
    }

    private void logAppEventForError(String string2, Bundle bundle) {
        bundle = new Bundle(bundle);
        bundle.putString(JSON_STRING_OBJECT_ID_KEY, this.objectId);
        bundle.putString(JSON_INT_OBJECT_TYPE_KEY, this.objectType.toString());
        bundle.putString("current_action", string2);
        this.getAppEventsLogger().logEventImplicitly("fb_like_control_error", null, bundle);
    }

    private void logAppEventForError(String string2, FacebookRequestError facebookRequestError) {
        Bundle bundle = new Bundle();
        if (facebookRequestError != null && (facebookRequestError = facebookRequestError.getRequestResult()) != null) {
            bundle.putString("error", facebookRequestError.toString());
        }
        this.logAppEventForError(string2, bundle);
    }

    private void onActivityResult(int n2, int n3, Intent intent) {
        ShareInternalUtility.handleActivityResult((int)n2, (int)n3, (Intent)intent, (ResultProcessor)this.getResultProcessor(this.facebookDialogAnalyticsBundle));
        this.clearState();
    }

    private static void performFirstInitialize() {
        synchronized (LikeActionController.class) {
            FileLruCache fileLruCache;
            Object object;
            block5: {
                boolean bl = isInitialized;
                if (!bl) break block5;
                return;
            }
            handler = object = new Handler(Looper.getMainLooper());
            objectSuffix = FacebookSdk.getApplicationContext().getSharedPreferences(LIKE_ACTION_CONTROLLER_STORE, 0).getInt(LIKE_ACTION_CONTROLLER_STORE_OBJECT_SUFFIX_KEY, 1);
            String string2 = TAG;
            object = new FileLruCache.Limits();
            controllerDiskCache = fileLruCache = new FileLruCache(string2, (FileLruCache.Limits)object);
            LikeActionController.registerAccessTokenTracker();
            int n2 = CallbackManagerImpl.RequestCodeOffset.Like.toRequestCode();
            object = new CallbackManagerImpl.Callback(){

                public boolean onActivityResult(int n2, Intent intent) {
                    return LikeActionController.handleOnActivityResult(CallbackManagerImpl.RequestCodeOffset.Like.toRequestCode(), n2, intent);
                }
            };
            CallbackManagerImpl.registerStaticCallback((int)n2, (CallbackManagerImpl.Callback)object);
            isInitialized = true;
            return;
        }
    }

    private void presentLikeDialog(Activity activity, FragmentWrapper fragmentWrapper, Bundle bundle) {
        String string2;
        if (LikeDialog.canShowNativeDialog()) {
            string2 = "fb_like_control_did_present_dialog";
        } else if (LikeDialog.canShowWebFallback()) {
            string2 = "fb_like_control_did_present_fallback_dialog";
        } else {
            this.logAppEventForError("present_dialog", bundle);
            Utility.logd((String)TAG, (String)"Cannot show the Like Dialog on this device.");
            LikeActionController.broadcastAction(null, ACTION_LIKE_ACTION_CONTROLLER_UPDATED);
            string2 = null;
        }
        if (string2 != null) {
            string2 = this.objectType;
            string2 = string2 != null ? string2.toString() : LikeView.ObjectType.UNKNOWN.toString();
            string2 = new LikeContent.Builder().setObjectId(this.objectId).setObjectType(string2).build();
            if (fragmentWrapper != null) {
                new LikeDialog(fragmentWrapper).show((LikeContent)string2);
            } else {
                new LikeDialog(activity).show((LikeContent)string2);
            }
            this.saveState(bundle);
            this.getAppEventsLogger().logEventImplicitly("fb_like_control_did_present_dialog", bundle);
        }
    }

    private void publishAgainIfNeeded(Bundle bundle) {
        boolean bl = this.isObjectLiked;
        if (bl != this.isObjectLikedOnServer && !this.publishLikeOrUnlikeAsync(bl, bundle)) {
            this.publishDidError(this.isObjectLiked ^ true);
        }
    }

    private void publishDidError(boolean bl) {
        this.updateLikeState(bl);
        Bundle bundle = new Bundle();
        bundle.putString("com.facebook.platform.status.ERROR_DESCRIPTION", ERROR_PUBLISH_ERROR);
        LikeActionController.broadcastAction(this, ACTION_LIKE_ACTION_CONTROLLER_DID_ERROR, bundle);
    }

    private void publishLikeAsync(final Bundle bundle) {
        this.isPendingLikeOrUnlike = true;
        this.fetchVerifiedObjectId(new RequestCompletionCallback(){

            @Override
            public void onComplete() {
                if (Utility.isNullOrEmpty((String)LikeActionController.this.verifiedObjectId)) {
                    Bundle bundle2 = new Bundle();
                    bundle2.putString("com.facebook.platform.status.ERROR_DESCRIPTION", LikeActionController.ERROR_INVALID_OBJECT_ID);
                    LikeActionController.broadcastAction(LikeActionController.this, LikeActionController.ACTION_LIKE_ACTION_CONTROLLER_DID_ERROR, bundle2);
                    return;
                }
                GraphRequestBatch graphRequestBatch = new GraphRequestBatch();
                Object object = LikeActionController.this;
                object = (LikeActionController)object.new PublishLikeRequestWrapper(((LikeActionController)object).verifiedObjectId, LikeActionController.this.objectType);
                ((AbstractRequestWrapper)object).addToBatch(graphRequestBatch);
                graphRequestBatch.addCallback(new GraphRequestBatch.Callback((PublishLikeRequestWrapper)object){
                    final /* synthetic */ PublishLikeRequestWrapper val$likeRequest;
                    {
                        this.val$likeRequest = publishLikeRequestWrapper;
                    }

                    public void onBatchCompleted(GraphRequestBatch graphRequestBatch) {
                        LikeActionController.access$1802(LikeActionController.this, false);
                        if (this.val$likeRequest.getError() != null) {
                            LikeActionController.this.publishDidError(false);
                        } else {
                            LikeActionController.access$1102(LikeActionController.this, Utility.coerceValueIfNullOrEmpty((String)this.val$likeRequest.unlikeToken, null));
                            LikeActionController.access$2002(LikeActionController.this, true);
                            LikeActionController.this.getAppEventsLogger().logEventImplicitly("fb_like_control_did_like", null, bundle);
                            LikeActionController.this.publishAgainIfNeeded(bundle);
                        }
                    }
                });
                graphRequestBatch.executeAsync();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean publishLikeOrUnlikeAsync(boolean bl, Bundle bundle) {
        boolean bl2 = this.canUseOGPublish();
        boolean bl3 = true;
        if (!bl2) return false;
        if (bl) {
            this.publishLikeAsync(bundle);
            return bl3;
        }
        if (Utility.isNullOrEmpty((String)this.unlikeToken)) return false;
        this.publishUnlikeAsync(bundle);
        return bl3;
    }

    private void publishUnlikeAsync(final Bundle bundle) {
        this.isPendingLikeOrUnlike = true;
        GraphRequestBatch graphRequestBatch = new GraphRequestBatch();
        final PublishUnlikeRequestWrapper publishUnlikeRequestWrapper = new PublishUnlikeRequestWrapper(this.unlikeToken);
        publishUnlikeRequestWrapper.addToBatch(graphRequestBatch);
        graphRequestBatch.addCallback(new GraphRequestBatch.Callback(){

            public void onBatchCompleted(GraphRequestBatch graphRequestBatch) {
                LikeActionController.access$1802(LikeActionController.this, false);
                if (publishUnlikeRequestWrapper.getError() != null) {
                    LikeActionController.this.publishDidError(true);
                } else {
                    LikeActionController.access$1102(LikeActionController.this, null);
                    LikeActionController.access$2002(LikeActionController.this, false);
                    LikeActionController.this.getAppEventsLogger().logEventImplicitly("fb_like_control_did_unlike", null, bundle);
                    LikeActionController.this.publishAgainIfNeeded(bundle);
                }
            }
        });
        graphRequestBatch.executeAsync();
    }

    private static void putControllerInMemoryCache(String string2, LikeActionController likeActionController) {
        string2 = LikeActionController.getCacheKeyForObjectId(string2);
        mruCacheWorkQueue.addActiveWorkItem((Runnable)new MRUCacheWorkItem(string2, true));
        cache.put(string2, likeActionController);
    }

    private void refreshStatusAsync() {
        if (!AccessToken.isCurrentAccessTokenActive()) {
            this.refreshStatusViaService();
            return;
        }
        this.fetchVerifiedObjectId(new RequestCompletionCallback(){

            @Override
            public void onComplete() {
                Object object;
                if (12.$SwitchMap$com$facebook$share$widget$LikeView$ObjectType[LikeActionController.this.objectType.ordinal()] != 1) {
                    object = LikeActionController.this;
                    object = (LikeActionController)object.new GetOGObjectLikesRequestWrapper(((LikeActionController)object).verifiedObjectId, LikeActionController.this.objectType);
                } else {
                    object = LikeActionController.this;
                    object = (LikeActionController)object.new GetPageLikesRequestWrapper(((LikeActionController)object).verifiedObjectId);
                }
                Object object2 = LikeActionController.this;
                object2 = (LikeActionController)object2.new GetEngagementRequestWrapper(((LikeActionController)object2).verifiedObjectId, LikeActionController.this.objectType);
                GraphRequestBatch graphRequestBatch = new GraphRequestBatch();
                object.addToBatch(graphRequestBatch);
                ((AbstractRequestWrapper)object2).addToBatch(graphRequestBatch);
                graphRequestBatch.addCallback(new GraphRequestBatch.Callback((LikeRequestWrapper)object, (GetEngagementRequestWrapper)object2){
                    final /* synthetic */ GetEngagementRequestWrapper val$engagementRequest;
                    final /* synthetic */ LikeRequestWrapper val$likeRequestWrapper;
                    {
                        this.val$likeRequestWrapper = likeRequestWrapper;
                        this.val$engagementRequest = getEngagementRequestWrapper;
                    }

                    public void onBatchCompleted(GraphRequestBatch graphRequestBatch) {
                        if (this.val$likeRequestWrapper.getError() == null && this.val$engagementRequest.getError() == null) {
                            LikeActionController.this.updateState(this.val$likeRequestWrapper.isObjectLiked(), this.val$engagementRequest.likeCountStringWithLike, this.val$engagementRequest.likeCountStringWithoutLike, this.val$engagementRequest.socialSentenceStringWithLike, this.val$engagementRequest.socialSentenceStringWithoutLike, this.val$likeRequestWrapper.getUnlikeToken());
                            return;
                        }
                        Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Unable to refresh like state for id: '%s'", (Object[])new Object[]{LikeActionController.this.objectId});
                    }
                });
                graphRequestBatch.executeAsync();
            }
        });
    }

    private void refreshStatusViaService() {
        LikeStatusClient likeStatusClient = new LikeStatusClient(FacebookSdk.getApplicationContext(), FacebookSdk.getApplicationId(), this.objectId);
        if (!likeStatusClient.start()) {
            return;
        }
        likeStatusClient.setCompletedListener(new PlatformServiceClient.CompletedListener(){

            @Override
            public void completed(Bundle object) {
                if (object != null && object.containsKey("com.facebook.platform.extra.OBJECT_IS_LIKED")) {
                    boolean bl = object.getBoolean("com.facebook.platform.extra.OBJECT_IS_LIKED");
                    String string2 = object.containsKey("com.facebook.platform.extra.LIKE_COUNT_STRING_WITH_LIKE") ? object.getString("com.facebook.platform.extra.LIKE_COUNT_STRING_WITH_LIKE") : LikeActionController.this.likeCountStringWithLike;
                    String string3 = object.containsKey("com.facebook.platform.extra.LIKE_COUNT_STRING_WITHOUT_LIKE") ? object.getString("com.facebook.platform.extra.LIKE_COUNT_STRING_WITHOUT_LIKE") : LikeActionController.this.likeCountStringWithoutLike;
                    String string4 = object.containsKey("com.facebook.platform.extra.SOCIAL_SENTENCE_WITH_LIKE") ? object.getString("com.facebook.platform.extra.SOCIAL_SENTENCE_WITH_LIKE") : LikeActionController.this.socialSentenceWithLike;
                    String string5 = object.containsKey("com.facebook.platform.extra.SOCIAL_SENTENCE_WITHOUT_LIKE") ? object.getString("com.facebook.platform.extra.SOCIAL_SENTENCE_WITHOUT_LIKE") : LikeActionController.this.socialSentenceWithoutLike;
                    object = object.containsKey("com.facebook.platform.extra.UNLIKE_TOKEN") ? object.getString("com.facebook.platform.extra.UNLIKE_TOKEN") : LikeActionController.this.unlikeToken;
                    LikeActionController.this.updateState(bl, string2, string3, string4, string5, (String)object);
                }
            }
        });
    }

    private static void registerAccessTokenTracker() {
        accessTokenTracker = new AccessTokenTracker(){

            @Override
            protected void onCurrentAccessTokenChanged(AccessToken accessToken, AccessToken accessToken2) {
                accessToken = FacebookSdk.getApplicationContext();
                if (accessToken2 == null) {
                    LikeActionController.access$302((objectSuffix + 1) % 1000);
                    accessToken.getSharedPreferences(LikeActionController.LIKE_ACTION_CONTROLLER_STORE, 0).edit().putInt(LikeActionController.LIKE_ACTION_CONTROLLER_STORE_OBJECT_SUFFIX_KEY, objectSuffix).apply();
                    cache.clear();
                    controllerDiskCache.clearCache();
                }
                LikeActionController.broadcastAction(null, LikeActionController.ACTION_LIKE_ACTION_CONTROLLER_DID_RESET);
            }
        };
    }

    private void saveState(Bundle bundle) {
        LikeActionController.storeObjectIdForPendingController(this.objectId);
        this.facebookDialogAnalyticsBundle = bundle;
        LikeActionController.serializeToDiskAsync(this);
    }

    private static void serializeToDiskAsync(LikeActionController object) {
        String string2 = LikeActionController.serializeToJson((LikeActionController)object);
        object = LikeActionController.getCacheKeyForObjectId(((LikeActionController)object).objectId);
        if (!Utility.isNullOrEmpty((String)string2) && !Utility.isNullOrEmpty((String)object)) {
            diskIOWorkQueue.addActiveWorkItem((Runnable)new SerializeToDiskWorkItem((String)object, string2));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void serializeToDiskSynchronously(String object, String string2) {
        Throwable throwable2;
        Object object2;
        block4: {
            Object object3 = null;
            object2 = null;
            object2 = object = controllerDiskCache.openPutStream((String)object);
            object3 = object;
            ((OutputStream)object).write(string2.getBytes());
            if (object == null) return;
            {
                catch (Throwable throwable2) {
                    break block4;
                }
                catch (IOException iOException) {}
                object2 = object3;
                {
                    Log.e((String)TAG, (String)"Unable to serialize controller to disk", (Throwable)iOException);
                    if (object3 == null) return;
                    object = object3;
                }
            }
            Utility.closeQuietly((Closeable)object);
            return;
        }
        if (object2 == null) throw throwable2;
        Utility.closeQuietly((Closeable)object2);
        throw throwable2;
    }

    private static String serializeToJson(LikeActionController likeActionController) {
        JSONObject jSONObject;
        block3: {
            jSONObject = new JSONObject();
            try {
                jSONObject.put(JSON_INT_VERSION_KEY, 3);
                jSONObject.put(JSON_STRING_OBJECT_ID_KEY, (Object)likeActionController.objectId);
                jSONObject.put(JSON_INT_OBJECT_TYPE_KEY, likeActionController.objectType.getValue());
                jSONObject.put(JSON_STRING_LIKE_COUNT_WITH_LIKE_KEY, (Object)likeActionController.likeCountStringWithLike);
                jSONObject.put(JSON_STRING_LIKE_COUNT_WITHOUT_LIKE_KEY, (Object)likeActionController.likeCountStringWithoutLike);
                jSONObject.put(JSON_STRING_SOCIAL_SENTENCE_WITH_LIKE_KEY, (Object)likeActionController.socialSentenceWithLike);
                jSONObject.put(JSON_STRING_SOCIAL_SENTENCE_WITHOUT_LIKE_KEY, (Object)likeActionController.socialSentenceWithoutLike);
                jSONObject.put(JSON_BOOL_IS_OBJECT_LIKED_KEY, likeActionController.isObjectLiked);
                jSONObject.put("unlike_token", (Object)likeActionController.unlikeToken);
                if (likeActionController.facebookDialogAnalyticsBundle == null || (likeActionController = BundleJSONConverter.convertToJSON(likeActionController.facebookDialogAnalyticsBundle)) == null) break block3;
            }
            catch (JSONException jSONException) {
                Log.e((String)TAG, (String)"Unable to serialize controller to JSON", (Throwable)jSONException);
                return null;
            }
            jSONObject.put(JSON_BUNDLE_FACEBOOK_DIALOG_ANALYTICS_BUNDLE, (Object)likeActionController);
        }
        return jSONObject.toString();
    }

    private static void storeObjectIdForPendingController(String string2) {
        objectIdForPendingController = string2;
        FacebookSdk.getApplicationContext().getSharedPreferences(LIKE_ACTION_CONTROLLER_STORE, 0).edit().putString(LIKE_ACTION_CONTROLLER_STORE_PENDING_OBJECT_ID_KEY, objectIdForPendingController).apply();
    }

    private void updateLikeState(boolean bl) {
        this.updateState(bl, this.likeCountStringWithLike, this.likeCountStringWithoutLike, this.socialSentenceWithLike, this.socialSentenceWithoutLike, this.unlikeToken);
    }

    private void updateState(boolean bl, String string2, String string3, String string4, String string5, String string6) {
        string2 = Utility.coerceValueIfNullOrEmpty((String)string2, null);
        string3 = Utility.coerceValueIfNullOrEmpty((String)string3, null);
        string4 = Utility.coerceValueIfNullOrEmpty((String)string4, null);
        string5 = Utility.coerceValueIfNullOrEmpty((String)string5, null);
        string6 = Utility.coerceValueIfNullOrEmpty((String)string6, null);
        boolean bl2 = !(bl == this.isObjectLiked && Utility.areObjectsEqual((Object)string2, (Object)this.likeCountStringWithLike) && Utility.areObjectsEqual((Object)string3, (Object)this.likeCountStringWithoutLike) && Utility.areObjectsEqual((Object)string4, (Object)this.socialSentenceWithLike) && Utility.areObjectsEqual((Object)string5, (Object)this.socialSentenceWithoutLike) && Utility.areObjectsEqual((Object)string6, (Object)this.unlikeToken));
        if (!bl2) {
            return;
        }
        this.isObjectLiked = bl;
        this.likeCountStringWithLike = string2;
        this.likeCountStringWithoutLike = string3;
        this.socialSentenceWithLike = string4;
        this.socialSentenceWithoutLike = string5;
        this.unlikeToken = string6;
        LikeActionController.serializeToDiskAsync(this);
        LikeActionController.broadcastAction(this, ACTION_LIKE_ACTION_CONTROLLER_UPDATED);
    }

    private static void verifyControllerAndInvokeCallback(LikeActionController likeActionController, LikeView.ObjectType object, CreationCallback creationCallback) {
        LikeView.ObjectType objectType = ShareInternalUtility.getMostSpecificObjectType((LikeView.ObjectType)object, (LikeView.ObjectType)likeActionController.objectType);
        if (objectType == null) {
            likeActionController = new FacebookException("Object with id:\"%s\" is already marked as type:\"%s\". Cannot change the type to:\"%s\"", new Object[]{likeActionController.objectId, likeActionController.objectType.toString(), object.toString()});
            object = null;
        } else {
            likeActionController.objectType = objectType;
            objectType = null;
            object = likeActionController;
            likeActionController = objectType;
        }
        LikeActionController.invokeCallbackWithController(creationCallback, (LikeActionController)object, (FacebookException)likeActionController);
    }

    @Deprecated
    public String getLikeCountString() {
        String string2 = this.isObjectLiked ? this.likeCountStringWithLike : this.likeCountStringWithoutLike;
        return string2;
    }

    @Deprecated
    public String getObjectId() {
        return this.objectId;
    }

    @Deprecated
    public String getSocialSentence() {
        String string2 = this.isObjectLiked ? this.socialSentenceWithLike : this.socialSentenceWithoutLike;
        return string2;
    }

    @Deprecated
    public boolean isObjectLiked() {
        return this.isObjectLiked;
    }

    @Deprecated
    public boolean shouldEnableView() {
        return false;
    }

    @Deprecated
    public void toggleLike(Activity activity, FragmentWrapper fragmentWrapper, Bundle bundle) {
        boolean bl = this.isObjectLiked ^ true;
        if (this.canUseOGPublish()) {
            this.updateLikeState(bl);
            if (this.isPendingLikeOrUnlike) {
                this.getAppEventsLogger().logEventImplicitly("fb_like_control_did_undo_quickly", bundle);
            } else if (!this.publishLikeOrUnlikeAsync(bl, bundle)) {
                this.updateLikeState(bl ^ true);
                this.presentLikeDialog(activity, fragmentWrapper, bundle);
            }
        } else {
            this.presentLikeDialog(activity, fragmentWrapper, bundle);
        }
    }

    private abstract class AbstractRequestWrapper
    implements RequestWrapper {
        protected FacebookRequestError error;
        protected String objectId;
        protected LikeView.ObjectType objectType;
        private GraphRequest request;

        protected AbstractRequestWrapper(String string2, LikeView.ObjectType objectType) {
            this.objectId = string2;
            this.objectType = objectType;
        }

        @Override
        public void addToBatch(GraphRequestBatch graphRequestBatch) {
            graphRequestBatch.add(this.request);
        }

        @Override
        public FacebookRequestError getError() {
            return this.error;
        }

        protected void processError(FacebookRequestError facebookRequestError) {
            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error running request for object '%s' with type '%s' : %s", (Object[])new Object[]{this.objectId, this.objectType, facebookRequestError});
        }

        protected abstract void processSuccess(GraphResponse var1);

        protected void setRequest(GraphRequest graphRequest) {
            this.request = graphRequest;
            graphRequest.setVersion(FacebookSdk.getGraphApiVersion());
            graphRequest.setCallback(new GraphRequest.Callback(){

                @Override
                public void onCompleted(GraphResponse object) {
                    AbstractRequestWrapper.this.error = object.getError();
                    if (AbstractRequestWrapper.this.error != null) {
                        object = AbstractRequestWrapper.this;
                        ((AbstractRequestWrapper)object).processError(((AbstractRequestWrapper)object).error);
                    } else {
                        AbstractRequestWrapper.this.processSuccess((GraphResponse)object);
                    }
                }
            });
        }
    }

    private static class CreateLikeActionControllerWorkItem
    implements Runnable {
        private CreationCallback callback;
        private String objectId;
        private LikeView.ObjectType objectType;

        CreateLikeActionControllerWorkItem(String string2, LikeView.ObjectType objectType, CreationCallback creationCallback) {
            this.objectId = string2;
            this.objectType = objectType;
            this.callback = creationCallback;
        }

        @Override
        public void run() {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return;
            }
            try {
                LikeActionController.createControllerForObjectIdAndType(this.objectId, this.objectType, this.callback);
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return;
            }
        }
    }

    @Deprecated
    public static interface CreationCallback {
        public void onComplete(LikeActionController var1, FacebookException var2);
    }

    private class GetEngagementRequestWrapper
    extends AbstractRequestWrapper {
        String likeCountStringWithLike;
        String likeCountStringWithoutLike;
        String socialSentenceStringWithLike;
        String socialSentenceStringWithoutLike;

        GetEngagementRequestWrapper(String string2, LikeView.ObjectType objectType) {
            super(string2, objectType);
            this.likeCountStringWithLike = LikeActionController.this.likeCountStringWithLike;
            this.likeCountStringWithoutLike = LikeActionController.this.likeCountStringWithoutLike;
            this.socialSentenceStringWithLike = LikeActionController.this.socialSentenceWithLike;
            this.socialSentenceStringWithoutLike = LikeActionController.this.socialSentenceWithoutLike;
            LikeActionController.this = new Bundle();
            LikeActionController.this.putString("fields", "engagement.fields(count_string_with_like,count_string_without_like,social_sentence_with_like,social_sentence_without_like)");
            LikeActionController.this.putString("locale", Locale.getDefault().toString());
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), string2, (Bundle)LikeActionController.this, HttpMethod.GET));
        }

        @Override
        protected void processError(FacebookRequestError facebookRequestError) {
            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error fetching engagement for object '%s' with type '%s' : %s", (Object[])new Object[]{this.objectId, this.objectType, facebookRequestError});
            LikeActionController.this.logAppEventForError("get_engagement", facebookRequestError);
        }

        @Override
        protected void processSuccess(GraphResponse graphResponse) {
            if ((graphResponse = Utility.tryGetJSONObjectFromResponse((JSONObject)graphResponse.getJSONObject(), (String)"engagement")) != null) {
                this.likeCountStringWithLike = graphResponse.optString("count_string_with_like", this.likeCountStringWithLike);
                this.likeCountStringWithoutLike = graphResponse.optString("count_string_without_like", this.likeCountStringWithoutLike);
                this.socialSentenceStringWithLike = graphResponse.optString(LikeActionController.JSON_STRING_SOCIAL_SENTENCE_WITH_LIKE_KEY, this.socialSentenceStringWithLike);
                this.socialSentenceStringWithoutLike = graphResponse.optString(LikeActionController.JSON_STRING_SOCIAL_SENTENCE_WITHOUT_LIKE_KEY, this.socialSentenceStringWithoutLike);
            }
        }
    }

    private class GetOGObjectIdRequestWrapper
    extends AbstractRequestWrapper {
        String verifiedObjectId;

        GetOGObjectIdRequestWrapper(String string2, LikeView.ObjectType objectType) {
            super(string2, objectType);
            LikeActionController.this = new Bundle();
            LikeActionController.this.putString("fields", "og_object.fields(id)");
            LikeActionController.this.putString("ids", string2);
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), "", (Bundle)LikeActionController.this, HttpMethod.GET));
        }

        @Override
        protected void processError(FacebookRequestError facebookRequestError) {
            if (facebookRequestError.getErrorMessage().contains("og_object")) {
                this.error = null;
            } else {
                Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error getting the FB id for object '%s' with type '%s' : %s", (Object[])new Object[]{this.objectId, this.objectType, facebookRequestError});
            }
        }

        @Override
        protected void processSuccess(GraphResponse graphResponse) {
            if ((graphResponse = Utility.tryGetJSONObjectFromResponse((JSONObject)graphResponse.getJSONObject(), (String)this.objectId)) != null && (graphResponse = graphResponse.optJSONObject("og_object")) != null) {
                this.verifiedObjectId = graphResponse.optString("id");
            }
        }
    }

    private class GetOGObjectLikesRequestWrapper
    extends AbstractRequestWrapper
    implements LikeRequestWrapper {
        private final String objectId;
        private boolean objectIsLiked;
        private final LikeView.ObjectType objectType;
        private String unlikeToken;

        GetOGObjectLikesRequestWrapper(String string2, LikeView.ObjectType objectType) {
            super(string2, objectType);
            this.objectIsLiked = LikeActionController.this.isObjectLiked;
            this.objectId = string2;
            this.objectType = objectType;
            LikeActionController.this = new Bundle();
            LikeActionController.this.putString("fields", "id,application");
            LikeActionController.this.putString("object", this.objectId);
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), "me/og.likes", (Bundle)LikeActionController.this, HttpMethod.GET));
        }

        @Override
        public String getUnlikeToken() {
            return this.unlikeToken;
        }

        @Override
        public boolean isObjectLiked() {
            return this.objectIsLiked;
        }

        @Override
        protected void processError(FacebookRequestError facebookRequestError) {
            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error fetching like status for object '%s' with type '%s' : %s", (Object[])new Object[]{this.objectId, this.objectType, facebookRequestError});
            LikeActionController.this.logAppEventForError("get_og_object_like", facebookRequestError);
        }

        @Override
        protected void processSuccess(GraphResponse graphResponse) {
            JSONArray jSONArray = Utility.tryGetJSONArrayFromResponse((JSONObject)graphResponse.getJSONObject(), (String)"data");
            if (jSONArray != null) {
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    JSONObject jSONObject = jSONArray.optJSONObject(i2);
                    if (jSONObject == null) continue;
                    this.objectIsLiked = true;
                    JSONObject jSONObject2 = jSONObject.optJSONObject("application");
                    graphResponse = AccessToken.getCurrentAccessToken();
                    if (jSONObject2 == null || !AccessToken.isCurrentAccessTokenActive() || !Utility.areObjectsEqual((Object)graphResponse.getApplicationId(), (Object)jSONObject2.optString("id"))) continue;
                    this.unlikeToken = jSONObject.optString("id");
                }
            }
        }
    }

    private class GetPageIdRequestWrapper
    extends AbstractRequestWrapper {
        boolean objectIsPage;
        String verifiedObjectId;

        GetPageIdRequestWrapper(String string2, LikeView.ObjectType objectType) {
            super(string2, objectType);
            LikeActionController.this = new Bundle();
            LikeActionController.this.putString("fields", "id");
            LikeActionController.this.putString("ids", string2);
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), "", (Bundle)LikeActionController.this, HttpMethod.GET));
        }

        @Override
        protected void processError(FacebookRequestError facebookRequestError) {
            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error getting the FB id for object '%s' with type '%s' : %s", (Object[])new Object[]{this.objectId, this.objectType, facebookRequestError});
        }

        @Override
        protected void processSuccess(GraphResponse graphResponse) {
            if ((graphResponse = Utility.tryGetJSONObjectFromResponse((JSONObject)graphResponse.getJSONObject(), (String)this.objectId)) != null) {
                this.verifiedObjectId = graphResponse.optString("id");
                this.objectIsPage = Utility.isNullOrEmpty((String)this.verifiedObjectId) ^ true;
            }
        }
    }

    private class GetPageLikesRequestWrapper
    extends AbstractRequestWrapper
    implements LikeRequestWrapper {
        private boolean objectIsLiked;
        private String pageId;

        GetPageLikesRequestWrapper(String string2) {
            super(string2, LikeView.ObjectType.PAGE);
            this.objectIsLiked = LikeActionController.this.isObjectLiked;
            this.pageId = string2;
            LikeActionController.this = new Bundle();
            LikeActionController.this.putString("fields", "id");
            AccessToken accessToken = AccessToken.getCurrentAccessToken();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("me/likes/");
            stringBuilder.append(string2);
            this.setRequest(new GraphRequest(accessToken, stringBuilder.toString(), (Bundle)LikeActionController.this, HttpMethod.GET));
        }

        @Override
        public String getUnlikeToken() {
            return null;
        }

        @Override
        public boolean isObjectLiked() {
            return this.objectIsLiked;
        }

        @Override
        protected void processError(FacebookRequestError facebookRequestError) {
            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error fetching like status for page id '%s': %s", (Object[])new Object[]{this.pageId, facebookRequestError});
            LikeActionController.this.logAppEventForError("get_page_like", facebookRequestError);
        }

        @Override
        protected void processSuccess(GraphResponse graphResponse) {
            if ((graphResponse = Utility.tryGetJSONArrayFromResponse((JSONObject)graphResponse.getJSONObject(), (String)"data")) != null && graphResponse.length() > 0) {
                this.objectIsLiked = true;
            }
        }
    }

    private static interface LikeRequestWrapper
    extends RequestWrapper {
        public String getUnlikeToken();

        public boolean isObjectLiked();
    }

    private static class MRUCacheWorkItem
    implements Runnable {
        private static ArrayList<String> mruCachedItems = new ArrayList();
        private String cacheItem;
        private boolean shouldTrim;

        MRUCacheWorkItem(String string2, boolean bl) {
            this.cacheItem = string2;
            this.shouldTrim = bl;
        }

        @Override
        public void run() {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return;
            }
            try {
                if (this.cacheItem != null) {
                    mruCachedItems.remove(this.cacheItem);
                    mruCachedItems.add(0, this.cacheItem);
                }
                if (this.shouldTrim && mruCachedItems.size() >= 128) {
                    while (64 < mruCachedItems.size()) {
                        String string2 = mruCachedItems.remove(mruCachedItems.size() - 1);
                        cache.remove(string2);
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return;
            }
        }
    }

    private class PublishLikeRequestWrapper
    extends AbstractRequestWrapper {
        String unlikeToken;

        PublishLikeRequestWrapper(String string2, LikeView.ObjectType objectType) {
            super(string2, objectType);
            LikeActionController.this = new Bundle();
            LikeActionController.this.putString("object", string2);
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), "me/og.likes", (Bundle)LikeActionController.this, HttpMethod.POST));
        }

        @Override
        protected void processError(FacebookRequestError facebookRequestError) {
            if (facebookRequestError.getErrorCode() == 3501) {
                this.error = null;
            } else {
                Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error liking object '%s' with type '%s' : %s", (Object[])new Object[]{this.objectId, this.objectType, facebookRequestError});
                LikeActionController.this.logAppEventForError("publish_like", facebookRequestError);
            }
        }

        @Override
        protected void processSuccess(GraphResponse graphResponse) {
            this.unlikeToken = Utility.safeGetStringFromResponse((JSONObject)graphResponse.getJSONObject(), (String)"id");
        }
    }

    private class PublishUnlikeRequestWrapper
    extends AbstractRequestWrapper {
        private String unlikeToken;

        PublishUnlikeRequestWrapper(String string2) {
            super(null, null);
            this.unlikeToken = string2;
            this.setRequest(new GraphRequest(AccessToken.getCurrentAccessToken(), string2, null, HttpMethod.DELETE));
        }

        @Override
        protected void processError(FacebookRequestError facebookRequestError) {
            Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (String)TAG, (String)"Error unliking object with unlike token '%s' : %s", (Object[])new Object[]{this.unlikeToken, facebookRequestError});
            LikeActionController.this.logAppEventForError("publish_unlike", facebookRequestError);
        }

        @Override
        protected void processSuccess(GraphResponse graphResponse) {
        }
    }

    private static interface RequestCompletionCallback {
        public void onComplete();
    }

    private static interface RequestWrapper {
        public void addToBatch(GraphRequestBatch var1);

        public FacebookRequestError getError();
    }

    private static class SerializeToDiskWorkItem
    implements Runnable {
        private String cacheKey;
        private String controllerJson;

        SerializeToDiskWorkItem(String string2, String string3) {
            this.cacheKey = string2;
            this.controllerJson = string3;
        }

        @Override
        public void run() {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return;
            }
            try {
                LikeActionController.serializeToDiskSynchronously(this.cacheKey, this.controllerJson);
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return;
            }
        }
    }
}

