/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import com.facebook.share.model.CameraEffectArguments;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CameraEffectJSONUtility {
    private static final Map<Class<?>, Setter> SETTERS = new HashMap();

    static {
        SETTERS.put(String.class, new Setter(){

            @Override
            public void setOnArgumentsBuilder(CameraEffectArguments.Builder builder, String string2, Object object) throws JSONException {
                builder.putArgument(string2, (String)object);
            }

            @Override
            public void setOnJSON(JSONObject jSONObject, String string2, Object object) throws JSONException {
                jSONObject.put(string2, object);
            }
        });
        SETTERS.put(String[].class, new Setter(){

            @Override
            public void setOnArgumentsBuilder(CameraEffectArguments.Builder builder, String string2, Object object) throws JSONException {
                throw new IllegalArgumentException("Unexpected type from JSON");
            }

            @Override
            public void setOnJSON(JSONObject jSONObject, String string2, Object stringArray) throws JSONException {
                JSONArray jSONArray = new JSONArray();
                stringArray = stringArray;
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    jSONArray.put((Object)stringArray[i2]);
                }
                jSONObject.put(string2, (Object)jSONArray);
            }
        });
        SETTERS.put(JSONArray.class, new Setter(){

            @Override
            public void setOnArgumentsBuilder(CameraEffectArguments.Builder object, String string2, Object object2) throws JSONException {
                JSONArray jSONArray = (JSONArray)object2;
                String[] stringArray = new String[jSONArray.length()];
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    object2 = jSONArray.get(i2);
                    if (object2 instanceof String) {
                        stringArray[i2] = (String)object2;
                        continue;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unexpected type in an array: ");
                    ((StringBuilder)object).append(object2.getClass());
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                object.putArgument(string2, stringArray);
            }

            @Override
            public void setOnJSON(JSONObject jSONObject, String string2, Object object) throws JSONException {
                throw new IllegalArgumentException("JSONArray's are not supported in bundles.");
            }
        });
    }

    public static CameraEffectArguments convertToCameraEffectArguments(JSONObject object) throws JSONException {
        if (object == null) {
            return null;
        }
        CameraEffectArguments.Builder builder = new CameraEffectArguments.Builder();
        Iterator iterator2 = object.keys();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator2.next();
            Object object2 = object.get(string2);
            if (object2 == null || object2 == JSONObject.NULL) continue;
            Setter setter = SETTERS.get(object2.getClass());
            if (setter != null) {
                setter.setOnArgumentsBuilder(builder, string2, object2);
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unsupported type: ");
            ((StringBuilder)object).append(object2.getClass());
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        return builder.build();
    }

    public static JSONObject convertToJSON(CameraEffectArguments object) throws JSONException {
        if (object == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        for (String string2 : object.keySet()) {
            Object object2 = object.get(string2);
            if (object2 == null) continue;
            Setter setter = SETTERS.get(object2.getClass());
            if (setter != null) {
                setter.setOnJSON(jSONObject, string2, object2);
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unsupported type: ");
            ((StringBuilder)object).append(object2.getClass());
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        return jSONObject;
    }

    public static interface Setter {
        public void setOnArgumentsBuilder(CameraEffectArguments.Builder var1, String var2, Object var3) throws JSONException;

        public void setOnJSON(JSONObject var1, String var2, Object var3) throws JSONException;
    }
}

