/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.referrals;

import android.app.Activity;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import com.facebook.CallbackManager;
import com.facebook.FacebookActivity;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.referrals.ReferralClient;
import com.facebook.referrals.ReferralLogger;
import com.facebook.referrals.ReferralResult;
import com.facebook.referrals.StartActivityDelegate;
import com.safedk.android.analytics.brandsafety.BrandSafetyUtils;
import com.safedk.android.utils.Logger;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class ReferralManager {
    private static volatile ReferralManager instance;
    private ReferralLogger logger;

    ReferralManager() {
        Validate.sdkInitialized();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ReferralManager getInstance() {
        if (instance != null) return instance;
        synchronized (ReferralManager.class) {
            ReferralManager referralManager;
            if (instance != null) return instance;
            instance = referralManager = new ReferralManager();
            return instance;
        }
    }

    private ReferralLogger getLogger(Context context) {
        if (context == null) {
            context = FacebookSdk.getApplicationContext();
        }
        if (context == null) {
            return null;
        }
        if (this.logger == null) {
            this.logger = new ReferralLogger(context, FacebookSdk.getApplicationId());
        }
        return this.logger;
    }

    private static boolean resolveIntent(Intent intent) {
        PackageManager packageManager = FacebookSdk.getApplicationContext().getPackageManager();
        boolean bl = false;
        if (packageManager.resolveActivity(intent, 0) != null) {
            bl = true;
        }
        return bl;
    }

    public static void safedk_StartActivityDelegate_startActivityForResult_07aa19e1f928cab937344308c91ff854(StartActivityDelegate startActivityDelegate, Intent intent, int n2) {
        Logger.d("SafeDK-Special|SafeDK: Call> Lcom/facebook/referrals/StartActivityDelegate;->startActivityForResult(Landroid/content/Intent;I)V");
        if (intent == null) {
            return;
        }
        BrandSafetyUtils.detectAdClick(intent, "com.facebook");
        startActivityDelegate.startActivityForResult(intent, n2);
    }

    private void startReferralImpl(StartActivityDelegate startActivityDelegate) {
        ReferralLogger referralLogger = this.getLogger((Context)startActivityDelegate.getActivityContext());
        if (referralLogger != null) {
            referralLogger.logStartReferral();
        }
        if (!this.tryFacebookActivity(startActivityDelegate)) {
            startActivityDelegate = new FacebookException("Failed to open Referral dialog: FacebookActivity could not be started. Please make sure you added FacebookActivity to the AndroidManifest.");
            if (referralLogger != null) {
                referralLogger.logError((Exception)startActivityDelegate);
            }
            throw startActivityDelegate;
        }
    }

    private boolean tryFacebookActivity(StartActivityDelegate startActivityDelegate) {
        Intent intent = new Intent();
        intent.setClass(FacebookSdk.getApplicationContext(), FacebookActivity.class);
        intent.setAction("ReferralFragment");
        if (!ReferralManager.resolveIntent(intent)) {
            return false;
        }
        try {
            ReferralManager.safedk_StartActivityDelegate_startActivityForResult_07aa19e1f928cab937344308c91ff854(startActivityDelegate, intent, CallbackManagerImpl.RequestCodeOffset.Referral.toRequestCode());
            return true;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            return false;
        }
    }

    boolean onActivityResult(int n2, Intent object, FacebookCallback<ReferralResult> facebookCallback) {
        Object object2;
        block18: {
            block17: {
                if (n2 == -1 && object != null) {
                    if (object.getExtras() == null || !object.getExtras().containsKey("fb_referral_codes")) break block17;
                    object2 = object.getExtras().getString("fb_referral_codes");
                    object = new JSONArray((String)object2);
                    object = Utility.convertJSONArrayToList((JSONArray)object);
                    object2 = new ReferralResult((List)object);
                    object = null;
                    break block18;
                }
            }
            if (n2 == 0) {
                block19: {
                    if (object != null) {
                        if (object.getExtras() == null || !object.getExtras().containsKey("error_message")) break block19;
                        object = new FacebookException(object.getExtras().getString("error_message"));
                    }
                }
                object2 = object = null;
            } else {
                try {
                    object = new FacebookException("Unexpected call to ReferralManager.onActivityResult");
                }
                catch (JSONException jSONException) {
                    object = new FacebookException("Unable to parse referral codes from response");
                }
                object2 = null;
            }
        }
        ReferralLogger referralLogger = this.getLogger(null);
        if (referralLogger != null) {
            if (object2 != null) {
                referralLogger.logSuccess();
            } else if (object != null) {
                referralLogger.logError((Exception)object);
            } else {
                referralLogger.logCancel();
            }
        }
        if (object2 != null) {
            facebookCallback.onSuccess(object2);
        } else if (object != null) {
            facebookCallback.onError((FacebookException)object);
        } else {
            facebookCallback.onCancel();
        }
        return true;
    }

    public void registerCallback(CallbackManager callbackManager, final FacebookCallback<ReferralResult> facebookCallback) {
        if (callbackManager instanceof CallbackManagerImpl) {
            ((CallbackManagerImpl)callbackManager).registerCallback(ReferralClient.getReferralRequestCode(), new CallbackManagerImpl.Callback(){

                public boolean onActivityResult(int n2, Intent intent) {
                    return ReferralManager.this.onActivityResult(n2, intent, (FacebookCallback<ReferralResult>)facebookCallback);
                }
            });
            return;
        }
        throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
    }

    public void startReferral(Activity activity) {
        this.startReferralImpl(new ActivityStartActivityDelegate(activity));
    }

    public void startReferral(Fragment fragment) {
        this.startReferralImpl(new FragmentStartActivityDelegate(new FragmentWrapper(fragment)));
    }

    public void startReferral(androidx.fragment.app.Fragment fragment) {
        this.startReferralImpl(new FragmentStartActivityDelegate(new FragmentWrapper(fragment)));
    }

    public void startReferral(FragmentWrapper fragmentWrapper) {
        this.startReferralImpl(new FragmentStartActivityDelegate(fragmentWrapper));
    }

    private static class ActivityStartActivityDelegate
    implements StartActivityDelegate {
        private final Activity activity;

        ActivityStartActivityDelegate(Activity activity) {
            Validate.notNull((Object)activity, (String)"activity");
            this.activity = activity;
        }

        public static void safedk_Activity_startActivityForResult_206f42f0b65887e835d87ee52d14d221(Activity activity, Intent intent, int n2) {
            Logger.d("SafeDK-Special|SafeDK: Call> Landroid/app/Activity;->startActivityForResult(Landroid/content/Intent;I)V");
            if (intent == null) {
                return;
            }
            BrandSafetyUtils.detectAdClick(intent, "com.facebook");
            activity.startActivityForResult(intent, n2);
        }

        public Activity getActivityContext() {
            return this.activity;
        }

        public void startActivityForResult(Intent intent, int n2) {
            ActivityStartActivityDelegate.safedk_Activity_startActivityForResult_206f42f0b65887e835d87ee52d14d221(this.activity, intent, n2);
        }
    }

    private static class FragmentStartActivityDelegate
    implements StartActivityDelegate {
        private final FragmentWrapper fragment;

        FragmentStartActivityDelegate(FragmentWrapper fragmentWrapper) {
            Validate.notNull((Object)fragmentWrapper, (String)"fragment");
            this.fragment = fragmentWrapper;
        }

        public static void safedk_FragmentWrapper_startActivityForResult_51accca8f1bb017fcda2a6aac31602e6(FragmentWrapper fragmentWrapper, Intent intent, int n2) {
            Logger.d("SafeDK-Special|SafeDK: Call> Lcom/facebook/internal/FragmentWrapper;->startActivityForResult(Landroid/content/Intent;I)V");
            if (intent == null) {
                return;
            }
            BrandSafetyUtils.detectAdClick(intent, "com.facebook");
            fragmentWrapper.startActivityForResult(intent, n2);
        }

        public Activity getActivityContext() {
            return this.fragment.getActivity();
        }

        public void startActivityForResult(Intent intent, int n2) {
            FragmentStartActivityDelegate.safedk_FragmentWrapper_startActivityForResult_51accca8f1bb017fcda2a6aac31602e6(this.fragment, intent, n2);
        }
    }
}

