/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.fragment.app.DialogFragment;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestAsyncTask;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.common.R;
import com.facebook.devicerequests.internal.DeviceRequestsHelper;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.SmartLoginOption;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.login.DeviceAuthMethodHandler;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginFragment;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceAuthDialog
extends DialogFragment {
    private static final String DEVICE_LOGIN_ENDPOINT = "device/login";
    private static final String DEVICE_LOGIN_STATUS_ENDPOINT = "device/login_status";
    private static final int LOGIN_ERROR_SUBCODE_AUTHORIZATION_DECLINED = 1349173;
    private static final int LOGIN_ERROR_SUBCODE_AUTHORIZATION_PENDING = 1349174;
    private static final int LOGIN_ERROR_SUBCODE_CODE_EXPIRED = 1349152;
    private static final int LOGIN_ERROR_SUBCODE_EXCESSIVE_POLLING = 1349172;
    private static final String REQUEST_STATE_KEY = "request_state";
    private AtomicBoolean completed = new AtomicBoolean();
    private TextView confirmationCode;
    private volatile GraphRequestAsyncTask currentGraphRequestPoll;
    private volatile RequestState currentRequestState;
    private DeviceAuthMethodHandler deviceAuthMethodHandler;
    private TextView instructions;
    private boolean isBeingDestroyed = false;
    private boolean isRetry = false;
    private LoginClient.Request mRequest = null;
    private View progressBar;
    private volatile ScheduledFuture scheduledPoll;

    static /* synthetic */ boolean access$902(DeviceAuthDialog deviceAuthDialog, boolean bl) {
        deviceAuthDialog.isRetry = bl;
        return bl;
    }

    private void completeLogin(String string2, Utility.PermissionsLists permissionsLists, String string3, Date date, Date date2) {
        this.deviceAuthMethodHandler.onSuccess(string3, FacebookSdk.getApplicationId(), string2, (Collection)permissionsLists.getGrantedPermissions(), (Collection)permissionsLists.getDeclinedPermissions(), (Collection)permissionsLists.getExpiredPermissions(), AccessTokenSource.DEVICE_AUTH, date, null, date2);
        this.getDialog().dismiss();
    }

    private GraphRequest getPollRequest() {
        Bundle bundle = new Bundle();
        bundle.putString("code", this.currentRequestState.getRequestCode());
        return new GraphRequest(null, DEVICE_LOGIN_STATUS_ENDPOINT, bundle, HttpMethod.POST, new GraphRequest.Callback(){

            @Override
            public void onCompleted(GraphResponse object) {
                if (DeviceAuthDialog.this.completed.get()) {
                    return;
                }
                FacebookRequestError facebookRequestError = object.getError();
                if (facebookRequestError != null) {
                    int n2 = facebookRequestError.getSubErrorCode();
                    if (n2 != 1349152) {
                        switch (n2) {
                            default: {
                                DeviceAuthDialog.this.onError(object.getError().getException());
                                break;
                            }
                            case 1349173: {
                                DeviceAuthDialog.this.onCancel();
                                break;
                            }
                            case 1349172: 
                            case 1349174: {
                                DeviceAuthDialog.this.schedulePoll();
                                break;
                            }
                        }
                    } else {
                        if (DeviceAuthDialog.this.currentRequestState != null) {
                            DeviceRequestsHelper.cleanUpAdvertisementService((String)DeviceAuthDialog.this.currentRequestState.getUserCode());
                        }
                        if (DeviceAuthDialog.this.mRequest != null) {
                            object = DeviceAuthDialog.this;
                            ((DeviceAuthDialog)((Object)object)).startLogin(((DeviceAuthDialog)((Object)object)).mRequest);
                        } else {
                            DeviceAuthDialog.this.onCancel();
                        }
                    }
                    return;
                }
                try {
                    object = object.getJSONObject();
                    DeviceAuthDialog.this.onSuccess(object.getString("access_token"), object.getLong("expires_in"), object.optLong("data_access_expiration_time"));
                }
                catch (JSONException jSONException) {
                    DeviceAuthDialog.this.onError(new FacebookException((Throwable)jSONException));
                }
            }
        });
    }

    private void onSuccess(final String string2, Long comparable, Long l2) {
        Bundle bundle = new Bundle();
        bundle.putString("fields", "id,permissions,name");
        long l3 = comparable;
        Date date = null;
        comparable = l3 != 0L ? new Date(new Date().getTime() + comparable * 1000L) : null;
        Date date2 = date;
        if (l2 != 0L) {
            date2 = date;
            if (l2 != null) {
                date2 = new Date(l2 * 1000L);
            }
        }
        new GraphRequest(new AccessToken(string2, FacebookSdk.getApplicationId(), "0", null, null, null, null, (Date)comparable, null, date2), "me", bundle, HttpMethod.GET, new GraphRequest.Callback((Date)comparable, date2){
            final /* synthetic */ Date val$dataAccessExpirationTimeDate;
            final /* synthetic */ Date val$expirationTime;
            {
                this.val$expirationTime = date;
                this.val$dataAccessExpirationTimeDate = date2;
            }

            @Override
            public void onCompleted(GraphResponse graphResponse) {
                String string22;
                Object object;
                if (DeviceAuthDialog.this.completed.get()) {
                    return;
                }
                if (graphResponse.getError() != null) {
                    DeviceAuthDialog.this.onError(graphResponse.getError().getException());
                    return;
                }
                try {
                    object = graphResponse.getJSONObject();
                    string22 = object.getString("id");
                    graphResponse = Utility.handlePermissionResponse((JSONObject)object);
                    object = object.getString("name");
                }
                catch (JSONException jSONException) {
                    DeviceAuthDialog.this.onError(new FacebookException((Throwable)jSONException));
                    return;
                }
                DeviceRequestsHelper.cleanUpAdvertisementService((String)DeviceAuthDialog.this.currentRequestState.getUserCode());
                if (FetchedAppSettingsManager.getAppSettingsWithoutQuery((String)FacebookSdk.getApplicationId()).getSmartLoginOptions().contains(SmartLoginOption.RequireConfirm) && !DeviceAuthDialog.this.isRetry) {
                    DeviceAuthDialog.access$902(DeviceAuthDialog.this, true);
                    DeviceAuthDialog.this.presentConfirmation(string22, (Utility.PermissionsLists)graphResponse, string2, (String)object, this.val$expirationTime, this.val$dataAccessExpirationTimeDate);
                    return;
                }
                DeviceAuthDialog.this.completeLogin(string22, (Utility.PermissionsLists)graphResponse, string2, this.val$expirationTime, this.val$dataAccessExpirationTimeDate);
            }
        }).executeAsync();
    }

    private void poll() {
        this.currentRequestState.setLastPoll(new Date().getTime());
        this.currentGraphRequestPoll = this.getPollRequest().executeAsync();
    }

    private void presentConfirmation(final String string2, final Utility.PermissionsLists permissionsLists, final String string3, String string4, final Date date, final Date date2) {
        String string5 = this.getResources().getString(R.string.com_facebook_smart_login_confirmation_title);
        String string6 = this.getResources().getString(R.string.com_facebook_smart_login_confirmation_continue_as);
        String string7 = this.getResources().getString(R.string.com_facebook_smart_login_confirmation_cancel);
        string6 = String.format(string6, string4);
        string4 = new AlertDialog.Builder(this.getContext());
        string4.setMessage((CharSequence)string5).setCancelable(true).setNegativeButton((CharSequence)string6, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                DeviceAuthDialog.this.completeLogin(string2, permissionsLists, string3, date, date2);
            }
        }).setPositiveButton((CharSequence)string7, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface object, int n2) {
                object = DeviceAuthDialog.this.initializeContentView(false);
                DeviceAuthDialog.this.getDialog().setContentView((View)object);
                object = DeviceAuthDialog.this;
                ((DeviceAuthDialog)((Object)object)).startLogin(((DeviceAuthDialog)((Object)object)).mRequest);
            }
        });
        string4.create().show();
    }

    private void schedulePoll() {
        this.scheduledPoll = DeviceAuthMethodHandler.getBackgroundExecutor().schedule(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                    return;
                }
                try {
                    DeviceAuthDialog.this.poll();
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                    return;
                }
            }
        }, this.currentRequestState.getInterval(), TimeUnit.SECONDS);
    }

    private void setCurrentRequestState(RequestState requestState) {
        this.currentRequestState = requestState;
        this.confirmationCode.setText((CharSequence)requestState.getUserCode());
        Bitmap bitmap = DeviceRequestsHelper.generateQRCode((String)requestState.getAuthorizationUri());
        bitmap = new BitmapDrawable(this.getResources(), bitmap);
        this.instructions.setCompoundDrawablesWithIntrinsicBounds(null, (Drawable)bitmap, null, null);
        this.confirmationCode.setVisibility(0);
        this.progressBar.setVisibility(8);
        if (!this.isRetry && DeviceRequestsHelper.startAdvertisementService((String)requestState.getUserCode())) {
            new InternalAppEventsLogger(this.getContext()).logEventImplicitly("fb_smart_login_service");
        }
        if (requestState.withinLastRefreshWindow()) {
            this.schedulePoll();
        } else {
            this.poll();
        }
    }

    protected int getLayoutResId(boolean bl) {
        int n2 = bl ? R.layout.com_facebook_smart_device_dialog_fragment : R.layout.com_facebook_device_auth_dialog_fragment;
        return n2;
    }

    protected View initializeContentView(boolean bl) {
        View view = this.getActivity().getLayoutInflater().inflate(this.getLayoutResId(bl), null);
        this.progressBar = view.findViewById(R.id.progress_bar);
        this.confirmationCode = (TextView)view.findViewById(R.id.confirmation_code);
        ((Button)view.findViewById(R.id.cancel_button)).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                    return;
                }
                try {
                    DeviceAuthDialog.this.onCancel();
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                    return;
                }
            }
        });
        this.instructions = (TextView)view.findViewById(R.id.com_facebook_device_auth_instructions);
        this.instructions.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.com_facebook_device_auth_instructions)));
        return view;
    }

    protected void onBackButtonPressed() {
    }

    protected void onCancel() {
        DeviceAuthMethodHandler deviceAuthMethodHandler;
        if (!this.completed.compareAndSet(false, true)) {
            return;
        }
        if (this.currentRequestState != null) {
            DeviceRequestsHelper.cleanUpAdvertisementService((String)this.currentRequestState.getUserCode());
        }
        if ((deviceAuthMethodHandler = this.deviceAuthMethodHandler) != null) {
            deviceAuthMethodHandler.onCancel();
        }
        this.getDialog().dismiss();
    }

    public Dialog onCreateDialog(Bundle object) {
        object = new Dialog((Context)this.getActivity(), R.style.com_facebook_auth_dialog){

            public void onBackPressed() {
                DeviceAuthDialog.this.onBackButtonPressed();
                super.onBackPressed();
            }
        };
        boolean bl = DeviceRequestsHelper.isAvailable() && !this.isRetry;
        object.setContentView(this.initializeContentView(bl));
        return object;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup object, Bundle bundle) {
        layoutInflater = super.onCreateView(layoutInflater, object, bundle);
        this.deviceAuthMethodHandler = (DeviceAuthMethodHandler)((LoginFragment)((FacebookActivity)this.getActivity()).getCurrentFragment()).getLoginClient().getCurrentHandler();
        if (bundle != null && (object = (RequestState)bundle.getParcelable(REQUEST_STATE_KEY)) != null) {
            this.setCurrentRequestState((RequestState)object);
        }
        return layoutInflater;
    }

    public void onDestroyView() {
        this.isBeingDestroyed = true;
        this.completed.set(true);
        super.onDestroyView();
        if (this.currentGraphRequestPoll != null) {
            this.currentGraphRequestPoll.cancel(true);
        }
        if (this.scheduledPoll != null) {
            this.scheduledPoll.cancel(true);
        }
        this.progressBar = null;
        this.confirmationCode = null;
        this.instructions = null;
    }

    public void onDismiss(DialogInterface dialogInterface) {
        super.onDismiss(dialogInterface);
        if (!this.isBeingDestroyed) {
            this.onCancel();
        }
    }

    protected void onError(FacebookException facebookException) {
        if (!this.completed.compareAndSet(false, true)) {
            return;
        }
        if (this.currentRequestState != null) {
            DeviceRequestsHelper.cleanUpAdvertisementService((String)this.currentRequestState.getUserCode());
        }
        this.deviceAuthMethodHandler.onError((Exception)facebookException);
        this.getDialog().dismiss();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (this.currentRequestState != null) {
            bundle.putParcelable(REQUEST_STATE_KEY, (Parcelable)this.currentRequestState);
        }
    }

    public void startLogin(LoginClient.Request object) {
        this.mRequest = object;
        Bundle bundle = new Bundle();
        bundle.putString("scope", TextUtils.join((CharSequence)",", (Iterable)object.getPermissions()));
        String string2 = object.getDeviceRedirectUriString();
        if (string2 != null) {
            bundle.putString("redirect_uri", string2);
        }
        if ((object = object.getDeviceAuthTargetUserId()) != null) {
            bundle.putString("target_user_id", (String)object);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(Validate.hasAppID());
        ((StringBuilder)object).append("|");
        ((StringBuilder)object).append(Validate.hasClientToken());
        bundle.putString("access_token", ((StringBuilder)object).toString());
        bundle.putString("device_info", DeviceRequestsHelper.getDeviceInfo());
        new GraphRequest(null, DEVICE_LOGIN_ENDPOINT, bundle, HttpMethod.POST, new GraphRequest.Callback(){

            @Override
            public void onCompleted(GraphResponse graphResponse) {
                if (DeviceAuthDialog.this.isBeingDestroyed) {
                    return;
                }
                if (graphResponse.getError() != null) {
                    DeviceAuthDialog.this.onError(graphResponse.getError().getException());
                    return;
                }
                graphResponse = graphResponse.getJSONObject();
                RequestState requestState = new RequestState();
                try {
                    requestState.setUserCode(graphResponse.getString("user_code"));
                    requestState.setRequestCode(graphResponse.getString("code"));
                    requestState.setInterval(graphResponse.getLong("interval"));
                }
                catch (JSONException jSONException) {
                    DeviceAuthDialog.this.onError(new FacebookException((Throwable)jSONException));
                    return;
                }
                DeviceAuthDialog.this.setCurrentRequestState(requestState);
            }
        }).executeAsync();
    }

    private static class RequestState
    implements Parcelable {
        public static final Parcelable.Creator<RequestState> CREATOR = new Parcelable.Creator<RequestState>(){

            public RequestState createFromParcel(Parcel parcel) {
                return new RequestState(parcel);
            }

            public RequestState[] newArray(int n2) {
                return new RequestState[n2];
            }
        };
        private String authorizationUri;
        private long interval;
        private long lastPoll;
        private String requestCode;
        private String userCode;

        RequestState() {
        }

        protected RequestState(Parcel parcel) {
            this.authorizationUri = parcel.readString();
            this.userCode = parcel.readString();
            this.requestCode = parcel.readString();
            this.interval = parcel.readLong();
            this.lastPoll = parcel.readLong();
        }

        public int describeContents() {
            return 0;
        }

        public String getAuthorizationUri() {
            return this.authorizationUri;
        }

        public long getInterval() {
            return this.interval;
        }

        public String getRequestCode() {
            return this.requestCode;
        }

        public String getUserCode() {
            return this.userCode;
        }

        public void setInterval(long l2) {
            this.interval = l2;
        }

        public void setLastPoll(long l2) {
            this.lastPoll = l2;
        }

        public void setRequestCode(String string2) {
            this.requestCode = string2;
        }

        public void setUserCode(String string2) {
            this.userCode = string2;
            this.authorizationUri = String.format(Locale.ENGLISH, "https://facebook.com/device?user_code=%1$s&qr=1", string2);
        }

        public boolean withinLastRefreshWindow() {
            long l2 = this.lastPoll;
            boolean bl = false;
            if (l2 == 0L) {
                return false;
            }
            if (new Date().getTime() - this.lastPoll - this.interval * 1000L < 0L) {
                bl = true;
            }
            return bl;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeString(this.authorizationUri);
            parcel.writeString(this.userCode);
            parcel.writeString(this.requestCode);
            parcel.writeLong(this.interval);
            parcel.writeLong(this.lastPoll);
        }
    }
}

