/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.anrreport;

import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.InstrumentData;
import com.facebook.internal.instrument.InstrumentUtility;
import com.facebook.internal.instrument.anrreport.ANRDetector;
import com.facebook.internal.instrument.anrreport.ANRHandler;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.json.JSONArray;
import org.json.JSONException;

@Metadata(d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/internal/instrument/anrreport/ANRHandler;", "", "()V", "MAX_ANR_REPORT_NUM", "", "enabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "enable", "", "sendANRReports", "facebook-core_release"}, k=1, mv={1, 5, 1})
public final class ANRHandler {
    public static final ANRHandler INSTANCE = new ANRHandler();
    private static final int MAX_ANR_REPORT_NUM = 5;
    private static final AtomicBoolean enabled = new AtomicBoolean(false);

    private ANRHandler() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    public static final void enable() {
        synchronized (ANRHandler.class) {
            block8: {
                boolean bl = CrashShieldHandler.isObjectCrashing(ANRHandler.class);
                if (bl) {
                    return;
                }
                try {
                    bl = enabled.getAndSet(true);
                    if (!bl) break block8;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, ANRHandler.class);
                    return;
                }
                return;
            }
            if (FacebookSdk.getAutoLogAppEventsEnabled()) {
                ANRHandler.sendANRReports();
            }
            ANRDetector.start();
            return;
        }
    }

    @JvmStatic
    public static final void sendANRReports() {
        if (CrashShieldHandler.isObjectCrashing(ANRHandler.class)) {
            return;
        }
        if (Utility.isDataProcessingRestricted()) {
            return;
        }
        Object object = InstrumentUtility.listAnrReportFiles();
        Object object22 = new ArrayList(((File[])object).length);
        object22 = (Collection)object22;
        int n2 = ((File[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object22.add(InstrumentData.Builder.load((File)object[i2]));
            continue;
        }
        try {
            object22 = (List)object22;
            object = new ArrayList();
            object = (Collection)object;
            for (Object object22 : object22) {
                if (!((InstrumentData)object22).isValid()) continue;
                object.add(object22);
            }
            object = CollectionsKt.sortedWith((Iterable)((List)object), (Comparator)sendANRReports.validReports.3.INSTANCE);
            object22 = new JSONArray();
            GraphRequest.Callback callback2 = ((Iterable)RangesKt.until((int)0, (int)Math.min(object.size(), 5))).iterator();
            while (callback2.hasNext()) {
                object22.put(object.get(((IntIterator)callback2).nextInt()));
            }
            callback2 = new GraphRequest.Callback((List)object){
                final /* synthetic */ List $validReports;
                {
                    this.$validReports = list;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void onCompleted(GraphResponse object) {
                    Intrinsics.checkNotNullParameter(object, "response");
                    try {
                        if (object.getError() != null) return;
                        if ((object = object.getJsonObject()) == null) return;
                        if (!object.getBoolean("success")) return;
                        object = ((Iterable)this.$validReports).iterator();
                        while (object.hasNext()) {
                            ((InstrumentData)object.next()).clear();
                        }
                        return;
                    }
                    catch (JSONException jSONException) {
                        return;
                    }
                }
            };
            InstrumentUtility.sendReports((String)"anr_reports", (JSONArray)object22, (GraphRequest.Callback)callback2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ANRHandler.class);
            return;
        }
    }
}

