/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslError;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.facebook.AccessToken;
import com.facebook.FacebookDialogException;
import com.facebook.FacebookException;
import com.facebook.FacebookGraphResponseException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.FacebookServiceException;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.common.R;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.login.LoginTargetApp;
import com.facebook.share.internal.ShareInternalUtility;
import com.safedk.android.analytics.brandsafety.BrandSafetyUtils;
import com.safedk.android.analytics.brandsafety.DetectTouchUtils;
import com.safedk.android.analytics.brandsafety.creatives.CreativeInfoManager;
import com.safedk.android.internal.partials.FacebookNetworkBridge;
import com.safedk.android.utils.Logger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebDialog
extends Dialog {
    private static final int API_EC_DIALOG_CANCEL = 4201;
    private static final int BACKGROUND_GRAY = -872415232;
    private static final int DEFAULT_THEME = R.style.com_facebook_activity_theme;
    static final boolean DISABLE_SSL_CHECK_FOR_TESTING = false;
    private static final String DISPLAY_TOUCH = "touch";
    private static final String LOG_TAG = "FacebookSDK.WebDialog";
    private static final int MAX_PADDING_SCREEN_HEIGHT = 1280;
    private static final int MAX_PADDING_SCREEN_WIDTH = 800;
    private static final double MIN_SCALE_FACTOR = 0.5;
    private static final int NO_PADDING_SCREEN_HEIGHT = 800;
    private static final int NO_PADDING_SCREEN_WIDTH = 480;
    private static final String PLATFORM_DIALOG_PATH_REGEX = "^/(v\\d+\\.\\d+/)??dialog/.*";
    private static InitCallback initCallback;
    private static volatile int webDialogTheme;
    private FrameLayout contentFrameLayout;
    private ImageView crossImageView;
    private String expectedRedirectUrl;
    private boolean isDetached;
    private boolean isPageFinished;
    private boolean listenerCalled;
    private OnCompleteListener onCompleteListener;
    private ProgressDialog spinner;
    private UploadStagingResourcesTask uploadTask;
    private String url;
    private WebView webView;
    private WindowManager.LayoutParams windowParams;

    protected WebDialog(Context context, String string2) {
        this(context, string2, WebDialog.getWebDialogTheme());
    }

    private WebDialog(Context context, String string2, int n2) {
        int n3 = n2;
        if (n2 == 0) {
            n3 = WebDialog.getWebDialogTheme();
        }
        super(context, n3);
        this.expectedRedirectUrl = "fbconnect://success";
        this.listenerCalled = false;
        this.isDetached = false;
        this.isPageFinished = false;
        this.url = string2;
    }

    private WebDialog(Context context, String string2, Bundle bundle, int n2, OnCompleteListener onCompleteListener) {
        this(context, string2, bundle, n2, LoginTargetApp.FACEBOOK, onCompleteListener);
    }

    private WebDialog(Context object, String string2, Bundle object2, int n2, LoginTargetApp loginTargetApp, OnCompleteListener onCompleteListener) {
        int n3 = n2;
        if (n2 == 0) {
            n3 = WebDialog.getWebDialogTheme();
        }
        super(object, n3);
        String string3 = "fbconnect://success";
        this.expectedRedirectUrl = "fbconnect://success";
        this.listenerCalled = false;
        this.isDetached = false;
        this.isPageFinished = false;
        Bundle bundle = object2;
        if (object2 == null) {
            bundle = new Bundle();
        }
        object2 = string3;
        if (Utility.isChromeOS((Context)object)) {
            object2 = "fbconnect://chrome_os_success";
        }
        this.expectedRedirectUrl = object2;
        bundle.putString("redirect_uri", this.expectedRedirectUrl);
        bundle.putString("display", DISPLAY_TOUCH);
        bundle.putString("client_id", FacebookSdk.getApplicationId());
        bundle.putString("sdk", String.format(Locale.ROOT, "android-%s", FacebookSdk.getSdkVersion()));
        this.onCompleteListener = onCompleteListener;
        if (string2.equals("share") && bundle.containsKey("media")) {
            this.uploadTask = new UploadStagingResourcesTask(string2, bundle);
        } else {
            if (5.$SwitchMap$com$facebook$login$LoginTargetApp[loginTargetApp.ordinal()] != 1) {
                object = ServerProtocol.getDialogAuthority();
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(FacebookSdk.getGraphApiVersion());
                ((StringBuilder)object2).append("/");
                ((StringBuilder)object2).append("dialog/");
                ((StringBuilder)object2).append(string2);
                object = Utility.buildUri((String)object, (String)((StringBuilder)object2).toString(), (Bundle)bundle);
            } else {
                object = Utility.buildUri((String)ServerProtocol.getInstagramDialogAuthority(), (String)"oauth/authorize", (Bundle)bundle);
            }
            this.url = object.toString();
        }
    }

    static /* synthetic */ boolean access$702(WebDialog webDialog, boolean bl) {
        webDialog.isPageFinished = bl;
        return bl;
    }

    static /* synthetic */ String access$902(WebDialog webDialog, String string2) {
        webDialog.url = string2;
        return string2;
    }

    private void createCrossImage() {
        this.crossImageView = new ImageView(this.getContext());
        this.crossImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                    return;
                }
                try {
                    WebDialog.this.cancel();
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                    return;
                }
            }
        });
        Drawable drawable2 = this.getContext().getResources().getDrawable(R.drawable.com_facebook_close);
        this.crossImageView.setImageDrawable(drawable2);
        this.crossImageView.setVisibility(4);
    }

    private int getScaledSize(int n2, float f2, int n3, int n4) {
        double d2;
        int n5 = (int)((float)n2 / f2);
        double d3 = 0.5;
        if (n5 <= n3) {
            d3 = 1.0;
        } else if (n5 < n4) {
            d2 = n4 - n5;
            d3 = n4 - n3;
            Double.isNaN(d2);
            Double.isNaN(d3);
            d3 = 0.5 + d2 / d3 * 0.5;
        }
        d2 = n2;
        Double.isNaN(d2);
        return (int)(d2 * d3);
    }

    public static int getWebDialogTheme() {
        Validate.sdkInitialized();
        return webDialogTheme;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void initDefaultTheme(Context context) {
        block4: {
            if (context == null) {
                return;
            }
            try {
                context = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                if (context == null || context.metaData == null || webDialogTheme != 0) break block4;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return;
            }
            WebDialog.setWebDialogTheme(context.metaData.getInt("com.facebook.sdk.WebDialogTheme"));
        }
    }

    public static WebDialog newInstance(Context context, String string2, Bundle bundle, int n2, OnCompleteListener onCompleteListener) {
        WebDialog.initDefaultTheme(context);
        return new WebDialog(context, string2, bundle, n2, LoginTargetApp.FACEBOOK, onCompleteListener);
    }

    public static WebDialog newInstance(Context context, String string2, Bundle bundle, int n2, LoginTargetApp loginTargetApp, OnCompleteListener onCompleteListener) {
        WebDialog.initDefaultTheme(context);
        return new WebDialog(context, string2, bundle, n2, loginTargetApp, onCompleteListener);
    }

    public static void setInitCallback(InitCallback initCallback) {
        WebDialog.initCallback = initCallback;
    }

    private void setUpWebView(int n2) {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        this.webView = new WebView(this.getContext()){

            public boolean dispatchTouchEvent(MotionEvent motionEvent) {
                DetectTouchUtils.webViewOnTouch("com.facebook", this, motionEvent);
                return super.dispatchTouchEvent(motionEvent);
            }

            protected void onMeasure(int n2, int n3) {
                if (!true) {
                    this.setMeasuredDimension(0, 0);
                    return;
                }
                super.onMeasure(n2, n3);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onWindowFocusChanged(boolean bl) {
                try {
                    super.onWindowFocusChanged(bl);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    return;
                }
            }
        };
        InitCallback initCallback = WebDialog.initCallback;
        if (initCallback != null) {
            initCallback.onInit(this.webView);
        }
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setHorizontalScrollBarEnabled(false);
        this.webView.setWebViewClient((WebViewClient)new DialogWebViewClient());
        this.webView.getSettings().setJavaScriptEnabled(true);
        FacebookNetworkBridge.webviewLoadUrl(this.webView, this.url);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.webView.setVisibility(4);
        this.webView.getSettings().setSavePassword(false);
        this.webView.getSettings().setSaveFormData(false);
        this.webView.setFocusable(true);
        this.webView.setFocusableInTouchMode(true);
        this.webView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (!view.hasFocus()) {
                    view.requestFocus();
                }
                return false;
            }
        });
        linearLayout.setPadding(n2, n2, n2, n2);
        linearLayout.addView((View)this.webView);
        linearLayout.setBackgroundColor(-872415232);
        this.contentFrameLayout.addView((View)linearLayout);
    }

    public static void setWebDialogTheme(int n2) {
        if (n2 == 0) {
            n2 = DEFAULT_THEME;
        }
        webDialogTheme = n2;
    }

    public void cancel() {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.sendErrorToListener((Throwable)new FacebookOperationCanceledException());
        }
    }

    public void dismiss() {
        WebView webView = this.webView;
        if (webView != null) {
            webView.stopLoading();
        }
        if (!this.isDetached && (webView = this.spinner) != null && webView.isShowing()) {
            this.spinner.dismiss();
        }
        super.dismiss();
    }

    public OnCompleteListener getOnCompleteListener() {
        return this.onCompleteListener;
    }

    protected WebView getWebView() {
        return this.webView;
    }

    protected boolean isListenerCalled() {
        return this.listenerCalled;
    }

    protected boolean isPageFinished() {
        return this.isPageFinished;
    }

    public void onAttachedToWindow() {
        Object object;
        this.isDetached = false;
        if (Utility.mustFixWindowParamsForAutofill((Context)this.getContext()) && (object = this.windowParams) != null && ((WindowManager.LayoutParams)object).token == null) {
            this.windowParams.token = this.getOwnerActivity().getWindow().getAttributes().token;
            object = new StringBuilder();
            ((StringBuilder)object).append("Set token on onAttachedToWindow(): ");
            ((StringBuilder)object).append(this.windowParams.token);
            Utility.logd((String)LOG_TAG, (String)((StringBuilder)object).toString());
        }
        super.onAttachedToWindow();
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.spinner = new ProgressDialog(this.getContext());
        this.spinner.requestWindowFeature(1);
        this.spinner.setMessage((CharSequence)this.getContext().getString(R.string.com_facebook_loading));
        this.spinner.setCanceledOnTouchOutside(false);
        this.spinner.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                WebDialog.this.cancel();
            }
        });
        this.requestWindowFeature(1);
        this.contentFrameLayout = new FrameLayout(this.getContext());
        this.resize();
        this.getWindow().setGravity(17);
        this.getWindow().setSoftInputMode(16);
        this.createCrossImage();
        if (this.url != null) {
            this.setUpWebView(this.crossImageView.getDrawable().getIntrinsicWidth() / 2 + 1);
        }
        this.contentFrameLayout.addView((View)this.crossImageView, new ViewGroup.LayoutParams(-2, -2));
        this.setContentView((View)this.contentFrameLayout);
    }

    public void onDetachedFromWindow() {
        this.isDetached = true;
        super.onDetachedFromWindow();
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (n2 == 4) {
            WebView webView = this.webView;
            if (webView != null && webView.canGoBack()) {
                this.webView.goBack();
                return true;
            }
            this.cancel();
        }
        return super.onKeyDown(n2, keyEvent);
    }

    protected void onStart() {
        super.onStart();
        UploadStagingResourcesTask uploadStagingResourcesTask = this.uploadTask;
        if (uploadStagingResourcesTask != null && uploadStagingResourcesTask.getStatus() == AsyncTask.Status.PENDING) {
            this.uploadTask.execute(new Void[0]);
            this.spinner.show();
        } else {
            this.resize();
        }
    }

    protected void onStop() {
        UploadStagingResourcesTask uploadStagingResourcesTask = this.uploadTask;
        if (uploadStagingResourcesTask != null) {
            uploadStagingResourcesTask.cancel(true);
            this.spinner.dismiss();
        }
        super.onStop();
    }

    public void onWindowAttributesChanged(WindowManager.LayoutParams layoutParams) {
        if (layoutParams.token == null) {
            this.windowParams = layoutParams;
        }
        super.onWindowAttributesChanged(layoutParams);
    }

    protected Bundle parseResponseUri(String string2) {
        Uri uri = Uri.parse((String)string2);
        string2 = Utility.parseUrlQueryString((String)uri.getQuery());
        string2.putAll(Utility.parseUrlQueryString((String)uri.getFragment()));
        return string2;
    }

    public void resize() {
        Display display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int n2 = displayMetrics.widthPixels < displayMetrics.heightPixels ? displayMetrics.widthPixels : displayMetrics.heightPixels;
        int n3 = displayMetrics.widthPixels < displayMetrics.heightPixels ? displayMetrics.heightPixels : displayMetrics.widthPixels;
        n2 = Math.min(this.getScaledSize(n2, displayMetrics.density, 480, 800), displayMetrics.widthPixels);
        n3 = Math.min(this.getScaledSize(n3, displayMetrics.density, 800, 1280), displayMetrics.heightPixels);
        this.getWindow().setLayout(n2, n3);
    }

    protected void sendErrorToListener(Throwable throwable) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            throwable = throwable instanceof FacebookException ? (FacebookException)throwable : new FacebookException(throwable);
            this.onCompleteListener.onComplete(null, (FacebookException)throwable);
            this.dismiss();
        }
    }

    protected void sendSuccessToListener(Bundle bundle) {
        OnCompleteListener onCompleteListener = this.onCompleteListener;
        if (onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            onCompleteListener.onComplete(bundle, null);
            this.dismiss();
        }
    }

    protected void setExpectedRedirectUrl(String string2) {
        this.expectedRedirectUrl = string2;
    }

    public void setOnCompleteListener(OnCompleteListener onCompleteListener) {
        this.onCompleteListener = onCompleteListener;
    }

    public static class Builder {
        private AccessToken accessToken;
        private String action;
        private String applicationId;
        private Context context;
        private OnCompleteListener listener;
        private Bundle parameters;
        private int theme;

        public Builder(Context context, String string2, Bundle bundle) {
            this.accessToken = AccessToken.getCurrentAccessToken();
            if (!AccessToken.isCurrentAccessTokenActive()) {
                String string3 = Utility.getMetadataApplicationId((Context)context);
                if (string3 != null) {
                    this.applicationId = string3;
                } else {
                    throw new FacebookException("Attempted to create a builder without a valid access token or a valid default Application ID.");
                }
            }
            this.finishInit(context, string2, bundle);
        }

        public Builder(Context context, String string2, String string3, Bundle bundle) {
            String string4 = string2;
            if (string2 == null) {
                string4 = Utility.getMetadataApplicationId((Context)context);
            }
            Validate.notNullOrEmpty((String)string4, (String)"applicationId");
            this.applicationId = string4;
            this.finishInit(context, string3, bundle);
        }

        private void finishInit(Context context, String string2, Bundle bundle) {
            this.context = context;
            this.action = string2;
            this.parameters = bundle != null ? bundle : new Bundle();
        }

        public WebDialog build() {
            AccessToken accessToken = this.accessToken;
            if (accessToken != null) {
                this.parameters.putString("app_id", accessToken.getApplicationId());
                this.parameters.putString("access_token", this.accessToken.getToken());
            } else {
                this.parameters.putString("app_id", this.applicationId);
            }
            return WebDialog.newInstance(this.context, this.action, this.parameters, this.theme, this.listener);
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public Context getContext() {
            return this.context;
        }

        public OnCompleteListener getListener() {
            return this.listener;
        }

        public Bundle getParameters() {
            return this.parameters;
        }

        public int getTheme() {
            return this.theme;
        }

        public Builder setOnCompleteListener(OnCompleteListener onCompleteListener) {
            this.listener = onCompleteListener;
            return this;
        }

        public Builder setTheme(int n2) {
            this.theme = n2;
            return this;
        }
    }

    private class DialogWebViewClient
    extends WebViewClient {
        private DialogWebViewClient() {
        }

        public static void safedk_Context_startActivity_97cb3195734cf5c9cc3418feeafa6dd6(Context context, Intent intent) {
            Logger.d("SafeDK-Special|SafeDK: Call> Landroid/content/Context;->startActivity(Landroid/content/Intent;)V");
            if (intent == null) {
                return;
            }
            BrandSafetyUtils.detectAdClick(intent, "com.facebook");
            context.startActivity(intent);
        }

        public void onLoadResource(WebView webView, String string2) {
            super.onLoadResource(webView, string2);
            CreativeInfoManager.onResourceLoaded("com.facebook", webView, string2);
        }

        public void onPageFinished(WebView webView, String string2) {
            Logger.d("Facebook|SafeDK: Execution> Lcom/facebook/internal/WebDialog$DialogWebViewClient;->onPageFinished(Landroid/webkit/WebView;Ljava/lang/String;)V");
            CreativeInfoManager.onWebViewPageFinished("com.facebook", webView, string2);
            this.safedk_WebDialog$DialogWebViewClient_onPageFinished_400f986d4d48130a97f38c7d4d9ce2a0(webView, string2);
        }

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Webview loading URL: ");
            stringBuilder.append(string2);
            Utility.logd((String)WebDialog.LOG_TAG, (String)stringBuilder.toString());
            super.onPageStarted(webView, string2, bitmap);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.show();
            }
        }

        public void onReceivedError(WebView webView, int n2, String string2, String string3) {
            super.onReceivedError(webView, n2, string2, string3);
            WebDialog.this.sendErrorToListener((Throwable)new FacebookDialogException(string2, n2, string3));
        }

        public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
            sslErrorHandler.cancel();
            WebDialog.this.sendErrorToListener((Throwable)new FacebookDialogException(null, -11, null));
        }

        public void safedk_WebDialog$DialogWebViewClient_onPageFinished_400f986d4d48130a97f38c7d4d9ce2a0(WebView webView, String string2) {
            super.onPageFinished(webView, string2);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.dismiss();
            }
            WebDialog.this.contentFrameLayout.setBackgroundColor(0);
            WebDialog.this.webView.setVisibility(0);
            WebDialog.this.crossImageView.setVisibility(0);
            WebDialog.access$702(WebDialog.this, true);
        }

        public WebResourceResponse shouldInterceptRequest(WebView webView, WebResourceRequest webResourceRequest) {
            return CreativeInfoManager.onWebViewResponseWithHeaders("com.facebook", webView, webResourceRequest, super.shouldInterceptRequest(webView, webResourceRequest));
        }

        public WebResourceResponse shouldInterceptRequest(WebView webView, String string2) {
            return CreativeInfoManager.onWebViewResponse("com.facebook", string2, super.shouldInterceptRequest(webView, string2));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean shouldOverrideUrlLoading(WebView object, String object2) {
            Object object3;
            Bundle bundle;
            int n2;
            block12: {
                block14: {
                    block13: {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Redirect URL: ");
                        ((StringBuilder)object).append((String)object2);
                        Utility.logd((String)WebDialog.LOG_TAG, (String)((StringBuilder)object).toString());
                        object = Uri.parse((String)object2);
                        n2 = object.getPath() != null && Pattern.matches(WebDialog.PLATFORM_DIALOG_PATH_REGEX, object.getPath()) ? 1 : 0;
                        if (!((String)object2).startsWith(WebDialog.this.expectedRedirectUrl)) break block13;
                        bundle = WebDialog.this.parseResponseUri((String)object2);
                        object2 = object = bundle.getString("error");
                        if (object == null) {
                            object2 = bundle.getString("error_type");
                        }
                        object = object3 = bundle.getString("error_msg");
                        if (object3 == null) {
                            object = bundle.getString("error_message");
                        }
                        object3 = object;
                        if (object == null) {
                            object3 = bundle.getString("error_description");
                        }
                        if (Utility.isNullOrEmpty((String)(object = bundle.getString("error_code")))) break block14;
                        try {
                            n2 = Integer.parseInt((String)object);
                            break block12;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (((String)object2).startsWith("fbconnect://cancel")) {
                        WebDialog.this.cancel();
                        return true;
                    }
                    if (n2 != 0) return false;
                    if (((String)object2).contains(WebDialog.DISPLAY_TOUCH)) {
                        return false;
                    }
                    try {
                        Context context = WebDialog.this.getContext();
                        object = new Intent("android.intent.action.VIEW", Uri.parse((String)object2));
                        DialogWebViewClient.safedk_Context_startActivity_97cb3195734cf5c9cc3418feeafa6dd6(context, (Intent)object);
                        return true;
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        return false;
                    }
                }
                n2 = -1;
            }
            if (Utility.isNullOrEmpty((String)object2) && Utility.isNullOrEmpty((String)object3) && n2 == -1) {
                WebDialog.this.sendSuccessToListener(bundle);
                return true;
            }
            if (object2 != null && (((String)object2).equals("access_denied") || ((String)object2).equals("OAuthAccessDeniedException"))) {
                WebDialog.this.cancel();
                return true;
            }
            if (n2 == 4201) {
                WebDialog.this.cancel();
                return true;
            }
            object = new FacebookRequestError(n2, (String)object2, (String)object3);
            WebDialog.this.sendErrorToListener((Throwable)new FacebookServiceException((FacebookRequestError)object, (String)object3));
            return true;
        }
    }

    public static interface InitCallback {
        public void onInit(WebView var1);
    }

    public static interface OnCompleteListener {
        public void onComplete(Bundle var1, FacebookException var2);
    }

    private class UploadStagingResourcesTask
    extends AsyncTask<Void, Void, String[]> {
        private String action;
        private Exception[] exceptions;
        private Bundle parameters;

        UploadStagingResourcesTask(String string2, Bundle bundle) {
            this.action = string2;
            this.parameters = bundle;
        }

        protected String[] doInBackground(Void ... object) {
            if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
                return null;
            }
            String[] stringArray = this.parameters.getStringArray("media");
            Object object2 = new String[stringArray.length];
            this.exceptions = new Exception[stringArray.length];
            CountDownLatch countDownLatch = new CountDownLatch(stringArray.length);
            object = new ConcurrentLinkedQueue();
            AccessToken accessToken = AccessToken.getCurrentAccessToken();
            int n2 = 0;
            while (true) {
                block13: {
                    if (n2 >= stringArray.length) break;
                    if (!this.isCancelled()) break block13;
                    object2 = ((ConcurrentLinkedQueue)object).iterator();
                    while (object2.hasNext()) {
                        ((AsyncTask)object2.next()).cancel(true);
                    }
                    return null;
                }
                Uri uri = Uri.parse((String)stringArray[n2]);
                if (Utility.isWebUri((Uri)uri)) {
                    object2[n2] = uri.toString();
                    countDownLatch.countDown();
                } else {
                    GraphRequest.Callback callback2 = new GraphRequest.Callback((String[])object2, n2, countDownLatch){
                        final /* synthetic */ CountDownLatch val$latch;
                        final /* synthetic */ String[] val$results;
                        final /* synthetic */ int val$writeIndex;
                        {
                            this.val$results = stringArray;
                            this.val$writeIndex = n2;
                            this.val$latch = countDownLatch;
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void onCompleted(GraphResponse object) {
                            try {
                                FacebookRequestError facebookRequestError = object.getError();
                                if (facebookRequestError != null) {
                                    void var2_10;
                                    String string2;
                                    String string3 = string2 = facebookRequestError.getErrorMessage();
                                    if (string2 == null) {
                                        String string4 = "Error staging photo.";
                                    }
                                    string2 = new FacebookGraphResponseException(object, (String)var2_10);
                                    throw string2;
                                }
                                JSONObject jSONObject = object.getJSONObject();
                                if (jSONObject == null) {
                                    FacebookException facebookException = new FacebookException("Error staging photo.");
                                    throw facebookException;
                                }
                                String string5 = jSONObject.optString("uri");
                                if (string5 == null) {
                                    FacebookException facebookException = new FacebookException("Error staging photo.");
                                    throw facebookException;
                                }
                                this.val$results[this.val$writeIndex] = string5;
                            }
                            catch (Exception exception) {
                                ((UploadStagingResourcesTask)UploadStagingResourcesTask.this).exceptions[this.val$writeIndex] = exception;
                            }
                            this.val$latch.countDown();
                        }
                    };
                    ((ConcurrentLinkedQueue)object).add(ShareInternalUtility.newUploadStagingResourceWithImageRequest((AccessToken)accessToken, (Uri)uri, (GraphRequest.Callback)callback2).executeAsync());
                }
                ++n2;
                continue;
                break;
            }
            try {
                countDownLatch.await();
                return object2;
            }
            catch (Exception exception) {
                try {
                    object = ((ConcurrentLinkedQueue)object).iterator();
                    while (object.hasNext()) {
                        ((AsyncTask)object.next()).cancel(true);
                    }
                    return null;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
                    return null;
                }
            }
        }

        /*
         * WARNING - combined exceptions agressively - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void onPostExecute(String[] object) {
            if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
                return;
            }
            try {
                Object object2;
                List list2;
                WebDialog.this.spinner.dismiss();
                for (List list2 : this.exceptions) {
                    if (list2 == null) continue;
                    WebDialog.this.sendErrorToListener((Throwable)((Object)list2));
                    return;
                }
                if (object == null) {
                    object = WebDialog.this;
                    object2 = new FacebookException("Failed to stage photos for web dialog");
                    ((WebDialog)((Object)object)).sendErrorToListener((Throwable)object2);
                    return;
                }
                list2 = Arrays.asList(object);
                if (list2.contains(null)) {
                    object2 = WebDialog.this;
                    object = new FacebookException("Failed to stage photos for web dialog");
                    ((WebDialog)((Object)object2)).sendErrorToListener((Throwable)object);
                    return;
                }
                object2 = this.parameters;
                object = new JSONArray((Collection)list2);
                Utility.putJSONValueInBundle((Bundle)object2, (String)"media", (Object)object);
                object = ServerProtocol.getDialogAuthority();
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(FacebookSdk.getGraphApiVersion());
                ((StringBuilder)object2).append("/");
                ((StringBuilder)object2).append("dialog/");
                ((StringBuilder)object2).append(this.action);
                object = Utility.buildUri((String)object, (String)((StringBuilder)object2).toString(), (Bundle)this.parameters);
                WebDialog.access$902(WebDialog.this, object.toString());
                int n2 = WebDialog.this.crossImageView.getDrawable().getIntrinsicWidth();
                WebDialog.this.setUpWebView(n2 / 2 + 1);
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
                return;
            }
        }
    }
}

