/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.net.Uri;
import com.facebook.LoggingBehavior;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.safedk.android.internal.partials.FacebookNetworkBridge;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\bH\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/internal/ImageResponseCache;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "imageCache", "Lcom/facebook/internal/FileLruCache;", "clearCache", "", "getCache", "getCachedImageStream", "Ljava/io/InputStream;", "uri", "Landroid/net/Uri;", "interceptAndCacheImageStream", "connection", "Ljava/net/HttpURLConnection;", "isCDNURL", "", "BufferedHttpInputStream", "facebook-core_release"}, k=1, mv={1, 5, 1})
public final class ImageResponseCache {
    public static final ImageResponseCache INSTANCE = new ImageResponseCache();
    private static final String TAG;
    private static FileLruCache imageCache;

    static {
        String string2 = ImageResponseCache.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "ImageResponseCache::class.java.simpleName");
        TAG = string2;
    }

    private ImageResponseCache() {
    }

    @JvmStatic
    public static final void clearCache() {
        try {
            ImageResponseCache.getCache().clearCache();
        }
        catch (IOException iOException) {
            Logger.Companion companion = Logger.Companion;
            LoggingBehavior loggingBehavior = LoggingBehavior.CACHE;
            String string2 = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("clearCache failed ");
            stringBuilder.append(iOException.getMessage());
            companion.log(loggingBehavior, 5, string2, stringBuilder.toString());
        }
    }

    @JvmStatic
    public static final FileLruCache getCache() throws IOException {
        synchronized (ImageResponseCache.class) {
            Object object;
            block5: {
                if (imageCache == null) {
                    FileLruCache fileLruCache;
                    String string2 = TAG;
                    object = new FileLruCache.Limits();
                    imageCache = fileLruCache = new FileLruCache(string2, (FileLruCache.Limits)object);
                }
                if ((object = imageCache) == null) break block5;
                return object;
            }
            object = new IllegalStateException("Required value was null.".toString());
            throw (Throwable)object;
        }
    }

    @JvmStatic
    public static final InputStream getCachedImageStream(Uri object) {
        InputStream inputStream = null;
        Object object2 = inputStream;
        if (object != null) {
            object2 = inputStream;
            if (INSTANCE.isCDNURL((Uri)object)) {
                try {
                    object2 = ImageResponseCache.getCache();
                    object = object.toString();
                    Intrinsics.checkNotNullExpressionValue(object, "uri.toString()");
                    object2 = FileLruCache.get$default((FileLruCache)object2, (String)object, null, 2, null);
                }
                catch (IOException iOException) {
                    Logger.Companion.log(LoggingBehavior.CACHE, 5, TAG, iOException.toString());
                    object2 = inputStream;
                }
            }
        }
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final InputStream interceptAndCacheImageStream(HttpURLConnection object) throws IOException {
        Intrinsics.checkNotNullParameter(object, "connection");
        Object object2 = null;
        if (FacebookNetworkBridge.httpUrlConnectionGetResponseCode((HttpURLConnection)object) != 200) return object2;
        Uri uri = Uri.parse((String)((URLConnection)object).getURL().toString());
        object2 = FacebookNetworkBridge.urlConnectionGetInputStream((URLConnection)object);
        try {
            if (!INSTANCE.isCDNURL(uri)) return object2;
            FileLruCache fileLruCache = ImageResponseCache.getCache();
            String string2 = uri.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "uri.toString()");
            BufferedHttpInputStream bufferedHttpInputStream = new BufferedHttpInputStream((InputStream)object2, (HttpURLConnection)object);
            object = fileLruCache.interceptAndPut(string2, bufferedHttpInputStream);
            return object;
        }
        catch (IOException iOException) {
            return object2;
        }
    }

    private final boolean isCDNURL(Uri object) {
        if (object != null) {
            if ((object = object.getHost()) != null && StringsKt.endsWith$default((String)object, (String)"fbcdn.net", (boolean)false, (int)2, null)) {
                return true;
            }
            if (object != null && StringsKt.startsWith$default((String)object, (String)"fbcdn", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)object, (String)"akamaihd.net", (boolean)false, (int)2, null)) {
                return true;
            }
        }
        return false;
    }

    public final String getTAG() {
        return TAG;
    }

    @Metadata(d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/facebook/internal/ImageResponseCache$BufferedHttpInputStream;", "Ljava/io/BufferedInputStream;", "stream", "Ljava/io/InputStream;", "connection", "Ljava/net/HttpURLConnection;", "(Ljava/io/InputStream;Ljava/net/HttpURLConnection;)V", "getConnection", "()Ljava/net/HttpURLConnection;", "setConnection", "(Ljava/net/HttpURLConnection;)V", "close", "", "facebook-core_release"}, k=1, mv={1, 5, 1})
    private static final class BufferedHttpInputStream
    extends BufferedInputStream {
        private HttpURLConnection connection;

        public BufferedHttpInputStream(InputStream inputStream, HttpURLConnection httpURLConnection) {
            Intrinsics.checkNotNullParameter(httpURLConnection, "connection");
            super(inputStream, 8192);
            this.connection = httpURLConnection;
        }

        @Override
        public void close() throws IOException {
            super.close();
            Utility.disconnectQuietly((URLConnection)this.connection);
        }

        public final HttpURLConnection getConnection() {
            return this.connection;
        }

        public final void setConnection(HttpURLConnection httpURLConnection) {
            Intrinsics.checkNotNullParameter(httpURLConnection, "<set-?>");
            this.connection = httpURLConnection;
        }
    }
}

