/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import com.facebook.FacebookSdk;
import com.facebook.LoggingBehavior;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.safedk.android.internal.partials.FacebookFilesBridge;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.util.Date;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@Metadata(d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u0000 )2\u00020\u0001:\b'()*+,-.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0017J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00032\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0087\u0002J\u0016\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0019J\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00032\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0007J\b\u0010 \u001a\u00020\u0017H\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u0017H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/facebook/internal/FileLruCache;", "", "tag", "", "limits", "Lcom/facebook/internal/FileLruCache$Limits;", "(Ljava/lang/String;Lcom/facebook/internal/FileLruCache$Limits;)V", "condition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "directory", "Ljava/io/File;", "isTrimInProgress", "", "isTrimPending", "lastClearCacheTime", "Ljava/util/concurrent/atomic/AtomicLong;", "location", "getLocation", "()Ljava/lang/String;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "clearCache", "", "get", "Ljava/io/InputStream;", "key", "contentTag", "interceptAndPut", "input", "openPutStream", "Ljava/io/OutputStream;", "postTrim", "renameToTargetAndTrim", "buffer", "sizeInBytesForTest", "", "toString", "trim", "BufferFile", "CloseCallbackOutputStream", "Companion", "CopyingInputStream", "Limits", "ModifiedFile", "StreamCloseCallback", "StreamHeader", "facebook-core_release"}, k=1, mv={1, 5, 1})
public final class FileLruCache {
    public static final Companion Companion = new Companion(null);
    private static final String HEADER_CACHEKEY_KEY = "key";
    private static final String HEADER_CACHE_CONTENT_TAG_KEY = "tag";
    private static final String TAG;
    private static final AtomicLong bufferIndex;
    private final Condition condition;
    private final File directory;
    private boolean isTrimInProgress;
    private boolean isTrimPending;
    private final AtomicLong lastClearCacheTime;
    private final Limits limits;
    private final ReentrantLock lock;
    private final String tag;

    static {
        String string2 = FileLruCache.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "FileLruCache::class.java.simpleName");
        TAG = string2;
        bufferIndex = new AtomicLong();
    }

    public FileLruCache(String string2, Limits limits) {
        Intrinsics.checkNotNullParameter(string2, HEADER_CACHE_CONTENT_TAG_KEY);
        Intrinsics.checkNotNullParameter(limits, "limits");
        this.tag = string2;
        this.limits = limits;
        this.directory = new File(FacebookSdk.getCacheDir(), this.tag);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.lastClearCacheTime = new AtomicLong(0L);
        if (this.directory.mkdirs() || this.directory.isDirectory()) {
            BufferFile.INSTANCE.deleteAll(this.directory);
        }
    }

    public static final /* synthetic */ AtomicLong access$getLastClearCacheTime$p(FileLruCache fileLruCache) {
        return fileLruCache.lastClearCacheTime;
    }

    public static final /* synthetic */ void access$renameToTargetAndTrim(FileLruCache fileLruCache, String string2, File file) {
        fileLruCache.renameToTargetAndTrim(string2, file);
    }

    public static final /* synthetic */ void access$trim(FileLruCache fileLruCache) {
        fileLruCache.trim();
    }

    public static /* synthetic */ InputStream get$default(FileLruCache fileLruCache, String string2, String string3, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            string3 = null;
        }
        return fileLruCache.get(string2, string3);
    }

    public static /* synthetic */ OutputStream openPutStream$default(FileLruCache fileLruCache, String string2, String string3, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            string3 = null;
        }
        return fileLruCache.openPutStream(string2, string3);
    }

    private final void postTrim() {
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object;
            if (!this.isTrimPending) {
                this.isTrimPending = true;
                object = FacebookSdk.getExecutor();
                Runnable runnable2 = new Runnable(this){
                    final /* synthetic */ FileLruCache this$0;
                    {
                        this.this$0 = fileLruCache;
                    }

                    /*
                     * Loose catch block
                     */
                    public final void run() {
                        block6: {
                            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                                return;
                            }
                            boolean bl = CrashShieldHandler.isObjectCrashing((Object)this);
                            if (!bl) break block6;
                            return;
                            {
                                catch (Throwable throwable) {
                                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                                    return;
                                }
                            }
                        }
                        try {
                            FileLruCache.access$trim(this.this$0);
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                            return;
                        }
                    }
                };
                object.execute(runnable2);
            }
            object = Unit.INSTANCE;
            return;
        }
        finally {
            lock.unlock();
        }
    }

    private final void renameToTargetAndTrim(String string2, File file) {
        if (!file.renameTo(new File(this.directory, Utility.md5hash((String)string2)))) {
            file.delete();
        }
        this.postTrim();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void trim() {
        block19: {
            block18: {
                var1_1 = this.lock;
                var1_1.lock();
                this.isTrimPending = false;
                this.isTrimInProgress = true;
                var2_2 /* !! */  = Unit.INSTANCE;
                var1_1.unlock();
                Logger.Companion.log(LoggingBehavior.CACHE, FileLruCache.TAG, "trim started");
                var1_1 = new PriorityQueue();
                var2_2 /* !! */  = this.directory.listFiles(BufferFile.INSTANCE.excludeBufferFiles());
                var3_6 = 0L;
                if (var2_2 /* !! */  == null) break block18;
                try {
                    var5_7 = ((Unit)var2_2 /* !! */ ).length;
                    var3_6 = var6_8 = 0L;
                }
lbl46:
                // 6 sources

                catch (Throwable var10_12) {
                    var1_1 = this.lock;
                    var1_1.lock();
                    try {
                        this.isTrimInProgress = false;
                        this.condition.signalAll();
                        var2_2 /* !! */  = Unit.INSTANCE;
                        throw var10_12;
                    }
                    finally {
                        var1_1.unlock();
                    }
                }
                for (var8_9 = 0; var8_9 < var5_7; ++var8_9) {
                    var9_10 = var2_2 /* !! */ [var8_9];
                    Intrinsics.checkNotNullExpressionValue(var9_10, "file");
                    var10_11 = new ModifiedFile((File)var9_10);
                    var1_1.add(var10_11);
                    var11_13 = Logger.Companion;
                    var12_14 = LoggingBehavior.CACHE;
                    var13_15 = FileLruCache.TAG;
                    var14_16 = new StringBuilder();
                    var14_16.append("  trim considering time=");
                    var14_16.append((Object)var10_11.getModified());
                    var14_16.append(" name=");
                    var14_16.append(var10_11.getFile().getName());
                    var11_13.log((LoggingBehavior)var12_14, var13_15, var14_16.toString());
                    var3_6 += var9_10.length();
                    ++var6_8;
                    continue;
                }
                break block19;
            }
            var6_8 = 0L;
        }
        while (true) {
            ** try [egrp 4[TRYBLOCK] [4 : 241->263)] { 
            break;
        }
lbl-1000:
        // 1 sources

        {
            if (var3_6 <= (long)this.limits.getByteCount() && var6_8 <= (long)(var8_9 = this.limits.getFileCount())) {
                var1_1 = this.lock;
                var1_1.lock();
                try {
                    this.isTrimInProgress = false;
                    this.condition.signalAll();
                    var2_2 /* !! */  = Unit.INSTANCE;
                    return;
                }
                finally {
                    var1_1.unlock();
                }
            }
            var11_13 = ((ModifiedFile)var1_1.remove()).getFile();
            var12_14 = Logger.Companion;
            var10_11 = LoggingBehavior.CACHE;
            var2_2 /* !! */  = FileLruCache.TAG;
            var9_10 = new StringBuilder();
            var9_10.append("  trim removing ");
            var9_10.append(var11_13.getName());
            var12_14.log((LoggingBehavior)var10_11, (String)var2_2 /* !! */ , var9_10.toString());
            var3_6 -= var11_13.length();
            --var6_8;
            var11_13.delete();
            continue;
        }
        catch (Throwable var2_5) {
            var1_1.unlock();
            throw var2_5;
        }
    }

    public final void clearCache() {
        File[] fileArray = this.directory.listFiles(BufferFile.INSTANCE.excludeBufferFiles());
        this.lastClearCacheTime.set(System.currentTimeMillis());
        if (fileArray != null) {
            FacebookSdk.getExecutor().execute(new Runnable(fileArray){
                final /* synthetic */ File[] $filesToDelete;
                {
                    this.$filesToDelete = fileArray;
                }

                public final void run() {
                    int n2;
                    File[] fileArray;
                    block8: {
                        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                            return;
                        }
                        boolean bl = CrashShieldHandler.isObjectCrashing((Object)this);
                        if (!bl) break block8;
                        return;
                    }
                    try {
                        fileArray = this.$filesToDelete;
                        n2 = fileArray.length;
                    }
                    catch (Throwable throwable) {
                        try {
                            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                            return;
                        }
                        catch (Throwable throwable2) {
                            CrashShieldHandler.handleThrowable((Throwable)throwable2, (Object)this);
                            return;
                        }
                    }
                    for (int i2 = 0; i2 < n2; ++i2) {
                        fileArray[i2].delete();
                        continue;
                    }
                    return;
                }
            });
        }
    }

    public final InputStream get(String string2) throws IOException {
        return FileLruCache.get$default(this, string2, null, 2, null);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public final InputStream get(String object, String string2) throws IOException {
        void var1_4;
        boolean bl;
        InputStream inputStream;
        block14: {
            block11: {
                Object object2;
                File file;
                block13: {
                    boolean bl2;
                    block12: {
                        Intrinsics.checkNotNullParameter(object, HEADER_CACHEKEY_KEY);
                        file = new File(this.directory, Utility.md5hash((String)object));
                        try {
                            inputStream = new FileInputStream(file);
                            inputStream = new BufferedInputStream(inputStream, 8192);
                            bl = false;
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                        object2 = StreamHeader.INSTANCE.readHeader(inputStream);
                        if (object2 == null) break block11;
                        bl2 = Intrinsics.areEqual(object2.optString(HEADER_CACHEKEY_KEY), object);
                        if (!(bl2 ^ true)) break block12;
                        ((BufferedInputStream)inputStream).close();
                        return null;
                    }
                    object = object2.optString(HEADER_CACHE_CONTENT_TAG_KEY, null);
                    if (string2 != null) break block13;
                    bl2 = Intrinsics.areEqual(string2, object);
                    if (!(bl2 ^ true)) break block13;
                    ((BufferedInputStream)inputStream).close();
                    return null;
                }
                object = new Date();
                long l2 = ((Date)object).getTime();
                Logger.Companion companion = Logger.Companion;
                string2 = LoggingBehavior.CACHE;
                object = TAG;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Setting lastModified to ");
                ((StringBuilder)object2).append((Object)l2);
                ((StringBuilder)object2).append(" for ");
                ((StringBuilder)object2).append(file.getName());
                companion.log((LoggingBehavior)string2, (String)object, ((StringBuilder)object2).toString());
                file.setLastModified(l2);
                try {
                    object = inputStream;
                    return object;
                }
                catch (Throwable throwable) {
                    bl = true;
                }
                break block14;
            }
            ((BufferedInputStream)inputStream).close();
            return null;
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!bl) {
            ((BufferedInputStream)inputStream).close();
        }
        throw var1_4;
    }

    public final String getLocation() {
        String string2 = this.directory.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "directory.path");
        return string2;
    }

    public final InputStream interceptAndPut(String string2, InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter(string2, HEADER_CACHEKEY_KEY);
        Intrinsics.checkNotNullParameter(inputStream, "input");
        return new CopyingInputStream(inputStream, FileLruCache.openPutStream$default(this, string2, null, 2, null));
    }

    public final OutputStream openPutStream(String string2) throws IOException {
        return FileLruCache.openPutStream$default(this, string2, null, 2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final OutputStream openPutStream(String object, String object2) throws IOException {
        boolean bl;
        FileOutputStream fileOutputStream;
        Intrinsics.checkNotNullParameter(object, HEADER_CACHEKEY_KEY);
        Object object3 = BufferFile.INSTANCE.newFile(this.directory);
        ((File)object3).delete();
        if (!((File)object3).createNewFile()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Could not create file at ");
            ((StringBuilder)object).append(((File)object3).getAbsolutePath());
            throw (Throwable)new IOException(((StringBuilder)object).toString());
        }
        try {
            fileOutputStream = FacebookFilesBridge.fileOutputStreamCtor((File)object3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            object2 = Logger.Companion;
            LoggingBehavior loggingBehavior = LoggingBehavior.CACHE;
            object3 = TAG;
            object = new StringBuilder();
            ((StringBuilder)object).append("Error creating buffer output stream: ");
            ((StringBuilder)object).append(fileNotFoundException);
            object2.log(loggingBehavior, 5, (String)object3, ((StringBuilder)object).toString());
            throw (Throwable)new IOException(fileNotFoundException.getMessage());
        }
        object3 = new StreamCloseCallback(this, System.currentTimeMillis(), (File)object3, (String)object){
            final /* synthetic */ File $buffer;
            final /* synthetic */ long $bufferFileCreateTime;
            final /* synthetic */ String $key;
            final /* synthetic */ FileLruCache this$0;
            {
                this.this$0 = fileLruCache;
                this.$bufferFileCreateTime = l2;
                this.$buffer = file;
                this.$key = string2;
            }

            public void onClose() {
                if (this.$bufferFileCreateTime < FileLruCache.access$getLastClearCacheTime$p(this.this$0).get()) {
                    this.$buffer.delete();
                } else {
                    FileLruCache.access$renameToTargetAndTrim(this.this$0, this.$key, this.$buffer);
                }
            }
        };
        object3 = new BufferedOutputStream(new CloseCallbackOutputStream(fileOutputStream, (StreamCloseCallback)object3), 8192);
        boolean bl2 = false;
        boolean bl3 = bl = false;
        boolean bl4 = bl2;
        try {
            try {
                bl3 = bl;
                bl4 = bl2;
                fileOutputStream = new JSONObject();
                bl3 = bl;
                bl4 = bl2;
                fileOutputStream.put(HEADER_CACHEKEY_KEY, object);
                bl3 = bl;
                bl4 = bl2;
                if (!Utility.isNullOrEmpty((String)object2)) {
                    bl3 = bl;
                    bl4 = bl2;
                    fileOutputStream.put(HEADER_CACHE_CONTENT_TAG_KEY, object2);
                }
                bl3 = bl;
                bl4 = bl2;
                StreamHeader.INSTANCE.writeHeader((OutputStream)object3, (JSONObject)fileOutputStream);
                bl4 = true;
                bl3 = true;
                return (OutputStream)object3;
            }
            catch (JSONException jSONException) {
                bl3 = bl4;
                Logger.Companion companion = Logger.Companion;
                bl3 = bl4;
                fileOutputStream = LoggingBehavior.CACHE;
                bl3 = bl4;
                String string2 = TAG;
                bl3 = bl4;
                bl3 = bl4;
                object2 = new StringBuilder();
                bl3 = bl4;
                ((StringBuilder)object2).append("Error creating JSON header for cache file: ");
                bl3 = bl4;
                ((StringBuilder)object2).append((Object)jSONException);
                bl3 = bl4;
                companion.log((LoggingBehavior)fileOutputStream, 5, string2, ((StringBuilder)object2).toString());
                bl3 = bl4;
                bl3 = bl4;
                object2 = new IOException(jSONException.getMessage());
                bl3 = bl4;
                throw (Throwable)object2;
            }
        }
        catch (Throwable throwable) {}
        if (bl3) throw throwable;
        ((FilterOutputStream)object3).close();
        throw throwable;
    }

    public final long sizeInBytesForTest() {
        File[] fileArray = (File[])this.lock;
        fileArray.lock();
        while (true) {
            block6: {
                long l2;
                block7: {
                    long l3;
                    if (this.isTrimPending || this.isTrimInProgress) break block6;
                    Unit unit = Unit.INSTANCE;
                    fileArray.unlock();
                    fileArray = this.directory.listFiles();
                    l2 = l3 = 0L;
                    if (fileArray == null) break block7;
                    int n2 = fileArray.length;
                    int n3 = 0;
                    while (true) {
                        l2 = l3;
                        if (n3 >= n2) break;
                        l3 += fileArray[n3].length();
                        ++n3;
                    }
                }
                return l2;
            }
            try {
                this.condition.await();
                continue;
            }
            catch (Throwable throwable) {
                fileArray.unlock();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{FileLruCache: tag:");
        stringBuilder.append(this.tag);
        stringBuilder.append(" file:");
        stringBuilder.append(this.directory.getName());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Metadata(d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/internal/FileLruCache$BufferFile;", "", "()V", "FILE_NAME_PREFIX", "", "filterExcludeBufferFiles", "Ljava/io/FilenameFilter;", "filterExcludeNonBufferFiles", "deleteAll", "", "root", "Ljava/io/File;", "excludeBufferFiles", "excludeNonBufferFiles", "newFile", "facebook-core_release"}, k=1, mv={1, 5, 1})
    private static final class BufferFile {
        private static final String FILE_NAME_PREFIX = "buffer";
        public static final BufferFile INSTANCE = new BufferFile();
        private static final FilenameFilter filterExcludeBufferFiles = filterExcludeBufferFiles.1.INSTANCE;
        private static final FilenameFilter filterExcludeNonBufferFiles = filterExcludeNonBufferFiles.1.INSTANCE;

        private BufferFile() {
        }

        public final void deleteAll(File fileArray) {
            Intrinsics.checkNotNullParameter(fileArray, "root");
            fileArray = fileArray.listFiles(this.excludeNonBufferFiles());
            if (fileArray != null) {
                int n2 = fileArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    fileArray[i2].delete();
                }
            }
        }

        public final FilenameFilter excludeBufferFiles() {
            return filterExcludeBufferFiles;
        }

        public final FilenameFilter excludeNonBufferFiles() {
            return filterExcludeNonBufferFiles;
        }

        public final File newFile(File file) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(FILE_NAME_PREFIX);
            stringBuilder.append(String.valueOf(bufferIndex.incrementAndGet()));
            return new File(file, stringBuilder.toString());
        }
    }

    @Metadata(d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/facebook/internal/FileLruCache$CloseCallbackOutputStream;", "Ljava/io/OutputStream;", "innerStream", "callback", "Lcom/facebook/internal/FileLruCache$StreamCloseCallback;", "(Ljava/io/OutputStream;Lcom/facebook/internal/FileLruCache$StreamCloseCallback;)V", "getCallback", "()Lcom/facebook/internal/FileLruCache$StreamCloseCallback;", "getInnerStream", "()Ljava/io/OutputStream;", "close", "", "flush", "write", "buffer", "", "offset", "", "count", "oneByte", "facebook-core_release"}, k=1, mv={1, 5, 1})
    private static final class CloseCallbackOutputStream
    extends OutputStream {
        private final StreamCloseCallback callback;
        private final OutputStream innerStream;

        public CloseCallbackOutputStream(OutputStream outputStream, StreamCloseCallback streamCloseCallback) {
            Intrinsics.checkNotNullParameter(outputStream, "innerStream");
            Intrinsics.checkNotNullParameter(streamCloseCallback, "callback");
            this.innerStream = outputStream;
            this.callback = streamCloseCallback;
        }

        @Override
        public void close() throws IOException {
            try {
                this.innerStream.close();
                return;
            }
            finally {
                this.callback.onClose();
            }
        }

        @Override
        public void flush() throws IOException {
            this.innerStream.flush();
        }

        public final StreamCloseCallback getCallback() {
            return this.callback;
        }

        public final OutputStream getInnerStream() {
            return this.innerStream;
        }

        @Override
        public void write(int n2) throws IOException {
            this.innerStream.write(n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            Intrinsics.checkNotNullParameter(byArray, "buffer");
            this.innerStream.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            Intrinsics.checkNotNullParameter(byArray, "buffer");
            this.innerStream.write(byArray, n2, n3);
        }
    }

    @Metadata(d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/internal/FileLruCache$Companion;", "", "()V", "HEADER_CACHEKEY_KEY", "", "HEADER_CACHE_CONTENT_TAG_KEY", "TAG", "getTAG", "()Ljava/lang/String;", "bufferIndex", "Ljava/util/concurrent/atomic/AtomicLong;", "facebook-core_release"}, k=1, mv={1, 5, 1})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final String getTAG() {
            return TAG;
        }
    }

    @Metadata(d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/facebook/internal/FileLruCache$CopyingInputStream;", "Ljava/io/InputStream;", "input", "output", "Ljava/io/OutputStream;", "(Ljava/io/InputStream;Ljava/io/OutputStream;)V", "getInput", "()Ljava/io/InputStream;", "getOutput", "()Ljava/io/OutputStream;", "available", "", "close", "", "mark", "readlimit", "markSupported", "", "read", "buffer", "", "offset", "length", "reset", "skip", "", "byteCount", "facebook-core_release"}, k=1, mv={1, 5, 1})
    private static final class CopyingInputStream
    extends InputStream {
        private final InputStream input;
        private final OutputStream output;

        public CopyingInputStream(InputStream inputStream, OutputStream outputStream) {
            Intrinsics.checkNotNullParameter(inputStream, "input");
            Intrinsics.checkNotNullParameter(outputStream, "output");
            this.input = inputStream;
            this.output = outputStream;
        }

        @Override
        public int available() throws IOException {
            return this.input.available();
        }

        @Override
        public void close() throws IOException {
            try {
                this.input.close();
                return;
            }
            finally {
                this.output.close();
            }
        }

        public final InputStream getInput() {
            return this.input;
        }

        public final OutputStream getOutput() {
            return this.output;
        }

        @Override
        public void mark(int n2) {
            throw (Throwable)new UnsupportedOperationException();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            int n2 = this.input.read();
            if (n2 >= 0) {
                this.output.write(n2);
            }
            return n2;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            Intrinsics.checkNotNullParameter(byArray, "buffer");
            int n2 = this.input.read(byArray);
            if (n2 > 0) {
                this.output.write(byArray, 0, n2);
            }
            return n2;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            Intrinsics.checkNotNullParameter(byArray, "buffer");
            n3 = this.input.read(byArray, n2, n3);
            if (n3 > 0) {
                this.output.write(byArray, n2, n3);
            }
            return n3;
        }

        @Override
        public void reset() {
            synchronized (this) {
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                throw (Throwable)unsupportedOperationException;
            }
        }

        @Override
        public long skip(long l2) throws IOException {
            long l3;
            int n2;
            byte[] byArray = new byte[1024];
            for (l3 = 0L; l3 < l2; l3 += (long)n2) {
                n2 = this.read(byArray, 0, (int)Math.min(l2 - l3, (long)byArray.length));
                if (n2 >= 0) continue;
                return l3;
            }
            return l3;
        }
    }

    @Metadata(d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lcom/facebook/internal/FileLruCache$Limits;", "", "()V", "value", "", "byteCount", "getByteCount", "()I", "setByteCount", "(I)V", "fileCount", "getFileCount", "setFileCount", "facebook-core_release"}, k=1, mv={1, 5, 1})
    public static final class Limits {
        private int byteCount = 0x100000;
        private int fileCount = 1024;

        public final int getByteCount() {
            return this.byteCount;
        }

        public final int getFileCount() {
            return this.fileCount;
        }

        public final void setByteCount(int n2) {
            if (n2 >= 0) {
                this.byteCount = n2;
                return;
            }
            throw (Throwable)new InvalidParameterException("Cache byte-count limit must be >= 0");
        }

        public final void setFileCount(int n2) {
            if (n2 >= 0) {
                this.fileCount = n2;
                return;
            }
            throw (Throwable)new InvalidParameterException("Cache file count limit must be >= 0");
        }
    }

    @Metadata(d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/facebook/internal/FileLruCache$ModifiedFile;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "modified", "", "getModified", "()J", "compareTo", "", "another", "equals", "", "", "hashCode", "Companion", "facebook-core_release"}, k=1, mv={1, 5, 1})
    private static final class ModifiedFile
    implements Comparable<ModifiedFile> {
        public static final Companion Companion = new Companion(null);
        private static final int HASH_MULTIPLIER = 37;
        private static final int HASH_SEED = 29;
        private final File file;
        private final long modified;

        public ModifiedFile(File file) {
            Intrinsics.checkNotNullParameter(file, "file");
            this.file = file;
            this.modified = this.file.lastModified();
        }

        @Override
        public int compareTo(ModifiedFile modifiedFile) {
            Intrinsics.checkNotNullParameter(modifiedFile, "another");
            long l2 = this.modified;
            long l3 = modifiedFile.modified;
            int n2 = l2 < l3 ? -1 : (l2 > l3 ? 1 : this.file.compareTo(modifiedFile.file));
            return n2;
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof ModifiedFile && this.compareTo((ModifiedFile)object) == 0;
            return bl;
        }

        public final File getFile() {
            return this.file;
        }

        public final long getModified() {
            return this.modified;
        }

        public int hashCode() {
            return (1073 + this.file.hashCode()) * 37 + (int)(this.modified % (long)Integer.MAX_VALUE);
        }

        @Metadata(d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/FileLruCache$ModifiedFile$Companion;", "", "()V", "HASH_MULTIPLIER", "", "HASH_SEED", "facebook-core_release"}, k=1, mv={1, 5, 1})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }

    @Metadata(d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e2\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/facebook/internal/FileLruCache$StreamCloseCallback;", "", "onClose", "", "facebook-core_release"}, k=1, mv={1, 5, 1})
    private static interface StreamCloseCallback {
        public void onClose();
    }

    @Metadata(d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/internal/FileLruCache$StreamHeader;", "", "()V", "HEADER_VERSION", "", "readHeader", "Lorg/json/JSONObject;", "stream", "Ljava/io/InputStream;", "writeHeader", "", "Ljava/io/OutputStream;", "header", "facebook-core_release"}, k=1, mv={1, 5, 1})
    private static final class StreamHeader {
        private static final int HEADER_VERSION = 0;
        public static final StreamHeader INSTANCE = new StreamHeader();

        private StreamHeader() {
        }

        public final JSONObject readHeader(InputStream object) throws IOException {
            Object object2;
            block7: {
                int n2;
                Intrinsics.checkNotNullParameter(object, "stream");
                if (((InputStream)object).read() != 0) {
                    return null;
                }
                int n3 = 0;
                int n4 = 0;
                for (n2 = 0; n2 < 3; ++n2) {
                    int n5 = ((InputStream)object).read();
                    if (n5 == -1) {
                        Logger.Companion.log(LoggingBehavior.CACHE, Companion.getTAG(), "readHeader: stream.read returned -1 while reading header size");
                        return null;
                    }
                    n4 = (n4 << 8) + (n5 & 0xFF);
                }
                object2 = new byte[n4];
                for (n4 = n3; n4 < ((byte[])object2).length; n4 += n2) {
                    n2 = ((InputStream)object).read((byte[])object2, n4, ((byte[])object2).length - n4);
                    if (n2 >= 1) continue;
                    Logger.Companion companion = Logger.Companion;
                    LoggingBehavior loggingBehavior = LoggingBehavior.CACHE;
                    object = Companion.getTAG();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("readHeader: stream.read stopped at ");
                    stringBuilder.append((Object)n4);
                    stringBuilder.append(" when expected ");
                    stringBuilder.append(((Object)object2).length);
                    companion.log(loggingBehavior, (String)object, stringBuilder.toString());
                    return null;
                }
                object = new JSONTokener(new String((byte[])object2, Charsets.UTF_8));
                try {
                    object2 = object.nextValue();
                    if (object2 instanceof JSONObject) break block7;
                    Logger.Companion companion = Logger.Companion;
                    LoggingBehavior loggingBehavior = LoggingBehavior.CACHE;
                    object = Companion.getTAG();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("readHeader: expected JSONObject, got ");
                    stringBuilder.append(object2.getClass().getCanonicalName());
                    companion.log(loggingBehavior, (String)object, stringBuilder.toString());
                    return null;
                }
                catch (JSONException jSONException) {
                    Throwable throwable = new IOException(jSONException.getMessage());
                    throw throwable;
                }
            }
            object = (JSONObject)object2;
            return object;
        }

        public final void writeHeader(OutputStream outputStream, JSONObject object) throws IOException {
            Intrinsics.checkNotNullParameter(outputStream, "stream");
            Intrinsics.checkNotNullParameter(object, "header");
            String string2 = object.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "header.toString()");
            object = Charsets.UTF_8;
            if (string2 != null) {
                object = string2.getBytes((Charset)object);
                Intrinsics.checkNotNullExpressionValue(object, "(this as java.lang.String).getBytes(charset)");
                outputStream.write(0);
                outputStream.write(((JSONObject)object).length >> 16 & 0xFF);
                outputStream.write(((JSONObject)object).length >> 8 & 0xFF);
                outputStream.write(((JSONObject)object).length >> 0 & 0xFF);
                outputStream.write((byte[])object);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
    }
}

