/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.facebook.CustomTabMainActivity;
import com.facebook.FacebookActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.AppCall;
import com.facebook.internal.CustomTabUtils;
import com.facebook.internal.DialogFeature;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.safedk.android.analytics.brandsafety.BrandSafetyUtils;
import com.safedk.android.utils.Logger;

public class DialogPresenter {
    public static boolean canPresentNativeDialogWithFeature(DialogFeature dialogFeature) {
        boolean bl = DialogPresenter.getProtocolVersionForNativeDialog(dialogFeature).getProtocolVersion() != -1;
        return bl;
    }

    public static boolean canPresentWebFallbackDialogWithFeature(DialogFeature dialogFeature) {
        boolean bl = DialogPresenter.getDialogWebFallbackUri(dialogFeature) != null;
        return bl;
    }

    private static Uri getDialogWebFallbackUri(DialogFeature object) {
        String string2 = object.name();
        object = object.getAction();
        object = FetchedAppSettings.getDialogFeatureConfig((String)FacebookSdk.getApplicationId(), (String)object, (String)string2);
        object = object != null ? object.getFallbackUrl() : null;
        return object;
    }

    public static NativeProtocol.ProtocolVersionQueryResult getProtocolVersionForNativeDialog(DialogFeature dialogFeature) {
        String string2 = FacebookSdk.getApplicationId();
        String string3 = dialogFeature.getAction();
        return NativeProtocol.getLatestAvailableProtocolVersionForAction(string3, DialogPresenter.getVersionSpecForFeature(string2, string3, dialogFeature));
    }

    private static int[] getVersionSpecForFeature(String string2, String string3, DialogFeature dialogFeature) {
        if ((string2 = FetchedAppSettings.getDialogFeatureConfig((String)string2, (String)string3, (String)dialogFeature.name())) != null) {
            return string2.getVersionSpec();
        }
        return new int[]{dialogFeature.getMinVersion()};
    }

    public static void logDialogActivity(Context context, String string2, String string3) {
        context = new InternalAppEventsLogger(context);
        Bundle bundle = new Bundle();
        bundle.putString("fb_dialog_outcome", string3);
        context.logEventImplicitly(string2, bundle);
    }

    public static void present(AppCall appCall, Activity activity) {
        DialogPresenter.safedk_Activity_startActivityForResult_206f42f0b65887e835d87ee52d14d221(activity, appCall.getRequestIntent(), appCall.getRequestCode());
        appCall.setPending();
    }

    public static void present(AppCall appCall, FragmentWrapper fragmentWrapper) {
        DialogPresenter.safedk_FragmentWrapper_startActivityForResult_51accca8f1bb017fcda2a6aac31602e6(fragmentWrapper, appCall.getRequestIntent(), appCall.getRequestCode());
        appCall.setPending();
    }

    public static void safedk_Activity_startActivityForResult_206f42f0b65887e835d87ee52d14d221(Activity activity, Intent intent, int n2) {
        Logger.d("SafeDK-Special|SafeDK: Call> Landroid/app/Activity;->startActivityForResult(Landroid/content/Intent;I)V");
        if (intent == null) {
            return;
        }
        BrandSafetyUtils.detectAdClick(intent, "com.facebook");
        activity.startActivityForResult(intent, n2);
    }

    public static void safedk_FragmentWrapper_startActivityForResult_51accca8f1bb017fcda2a6aac31602e6(FragmentWrapper fragmentWrapper, Intent intent, int n2) {
        Logger.d("SafeDK-Special|SafeDK: Call> Lcom/facebook/internal/FragmentWrapper;->startActivityForResult(Landroid/content/Intent;I)V");
        if (intent == null) {
            return;
        }
        BrandSafetyUtils.detectAdClick(intent, "com.facebook");
        fragmentWrapper.startActivityForResult(intent, n2);
    }

    public static void setupAppCallForCannotShowError(AppCall appCall) {
        DialogPresenter.setupAppCallForValidationError(appCall, new FacebookException("Unable to show the provided content via the web or the installed version of the Facebook app. Some dialogs are only supported starting API 14."));
    }

    public static void setupAppCallForCustomTabDialog(AppCall appCall, String string2, Bundle bundle) {
        Validate.hasCustomTabRedirectActivity((Context)FacebookSdk.getApplicationContext(), (String)CustomTabUtils.getDefaultRedirectURI());
        Validate.hasInternetPermissions((Context)FacebookSdk.getApplicationContext());
        Intent intent = new Intent(FacebookSdk.getApplicationContext(), CustomTabMainActivity.class);
        intent.putExtra(CustomTabMainActivity.EXTRA_ACTION, string2);
        intent.putExtra(CustomTabMainActivity.EXTRA_PARAMS, bundle);
        intent.putExtra(CustomTabMainActivity.EXTRA_CHROME_PACKAGE, CustomTabUtils.getChromePackage());
        NativeProtocol.setupProtocolRequestIntent(intent, appCall.getCallId().toString(), string2, NativeProtocol.getLatestKnownVersion(), null);
        appCall.setRequestIntent(intent);
    }

    public static void setupAppCallForErrorResult(AppCall appCall, FacebookException facebookException) {
        if (facebookException == null) {
            return;
        }
        Validate.hasFacebookActivity((Context)FacebookSdk.getApplicationContext());
        Intent intent = new Intent();
        intent.setClass(FacebookSdk.getApplicationContext(), FacebookActivity.class);
        intent.setAction(FacebookActivity.PASS_THROUGH_CANCEL_ACTION);
        NativeProtocol.setupProtocolRequestIntent(intent, appCall.getCallId().toString(), null, NativeProtocol.getLatestKnownVersion(), NativeProtocol.createBundleForException(facebookException));
        appCall.setRequestIntent(intent);
    }

    public static void setupAppCallForNativeDialog(AppCall appCall, ParameterProvider parameterProvider, DialogFeature object) {
        Context context = FacebookSdk.getApplicationContext();
        String string2 = object.getAction();
        NativeProtocol.ProtocolVersionQueryResult protocolVersionQueryResult = DialogPresenter.getProtocolVersionForNativeDialog(object);
        int n2 = protocolVersionQueryResult.getProtocolVersion();
        if (n2 != -1) {
            parameterProvider = NativeProtocol.isVersionCompatibleWithBucketedIntent(n2) ? parameterProvider.getParameters() : parameterProvider.getLegacyParameters();
            object = parameterProvider;
            if (parameterProvider == null) {
                object = new Bundle();
            }
            if ((parameterProvider = NativeProtocol.createPlatformActivityIntent(context, appCall.getCallId().toString(), string2, protocolVersionQueryResult, (Bundle)object)) != null) {
                appCall.setRequestIntent((Intent)parameterProvider);
                return;
            }
            throw new FacebookException("Unable to create Intent; this likely means theFacebook app is not installed.");
        }
        throw new FacebookException("Cannot present this dialog. This likely means that the Facebook app is not installed.");
    }

    public static void setupAppCallForValidationError(AppCall appCall, FacebookException facebookException) {
        DialogPresenter.setupAppCallForErrorResult(appCall, facebookException);
    }

    public static void setupAppCallForWebDialog(AppCall appCall, String string2, Bundle bundle) {
        Validate.hasFacebookActivity((Context)FacebookSdk.getApplicationContext());
        Validate.hasInternetPermissions((Context)FacebookSdk.getApplicationContext());
        Bundle bundle2 = new Bundle();
        bundle2.putString("action", string2);
        bundle2.putBundle("params", bundle);
        bundle = new Intent();
        NativeProtocol.setupProtocolRequestIntent((Intent)bundle, appCall.getCallId().toString(), string2, NativeProtocol.getLatestKnownVersion(), bundle2);
        bundle.setClass(FacebookSdk.getApplicationContext(), FacebookActivity.class);
        bundle.setAction("FacebookDialogFragment");
        appCall.setRequestIntent((Intent)bundle);
    }

    public static void setupAppCallForWebFallbackDialog(AppCall object, Bundle bundle, DialogFeature dialogFeature) {
        Validate.hasFacebookActivity((Context)FacebookSdk.getApplicationContext());
        Validate.hasInternetPermissions((Context)FacebookSdk.getApplicationContext());
        String string2 = dialogFeature.name();
        Uri uri = DialogPresenter.getDialogWebFallbackUri(dialogFeature);
        if (uri != null) {
            int n2 = NativeProtocol.getLatestKnownVersion();
            bundle = ServerProtocol.getQueryParamsForPlatformActivityIntentWebFallback((String)object.getCallId().toString(), (int)n2, (Bundle)bundle);
            if (bundle != null) {
                bundle = uri.isRelative() ? Utility.buildUri((String)ServerProtocol.getDialogAuthority(), (String)uri.toString(), (Bundle)bundle) : Utility.buildUri((String)uri.getAuthority(), (String)uri.getPath(), (Bundle)bundle);
                string2 = new Bundle();
                string2.putString("url", bundle.toString());
                string2.putBoolean("is_fallback", true);
                bundle = new Intent();
                NativeProtocol.setupProtocolRequestIntent((Intent)bundle, object.getCallId().toString(), dialogFeature.getAction(), NativeProtocol.getLatestKnownVersion(), (Bundle)string2);
                bundle.setClass(FacebookSdk.getApplicationContext(), FacebookActivity.class);
                bundle.setAction("FacebookDialogFragment");
                object.setRequestIntent((Intent)bundle);
                return;
            }
            throw new FacebookException("Unable to fetch the app's key-hash");
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Unable to fetch the Url for the DialogFeature : '");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append("'");
        throw new FacebookException(((StringBuilder)object).toString());
    }

    public static interface ParameterProvider {
        public Bundle getLegacyParameters();

        public Bundle getParameters();
    }
}

