/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.os.Bundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bH\u0007R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/internal/BundleJSONConverter;", "", "()V", "SETTERS", "", "Ljava/lang/Class;", "Lcom/facebook/internal/BundleJSONConverter$Setter;", "convertToBundle", "Landroid/os/Bundle;", "jsonObject", "Lorg/json/JSONObject;", "convertToJSON", "bundle", "Setter", "facebook-core_release"}, k=1, mv={1, 5, 1})
public final class BundleJSONConverter {
    public static final BundleJSONConverter INSTANCE = new BundleJSONConverter();
    private static final Map<Class<?>, Setter> SETTERS = new HashMap();

    static {
        SETTERS.put(Boolean.class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String string2, Object object) throws JSONException {
                Intrinsics.checkNotNullParameter(bundle, "bundle");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object, "value");
                bundle.putBoolean(string2, ((Boolean)object).booleanValue());
            }

            @Override
            public void setOnJSON(JSONObject jSONObject, String string2, Object object) throws JSONException {
                Intrinsics.checkNotNullParameter(jSONObject, "json");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object, "value");
                jSONObject.put(string2, object);
            }
        });
        SETTERS.put(Integer.class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String string2, Object object) throws JSONException {
                Intrinsics.checkNotNullParameter(bundle, "bundle");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object, "value");
                bundle.putInt(string2, ((Integer)object).intValue());
            }

            @Override
            public void setOnJSON(JSONObject jSONObject, String string2, Object object) throws JSONException {
                Intrinsics.checkNotNullParameter(jSONObject, "json");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object, "value");
                jSONObject.put(string2, object);
            }
        });
        SETTERS.put(Long.class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String string2, Object object) throws JSONException {
                Intrinsics.checkNotNullParameter(bundle, "bundle");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object, "value");
                bundle.putLong(string2, ((Long)object).longValue());
            }

            @Override
            public void setOnJSON(JSONObject jSONObject, String string2, Object object) throws JSONException {
                Intrinsics.checkNotNullParameter(jSONObject, "json");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object, "value");
                jSONObject.put(string2, object);
            }
        });
        SETTERS.put(Double.class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String string2, Object object) throws JSONException {
                Intrinsics.checkNotNullParameter(bundle, "bundle");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object, "value");
                bundle.putDouble(string2, ((Double)object).doubleValue());
            }

            @Override
            public void setOnJSON(JSONObject jSONObject, String string2, Object object) throws JSONException {
                Intrinsics.checkNotNullParameter(jSONObject, "json");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object, "value");
                jSONObject.put(string2, object);
            }
        });
        SETTERS.put(String.class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String string2, Object object) throws JSONException {
                Intrinsics.checkNotNullParameter(bundle, "bundle");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object, "value");
                bundle.putString(string2, (String)object);
            }

            @Override
            public void setOnJSON(JSONObject jSONObject, String string2, Object object) throws JSONException {
                Intrinsics.checkNotNullParameter(jSONObject, "json");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object, "value");
                jSONObject.put(string2, object);
            }
        });
        SETTERS.put(String[].class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String string2, Object object) throws JSONException {
                Intrinsics.checkNotNullParameter(bundle, "bundle");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object, "value");
                throw (Throwable)new IllegalArgumentException("Unexpected type from JSON");
            }

            @Override
            public void setOnJSON(JSONObject jSONObject, String string2, Object stringArray) throws JSONException {
                Intrinsics.checkNotNullParameter(jSONObject, "json");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(stringArray, "value");
                JSONArray jSONArray = new JSONArray();
                stringArray = stringArray;
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    jSONArray.put((Object)stringArray[i2]);
                }
                jSONObject.put(string2, (Object)jSONArray);
            }
        });
        SETTERS.put(JSONArray.class, new Setter(){

            @Override
            public void setOnBundle(Bundle object, String string2, Object object2) throws JSONException {
                Intrinsics.checkNotNullParameter(object, "bundle");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object2, "value");
                JSONArray jSONArray = (JSONArray)object2;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (jSONArray.length() == 0) {
                    object.putStringArrayList(string2, arrayList);
                    return;
                }
                int n2 = jSONArray.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    object2 = jSONArray.get(i2);
                    if (object2 instanceof String) {
                        arrayList.add(object2);
                        continue;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unexpected type in an array: ");
                    ((StringBuilder)object).append(object2.getClass());
                    throw (Throwable)new IllegalArgumentException(((StringBuilder)object).toString());
                }
                object.putStringArrayList(string2, arrayList);
            }

            @Override
            public void setOnJSON(JSONObject jSONObject, String string2, Object object) throws JSONException {
                Intrinsics.checkNotNullParameter(jSONObject, "json");
                Intrinsics.checkNotNullParameter(string2, "key");
                Intrinsics.checkNotNullParameter(object, "value");
                throw (Throwable)new IllegalArgumentException("JSONArray's are not supported in bundles.");
            }
        });
    }

    private BundleJSONConverter() {
    }

    @JvmStatic
    public static final Bundle convertToBundle(JSONObject object) throws JSONException {
        Intrinsics.checkNotNullParameter(object, "jsonObject");
        Bundle bundle = new Bundle();
        Iterator iterator2 = object.keys();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator2.next();
            Object object2 = object.get(string2);
            if (object2 == JSONObject.NULL) continue;
            if (object2 instanceof JSONObject) {
                bundle.putBundle(string2, BundleJSONConverter.convertToBundle((JSONObject)object2));
                continue;
            }
            Setter setter = SETTERS.get(object2.getClass());
            if (setter != null) {
                Intrinsics.checkNotNullExpressionValue(string2, "key");
                Intrinsics.checkNotNullExpressionValue(object2, "value");
                setter.setOnBundle(bundle, string2, object2);
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unsupported type: ");
            ((StringBuilder)object).append(object2.getClass());
            throw (Throwable)new IllegalArgumentException(((StringBuilder)object).toString());
        }
        return bundle;
    }

    @JvmStatic
    public static final JSONObject convertToJSON(Bundle object) throws JSONException {
        Intrinsics.checkNotNullParameter(object, "bundle");
        JSONObject jSONObject = new JSONObject();
        for (String string2 : object.keySet()) {
            Object object2;
            Iterator iterator2 = object.get(string2);
            if (iterator2 == null) continue;
            Intrinsics.checkNotNullExpressionValue(iterator2, "bundle[key] ?: // Null i\u2026orted.\n          continue");
            if (iterator2 instanceof List) {
                object2 = new JSONArray();
                iterator2 = ((List)((Object)iterator2)).iterator();
                while (iterator2.hasNext()) {
                    object2.put((Object)((String)iterator2.next()));
                }
                jSONObject.put(string2, object2);
                continue;
            }
            if (iterator2 instanceof Bundle) {
                jSONObject.put(string2, (Object)BundleJSONConverter.convertToJSON((Bundle)iterator2));
                continue;
            }
            object2 = SETTERS.get(iterator2.getClass());
            if (object2 != null) {
                Intrinsics.checkNotNullExpressionValue(string2, "key");
                object2.setOnJSON(jSONObject, string2, iterator2);
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unsupported type: ");
            ((StringBuilder)object).append(iterator2.getClass());
            throw (Throwable)new IllegalArgumentException(((StringBuilder)object).toString());
        }
        return jSONObject;
    }

    @Metadata(d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H&J \u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H&\u00a8\u0006\f"}, d2={"Lcom/facebook/internal/BundleJSONConverter$Setter;", "", "setOnBundle", "", "bundle", "Landroid/os/Bundle;", "key", "", "value", "setOnJSON", "json", "Lorg/json/JSONObject;", "facebook-core_release"}, k=1, mv={1, 5, 1})
    public static interface Setter {
        public void setOnBundle(Bundle var1, String var2, Object var3) throws JSONException;

        public void setOnJSON(JSONObject var1, String var2, Object var3) throws JSONException;
    }
}

