/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Looper;
import android.view.View;
import com.facebook.FacebookSdk;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;

@Metadata(d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\tH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0006H\u0007J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/facebook/appevents/internal/AppEventUtility;", "", "()V", "PRICE_REGEX", "", "isMainThread", "", "()Z", "assertIsMainThread", "", "assertIsNotMainThread", "bytesToHex", "bytes", "", "getAppVersion", "getRootView", "Landroid/view/View;", "activity", "Landroid/app/Activity;", "isEmulator", "normalizePrice", "", "value", "facebook-core_release"}, k=1, mv={1, 5, 1})
public final class AppEventUtility {
    public static final AppEventUtility INSTANCE = new AppEventUtility();
    private static final String PRICE_REGEX = "[-+]*\\d+([.,]\\d+)*([.,]\\d+)?";

    private AppEventUtility() {
    }

    @JvmStatic
    public static final void assertIsMainThread() {
    }

    @JvmStatic
    public static final void assertIsNotMainThread() {
    }

    @JvmStatic
    public static final String bytesToHex(byte[] object) {
        Intrinsics.checkNotNullParameter(object, "bytes");
        StringBuffer stringBuffer = new StringBuffer();
        for (Object object2 : object) {
            Object object3 = StringCompanionObject.INSTANCE;
            object3 = new Object[]{(byte)object2};
            object3 = String.format("%02x", Arrays.copyOf(object3, ((Object[])object3).length));
            Intrinsics.checkNotNullExpressionValue(object3, "java.lang.String.format(format, *args)");
            stringBuffer.append((String)object3);
        }
        String string2 = stringBuffer.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return string2;
    }

    @JvmStatic
    public static final String getAppVersion() {
        Object object = FacebookSdk.getApplicationContext();
        try {
            object = object.getPackageManager().getPackageInfo((String)object.getPackageName(), (int)0).versionName;
            Intrinsics.checkNotNullExpressionValue(object, "packageInfo.versionName");
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = "";
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final View getRootView(Activity activity) {
        boolean bl = CrashShieldHandler.isObjectCrashing(AppEventUtility.class);
        Object var2_4 = null;
        if (bl) {
            return null;
        }
        if (activity == null) {
            return null;
        }
        activity = activity.getWindow();
        if (activity == null) return null;
        try {
            activity = activity.getDecorView();
            Intrinsics.checkNotNullExpressionValue(activity, "window.decorView");
            return activity.getRootView();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, AppEventUtility.class);
            return var2_4;
        }
        catch (Exception exception) {
            return var2_4;
        }
    }

    @JvmStatic
    public static final boolean isEmulator() {
        boolean bl;
        block4: {
            block2: {
                block3: {
                    String string2 = Build.FINGERPRINT;
                    Intrinsics.checkNotNullExpressionValue(string2, "Build.FINGERPRINT");
                    bl = false;
                    if (StringsKt.startsWith$default((String)string2, (String)"generic", (boolean)false, (int)2, null)) break block2;
                    string2 = Build.FINGERPRINT;
                    Intrinsics.checkNotNullExpressionValue(string2, "Build.FINGERPRINT");
                    if (StringsKt.startsWith$default((String)string2, (String)"unknown", (boolean)false, (int)2, null)) break block2;
                    string2 = Build.MODEL;
                    Intrinsics.checkNotNullExpressionValue(string2, "Build.MODEL");
                    if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) break block2;
                    string2 = Build.MODEL;
                    Intrinsics.checkNotNullExpressionValue(string2, "Build.MODEL");
                    if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"Emulator", (boolean)false, (int)2, null)) break block2;
                    string2 = Build.MODEL;
                    Intrinsics.checkNotNullExpressionValue(string2, "Build.MODEL");
                    if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) break block2;
                    string2 = Build.MANUFACTURER;
                    Intrinsics.checkNotNullExpressionValue(string2, "Build.MANUFACTURER");
                    if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) break block2;
                    string2 = Build.BRAND;
                    Intrinsics.checkNotNullExpressionValue(string2, "Build.BRAND");
                    if (!StringsKt.startsWith$default((String)string2, (String)"generic", (boolean)false, (int)2, null)) break block3;
                    string2 = Build.DEVICE;
                    Intrinsics.checkNotNullExpressionValue(string2, "Build.DEVICE");
                    if (StringsKt.startsWith$default((String)string2, (String)"generic", (boolean)false, (int)2, null)) break block2;
                }
                if (!Intrinsics.areEqual("google_sdk", Build.PRODUCT)) break block4;
            }
            bl = true;
        }
        return bl;
    }

    @JvmStatic
    private static final boolean isMainThread() {
        return Intrinsics.areEqual(Looper.myLooper(), Looper.getMainLooper());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final double normalizePrice(String object) {
        double d2;
        double d3 = 0.0;
        try {
            object = Pattern.compile(PRICE_REGEX, 8).matcher((CharSequence)object);
            d2 = d3;
        }
        catch (ParseException parseException) {
            return d3;
        }
        if (!((Matcher)object).find()) return d2;
        object = ((Matcher)object).group(0);
        return NumberFormat.getNumberInstance(Utility.getCurrentLocale()).parse((String)object).doubleValue();
    }
}

