/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AnalyticsUserIDStore;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;

@Metadata(d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0007J\u0012\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/appevents/AnalyticsUserIDStore;", "", "()V", "ANALYTICS_USER_ID_KEY", "", "TAG", "initialized", "", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "userID", "getUserID", "initAndWait", "", "initStore", "setUserID", "id", "facebook-core_release"}, k=1, mv={1, 5, 1})
public final class AnalyticsUserIDStore {
    private static final String ANALYTICS_USER_ID_KEY = "com.facebook.appevents.AnalyticsUserIDStore.userID";
    public static final AnalyticsUserIDStore INSTANCE = new AnalyticsUserIDStore();
    private static final String TAG;
    private static volatile boolean initialized;
    private static final ReentrantReadWriteLock lock;
    private static String userID;

    static {
        String string2 = AnalyticsUserIDStore.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "AnalyticsUserIDStore::class.java.simpleName");
        TAG = string2;
        lock = new ReentrantReadWriteLock();
    }

    private AnalyticsUserIDStore() {
    }

    public static final /* synthetic */ ReentrantReadWriteLock access$getLock$p(AnalyticsUserIDStore analyticsUserIDStore) {
        return lock;
    }

    public static final /* synthetic */ String access$getUserID$p(AnalyticsUserIDStore analyticsUserIDStore) {
        return userID;
    }

    public static final /* synthetic */ void access$initAndWait(AnalyticsUserIDStore analyticsUserIDStore) {
        analyticsUserIDStore.initAndWait();
    }

    public static final /* synthetic */ void access$setUserID$p(AnalyticsUserIDStore analyticsUserIDStore, String string2) {
        userID = string2;
    }

    @JvmStatic
    public static final String getUserID() {
        if (!initialized) {
            Log.w((String)TAG, (String)"initStore should have been called before calling setUserID");
            INSTANCE.initAndWait();
        }
        lock.readLock().lock();
        try {
            String string2 = userID;
            return string2;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    private final void initAndWait() {
        block5: {
            if (initialized) {
                return;
            }
            lock.writeLock().lock();
            boolean bl = initialized;
            if (!bl) break block5;
            lock.writeLock().unlock();
            return;
        }
        try {
            userID = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext()).getString(ANALYTICS_USER_ID_KEY, null);
            initialized = true;
            return;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @JvmStatic
    public static final void initStore() {
        if (initialized) {
            return;
        }
        InternalAppEventsLogger.Companion.getAnalyticsExecutor().execute(initStore.1.INSTANCE);
    }

    @JvmStatic
    public static final void setUserID(String string2) {
        AppEventUtility.assertIsNotMainThread();
        if (!initialized) {
            Log.w((String)TAG, (String)"initStore should have been called before calling setUserID");
            INSTANCE.initAndWait();
        }
        InternalAppEventsLogger.Companion.getAnalyticsExecutor().execute(new Runnable(string2){
            final /* synthetic */ String $id;
            {
                this.$id = string2;
            }

            /*
             * Loose catch block
             */
            public final void run() {
                block10: {
                    if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                        return;
                    }
                    boolean bl = CrashShieldHandler.isObjectCrashing((Object)this);
                    if (!bl) break block10;
                    return;
                }
                AnalyticsUserIDStore.access$getLock$p(AnalyticsUserIDStore.INSTANCE).writeLock().lock();
                {
                    catch (Throwable throwable) {
                        try {
                            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                            return;
                        }
                        catch (Throwable throwable2) {
                            CrashShieldHandler.handleThrowable((Throwable)throwable2, (Object)this);
                            return;
                        }
                    }
                }
                AnalyticsUserIDStore.access$setUserID$p(AnalyticsUserIDStore.INSTANCE, this.$id);
                SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext()).edit();
                editor.putString("com.facebook.appevents.AnalyticsUserIDStore.userID", AnalyticsUserIDStore.access$getUserID$p(AnalyticsUserIDStore.INSTANCE));
                editor.apply();
                AnalyticsUserIDStore.access$getLock$p(AnalyticsUserIDStore.INSTANCE).writeLock().unlock();
                return;
                catch (Throwable throwable) {
                    AnalyticsUserIDStore.access$getLock$p(AnalyticsUserIDStore.INSTANCE).writeLock().unlock();
                    throw throwable;
                }
            }
        });
    }
}

