/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.dynamicloading;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.BuildConfig;
import com.facebook.ads.internal.dynamicloading.DexLoadErrorReporter;
import com.facebook.ads.internal.dynamicloading.DynamicLoader;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFallback;
import com.facebook.ads.internal.settings.MultithreadedBundleWrapper;
import com.facebook.ads.internal.util.common.ANActivityLifecycleCallbacksListener;
import com.facebook.ads.internal.util.common.Preconditions;
import com.safedk.android.internal.partials.FacebookAudienceNetworkFilesBridge;
import dalvik.system.DexClassLoader;
import dalvik.system.InMemoryDexClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class DynamicLoaderFactory {
    private static final String AUDIENCE_NETWORK_CODE_PATH = "audience_network";
    public static final String AUDIENCE_NETWORK_DEX = "audience_network.dex";
    private static final String CODE_CACHE_DIR = "code_cache";
    static final String DEX_LOADING_ERROR_MESSAGE = "Can't load Audience Network Dex. Please, check that audience_network.dex is inside of assets folder.";
    private static final int DEX_LOAD_RETRY_COUNT = 3;
    private static final int DEX_LOAD_RETRY_DELAY_MS = 200;
    private static final String DYNAMIC_LOADING_BUILD_TYPE = "releaseDL";
    public static final boolean LOAD_FROM_ASSETS = "releaseDL".equals(BuildConfig.BUILD_TYPE);
    private static final String OPTIMIZED_DEX_PATH = "optimized";
    private static final AtomicReference<DynamicLoader> sDynamicLoader = new AtomicReference();
    private static boolean sFallbackMode;
    private static final AtomicBoolean sInitializing;
    private static boolean sUseLegacyClassLoader;

    static {
        sInitializing = new AtomicBoolean();
        sUseLegacyClassLoader = true;
    }

    static /* synthetic */ DynamicLoader access$000(Context context, boolean bl) throws Exception {
        return DynamicLoaderFactory.doMakeLoader(context, bl);
    }

    static /* synthetic */ void access$200(Context context, DynamicLoader dynamicLoader, Throwable throwable, boolean bl, MultithreadedBundleWrapper multithreadedBundleWrapper, AudienceNetworkAds.InitListener initListener) {
        DynamicLoaderFactory.doCallInitialize(context, dynamicLoader, throwable, bl, multithreadedBundleWrapper, initListener);
    }

    static /* synthetic */ AtomicBoolean access$300() {
        return sInitializing;
    }

    private static AudienceNetworkAds.InitResult createErrorInitResult(final Throwable throwable) {
        return new AudienceNetworkAds.InitResult(){

            @Override
            public String getMessage() {
                return DynamicLoaderFactory.createErrorMessage(throwable);
            }

            @Override
            public boolean isSuccess() {
                return false;
            }
        };
    }

    private static String createErrorMessage(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Can't load Audience Network Dex. Please, check that audience_network.dex is inside of assets folder.\n");
        stringBuilder.append(DynamicLoaderFactory.stackTraceToString(throwable));
        return stringBuilder.toString();
    }

    private static ClassLoader createInMemoryClassLoader(Context object) throws IOException {
        int n2;
        object = object.getAssets().open(AUDIENCE_NETWORK_DEX);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = ((InputStream)object).read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        ((InputStream)object).close();
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return new InMemoryDexClassLoader(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()), DynamicLoaderFactory.class.getClassLoader());
    }

    private static void doCallInitialize(Context context, DynamicLoader dynamicLoader, final Throwable throwable, boolean bl, MultithreadedBundleWrapper multithreadedBundleWrapper, final AudienceNetworkAds.InitListener initListener) {
        if (throwable != null) {
            if (initListener != null) {
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        initListener.onInitialized(DynamicLoaderFactory.createErrorInitResult(throwable));
                    }
                }, 100L);
            } else {
                Log.e((String)"FBAudienceNetwork", (String)DEX_LOADING_ERROR_MESSAGE, (Throwable)throwable);
            }
        } else if (dynamicLoader != null) {
            if (bl) {
                dynamicLoader.createAudienceNetworkAdsApi().onContentProviderCreated(context);
            } else {
                dynamicLoader.createAudienceNetworkAdsApi().initialize(context, multithreadedBundleWrapper, initListener);
            }
        }
    }

    private static DynamicLoader doMakeLoader(Context context, boolean bl) throws Exception {
        Object object = sDynamicLoader.get();
        DynamicLoader dynamicLoader = object;
        if (object == null) {
            if (!LOAD_FROM_ASSETS) {
                dynamicLoader = (DynamicLoader)Class.forName("com.facebook.ads.internal.dynamicloading.DynamicLoaderImpl").newInstance();
            } else {
                long l2 = System.currentTimeMillis();
                dynamicLoader = (DynamicLoader)DynamicLoaderFactory.makeAdsSdkClassLoader(context.getApplicationContext()).loadClass("com.facebook.ads.internal.dynamicloading.DynamicLoaderImpl").newInstance();
                long l3 = System.currentTimeMillis();
                object = new StringBuilder();
                ((StringBuilder)object).append("SDK dex loading time: ");
                ((StringBuilder)object).append(l3 - l2);
                Log.d((String)"FBAudienceNetwork", (String)((StringBuilder)object).toString());
            }
            if (bl) {
                dynamicLoader.maybeInitInternally(context);
            }
            sDynamicLoader.set(dynamicLoader);
        }
        return dynamicLoader;
    }

    private static Context getApplicationContextViaReflection() {
        try {
            Context context = (Context)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
            return context;
        }
        catch (Throwable throwable) {
            Log.e((String)"FBAudienceNetwork", (String)"Failed to fetch Context from  ActivityThread. Audience Network SDK won't work unless you call AudienceNetworkAds.buildInitSettings().withListener(InitListener).initialize().", (Throwable)throwable);
            return null;
        }
    }

    private static File getCacheCodeDirLegacy(Context object, File file) throws IOException {
        file = new File(file, CODE_CACHE_DIR);
        try {
            DynamicLoaderFactory.mkdirChecked(file);
            object = file;
        }
        catch (IOException iOException) {
            object = object.getDir(CODE_CACHE_DIR, 0);
            DynamicLoaderFactory.mkdirChecked((File)object);
        }
        return object;
    }

    private static File getCodeCacheDir(Context context, File file) throws IOException {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getCodeCacheDir();
        }
        return DynamicLoaderFactory.getCacheCodeDirLegacy(context, file);
    }

    public static DynamicLoader getDynamicLoader() {
        return sDynamicLoader.get();
    }

    private static File getSecondaryDir(File file) throws IOException {
        file = new File(file, AUDIENCE_NETWORK_CODE_PATH);
        DynamicLoaderFactory.mkdirChecked(file);
        return file;
    }

    public static void initialize(final Context context, final MultithreadedBundleWrapper multithreadedBundleWrapper, final AudienceNetworkAds.InitListener initListener, final boolean bl) {
        if (bl || !sInitializing.getAndSet(true)) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    ANActivityLifecycleCallbacksListener.registerActivityCallbacks((Context)context);
                    synchronized (DynamicLoaderFactory.class) {
                        var1_1 = null;
                        var2_2 = null;
                        var3_4 = 0;
                        while (true) {
                            var4_6 = var1_1;
                            if (var3_4 >= 3) break;
                            try {
                                var4_6 = DynamicLoaderFactory.access$000(context, false);
                                break;
                            }
                            catch (Throwable var4_5) {
                                block9: {
                                    if (var3_4 != 2) ** GOTO lbl20
                                    if (!bl) {
                                        DexLoadErrorReporter.reportDexLoadingIssue((Context)context, (String)DynamicLoaderFactory.access$100(var4_5), (double)0.1);
                                        DynamicLoaderFactory.setFallbackMode(true);
                                    }
                                    var2_2 = var4_5;
                                    break block9;
lbl20:
                                    // 1 sources

                                    SystemClock.sleep((long)200L);
                                }
                                ++var3_4;
                                continue;
                                {
                                    catch (Throwable var2_3) {}
                                    {
                                        throw var2_3;
                                    }
                                }
                            }
                            {
                                continue;
                            }
                            break;
                        }
                    }
                    DynamicLoaderFactory.access$200(context, var4_6, var2_2, bl, multithreadedBundleWrapper, initListener);
                    DynamicLoaderFactory.access$300().set(false);
                }
            }).start();
        }
    }

    public static boolean isFallbackMode() {
        synchronized (DynamicLoaderFactory.class) {
            boolean bl = sFallbackMode;
            return bl;
        }
    }

    private static ClassLoader makeAdsSdkClassLoader(Context context) throws Exception {
        int n2;
        if (Build.VERSION.SDK_INT >= 30) {
            return DynamicLoaderFactory.createInMemoryClassLoader(context);
        }
        if (sUseLegacyClassLoader) {
            return DynamicLoaderFactory.makeLegacyAdsSdkClassLoader(context);
        }
        File file = DynamicLoaderFactory.getSecondaryDir(DynamicLoaderFactory.getCodeCacheDir(context, new File(context.getApplicationInfo().dataDir)));
        CharSequence charSequence = new StringBuilder();
        charSequence.append(file.getPath());
        charSequence.append(File.separator);
        charSequence.append(AUDIENCE_NETWORK_DEX);
        charSequence = charSequence.toString();
        Object object = context.getAssets().open(AUDIENCE_NETWORK_DEX);
        FileOutputStream fileOutputStream = FacebookAudienceNetworkFilesBridge.fileOutputStreamCtor((String)charSequence);
        byte[] byArray = new byte[1024];
        while ((n2 = ((InputStream)object).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n2);
        }
        ((InputStream)object).close();
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
        object = new StringBuilder();
        ((StringBuilder)object).append(file.getPath());
        ((StringBuilder)object).append(File.separator);
        ((StringBuilder)object).append(OPTIMIZED_DEX_PATH);
        file = new File(((StringBuilder)object).toString());
        DynamicLoaderFactory.mkdirChecked(file);
        return new DexClassLoader((String)charSequence, file.getPath(), null, context.getClassLoader());
    }

    private static DexClassLoader makeLegacyAdsSdkClassLoader(Context context) throws Exception {
        int n2;
        CharSequence charSequence = new StringBuilder();
        charSequence.append(context.getFilesDir().getPath());
        charSequence.append(File.separator);
        charSequence.append(AUDIENCE_NETWORK_DEX);
        charSequence = charSequence.toString();
        InputStream inputStream = context.getAssets().open(AUDIENCE_NETWORK_DEX);
        FileOutputStream fileOutputStream = FacebookAudienceNetworkFilesBridge.fileOutputStreamCtor((String)charSequence);
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n2);
        }
        inputStream.close();
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
        return new DexClassLoader((String)charSequence, context.getDir(OPTIMIZED_DEX_PATH, 0).getPath(), null, DynamicLoaderFactory.class.getClassLoader());
    }

    public static DynamicLoader makeLoader(Context context) {
        synchronized (DynamicLoaderFactory.class) {
            context = DynamicLoaderFactory.makeLoader(context, true);
            return context;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DynamicLoader makeLoader(Context context, boolean bl) {
        synchronized (DynamicLoaderFactory.class) {
            Preconditions.checkNotNull((Object)context, (String)"Context can not be null.");
            try {
                void var1_1;
                return DynamicLoaderFactory.doMakeLoader(context, (boolean)var1_1);
            }
            catch (Throwable dynamicLoader) {
                Log.e((String)"FBAudienceNetwork", (String)DEX_LOADING_ERROR_MESSAGE, (Throwable)dynamicLoader);
                DexLoadErrorReporter.reportDexLoadingIssue((Context)context, (String)DynamicLoaderFactory.createErrorMessage(dynamicLoader), (double)0.1);
                context = DynamicLoaderFallback.makeFallbackLoader();
                sDynamicLoader.set((DynamicLoader)context);
                sFallbackMode = true;
                return context;
            }
        }
    }

    public static DynamicLoader makeLoaderUnsafe() {
        synchronized (DynamicLoaderFactory.class) {
            if (sDynamicLoader.get() == null) {
                Object object = DynamicLoaderFactory.getApplicationContextViaReflection();
                if (object != null) {
                    object = DynamicLoaderFactory.makeLoader(object, true);
                    return object;
                }
                object = new RuntimeException("You must call AudienceNetworkAds.buildInitSettings(Context).initialize() before you can use Audience Network SDK.");
                throw object;
            }
            DynamicLoader dynamicLoader = sDynamicLoader.get();
            return dynamicLoader;
        }
    }

    private static void mkdirChecked(File file) throws IOException {
        file.mkdir();
        if (!file.isDirectory()) {
            CharSequence charSequence;
            Comparable<File> comparable = file.getParentFile();
            if (comparable == null) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Failed to create dir ");
                ((StringBuilder)charSequence).append(file.getPath());
                ((StringBuilder)charSequence).append(". Parent file is null.");
                charSequence = ((StringBuilder)charSequence).toString();
            } else {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Failed to create dir ");
                ((StringBuilder)charSequence).append(file.getPath());
                ((StringBuilder)charSequence).append(". parent file is a dir ");
                ((StringBuilder)charSequence).append(((File)comparable).isDirectory());
                ((StringBuilder)charSequence).append(", a file ");
                ((StringBuilder)charSequence).append(((File)comparable).isFile());
                ((StringBuilder)charSequence).append(", exists ");
                ((StringBuilder)charSequence).append(((File)comparable).exists());
                ((StringBuilder)charSequence).append(", readable ");
                ((StringBuilder)charSequence).append(((File)comparable).canRead());
                ((StringBuilder)charSequence).append(", writable ");
                ((StringBuilder)charSequence).append(((File)comparable).canWrite());
                charSequence = ((StringBuilder)charSequence).toString();
            }
            Log.e((String)"FBAudienceNetwork", (String)charSequence);
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("Failed to create directory ");
            ((StringBuilder)comparable).append(file.getPath());
            ((StringBuilder)comparable).append(", detailed message: ");
            ((StringBuilder)comparable).append((String)charSequence);
            throw new IOException(((StringBuilder)comparable).toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setFallbackMode(boolean bl) {
        synchronized (DynamicLoaderFactory.class) {
            if (bl) {
                sDynamicLoader.set(DynamicLoaderFallback.makeFallbackLoader());
                sFallbackMode = true;
            } else {
                sDynamicLoader.set(null);
                sFallbackMode = false;
            }
            return;
        }
    }

    public static void setUseLegacyClassLoader(boolean bl) {
        sUseLegacyClassLoader = bl;
    }

    private static String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

