/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import androidx.core.content.ContextCompat;
import com.facebook.FacebookException;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.common.R;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;

public abstract class FacebookButtonBase
extends Button {
    private String analyticsButtonCreatedEventName;
    private String analyticsButtonTappedEventName;
    private View.OnClickListener externalOnClickListener;
    private View.OnClickListener internalOnClickListener;
    private boolean overrideCompoundPadding;
    private int overrideCompoundPaddingLeft;
    private int overrideCompoundPaddingRight;
    private FragmentWrapper parentFragment;

    protected FacebookButtonBase(Context context, AttributeSet attributeSet, int n2, int n3, String string2, String string3) {
        super(context, attributeSet, 0);
        int n4 = n3;
        if (n3 == 0) {
            n4 = this.getDefaultStyleResource();
        }
        n3 = n4;
        if (n4 == 0) {
            n3 = R.style.com_facebook_button;
        }
        this.configureButton(context, attributeSet, n2, n3);
        this.analyticsButtonCreatedEventName = string2;
        this.analyticsButtonTappedEventName = string3;
        this.setClickable(true);
        this.setFocusable(true);
    }

    static /* synthetic */ void access$000(FacebookButtonBase facebookButtonBase, Context context) {
        if (CrashShieldHandler.isObjectCrashing(FacebookButtonBase.class)) {
            return;
        }
        try {
            facebookButtonBase.logButtonTapped(context);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookButtonBase.class);
            return;
        }
    }

    static /* synthetic */ View.OnClickListener access$100(FacebookButtonBase facebookButtonBase) {
        if (CrashShieldHandler.isObjectCrashing(FacebookButtonBase.class)) {
            return null;
        }
        try {
            facebookButtonBase = facebookButtonBase.internalOnClickListener;
            return facebookButtonBase;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookButtonBase.class);
            return null;
        }
    }

    static /* synthetic */ View.OnClickListener access$200(FacebookButtonBase facebookButtonBase) {
        if (CrashShieldHandler.isObjectCrashing(FacebookButtonBase.class)) {
            return null;
        }
        try {
            facebookButtonBase = facebookButtonBase.externalOnClickListener;
            return facebookButtonBase;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookButtonBase.class);
            return null;
        }
    }

    private void logButtonCreated(Context context) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            InternalAppEventsLogger internalAppEventsLogger = new InternalAppEventsLogger(context);
            internalAppEventsLogger.logEventImplicitly(this.analyticsButtonCreatedEventName);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    private void logButtonTapped(Context context) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            InternalAppEventsLogger internalAppEventsLogger = new InternalAppEventsLogger(context);
            internalAppEventsLogger.logEventImplicitly(this.analyticsButtonTappedEventName);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBackgroundAttributes(Context context, AttributeSet attributeSet, int n2, int n3) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            if (this.isInEditMode()) {
                return;
            }
            attributeSet = context.getTheme().obtainStyledAttributes(attributeSet, new int[]{16842964}, n2, n3);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
        try {
            if (attributeSet.hasValue(0)) {
                n2 = attributeSet.getResourceId(0, 0);
                if (n2 != 0) {
                    this.setBackgroundResource(n2);
                    return;
                } else {
                    this.setBackgroundColor(attributeSet.getColor(0, 0));
                }
                return;
            }
            this.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.com_facebook_blue));
            return;
        }
        finally {
            attributeSet.recycle();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseCompoundDrawableAttributes(Context context, AttributeSet attributeSet, int n2, int n3) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            context = context.getTheme().obtainStyledAttributes(attributeSet, new int[]{16843119, 16843117, 0x1010170, 16843118, 0x1010171}, n2, n3);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
        try {
            this.setCompoundDrawablesWithIntrinsicBounds(context.getResourceId(0, 0), context.getResourceId(1, 0), context.getResourceId(2, 0), context.getResourceId(3, 0));
            this.setCompoundDrawablePadding(context.getDimensionPixelSize(4, 0));
            return;
        }
        finally {
            context.recycle();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseContentAttributes(Context context, AttributeSet attributeSet, int n2, int n3) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            context = context.getTheme().obtainStyledAttributes(attributeSet, new int[]{16842966, 16842967, 16842968, 16842969}, n2, n3);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
        try {
            this.setPadding(context.getDimensionPixelSize(0, 0), context.getDimensionPixelSize(1, 0), context.getDimensionPixelSize(2, 0), context.getDimensionPixelSize(3, 0));
            return;
        }
        finally {
            context.recycle();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseTextAttributes(Context context, AttributeSet attributeSet, int n2, int n3) {
        TypedArray typedArray;
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            typedArray = context.getTheme().obtainStyledAttributes(attributeSet, new int[]{16842904}, n2, n3);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
        this.setTextColor(typedArray.getColorStateList(0));
        typedArray.recycle();
        typedArray = context.getTheme().obtainStyledAttributes(attributeSet, new int[]{16842927}, n2, n3);
        this.setGravity(typedArray.getInt(0, 17));
        typedArray.recycle();
        attributeSet = context.getTheme().obtainStyledAttributes(attributeSet, new int[]{16842901, 16842903, 16843087}, n2, n3);
        this.setTextSize(0, attributeSet.getDimensionPixelSize(0, 0));
        this.setTypeface(Typeface.defaultFromStyle((int)attributeSet.getInt(1, 1)));
        this.setText(attributeSet.getString(2));
        {
            catch (Throwable throwable) {
                attributeSet.recycle();
                throw throwable;
            }
        }
        attributeSet.recycle();
        return;
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
    }

    private void setupOnClickListener() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            View.OnClickListener onClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                        return;
                    }
                    try {
                        FacebookButtonBase.access$000(FacebookButtonBase.this, FacebookButtonBase.this.getContext());
                        if (FacebookButtonBase.access$100(FacebookButtonBase.this) != null) {
                            FacebookButtonBase.access$100(FacebookButtonBase.this).onClick(view);
                        } else if (FacebookButtonBase.access$200(FacebookButtonBase.this) != null) {
                            FacebookButtonBase.access$200(FacebookButtonBase.this).onClick(view);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                        return;
                    }
                }
            };
            super.setOnClickListener(onClickListener);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    protected void callExternalOnClickListener(View view) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            if (this.externalOnClickListener != null) {
                this.externalOnClickListener.onClick(view);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    protected void configureButton(Context context, AttributeSet attributeSet, int n2, int n3) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            this.parseBackgroundAttributes(context, attributeSet, n2, n3);
            this.parseCompoundDrawableAttributes(context, attributeSet, n2, n3);
            this.parseContentAttributes(context, attributeSet, n2, n3);
            this.parseTextAttributes(context, attributeSet, n2, n3);
            this.setupOnClickListener();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    protected Activity getActivity() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return null;
        }
        try {
            Context context = this.getContext();
            while (!(context instanceof Activity) && context instanceof ContextWrapper) {
                context = ((ContextWrapper)context).getBaseContext();
            }
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = new FacebookException("Unable to get Activity.");
            throw context;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return null;
        }
    }

    public int getCompoundPaddingLeft() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            int n2 = this.overrideCompoundPadding ? this.overrideCompoundPaddingLeft : super.getCompoundPaddingLeft();
            return n2;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    public int getCompoundPaddingRight() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            int n2 = this.overrideCompoundPadding ? this.overrideCompoundPaddingRight : super.getCompoundPaddingRight();
            return n2;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    protected abstract int getDefaultRequestCode();

    protected int getDefaultStyleResource() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            // empty if block
        }
        return 0;
    }

    public androidx.fragment.app.Fragment getFragment() {
        boolean bl = CrashShieldHandler.isObjectCrashing((Object)((Object)this));
        androidx.fragment.app.Fragment fragment = null;
        if (bl) {
            return null;
        }
        try {
            if (this.parentFragment != null) {
                fragment = this.parentFragment.getSupportFragment();
            }
            return fragment;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return null;
        }
    }

    public Fragment getNativeFragment() {
        boolean bl = CrashShieldHandler.isObjectCrashing((Object)((Object)this));
        Fragment fragment = null;
        if (bl) {
            return null;
        }
        try {
            if (this.parentFragment != null) {
                fragment = this.parentFragment.getNativeFragment();
            }
            return fragment;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return null;
        }
    }

    public int getRequestCode() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            int n2 = this.getDefaultRequestCode();
            return n2;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    protected int measureTextWidth(String string2) {
        double d2;
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            d2 = Math.ceil(this.getPaint().measureText(string2));
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
        return (int)d2;
    }

    protected void onAttachedToWindow() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            super.onAttachedToWindow();
            if (!this.isInEditMode()) {
                this.logButtonCreated(this.getContext());
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onDraw(Canvas canvas) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            int n2 = (this.getGravity() & 1) != 0 ? 1 : 0;
            if (n2 != 0) {
                n2 = this.getCompoundPaddingLeft();
                int n3 = this.getCompoundPaddingRight();
                int n4 = this.getCompoundDrawablePadding();
                n4 = Math.min((this.getWidth() - (n4 + n2) - n3 - this.measureTextWidth(this.getText().toString())) / 2, (n2 - this.getPaddingLeft()) / 2);
                this.overrideCompoundPaddingLeft = n2 - n4;
                this.overrideCompoundPaddingRight = n3 + n4;
                this.overrideCompoundPadding = true;
            }
            super.onDraw(canvas);
            this.overrideCompoundPadding = false;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    protected void onMeasure(int n2, int n3) {
        if (!true) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        super.onMeasure(n2, n3);
    }

    public void setFragment(Fragment fragment) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            FragmentWrapper fragmentWrapper;
            this.parentFragment = fragmentWrapper = new FragmentWrapper(fragment);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    public void setFragment(androidx.fragment.app.Fragment fragment) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            FragmentWrapper fragmentWrapper;
            this.parentFragment = fragmentWrapper = new FragmentWrapper(fragment);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    protected void setInternalOnClickListener(View.OnClickListener onClickListener) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            this.internalOnClickListener = onClickListener;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            this.externalOnClickListener = onClickListener;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }
}

