/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.SharedPreferences;
import com.facebook.AuthenticationToken;
import com.facebook.FacebookSdk;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0007R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/AuthenticationTokenCache;", "", "()V", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "cachedAuthenticationToken", "Lcom/facebook/AuthenticationToken;", "getCachedAuthenticationToken", "()Lcom/facebook/AuthenticationToken;", "clear", "", "hasCachedAuthenticationToken", "", "load", "save", "authenticationToken", "Companion", "facebook-core_release"}, k=1, mv={1, 5, 1})
public final class AuthenticationTokenCache {
    public static final String CACHED_AUTHENTICATION_TOKEN_KEY = "com.facebook.AuthenticationManager.CachedAuthenticationToken";
    public static final String CACHED_AUTHENTICATION_TOKEN_NONCE_KEY = "com.facebook.AuthenticationManager.CachedAuthenticationTokenNonce";
    public static final Companion Companion = new Companion(null);
    private final SharedPreferences sharedPreferences;

    public AuthenticationTokenCache() {
        SharedPreferences sharedPreferences = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.AccessTokenManager.SharedPreferences", 0);
        Intrinsics.checkNotNullExpressionValue(sharedPreferences, "FacebookSdk.getApplicati\u2026    Context.MODE_PRIVATE)");
        this(sharedPreferences);
    }

    public AuthenticationTokenCache(SharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter(sharedPreferences, "sharedPreferences");
        this.sharedPreferences = sharedPreferences;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AuthenticationToken getCachedAuthenticationToken() {
        boolean bl;
        String string2;
        String string3;
        Object var2_3;
        Object object;
        block6: {
            block5: {
                object = this.sharedPreferences;
                var2_3 = null;
                string3 = object.getString(CACHED_AUTHENTICATION_TOKEN_KEY, null);
                string2 = this.sharedPreferences.getString(CACHED_AUTHENTICATION_TOKEN_NONCE_KEY, null);
                object = string3;
                boolean bl2 = false;
                bl = object == null || object.length() == 0;
                object = var2_3;
                if (bl) return object;
                object = string2;
                if (object == null) break block5;
                bl = bl2;
                if (object.length() != 0) break block6;
            }
            bl = true;
        }
        object = var2_3;
        if (bl) return object;
        try {
            return new AuthenticationToken(string3, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return var2_3;
        }
    }

    private final boolean hasCachedAuthenticationToken() {
        return this.sharedPreferences.contains(CACHED_AUTHENTICATION_TOKEN_KEY);
    }

    public final void clear() {
        this.sharedPreferences.edit().remove(CACHED_AUTHENTICATION_TOKEN_KEY).apply();
        this.sharedPreferences.edit().remove(CACHED_AUTHENTICATION_TOKEN_NONCE_KEY).apply();
    }

    public final AuthenticationToken load() {
        AuthenticationToken authenticationToken = null;
        if (this.hasCachedAuthenticationToken()) {
            authenticationToken = this.getCachedAuthenticationToken();
        }
        return authenticationToken;
    }

    public final void save(AuthenticationToken authenticationToken) {
        Intrinsics.checkNotNullParameter(authenticationToken, "authenticationToken");
        this.sharedPreferences.edit().putString(CACHED_AUTHENTICATION_TOKEN_KEY, authenticationToken.getToken()).putString(CACHED_AUTHENTICATION_TOKEN_NONCE_KEY, authenticationToken.getExpectedNonce()).apply();
    }

    @Metadata(d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/AuthenticationTokenCache$Companion;", "", "()V", "CACHED_AUTHENTICATION_TOKEN_KEY", "", "CACHED_AUTHENTICATION_TOKEN_NONCE_KEY", "facebook-core_release"}, k=1, mv={1, 5, 1})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

