/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Parcel;
import android.os.Parcelable;
import com.facebook.AuthenticationTokenClaims;
import com.facebook.AuthenticationTokenHeader;
import com.facebook.internal.Validate;
import com.facebook.internal.security.OidcSecurityUtil;
import java.io.IOException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0016J(\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0017H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006'"}, d2={"Lcom/facebook/AuthenticationToken;", "Landroid/os/Parcelable;", "token", "", "expectedNonce", "(Ljava/lang/String;Ljava/lang/String;)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "claims", "Lcom/facebook/AuthenticationTokenClaims;", "getClaims", "()Lcom/facebook/AuthenticationTokenClaims;", "getExpectedNonce", "()Ljava/lang/String;", "header", "Lcom/facebook/AuthenticationTokenHeader;", "getHeader", "()Lcom/facebook/AuthenticationTokenHeader;", "signature", "getSignature", "getToken", "describeContents", "", "equals", "", "other", "", "hashCode", "isValidSignature", "headerString", "claimsString", "sigString", "kid", "writeToParcel", "", "dest", "flags", "Companion", "facebook-core_release"}, k=1, mv={1, 5, 1})
public final class AuthenticationToken
implements Parcelable {
    public static final String AUTHENTICATION_TOKEN_KEY = "id_token";
    public static final Parcelable.Creator<AuthenticationToken> CREATOR;
    public static final Companion Companion;
    private final AuthenticationTokenClaims claims;
    private final String expectedNonce;
    private final AuthenticationTokenHeader header;
    private final String signature;
    private final String token;

    static {
        Companion = new Companion(null);
        CREATOR = (Parcelable.Creator)new Parcelable.Creator<AuthenticationToken>(){

            public AuthenticationToken createFromParcel(Parcel parcel) {
                Intrinsics.checkNotNullParameter(parcel, "source");
                return new AuthenticationToken(parcel);
            }

            public AuthenticationToken[] newArray(int n2) {
                return new AuthenticationToken[n2];
            }
        };
    }

    public AuthenticationToken(Parcel object) {
        Intrinsics.checkNotNullParameter(object, "parcel");
        Object object2 = object.readString();
        Validate.notNullOrEmpty((String)object2, (String)"token");
        if (object2 != null) {
            this.token = object2;
            object = object.readString();
            Validate.notNull((Object)object, (String)"expectedNonce");
            if (object != null) {
                this.expectedNonce = object;
                object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
                this.header = new AuthenticationTokenHeader((String)object2.get(0));
                this.claims = new AuthenticationTokenClaims((String)object2.get(1), (String)object);
                this.signature = (String)object2.get(2);
                return;
            }
            throw (Throwable)new IllegalStateException("Required value was null.".toString());
        }
        throw (Throwable)new IllegalStateException("Required value was null.".toString());
    }

    public AuthenticationToken(String string2, String string3) {
        Intrinsics.checkNotNullParameter(string2, "token");
        Intrinsics.checkNotNullParameter(string3, "expectedNonce");
        Validate.notEmpty((String)string2, (String)"token");
        Validate.notEmpty((String)string3, (String)"expectedNonce");
        Object object = StringsKt.split$default((CharSequence)string2, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
        boolean bl = object.size() == 3;
        if (bl) {
            String string4 = (String)object.get(0);
            String string5 = (String)object.get(1);
            object = (String)object.get(2);
            this.token = string2;
            this.expectedNonce = string3;
            this.header = new AuthenticationTokenHeader(string4);
            this.claims = new AuthenticationTokenClaims(string5, string3);
            if (this.isValidSignature(string4, string5, (String)object, this.header.getKid())) {
                this.signature = object;
                return;
            }
            throw (Throwable)new IllegalArgumentException("Invalid Signature".toString());
        }
        throw (Throwable)new IllegalArgumentException("Invalid IdToken string".toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidSignature(String string2, String string3, String string4, String object) {
        object = OidcSecurityUtil.getRawKeyFromEndPoint((String)object);
        if (object == null) return false;
        try {
            object = OidcSecurityUtil.getPublicKeyFromString((String)object);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append('.');
            stringBuilder.append(string3);
            return OidcSecurityUtil.verify((PublicKey)object, (String)stringBuilder.toString(), (String)string4);
        }
        catch (IOException | InvalidKeySpecException exception) {
            return false;
        }
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AuthenticationToken)) {
            return false;
        }
        return Intrinsics.areEqual(this.token, ((AuthenticationToken)object).token);
    }

    public final AuthenticationTokenClaims getClaims() {
        return this.claims;
    }

    public final String getExpectedNonce() {
        return this.expectedNonce;
    }

    public final AuthenticationTokenHeader getHeader() {
        return this.header;
    }

    public final String getSignature() {
        return this.signature;
    }

    public final String getToken() {
        return this.token;
    }

    public int hashCode() {
        return 527 + this.token.hashCode();
    }

    public void writeToParcel(Parcel parcel, int n2) {
        Intrinsics.checkNotNullParameter(parcel, "dest");
        parcel.writeString(this.token);
        parcel.writeString(this.expectedNonce);
    }

    @Metadata(d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/AuthenticationToken$Companion;", "", "()V", "AUTHENTICATION_TOKEN_KEY", "", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/AuthenticationToken;", "facebook-core_release"}, k=1, mv={1, 5, 1})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

