/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.content.Context;
import android.graphics.Point;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.Utils;
import com.applovin.impl.sdk.utils.f;
import com.applovin.sdk.AppLovinSdk;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AppLovinSdkUtils {
    private static final Handler a = new Handler(Looper.getMainLooper());

    public static int dpToPx(Context context, int n2) {
        return (int)TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static boolean isSdkVersionGreaterThanOrEqualTo(String string2) {
        boolean bl = AppLovinSdk.VERSION_CODE >= Utils.toVersionCode((String)string2);
        return bl;
    }

    public static boolean isTablet(Context context) {
        Point point = f.a((Context)context);
        boolean bl = Math.min(point.x, point.y) >= AppLovinSdkUtils.dpToPx(context, 600);
        return bl;
    }

    public static boolean isValidString(String string2) {
        return TextUtils.isEmpty((CharSequence)string2) ^ true;
    }

    public static int pxToDp(Context context, int n2) {
        return (int)Math.ceil((float)n2 / context.getResources().getDisplayMetrics().density);
    }

    public static void runOnUiThread(Runnable runnable2) {
        AppLovinSdkUtils.runOnUiThread(false, runnable2);
    }

    public static void runOnUiThread(boolean bl, Runnable runnable2) {
        if (!bl && Utils.isMainThread()) {
            runnable2.run();
        } else {
            a.post(runnable2);
        }
    }

    public static void runOnUiThreadDelayed(Runnable runnable2, long l2) {
        AppLovinSdkUtils.runOnUiThreadDelayed(runnable2, l2, a);
    }

    public static void runOnUiThreadDelayed(Runnable runnable2, long l2, Handler handler) {
        if (l2 > 0L) {
            handler.postDelayed(runnable2, l2);
        } else if (Utils.isMainThread()) {
            runnable2.run();
        } else {
            handler.post(runnable2);
        }
    }

    public static Map<String, String> toMap(JSONObject jSONObject) throws JSONException {
        return JsonUtils.toStringMap((JSONObject)jSONObject);
    }

    public static final class Size {
        private int a;
        private int b;

        private Size() {
        }

        public Size(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (!(object instanceof Size)) {
                return false;
            }
            if (this.a != ((Size)(object = (Size)object)).getWidth() || this.b != ((Size)object).getHeight()) {
                bl = false;
            }
            return bl;
        }

        public int getHeight() {
            return this.b;
        }

        public int getWidth() {
            return this.a;
        }

        public int hashCode() {
            int n2 = this.b;
            int n3 = this.a;
            return n2 ^ (n3 >>> 16 | n3 << 16);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.a);
            stringBuilder.append("x");
            stringBuilder.append(this.b);
            return stringBuilder.toString();
        }
    }
}

