/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.unity;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxAdView;
import com.applovin.mediation.ads.MaxInterstitialAd;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.applovin.mediation.ads.MaxRewardedInterstitialAd;
import com.applovin.mediation.unity.Utils;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkSettings;
import com.applovin.sdk.AppLovinSdkUtils;
import com.applovin.sdk.AppLovinUserService;
import com.applovin.sdk.AppLovinVariableService;
import com.unity3d.player.UnityPlayer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class MaxUnityAdManager
implements MaxAdListener,
MaxAdViewAdListener,
MaxRewardedAdListener,
MaxAdRevenueListener,
AppLovinVariableService.OnVariablesUpdateListener,
AppLovinUserService.OnConsentDialogDismissListener {
    private static final Point DEFAULT_AD_VIEW_OFFSET;
    private static final String DEFAULT_AD_VIEW_POSITION = "top_left";
    private static final String SDK_TAG = "AppLovinSdk";
    private static final String SERIALIZED_KEY_VALUE_PAIR_SEPARATOR;
    private static final String SERIALIZED_KEY_VALUE_SEPARATOR;
    private static final String TAG = "MaxUnityAdManager";
    private static final String VERSION = "4.3.7";
    private static WeakReference<Activity> currentActivity;
    private static MaxUnityAdManager instance;
    private static final ScheduledThreadPoolExecutor sThreadPoolExecutor;
    private final Map<String, MaxAd> mAdInfoMap;
    private final Object mAdInfoMapLock;
    private final List<String> mAdUnitIdsToShowAfterCreate;
    private final Map<String, MaxAdFormat> mAdViewAdFormats;
    private final Map<String, Map<String, String>> mAdViewExtraParametersToSetAfterCreate;
    private final Map<String, Point> mAdViewOffsets;
    private final Map<String, String> mAdViewPositions;
    private final Map<String, Integer> mAdViewWidths;
    private final Map<String, MaxAdView> mAdViews;
    private final Map<String, Integer> mCrossPromoAdViewHeights;
    private final Map<String, Integer> mCrossPromoAdViewRotations;
    private final Set<String> mDisabledAdaptiveBannerAdUnitIds;
    private final Map<String, MaxInterstitialAd> mInterstitials;
    private Integer mPublisherBannerBackgroundColor = null;
    private final Map<String, MaxRewardedAd> mRewardedAds;
    private final Map<String, MaxRewardedInterstitialAd> mRewardedInterstitialAds;
    private View mSafeAreaBackground;
    private AppLovinSdk sdk;

    static {
        SERIALIZED_KEY_VALUE_SEPARATOR = String.valueOf('\u001c');
        SERIALIZED_KEY_VALUE_PAIR_SEPARATOR = String.valueOf('\u001d');
        DEFAULT_AD_VIEW_OFFSET = new Point(0, 0);
        sThreadPoolExecutor = new ScheduledThreadPoolExecutor(3, new SdkThreadFactory());
    }

    public MaxUnityAdManager() {
        this(null);
    }

    private MaxUnityAdManager(Activity activity) {
        currentActivity = new WeakReference<Activity>(activity);
        this.mInterstitials = new HashMap<String, MaxInterstitialAd>(2);
        this.mRewardedAds = new HashMap<String, MaxRewardedAd>(2);
        this.mRewardedInterstitialAds = new HashMap<String, MaxRewardedInterstitialAd>(2);
        this.mAdViews = new HashMap<String, MaxAdView>(2);
        this.mAdViewAdFormats = new HashMap<String, MaxAdFormat>(2);
        this.mAdViewPositions = new HashMap<String, String>(2);
        this.mAdViewOffsets = new HashMap<String, Point>(2);
        this.mAdViewWidths = new HashMap<String, Integer>(2);
        this.mCrossPromoAdViewHeights = new HashMap<String, Integer>(2);
        this.mCrossPromoAdViewRotations = new HashMap<String, Integer>(2);
        this.mAdInfoMap = new HashMap<String, MaxAd>();
        this.mAdInfoMapLock = new Object();
        this.mAdViewExtraParametersToSetAfterCreate = new HashMap<String, Map<String, String>>(1);
        this.mAdUnitIdsToShowAfterCreate = new ArrayList<String>(2);
        this.mDisabledAdaptiveBannerAdUnitIds = new HashSet<String>(2);
        MaxUnityAdManager.getCurrentActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MaxUnityAdManager.access$102(MaxUnityAdManager.this, new View((Context)MaxUnityAdManager.getCurrentActivity()));
                MaxUnityAdManager.this.mSafeAreaBackground.setVisibility(8);
                MaxUnityAdManager.this.mSafeAreaBackground.setBackgroundColor(0);
                MaxUnityAdManager.this.mSafeAreaBackground.setClickable(false);
                FrameLayout frameLayout = new FrameLayout((Context)MaxUnityAdManager.getCurrentActivity());
                frameLayout.addView(MaxUnityAdManager.this.mSafeAreaBackground, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
                MaxUnityAdManager.getCurrentActivity().addContentView((View)frameLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
            }
        });
        MaxUnityAdManager.getCurrentActivity().getWindow().getDecorView().getRootView().addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View object, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
                n2 = n2 == n6 && n4 == n8 && n5 == n9 && n3 == n7 ? 0 : 1;
                if (n2 == 0) {
                    return;
                }
                for (Map.Entry entry : MaxUnityAdManager.this.mAdViewAdFormats.entrySet()) {
                    MaxUnityAdManager.this.positionAdView((String)entry.getKey(), (MaxAdFormat)entry.getValue());
                }
            }
        });
    }

    static /* synthetic */ View access$102(MaxUnityAdManager maxUnityAdManager, View view) {
        maxUnityAdManager.mSafeAreaBackground = view;
        return view;
    }

    static /* synthetic */ Integer access$2102(MaxUnityAdManager maxUnityAdManager, Integer n2) {
        maxUnityAdManager.mPublisherBannerBackgroundColor = n2;
        return n2;
    }

    private void createAdView(final String string2, final MaxAdFormat maxAdFormat, final String string3, final Point point) {
        Utils.runSafelyOnUiThread((Activity)MaxUnityAdManager.getCurrentActivity(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Iterator iterator2 = MaxUnityAdManager.this;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Creating ");
                stringBuilder.append(maxAdFormat.getLabel());
                stringBuilder.append(" with ad unit id \"");
                stringBuilder.append(string2);
                stringBuilder.append("\" and position: \"");
                stringBuilder.append(string3);
                stringBuilder.append("\"");
                ((MaxUnityAdManager)((Object)iterator2)).d(stringBuilder.toString());
                stringBuilder = MaxUnityAdManager.this.retrieveAdView(string2, maxAdFormat, string3, point);
                if (stringBuilder == null) {
                    iterator2 = MaxUnityAdManager.this;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(maxAdFormat.getLabel());
                    stringBuilder.append(" does not exist");
                    ((MaxUnityAdManager)((Object)iterator2)).e(stringBuilder.toString());
                    return;
                }
                MaxUnityAdManager.this.mSafeAreaBackground.setVisibility(8);
                stringBuilder.setVisibility(8);
                if (stringBuilder.getParent() == null) {
                    Activity object = MaxUnityAdManager.getCurrentActivity();
                    iterator2 = new RelativeLayout((Context)object);
                    object.addContentView((View)iterator2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                    iterator2.addView((View)stringBuilder);
                    MaxUnityAdManager.this.mAdViewAdFormats.put(string2, maxAdFormat);
                    MaxUnityAdManager.this.positionAdView(string2, maxAdFormat);
                }
                if (MaxUnityAdManager.this.mAdViewExtraParametersToSetAfterCreate.containsKey(string2) && (iterator2 = (Map)MaxUnityAdManager.this.mAdViewExtraParametersToSetAfterCreate.get(string2)) != null) {
                    for (Map.Entry entry : iterator2.entrySet()) {
                        stringBuilder.setExtraParameter((String)entry.getKey(), (String)entry.getValue());
                        MaxUnityAdManager.this.maybeHandleExtraParameterChanges(string2, maxAdFormat, (String)entry.getKey(), (String)entry.getValue());
                    }
                    MaxUnityAdManager.this.mAdViewExtraParametersToSetAfterCreate.remove(string2);
                }
                stringBuilder.loadAd();
                if (MaxUnityAdManager.this.mAdUnitIdsToShowAfterCreate.contains(string2)) {
                    MaxUnityAdManager.this.showAdView(string2, maxAdFormat);
                    MaxUnityAdManager.this.mAdUnitIdsToShowAfterCreate.remove(string2);
                }
            }
        });
    }

    private void d(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[MaxUnityAdManager] ");
        stringBuilder.append(string2);
        Log.d((String)SDK_TAG, (String)stringBuilder.toString());
    }

    private static Map<String, String> deserializeParameters(String stringArray) {
        if (!TextUtils.isEmpty((CharSequence)stringArray)) {
            stringArray = stringArray.split(SERIALIZED_KEY_VALUE_PAIR_SEPARATOR);
            HashMap<String, String> hashMap = new HashMap<String, String>(stringArray.length);
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String[] stringArray2 = stringArray[i2].split(SERIALIZED_KEY_VALUE_SEPARATOR);
                if (stringArray2.length != 2) continue;
                hashMap.put(stringArray2[0], stringArray2[1]);
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    private void destroyAdView(final String string2, final MaxAdFormat maxAdFormat) {
        Utils.runSafelyOnUiThread((Activity)MaxUnityAdManager.getCurrentActivity(), (Runnable)new Runnable(){

            @Override
            public void run() {
                MaxUnityAdManager maxUnityAdManager = MaxUnityAdManager.this;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Destroying ");
                stringBuilder.append(maxAdFormat.getLabel());
                stringBuilder.append(" with ad unit id \"");
                stringBuilder.append(string2);
                stringBuilder.append("\"");
                maxUnityAdManager.d(stringBuilder.toString());
                stringBuilder = MaxUnityAdManager.this.retrieveAdView(string2, maxAdFormat);
                if (stringBuilder == null) {
                    maxUnityAdManager = MaxUnityAdManager.this;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(maxAdFormat.getLabel());
                    stringBuilder.append(" does not exist");
                    maxUnityAdManager.e(stringBuilder.toString());
                    return;
                }
                maxUnityAdManager = stringBuilder.getParent();
                if (maxUnityAdManager instanceof ViewGroup) {
                    ((ViewGroup)maxUnityAdManager).removeView((View)stringBuilder);
                }
                stringBuilder.setListener(null);
                stringBuilder.setRevenueListener(null);
                stringBuilder.destroy();
                MaxUnityAdManager.this.mAdViews.remove(string2);
                MaxUnityAdManager.this.mAdViewAdFormats.remove(string2);
                MaxUnityAdManager.this.mAdViewPositions.remove(string2);
                MaxUnityAdManager.this.mAdViewOffsets.remove(string2);
                MaxUnityAdManager.this.mAdViewWidths.remove(string2);
                MaxUnityAdManager.this.mCrossPromoAdViewHeights.remove(string2);
                MaxUnityAdManager.this.mCrossPromoAdViewRotations.remove(string2);
                MaxUnityAdManager.this.mDisabledAdaptiveBannerAdUnitIds.remove(string2);
            }
        });
    }

    private void e(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[MaxUnityAdManager] ");
        stringBuilder.append(string2);
        Log.e((String)SDK_TAG, (String)stringBuilder.toString());
    }

    private static void forwardUnityEvent(final Map<String, String> map) {
        sThreadPoolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                UnityPlayer.UnitySendMessage((String)"MaxSdkCallbacks", (String)"ForwardEvent", (String)MaxUnityAdManager.propsStrFromDictionary(map));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AppLovinSdkSettings generateSdkSettings(String object, String iterator2, Context context) {
        context = new AppLovinSdkSettings(context);
        context.setInitializationAdUnitIds(Arrays.asList(((String)object).split(",")));
        iterator2 = MaxUnityAdManager.deserializeParameters(iterator2);
        if (AppLovinSdk.VERSION_CODE < 91201) return context;
        try {
            object = AppLovinSdkSettings.class.getDeclaredField("metaData");
            ((Field)object).setAccessible(true);
            object = (Map)((Field)object).get(context);
            iterator2 = iterator2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                object.put(entry.getKey(), entry.getValue());
            }
            return context;
        }
        catch (Exception exception) {
            return context;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MaxAd getAd(String string2) {
        Object object = this.mAdInfoMapLock;
        synchronized (object) {
            return this.mAdInfoMap.get(string2);
        }
    }

    private Map<String, String> getAdInfo(MaxAd maxAd) {
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        hashMap.put("adUnitId", maxAd.getAdUnitId());
        hashMap.put("networkName", maxAd.getNetworkName());
        hashMap.put("networkPlacement", maxAd.getNetworkPlacement());
        boolean bl = TextUtils.isEmpty((CharSequence)maxAd.getCreativeId());
        String string2 = "";
        String string3 = !bl ? maxAd.getCreativeId() : "";
        hashMap.put("creativeId", string3);
        string3 = string2;
        if (!TextUtils.isEmpty((CharSequence)maxAd.getPlacement())) {
            string3 = maxAd.getPlacement();
        }
        hashMap.put("placement", string3);
        hashMap.put("revenue", String.valueOf(maxAd.getRevenue()));
        return hashMap;
    }

    private MaxAdFormat getAdViewAdFormat(String string2) {
        if (this.mAdViewAdFormats.containsKey(string2)) {
            return this.mAdViewAdFormats.get(string2);
        }
        return MaxUnityAdManager.getDeviceSpecificAdViewAdFormat();
    }

    private String getAdViewLayout(String object, MaxAdFormat object2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Getting ");
        stringBuilder.append(object2.getLabel());
        stringBuilder.append(" absolute position with ad unit id \"");
        stringBuilder.append((String)object);
        stringBuilder.append("\"");
        this.d(stringBuilder.toString());
        object = this.retrieveAdView((String)object, (MaxAdFormat)object2);
        if (object == null) {
            object = new StringBuilder();
            ((StringBuilder)object).append(object2.getLabel());
            ((StringBuilder)object).append(" does not exist");
            this.e(((StringBuilder)object).toString());
            return "";
        }
        object2 = new int[2];
        object.getLocationOnScreen((int[])object2);
        int n2 = AppLovinSdkUtils.pxToDp((Context)MaxUnityAdManager.getCurrentActivity(), (int)object2[0]);
        int n3 = AppLovinSdkUtils.pxToDp((Context)MaxUnityAdManager.getCurrentActivity(), (int)object2[1]);
        int n4 = AppLovinSdkUtils.pxToDp((Context)MaxUnityAdManager.getCurrentActivity(), object.getWidth());
        int n5 = AppLovinSdkUtils.pxToDp((Context)MaxUnityAdManager.getCurrentActivity(), object.getHeight());
        object = new HashMap(4);
        object.put("origin_x", String.valueOf(n2));
        object.put("origin_y", String.valueOf(n3));
        object.put("width", String.valueOf(n4));
        object.put("height", String.valueOf(n5));
        return MaxUnityAdManager.propsStrFromDictionary((Map<String, String>)object);
    }

    public static float getAdaptiveBannerHeight(float f2) {
        return MaxUnityAdManager.getDeviceSpecificAdViewAdFormat().getAdaptiveSize((int)f2, MaxUnityAdManager.getCurrentActivity()).getHeight();
    }

    private static Activity getCurrentActivity() {
        return Utils.getCurrentActivity();
    }

    private Map<String, String> getDefaultAdEventParameters(String string2, MaxAd object) {
        object = this.getAdInfo((MaxAd)object);
        object.put("name", string2);
        return object;
    }

    private static MaxAdFormat getDeviceSpecificAdViewAdFormat() {
        MaxAdFormat maxAdFormat = AppLovinSdkUtils.isTablet((Context)MaxUnityAdManager.getCurrentActivity()) ? MaxAdFormat.LEADER : MaxAdFormat.BANNER;
        return maxAdFormat;
    }

    public static MaxUnityAdManager getInstance(Activity activity) {
        if (instance == null) {
            instance = new MaxUnityAdManager(activity);
        } else {
            currentActivity = new WeakReference<Activity>(activity);
        }
        return instance;
    }

    private static Point getOffsetPixels(float f2, float f3, Context context) {
        return new Point(AppLovinSdkUtils.dpToPx(context, (int)f2), AppLovinSdkUtils.dpToPx(context, (int)f3));
    }

    private static Insets getSafeInsets() {
        Insets insets = new Insets();
        if (Build.VERSION.SDK_INT < 28) {
            return insets;
        }
        Window window = MaxUnityAdManager.getCurrentActivity().getWindow();
        if (window == null) {
            return insets;
        }
        if ((window = window.getDecorView().getRootWindowInsets()) == null) {
            return insets;
        }
        if ((window = window.getDisplayCutout()) == null) {
            return insets;
        }
        insets.left = window.getSafeInsetLeft();
        insets.top = window.getSafeInsetTop();
        insets.right = window.getSafeInsetRight();
        insets.bottom = window.getSafeInsetBottom();
        return insets;
    }

    private void hideAdView(final String string2, final MaxAdFormat maxAdFormat) {
        Utils.runSafelyOnUiThread((Activity)MaxUnityAdManager.getCurrentActivity(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Object object = MaxUnityAdManager.this;
                Object object2 = new StringBuilder();
                ((StringBuilder)object2).append("Hiding ");
                ((StringBuilder)object2).append(maxAdFormat.getLabel());
                ((StringBuilder)object2).append(" with ad unit id \"");
                ((StringBuilder)object2).append(string2);
                ((StringBuilder)object2).append("\"");
                ((MaxUnityAdManager)object).d(((StringBuilder)object2).toString());
                MaxUnityAdManager.this.mAdUnitIdsToShowAfterCreate.remove(string2);
                object2 = MaxUnityAdManager.this.retrieveAdView(string2, maxAdFormat);
                if (object2 == null) {
                    object2 = MaxUnityAdManager.this;
                    object = new StringBuilder();
                    ((StringBuilder)object).append(maxAdFormat.getLabel());
                    ((StringBuilder)object).append(" does not exist");
                    ((MaxUnityAdManager)object2).e(((StringBuilder)object).toString());
                    return;
                }
                MaxUnityAdManager.this.mSafeAreaBackground.setVisibility(8);
                object2.setVisibility(8);
                object2.stopAutoRefresh();
            }
        });
    }

    private void logInvalidAdFormat(MaxAdFormat maxAdFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("invalid ad format: ");
        stringBuilder.append(maxAdFormat);
        this.logStackTrace(new IllegalStateException(stringBuilder.toString()));
    }

    private void logStackTrace(Exception exception) {
        this.e(Log.getStackTraceString((Throwable)exception));
    }

    private void maybeHandleExtraParameterChanges(String string2, MaxAdFormat maxAdFormat, String string3, String string4) {
        if (MaxAdFormat.MREC != maxAdFormat) {
            if ("force_banner".equalsIgnoreCase(string3)) {
                maxAdFormat = Boolean.parseBoolean(string4) ? MaxAdFormat.BANNER : MaxUnityAdManager.getDeviceSpecificAdViewAdFormat();
                this.mAdViewAdFormats.put(string2, maxAdFormat);
                this.positionAdView(string2, maxAdFormat);
            } else if ("adaptive_banner".equalsIgnoreCase(string3)) {
                if (Boolean.parseBoolean(string4)) {
                    this.mDisabledAdaptiveBannerAdUnitIds.remove(string2);
                } else {
                    this.mDisabledAdaptiveBannerAdUnitIds.add(string2);
                }
                this.positionAdView(string2, maxAdFormat);
            }
        }
    }

    private void positionAdView(MaxAd maxAd) {
        this.positionAdView(maxAd.getAdUnitId(), maxAd.getFormat());
    }

    private void positionAdView(final String string2, final MaxAdFormat maxAdFormat) {
        MaxUnityAdManager.getCurrentActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int n2;
                int n3;
                int n4;
                RelativeLayout.LayoutParams layoutParams;
                int n5;
                int n6;
                int n7;
                Object object;
                block29: {
                    int n8;
                    int n9;
                    Insets insets;
                    String string22;
                    Rect rect;
                    MaxAdView maxAdView;
                    block28: {
                        maxAdView = MaxUnityAdManager.this.retrieveAdView(string2, maxAdFormat);
                        if (maxAdView == null) {
                            MaxUnityAdManager maxUnityAdManager = MaxUnityAdManager.this;
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(maxAdFormat.getLabel());
                            stringBuilder.append(" does not exist");
                            maxUnityAdManager.e(stringBuilder.toString());
                            return;
                        }
                        object = (RelativeLayout)maxAdView.getParent();
                        if (object == null) {
                            MaxUnityAdManager maxUnityAdManager = MaxUnityAdManager.this;
                            object = new StringBuilder();
                            ((StringBuilder)object).append(maxAdFormat.getLabel());
                            ((StringBuilder)object).append("'s parent does not exist");
                            maxUnityAdManager.e(((StringBuilder)object).toString());
                            return;
                        }
                        rect = new Rect();
                        object.getWindowVisibleDisplayFrame(rect);
                        string22 = (String)MaxUnityAdManager.this.mAdViewPositions.get(string2);
                        Point point = (Point)MaxUnityAdManager.this.mAdViewOffsets.get(string2);
                        insets = MaxUnityAdManager.getSafeInsets();
                        boolean bl = MaxUnityAdManager.this.mDisabledAdaptiveBannerAdUnitIds.contains(string2);
                        boolean bl2 = MaxUnityAdManager.this.mAdViewWidths.containsKey(string2);
                        boolean bl3 = MaxUnityAdManager.this.mCrossPromoAdViewHeights.containsKey(string2);
                        boolean bl4 = MaxUnityAdManager.this.mCrossPromoAdViewRotations.containsKey(string2);
                        if (bl2) {
                            n7 = (Integer)MaxUnityAdManager.this.mAdViewWidths.get(string2);
                        } else if (!"top_center".equalsIgnoreCase(string22) && !"bottom_center".equalsIgnoreCase(string22)) {
                            n7 = maxAdFormat.getSize().getWidth();
                        } else {
                            n7 = rect.width();
                            n7 = AppLovinSdkUtils.pxToDp((Context)MaxUnityAdManager.getCurrentActivity(), n7);
                        }
                        n9 = bl3 ? (Integer)MaxUnityAdManager.this.mCrossPromoAdViewHeights.get(string2) : ((maxAdFormat == MaxAdFormat.BANNER || maxAdFormat == MaxAdFormat.LEADER) && !bl ? maxAdFormat.getAdaptiveSize(n7, MaxUnityAdManager.getCurrentActivity()).getHeight() : maxAdFormat.getSize().getHeight());
                        n6 = AppLovinSdkUtils.dpToPx((Context)MaxUnityAdManager.getCurrentActivity(), n7);
                        n5 = AppLovinSdkUtils.dpToPx((Context)MaxUnityAdManager.getCurrentActivity(), n9);
                        layoutParams = (RelativeLayout.LayoutParams)maxAdView.getLayoutParams();
                        layoutParams.height = n5;
                        maxAdView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        maxAdView.setRotation(0.0f);
                        maxAdView.setTranslationX(0.0f);
                        layoutParams.setMargins(0, 0, 0, 0);
                        n8 = insets.left + point.x;
                        n4 = insets.top;
                        n3 = point.y;
                        n9 = insets.right;
                        n2 = insets.bottom;
                        if ("centered".equalsIgnoreCase(string22)) {
                            n7 = 17;
                            layoutParams.width = MaxAdFormat.MREC != maxAdFormat && !bl2 ? -1 : n6;
                        } else {
                            n7 = string22.contains("top") ? 48 : (string22.contains("bottom") ? 80 : 0);
                            if (string22.contains("center")) {
                                n7 |= 1;
                                layoutParams.width = MaxAdFormat.MREC != maxAdFormat && !bl2 ? -1 : n6;
                                bl = string22.contains("left");
                                bl2 = string22.contains("right");
                                if (bl || bl2) {
                                    n6 = n7 | 0x10;
                                    if (MaxAdFormat.MREC == maxAdFormat) {
                                        n7 = string22.contains("left") ? 3 : 5;
                                        n7 = n6 | n7;
                                    } else {
                                        int n10 = rect.width() - insets.left - insets.right;
                                        n7 = rect.height() - insets.top - insets.bottom;
                                        int n11 = Math.max(n10, n7);
                                        int n12 = Math.min(n10, n7);
                                        n7 = n7 > n10 ? -1 : 1;
                                        n7 = n7 * (n11 - n12) / 2;
                                        n8 += n7;
                                        n9 += n7;
                                        n7 = n5 = n10 / 2 - n5 / 2;
                                        if (bl) {
                                            n7 = -n5;
                                        }
                                        maxAdView.setTranslationX((float)n7);
                                        maxAdView.setRotation(90.0f);
                                        n7 = n6;
                                    }
                                    object.setBackgroundColor(0);
                                }
                            } else {
                                layoutParams.width = n6;
                                if (string22.contains("left")) {
                                    n7 |= 3;
                                } else if (string22.contains("right")) {
                                    n7 |= 5;
                                }
                            }
                        }
                        if (bl4) {
                            maxAdView.setRotation((float)((Integer)MaxUnityAdManager.this.mCrossPromoAdViewRotations.get(string2)).intValue());
                            object.setBackgroundColor(0);
                        }
                        if (MaxAdFormat.BANNER == maxAdFormat) break block28;
                        n6 = n9;
                        n5 = n8;
                        if (MaxAdFormat.LEADER != maxAdFormat) break block29;
                    }
                    if (MaxUnityAdManager.this.mPublisherBannerBackgroundColor != null) {
                        rect = (FrameLayout.LayoutParams)MaxUnityAdManager.this.mSafeAreaBackground.getLayoutParams();
                        if ("top_center".equals(string22)) {
                            rect.height = insets.top;
                            rect.width = -1;
                            MaxUnityAdManager.this.mSafeAreaBackground.setVisibility(maxAdView.getVisibility());
                            n8 -= insets.left;
                            n9 -= insets.right;
                            n6 = 49;
                        } else if ("bottom_center".equals(string22)) {
                            rect.height = insets.bottom;
                            rect.width = -1;
                            MaxUnityAdManager.this.mSafeAreaBackground.setVisibility(maxAdView.getVisibility());
                            n8 -= insets.left;
                            n9 -= insets.right;
                            n6 = 81;
                        } else {
                            MaxUnityAdManager.this.mSafeAreaBackground.setVisibility(8);
                            n6 = 1;
                        }
                        rect.gravity = n6;
                        MaxUnityAdManager.this.mSafeAreaBackground.requestLayout();
                        n6 = n9;
                        n5 = n8;
                    } else {
                        MaxUnityAdManager.this.mSafeAreaBackground.setVisibility(8);
                        n5 = n8;
                        n6 = n9;
                    }
                }
                layoutParams.setMargins(n5, n4 + n3, n6, n2);
                object.setGravity(n7);
            }
        });
    }

    public static String propsStrFromDictionary(Map<String, String> object2) {
        StringBuilder stringBuilder = new StringBuilder(64);
        for (Map.Entry entry : object2.entrySet()) {
            stringBuilder.append((String)entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append((String)entry.getValue());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private MaxAdView retrieveAdView(String string2, MaxAdFormat maxAdFormat) {
        return this.retrieveAdView(string2, maxAdFormat, null, null);
    }

    private MaxAdView retrieveAdView(String string2, MaxAdFormat maxAdFormat, String string3, Point point) {
        MaxAdView maxAdView;
        MaxAdView maxAdView2 = maxAdView = this.mAdViews.get(string2);
        if (maxAdView == null) {
            maxAdView2 = maxAdView;
            if (string3 != null) {
                maxAdView2 = maxAdView;
                if (point != null) {
                    maxAdView2 = new MaxAdView(string2, maxAdFormat, this.sdk, MaxUnityAdManager.getCurrentActivity());
                    maxAdView2.setListener((MaxAdViewAdListener)this);
                    maxAdView2.setRevenueListener((MaxAdRevenueListener)this);
                    this.mAdViews.put(string2, maxAdView2);
                    this.mAdViewPositions.put(string2, string3);
                    this.mAdViewOffsets.put(string2, point);
                }
            }
        }
        return maxAdView2;
    }

    private MaxInterstitialAd retrieveInterstitial(String string2) {
        MaxInterstitialAd maxInterstitialAd;
        MaxInterstitialAd maxInterstitialAd2 = maxInterstitialAd = this.mInterstitials.get(string2);
        if (maxInterstitialAd == null) {
            maxInterstitialAd2 = new MaxInterstitialAd(string2, this.sdk, MaxUnityAdManager.getCurrentActivity());
            maxInterstitialAd2.setListener((MaxAdListener)this);
            maxInterstitialAd2.setRevenueListener((MaxAdRevenueListener)this);
            this.mInterstitials.put(string2, maxInterstitialAd2);
        }
        return maxInterstitialAd2;
    }

    private MaxRewardedAd retrieveRewardedAd(String string2) {
        MaxRewardedAd maxRewardedAd;
        MaxRewardedAd maxRewardedAd2 = maxRewardedAd = this.mRewardedAds.get(string2);
        if (maxRewardedAd == null) {
            maxRewardedAd2 = MaxRewardedAd.getInstance((String)string2, (AppLovinSdk)this.sdk, (Activity)MaxUnityAdManager.getCurrentActivity());
            maxRewardedAd2.setListener((MaxRewardedAdListener)this);
            maxRewardedAd2.setRevenueListener((MaxAdRevenueListener)this);
            this.mRewardedAds.put(string2, maxRewardedAd2);
        }
        return maxRewardedAd2;
    }

    private MaxRewardedInterstitialAd retrieveRewardedInterstitialAd(String string2) {
        MaxRewardedInterstitialAd maxRewardedInterstitialAd;
        MaxRewardedInterstitialAd maxRewardedInterstitialAd2 = maxRewardedInterstitialAd = this.mRewardedInterstitialAds.get(string2);
        if (maxRewardedInterstitialAd == null) {
            maxRewardedInterstitialAd2 = new MaxRewardedInterstitialAd(string2, this.sdk, MaxUnityAdManager.getCurrentActivity());
            maxRewardedInterstitialAd2.setListener((MaxRewardedAdListener)this);
            maxRewardedInterstitialAd2.setRevenueListener((MaxAdRevenueListener)this);
            this.mRewardedInterstitialAds.put(string2, maxRewardedInterstitialAd2);
        }
        return maxRewardedInterstitialAd2;
    }

    private void setAdViewBackgroundColor(final String string2, final MaxAdFormat maxAdFormat, final String string3) {
        Utils.runSafelyOnUiThread((Activity)MaxUnityAdManager.getCurrentActivity(), (Runnable)new Runnable(){

            @Override
            public void run() {
                MaxUnityAdManager maxUnityAdManager = MaxUnityAdManager.this;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Setting ");
                stringBuilder.append(maxAdFormat.getLabel());
                stringBuilder.append(" with ad unit id \"");
                stringBuilder.append(string2);
                stringBuilder.append("\" to color: ");
                stringBuilder.append(string3);
                maxUnityAdManager.d(stringBuilder.toString());
                maxUnityAdManager = MaxUnityAdManager.this.retrieveAdView(string2, maxAdFormat);
                if (maxUnityAdManager == null) {
                    maxUnityAdManager = MaxUnityAdManager.this;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(maxAdFormat.getLabel());
                    stringBuilder.append(" does not exist");
                    maxUnityAdManager.e(stringBuilder.toString());
                    return;
                }
                int n2 = Color.parseColor((String)string3);
                MaxUnityAdManager.access$2102(MaxUnityAdManager.this, n2);
                MaxUnityAdManager.this.mSafeAreaBackground.setBackgroundColor(n2);
                maxUnityAdManager.setBackgroundColor(n2);
            }
        });
    }

    private void setAdViewExtraParameters(final String string2, final MaxAdFormat maxAdFormat, final String string3, final String string4) {
        Utils.runSafelyOnUiThread((Activity)MaxUnityAdManager.getCurrentActivity(), (Runnable)new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = MaxUnityAdManager.this;
                Object object = new StringBuilder();
                ((StringBuilder)object).append("Setting ");
                ((StringBuilder)object).append(maxAdFormat.getLabel());
                ((StringBuilder)object).append(" extra with key: \"");
                ((StringBuilder)object).append(string3);
                ((StringBuilder)object).append("\" value: ");
                ((StringBuilder)object).append(string4);
                ((MaxUnityAdManager)((Object)hashMap)).d(((StringBuilder)object).toString());
                hashMap = MaxUnityAdManager.this.retrieveAdView(string2, maxAdFormat);
                if (hashMap != null) {
                    hashMap.setExtraParameter(string3, string4);
                } else {
                    object = MaxUnityAdManager.this;
                    hashMap = new StringBuilder();
                    ((StringBuilder)((Object)hashMap)).append(maxAdFormat.getLabel());
                    ((StringBuilder)((Object)hashMap)).append(" does not exist for ad unit ID ");
                    ((StringBuilder)((Object)hashMap)).append(string2);
                    ((StringBuilder)((Object)hashMap)).append(". Saving extra parameter to be set when it is created.");
                    ((MaxUnityAdManager)object).d(((StringBuilder)((Object)hashMap)).toString());
                    object = (Map)MaxUnityAdManager.this.mAdViewExtraParametersToSetAfterCreate.get(string2);
                    hashMap = object;
                    if (object == null) {
                        hashMap = new HashMap<String, String>(1);
                        MaxUnityAdManager.this.mAdViewExtraParametersToSetAfterCreate.put(string2, hashMap);
                    }
                    hashMap.put(string3, string4);
                }
                MaxUnityAdManager.this.maybeHandleExtraParameterChanges(string2, maxAdFormat, string3, string4);
            }
        });
    }

    private void setAdViewPlacement(final String string2, final MaxAdFormat maxAdFormat, final String string3) {
        Utils.runSafelyOnUiThread((Activity)MaxUnityAdManager.getCurrentActivity(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Object object = MaxUnityAdManager.this;
                Object object2 = new StringBuilder();
                ((StringBuilder)object2).append("Setting placement \"");
                ((StringBuilder)object2).append(string3);
                ((StringBuilder)object2).append("\" for ");
                ((StringBuilder)object2).append(maxAdFormat.getLabel());
                ((StringBuilder)object2).append(" with ad unit id \"");
                ((StringBuilder)object2).append(string2);
                ((StringBuilder)object2).append("\"");
                ((MaxUnityAdManager)object).d(((StringBuilder)object2).toString());
                object = MaxUnityAdManager.this.retrieveAdView(string2, maxAdFormat);
                if (object == null) {
                    object2 = MaxUnityAdManager.this;
                    object = new StringBuilder();
                    ((StringBuilder)object).append(maxAdFormat.getLabel());
                    ((StringBuilder)object).append(" does not exist");
                    ((MaxUnityAdManager)object2).e(((StringBuilder)object).toString());
                    return;
                }
                object.setPlacement(string3);
            }
        });
    }

    private void setAdViewWidth(final String string2, final int n2, final MaxAdFormat maxAdFormat) {
        Utils.runSafelyOnUiThread((Activity)MaxUnityAdManager.getCurrentActivity(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Object object = MaxUnityAdManager.this;
                Object object2 = new StringBuilder();
                ((StringBuilder)object2).append("Setting width ");
                ((StringBuilder)object2).append(n2);
                ((StringBuilder)object2).append(" for \"");
                ((StringBuilder)object2).append(maxAdFormat);
                ((StringBuilder)object2).append("\" with ad unit identifier \"");
                ((StringBuilder)object2).append(string2);
                ((StringBuilder)object2).append("\"");
                ((MaxUnityAdManager)object).d(((StringBuilder)object2).toString());
                int n22 = maxAdFormat.getSize().getWidth();
                if (n2 < n22) {
                    object2 = MaxUnityAdManager.this;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("The provided width: ");
                    ((StringBuilder)object).append(n2);
                    ((StringBuilder)object).append("dp is smaller than the minimum required width: ");
                    ((StringBuilder)object).append(n22);
                    ((StringBuilder)object).append("dp for ad format: ");
                    ((StringBuilder)object).append(maxAdFormat);
                    ((StringBuilder)object).append(". Please set the width higher than the minimum required.");
                    ((MaxUnityAdManager)object2).e(((StringBuilder)object).toString());
                }
                MaxUnityAdManager.this.mAdViewWidths.put(string2, n2);
                MaxUnityAdManager.this.positionAdView(string2, maxAdFormat);
            }
        });
    }

    private void showAdView(final String string2, final MaxAdFormat maxAdFormat) {
        Utils.runSafelyOnUiThread((Activity)MaxUnityAdManager.getCurrentActivity(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Object object = MaxUnityAdManager.this;
                Object object2 = new StringBuilder();
                ((StringBuilder)object2).append("Showing ");
                ((StringBuilder)object2).append(maxAdFormat.getLabel());
                ((StringBuilder)object2).append(" with ad unit id \"");
                ((StringBuilder)object2).append(string2);
                ((StringBuilder)object2).append("\"");
                ((MaxUnityAdManager)object).d(((StringBuilder)object2).toString());
                object2 = MaxUnityAdManager.this.retrieveAdView(string2, maxAdFormat);
                if (object2 == null) {
                    object2 = MaxUnityAdManager.this;
                    object = new StringBuilder();
                    ((StringBuilder)object).append(maxAdFormat.getLabel());
                    ((StringBuilder)object).append(" does not exist for ad unit id ");
                    ((StringBuilder)object).append(string2);
                    ((MaxUnityAdManager)object2).e(((StringBuilder)object).toString());
                    MaxUnityAdManager.this.mAdUnitIdsToShowAfterCreate.add(string2);
                    return;
                }
                MaxUnityAdManager.this.mSafeAreaBackground.setVisibility(0);
                object2.setVisibility(0);
                object2.startAutoRefresh();
            }
        });
    }

    private void updateAdViewPosition(final String string2, final String string3, final Point point, final MaxAdFormat maxAdFormat) {
        Utils.runSafelyOnUiThread((Activity)MaxUnityAdManager.getCurrentActivity(), (Runnable)new Runnable(){

            @Override
            public void run() {
                MaxUnityAdManager maxUnityAdManager = MaxUnityAdManager.this;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Updating ");
                stringBuilder.append(maxAdFormat.getLabel());
                stringBuilder.append(" position to \"");
                stringBuilder.append(string3);
                stringBuilder.append("\" for ad unit id \"");
                stringBuilder.append(string2);
                stringBuilder.append("\"");
                maxUnityAdManager.d(stringBuilder.toString());
                if (MaxUnityAdManager.this.retrieveAdView(string2, maxAdFormat) == null) {
                    maxUnityAdManager = MaxUnityAdManager.this;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(maxAdFormat.getLabel());
                    stringBuilder.append(" does not exist");
                    maxUnityAdManager.e(stringBuilder.toString());
                    return;
                }
                MaxUnityAdManager.this.mAdViewPositions.put(string2, string3);
                MaxUnityAdManager.this.mAdViewOffsets.put(string2, point);
                MaxUnityAdManager.this.positionAdView(string2, maxAdFormat);
            }
        });
    }

    public void createBanner(String string2, float f2, float f3) {
        this.createAdView(string2, this.getAdViewAdFormat(string2), DEFAULT_AD_VIEW_POSITION, MaxUnityAdManager.getOffsetPixels(f2, f3, (Context)MaxUnityAdManager.getCurrentActivity()));
    }

    public void createBanner(String string2, String string3) {
        this.createAdView(string2, this.getAdViewAdFormat(string2), string3, DEFAULT_AD_VIEW_OFFSET);
    }

    public void createCrossPromoAd(String string2, float f2, float f3, int n2, int n3, int n4) {
        this.mAdViewWidths.put(string2, n2);
        this.mCrossPromoAdViewHeights.put(string2, n3);
        this.mCrossPromoAdViewRotations.put(string2, n4);
        this.createAdView(string2, MaxAdFormat.CROSS_PROMO, DEFAULT_AD_VIEW_POSITION, MaxUnityAdManager.getOffsetPixels(f2, f3, (Context)MaxUnityAdManager.getCurrentActivity()));
    }

    public void createMRec(String string2, float f2, float f3) {
        this.createAdView(string2, MaxAdFormat.MREC, DEFAULT_AD_VIEW_POSITION, MaxUnityAdManager.getOffsetPixels(f2, f3, (Context)MaxUnityAdManager.getCurrentActivity()));
    }

    public void createMRec(String string2, String string3) {
        this.createAdView(string2, MaxAdFormat.MREC, string3, DEFAULT_AD_VIEW_OFFSET);
    }

    public void destroyBanner(String string2) {
        this.destroyAdView(string2, this.getAdViewAdFormat(string2));
    }

    public void destroyCrossPromoAd(String string2) {
        this.destroyAdView(string2, MaxAdFormat.CROSS_PROMO);
    }

    public void destroyMRec(String string2) {
        this.destroyAdView(string2, MaxAdFormat.MREC);
    }

    public String getAdInfo(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        if ((string2 = this.getAd(string2)) == null) {
            return "";
        }
        return MaxUnityAdManager.propsStrFromDictionary(this.getAdInfo((MaxAd)string2));
    }

    public String getAdValue(String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        if ((string2 = this.getAd(string2)) == null) {
            return "";
        }
        return string2.getAdValue(string3);
    }

    public String getBannerLayout(String string2) {
        return this.getAdViewLayout(string2, this.getAdViewAdFormat(string2));
    }

    public String getCrossPromoAdLayout(String string2) {
        return this.getAdViewLayout(string2, MaxAdFormat.CROSS_PROMO);
    }

    public String getMRecLayout(String string2) {
        return this.getAdViewLayout(string2, MaxAdFormat.MREC);
    }

    public void hideBanner(String string2) {
        this.hideAdView(string2, this.getAdViewAdFormat(string2));
    }

    public void hideCrossPromoAd(String string2) {
        this.hideAdView(string2, MaxAdFormat.CROSS_PROMO);
    }

    public void hideMRec(String string2) {
        this.hideAdView(string2, MaxAdFormat.MREC);
    }

    public AppLovinSdk initializeSdkWithCompletionHandler(String string2, String string3, String string4, final Listener listener2) {
        Activity activity = MaxUnityAdManager.getCurrentActivity();
        this.sdk = AppLovinSdk.getInstance((String)string2, (AppLovinSdkSettings)MaxUnityAdManager.generateSdkSettings(string3, string4, (Context)activity), (Context)activity);
        this.sdk.getVariableService().setOnVariablesUpdateListener((AppLovinVariableService.OnVariablesUpdateListener)this);
        this.sdk.setPluginVersion("Max-Unity-4.3.7");
        this.sdk.setMediationProvider("max");
        this.sdk.initializeSdk(new AppLovinSdk.SdkInitializationListener(){

            public void onSdkInitialized(AppLovinSdkConfiguration appLovinSdkConfiguration) {
                listener2.onSdkInitializationComplete(appLovinSdkConfiguration);
                HashMap<String, String> hashMap = new HashMap<String, String>(3);
                hashMap.put("name", "OnSdkInitializedEvent");
                hashMap.put("consentDialogState", Integer.toString(appLovinSdkConfiguration.getConsentDialogState().ordinal()));
                hashMap.put("countryCode", appLovinSdkConfiguration.getCountryCode());
                MaxUnityAdManager.forwardUnityEvent(hashMap);
            }
        });
        return this.sdk;
    }

    public boolean isInterstitialReady(String string2) {
        return this.retrieveInterstitial(string2).isReady();
    }

    public boolean isRewardedAdReady(String string2) {
        return this.retrieveRewardedAd(string2).isReady();
    }

    public boolean isRewardedInterstitialAdReady(String string2) {
        return this.retrieveRewardedInterstitialAd(string2).isReady();
    }

    public void loadInterstitial(String string2) {
        this.retrieveInterstitial(string2).loadAd();
    }

    public void loadRewardedAd(String string2) {
        this.retrieveRewardedAd(string2).loadAd();
    }

    public void loadRewardedInterstitialAd(String string2) {
        this.retrieveRewardedInterstitialAd(string2).loadAd();
    }

    @Deprecated
    public void loadVariables() {
        this.sdk.getVariableService().loadVariables();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void onAdClicked(MaxAd maxAd) {
        void var2_9;
        block5: {
            block6: {
                MaxAdFormat maxAdFormat;
                block8: {
                    block7: {
                        maxAdFormat = maxAd.getFormat();
                        if (MaxAdFormat.BANNER == maxAdFormat || MaxAdFormat.LEADER == maxAdFormat) break block6;
                        if (MaxAdFormat.MREC != maxAdFormat) break block7;
                        String string2 = "OnMRecAdClickedEvent";
                        break block5;
                    }
                    if (MaxAdFormat.CROSS_PROMO != maxAdFormat) break block8;
                    String string3 = "OnCrossPromoAdClickedEvent";
                    break block5;
                }
                if (MaxAdFormat.INTERSTITIAL == maxAdFormat) {
                    String string4 = "OnInterstitialClickedEvent";
                    break block5;
                } else if (MaxAdFormat.REWARDED == maxAdFormat) {
                    String string5 = "OnRewardedAdClickedEvent";
                    break block5;
                } else {
                    if (MaxAdFormat.REWARDED_INTERSTITIAL != maxAdFormat) {
                        this.logInvalidAdFormat(maxAdFormat);
                        return;
                    }
                    String string6 = "OnRewardedInterstitialAdClickedEvent";
                }
                break block5;
            }
            String string7 = "OnBannerAdClickedEvent";
        }
        MaxUnityAdManager.forwardUnityEvent(this.getDefaultAdEventParameters((String)var2_9, maxAd));
    }

    public void onAdCollapsed(MaxAd maxAd) {
        Object object = maxAd.getFormat();
        if (!object.isAdViewAd()) {
            this.logInvalidAdFormat((MaxAdFormat)object);
            return;
        }
        object = MaxAdFormat.MREC == object ? "OnMRecAdCollapsedEvent" : (MaxAdFormat.CROSS_PROMO == object ? "OnCrossPromoAdCollapsedEvent" : "OnBannerAdCollapsedEvent");
        MaxUnityAdManager.forwardUnityEvent(this.getDefaultAdEventParameters((String)object, maxAd));
    }

    public void onAdDisplayFailed(MaxAd object, MaxError maxError) {
        Object object2 = object.getFormat();
        if (!object2.isFullscreenAd()) {
            return;
        }
        object2 = MaxAdFormat.INTERSTITIAL == object2 ? "OnInterstitialAdFailedToDisplayEvent" : (MaxAdFormat.REWARDED == object2 ? "OnRewardedAdFailedToDisplayEvent" : "OnRewardedInterstitialAdFailedToDisplayEvent");
        object = this.getDefaultAdEventParameters((String)object2, (MaxAd)object);
        object.put("errorCode", Integer.toString(maxError.getCode()));
        object.put("errorMessage", maxError.getMessage());
        MaxUnityAdManager.forwardUnityEvent((Map<String, String>)object);
    }

    public void onAdDisplayed(MaxAd maxAd) {
        Object object = maxAd.getFormat();
        if (!object.isFullscreenAd()) {
            return;
        }
        object = MaxAdFormat.INTERSTITIAL == object ? "OnInterstitialDisplayedEvent" : (MaxAdFormat.REWARDED == object ? "OnRewardedAdDisplayedEvent" : "OnRewardedInterstitialAdDisplayedEvent");
        MaxUnityAdManager.forwardUnityEvent(this.getDefaultAdEventParameters((String)object, maxAd));
    }

    public void onAdExpanded(MaxAd maxAd) {
        Object object = maxAd.getFormat();
        if (!object.isAdViewAd()) {
            this.logInvalidAdFormat((MaxAdFormat)object);
            return;
        }
        object = MaxAdFormat.MREC == object ? "OnMRecAdExpandedEvent" : (MaxAdFormat.CROSS_PROMO == object ? "OnCrossPromoAdExpandedEvent" : "OnBannerAdExpandedEvent");
        MaxUnityAdManager.forwardUnityEvent(this.getDefaultAdEventParameters((String)object, maxAd));
    }

    public void onAdHidden(MaxAd maxAd) {
        Object object = maxAd.getFormat();
        if (!object.isFullscreenAd()) {
            return;
        }
        object = MaxAdFormat.INTERSTITIAL == object ? "OnInterstitialHiddenEvent" : (MaxAdFormat.REWARDED == object ? "OnRewardedAdHiddenEvent" : "OnRewardedInterstitialAdHiddenEvent");
        MaxUnityAdManager.forwardUnityEvent(this.getDefaultAdEventParameters((String)object, maxAd));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onAdLoadFailed(String string2, MaxError object) {
        Object object2;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.logStackTrace(new IllegalArgumentException("adUnitId cannot be null"));
            return;
        }
        if (this.mAdViews.containsKey(string2)) {
            object2 = this.mAdViewAdFormats.get(string2);
            object2 = MaxAdFormat.MREC == object2 ? "OnMRecAdLoadFailedEvent" : (MaxAdFormat.CROSS_PROMO == object2 ? "OnCrossPromoAdLoadFailedEvent" : "OnBannerAdLoadFailedEvent");
        } else if (this.mInterstitials.containsKey(string2)) {
            object2 = "OnInterstitialLoadFailedEvent";
        } else if (this.mRewardedAds.containsKey(string2)) {
            object2 = "OnRewardedAdLoadFailedEvent";
        } else {
            if (!this.mRewardedInterstitialAds.containsKey(string2)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("invalid adUnitId: ");
                ((StringBuilder)object).append(string2);
                this.logStackTrace(new IllegalStateException(((StringBuilder)object).toString()));
                return;
            }
            object2 = "OnRewardedInterstitialAdLoadFailedEvent";
        }
        HashMap<String, String> hashMap = this.mAdInfoMapLock;
        synchronized (hashMap) {
            this.mAdInfoMap.remove(string2);
        }
        hashMap = new HashMap<String, String>(3);
        hashMap.put("name", (String)object2);
        hashMap.put("adUnitId", string2);
        hashMap.put("errorCode", Integer.toString(object.getCode()));
        hashMap.put("errorMessage", object.getMessage());
        string2 = object.getAdLoadFailureInfo();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "";
        }
        hashMap.put("adLoadFailureInfo", string2);
        MaxUnityAdManager.forwardUnityEvent(hashMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onAdLoaded(MaxAd maxAd) {
        Object object;
        Object object2;
        block11: {
            block10: {
                object2 = maxAd.getFormat();
                if (!object2.isAdViewAd()) break block10;
                object = MaxAdFormat.MREC == object2 ? "OnMRecAdLoadedEvent" : (MaxAdFormat.CROSS_PROMO == object2 ? "OnCrossPromoAdLoadedEvent" : "OnBannerAdLoadedEvent");
                this.positionAdView(maxAd);
                MaxAdView maxAdView = this.retrieveAdView(maxAd.getAdUnitId(), (MaxAdFormat)object2);
                object2 = object;
                if (maxAdView != null) {
                    object2 = object;
                    if (maxAdView.getVisibility() != 0) {
                        maxAdView.stopAutoRefresh();
                        object2 = object;
                    }
                }
                break block11;
            }
            if (MaxAdFormat.INTERSTITIAL == object2) {
                object2 = "OnInterstitialLoadedEvent";
            } else if (MaxAdFormat.REWARDED == object2) {
                object2 = "OnRewardedAdLoadedEvent";
            } else {
                if (MaxAdFormat.REWARDED_INTERSTITIAL != object2) {
                    this.logInvalidAdFormat((MaxAdFormat)object2);
                    return;
                }
                object2 = "OnRewardedInterstitialAdLoadedEvent";
            }
        }
        object = this.mAdInfoMapLock;
        synchronized (object) {
            this.mAdInfoMap.put(maxAd.getAdUnitId(), maxAd);
        }
        MaxUnityAdManager.forwardUnityEvent(this.getDefaultAdEventParameters((String)object2, maxAd));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void onAdRevenuePaid(MaxAd maxAd) {
        void var2_9;
        block5: {
            block6: {
                MaxAdFormat maxAdFormat;
                block8: {
                    block7: {
                        maxAdFormat = maxAd.getFormat();
                        if (MaxAdFormat.BANNER == maxAdFormat || MaxAdFormat.LEADER == maxAdFormat) break block6;
                        if (MaxAdFormat.MREC != maxAdFormat) break block7;
                        String string2 = "OnMRecAdRevenuePaidEvent";
                        break block5;
                    }
                    if (MaxAdFormat.CROSS_PROMO != maxAdFormat) break block8;
                    String string3 = "OnCrossPromoAdRevenuePaidEvent";
                    break block5;
                }
                if (MaxAdFormat.INTERSTITIAL == maxAdFormat) {
                    String string4 = "OnInterstitialAdRevenuePaidEvent";
                    break block5;
                } else if (MaxAdFormat.REWARDED == maxAdFormat) {
                    String string5 = "OnRewardedAdRevenuePaidEvent";
                    break block5;
                } else {
                    if (MaxAdFormat.REWARDED_INTERSTITIAL != maxAdFormat) {
                        this.logInvalidAdFormat(maxAdFormat);
                        return;
                    }
                    String string6 = "OnRewardedInterstitialAdRevenuePaidEvent";
                }
                break block5;
            }
            String string7 = "OnBannerAdRevenuePaidEvent";
        }
        MaxUnityAdManager.forwardUnityEvent(this.getDefaultAdEventParameters((String)var2_9, maxAd));
    }

    public void onDismiss() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("name", "OnSdkConsentDialogDismissedEvent");
        MaxUnityAdManager.forwardUnityEvent(hashMap);
    }

    public void onRewardedVideoCompleted(MaxAd maxAd) {
    }

    public void onRewardedVideoStarted(MaxAd maxAd) {
    }

    public void onUserRewarded(MaxAd object, MaxReward object2) {
        MaxAdFormat maxAdFormat = object.getFormat();
        if (maxAdFormat != MaxAdFormat.REWARDED && maxAdFormat != MaxAdFormat.REWARDED_INTERSTITIAL) {
            this.logInvalidAdFormat(maxAdFormat);
            return;
        }
        String string2 = object2 != null ? object2.getLabel() : "";
        int n2 = object2 != null ? object2.getAmount() : 0;
        String string3 = Integer.toString(n2);
        object2 = maxAdFormat == MaxAdFormat.REWARDED ? "OnRewardedAdReceivedRewardEvent" : "OnRewardedInterstitialAdReceivedRewardEvent";
        object = this.getDefaultAdEventParameters((String)object2, (MaxAd)object);
        object.put("rewardLabel", string2);
        object.put("rewardAmount", string3);
        MaxUnityAdManager.forwardUnityEvent((Map<String, String>)object);
    }

    public void onVariablesUpdate(Bundle object) {
        object = new HashMap(1);
        object.put("name", "OnVariablesUpdatedEvent");
        MaxUnityAdManager.forwardUnityEvent((Map<String, String>)object);
    }

    public void setBannerBackgroundColor(String string2, String string3) {
        this.setAdViewBackgroundColor(string2, this.getAdViewAdFormat(string2), string3);
    }

    public void setBannerExtraParameter(String string2, String string3, String string4) {
        this.setAdViewExtraParameters(string2, this.getAdViewAdFormat(string2), string3, string4);
    }

    public void setBannerPlacement(String string2, String string3) {
        this.setAdViewPlacement(string2, this.getAdViewAdFormat(string2), string3);
    }

    public void setBannerWidth(String string2, int n2) {
        this.setAdViewWidth(string2, n2, this.getAdViewAdFormat(string2));
    }

    public void setCrossPromoAdPlacement(String string2, String string3) {
        this.setAdViewPlacement(string2, MaxAdFormat.CROSS_PROMO, string3);
    }

    public void setInterstitialExtraParameter(String string2, String string3, String string4) {
        this.retrieveInterstitial(string2).setExtraParameter(string3, string4);
    }

    public void setMRecExtraParameter(String string2, String string3, String string4) {
        this.setAdViewExtraParameters(string2, MaxAdFormat.MREC, string3, string4);
    }

    public void setMRecPlacement(String string2, String string3) {
        this.setAdViewPlacement(string2, MaxAdFormat.MREC, string3);
    }

    public void setRewardedAdExtraParameter(String string2, String string3, String string4) {
        this.retrieveRewardedAd(string2).setExtraParameter(string3, string4);
    }

    public void setRewardedInterstitialAdExtraParameter(String string2, String string3, String string4) {
        this.retrieveRewardedInterstitialAd(string2).setExtraParameter(string3, string4);
    }

    public void showBanner(String string2) {
        this.showAdView(string2, this.getAdViewAdFormat(string2));
    }

    public void showCrossPromoAd(String string2) {
        this.showAdView(string2, MaxAdFormat.CROSS_PROMO);
    }

    public void showInterstitial(String string2, String string3) {
        this.retrieveInterstitial(string2).showAd(string3);
    }

    public void showMRec(String string2) {
        this.showAdView(string2, MaxAdFormat.MREC);
    }

    public void showRewardedAd(String string2, String string3) {
        this.retrieveRewardedAd(string2).showAd(string3);
    }

    public void showRewardedInterstitialAd(String string2, String string3) {
        this.retrieveRewardedInterstitialAd(string2).showAd(string3);
    }

    public void trackEvent(String string2, String object) {
        if (this.sdk == null) {
            return;
        }
        object = MaxUnityAdManager.deserializeParameters((String)object);
        this.sdk.getEventService().trackEvent(string2, (Map)object);
    }

    public void updateBannerPosition(String string2, float f2, float f3) {
        this.updateAdViewPosition(string2, DEFAULT_AD_VIEW_POSITION, MaxUnityAdManager.getOffsetPixels(f2, f3, (Context)MaxUnityAdManager.getCurrentActivity()), this.getAdViewAdFormat(string2));
    }

    public void updateBannerPosition(String string2, String string3) {
        this.updateAdViewPosition(string2, string3, DEFAULT_AD_VIEW_OFFSET, this.getAdViewAdFormat(string2));
    }

    public void updateCrossPromoAdPosition(String string2, float f2, float f3, int n2, int n3, int n4) {
        this.mAdViewWidths.put(string2, n2);
        this.mCrossPromoAdViewHeights.put(string2, n3);
        this.mCrossPromoAdViewRotations.put(string2, n4);
        this.updateAdViewPosition(string2, DEFAULT_AD_VIEW_POSITION, MaxUnityAdManager.getOffsetPixels(f2, f3, (Context)MaxUnityAdManager.getCurrentActivity()), MaxAdFormat.CROSS_PROMO);
    }

    public void updateMRecPosition(String string2, float f2, float f3) {
        this.updateAdViewPosition(string2, DEFAULT_AD_VIEW_POSITION, MaxUnityAdManager.getOffsetPixels(f2, f3, (Context)MaxUnityAdManager.getCurrentActivity()), MaxAdFormat.MREC);
    }

    public void updateMRecPosition(String string2, String string3) {
        this.updateAdViewPosition(string2, string3, DEFAULT_AD_VIEW_OFFSET, MaxAdFormat.MREC);
    }

    private static class Insets {
        int bottom;
        int left;
        int right;
        int top;

        private Insets() {
        }
    }

    public static interface Listener {
        public void onSdkInitializationComplete(AppLovinSdkConfiguration var1);
    }

    private static class SdkThreadFactory
    implements ThreadFactory {
        private SdkThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable2) {
            runnable2 = new Thread(runnable2, "AppLovinSdk:Max-Unity-Plugin:shared");
            ((Thread)runnable2).setDaemon(true);
            ((Thread)runnable2).setPriority(10);
            ((Thread)runnable2).setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    Log.e((String)MaxUnityAdManager.TAG, (String)"Caught unhandled exception", (Throwable)throwable);
                }
            });
            return runnable2;
        }
    }
}

