/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import com.applovin.impl.mediation.MaxRewardImpl;
import com.applovin.impl.sdk.k;
import com.applovin.impl.sdk.r;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MediationAdapterRouter {
    private static final Map<String, MediationAdapterRouter> sharedInstances = new HashMap<String, MediationAdapterRouter>();
    private static final Object sharedInstancesLock = new Object();
    private final Map<String, List<MediationAdapterRouterListenerWrapper>> listeners;
    private final Object listenersLock;
    private final Set<MaxAdapter> loadedAdapters;
    private final Object loadedAdaptersLock;
    protected MaxAdapter.OnCompletionListener mOnCompletionListener;
    private k mSdk;
    private final String mTag = this.getClass().getSimpleName();
    private final Set<MaxAdapter> showingAdapters;
    private final Object showingAdaptersLock;

    protected MediationAdapterRouter() {
        this.listeners = new HashMap<String, List<MediationAdapterRouterListenerWrapper>>();
        this.listenersLock = new Object();
        this.loadedAdapters = new HashSet<MaxAdapter>();
        this.loadedAdaptersLock = new Object();
        this.showingAdapters = new HashSet<MaxAdapter>();
        this.showingAdaptersLock = new Object();
        for (AppLovinSdk appLovinSdk : AppLovinSdk.a()) {
            if (!"max".equalsIgnoreCase(appLovinSdk.getMediationProvider())) continue;
            this.mSdk = appLovinSdk.coreSdk;
        }
        if (this.mSdk == null) {
            r.i((String)this.mTag, (String)"Invalid mediation provider detected. Please set AppLovin SDK mediation provider to MAX via AppLovinSdk.getInstance(context).setMediationProvider( AppLovinMediationProvider.MAX )");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAdapter(MaxAdapter object, MaxAdapterListener maxAdapterListener, String string2, RouterAdLoadType routerAdLoadType, View view) {
        Object object2 = this.listenersLock;
        synchronized (object2) {
            MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = new MediationAdapterRouterListenerWrapper((MaxAdapter)object, maxAdapterListener, routerAdLoadType, view);
            object = this.listeners.get(string2) != null ? this.listeners.get(string2) : new ArrayList(1);
            object.add(mediationAdapterRouterListenerWrapper);
            this.listeners.put(string2, (List<MediationAdapterRouterListenerWrapper>)object);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addLoadedAdapter(MaxAdapter maxAdapter) {
        Object object = this.loadedAdaptersLock;
        synchronized (object) {
            this.loadedAdapters.add(maxAdapter);
            return;
        }
    }

    private List<MediationAdapterRouterListenerWrapper> getListenerWrappers(String arrayList) {
        arrayList = this.listeners.containsKey(arrayList) ? new ArrayList(this.listeners.get(arrayList)) : null;
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<MediationAdapterRouterListenerWrapper> getLoadingListenerWrappers(String iterator2) {
        ArrayList<MediationAdapterRouterListenerWrapper> arrayList = new ArrayList<MediationAdapterRouterListenerWrapper>();
        Object object = this.listenersLock;
        synchronized (object) {
            iterator2 = this.getListenerWrappers((String)((Object)iterator2));
            if (iterator2 == null) return null;
            if (iterator2.size() <= 0) return null;
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                if (this.isAdLoaded(mediationAdapterRouterListenerWrapper.getAdapter())) continue;
                arrayList.add(mediationAdapterRouterListenerWrapper);
            }
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MediationAdapterRouter getSharedInstance(Class object) {
        Object object2 = sharedInstancesLock;
        synchronized (object2) {
            String string2 = ((Class)object).getName();
            MediationAdapterRouter mediationAdapterRouter = sharedInstances.get(string2);
            MediationAdapterRouter mediationAdapterRouter2 = mediationAdapterRouter;
            if (mediationAdapterRouter != null) return mediationAdapterRouter2;
            try {
                object = ((Class)object).getDeclaredConstructor(new Class[0]);
                ((Constructor)object).setAccessible(true);
                object = (MediationAdapterRouter)((Constructor)object).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                object = mediationAdapterRouter;
            }
            sharedInstances.put(string2, (MediationAdapterRouter)object);
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<MediationAdapterRouterListenerWrapper> getShowingListenerWrappers(String iterator2) {
        ArrayList<MediationAdapterRouterListenerWrapper> arrayList = new ArrayList<MediationAdapterRouterListenerWrapper>();
        Object object = this.listenersLock;
        synchronized (object) {
            iterator2 = this.getListenerWrappers((String)((Object)iterator2));
            if (iterator2 == null) return null;
            if (iterator2.size() <= 0) return null;
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                if (!this.isAdShowing(mediationAdapterRouterListenerWrapper.getAdapter())) continue;
                arrayList.add(mediationAdapterRouterListenerWrapper);
            }
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAdLoaded(MaxAdapter maxAdapter) {
        Object object = this.loadedAdaptersLock;
        synchronized (object) {
            return this.loadedAdapters.contains(maxAdapter);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAdShowing(MaxAdapter maxAdapter) {
        Object object = this.showingAdaptersLock;
        synchronized (object) {
            return this.showingAdapters.contains(maxAdapter);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeLoadedAdapter(MaxAdapter maxAdapter) {
        Object object = this.loadedAdaptersLock;
        synchronized (object) {
            this.loadedAdapters.remove(maxAdapter);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeShowingAdapter(MaxAdapter maxAdapter) {
        Object object = this.showingAdaptersLock;
        synchronized (object) {
            this.showingAdapters.remove(maxAdapter);
            return;
        }
    }

    public void addAdViewAdapter(MaxAdapter maxAdapter, MaxAdViewAdapterListener maxAdViewAdapterListener, String string2, View view) {
        this.addAdapter(maxAdapter, (MaxAdapterListener)maxAdViewAdapterListener, string2, RouterAdLoadType.ADVIEW, view);
    }

    public void addInterstitialAdapter(MaxAdapter maxAdapter, MaxInterstitialAdapterListener maxInterstitialAdapterListener, String string2) {
        this.addAdapter(maxAdapter, (MaxAdapterListener)maxInterstitialAdapterListener, string2, RouterAdLoadType.INTERSTITIAL, null);
    }

    public void addRewardedAdapter(MaxAdapter maxAdapter, MaxRewardedAdapterListener maxRewardedAdapterListener, String string2) {
        this.addAdapter(maxAdapter, (MaxAdapterListener)maxRewardedAdapterListener, string2, RouterAdLoadType.REWARDED, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addShowingAdapter(MaxAdapter maxAdapter) {
        Object object = this.showingAdaptersLock;
        synchronized (object) {
            this.showingAdapters.add(maxAdapter);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MaxReward getReward(String object) {
        Object object2 = this.listenersLock;
        synchronized (object2) {
            object = this.getListenerWrappers((String)object);
            if (object == null) return MaxRewardImpl.createDefault();
            if (object.size() <= 0) return MaxRewardImpl.createDefault();
            if (!((object = ((MediationAdapterRouterListenerWrapper)object.get(0)).getAdapter()) instanceof MediationAdapterBase)) return MaxRewardImpl.createDefault();
            return ((MediationAdapterBase)object).getReward();
        }
    }

    abstract void initialize(MaxAdapterInitializationParameters var1, Activity var2, MaxAdapter.OnCompletionListener var3);

    protected void log(String string2) {
        k k2 = this.mSdk;
        if (k2 != null) {
            k2.z().c(this.mTag, string2);
        }
    }

    protected void log(String string2, Throwable throwable) {
        k k2 = this.mSdk;
        if (k2 != null) {
            k2.z().b(this.mTag, string2, throwable);
        }
    }

    protected void onAdClicked(String object) {
        if ((object = this.getShowingListenerWrappers((String)object)) != null && object.size() > 0) {
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                object = mediationAdapterRouterListenerWrapper.getLoadType();
                mediationAdapterRouterListenerWrapper = mediationAdapterRouterListenerWrapper.getListener();
                if (object == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial clicked");
                    ((MaxInterstitialAdapterListener)mediationAdapterRouterListenerWrapper).onInterstitialAdClicked();
                    continue;
                }
                if (object == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded clicked");
                    ((MaxRewardedAdapterListener)mediationAdapterRouterListenerWrapper).onRewardedAdClicked();
                    continue;
                }
                if (object != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView clicked");
                ((MaxAdViewAdapterListener)mediationAdapterRouterListenerWrapper).onAdViewAdClicked();
            }
        }
    }

    protected void onAdDisplayFailed(String iterator2, MaxAdapterError maxAdapterError) {
        if ((iterator2 = this.getShowingListenerWrappers((String)((Object)iterator2))) != null && iterator2.size() > 0) {
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                Object object = mediationAdapterRouterListenerWrapper.getLoadType();
                mediationAdapterRouterListenerWrapper = mediationAdapterRouterListenerWrapper.getListener();
                if (object == RouterAdLoadType.INTERSTITIAL) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Interstitial failed to display with error: ");
                    ((StringBuilder)object).append(maxAdapterError.toString());
                    this.log(((StringBuilder)object).toString());
                    ((MaxInterstitialAdapterListener)mediationAdapterRouterListenerWrapper).onInterstitialAdDisplayFailed(maxAdapterError);
                    continue;
                }
                if (object == RouterAdLoadType.REWARDED) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Rewarded failed to display with error: ");
                    ((StringBuilder)object).append(maxAdapterError.toString());
                    this.log(((StringBuilder)object).toString());
                    ((MaxRewardedAdapterListener)mediationAdapterRouterListenerWrapper).onRewardedAdDisplayFailed(maxAdapterError);
                    continue;
                }
                if (object != RouterAdLoadType.ADVIEW) continue;
                object = new StringBuilder();
                ((StringBuilder)object).append("AdView failed to display with error: ");
                ((StringBuilder)object).append(maxAdapterError.toString());
                this.log(((StringBuilder)object).toString());
                ((MaxAdViewAdapterListener)mediationAdapterRouterListenerWrapper).onAdViewAdDisplayFailed(maxAdapterError);
            }
        }
    }

    protected void onAdDisplayed(String string2) {
        this.onAdDisplayed(string2, null);
    }

    protected void onAdDisplayed(String object, Bundle bundle) {
        if ((object = this.getShowingListenerWrappers((String)object)) != null && object.size() > 0) {
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                object = mediationAdapterRouterListenerWrapper.getLoadType();
                mediationAdapterRouterListenerWrapper = mediationAdapterRouterListenerWrapper.getListener();
                if (object == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial shown");
                    ((MaxInterstitialAdapterListener)mediationAdapterRouterListenerWrapper).onInterstitialAdDisplayed(bundle);
                    continue;
                }
                if (object == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded shown");
                    ((MaxRewardedAdapterListener)mediationAdapterRouterListenerWrapper).onRewardedAdDisplayed(bundle);
                    continue;
                }
                if (object != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView shown");
                ((MaxAdViewAdapterListener)mediationAdapterRouterListenerWrapper).onAdViewAdDisplayed(bundle);
            }
        }
    }

    protected void onAdHidden(String iterator2) {
        if ((iterator2 = this.getShowingListenerWrappers((String)((Object)iterator2))) != null && iterator2.size() > 0) {
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                mediationAdapterRouterListenerWrapper = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial hidden");
                    ((MaxInterstitialAdapterListener)mediationAdapterRouterListenerWrapper).onInterstitialAdHidden();
                    continue;
                }
                if (routerAdLoadType == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded hidden");
                    ((MaxRewardedAdapterListener)mediationAdapterRouterListenerWrapper).onRewardedAdHidden();
                    continue;
                }
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView hidden");
                ((MaxAdViewAdapterListener)mediationAdapterRouterListenerWrapper).onAdViewAdHidden();
            }
        }
    }

    protected void onAdLoadFailed(String iterator2, MaxAdapterError maxAdapterError) {
        if ((iterator2 = this.getLoadingListenerWrappers((String)((Object)iterator2))) != null && iterator2.size() > 0) {
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                Object object = mediationAdapterRouterListenerWrapper.getLoadType();
                mediationAdapterRouterListenerWrapper = mediationAdapterRouterListenerWrapper.getListener();
                if (object == RouterAdLoadType.INTERSTITIAL) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Interstitial failed to load with error: ");
                    ((StringBuilder)object).append(maxAdapterError.toString());
                    this.log(((StringBuilder)object).toString());
                    ((MaxInterstitialAdapterListener)mediationAdapterRouterListenerWrapper).onInterstitialAdLoadFailed(maxAdapterError);
                    continue;
                }
                if (object == RouterAdLoadType.REWARDED) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Rewarded failed to load with error: ");
                    ((StringBuilder)object).append(maxAdapterError.toString());
                    this.log(((StringBuilder)object).toString());
                    ((MaxRewardedAdapterListener)mediationAdapterRouterListenerWrapper).onRewardedAdLoadFailed(maxAdapterError);
                    continue;
                }
                if (object != RouterAdLoadType.ADVIEW) continue;
                object = new StringBuilder();
                ((StringBuilder)object).append("AdView failed to load with error: ");
                ((StringBuilder)object).append(maxAdapterError.toString());
                this.log(((StringBuilder)object).toString());
                ((MaxAdViewAdapterListener)mediationAdapterRouterListenerWrapper).onAdViewAdLoadFailed(maxAdapterError);
            }
        }
    }

    protected void onAdLoaded(String string2) {
        this.onAdLoaded(string2, null);
    }

    protected void onAdLoaded(String object, Bundle bundle) {
        if ((object = this.getLoadingListenerWrappers((String)object)) != null && object.size() > 0) {
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                this.addLoadedAdapter(mediationAdapterRouterListenerWrapper.getAdapter());
                object = mediationAdapterRouterListenerWrapper.getLoadType();
                MaxAdapterListener maxAdapterListener = mediationAdapterRouterListenerWrapper.getListener();
                if (object == RouterAdLoadType.INTERSTITIAL) {
                    this.log("Interstitial loaded");
                    ((MaxInterstitialAdapterListener)maxAdapterListener).onInterstitialAdLoaded(bundle);
                    continue;
                }
                if (object == RouterAdLoadType.REWARDED) {
                    this.log("Rewarded loaded");
                    ((MaxRewardedAdapterListener)maxAdapterListener).onRewardedAdLoaded(bundle);
                    continue;
                }
                if (object != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView loaded");
                ((MaxAdViewAdapterListener)maxAdapterListener).onAdViewAdLoaded(mediationAdapterRouterListenerWrapper.getAdView(), bundle);
            }
        }
    }

    protected void onAdViewAdCollapsed(String iterator2) {
        if ((iterator2 = this.getShowingListenerWrappers((String)((Object)iterator2))) != null && iterator2.size() > 0) {
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                mediationAdapterRouterListenerWrapper = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView collapsed");
                ((MaxAdViewAdapterListener)mediationAdapterRouterListenerWrapper).onAdViewAdCollapsed();
            }
        }
    }

    protected void onAdViewAdExpanded(String object) {
        if ((object = this.getShowingListenerWrappers((String)object)) != null && object.size() > 0) {
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                object = mediationAdapterRouterListenerWrapper.getLoadType();
                mediationAdapterRouterListenerWrapper = mediationAdapterRouterListenerWrapper.getListener();
                if (object != RouterAdLoadType.ADVIEW) continue;
                this.log("AdView expanded");
                ((MaxAdViewAdapterListener)mediationAdapterRouterListenerWrapper).onAdViewAdExpanded();
            }
        }
    }

    protected void onRewardedAdVideoCompleted(String iterator2) {
        if ((iterator2 = this.getShowingListenerWrappers((String)((Object)iterator2))) != null && iterator2.size() > 0) {
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                mediationAdapterRouterListenerWrapper = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.REWARDED) continue;
                this.log("Rewarded video completed");
                ((MaxRewardedAdapterListener)mediationAdapterRouterListenerWrapper).onRewardedAdVideoCompleted();
            }
        }
    }

    protected void onRewardedAdVideoStarted(String iterator2) {
        if ((iterator2 = this.getShowingListenerWrappers((String)((Object)iterator2))) != null && iterator2.size() > 0) {
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                RouterAdLoadType routerAdLoadType = mediationAdapterRouterListenerWrapper.getLoadType();
                mediationAdapterRouterListenerWrapper = mediationAdapterRouterListenerWrapper.getListener();
                if (routerAdLoadType != RouterAdLoadType.REWARDED) continue;
                this.log("Rewarded video started");
                ((MaxRewardedAdapterListener)mediationAdapterRouterListenerWrapper).onRewardedAdVideoStarted();
            }
        }
    }

    protected void onUserRewarded(String iterator2, MaxReward maxReward) {
        if ((iterator2 = this.getShowingListenerWrappers((String)((Object)iterator2))) != null && iterator2.size() > 0) {
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next();
                Object object = mediationAdapterRouterListenerWrapper.getLoadType();
                mediationAdapterRouterListenerWrapper = mediationAdapterRouterListenerWrapper.getListener();
                if (object != RouterAdLoadType.REWARDED) continue;
                object = new StringBuilder();
                ((StringBuilder)object).append("Rewarded user with reward: ");
                ((StringBuilder)object).append(maxReward);
                this.log(((StringBuilder)object).toString());
                ((MaxRewardedAdapterListener)mediationAdapterRouterListenerWrapper).onUserRewarded(maxReward);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAdapter(MaxAdapter maxAdapter, String object) {
        this.removeLoadedAdapter(maxAdapter);
        this.removeShowingAdapter(maxAdapter);
        Object object2 = this.listenersLock;
        synchronized (object2) {
            List<MediationAdapterRouterListenerWrapper> list = this.listeners.get(object);
            if (list == null) return;
            if (list.size() <= 0) return;
            Object var5_6 = null;
            Iterator<MediationAdapterRouterListenerWrapper> iterator2 = list.iterator();
            do {
                object = var5_6;
            } while (iterator2.hasNext() && ((MediationAdapterRouterListenerWrapper)(object = iterator2.next())).getAdapter() != maxAdapter);
            if (object == null) return;
            list.remove(object);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean shouldAlwaysRewardUser(String object) {
        Object object2 = this.listenersLock;
        synchronized (object2) {
            object = this.getListenerWrappers((String)object);
            if (object == null) return false;
            if (object.size() <= 0) return false;
            if (!((object = ((MediationAdapterRouterListenerWrapper)object.get(0)).getAdapter()) instanceof MediationAdapterBase)) return false;
            return ((MediationAdapterBase)object).shouldAlwaysRewardUser();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateAdView(View view, String iterator2) {
        Object object = this.listenersLock;
        synchronized (object) {
            MediationAdapterRouterListenerWrapper mediationAdapterRouterListenerWrapper;
            iterator2 = this.getListenerWrappers((String)((Object)iterator2));
            if (iterator2 == null) return;
            if (iterator2.size() <= 0) return;
            iterator2 = iterator2.iterator();
            do {
                if (!iterator2.hasNext()) return;
            } while ((mediationAdapterRouterListenerWrapper = (MediationAdapterRouterListenerWrapper)iterator2.next()).getAdView() != null);
            mediationAdapterRouterListenerWrapper.setAdView(view);
            return;
        }
    }

    private final class MediationAdapterRouterListenerWrapper {
        private View mAdView;
        private final MaxAdapter mAdapter;
        private final MaxAdapterListener mListener;
        private final RouterAdLoadType mLoadType;

        MediationAdapterRouterListenerWrapper(MaxAdapter maxAdapter, MaxAdapterListener maxAdapterListener, RouterAdLoadType routerAdLoadType, View view) {
            this.mAdapter = maxAdapter;
            this.mListener = maxAdapterListener;
            this.mLoadType = routerAdLoadType;
            this.mAdView = view;
        }

        View getAdView() {
            return this.mAdView;
        }

        MaxAdapter getAdapter() {
            return this.mAdapter;
        }

        MaxAdapterListener getListener() {
            return this.mListener;
        }

        RouterAdLoadType getLoadType() {
            return this.mLoadType;
        }

        void setAdView(View view) {
            this.mAdView = view;
        }
    }

    private static enum RouterAdLoadType {
        INTERSTITIAL,
        REWARDED,
        ADVIEW;

    }
}

