/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxRewardedInterstitialAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkUtils;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAd;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAdLoadCallback;
import com.safedk.android.internal.special.SpecialsBridge;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public class GoogleMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus status;
    private AdView adView;
    private InterstitialAd interstitialAd;
    private NativeAdView nativeAdView;
    private RewardedAd rewardedAd;
    private RewardedAdListener rewardedAdListener;
    private RewardedInterstitialAd rewardedInterstitialAd;
    private RewardedInterstitialAdListener rewardedInterstitialAdListener;

    public GoogleMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    static /* synthetic */ MaxAdapter.InitializationStatus access$002(MaxAdapter.InitializationStatus initializationStatus) {
        status = initializationStatus;
        return initializationStatus;
    }

    static /* synthetic */ InterstitialAd access$102(GoogleMediationAdapter googleMediationAdapter, InterstitialAd interstitialAd) {
        googleMediationAdapter.interstitialAd = interstitialAd;
        return interstitialAd;
    }

    static /* synthetic */ NativeAdView access$1102(GoogleMediationAdapter googleMediationAdapter, NativeAdView nativeAdView) {
        googleMediationAdapter.nativeAdView = nativeAdView;
        return nativeAdView;
    }

    static /* synthetic */ RewardedInterstitialAd access$302(GoogleMediationAdapter googleMediationAdapter, RewardedInterstitialAd rewardedInterstitialAd) {
        googleMediationAdapter.rewardedInterstitialAd = rewardedInterstitialAd;
        return rewardedInterstitialAd;
    }

    static /* synthetic */ RewardedInterstitialAdListener access$402(GoogleMediationAdapter googleMediationAdapter, RewardedInterstitialAdListener rewardedInterstitialAdListener) {
        googleMediationAdapter.rewardedInterstitialAdListener = rewardedInterstitialAdListener;
        return rewardedInterstitialAdListener;
    }

    static /* synthetic */ RewardedAd access$702(GoogleMediationAdapter googleMediationAdapter, RewardedAd rewardedAd) {
        googleMediationAdapter.rewardedAd = rewardedAd;
        return rewardedAd;
    }

    static /* synthetic */ RewardedAdListener access$802(GoogleMediationAdapter googleMediationAdapter, RewardedAdListener rewardedAdListener) {
        googleMediationAdapter.rewardedAdListener = rewardedAdListener;
        return rewardedAdListener;
    }

    private AdRequest createAdRequestWithParameters(MaxAdapterParameters object, Activity activity) {
        Object object2;
        String string2;
        AdRequest.Builder builder = new AdRequest.Builder();
        if (object instanceof MaxAdapterResponseParameters && AppLovinSdkUtils.isValidString(string2 = ((MaxAdapterResponseParameters)object).getBidResponse())) {
            builder.setAdString(string2);
        }
        if ((object2 = object.getServerParameters()).getBoolean("set_mediation_identifier", true)) {
            builder.setRequestAgent(GoogleMediationAdapter.mediationTag());
        }
        string2 = new Bundle();
        if (AppLovinSdkUtils.isValidString((String)(object2 = BundleUtils.getString((String)"event_id", (Bundle)object2)))) {
            string2.putString("placement_req_id", (String)object2);
        }
        if (this.getWrappingSdk().getConfiguration().getConsentDialogState() == AppLovinSdkConfiguration.ConsentDialogState.APPLIES && (object2 = this.getPrivacySetting("hasUserConsent", (MaxAdapterParameters)object)) != null && !((Boolean)object2).booleanValue()) {
            string2.putString("npa", "1");
        }
        if (AppLovinSdk.VERSION_CODE >= 91100 && (object = this.getPrivacySetting("isDoNotSell", (MaxAdapterParameters)object)) != null && ((Boolean)object).booleanValue()) {
            string2.putInt("rdp", 1);
            activity.getPreferences(0).edit().putInt("gad_rdp", 1).commit();
        }
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string2);
        return builder.build();
    }

    private Boolean getPrivacySetting(String object, MaxAdapterParameters object2) {
        try {
            object2 = (Boolean)object2.getClass().getMethod((String)object, new Class[0]).invoke(object2, new Object[0]);
            return object2;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error getting privacy setting ");
            stringBuilder.append((String)object);
            stringBuilder.append(" with exception: ");
            this.log(stringBuilder.toString(), exception);
            object = AppLovinSdk.VERSION_CODE >= 9140000 ? null : Boolean.valueOf(false);
            return object;
        }
    }

    private void setRequestConfiguration(MaxAdapterParameters object) {
        RequestConfiguration.Builder builder = MobileAds.getRequestConfiguration().toBuilder();
        Boolean bl = this.getPrivacySetting("isAgeRestrictedUser", (MaxAdapterParameters)object);
        if (bl != null) {
            builder.setTagForChildDirectedTreatment(bl.booleanValue() ? 1 : 0);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = object.getServerParameters().getString("test_device_ids", null)))) {
            builder.setTestDeviceIds(Arrays.asList(((String)object).split(",")));
        }
        MobileAds.setRequestConfiguration((RequestConfiguration)builder.build());
    }

    private AdFormat toAdFormat(MaxAdapterSignalCollectionParameters object) {
        boolean bl = object.getServerParameters().getBoolean("is_native");
        MaxAdFormat maxAdFormat = object.getAdFormat();
        if (bl) {
            return AdFormat.NATIVE;
        }
        if (maxAdFormat.isAdViewAd()) {
            return AdFormat.BANNER;
        }
        if (maxAdFormat == MaxAdFormat.INTERSTITIAL) {
            return AdFormat.INTERSTITIAL;
        }
        if (maxAdFormat == MaxAdFormat.REWARDED) {
            return AdFormat.REWARDED;
        }
        if (maxAdFormat == MaxAdFormat.REWARDED_INTERSTITIAL) {
            return AdFormat.REWARDED_INTERSTITIAL;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Unsupported ad format: ");
        ((StringBuilder)object).append(maxAdFormat);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    private AdSize toAdSize(MaxAdFormat maxAdFormat, Bundle object, Activity activity) {
        if (maxAdFormat != MaxAdFormat.BANNER && maxAdFormat != MaxAdFormat.LEADER) {
            if (maxAdFormat == MaxAdFormat.MREC) {
                return AdSize.MEDIUM_RECTANGLE;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unsupported ad format: ");
            ((StringBuilder)object).append(maxAdFormat);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        if (object.getBoolean("adaptive_banner", false)) {
            object = activity.getWindowManager().getDefaultDisplay();
            maxAdFormat = new DisplayMetrics();
            object.getMetrics((DisplayMetrics)maxAdFormat);
            return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)activity, (int)AppLovinSdkUtils.pxToDp((Context)activity, maxAdFormat.widthPixels));
        }
        maxAdFormat = maxAdFormat == MaxAdFormat.BANNER ? AdSize.BANNER : AdSize.LEADERBOARD;
        return maxAdFormat;
    }

    /*
     * Unable to fully structure code
     */
    private static MaxAdapterError toMaxError(AdError var0) {
        block6: {
            block5: {
                var1_1 = var0.getCode();
                var2_2 = MaxAdapterError.UNSPECIFIED;
                if (var1_1 == 0) break block5;
                if (var1_1 == 1) ** GOTO lbl-1000
                if (var1_1 == 2) ** GOTO lbl16
                if (var1_1 == 3) ** GOTO lbl-1000
                switch (var1_1) {
                    default: {
                        break;
                    }
                    case 8: {
                        var2_2 = MaxAdapterError.INVALID_CONFIGURATION;
                        break;
                    }
                    case 9: lbl-1000:
                    // 2 sources

                    {
                        var2_2 = MaxAdapterError.NO_FILL;
                        break;
                    }
lbl16:
                    // 1 sources

                    var2_2 = MaxAdapterError.NO_CONNECTION;
                    break;
                    case 10: lbl-1000:
                    // 2 sources

                    {
                        var2_2 = MaxAdapterError.BAD_REQUEST;
                        break;
                    }
                }
                break block6;
            }
            var2_2 = MaxAdapterError.INTERNAL_ERROR;
        }
        return new MaxAdapterError(var2_2.getErrorCode(), var2_2.getErrorMessage(), var1_1, var0.getMessage());
    }

    private static void updateMuteState(MaxAdapterResponseParameters maxAdapterResponseParameters) {
        if ((maxAdapterResponseParameters = maxAdapterResponseParameters.getServerParameters()).containsKey("is_muted")) {
            MobileAds.setAppMuted((boolean)maxAdapterResponseParameters.getBoolean("is_muted"));
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters maxAdapterSignalCollectionParameters, Activity activity, final MaxSignalCollectionListener maxSignalCollectionListener) {
        this.setRequestConfiguration((MaxAdapterParameters)maxAdapterSignalCollectionParameters);
        AdRequest adRequest = this.createAdRequestWithParameters((MaxAdapterParameters)maxAdapterSignalCollectionParameters, activity);
        QueryInfo.generate((Context)activity.getApplicationContext(), (AdFormat)this.toAdFormat(maxAdapterSignalCollectionParameters), (AdRequest)adRequest, (QueryInfoGenerationCallback)new QueryInfoGenerationCallback(){

            public void onFailure(String string2) {
                GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Signal collection failed with error: ");
                stringBuilder.append(string2);
                googleMediationAdapter.log(stringBuilder.toString());
                maxSignalCollectionListener.onSignalCollectionFailed(string2);
            }

            public void onSuccess(QueryInfo queryInfo) {
                GoogleMediationAdapter.this.log("Signal collection successful");
                maxSignalCollectionListener.onSignalCollected(queryInfo.getQuery());
            }
        });
    }

    public String getAdapterVersion() {
        return "20.3.0.0";
    }

    public String getSdkVersion() {
        String string2 = this.getAdapterVersion();
        return string2.substring(0, string2.lastIndexOf(46));
    }

    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        this.log("Initializing Google SDK...");
        this.checkExistence(new Class[]{MobileAds.class, InterstitialAd.class, RewardedAd.class, AdListener.class});
        if (initialized.compareAndSet(false, true)) {
            status = MaxAdapter.InitializationStatus.INITIALIZING;
            MobileAds.disableMediationAdapterInitialization((Context)activity);
            MobileAds.initialize((Context)activity, (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

                @Override
                public void onInitializationComplete(InitializationStatus object) {
                    object = (object = (AdapterStatus)object.getAdapterStatusMap().get("com.google.android.gms.ads.MobileAds")) != null ? object.getInitializationState() : null;
                    GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Initialization complete with status ");
                    stringBuilder.append(object);
                    googleMediationAdapter.log(stringBuilder.toString());
                    object = AdapterStatus.State.READY == object ? MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS : MaxAdapter.InitializationStatus.INITIALIZED_UNKNOWN;
                    GoogleMediationAdapter.access$002((MaxAdapter.InitializationStatus)object);
                    onCompletionListener.onCompletion(status, null);
                }
            });
        } else {
            onCompletionListener.onCompletion(status, null);
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters object, MaxAdFormat maxAdFormat, Activity activity, MaxAdViewAdapterListener maxAdViewAdapterListener) {
        String string2 = object.getThirdPartyAdPlacementId();
        boolean bl = object.getServerParameters().getBoolean("is_native");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Loading ");
        boolean bl2 = AppLovinSdkUtils.isValidString(object.getBidResponse());
        String string3 = "";
        Object object2 = bl2 ? "bidding " : "";
        stringBuilder.append((String)object2);
        object2 = string3;
        if (bl) {
            object2 = "native ";
        }
        stringBuilder.append((String)object2);
        stringBuilder.append(maxAdFormat.getLabel());
        stringBuilder.append(" ad for placement id: ");
        stringBuilder.append(string2);
        stringBuilder.append("...");
        this.log(stringBuilder.toString());
        this.setRequestConfiguration((MaxAdapterParameters)object);
        string3 = this.createAdRequestWithParameters((MaxAdapterParameters)object, activity);
        if (bl) {
            object2 = new NativeAdOptions.Builder();
            bl = true;
            ((NativeAdOptions.Builder)object2).setAdChoicesPlacement(1);
            if (maxAdFormat != MaxAdFormat.MREC) {
                bl = false;
            }
            ((NativeAdOptions.Builder)object2).setRequestMultipleImages(bl);
            object = new NativeAdViewListener(string2, maxAdFormat, object.getServerParameters(), activity, maxAdViewAdapterListener);
            new AdLoader.Builder((Context)activity, string2).withNativeAdOptions(((NativeAdOptions.Builder)object2).build()).forNativeAd((NativeAd.OnNativeAdLoadedListener)object).withAdListener((AdListener)object).build().loadAd((AdRequest)string3);
        } else {
            this.adView = new AdView((Context)activity);
            this.adView.setAdUnitId(string2);
            this.adView.setAdSize(this.toAdSize(maxAdFormat, object.getServerParameters(), activity));
            this.adView.setAdListener((AdListener)new AdViewListener(string2, maxAdFormat, maxAdViewAdapterListener));
            this.adView.loadAd((AdRequest)string3);
        }
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        final String string2 = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Loading ");
        String string3 = AppLovinSdkUtils.isValidString(maxAdapterResponseParameters.getBidResponse()) ? "bidding " : "";
        stringBuilder.append(string3);
        stringBuilder.append("interstitial ad: ");
        stringBuilder.append(string2);
        stringBuilder.append("...");
        this.log(stringBuilder.toString());
        GoogleMediationAdapter.updateMuteState(maxAdapterResponseParameters);
        this.setRequestConfiguration((MaxAdapterParameters)maxAdapterResponseParameters);
        InterstitialAd.load((Context)activity, string2, this.createAdRequestWithParameters((MaxAdapterParameters)maxAdapterResponseParameters, activity), new InterstitialAdLoadCallback(){

            public void onAdFailedToLoad(LoadAdError object) {
                MaxAdapterError maxAdapterError = GoogleMediationAdapter.toMaxError((AdError)object);
                GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
                object = new StringBuilder();
                ((StringBuilder)object).append("Interstitial ad (");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(") failed to load with error: ");
                ((StringBuilder)object).append(maxAdapterError);
                googleMediationAdapter.log(((StringBuilder)object).toString());
                maxInterstitialAdapterListener.onInterstitialAdLoadFailed(maxAdapterError);
            }

            public void onAdLoaded(InterstitialAd object) {
                GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Interstitial ad loaded: ");
                stringBuilder.append(string2);
                stringBuilder.append("...");
                googleMediationAdapter.log(stringBuilder.toString());
                GoogleMediationAdapter.access$102(GoogleMediationAdapter.this, (InterstitialAd)object);
                GoogleMediationAdapter.this.interstitialAd.setFullScreenContentCallback(new InterstitialAdListener(string2, maxInterstitialAdapterListener));
                object = GoogleMediationAdapter.this.interstitialAd.getResponseInfo();
                object = object != null ? ((ResponseInfo)object).getResponseId() : null;
                if (AppLovinSdk.VERSION_CODE >= 9150000 && AppLovinSdkUtils.isValidString((String)object)) {
                    stringBuilder = new Bundle(1);
                    stringBuilder.putString("creative_id", (String)object);
                    maxInterstitialAdapterListener.onInterstitialAdLoaded((Bundle)stringBuilder);
                } else {
                    maxInterstitialAdapterListener.onInterstitialAdLoaded();
                }
            }
        });
    }

    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxRewardedAdapterListener maxRewardedAdapterListener) {
        final String string2 = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Loading ");
        String string3 = AppLovinSdkUtils.isValidString(maxAdapterResponseParameters.getBidResponse()) ? "bidding " : "";
        stringBuilder.append(string3);
        stringBuilder.append("rewarded ad: ");
        stringBuilder.append(string2);
        stringBuilder.append("...");
        this.log(stringBuilder.toString());
        GoogleMediationAdapter.updateMuteState(maxAdapterResponseParameters);
        this.setRequestConfiguration((MaxAdapterParameters)maxAdapterResponseParameters);
        RewardedAd.load((Context)activity, string2, this.createAdRequestWithParameters((MaxAdapterParameters)maxAdapterResponseParameters, activity), new RewardedAdLoadCallback(){

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                loadAdError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
                GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Rewarded ad (");
                stringBuilder.append(string2);
                stringBuilder.append(") failed to load with error: ");
                stringBuilder.append(loadAdError);
                googleMediationAdapter.log(stringBuilder.toString());
                maxRewardedAdapterListener.onRewardedAdLoadFailed((MaxAdapterError)loadAdError);
            }

            public void onAdLoaded(RewardedAd object) {
                GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Rewarded ad loaded: ");
                stringBuilder.append(string2);
                stringBuilder.append("...");
                googleMediationAdapter.log(stringBuilder.toString());
                GoogleMediationAdapter.access$702(GoogleMediationAdapter.this, (RewardedAd)object);
                object = GoogleMediationAdapter.this;
                GoogleMediationAdapter.access$802((GoogleMediationAdapter)((Object)object), (GoogleMediationAdapter)((Object)object).new RewardedAdListener(string2, maxRewardedAdapterListener));
                GoogleMediationAdapter.this.rewardedAd.setFullScreenContentCallback(GoogleMediationAdapter.this.rewardedAdListener);
                object = GoogleMediationAdapter.this.rewardedAd.getResponseInfo();
                object = object != null ? ((ResponseInfo)object).getResponseId() : null;
                if (AppLovinSdk.VERSION_CODE >= 9150000 && AppLovinSdkUtils.isValidString((String)object)) {
                    googleMediationAdapter = new Bundle(1);
                    googleMediationAdapter.putString("creative_id", (String)object);
                    maxRewardedAdapterListener.onRewardedAdLoaded((Bundle)googleMediationAdapter);
                } else {
                    maxRewardedAdapterListener.onRewardedAdLoaded();
                }
            }
        });
    }

    public void loadRewardedInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxRewardedInterstitialAdapterListener maxRewardedInterstitialAdapterListener) {
        final String string2 = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Loading ");
        String string3 = AppLovinSdkUtils.isValidString(maxAdapterResponseParameters.getBidResponse()) ? "bidding " : "";
        stringBuilder.append(string3);
        stringBuilder.append("rewarded interstitial ad: ");
        stringBuilder.append(string2);
        stringBuilder.append("...");
        this.log(stringBuilder.toString());
        GoogleMediationAdapter.updateMuteState(maxAdapterResponseParameters);
        this.setRequestConfiguration((MaxAdapterParameters)maxAdapterResponseParameters);
        RewardedInterstitialAd.load((Context)activity, string2, this.createAdRequestWithParameters((MaxAdapterParameters)maxAdapterResponseParameters, activity), new RewardedInterstitialAdLoadCallback(){

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                loadAdError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
                GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Rewarded interstitial ad (");
                stringBuilder.append(string2);
                stringBuilder.append(") failed to load with error: ");
                stringBuilder.append(loadAdError);
                googleMediationAdapter.log(stringBuilder.toString());
                maxRewardedInterstitialAdapterListener.onRewardedInterstitialAdLoadFailed((MaxAdapterError)loadAdError);
            }

            public void onAdLoaded(RewardedInterstitialAd object) {
                Object object2 = GoogleMediationAdapter.this;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Rewarded interstitial ad loaded: ");
                stringBuilder.append(string2);
                object2.log(stringBuilder.toString());
                GoogleMediationAdapter.access$302(GoogleMediationAdapter.this, (RewardedInterstitialAd)object);
                object2 = GoogleMediationAdapter.this;
                String string22 = string2;
                stringBuilder = maxRewardedInterstitialAdapterListener;
                object = null;
                GoogleMediationAdapter.access$402((GoogleMediationAdapter)((Object)object2), (GoogleMediationAdapter)((Object)object2).new RewardedInterstitialAdListener(string22, (MaxRewardedInterstitialAdapterListener)stringBuilder));
                GoogleMediationAdapter.this.rewardedInterstitialAd.setFullScreenContentCallback(GoogleMediationAdapter.this.rewardedInterstitialAdListener);
                object2 = GoogleMediationAdapter.this.rewardedInterstitialAd.getResponseInfo();
                if (object2 != null) {
                    object = ((ResponseInfo)object2).getResponseId();
                }
                if (AppLovinSdk.VERSION_CODE > 9150000 && AppLovinSdkUtils.isValidString((String)object)) {
                    object2 = new Bundle(1);
                    object2.putString("creative_id", (String)object);
                    maxRewardedInterstitialAdapterListener.onRewardedInterstitialAdLoaded((Bundle)object2);
                } else {
                    maxRewardedInterstitialAdapterListener.onRewardedInterstitialAdLoaded();
                }
            }
        });
    }

    public void onDestroy() {
        Object object = new StringBuilder();
        ((StringBuilder)object).append("Destroy called for adapter ");
        ((StringBuilder)object).append((Object)this);
        this.log(((StringBuilder)object).toString());
        object = this.interstitialAd;
        if (object != null) {
            ((InterstitialAd)object).setFullScreenContentCallback(null);
            this.interstitialAd = null;
        }
        if ((object = this.rewardedInterstitialAd) != null) {
            ((RewardedInterstitialAd)object).setFullScreenContentCallback(null);
            this.rewardedInterstitialAd = null;
            this.rewardedInterstitialAdListener = null;
        }
        if ((object = this.rewardedAd) != null) {
            ((RewardedAd)object).setFullScreenContentCallback(null);
            this.rewardedAd = null;
            this.rewardedAdListener = null;
        }
        if ((object = this.adView) != null) {
            object.destroy();
            this.adView = null;
        }
        if ((object = this.nativeAdView) != null) {
            ((NativeAdView)((Object)object)).destroy();
            this.nativeAdView = null;
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters object, Activity object2, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        object = object.getThirdPartyAdPlacementId();
        Object object3 = new StringBuilder();
        ((StringBuilder)object3).append("Showing interstitial ad: ");
        ((StringBuilder)object3).append((String)object);
        ((StringBuilder)object3).append("...");
        this.log(((StringBuilder)object3).toString());
        object3 = this.interstitialAd;
        if (object3 != null) {
            SpecialsBridge.interstitialAdShow((InterstitialAd)object3, (Activity)object2);
        } else {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Interstitial ad failed to show: ");
            ((StringBuilder)object2).append((String)object);
            this.log(((StringBuilder)object2).toString());
            maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters object, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        final String string2 = object.getThirdPartyAdPlacementId();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Showing rewarded ad: ");
        stringBuilder.append(string2);
        stringBuilder.append("...");
        this.log(stringBuilder.toString());
        if (this.rewardedAd != null) {
            this.configureReward((MaxAdapterResponseParameters)object);
            SpecialsBridge.rewardedAdShow(this.rewardedAd, activity, new OnUserEarnedRewardListener(){

                public void onUserEarnedReward(RewardItem object) {
                    GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Rewarded ad user earned reward: ");
                    ((StringBuilder)object).append(string2);
                    googleMediationAdapter.log(((StringBuilder)object).toString());
                    RewardedAdListener.access$902(GoogleMediationAdapter.this.rewardedAdListener, true);
                }
            });
        } else {
            object = new StringBuilder();
            ((StringBuilder)object).append("Rewarded ad failed to show: ");
            ((StringBuilder)object).append(string2);
            this.log(((StringBuilder)object).toString());
            maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    public void showRewardedInterstitialAd(MaxAdapterResponseParameters object, Activity activity, MaxRewardedInterstitialAdapterListener maxRewardedInterstitialAdapterListener) {
        final String string2 = object.getThirdPartyAdPlacementId();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Showing rewarded interstitial ad: ");
        stringBuilder.append(string2);
        stringBuilder.append("...");
        this.log(stringBuilder.toString());
        if (this.rewardedInterstitialAd != null) {
            this.configureReward((MaxAdapterResponseParameters)object);
            this.rewardedInterstitialAd.show(activity, new OnUserEarnedRewardListener(){

                public void onUserEarnedReward(RewardItem object) {
                    object = GoogleMediationAdapter.this;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Rewarded interstitial ad user earned reward: ");
                    stringBuilder.append(string2);
                    object.log(stringBuilder.toString());
                    RewardedInterstitialAdListener.access$602(GoogleMediationAdapter.this.rewardedInterstitialAdListener, true);
                }
            });
        } else {
            object = new StringBuilder();
            ((StringBuilder)object).append("Rewarded interstitial ad failed to show: ");
            ((StringBuilder)object).append(string2);
            this.log(((StringBuilder)object).toString());
            maxRewardedInterstitialAdapterListener.onRewardedInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    private class AdViewListener
    extends AdListener {
        final MaxAdFormat adFormat;
        final MaxAdViewAdapterListener listener;
        final String placementId;

        AdViewListener(String string2, MaxAdFormat maxAdFormat, MaxAdViewAdapterListener maxAdViewAdapterListener) {
            this.placementId = string2;
            this.adFormat = maxAdFormat;
            this.listener = maxAdViewAdapterListener;
        }

        public void onAdClosed() {
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.adFormat.getLabel());
            stringBuilder.append(" ad closed");
            googleMediationAdapter.log(stringBuilder.toString());
        }

        public void onAdFailedToLoad(LoadAdError object) {
            MaxAdapterError maxAdapterError = GoogleMediationAdapter.toMaxError((AdError)object);
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            object = new StringBuilder();
            ((StringBuilder)object).append(this.adFormat.getLabel());
            ((StringBuilder)object).append(" ad (");
            ((StringBuilder)object).append(this.placementId);
            ((StringBuilder)object).append(") failed to load with error code: ");
            ((StringBuilder)object).append(maxAdapterError);
            googleMediationAdapter.log(((StringBuilder)object).toString());
            this.listener.onAdViewAdLoadFailed(maxAdapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.adFormat.getLabel());
            stringBuilder.append(" ad shown: ");
            stringBuilder.append(this.placementId);
            googleMediationAdapter.log(stringBuilder.toString());
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdLoaded() {
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            Object object = new StringBuilder();
            ((StringBuilder)object).append(this.adFormat.getLabel());
            ((StringBuilder)object).append(" ad loaded: ");
            ((StringBuilder)object).append(this.placementId);
            googleMediationAdapter.log(((StringBuilder)object).toString());
            object = GoogleMediationAdapter.this.adView.getResponseInfo();
            object = object != null ? ((ResponseInfo)object).getResponseId() : null;
            if (AppLovinSdk.VERSION_CODE >= 9150000 && AppLovinSdkUtils.isValidString((String)object)) {
                googleMediationAdapter = new Bundle(1);
                googleMediationAdapter.putString("creative_id", (String)object);
                this.listener.onAdViewAdLoaded((View)GoogleMediationAdapter.this.adView, (Bundle)googleMediationAdapter);
            } else {
                this.listener.onAdViewAdLoaded((View)GoogleMediationAdapter.this.adView);
            }
        }

        public void onAdOpened() {
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.adFormat.getLabel());
            stringBuilder.append(" ad opened");
            googleMediationAdapter.log(stringBuilder.toString());
            this.listener.onAdViewAdClicked();
        }
    }

    private class InterstitialAdListener
    extends FullScreenContentCallback {
        private final MaxInterstitialAdapterListener listener;
        private final String placementId;

        InterstitialAdListener(String string2, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
            this.placementId = string2;
            this.listener = maxInterstitialAdapterListener;
        }

        public void onAdDismissedFullScreenContent() {
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Interstitial ad hidden: ");
            stringBuilder.append(this.placementId);
            googleMediationAdapter.log(stringBuilder.toString());
            this.listener.onInterstitialAdHidden();
        }

        public void onAdFailedToShowFullScreenContent(AdError object) {
            MaxAdapterError maxAdapterError = GoogleMediationAdapter.toMaxError(object);
            object = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Interstitial ad (");
            stringBuilder.append(this.placementId);
            stringBuilder.append(") failed to show with error: ");
            stringBuilder.append(maxAdapterError);
            object.log(stringBuilder.toString());
            this.listener.onInterstitialAdLoadFailed(maxAdapterError);
        }

        public void onAdShowedFullScreenContent() {
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Interstitial ad shown: ");
            stringBuilder.append(this.placementId);
            googleMediationAdapter.log(stringBuilder.toString());
            this.listener.onInterstitialAdDisplayed();
        }
    }

    private class NativeAdViewListener
    extends AdListener
    implements NativeAd.OnNativeAdLoadedListener {
        final WeakReference<Activity> activityRef;
        final MaxAdFormat adFormat;
        final MaxAdViewAdapterListener listener;
        final String placementId;
        final Bundle serverParameters;

        NativeAdViewListener(String string2, MaxAdFormat maxAdFormat, Bundle bundle, Activity activity, MaxAdViewAdapterListener maxAdViewAdapterListener) {
            this.placementId = string2;
            this.adFormat = maxAdFormat;
            this.serverParameters = bundle;
            this.activityRef = new WeakReference<Activity>(activity);
            this.listener = maxAdViewAdapterListener;
        }

        private boolean isValidNativeAd(NativeAd nativeAd) {
            boolean bl;
            String string2 = nativeAd.getHeadline();
            boolean bl2 = bl = false;
            if (string2 != null) {
                bl2 = bl;
                if (nativeAd.getBody() != null) {
                    bl2 = bl;
                    if (nativeAd.getImages() != null) {
                        bl2 = bl;
                        if (nativeAd.getImages().size() > 0) {
                            bl2 = bl;
                            if (nativeAd.getImages().get(0) != null) {
                                bl2 = bl;
                                if (nativeAd.getIcon() != null) {
                                    bl2 = bl;
                                    if (nativeAd.getCallToAction() != null) {
                                        bl2 = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return bl2;
        }

        public void onAdClicked() {
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Native ");
            stringBuilder.append(this.adFormat.getLabel());
            stringBuilder.append(" ad clicked");
            googleMediationAdapter.log(stringBuilder.toString());
            this.listener.onAdViewAdClicked();
        }

        public void onAdClosed() {
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Native ");
            stringBuilder.append(this.adFormat.getLabel());
            stringBuilder.append(" ad closed");
            googleMediationAdapter.log(stringBuilder.toString());
            this.listener.onAdViewAdCollapsed();
        }

        public void onAdFailedToLoad(LoadAdError object) {
            MaxAdapterError maxAdapterError = GoogleMediationAdapter.toMaxError((AdError)object);
            object = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Native ");
            stringBuilder.append(this.adFormat.getLabel());
            stringBuilder.append(" ad (");
            stringBuilder.append(this.placementId);
            stringBuilder.append(") failed to load with error: ");
            stringBuilder.append(maxAdapterError);
            object.log(stringBuilder.toString());
            this.listener.onAdViewAdLoadFailed(maxAdapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Native ");
            stringBuilder.append(this.adFormat.getLabel());
            stringBuilder.append(" ad shown");
            googleMediationAdapter.log(stringBuilder.toString());
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdOpened() {
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Native ");
            stringBuilder.append(this.adFormat.getLabel());
            stringBuilder.append(" ad opened");
            googleMediationAdapter.log(stringBuilder.toString());
            this.listener.onAdViewAdExpanded();
        }

        @Override
        public void onNativeAdLoaded(NativeAd nativeAd) {
            Object object = GoogleMediationAdapter.this;
            Object object2 = new StringBuilder();
            ((StringBuilder)object2).append("Native ");
            ((StringBuilder)object2).append(this.adFormat.getLabel());
            ((StringBuilder)object2).append(" ad loaded: ");
            ((StringBuilder)object2).append(this.placementId);
            object.log(((StringBuilder)object2).toString());
            object = (Activity)this.activityRef.get();
            if (object == null) {
                object = GoogleMediationAdapter.this;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Native ");
                ((StringBuilder)object2).append(this.adFormat.getLabel());
                ((StringBuilder)object2).append(" ad failed to load: activity reference is null when ad is loaded");
                object.log(((StringBuilder)object2).toString());
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.INVALID_LOAD_STATE);
                nativeAd.destroy();
                return;
            }
            if (!this.isValidNativeAd(nativeAd)) {
                object2 = GoogleMediationAdapter.this;
                object = new StringBuilder();
                ((StringBuilder)object).append("Native ");
                ((StringBuilder)object).append(this.adFormat.getLabel());
                ((StringBuilder)object).append(" ad failed to load: Google native ad is missing one or more required assets");
                object2.log(((StringBuilder)object).toString());
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
                nativeAd.destroy();
                return;
            }
            MediaView mediaView = new MediaView((Context)object);
            mediaView.setMediaContent(nativeAd.getMediaContent());
            object2 = nativeAd.getIcon();
            object2 = ((NativeAd.Image)object2).getDrawable() != null ? new MaxNativeAd.MaxNativeAdImage(((NativeAd.Image)object2).getDrawable()) : new MaxNativeAd.MaxNativeAdImage(((NativeAd.Image)object2).getUri());
            object2 = new MaxNativeAd.Builder().setAdFormat(this.adFormat).setIcon((MaxNativeAd.MaxNativeAdImage)object2).setTitle(nativeAd.getHeadline()).setBody(nativeAd.getBody()).setMediaView((View)mediaView).setCallToAction(nativeAd.getCallToAction()).build();
            String string2 = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            if (string2.contains("vertical") && AppLovinSdk.VERSION_CODE < 9140500) {
                GoogleMediationAdapter.this.log("Vertical native banners are only supported on MAX SDK 9.14.5 and above. Default horizontal native template will be used.");
            }
            AppLovinSdkUtils.runOnUiThread(new Runnable((MaxNativeAd)object2, (Activity)object, string2, mediaView, nativeAd){
                final /* synthetic */ Activity val$activity;
                final /* synthetic */ MaxNativeAd val$maxNativeAd;
                final /* synthetic */ MediaView val$mediaView;
                final /* synthetic */ NativeAd val$nativeAd;
                final /* synthetic */ String val$templateName;
                {
                    this.val$maxNativeAd = maxNativeAd;
                    this.val$activity = activity;
                    this.val$templateName = string2;
                    this.val$mediaView = mediaView;
                    this.val$nativeAd = nativeAd;
                }

                @Override
                public void run() {
                    Object object;
                    if (AppLovinSdk.VERSION_CODE < 9140000) {
                        GoogleMediationAdapter.this.log("Native ads with media views are only supported on MAX SDK version 9.14.0 and above. Default native template will be used.");
                        object = new MaxNativeAdView(this.val$maxNativeAd, this.val$activity);
                    } else {
                        object = new MaxNativeAdView(this.val$maxNativeAd, this.val$templateName, this.val$activity);
                    }
                    GoogleMediationAdapter.access$1102(GoogleMediationAdapter.this, new NativeAdView(object.getContext()));
                    GoogleMediationAdapter.this.nativeAdView.setIconView((View)object.getIconContentView());
                    GoogleMediationAdapter.this.nativeAdView.setHeadlineView((View)object.getTitleTextView());
                    GoogleMediationAdapter.this.nativeAdView.setBodyView((View)object.getBodyTextView());
                    GoogleMediationAdapter.this.nativeAdView.setMediaView(this.val$mediaView);
                    GoogleMediationAdapter.this.nativeAdView.setCallToActionView((View)object.getCallToActionButton());
                    GoogleMediationAdapter.this.nativeAdView.setNativeAd(this.val$nativeAd);
                    GoogleMediationAdapter.this.nativeAdView.addView((View)object);
                    object = this.val$nativeAd.getResponseInfo();
                    object = object != null ? ((ResponseInfo)object).getResponseId() : null;
                    if (AppLovinSdk.VERSION_CODE >= 9150000 && AppLovinSdkUtils.isValidString((String)object)) {
                        Bundle bundle = new Bundle(1);
                        bundle.putString("creative_id", (String)object);
                        NativeAdViewListener.this.listener.onAdViewAdLoaded((View)GoogleMediationAdapter.this.nativeAdView, bundle);
                    } else {
                        NativeAdViewListener.this.listener.onAdViewAdLoaded((View)GoogleMediationAdapter.this.nativeAdView);
                    }
                }
            });
        }
    }

    private class RewardedAdListener
    extends FullScreenContentCallback {
        private boolean hasGrantedReward;
        private final MaxRewardedAdapterListener listener;
        private final String placementId;

        RewardedAdListener(String string2, MaxRewardedAdapterListener maxRewardedAdapterListener) {
            this.placementId = string2;
            this.listener = maxRewardedAdapterListener;
        }

        static /* synthetic */ boolean access$902(RewardedAdListener rewardedAdListener, boolean bl) {
            rewardedAdListener.hasGrantedReward = bl;
            return bl;
        }

        public void onAdDismissedFullScreenContent() {
            Object object;
            Object object2;
            this.listener.onRewardedAdVideoCompleted();
            if (this.hasGrantedReward || GoogleMediationAdapter.this.shouldAlwaysRewardUser()) {
                object2 = GoogleMediationAdapter.this.getReward();
                object = GoogleMediationAdapter.this;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Rewarded user with reward: ");
                stringBuilder.append(object2);
                object.log(stringBuilder.toString());
                this.listener.onUserRewarded(object2);
            }
            object2 = GoogleMediationAdapter.this;
            object = new StringBuilder();
            ((StringBuilder)object).append("Rewarded ad hidden: ");
            ((StringBuilder)object).append(this.placementId);
            object2.log(((StringBuilder)object).toString());
            this.listener.onRewardedAdHidden();
        }

        public void onAdFailedToShowFullScreenContent(AdError object) {
            MaxAdapterError maxAdapterError = GoogleMediationAdapter.toMaxError((AdError)object);
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            object = new StringBuilder();
            ((StringBuilder)object).append("Rewarded ad (");
            ((StringBuilder)object).append(this.placementId);
            ((StringBuilder)object).append(") failed to show with error: ");
            ((StringBuilder)object).append(maxAdapterError);
            googleMediationAdapter.log(((StringBuilder)object).toString());
            this.listener.onRewardedAdDisplayFailed(maxAdapterError);
        }

        public void onAdShowedFullScreenContent() {
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Rewarded ad shown: ");
            stringBuilder.append(this.placementId);
            googleMediationAdapter.log(stringBuilder.toString());
            this.listener.onRewardedAdDisplayed();
            this.listener.onRewardedAdVideoStarted();
        }
    }

    private class RewardedInterstitialAdListener
    extends FullScreenContentCallback {
        private boolean hasGrantedReward;
        private final MaxRewardedInterstitialAdapterListener listener;
        private final String placementId;

        private RewardedInterstitialAdListener(String string2, MaxRewardedInterstitialAdapterListener maxRewardedInterstitialAdapterListener) {
            this.placementId = string2;
            this.listener = maxRewardedInterstitialAdapterListener;
        }

        static /* synthetic */ boolean access$602(RewardedInterstitialAdListener rewardedInterstitialAdListener, boolean bl) {
            rewardedInterstitialAdListener.hasGrantedReward = bl;
            return bl;
        }

        public void onAdDismissedFullScreenContent() {
            Object object;
            Object object2;
            this.listener.onRewardedInterstitialAdVideoCompleted();
            if (this.hasGrantedReward || GoogleMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward maxReward = GoogleMediationAdapter.this.getReward();
                object2 = GoogleMediationAdapter.this;
                object = new StringBuilder();
                ((StringBuilder)object).append("Rewarded interstitial ad rewarded user with reward: ");
                ((StringBuilder)object).append(maxReward);
                object2.log(((StringBuilder)object).toString());
                this.listener.onUserRewarded(maxReward);
            }
            object = GoogleMediationAdapter.this;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Rewarded interstitial ad hidden: ");
            ((StringBuilder)object2).append(this.placementId);
            object.log(((StringBuilder)object2).toString());
            this.listener.onRewardedInterstitialAdHidden();
        }

        public void onAdFailedToShowFullScreenContent(AdError object) {
            MaxAdapterError maxAdapterError = GoogleMediationAdapter.toMaxError((AdError)object);
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            object = new StringBuilder();
            ((StringBuilder)object).append("Rewarded interstitial ad (");
            ((StringBuilder)object).append(this.placementId);
            ((StringBuilder)object).append(") failed to show with error: ");
            ((StringBuilder)object).append(maxAdapterError);
            googleMediationAdapter.log(((StringBuilder)object).toString());
            this.listener.onRewardedInterstitialAdDisplayFailed(maxAdapterError);
        }

        public void onAdShowedFullScreenContent() {
            GoogleMediationAdapter googleMediationAdapter = GoogleMediationAdapter.this;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Rewarded interstitial ad shown: ");
            stringBuilder.append(this.placementId);
            googleMediationAdapter.log(stringBuilder.toString());
            this.listener.onRewardedInterstitialAdDisplayed();
            this.listener.onRewardedInterstitialAdVideoStarted();
        }
    }
}

