/*
 * Decompiled with CFR 0.152.
 */
package com.android.installreferrer.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.android.installreferrer.commons.InstallReferrerCommons;
import com.google.android.finsky.externalreferrer.IGetInstallReferrerService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

class InstallReferrerClientImpl
extends InstallReferrerClient {
    private static final int PLAY_STORE_MIN_APP_VER = 80837300;
    private static final String SERVICE_ACTION_NAME = "com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE";
    private static final String SERVICE_NAME = "com.google.android.finsky.externalreferrer.GetInstallReferrerService";
    private static final String SERVICE_PACKAGE_NAME = "com.android.vending";
    private static final String TAG = "InstallReferrerClient";
    private int clientState = 0;
    private final Context mApplicationContext;
    private IGetInstallReferrerService service;
    private ServiceConnection serviceConnection;

    public InstallReferrerClientImpl(Context context) {
        this.mApplicationContext = context.getApplicationContext();
    }

    static /* synthetic */ IGetInstallReferrerService access$102(InstallReferrerClientImpl installReferrerClientImpl, IGetInstallReferrerService iGetInstallReferrerService) {
        installReferrerClientImpl.service = iGetInstallReferrerService;
        return iGetInstallReferrerService;
    }

    static /* synthetic */ int access$202(InstallReferrerClientImpl installReferrerClientImpl, int n2) {
        installReferrerClientImpl.clientState = n2;
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPlayStoreCompatible() {
        block3: {
            PackageManager packageManager = this.mApplicationContext.getPackageManager();
            try {
                int n2 = packageManager.getPackageInfo((String)SERVICE_PACKAGE_NAME, (int)128).versionCode;
                if (n2 < 80837300) break block3;
                return true;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void endConnection() {
        this.clientState = 3;
        if (this.serviceConnection != null) {
            InstallReferrerCommons.logVerbose((String)TAG, (String)"Unbinding from service.");
            this.mApplicationContext.unbindService(this.serviceConnection);
            this.serviceConnection = null;
        }
        this.service = null;
    }

    @Override
    public ReferrerDetails getInstallReferrer() throws RemoteException {
        if (this.isReady()) {
            Object object = new Bundle();
            object.putString("package_name", this.mApplicationContext.getPackageName());
            try {
                object = new ReferrerDetails(this.service.a(object));
                return object;
            }
            catch (RemoteException remoteException) {
                InstallReferrerCommons.logWarn((String)TAG, (String)"RemoteException getting install referrer information");
                this.clientState = 0;
                throw remoteException;
            }
        }
        throw new IllegalStateException("Service not connected. Please start a connection before using the service.");
    }

    @Override
    public boolean isReady() {
        return this.clientState == 2 && this.service != null && this.serviceConnection != null;
    }

    @Override
    public void startConnection(InstallReferrerStateListener installReferrerStateListener) {
        if (this.isReady()) {
            InstallReferrerCommons.logVerbose((String)TAG, (String)"Service connection is valid. No need to re-initialize.");
            installReferrerStateListener.onInstallReferrerSetupFinished(0);
            return;
        }
        int n2 = this.clientState;
        if (n2 == 1) {
            InstallReferrerCommons.logWarn((String)TAG, (String)"Client is already in the process of connecting to the service.");
            installReferrerStateListener.onInstallReferrerSetupFinished(3);
            return;
        }
        if (n2 == 3) {
            InstallReferrerCommons.logWarn((String)TAG, (String)"Client was already closed and can't be reused. Please create another instance.");
            installReferrerStateListener.onInstallReferrerSetupFinished(3);
            return;
        }
        InstallReferrerCommons.logVerbose((String)TAG, (String)"Starting install referrer service setup.");
        Intent intent = new Intent(SERVICE_ACTION_NAME);
        intent.setComponent(new ComponentName(SERVICE_PACKAGE_NAME, SERVICE_NAME));
        Object object = this.mApplicationContext.getPackageManager().queryIntentServices(intent, 0);
        if (object != null && !object.isEmpty()) {
            Object object2 = (ResolveInfo)object.get(0);
            if (object2.serviceInfo != null) {
                object = object2.serviceInfo.packageName;
                object2 = object2.serviceInfo.name;
                if (SERVICE_PACKAGE_NAME.equals(object) && object2 != null && this.isPlayStoreCompatible()) {
                    intent = new Intent(intent);
                    this.serviceConnection = new InstallReferrerServiceConnection(installReferrerStateListener);
                    if (this.mApplicationContext.bindService(intent, this.serviceConnection, 1)) {
                        InstallReferrerCommons.logVerbose((String)TAG, (String)"Service was bonded successfully.");
                        return;
                    }
                    InstallReferrerCommons.logWarn((String)TAG, (String)"Connection to service is blocked.");
                    this.clientState = 0;
                    installReferrerStateListener.onInstallReferrerSetupFinished(1);
                    return;
                }
                InstallReferrerCommons.logWarn((String)TAG, (String)"Play Store missing or incompatible. Version 8.3.73 or later required.");
                this.clientState = 0;
                installReferrerStateListener.onInstallReferrerSetupFinished(2);
                return;
            }
        }
        this.clientState = 0;
        InstallReferrerCommons.logVerbose((String)TAG, (String)"Install Referrer service unavailable on device.");
        installReferrerStateListener.onInstallReferrerSetupFinished(2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ClientState {
        public static final int CLOSED = 3;
        public static final int CONNECTED = 2;
        public static final int CONNECTING = 1;
        public static final int DISCONNECTED = 0;
    }

    private final class InstallReferrerServiceConnection
    implements ServiceConnection {
        private final InstallReferrerStateListener mListener;

        private InstallReferrerServiceConnection(InstallReferrerStateListener installReferrerStateListener) {
            if (installReferrerStateListener != null) {
                this.mListener = installReferrerStateListener;
                return;
            }
            throw new RuntimeException("Please specify a listener to know when setup is done.");
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InstallReferrerCommons.logVerbose((String)InstallReferrerClientImpl.TAG, (String)"Install Referrer service connected.");
            InstallReferrerClientImpl.access$102(InstallReferrerClientImpl.this, IGetInstallReferrerService.Stub.a((IBinder)iBinder));
            InstallReferrerClientImpl.access$202(InstallReferrerClientImpl.this, 2);
            this.mListener.onInstallReferrerSetupFinished(0);
        }

        public void onServiceDisconnected(ComponentName componentName) {
            InstallReferrerCommons.logWarn((String)InstallReferrerClientImpl.TAG, (String)"Install Referrer service disconnected.");
            InstallReferrerClientImpl.access$102(InstallReferrerClientImpl.this, null);
            InstallReferrerClientImpl.access$202(InstallReferrerClientImpl.this, 0);
            this.mListener.onInstallReferrerServiceDisconnected();
        }
    }
}

