/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.text.TextUtils;
import com.android.billingclient.api.AccountIdentifiers;
import com.android.billingclient.api.BillingResult;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Purchase {
    private final String zza;
    private final String zzb;
    private final JSONObject zzc;

    public Purchase(String string2, String string3) throws JSONException {
        this.zza = string2;
        this.zzb = string3;
        this.zzc = new JSONObject(this.zza);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Purchase)) {
            return false;
        }
        return TextUtils.equals((CharSequence)this.zza, (CharSequence)((Purchase)(object = (Purchase)object)).getOriginalJson()) && TextUtils.equals((CharSequence)this.zzb, (CharSequence)((Purchase)object).getSignature());
    }

    public AccountIdentifiers getAccountIdentifiers() {
        String string2 = this.zzc.optString("obfuscatedAccountId");
        String string3 = this.zzc.optString("obfuscatedProfileId");
        if (string2 == null && string3 == null) {
            return null;
        }
        return new AccountIdentifiers(string2, string3);
    }

    public String getDeveloperPayload() {
        return this.zzc.optString("developerPayload");
    }

    public String getOrderId() {
        return this.zzc.optString("orderId");
    }

    public String getOriginalJson() {
        return this.zza;
    }

    public String getPackageName() {
        return this.zzc.optString("packageName");
    }

    public int getPurchaseState() {
        if (this.zzc.optInt("purchaseState", 1) != 4) {
            return 1;
        }
        return 2;
    }

    public long getPurchaseTime() {
        return this.zzc.optLong("purchaseTime");
    }

    public String getPurchaseToken() {
        JSONObject jSONObject = this.zzc;
        return jSONObject.optString("token", jSONObject.optString("purchaseToken"));
    }

    public String getSignature() {
        return this.zzb;
    }

    public String getSku() {
        return this.zzc.optString("productId");
    }

    public int hashCode() {
        return this.zza.hashCode();
    }

    public boolean isAcknowledged() {
        return this.zzc.optBoolean("acknowledged", true);
    }

    public boolean isAutoRenewing() {
        return this.zzc.optBoolean("autoRenewing");
    }

    public String toString() {
        String string2 = String.valueOf(this.zza);
        if (string2.length() != 0) {
            return "Purchase. Json: ".concat(string2);
        }
        return new String("Purchase. Json: ");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PurchaseState {
        public static final int PENDING = 2;
        public static final int PURCHASED = 1;
        public static final int UNSPECIFIED_STATE = 0;
    }

    public static class PurchasesResult {
        private final List<Purchase> zza;
        private final BillingResult zzb;

        public PurchasesResult(BillingResult billingResult, List<Purchase> list) {
            this.zza = list;
            this.zzb = billingResult;
        }

        public BillingResult getBillingResult() {
            return this.zzb;
        }

        public List<Purchase> getPurchasesList() {
            return this.zza;
        }

        public int getResponseCode() {
            return this.getBillingResult().getResponseCode();
        }
    }
}

