/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.app.Activity;
import android.content.Context;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingClientImpl;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.PriceChangeConfirmationListener;
import com.android.billingclient.api.PriceChangeFlowParams;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.android.billingclient.api.zzf;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class BillingClient {
    public static Builder newBuilder(Context context) {
        return new Builder(context, null);
    }

    public abstract void acknowledgePurchase(AcknowledgePurchaseParams var1, AcknowledgePurchaseResponseListener var2);

    public abstract void consumeAsync(ConsumeParams var1, ConsumeResponseListener var2);

    public abstract void endConnection();

    public abstract BillingResult isFeatureSupported(String var1);

    public abstract boolean isReady();

    public abstract BillingResult launchBillingFlow(Activity var1, BillingFlowParams var2);

    public abstract void launchPriceChangeConfirmationFlow(Activity var1, PriceChangeFlowParams var2, PriceChangeConfirmationListener var3);

    public abstract void queryPurchaseHistoryAsync(String var1, PurchaseHistoryResponseListener var2);

    public abstract Purchase.PurchasesResult queryPurchases(String var1);

    public abstract void querySkuDetailsAsync(SkuDetailsParams var1, SkuDetailsResponseListener var2);

    public abstract void startConnection(BillingClientStateListener var1);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BillingResponseCode {
        public static final int BILLING_UNAVAILABLE = 3;
        public static final int DEVELOPER_ERROR = 5;
        public static final int ERROR = 6;
        public static final int FEATURE_NOT_SUPPORTED = -2;
        public static final int ITEM_ALREADY_OWNED = 7;
        public static final int ITEM_NOT_OWNED = 8;
        public static final int ITEM_UNAVAILABLE = 4;
        public static final int OK = 0;
        public static final int SERVICE_DISCONNECTED = -1;
        public static final int SERVICE_TIMEOUT = -3;
        public static final int SERVICE_UNAVAILABLE = 2;
        public static final int USER_CANCELED = 1;
    }

    public static final class Builder {
        private boolean zza;
        private final Context zzb;
        private PurchasesUpdatedListener zzc;

        private Builder(Context context) {
            this.zzb = context;
        }

        /* synthetic */ Builder(Context context, zzf zzf2) {
            this(context);
        }

        public final BillingClient build() {
            Context context = this.zzb;
            if (context != null) {
                PurchasesUpdatedListener purchasesUpdatedListener = this.zzc;
                if (purchasesUpdatedListener != null) {
                    boolean bl = this.zza;
                    if (bl) {
                        return new BillingClientImpl(null, bl, context, purchasesUpdatedListener);
                    }
                    throw new IllegalArgumentException("Support for pending purchases must be enabled. Enable this by calling 'enablePendingPurchases()' on BillingClientBuilder.");
                }
                throw new IllegalArgumentException("Please provide a valid listener for purchases updates.");
            }
            throw new IllegalArgumentException("Please provide a valid Context.");
        }

        public final Builder enablePendingPurchases() {
            this.zza = true;
            return this;
        }

        public final Builder setListener(PurchasesUpdatedListener purchasesUpdatedListener) {
            this.zzc = purchasesUpdatedListener;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureType {
        public static final String IN_APP_ITEMS_ON_VR = "inAppItemsOnVr";
        public static final String PRICE_CHANGE_CONFIRMATION = "priceChangeConfirmation";
        public static final String SUBSCRIPTIONS = "subscriptions";
        public static final String SUBSCRIPTIONS_ON_VR = "subscriptionsOnVr";
        public static final String SUBSCRIPTIONS_UPDATE = "subscriptionsUpdate";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SkuType {
        public static final String INAPP = "inapp";
        public static final String SUBS = "subs";
    }
}

