/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.android;

import android.content.Context;
import cn.thinkingdata.android.SharedPreferencesLoader;
import cn.thinkingdata.android.TDContextConfig;
import cn.thinkingdata.android.ThinkingAnalyticsSDK;
import cn.thinkingdata.android.persistence.StorageFlushBulkSize;
import cn.thinkingdata.android.persistence.StorageFlushInterval;
import cn.thinkingdata.android.utils.TDLog;
import cn.thinkingdata.android.utils.TDUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class TDConfig {
    static final int DEFAULT_FLUSH_BULK_SIZE = 20;
    static final int DEFAULT_FLUSH_INTERVAL = 15000;
    private static final String PREFERENCE_NAME_PREFIX = "cn.thinkingdata.android.config";
    private static final String TAG = "ThinkingAnalytics.TDConfig";
    public static final String VERSION = "2.7.1";
    private static final Map<Context, Map<String, TDConfig>> sInstances;
    private static final SharedPreferencesLoader sPrefsLoader;
    private volatile boolean mAllowedDebug;
    private final String mConfigUrl;
    final Context mContext;
    private final TDContextConfig mContextConfig;
    private final String mDebugUrl;
    private TimeZone mDefaultTimeZone;
    private final Set<String> mDisabledEvents = new HashSet<String>();
    private final ReadWriteLock mDisabledEventsLock = new ReentrantReadWriteLock();
    private boolean mEnableMutiprocess;
    private final StorageFlushBulkSize mFlushBulkSize;
    private final StorageFlushInterval mFlushInterval;
    private volatile ModeEnum mMode = ModeEnum.NORMAL;
    private int mNetworkType = 255;
    private SSLSocketFactory mSSLSocketFactory;
    private final String mServerUrl;
    final String mToken;
    private volatile boolean mTrackOldData = true;

    static {
        sPrefsLoader = new SharedPreferencesLoader();
        sInstances = new HashMap<Context, Map<String, TDConfig>>();
    }

    private TDConfig(Context object, String string2, String string3) {
        Object object2 = object.getApplicationContext();
        this.mContext = object2;
        SharedPreferencesLoader sharedPreferencesLoader = sPrefsLoader;
        object = new StringBuilder();
        ((StringBuilder)object).append("cn.thinkingdata.android.config_");
        ((StringBuilder)object).append(string2);
        object = sharedPreferencesLoader.loadPreferences((Context)object2, ((StringBuilder)object).toString());
        this.mContextConfig = TDContextConfig.getInstance((Context)this.mContext);
        this.mToken = string2;
        object2 = new StringBuilder();
        ((StringBuilder)object2).append(string3);
        ((StringBuilder)object2).append("/sync");
        this.mServerUrl = ((StringBuilder)object2).toString();
        object2 = new StringBuilder();
        ((StringBuilder)object2).append(string3);
        ((StringBuilder)object2).append("/data_debug");
        this.mDebugUrl = ((StringBuilder)object2).toString();
        object2 = new StringBuilder();
        ((StringBuilder)object2).append(string3);
        ((StringBuilder)object2).append("/config?appid=");
        ((StringBuilder)object2).append(string2);
        this.mConfigUrl = ((StringBuilder)object2).toString();
        this.mFlushInterval = new StorageFlushInterval((Future)object, 15000);
        this.mFlushBulkSize = new StorageFlushBulkSize((Future)object, 20);
        this.mEnableMutiprocess = false;
    }

    static /* synthetic */ String access$000(TDConfig tDConfig) {
        return tDConfig.mConfigUrl;
    }

    static /* synthetic */ StorageFlushInterval access$100(TDConfig tDConfig) {
        return tDConfig.mFlushInterval;
    }

    static /* synthetic */ StorageFlushBulkSize access$200(TDConfig tDConfig) {
        return tDConfig.mFlushBulkSize;
    }

    static /* synthetic */ ReadWriteLock access$300(TDConfig tDConfig) {
        return tDConfig.mDisabledEventsLock;
    }

    static /* synthetic */ Set access$400(TDConfig tDConfig) {
        return tDConfig.mDisabledEvents;
    }

    private int convertToNetworkType(String string2) {
        if ("NULL".equals(string2)) {
            return 255;
        }
        if ("WIFI".equals(string2)) {
            return 8;
        }
        if ("2G".equals(string2)) {
            return 1;
        }
        if ("3G".equals(string2)) {
            return 2;
        }
        if ("4G".equals(string2)) {
            return 4;
        }
        if ("5G".equals(string2)) {
            return 16;
        }
        return 255;
    }

    static TDConfig getInstance(Context object, String string2) {
        try {
            object = TDConfig.getInstance(object, string2, "");
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TDConfig getInstance(Context object, String object2, String charSequence) {
        Context context = object.getApplicationContext();
        Map<Context, Map<String, TDConfig>> map = sInstances;
        synchronized (map) {
            StringBuilder stringBuilder;
            URL uRL;
            Object object3;
            object = object3 = sInstances.get(context);
            if (object3 == null) {
                object = new HashMap();
                sInstances.put(context, (Map<String, TDConfig>)object);
            }
            if ((object3 = (TDConfig)object.get(object2)) != null) return object3;
            try {
                uRL = new URL((String)charSequence);
                stringBuilder = new StringBuilder();
                stringBuilder.append(uRL.getProtocol());
            }
            catch (MalformedURLException malformedURLException) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Invalid server URL: ");
                ((StringBuilder)object2).append((String)charSequence);
                TDLog.e((String)TAG, (String)((StringBuilder)object2).toString());
                object2 = new IllegalArgumentException(malformedURLException);
                throw object2;
            }
            stringBuilder.append("://");
            stringBuilder.append(uRL.getHost());
            if (uRL.getPort() > 0) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(":");
                ((StringBuilder)charSequence).append(uRL.getPort());
                charSequence = ((StringBuilder)charSequence).toString();
            } else {
                charSequence = "";
            }
            stringBuilder.append((String)charSequence);
            object3 = new TDConfig(context, (String)object2, stringBuilder.toString());
            object.put(object2, object3);
            super.getRemoteConfig();
            return object3;
        }
    }

    private void getRemoteConfig() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                block34: {
                    block42: {
                        block40: {
                            block36: {
                                block39: {
                                    block35: {
                                        block38: {
                                            block41: {
                                                var1_1 = null;
                                                var2_2 = null;
                                                var3_4 = null;
                                                var4_6 = null;
                                                var5_7 = null;
                                                var6_8 = null;
                                                var7_9 = null;
                                                var8_14 = new URL(TDConfig.access$000(TDConfig.this));
                                                var9_19 = (HttpURLConnection)var8_14.openConnection();
                                                var3_4 = var1_1;
                                                var4_6 = var2_2;
                                                var8_14 = var5_7;
                                                var6_8 = var9_19;
                                                ** try [egrp 1[TRYBLOCK] [3, 5 : 58->847)] { 
lbl16:
                                                // 1 sources

                                                break block41;
lbl17:
                                                // 1 sources

                                                catch (Throwable var9_21) {
                                                    var7_9 = var8_14;
                                                    var8_14 = var9_21;
                                                    break block34;
                                                }
                                                catch (Throwable var8_16) {
                                                    var9_20 = null;
                                                    var7_9 = var6_8;
                                                    var6_8 = var9_20;
                                                    break block34;
                                                }
                                                catch (JSONException var7_12) {
                                                    var9_19 = null;
                                                    break block35;
                                                }
                                                catch (IOException var7_13) {
                                                    var9_19 = null;
                                                    break block36;
                                                }
                                            }
                                            var10_23 = TDConfig.this.getSSLSocketFactory();
                                            if (var10_23 != null) {
                                                var3_4 = var1_1;
                                                var4_6 = var2_2;
                                                var8_14 = var5_7;
                                                var6_8 = var9_19;
                                                if (var9_19 instanceof HttpsURLConnection) {
                                                    var3_4 = var1_1;
                                                    var4_6 = var2_2;
                                                    var8_14 = var5_7;
                                                    var6_8 = var9_19;
                                                    ((HttpsURLConnection)var9_19).setSSLSocketFactory((SSLSocketFactory)var10_23);
                                                }
                                            }
                                            var3_4 = var1_1;
                                            var4_6 = var2_2;
                                            var8_14 = var5_7;
                                            var6_8 = var9_19;
                                            var9_19.setRequestMethod("GET");
                                            var3_4 = var1_1;
                                            var4_6 = var2_2;
                                            var8_14 = var5_7;
                                            var6_8 = var9_19;
                                            if (200 != var9_19.getResponseCode()) ** GOTO lbl-1000
                                            var3_4 = var1_1;
                                            var4_6 = var2_2;
                                            var8_14 = var5_7;
                                            var6_8 = var9_19;
                                            var3_4 = var7_9 = var9_19.getInputStream();
                                            var4_6 = var7_9;
                                            var8_14 = var7_9;
                                            var6_8 = var9_19;
                                            var3_4 = var7_9;
                                            var4_6 = var7_9;
                                            var8_14 = var7_9;
                                            var6_8 = var9_19;
                                            var3_4 = var7_9;
                                            var4_6 = var7_9;
                                            var8_14 = var7_9;
                                            var6_8 = var9_19;
                                            var2_2 = new InputStreamReader((InputStream)var7_9);
                                            var3_4 = var7_9;
                                            var4_6 = var7_9;
                                            var8_14 = var7_9;
                                            var6_8 = var9_19;
                                            var1_1 = new BufferedReader((Reader)var2_2);
                                            var3_4 = var7_9;
                                            var4_6 = var7_9;
                                            var8_14 = var7_9;
                                            var6_8 = var9_19;
                                            var3_4 = var7_9;
                                            var4_6 = var7_9;
                                            var8_14 = var7_9;
                                            var6_8 = var9_19;
                                            var2_2 = new StringBuffer();
                                            while (true) {
                                                var3_4 = var7_9;
                                                var4_6 = var7_9;
                                                var8_14 = var7_9;
                                                var6_8 = var9_19;
                                                var5_7 = var1_1.readLine();
                                                if (var5_7 == null) break;
                                                var3_4 = var7_9;
                                                var4_6 = var7_9;
                                                var8_14 = var7_9;
                                                var6_8 = var9_19;
                                                var2_2.append(var5_7);
                                            }
                                            var3_4 = var7_9;
                                            var4_6 = var7_9;
                                            var8_14 = var7_9;
                                            var6_8 = var9_19;
                                            var3_4 = var7_9;
                                            var4_6 = var7_9;
                                            var8_14 = var7_9;
                                            var6_8 = var9_19;
                                            var5_7 = new JSONObject(var2_2.toString());
                                            var3_4 = var7_9;
                                            var4_6 = var7_9;
                                            var8_14 = var7_9;
                                            var6_8 = var9_19;
                                            if (var5_7.getString("code").equals("0")) {
                                                var3_4 = var7_9;
                                                var4_6 = var7_9;
                                                var8_14 = var7_9;
                                                var6_8 = var9_19;
                                                var11_24 = (Integer)TDConfig.access$100(TDConfig.this).get();
                                                var3_4 = var7_9;
                                                var4_6 = var7_9;
                                                var8_14 = var7_9;
                                                var6_8 = var9_19;
                                                var12_25 = (Integer)TDConfig.access$200(TDConfig.this).get();
                                                var13_26 = var11_24;
                                                var14_27 = var12_25;
                                                var4_6 = var7_9;
                                                var8_14 = var7_9;
                                                var6_8 = var9_19;
                                            }
                                            ** GOTO lbl234
                                            {
                                                catch (JSONException var7_10) {
                                                    break block35;
                                                }
                                                try {
                                                    var3_4 = var5_7.getJSONObject("data");
                                                    var13_26 = var11_24;
                                                    var14_27 = var12_25;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    var13_26 = var11_24 = var3_4.getInt("sync_interval") * 1000;
                                                    var14_27 = var12_25;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    var12_25 = var3_4.getInt("sync_batch_size");
                                                    var13_26 = var11_24;
                                                    var14_27 = var12_25;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    var13_26 = var11_24;
                                                    var14_27 = var12_25;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    var2_2 = new StringBuilder();
                                                    var13_26 = var11_24;
                                                    var14_27 = var12_25;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    var2_2.append("Fetched remote config for (");
                                                    var13_26 = var11_24;
                                                    var14_27 = var12_25;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    var2_2.append(TDUtils.getSuffix((String)TDConfig.this.mToken, (int)4));
                                                    var13_26 = var11_24;
                                                    var14_27 = var12_25;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    var2_2.append("):\n");
                                                    var13_26 = var11_24;
                                                    var14_27 = var12_25;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    var2_2.append(var3_4.toString(4));
                                                    var13_26 = var11_24;
                                                    var14_27 = var12_25;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    TDLog.d((String)"ThinkingAnalytics.TDConfig", (String)var2_2.toString());
                                                    var13_26 = var11_24;
                                                    var14_27 = var12_25;
                                                    var15_28 = var11_24;
                                                    var16_29 = var12_25;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    if (!var3_4.has("disable_event_list")) ** GOTO lbl214
                                                    var13_26 = var11_24;
                                                    var14_27 = var12_25;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    TDConfig.access$300(TDConfig.this).writeLock().lock();
                                                }
lbl206:
                                                // 2 sources

                                                catch (JSONException var2_3) {}
                                                var3_4 = var7_9;
                                                var4_6 = var7_9;
                                                var8_14 = var7_9;
                                                var6_8 = var9_19;
                                                {
                                                    var2_3.printStackTrace();
                                                    var16_29 = var14_27;
                                                    var15_28 = var13_26;
lbl214:
                                                    // 3 sources

                                                    var3_4 = var7_9;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    if ((Integer)TDConfig.access$200(TDConfig.this).get() != var16_29) {
                                                        var3_4 = var7_9;
                                                        var4_6 = var7_9;
                                                        var8_14 = var7_9;
                                                        var6_8 = var9_19;
                                                        TDConfig.access$200(TDConfig.this).put((Object)var16_29);
                                                    }
                                                    var3_4 = var7_9;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    if ((Integer)TDConfig.access$100(TDConfig.this).get() != var15_28) {
                                                        var3_4 = var7_9;
                                                        var4_6 = var7_9;
                                                        var8_14 = var7_9;
                                                        var6_8 = var9_19;
                                                        TDConfig.access$100(TDConfig.this).put((Object)var15_28);
                                                    }
lbl234:
                                                    // 4 sources

                                                    var3_4 = var7_9;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    var7_9.close();
                                                    var3_4 = var7_9;
                                                    var4_6 = var7_9;
                                                    var8_14 = var7_9;
                                                    var6_8 = var9_19;
                                                    var1_1.close();
                                                    break block37;
                                                }
                                                var8_14 = var3_4.getJSONArray("disable_event_list");
                                                for (var13_26 = 0; var13_26 < var8_14.length(); ++var13_26) {
                                                    TDConfig.access$400(TDConfig.this).add(var8_14.getString(var13_26));
                                                }
                                                var13_26 = var11_24;
                                                var14_27 = var12_25;
                                                var4_6 = var7_9;
                                                var8_14 = var7_9;
                                                var6_8 = var9_19;
                                                {
                                                    catch (Throwable var3_5) {
                                                        var13_26 = var11_24;
                                                        var14_27 = var12_25;
                                                        var4_6 = var7_9;
                                                        var8_14 = var7_9;
                                                        var6_8 = var9_19;
                                                        TDConfig.access$300(TDConfig.this).writeLock().unlock();
                                                        var13_26 = var11_24;
                                                        var14_27 = var12_25;
                                                        var4_6 = var7_9;
                                                        var8_14 = var7_9;
                                                        var6_8 = var9_19;
                                                        throw var3_5;
                                                    }
                                                    ** try [egrp 6[TRYBLOCK] [98 : 914->1002)] { 
lbl271:
                                                    // 1 sources

                                                    TDConfig.access$300(TDConfig.this).writeLock().unlock();
                                                    var15_28 = var11_24;
                                                    var16_29 = var12_25;
                                                    ** GOTO lbl214
                                                }
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                block37: {
                                                    var3_4 = var1_1;
                                                    var4_6 = var2_2;
                                                    var8_14 = var5_7;
                                                    var6_8 = var9_19;
                                                    var3_4 = var1_1;
                                                    var4_6 = var2_2;
                                                    var8_14 = var5_7;
                                                    var6_8 = var9_19;
                                                    var10_23 = new StringBuilder();
                                                    var3_4 = var1_1;
                                                    var4_6 = var2_2;
                                                    var8_14 = var5_7;
                                                    var6_8 = var9_19;
                                                    var10_23.append("Getting remote config failed, responseCode is ");
                                                    var3_4 = var1_1;
                                                    var4_6 = var2_2;
                                                    var8_14 = var5_7;
                                                    var6_8 = var9_19;
                                                    var10_23.append(var9_19.getResponseCode());
                                                    var3_4 = var1_1;
                                                    var4_6 = var2_2;
                                                    var8_14 = var5_7;
                                                    var6_8 = var9_19;
                                                    TDLog.d((String)"ThinkingAnalytics.TDConfig", (String)var10_23.toString());
                                                }
                                                if (var7_9 == null) break block38;
                                            }
                                            try {
                                                var7_9.close();
                                            }
                                            catch (IOException var8_15) {
                                                var8_15.printStackTrace();
                                            }
                                        }
                                        if (var9_19 == null) return;
                                        break block42;
lbl311:
                                        // 1 sources

                                        catch (IOException var7_11) {
                                            break block36;
                                        }
                                    }
                                    var8_14 = var3_4;
                                    var6_8 = var9_19;
                                    {
                                        var8_14 = var3_4;
                                        var6_8 = var9_19;
                                        var4_6 = new StringBuilder();
                                        var8_14 = var3_4;
                                        var6_8 = var9_19;
                                        var4_6.append("Getting remote config failed due to: ");
                                        var8_14 = var3_4;
                                        var6_8 = var9_19;
                                        var4_6.append(var7_9.getMessage());
                                        var8_14 = var3_4;
                                        var6_8 = var9_19;
                                        TDLog.d((String)"ThinkingAnalytics.TDConfig", (String)var4_6.toString());
                                        if (var3_4 == null) break block39;
                                    }
                                    try {
                                        var3_4.close();
                                    }
                                    catch (IOException var8_17) {
                                        var8_17.printStackTrace();
                                    }
                                }
                                if (var9_19 == null) return;
                                break block42;
                            }
                            var8_14 = var4_6;
                            var6_8 = var9_19;
                            {
                                var8_14 = var4_6;
                                var6_8 = var9_19;
                                var3_4 = new StringBuilder();
                                var8_14 = var4_6;
                                var6_8 = var9_19;
                                var3_4.append("Getting remote config failed due to: ");
                                var8_14 = var4_6;
                                var6_8 = var9_19;
                                var3_4.append(var7_9.getMessage());
                                var8_14 = var4_6;
                                var6_8 = var9_19;
                                TDLog.d((String)"ThinkingAnalytics.TDConfig", (String)var3_4.toString());
                                if (var4_6 == null) break block40;
                            }
                            try {
                                var4_6.close();
                            }
                            catch (IOException var8_18) {
                                var8_18.printStackTrace();
                            }
                        }
                        if (var9_19 == null) return;
                    }
                    var9_19.disconnect();
                    return;
                }
                if (var7_9 != null) {
                    try {
                        var7_9.close();
                    }
                    catch (IOException var9_22) {
                        var9_22.printStackTrace();
                    }
                }
                if (var6_8 == null) throw var8_14;
                var6_8.disconnect();
                throw var8_14;
            }
        }).start();
    }

    String getDebugUrl() {
        return this.mDebugUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TimeZone getDefaultTimeZone() {
        synchronized (this) {
            TimeZone timeZone;
            TimeZone timeZone2 = timeZone = this.mDefaultTimeZone;
            if (timeZone != null) return timeZone2;
            return TimeZone.getDefault();
        }
    }

    int getFlushBulkSize() {
        return (Integer)this.mFlushBulkSize.get();
    }

    int getFlushInterval() {
        return (Integer)this.mFlushInterval.get();
    }

    String getMainProcessName() {
        return this.mContextConfig.getMainProcessName();
    }

    public ModeEnum getMode() {
        return this.mMode;
    }

    public int getModeInt() {
        return this.mMode.ordinal();
    }

    public SSLSocketFactory getSSLSocketFactory() {
        synchronized (this) {
            SSLSocketFactory sSLSocketFactory = this.mSSLSocketFactory;
            return sSLSocketFactory;
        }
    }

    String getServerUrl() {
        return this.mServerUrl;
    }

    boolean isDebug() {
        return ModeEnum.DEBUG.equals((Object)this.mMode);
    }

    boolean isDebugOnly() {
        return ModeEnum.DEBUG_ONLY.equals((Object)this.mMode);
    }

    boolean isDisabledEvent(String string2) {
        this.mDisabledEventsLock.readLock().lock();
        try {
            boolean bl = this.mDisabledEvents.contains(string2);
            return bl;
        }
        finally {
            this.mDisabledEventsLock.readLock().unlock();
        }
    }

    public boolean isEnableMutiprocess() {
        return this.mEnableMutiprocess;
    }

    boolean isNormal() {
        return ModeEnum.NORMAL.equals((Object)this.mMode);
    }

    boolean isShouldFlush(String string2) {
        synchronized (this) {
            int n2 = this.convertToNetworkType(string2);
            int n3 = this.mNetworkType;
            boolean bl = (n2 & n3) != 0;
            return bl;
        }
    }

    void setAllowDebug() {
        this.mAllowedDebug = true;
    }

    public void setDefaultTimeZone(TimeZone timeZone) {
        synchronized (this) {
            this.mDefaultTimeZone = timeZone;
            return;
        }
    }

    public void setMode(ModeEnum modeEnum) {
        this.mMode = modeEnum;
    }

    public void setModeInt(int n2) {
        if (n2 >= 0 && n2 <= 2) {
            this.mMode = ModeEnum.values()[n2];
            return;
        }
        TDLog.d((String)TAG, (String)"Invalid mode value");
    }

    public void setMutiprocess(boolean bl) {
        this.mEnableMutiprocess = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setNetworkType(ThinkingAnalyticsSDK.ThinkingdataNetworkType thinkingdataNetworkType) {
        synchronized (this) {
            int n2 = 2.$SwitchMap$cn$thinkingdata$android$ThinkingAnalyticsSDK$ThinkingdataNetworkType[thinkingdataNetworkType.ordinal()];
            if (n2 != 1) {
                if (n2 == 2 || n2 == 3) {
                    this.mNetworkType = 31;
                }
            } else {
                this.mNetworkType = 8;
            }
            return;
        }
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        synchronized (this) {
            if (sSLSocketFactory != null) {
                this.mSSLSocketFactory = sSLSocketFactory;
                this.getRemoteConfig();
            }
            return;
        }
    }

    public void setTrackOldData(boolean bl) {
        this.mTrackOldData = bl;
    }

    boolean shouldThrowException() {
        return false;
    }

    public boolean trackOldData() {
        return this.mTrackOldData;
    }

    public static final class ModeEnum
    extends Enum<ModeEnum> {
        private static final /* synthetic */ ModeEnum[] $VALUES;
        public static final /* enum */ ModeEnum DEBUG;
        public static final /* enum */ ModeEnum DEBUG_ONLY;
        public static final /* enum */ ModeEnum NORMAL;

        static {
            ModeEnum modeEnum;
            NORMAL = new ModeEnum();
            DEBUG = new ModeEnum();
            DEBUG_ONLY = modeEnum = new ModeEnum();
            $VALUES = new ModeEnum[]{NORMAL, DEBUG, modeEnum};
        }

        public static ModeEnum valueOf(String string2) {
            return Enum.valueOf(ModeEnum.class, string2);
        }

        public static ModeEnum[] values() {
            return (ModeEnum[])$VALUES.clone();
        }
    }

    private final class NetworkType {
        public static final int TYPE_2G = 1;
        public static final int TYPE_3G = 2;
        public static final int TYPE_4G = 4;
        public static final int TYPE_5G = 16;
        public static final int TYPE_ALL = 255;
        public static final int TYPE_WIFI = 8;

        private NetworkType() {
        }
    }
}

