/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.workers;

import android.content.Context;
import android.text.TextUtils;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.constraints.WorkConstraintsCallback;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;

public class ConstraintTrackingWorker
extends ListenableWorker
implements WorkConstraintsCallback {
    public static final String ARGUMENT_CLASS_NAME = "androidx.work.impl.workers.ConstraintTrackingWorker.ARGUMENT_CLASS_NAME";
    private static final String TAG = Logger.tagWithPrefix((String)"ConstraintTrkngWrkr");
    volatile boolean mAreConstraintsUnmet;
    private ListenableWorker mDelegate;
    SettableFuture<ListenableWorker.Result> mFuture;
    final Object mLock;
    private WorkerParameters mWorkerParameters;

    public ConstraintTrackingWorker(Context context, WorkerParameters workerParameters) {
        super(context, workerParameters);
        this.mWorkerParameters = workerParameters;
        this.mLock = new Object();
        this.mAreConstraintsUnmet = false;
        this.mFuture = SettableFuture.create();
    }

    public ListenableWorker getDelegate() {
        return this.mDelegate;
    }

    public TaskExecutor getTaskExecutor() {
        return WorkManagerImpl.getInstance((Context)this.getApplicationContext()).getWorkTaskExecutor();
    }

    public WorkDatabase getWorkDatabase() {
        return WorkManagerImpl.getInstance((Context)this.getApplicationContext()).getWorkDatabase();
    }

    public void onAllConstraintsMet(List<String> list) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onAllConstraintsNotMet(List<String> list) {
        Logger.get().debug(TAG, String.format("Constraints changed for %s", list), new Throwable[0]);
        Object object = this.mLock;
        synchronized (object) {
            this.mAreConstraintsUnmet = true;
            return;
        }
    }

    public void onStopped() {
        super.onStopped();
        ListenableWorker listenableWorker = this.mDelegate;
        if (listenableWorker != null) {
            listenableWorker.stop();
        }
    }

    void setFutureFailed() {
        this.mFuture.set((Object)ListenableWorker.Result.failure());
    }

    void setFutureRetry() {
        this.mFuture.set((Object)ListenableWorker.Result.retry());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setupAndRunConstraintTrackingWork() {
        String string2 = this.getInputData().getString(ARGUMENT_CLASS_NAME);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Logger.get().error(TAG, "No worker to delegate to.", new Throwable[0]);
            this.setFutureFailed();
            return;
        }
        this.mDelegate = this.getWorkerFactory().createWorkerWithDefaultFallback(this.getApplicationContext(), string2, this.mWorkerParameters);
        if (this.mDelegate == null) {
            Logger.get().debug(TAG, "No worker to delegate to.", new Throwable[0]);
            this.setFutureFailed();
            return;
        }
        Object object = this.getWorkDatabase().workSpecDao().getWorkSpec(this.getId().toString());
        if (object == null) {
            this.setFutureFailed();
            return;
        }
        Object object2 = new WorkConstraintsTracker(this.getApplicationContext(), this.getTaskExecutor(), (WorkConstraintsCallback)this);
        object2.replace(Collections.singletonList(object));
        if (!object2.areAllConstraintsMet(this.getId().toString())) {
            Logger.get().debug(TAG, String.format("Constraints not met for delegate %s. Requesting retry.", string2), new Throwable[0]);
            this.setFutureRetry();
            return;
        }
        Logger.get().debug(TAG, String.format("Constraints met for delegate %s", string2), new Throwable[0]);
        try {
            object2 = this.mDelegate.startWork();
            object = new Runnable((ListenableFuture)object2){
                final /* synthetic */ ListenableFuture val$innerFuture;
                {
                    this.val$innerFuture = listenableFuture;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    Object object = ConstraintTrackingWorker.this.mLock;
                    synchronized (object) {
                        if (ConstraintTrackingWorker.this.mAreConstraintsUnmet) {
                            ConstraintTrackingWorker.this.setFutureRetry();
                        } else {
                            ConstraintTrackingWorker.this.mFuture.setFuture(this.val$innerFuture);
                        }
                        return;
                    }
                }
            };
            object2.addListener((Runnable)object, this.getBackgroundExecutor());
            return;
        }
        catch (Throwable throwable) {
            Logger.get().debug(TAG, String.format("Delegated worker %s threw exception in startWork.", string2), new Throwable[]{throwable});
            Object object3 = this.mLock;
            synchronized (object3) {
                if (this.mAreConstraintsUnmet) {
                    Logger.get().debug(TAG, "Constraints were unmet, Retrying.", new Throwable[0]);
                    this.setFutureRetry();
                } else {
                    this.setFutureFailed();
                }
                return;
            }
        }
    }

    public ListenableFuture<ListenableWorker.Result> startWork() {
        this.getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ConstraintTrackingWorker.this.setupAndRunConstraintTrackingWork();
            }
        });
        return this.mFuture;
    }
}

