/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemjob;

import android.app.job.JobInfo;
import android.content.ComponentName;
import android.content.Context;
import android.os.Build;
import android.os.PersistableBundle;
import androidx.work.BackoffPolicy;
import androidx.work.Constraints;
import androidx.work.ContentUriTriggers;
import androidx.work.Logger;
import androidx.work.NetworkType;
import androidx.work.impl.background.systemjob.SystemJobService;
import androidx.work.impl.model.WorkSpec;

class SystemJobInfoConverter {
    static final String EXTRA_IS_PERIODIC = "EXTRA_IS_PERIODIC";
    static final String EXTRA_WORK_SPEC_ID = "EXTRA_WORK_SPEC_ID";
    private static final String TAG = Logger.tagWithPrefix((String)"SystemJobInfoConverter");
    private final ComponentName mWorkServiceComponent;

    SystemJobInfoConverter(Context context) {
        this.mWorkServiceComponent = new ComponentName(context.getApplicationContext(), SystemJobService.class);
    }

    private static JobInfo.TriggerContentUri convertContentUriTrigger(ContentUriTriggers.Trigger trigger) {
        int n2 = trigger.shouldTriggerForDescendants();
        return new JobInfo.TriggerContentUri(trigger.getUri(), n2);
    }

    static int convertNetworkType(NetworkType networkType) {
        int n2 = 1.$SwitchMap$androidx$work$NetworkType[networkType.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    if (n2 != 4) {
                        if (n2 == 5 && Build.VERSION.SDK_INT >= 26) {
                            return 4;
                        }
                    } else if (Build.VERSION.SDK_INT >= 24) {
                        return 3;
                    }
                    Logger.get().debug(TAG, String.format("API version too low. Cannot convert network type value %s", networkType), new Throwable[0]);
                    return 1;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    JobInfo convert(WorkSpec object, int n2) {
        Constraints constraints = ((WorkSpec)object).constraints;
        int n3 = SystemJobInfoConverter.convertNetworkType(constraints.getRequiredNetworkType());
        PersistableBundle persistableBundle = new PersistableBundle();
        persistableBundle.putString(EXTRA_WORK_SPEC_ID, ((WorkSpec)object).id);
        persistableBundle.putBoolean(EXTRA_IS_PERIODIC, object.isPeriodic());
        persistableBundle = new JobInfo.Builder(n2, this.mWorkServiceComponent).setRequiredNetworkType(n3).setRequiresCharging(constraints.requiresCharging()).setRequiresDeviceIdle(constraints.requiresDeviceIdle()).setExtras(persistableBundle);
        if (!constraints.requiresDeviceIdle()) {
            n2 = ((WorkSpec)object).backoffPolicy == BackoffPolicy.LINEAR ? 0 : 1;
            persistableBundle.setBackoffCriteria(((WorkSpec)object).backoffDelayDuration, n2);
        }
        persistableBundle.setMinimumLatency(Math.max(object.calculateNextRunTime() - System.currentTimeMillis(), 0L));
        if (Build.VERSION.SDK_INT >= 24 && constraints.hasContentUriTriggers()) {
            object = constraints.getContentUriTriggers().getTriggers().iterator();
            while (object.hasNext()) {
                persistableBundle.addTriggerContentUri(SystemJobInfoConverter.convertContentUriTrigger((ContentUriTriggers.Trigger)object.next()));
            }
            persistableBundle.setTriggerContentUpdateDelay(constraints.getTriggerContentUpdateDelay());
            persistableBundle.setTriggerContentMaxDelay(constraints.getTriggerMaxContentDelay());
        }
        persistableBundle.setPersisted(false);
        if (Build.VERSION.SDK_INT >= 26) {
            persistableBundle.setRequiresBatteryNotLow(constraints.requiresBatteryNotLow());
            persistableBundle.setRequiresStorageNotLow(constraints.requiresStorageNotLow());
        }
        return persistableBundle.build();
    }
}

