/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import androidx.work.Logger;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.background.systemalarm.CommandHandler;
import androidx.work.impl.background.systemalarm.SystemAlarmDispatcher;
import androidx.work.impl.background.systemalarm.WorkTimer;
import androidx.work.impl.constraints.WorkConstraintsCallback;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.WakeLocks;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import java.util.Collections;
import java.util.List;

public class DelayMetCommandHandler
implements WorkConstraintsCallback,
ExecutionListener,
WorkTimer.TimeLimitExceededListener {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_START_REQUESTED = 1;
    private static final int STATE_STOP_REQUESTED = 2;
    private static final String TAG = Logger.tagWithPrefix((String)"DelayMetCommandHandler");
    private final Context mContext;
    private int mCurrentState;
    private final SystemAlarmDispatcher mDispatcher;
    private boolean mHasConstraints;
    private final Object mLock;
    private final int mStartId;
    private PowerManager.WakeLock mWakeLock;
    private final WorkConstraintsTracker mWorkConstraintsTracker;
    private final String mWorkSpecId;

    DelayMetCommandHandler(Context context, int n2, String string2, SystemAlarmDispatcher systemAlarmDispatcher) {
        this.mContext = context;
        this.mStartId = n2;
        this.mDispatcher = systemAlarmDispatcher;
        this.mWorkSpecId = string2;
        context = systemAlarmDispatcher.getTaskExecutor();
        this.mWorkConstraintsTracker = new WorkConstraintsTracker(this.mContext, (TaskExecutor)context, (WorkConstraintsCallback)this);
        this.mHasConstraints = false;
        this.mCurrentState = 0;
        this.mLock = new Object();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanUp() {
        Object object = this.mLock;
        synchronized (object) {
            this.mWorkConstraintsTracker.reset();
            this.mDispatcher.getWorkTimer().stopTimer(this.mWorkSpecId);
            if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
                Logger.get().debug(TAG, String.format("Releasing wakelock %s for WorkSpec %s", this.mWakeLock, this.mWorkSpecId), new Throwable[0]);
                this.mWakeLock.release();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopWork() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentState < 2) {
                this.mCurrentState = 2;
                Logger.get().debug(TAG, String.format("Stopping work for WorkSpec %s", this.mWorkSpecId), new Throwable[0]);
                Intent intent = CommandHandler.createStopWorkIntent((Context)this.mContext, (String)this.mWorkSpecId);
                SystemAlarmDispatcher systemAlarmDispatcher = this.mDispatcher;
                SystemAlarmDispatcher.AddRunnable addRunnable = new SystemAlarmDispatcher.AddRunnable(this.mDispatcher, intent, this.mStartId);
                systemAlarmDispatcher.postOnMainThread((Runnable)addRunnable);
                if (this.mDispatcher.getProcessor().isEnqueued(this.mWorkSpecId)) {
                    Logger.get().debug(TAG, String.format("WorkSpec %s needs to be rescheduled", this.mWorkSpecId), new Throwable[0]);
                    addRunnable = CommandHandler.createScheduleWorkIntent((Context)this.mContext, (String)this.mWorkSpecId);
                    intent = this.mDispatcher;
                    systemAlarmDispatcher = new SystemAlarmDispatcher.AddRunnable(this.mDispatcher, (Intent)addRunnable, this.mStartId);
                    intent.postOnMainThread((Runnable)systemAlarmDispatcher);
                } else {
                    Logger.get().debug(TAG, String.format("Processor does not have WorkSpec %s. No need to reschedule ", this.mWorkSpecId), new Throwable[0]);
                }
            } else {
                Logger.get().debug(TAG, String.format("Already stopped work for %s", this.mWorkSpecId), new Throwable[0]);
            }
            return;
        }
    }

    void handleProcessWork() {
        this.mWakeLock = WakeLocks.newWakeLock((Context)this.mContext, (String)String.format("%s (%s)", this.mWorkSpecId, this.mStartId));
        Logger.get().debug(TAG, String.format("Acquiring wakelock %s for WorkSpec %s", this.mWakeLock, this.mWorkSpecId), new Throwable[0]);
        this.mWakeLock.acquire();
        WorkSpec workSpec = this.mDispatcher.getWorkManager().getWorkDatabase().workSpecDao().getWorkSpec(this.mWorkSpecId);
        if (workSpec == null) {
            this.stopWork();
            return;
        }
        this.mHasConstraints = workSpec.hasConstraints();
        if (!this.mHasConstraints) {
            Logger.get().debug(TAG, String.format("No constraints for %s", this.mWorkSpecId), new Throwable[0]);
            this.onAllConstraintsMet(Collections.singletonList(this.mWorkSpecId));
        } else {
            this.mWorkConstraintsTracker.replace(Collections.singletonList(workSpec));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onAllConstraintsMet(List<String> object) {
        if (!object.contains(this.mWorkSpecId)) {
            return;
        }
        object = this.mLock;
        synchronized (object) {
            if (this.mCurrentState == 0) {
                this.mCurrentState = 1;
                Logger.get().debug(TAG, String.format("onAllConstraintsMet for %s", this.mWorkSpecId), new Throwable[0]);
                if (this.mDispatcher.getProcessor().startWork(this.mWorkSpecId)) {
                    this.mDispatcher.getWorkTimer().startTimer(this.mWorkSpecId, 600000L, (WorkTimer.TimeLimitExceededListener)this);
                } else {
                    this.cleanUp();
                }
            } else {
                Logger.get().debug(TAG, String.format("Already started work for %s", this.mWorkSpecId), new Throwable[0]);
            }
            return;
        }
    }

    public void onAllConstraintsNotMet(List<String> list) {
        this.stopWork();
    }

    public void onExecuted(String string2, boolean bl) {
        Intent intent;
        Logger.get().debug(TAG, String.format("onExecuted %s, %s", string2, bl), new Throwable[0]);
        this.cleanUp();
        if (bl) {
            intent = CommandHandler.createScheduleWorkIntent((Context)this.mContext, (String)this.mWorkSpecId);
            string2 = this.mDispatcher;
            string2.postOnMainThread((Runnable)new SystemAlarmDispatcher.AddRunnable((SystemAlarmDispatcher)string2, intent, this.mStartId));
        }
        if (this.mHasConstraints) {
            intent = CommandHandler.createConstraintsChangedIntent((Context)this.mContext);
            string2 = this.mDispatcher;
            string2.postOnMainThread((Runnable)new SystemAlarmDispatcher.AddRunnable((SystemAlarmDispatcher)string2, intent, this.mStartId));
        }
    }

    public void onTimeLimitExceeded(String string2) {
        Logger.get().debug(TAG, String.format("Exceeded time limits on execution for %s", string2), new Throwable[0]);
        this.stopWork();
    }
}

