/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import androidx.work.Logger;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.background.systemalarm.ConstraintProxy;
import androidx.work.impl.utils.PackageManagerHelper;

public class ConstraintProxyUpdateReceiver
extends BroadcastReceiver {
    static final String ACTION = "androidx.work.impl.background.systemalarm.UpdateProxies";
    static final String KEY_BATTERY_CHARGING_PROXY_ENABLED = "KEY_BATTERY_CHARGING_PROXY_ENABLED";
    static final String KEY_BATTERY_NOT_LOW_PROXY_ENABLED = "KEY_BATTERY_NOT_LOW_PROXY_ENABLED";
    static final String KEY_NETWORK_STATE_PROXY_ENABLED = "KEY_NETWORK_STATE_PROXY_ENABLED";
    static final String KEY_STORAGE_NOT_LOW_PROXY_ENABLED = "KEY_STORAGE_NOT_LOW_PROXY_ENABLED";
    static final String TAG = Logger.tagWithPrefix((String)"ConstrntProxyUpdtRecvr");

    public static Intent newConstraintProxyUpdateIntent(Context context, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Intent intent = new Intent(ACTION);
        intent.setComponent(new ComponentName(context, ConstraintProxyUpdateReceiver.class));
        intent.putExtra(KEY_BATTERY_NOT_LOW_PROXY_ENABLED, bl).putExtra(KEY_BATTERY_CHARGING_PROXY_ENABLED, bl2).putExtra(KEY_STORAGE_NOT_LOW_PROXY_ENABLED, bl3).putExtra(KEY_NETWORK_STATE_PROXY_ENABLED, bl4);
        return intent;
    }

    public void onReceive(final Context context, final Intent intent) {
        String string2 = intent != null ? intent.getAction() : null;
        if (!ACTION.equals(string2)) {
            Logger.get().debug(TAG, String.format("Ignoring unknown action %s", string2), new Throwable[0]);
        } else {
            string2 = this.goAsync();
            WorkManagerImpl.getInstance((Context)context).getWorkTaskExecutor().executeOnBackgroundThread(new Runnable((BroadcastReceiver.PendingResult)string2){
                final /* synthetic */ BroadcastReceiver.PendingResult val$pendingResult;
                {
                    this.val$pendingResult = pendingResult;
                }

                @Override
                public void run() {
                    try {
                        boolean bl = intent.getBooleanExtra(ConstraintProxyUpdateReceiver.KEY_BATTERY_NOT_LOW_PROXY_ENABLED, false);
                        boolean bl2 = intent.getBooleanExtra(ConstraintProxyUpdateReceiver.KEY_BATTERY_CHARGING_PROXY_ENABLED, false);
                        boolean bl3 = intent.getBooleanExtra(ConstraintProxyUpdateReceiver.KEY_STORAGE_NOT_LOW_PROXY_ENABLED, false);
                        boolean bl4 = intent.getBooleanExtra(ConstraintProxyUpdateReceiver.KEY_NETWORK_STATE_PROXY_ENABLED, false);
                        Logger.get().debug(TAG, String.format("Updating proxies: BatteryNotLowProxy enabled (%s), BatteryChargingProxy enabled (%s), StorageNotLowProxy (%s), NetworkStateProxy enabled (%s)", bl, bl2, bl3, bl4), new Throwable[0]);
                        PackageManagerHelper.setComponentEnabled((Context)context, ConstraintProxy.BatteryNotLowProxy.class, (boolean)bl);
                        PackageManagerHelper.setComponentEnabled((Context)context, ConstraintProxy.BatteryChargingProxy.class, (boolean)bl2);
                        PackageManagerHelper.setComponentEnabled((Context)context, ConstraintProxy.StorageNotLowProxy.class, (boolean)bl3);
                        PackageManagerHelper.setComponentEnabled((Context)context, ConstraintProxy.NetworkStateProxy.class, (boolean)bl4);
                        return;
                    }
                    finally {
                        this.val$pendingResult.finish();
                    }
                }
            });
        }
    }
}

