/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.work.Logger;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.background.systemalarm.CommandHandler;
import androidx.work.impl.model.SystemIdInfo;
import androidx.work.impl.utils.IdGenerator;

class Alarms {
    private static final String TAG = Logger.tagWithPrefix((String)"Alarms");

    private Alarms() {
    }

    public static void cancelAlarm(Context context, WorkManagerImpl workManagerImpl, String string2) {
        SystemIdInfo systemIdInfo = (workManagerImpl = workManagerImpl.getWorkDatabase().systemIdInfoDao()).getSystemIdInfo(string2);
        if (systemIdInfo != null) {
            Alarms.cancelExactAlarm(context, string2, systemIdInfo.systemId);
            Logger.get().debug(TAG, String.format("Removing SystemIdInfo for workSpecId (%s)", string2), new Throwable[0]);
            workManagerImpl.removeSystemIdInfo(string2);
        }
    }

    private static void cancelExactAlarm(Context context, String string2, int n2) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if ((context = PendingIntent.getService((Context)context, (int)n2, (Intent)CommandHandler.createDelayMetIntent((Context)context, (String)string2), (int)0x20000000)) != null && alarmManager != null) {
            Logger.get().debug(TAG, String.format("Cancelling existing alarm with (workSpecId, systemId) (%s, %s)", string2, n2), new Throwable[0]);
            alarmManager.cancel((PendingIntent)context);
        }
    }

    public static void setAlarm(Context context, WorkManagerImpl workManagerImpl, String string2, long l2) {
        SystemIdInfo systemIdInfo = (workManagerImpl = workManagerImpl.getWorkDatabase().systemIdInfoDao()).getSystemIdInfo(string2);
        if (systemIdInfo != null) {
            Alarms.cancelExactAlarm(context, string2, systemIdInfo.systemId);
            Alarms.setExactAlarm(context, string2, systemIdInfo.systemId, l2);
        } else {
            int n2 = new IdGenerator(context).nextAlarmManagerId();
            workManagerImpl.insertSystemIdInfo(new SystemIdInfo(string2, n2));
            Alarms.setExactAlarm(context, string2, n2, l2);
        }
    }

    private static void setExactAlarm(Context context, String string2, int n2, long l2) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        context = PendingIntent.getService((Context)context, (int)n2, (Intent)CommandHandler.createDelayMetIntent((Context)context, (String)string2), (int)0x40000000);
        if (alarmManager != null) {
            if (Build.VERSION.SDK_INT >= 19) {
                alarmManager.setExact(0, l2, (PendingIntent)context);
            } else {
                alarmManager.set(0, l2, (PendingIntent)context);
            }
        }
    }
}

