/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.net.Uri;
import android.os.Build;
import androidx.work.ContentUriTriggers;
import androidx.work.NetworkType;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public final class Constraints {
    public static final Constraints NONE = new Builder().build();
    private ContentUriTriggers mContentUriTriggers;
    private NetworkType mRequiredNetworkType = NetworkType.NOT_REQUIRED;
    private boolean mRequiresBatteryNotLow;
    private boolean mRequiresCharging;
    private boolean mRequiresDeviceIdle;
    private boolean mRequiresStorageNotLow;
    private long mTriggerContentUpdateDelay = -1L;
    private long mTriggerMaxContentDelay = -1L;

    public Constraints() {
        this.mContentUriTriggers = new ContentUriTriggers();
    }

    Constraints(Builder builder) {
        this.mContentUriTriggers = new ContentUriTriggers();
        this.mRequiresCharging = builder.mRequiresCharging;
        boolean bl = Build.VERSION.SDK_INT >= 23 && builder.mRequiresDeviceIdle;
        this.mRequiresDeviceIdle = bl;
        this.mRequiredNetworkType = builder.mRequiredNetworkType;
        this.mRequiresBatteryNotLow = builder.mRequiresBatteryNotLow;
        this.mRequiresStorageNotLow = builder.mRequiresStorageNotLow;
        if (Build.VERSION.SDK_INT >= 24) {
            this.mContentUriTriggers = builder.mContentUriTriggers;
            this.mTriggerContentUpdateDelay = builder.mTriggerContentUpdateDelay;
            this.mTriggerMaxContentDelay = builder.mTriggerContentMaxDelay;
        }
    }

    public Constraints(Constraints constraints) {
        this.mContentUriTriggers = new ContentUriTriggers();
        this.mRequiresCharging = constraints.mRequiresCharging;
        this.mRequiresDeviceIdle = constraints.mRequiresDeviceIdle;
        this.mRequiredNetworkType = constraints.mRequiredNetworkType;
        this.mRequiresBatteryNotLow = constraints.mRequiresBatteryNotLow;
        this.mRequiresStorageNotLow = constraints.mRequiresStorageNotLow;
        this.mContentUriTriggers = constraints.mContentUriTriggers;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (Constraints)object;
            if (this.mRequiresCharging != ((Constraints)object).mRequiresCharging) {
                return false;
            }
            if (this.mRequiresDeviceIdle != ((Constraints)object).mRequiresDeviceIdle) {
                return false;
            }
            if (this.mRequiresBatteryNotLow != ((Constraints)object).mRequiresBatteryNotLow) {
                return false;
            }
            if (this.mRequiresStorageNotLow != ((Constraints)object).mRequiresStorageNotLow) {
                return false;
            }
            if (this.mTriggerContentUpdateDelay != ((Constraints)object).mTriggerContentUpdateDelay) {
                return false;
            }
            if (this.mTriggerMaxContentDelay != ((Constraints)object).mTriggerMaxContentDelay) {
                return false;
            }
            if (this.mRequiredNetworkType != ((Constraints)object).mRequiredNetworkType) {
                return false;
            }
            return this.mContentUriTriggers.equals((Object)((Constraints)object).mContentUriTriggers);
        }
        return false;
    }

    public ContentUriTriggers getContentUriTriggers() {
        return this.mContentUriTriggers;
    }

    public NetworkType getRequiredNetworkType() {
        return this.mRequiredNetworkType;
    }

    public long getTriggerContentUpdateDelay() {
        return this.mTriggerContentUpdateDelay;
    }

    public long getTriggerMaxContentDelay() {
        return this.mTriggerMaxContentDelay;
    }

    public boolean hasContentUriTriggers() {
        boolean bl = this.mContentUriTriggers.size() > 0;
        return bl;
    }

    public int hashCode() {
        int n2 = this.mRequiredNetworkType.hashCode();
        int n3 = this.mRequiresCharging;
        int n4 = this.mRequiresDeviceIdle;
        int n5 = this.mRequiresBatteryNotLow;
        int n6 = this.mRequiresStorageNotLow;
        long l2 = this.mTriggerContentUpdateDelay;
        int n7 = (int)(l2 ^ l2 >>> 32);
        l2 = this.mTriggerMaxContentDelay;
        return ((((((n2 * 31 + n3) * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + this.mContentUriTriggers.hashCode();
    }

    public boolean requiresBatteryNotLow() {
        return this.mRequiresBatteryNotLow;
    }

    public boolean requiresCharging() {
        return this.mRequiresCharging;
    }

    public boolean requiresDeviceIdle() {
        return this.mRequiresDeviceIdle;
    }

    public boolean requiresStorageNotLow() {
        return this.mRequiresStorageNotLow;
    }

    public void setContentUriTriggers(ContentUriTriggers contentUriTriggers) {
        this.mContentUriTriggers = contentUriTriggers;
    }

    public void setRequiredNetworkType(NetworkType networkType) {
        this.mRequiredNetworkType = networkType;
    }

    public void setRequiresBatteryNotLow(boolean bl) {
        this.mRequiresBatteryNotLow = bl;
    }

    public void setRequiresCharging(boolean bl) {
        this.mRequiresCharging = bl;
    }

    public void setRequiresDeviceIdle(boolean bl) {
        this.mRequiresDeviceIdle = bl;
    }

    public void setRequiresStorageNotLow(boolean bl) {
        this.mRequiresStorageNotLow = bl;
    }

    public void setTriggerContentUpdateDelay(long l2) {
        this.mTriggerContentUpdateDelay = l2;
    }

    public void setTriggerMaxContentDelay(long l2) {
        this.mTriggerMaxContentDelay = l2;
    }

    public static final class Builder {
        ContentUriTriggers mContentUriTriggers;
        NetworkType mRequiredNetworkType = NetworkType.NOT_REQUIRED;
        boolean mRequiresBatteryNotLow = false;
        boolean mRequiresCharging = false;
        boolean mRequiresDeviceIdle = false;
        boolean mRequiresStorageNotLow = false;
        long mTriggerContentMaxDelay = -1L;
        long mTriggerContentUpdateDelay = -1L;

        public Builder() {
            this.mContentUriTriggers = new ContentUriTriggers();
        }

        public Builder addContentUriTrigger(Uri uri, boolean bl) {
            this.mContentUriTriggers.add(uri, bl);
            return this;
        }

        public Constraints build() {
            return new Constraints(this);
        }

        public Builder setRequiredNetworkType(NetworkType networkType) {
            this.mRequiredNetworkType = networkType;
            return this;
        }

        public Builder setRequiresBatteryNotLow(boolean bl) {
            this.mRequiresBatteryNotLow = bl;
            return this;
        }

        public Builder setRequiresCharging(boolean bl) {
            this.mRequiresCharging = bl;
            return this;
        }

        public Builder setRequiresDeviceIdle(boolean bl) {
            this.mRequiresDeviceIdle = bl;
            return this;
        }

        public Builder setRequiresStorageNotLow(boolean bl) {
            this.mRequiresStorageNotLow = bl;
            return this;
        }

        public Builder setTriggerContentMaxDelay(long l2, TimeUnit timeUnit) {
            this.mTriggerContentMaxDelay = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setTriggerContentMaxDelay(Duration duration) {
            this.mTriggerContentMaxDelay = duration.toMillis();
            return this;
        }

        public Builder setTriggerContentUpdateDelay(long l2, TimeUnit timeUnit) {
            this.mTriggerContentUpdateDelay = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setTriggerContentUpdateDelay(Duration duration) {
            this.mTriggerContentUpdateDelay = duration.toMillis();
            return this;
        }
    }
}

