/*
 * Decompiled with CFR 0.152.
 */
package androidx.viewpager.widget;

import android.content.Context;
import android.content.res.Resources;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.EdgeEffect;
import android.widget.Scroller;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.customview.view.AbsSavedState;
import androidx.viewpager.widget.PagerAdapter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ViewPager
extends ViewGroup {
    private static final int CLOSE_ENOUGH = 2;
    private static final Comparator<ItemInfo> COMPARATOR;
    private static final boolean DEBUG = false;
    private static final int DEFAULT_GUTTER_SIZE = 16;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int DRAW_ORDER_DEFAULT = 0;
    private static final int DRAW_ORDER_FORWARD = 1;
    private static final int DRAW_ORDER_REVERSE = 2;
    private static final int INVALID_POINTER = -1;
    static final int[] LAYOUT_ATTRS;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int MIN_FLING_VELOCITY = 400;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_SETTLING = 2;
    private static final String TAG = "ViewPager";
    private static final boolean USE_CACHE = false;
    private static final Interpolator sInterpolator;
    private static final ViewPositionComparator sPositionComparator;
    private int mActivePointerId = -1;
    PagerAdapter mAdapter;
    private List<OnAdapterChangeListener> mAdapterChangeListeners;
    private int mBottomPageBounds;
    private boolean mCalledSuper;
    private int mChildHeightMeasureSpec;
    private int mChildWidthMeasureSpec;
    private int mCloseEnough;
    int mCurItem;
    private int mDecorChildCount;
    private int mDefaultGutterSize;
    private int mDrawingOrder;
    private ArrayList<View> mDrawingOrderedChildren;
    private final Runnable mEndScrollRunnable;
    private int mExpectedAdapterCount;
    private long mFakeDragBeginTime;
    private boolean mFakeDragging;
    private boolean mFirstLayout = true;
    private float mFirstOffset = -3.4028235E38f;
    private int mFlingDistance;
    private int mGutterSize;
    private boolean mInLayout;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private OnPageChangeListener mInternalPageChangeListener;
    private boolean mIsBeingDragged;
    private boolean mIsScrollStarted;
    private boolean mIsUnableToDrag;
    private final ArrayList<ItemInfo> mItems = new ArrayList();
    private float mLastMotionX;
    private float mLastMotionY;
    private float mLastOffset;
    private EdgeEffect mLeftEdge;
    private Drawable mMarginDrawable;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private boolean mNeedCalculatePageOffsets = false;
    private PagerObserver mObserver;
    private int mOffscreenPageLimit = 1;
    private OnPageChangeListener mOnPageChangeListener;
    private List<OnPageChangeListener> mOnPageChangeListeners;
    private int mPageMargin;
    private PageTransformer mPageTransformer;
    private int mPageTransformerLayerType;
    private boolean mPopulatePending;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private int mRestoredCurItem = -1;
    private EdgeEffect mRightEdge;
    private int mScrollState = 0;
    private Scroller mScroller;
    private boolean mScrollingCacheEnabled;
    private final ItemInfo mTempItem = new ItemInfo();
    private final Rect mTempRect = new Rect();
    private int mTopPageBounds;
    private int mTouchSlop;
    private VelocityTracker mVelocityTracker;

    static {
        LAYOUT_ATTRS = new int[]{16842931};
        COMPARATOR = new Comparator<ItemInfo>(){

            @Override
            public int compare(ItemInfo itemInfo, ItemInfo itemInfo2) {
                return itemInfo.position - itemInfo2.position;
            }
        };
        sInterpolator = new Interpolator(){

            public float getInterpolation(float f2) {
                return (f2 -= 1.0f) * f2 * f2 * f2 * f2 + 1.0f;
            }
        };
        sPositionComparator = new ViewPositionComparator();
    }

    public ViewPager(Context context) {
        super(context);
        this.mLastOffset = Float.MAX_VALUE;
        this.mEndScrollRunnable = new Runnable(){

            @Override
            public void run() {
                ViewPager.this.setScrollState(0);
                ViewPager.this.populate();
            }
        };
        this.initViewPager();
    }

    public ViewPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mLastOffset = Float.MAX_VALUE;
        this.mEndScrollRunnable = new /* invalid duplicate definition of identical inner class */;
        this.initViewPager();
    }

    private void calculatePageOffsets(ItemInfo itemInfo, int n2, ItemInfo itemInfo2) {
        float f2;
        int n3;
        int n4;
        float f3;
        int n5 = this.mAdapter.getCount();
        int n6 = this.getClientWidth();
        float f4 = n6 > 0 ? (float)this.mPageMargin / (float)n6 : 0.0f;
        if (itemInfo2 != null) {
            n6 = itemInfo2.position;
            if (n6 < itemInfo.position) {
                f3 = itemInfo2.offset + itemInfo2.widthFactor + f4;
                ++n6;
                n4 = 0;
                while (n6 <= itemInfo.position && n4 < this.mItems.size()) {
                    itemInfo2 = this.mItems.get(n4);
                    while (true) {
                        n3 = n6;
                        f2 = f3;
                        if (n6 <= itemInfo2.position) break;
                        n3 = n6;
                        f2 = f3;
                        if (n4 >= this.mItems.size() - 1) break;
                        itemInfo2 = this.mItems.get(++n4);
                    }
                    while (n3 < itemInfo2.position) {
                        f2 += this.mAdapter.getPageWidth(n3) + f4;
                        ++n3;
                    }
                    itemInfo2.offset = f2;
                    f3 = f2 + (itemInfo2.widthFactor + f4);
                    n6 = n3 + 1;
                }
            } else if (n6 > itemInfo.position) {
                n4 = this.mItems.size() - 1;
                f3 = itemInfo2.offset;
                --n6;
                while (n6 >= itemInfo.position && n4 >= 0) {
                    itemInfo2 = this.mItems.get(n4);
                    while (true) {
                        n3 = n6;
                        f2 = f3;
                        if (n6 >= itemInfo2.position) break;
                        n3 = n6;
                        f2 = f3;
                        if (n4 <= 0) break;
                        itemInfo2 = this.mItems.get(--n4);
                    }
                    while (n3 > itemInfo2.position) {
                        f2 -= this.mAdapter.getPageWidth(n3) + f4;
                        --n3;
                    }
                    itemInfo2.offset = f3 = f2 - (itemInfo2.widthFactor + f4);
                    n6 = n3 - 1;
                }
            }
        }
        n3 = this.mItems.size();
        f2 = itemInfo.offset;
        n6 = itemInfo.position - 1;
        f3 = itemInfo.position == 0 ? itemInfo.offset : -3.4028235E38f;
        this.mFirstOffset = f3;
        n4 = itemInfo.position;
        f3 = n4 == --n5 ? itemInfo.offset + itemInfo.widthFactor - 1.0f : Float.MAX_VALUE;
        this.mLastOffset = f3;
        n4 = n2 - 1;
        f3 = f2;
        while (n4 >= 0) {
            itemInfo2 = this.mItems.get(n4);
            while (n6 > itemInfo2.position) {
                f3 -= this.mAdapter.getPageWidth(n6) + f4;
                --n6;
            }
            itemInfo2.offset = f3 -= itemInfo2.widthFactor + f4;
            if (itemInfo2.position == 0) {
                this.mFirstOffset = f3;
            }
            --n4;
            --n6;
        }
        f3 = itemInfo.offset + itemInfo.widthFactor + f4;
        n4 = itemInfo.position + 1;
        n6 = n2 + 1;
        n2 = n4;
        while (n6 < n3) {
            itemInfo = this.mItems.get(n6);
            while (n2 < itemInfo.position) {
                f3 += this.mAdapter.getPageWidth(n2) + f4;
                ++n2;
            }
            if (itemInfo.position == n5) {
                this.mLastOffset = itemInfo.widthFactor + f3 - 1.0f;
            }
            itemInfo.offset = f3;
            f3 += itemInfo.widthFactor + f4;
            ++n6;
            ++n2;
        }
        this.mNeedCalculatePageOffsets = false;
    }

    private void completeScroll(boolean bl) {
        int n2;
        int n3;
        int n4 = this.mScrollState == 2 ? 1 : 0;
        if (n4 != 0) {
            this.setScrollingCacheEnabled(false);
            if (this.mScroller.isFinished() ^ true) {
                this.mScroller.abortAnimation();
                n3 = this.getScrollX();
                int n5 = this.getScrollY();
                n2 = this.mScroller.getCurrX();
                int n6 = this.mScroller.getCurrY();
                if (n3 != n2 || n5 != n6) {
                    this.scrollTo(n2, n6);
                    if (n2 != n3) {
                        this.pageScrolled(n2);
                    }
                }
            }
        }
        this.mPopulatePending = false;
        n3 = 0;
        n2 = n4;
        for (n4 = n3; n4 < this.mItems.size(); ++n4) {
            ItemInfo itemInfo = this.mItems.get(n4);
            if (!itemInfo.scrolling) continue;
            itemInfo.scrolling = false;
            n2 = 1;
        }
        if (n2 != 0) {
            if (bl) {
                ViewCompat.postOnAnimation((View)this, this.mEndScrollRunnable);
            } else {
                this.mEndScrollRunnable.run();
            }
        }
    }

    private int determineTargetPage(int n2, float f2, int n3, int n4) {
        if (Math.abs(n4) > this.mFlingDistance && Math.abs(n3) > this.mMinimumVelocity) {
            if (n3 <= 0) {
                ++n2;
            }
        } else {
            float f3 = n2 >= this.mCurItem ? 0.4f : 0.6f;
            n2 += (int)(f2 + f3);
        }
        n3 = n2;
        if (this.mItems.size() > 0) {
            ItemInfo itemInfo = this.mItems.get(0);
            Object object = this.mItems;
            object = ((ArrayList)object).get(((ArrayList)object).size() - 1);
            n3 = Math.max(itemInfo.position, Math.min(n2, ((ItemInfo)object).position));
        }
        return n3;
    }

    private void dispatchOnPageScrolled(int n2, float f2, int n3) {
        Object object = this.mOnPageChangeListener;
        if (object != null) {
            object.onPageScrolled(n2, f2, n3);
        }
        if ((object = this.mOnPageChangeListeners) != null) {
            int n4 = object.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                object = this.mOnPageChangeListeners.get(i2);
                if (object == null) continue;
                object.onPageScrolled(n2, f2, n3);
            }
        }
        if ((object = this.mInternalPageChangeListener) != null) {
            object.onPageScrolled(n2, f2, n3);
        }
    }

    private void dispatchOnPageSelected(int n2) {
        Object object = this.mOnPageChangeListener;
        if (object != null) {
            object.onPageSelected(n2);
        }
        if ((object = this.mOnPageChangeListeners) != null) {
            int n3 = object.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                object = this.mOnPageChangeListeners.get(i2);
                if (object == null) continue;
                object.onPageSelected(n2);
            }
        }
        if ((object = this.mInternalPageChangeListener) != null) {
            object.onPageSelected(n2);
        }
    }

    private void dispatchOnScrollStateChanged(int n2) {
        Object object = this.mOnPageChangeListener;
        if (object != null) {
            object.onPageScrollStateChanged(n2);
        }
        if ((object = this.mOnPageChangeListeners) != null) {
            int n3 = object.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                object = this.mOnPageChangeListeners.get(i2);
                if (object == null) continue;
                object.onPageScrollStateChanged(n2);
            }
        }
        if ((object = this.mInternalPageChangeListener) != null) {
            object.onPageScrollStateChanged(n2);
        }
    }

    private void enableLayers(boolean bl) {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = bl ? this.mPageTransformerLayerType : 0;
            this.getChildAt(i2).setLayerType(n3, null);
        }
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private Rect getChildRectInPagerCoordinates(Rect rect, View view) {
        Rect rect2 = rect;
        if (rect == null) {
            rect2 = new Rect();
        }
        if (view == null) {
            rect2.set(0, 0, 0, 0);
            return rect2;
        }
        rect2.left = view.getLeft();
        rect2.right = view.getRight();
        rect2.top = view.getTop();
        rect2.bottom = view.getBottom();
        for (rect = view.getParent(); rect instanceof ViewGroup && rect != this; rect = rect.getParent()) {
            rect = (ViewGroup)rect;
            rect2.left += rect.getLeft();
            rect2.right += rect.getRight();
            rect2.top += rect.getTop();
            rect2.bottom += rect.getBottom();
        }
        return rect2;
    }

    private int getClientWidth() {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    private ItemInfo infoForCurrentScrollPosition() {
        int n2 = this.getClientWidth();
        float f2 = n2 > 0 ? (float)this.getScrollX() / (float)n2 : 0.0f;
        float f3 = n2 > 0 ? (float)this.mPageMargin / (float)n2 : 0.0f;
        ItemInfo itemInfo = null;
        n2 = 0;
        boolean bl = true;
        int n3 = -1;
        float f4 = 0.0f;
        float f5 = 0.0f;
        while (n2 < this.mItems.size()) {
            ItemInfo itemInfo2 = this.mItems.get(n2);
            int n4 = n2;
            ItemInfo itemInfo3 = itemInfo2;
            if (!bl) {
                int n5 = itemInfo2.position;
                n4 = n2;
                itemInfo3 = itemInfo2;
                if (n5 != ++n3) {
                    itemInfo3 = this.mTempItem;
                    itemInfo3.offset = f4 + f5 + f3;
                    itemInfo3.position = n3;
                    itemInfo3.widthFactor = this.mAdapter.getPageWidth(itemInfo3.position);
                    n4 = n2 - 1;
                }
            }
            f4 = itemInfo3.offset;
            f5 = itemInfo3.widthFactor;
            if (!bl && !(f2 >= f4)) {
                return itemInfo;
            }
            if (!(f2 < f5 + f4 + f3) && n4 != this.mItems.size() - 1) {
                n3 = itemInfo3.position;
                f5 = itemInfo3.widthFactor;
                n2 = n4 + 1;
                bl = false;
                itemInfo = itemInfo3;
                continue;
            }
            return itemInfo3;
        }
        return itemInfo;
    }

    private static boolean isDecorView(View view) {
        boolean bl = view.getClass().getAnnotation(DecorView.class) != null;
        return bl;
    }

    private boolean isGutterDrag(float f2, float f3) {
        boolean bl = f2 < (float)this.mGutterSize && f3 > 0.0f || f2 > (float)(this.getWidth() - this.mGutterSize) && f3 < 0.0f;
        return bl;
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n2 = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(n2) == this.mActivePointerId) {
            n2 = n2 == 0 ? 1 : 0;
            this.mLastMotionX = motionEvent.getX(n2);
            this.mActivePointerId = motionEvent.getPointerId(n2);
            motionEvent = this.mVelocityTracker;
            if (motionEvent != null) {
                motionEvent.clear();
            }
        }
    }

    private boolean pageScrolled(int n2) {
        if (this.mItems.size() == 0) {
            if (this.mFirstLayout) {
                return false;
            }
            this.mCalledSuper = false;
            this.onPageScrolled(0, 0.0f, 0);
            if (this.mCalledSuper) {
                return false;
            }
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        }
        ItemInfo itemInfo = this.infoForCurrentScrollPosition();
        int n3 = this.getClientWidth();
        int n4 = this.mPageMargin;
        float f2 = n4;
        float f3 = n3;
        f2 /= f3;
        int n5 = itemInfo.position;
        f3 = ((float)n2 / f3 - itemInfo.offset) / (itemInfo.widthFactor + f2);
        n2 = (int)((float)(n3 + n4) * f3);
        this.mCalledSuper = false;
        this.onPageScrolled(n5, f3, n2);
        if (this.mCalledSuper) {
            return true;
        }
        throw new IllegalStateException("onPageScrolled did not call superclass implementation");
    }

    private boolean performDrag(float f2) {
        boolean bl;
        int n2;
        float f3 = this.mLastMotionX;
        this.mLastMotionX = f2;
        float f4 = (float)this.getScrollX() + (f3 - f2);
        float f5 = this.getClientWidth();
        f2 = this.mFirstOffset * f5;
        f3 = this.mLastOffset * f5;
        Object object = this.mItems;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        object = ((ArrayList)object).get(0);
        Object object2 = this.mItems;
        object2 = ((ArrayList)object2).get(((ArrayList)object2).size() - 1);
        if (((ItemInfo)object).position != 0) {
            f2 = ((ItemInfo)object).offset * f5;
            n2 = 0;
        } else {
            n2 = 1;
        }
        if (((ItemInfo)object2).position != this.mAdapter.getCount() - 1) {
            f3 = ((ItemInfo)object2).offset * f5;
            bl = false;
        } else {
            bl = true;
        }
        if (f4 < f2) {
            if (n2 != 0) {
                this.mLeftEdge.onPull(Math.abs(f2 - f4) / f5);
                bl4 = true;
            }
        } else {
            bl4 = bl3;
            f2 = f4;
            if (f4 > f3) {
                bl4 = bl2;
                if (bl) {
                    this.mRightEdge.onPull(Math.abs(f4 - f3) / f5);
                    bl4 = true;
                }
                f2 = f3;
            }
        }
        f3 = this.mLastMotionX;
        n2 = (int)f2;
        this.mLastMotionX = f3 + (f2 - (float)n2);
        this.scrollTo(n2, this.getScrollY());
        this.pageScrolled(n2);
        return bl4;
    }

    private void recomputeScrollPosition(int n2, int n3, int n4, int n5) {
        if (n3 > 0 && !this.mItems.isEmpty()) {
            if (!this.mScroller.isFinished()) {
                this.mScroller.setFinalX(this.getCurrentItem() * this.getClientWidth());
            } else {
                int n6 = this.getPaddingLeft();
                int n7 = this.getPaddingRight();
                int n8 = this.getPaddingLeft();
                int n9 = this.getPaddingRight();
                this.scrollTo((int)((float)this.getScrollX() / (float)(n3 - n8 - n9 + n5) * (float)(n2 - n6 - n7 + n4)), this.getScrollY());
            }
        } else {
            ItemInfo itemInfo = this.infoForPosition(this.mCurItem);
            float f2 = itemInfo != null ? Math.min(itemInfo.offset, this.mLastOffset) : 0.0f;
            n2 = (int)(f2 * (float)(n2 - this.getPaddingLeft() - this.getPaddingRight()));
            if (n2 != this.getScrollX()) {
                this.completeScroll(false);
                this.scrollTo(n2, this.getScrollY());
            }
        }
    }

    private void removeNonDecorViews() {
        int n2 = 0;
        while (n2 < this.getChildCount()) {
            int n3 = n2;
            if (!((LayoutParams)this.getChildAt((int)n2).getLayoutParams()).isDecor) {
                this.removeViewAt(n2);
                n3 = n2 - 1;
            }
            n2 = n3 + 1;
        }
    }

    private void requestParentDisallowInterceptTouchEvent(boolean bl) {
        ViewParent viewParent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(bl);
        }
    }

    private boolean resetTouch() {
        this.mActivePointerId = -1;
        this.endDrag();
        this.mLeftEdge.onRelease();
        this.mRightEdge.onRelease();
        boolean bl = this.mLeftEdge.isFinished() || this.mRightEdge.isFinished();
        return bl;
    }

    private void scrollToItem(int n2, boolean bl, int n3, boolean bl2) {
        ItemInfo itemInfo = this.infoForPosition(n2);
        int n4 = itemInfo != null ? (int)((float)this.getClientWidth() * Math.max(this.mFirstOffset, Math.min(itemInfo.offset, this.mLastOffset))) : 0;
        if (bl) {
            this.smoothScrollTo(n4, 0, n3);
            if (bl2) {
                this.dispatchOnPageSelected(n2);
            }
        } else {
            if (bl2) {
                this.dispatchOnPageSelected(n2);
            }
            this.completeScroll(false);
            this.scrollTo(n4, 0);
            this.pageScrolled(n4);
        }
    }

    private void setScrollingCacheEnabled(boolean bl) {
        if (this.mScrollingCacheEnabled != bl) {
            this.mScrollingCacheEnabled = bl;
        }
    }

    private void sortChildDrawingOrder() {
        if (this.mDrawingOrder != 0) {
            View view = this.mDrawingOrderedChildren;
            if (view == null) {
                this.mDrawingOrderedChildren = new ArrayList();
            } else {
                view.clear();
            }
            int n2 = this.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                view = this.getChildAt(i2);
                this.mDrawingOrderedChildren.add(view);
            }
            Collections.sort(this.mDrawingOrderedChildren, sPositionComparator);
        }
    }

    public void addFocusables(ArrayList<View> arrayList, int n2, int n3) {
        int n4 = arrayList.size();
        int n5 = this.getDescendantFocusability();
        if (n5 != 393216) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                ItemInfo itemInfo;
                View view = this.getChildAt(i2);
                if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem) continue;
                view.addFocusables(arrayList, n2, n3);
            }
        }
        if (n5 != 262144 || n4 == arrayList.size()) {
            if (!this.isFocusable()) {
                return;
            }
            if ((n3 & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
                return;
            }
            if (arrayList != null) {
                arrayList.add((View)this);
            }
        }
    }

    ItemInfo addNewItem(int n2, int n3) {
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.position = n2;
        itemInfo.object = this.mAdapter.instantiateItem((ViewGroup)this, n2);
        itemInfo.widthFactor = this.mAdapter.getPageWidth(n2);
        if (n3 >= 0 && n3 < this.mItems.size()) {
            this.mItems.add(n3, itemInfo);
        } else {
            this.mItems.add(itemInfo);
        }
        return itemInfo;
    }

    public void addOnAdapterChangeListener(OnAdapterChangeListener onAdapterChangeListener) {
        if (this.mAdapterChangeListeners == null) {
            this.mAdapterChangeListeners = new ArrayList<OnAdapterChangeListener>();
        }
        this.mAdapterChangeListeners.add(onAdapterChangeListener);
    }

    public void addOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        if (this.mOnPageChangeListeners == null) {
            this.mOnPageChangeListeners = new ArrayList<OnPageChangeListener>();
        }
        this.mOnPageChangeListeners.add(onPageChangeListener);
    }

    public void addTouchables(ArrayList<View> arrayList) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem) continue;
            view.addTouchables(arrayList);
        }
    }

    public void addView(View view, int n2, ViewGroup.LayoutParams layoutParams) {
        ViewGroup.LayoutParams layoutParams2 = layoutParams;
        if (!this.checkLayoutParams(layoutParams)) {
            layoutParams2 = this.generateLayoutParams(layoutParams);
        }
        layoutParams = (LayoutParams)layoutParams2;
        layoutParams.isDecor |= ViewPager.isDecorView(view);
        if (this.mInLayout) {
            if (layoutParams != null && layoutParams.isDecor) {
                throw new IllegalStateException("Cannot add pager decor view during layout");
            }
            layoutParams.needsMeasure = true;
            this.addViewInLayout(view, n2, layoutParams2);
        } else {
            super.addView(view, n2, layoutParams2);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean arrowScroll(int var1_1) {
        block16: {
            block14: {
                block15: {
                    var2_2 = this.findFocus();
                    var3_3 = false;
                    var4_4 = null;
                    if (var2_2 != this) break block15;
                    var5_5 = var4_4;
                    break block16;
                }
                if (var2_2 == null) ** GOTO lbl-1000
                var5_5 = var2_2.getParent();
                while (var5_5 instanceof ViewGroup) {
                    if (var5_5 == this) {
                        var6_6 = 1;
                        break block14;
                    }
                    var5_5 = var5_5.getParent();
                }
                var6_6 = 0;
            }
            if (var6_6 == 0) {
                var7_7 = new StringBuilder();
                var7_7.append(var2_2.getClass().getSimpleName());
                var5_5 = var2_2.getParent();
                while (var5_5 instanceof ViewGroup) {
                    var7_7.append(" => ");
                    var7_7.append(var5_5.getClass().getSimpleName());
                    var5_5 = var5_5.getParent();
                }
                var5_5 = new StringBuilder();
                var5_5.append("arrowScroll tried to find focus based on non-child current focused view ");
                var5_5.append(var7_7.toString());
                Log.e((String)"ViewPager", (String)var5_5.toString());
                var5_5 = var4_4;
            } else lbl-1000:
            // 2 sources

            {
                var5_5 = var2_2;
            }
        }
        var4_4 = FocusFinder.getInstance().findNextFocus((ViewGroup)this, (View)var5_5, var1_1);
        if (var4_4 != null && var4_4 != var5_5) {
            if (var1_1 == 17) {
                var6_6 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var4_4).left;
                var8_8 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var5_5).left;
                var3_3 = var5_5 != null && var6_6 >= var8_8 ? this.pageLeft() : var4_4.requestFocus();
            } else if (var1_1 == 66) {
                var6_6 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var4_4).left;
                var8_9 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var5_5).left;
                var3_3 = var5_5 != null && var6_6 <= var8_9 ? this.pageRight() : var4_4.requestFocus();
            }
        } else if (var1_1 != 17 && var1_1 != 1) {
            if (var1_1 == 66 || var1_1 == 2) {
                var3_3 = this.pageRight();
            }
        } else {
            var3_3 = this.pageLeft();
        }
        if (var3_3) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)var1_1));
        }
        return var3_3;
    }

    public boolean beginFakeDrag() {
        if (this.mIsBeingDragged) {
            return false;
        }
        this.mFakeDragging = true;
        this.setScrollState(1);
        this.mLastMotionX = 0.0f;
        this.mInitialMotionX = 0.0f;
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            velocityTracker.clear();
        }
        long l2 = SystemClock.uptimeMillis();
        velocityTracker = MotionEvent.obtain((long)l2, (long)l2, (int)0, (float)0.0f, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement((MotionEvent)velocityTracker);
        velocityTracker.recycle();
        this.mFakeDragBeginTime = l2;
        return true;
    }

    protected boolean canScroll(View view, boolean bl, int n2, int n3, int n4) {
        boolean bl2 = view instanceof ViewGroup;
        boolean bl3 = true;
        if (bl2) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n5 = view.getScrollX();
            int n6 = view.getScrollY();
            for (int i2 = viewGroup.getChildCount() - 1; i2 >= 0; --i2) {
                int n7;
                int n8 = n3 + n5;
                View view2 = viewGroup.getChildAt(i2);
                if (n8 < view2.getLeft() || n8 >= view2.getRight() || (n7 = n4 + n6) < view2.getTop() || n7 >= view2.getBottom() || !this.canScroll(view2, true, n2, n8 - view2.getLeft(), n7 - view2.getTop())) continue;
                return true;
            }
        }
        bl = bl && view.canScrollHorizontally(-n2) ? bl3 : false;
        return bl;
    }

    public boolean canScrollHorizontally(int n2) {
        PagerAdapter pagerAdapter = this.mAdapter;
        boolean bl = false;
        boolean bl2 = false;
        if (pagerAdapter == null) {
            return false;
        }
        int n3 = this.getClientWidth();
        int n4 = this.getScrollX();
        if (n2 < 0) {
            if (n4 > (int)((float)n3 * this.mFirstOffset)) {
                bl2 = true;
            }
            return bl2;
        }
        bl2 = bl;
        if (n2 > 0) {
            bl2 = bl;
            if (n4 < (int)((float)n3 * this.mLastOffset)) {
                bl2 = true;
            }
        }
        return bl2;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        boolean bl = layoutParams instanceof LayoutParams && super.checkLayoutParams(layoutParams);
        return bl;
    }

    public void clearOnPageChangeListeners() {
        List<OnPageChangeListener> list = this.mOnPageChangeListeners;
        if (list != null) {
            list.clear();
        }
    }

    public void computeScroll() {
        this.mIsScrollStarted = true;
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int n2 = this.getScrollX();
            int n3 = this.getScrollY();
            int n4 = this.mScroller.getCurrX();
            int n5 = this.mScroller.getCurrY();
            if (n2 != n4 || n3 != n5) {
                this.scrollTo(n4, n5);
                if (!this.pageScrolled(n4)) {
                    this.mScroller.abortAnimation();
                    this.scrollTo(0, n5);
                }
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.completeScroll(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    void dataSetChanged() {
        int n2;
        this.mExpectedAdapterCount = n2 = this.mAdapter.getCount();
        int n3 = this.mItems.size() < this.mOffscreenPageLimit * 2 + 1 && this.mItems.size() < n2 ? 1 : 0;
        int n4 = this.mCurItem;
        int n5 = n3;
        n3 = n4;
        int n6 = 0;
        n4 = 0;
        while (n6 < this.mItems.size()) {
            int n7;
            int n8;
            int n9;
            block12: {
                block14: {
                    int n10;
                    ItemInfo itemInfo;
                    block13: {
                        block11: {
                            itemInfo = this.mItems.get(n6);
                            n10 = this.mAdapter.getItemPosition(itemInfo.object);
                            if (n10 != -1) break block11;
                            n9 = n6;
                            n8 = n4;
                            n7 = n3;
                            break block12;
                        }
                        if (n10 != -2) break block13;
                        this.mItems.remove(n6);
                        n9 = n6 - 1;
                        n8 = n4;
                        if (n4 == 0) {
                            this.mAdapter.startUpdate((ViewGroup)this);
                            n8 = 1;
                        }
                        this.mAdapter.destroyItem((ViewGroup)this, itemInfo.position, itemInfo.object);
                        n6 = n9;
                        n4 = n8;
                        if (this.mCurItem == itemInfo.position) {
                            n3 = Math.max(0, Math.min(this.mCurItem, n2 - 1));
                            n4 = n8;
                            n6 = n9;
                        }
                        break block14;
                    }
                    n9 = n6;
                    n8 = n4;
                    n7 = n3;
                    if (itemInfo.position == n10) break block12;
                    if (itemInfo.position == this.mCurItem) {
                        n3 = n10;
                    }
                    itemInfo.position = n10;
                }
                n5 = 1;
                n9 = n6;
                n8 = n4;
                n7 = n3;
            }
            n6 = n9 + 1;
            n4 = n8;
            n3 = n7;
        }
        if (n4 != 0) {
            this.mAdapter.finishUpdate((ViewGroup)this);
        }
        Collections.sort(this.mItems, COMPARATOR);
        if (n5 != 0) {
            n6 = this.getChildCount();
            for (n4 = 0; n4 < n6; ++n4) {
                LayoutParams layoutParams = (LayoutParams)this.getChildAt(n4).getLayoutParams();
                if (layoutParams.isDecor) continue;
                layoutParams.widthFactor = 0.0f;
            }
            this.setCurrentItemInternal(n3, false, true);
            this.requestLayout();
        }
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        boolean bl = super.dispatchKeyEvent(keyEvent) || this.executeKeyEvent(keyEvent);
        return bl;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (accessibilityEvent.getEventType() == 4096) {
            return super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        }
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem || !view.dispatchPopulateAccessibilityEvent(accessibilityEvent)) continue;
            return true;
        }
        return false;
    }

    float distanceInfluenceForSnapDuration(float f2) {
        return (float)Math.sin((f2 - 0.5f) * 0.47123894f);
    }

    public void draw(Canvas canvas) {
        PagerAdapter pagerAdapter;
        super.draw(canvas);
        int n2 = this.getOverScrollMode();
        int n3 = 0;
        int n4 = 0;
        if (n2 != 0 && (n2 != 1 || (pagerAdapter = this.mAdapter) == null || pagerAdapter.getCount() <= 1)) {
            this.mLeftEdge.finish();
            this.mRightEdge.finish();
        } else {
            if (!this.mLeftEdge.isFinished()) {
                n3 = canvas.save();
                n4 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                n2 = this.getWidth();
                canvas.rotate(270.0f);
                canvas.translate((float)(-n4 + this.getPaddingTop()), this.mFirstOffset * (float)n2);
                this.mLeftEdge.setSize(n4, n2);
                n4 = 0 | this.mLeftEdge.draw(canvas);
                canvas.restoreToCount(n3);
            }
            n3 = n4;
            if (!this.mRightEdge.isFinished()) {
                n2 = canvas.save();
                int n5 = this.getWidth();
                int n6 = this.getHeight();
                n3 = this.getPaddingTop();
                int n7 = this.getPaddingBottom();
                canvas.rotate(90.0f);
                canvas.translate((float)(-this.getPaddingTop()), -(this.mLastOffset + 1.0f) * (float)n5);
                this.mRightEdge.setSize(n6 - n3 - n7, n5);
                n3 = n4 | this.mRightEdge.draw(canvas);
                canvas.restoreToCount(n2);
            }
        }
        if (n3 != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable2 = this.mMarginDrawable;
        if (drawable2 != null && drawable2.isStateful()) {
            drawable2.setState(this.getDrawableState());
        }
    }

    public void endFakeDrag() {
        if (this.mFakeDragging) {
            if (this.mAdapter != null) {
                Object object = this.mVelocityTracker;
                object.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int n2 = (int)object.getXVelocity(this.mActivePointerId);
                this.mPopulatePending = true;
                int n3 = this.getClientWidth();
                int n4 = this.getScrollX();
                object = this.infoForCurrentScrollPosition();
                this.setCurrentItemInternal(this.determineTargetPage(object.position, ((float)n4 / (float)n3 - object.offset) / object.widthFactor, n2, (int)(this.mLastMotionX - this.mInitialMotionX)), true, true, n2);
            }
            this.endDrag();
            this.mFakeDragging = false;
            return;
        }
        throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
    }

    public boolean executeKeyEvent(KeyEvent keyEvent) {
        boolean bl;
        block4: {
            block0: {
                block1: {
                    block2: {
                        block3: {
                            if (keyEvent.getAction() != 0) break block0;
                            int n2 = keyEvent.getKeyCode();
                            if (n2 == 21) break block1;
                            if (n2 == 22) break block2;
                            if (n2 != 61) break block0;
                            if (!keyEvent.hasNoModifiers()) break block3;
                            bl = this.arrowScroll(2);
                            break block4;
                        }
                        if (!keyEvent.hasModifiers(1)) break block0;
                        bl = this.arrowScroll(1);
                        break block4;
                    }
                    bl = keyEvent.hasModifiers(2) ? this.pageRight() : this.arrowScroll(66);
                    break block4;
                }
                bl = keyEvent.hasModifiers(2) ? this.pageLeft() : this.arrowScroll(17);
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public void fakeDragBy(float f2) {
        if (this.mFakeDragging) {
            if (this.mAdapter == null) {
                return;
            }
            this.mLastMotionX += f2;
            float f3 = (float)this.getScrollX() - f2;
            float f4 = this.getClientWidth();
            f2 = this.mFirstOffset * f4;
            float f5 = this.mLastOffset * f4;
            ItemInfo itemInfo = this.mItems.get(0);
            Object object = this.mItems;
            object = ((ArrayList)object).get(((ArrayList)object).size() - 1);
            if (itemInfo.position != 0) {
                f2 = itemInfo.offset * f4;
            }
            if (((ItemInfo)object).position != this.mAdapter.getCount() - 1) {
                f5 = ((ItemInfo)object).offset * f4;
            }
            if (!(f3 < f2)) {
                f2 = f3;
                if (f3 > f5) {
                    f2 = f5;
                }
            }
            f5 = this.mLastMotionX;
            int n2 = (int)f2;
            this.mLastMotionX = f5 + (f2 - (float)n2);
            this.scrollTo(n2, this.getScrollY());
            this.pageScrolled(n2);
            long l2 = SystemClock.uptimeMillis();
            itemInfo = MotionEvent.obtain((long)this.mFakeDragBeginTime, (long)l2, (int)2, (float)this.mLastMotionX, (float)0.0f, (int)0);
            this.mVelocityTracker.addMovement((MotionEvent)itemInfo);
            itemInfo.recycle();
            return;
        }
        throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return this.generateDefaultLayoutParams();
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    protected int getChildDrawingOrder(int n2, int n3) {
        int n4 = n3;
        if (this.mDrawingOrder == 2) {
            n4 = n2 - 1 - n3;
        }
        return ((LayoutParams)this.mDrawingOrderedChildren.get((int)n4).getLayoutParams()).childIndex;
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public int getPageMargin() {
        return this.mPageMargin;
    }

    ItemInfo infoForAnyChild(View view) {
        ViewParent viewParent;
        while ((viewParent = view.getParent()) != this) {
            if (viewParent != null && viewParent instanceof View) {
                view = (View)viewParent;
                continue;
            }
            return null;
        }
        return this.infoForChild(view);
    }

    ItemInfo infoForChild(View view) {
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ItemInfo itemInfo = this.mItems.get(i2);
            if (!this.mAdapter.isViewFromObject(view, itemInfo.object)) continue;
            return itemInfo;
        }
        return null;
    }

    ItemInfo infoForPosition(int n2) {
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ItemInfo itemInfo = this.mItems.get(i2);
            if (itemInfo.position != n2) continue;
            return itemInfo;
        }
        return null;
    }

    void initViewPager() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        float f2 = context.getResources().getDisplayMetrics().density;
        this.mTouchSlop = viewConfiguration.getScaledPagingTouchSlop();
        this.mMinimumVelocity = (int)(400.0f * f2);
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mLeftEdge = new EdgeEffect(context);
        this.mRightEdge = new EdgeEffect(context);
        this.mFlingDistance = (int)(25.0f * f2);
        this.mCloseEnough = (int)(2.0f * f2);
        this.mDefaultGutterSize = (int)(f2 * 16.0f);
        ViewCompat.setAccessibilityDelegate((View)this, new MyAccessibilityDelegate());
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, 1);
        }
        ViewCompat.setOnApplyWindowInsetsListener((View)this, new OnApplyWindowInsetsListener(){
            private final Rect mTempRect = new Rect();

            public WindowInsetsCompat onApplyWindowInsets(View object, WindowInsetsCompat windowInsetsCompat) {
                if (((WindowInsetsCompat)(object = ViewCompat.onApplyWindowInsets((View)object, windowInsetsCompat))).isConsumed()) {
                    return object;
                }
                windowInsetsCompat = this.mTempRect;
                ((Rect)windowInsetsCompat).left = ((WindowInsetsCompat)object).getSystemWindowInsetLeft();
                ((Rect)windowInsetsCompat).top = ((WindowInsetsCompat)object).getSystemWindowInsetTop();
                ((Rect)windowInsetsCompat).right = ((WindowInsetsCompat)object).getSystemWindowInsetRight();
                ((Rect)windowInsetsCompat).bottom = ((WindowInsetsCompat)object).getSystemWindowInsetBottom();
                int n2 = ViewPager.this.getChildCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    WindowInsetsCompat windowInsetsCompat2 = ViewCompat.dispatchApplyWindowInsets(ViewPager.this.getChildAt(i2), (WindowInsetsCompat)object);
                    ((Rect)windowInsetsCompat).left = Math.min(windowInsetsCompat2.getSystemWindowInsetLeft(), ((Rect)windowInsetsCompat).left);
                    ((Rect)windowInsetsCompat).top = Math.min(windowInsetsCompat2.getSystemWindowInsetTop(), ((Rect)windowInsetsCompat).top);
                    ((Rect)windowInsetsCompat).right = Math.min(windowInsetsCompat2.getSystemWindowInsetRight(), ((Rect)windowInsetsCompat).right);
                    ((Rect)windowInsetsCompat).bottom = Math.min(windowInsetsCompat2.getSystemWindowInsetBottom(), ((Rect)windowInsetsCompat).bottom);
                }
                return ((WindowInsetsCompat)object).replaceSystemWindowInsets(((Rect)windowInsetsCompat).left, ((Rect)windowInsetsCompat).top, ((Rect)windowInsetsCompat).right, ((Rect)windowInsetsCompat).bottom);
            }
        });
    }

    public boolean isFakeDragging() {
        return this.mFakeDragging;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mEndScrollRunnable);
        Scroller scroller = this.mScroller;
        if (scroller != null && !scroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
        super.onDetachedFromWindow();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPageMargin > 0 && this.mMarginDrawable != null && this.mItems.size() > 0 && this.mAdapter != null) {
            int n2 = this.getScrollX();
            int n3 = this.getWidth();
            float f2 = this.mPageMargin;
            float f3 = n3;
            float f4 = f2 / f3;
            Object object = this.mItems;
            int n4 = 0;
            object = ((ArrayList)object).get(0);
            f2 = ((ItemInfo)object).offset;
            int n5 = this.mItems.size();
            int n6 = this.mItems.get((int)(n5 - 1)).position;
            for (int i2 = ((ItemInfo)object).position; i2 < n6; ++i2) {
                float f5;
                while (i2 > ((ItemInfo)object).position && n4 < n5) {
                    object = this.mItems;
                    object = ((ArrayList)object).get(++n4);
                }
                if (i2 == ((ItemInfo)object).position) {
                    f5 = (((ItemInfo)object).offset + ((ItemInfo)object).widthFactor) * f3;
                    f2 = ((ItemInfo)object).offset + ((ItemInfo)object).widthFactor + f4;
                } else {
                    float f6 = this.mAdapter.getPageWidth(i2);
                    f5 = f2 + (f6 + f4);
                    f6 = (f2 + f6) * f3;
                    f2 = f5;
                    f5 = f6;
                }
                if ((float)this.mPageMargin + f5 > (float)n2) {
                    this.mMarginDrawable.setBounds(Math.round(f5), this.mTopPageBounds, Math.round((float)this.mPageMargin + f5), this.mBottomPageBounds);
                    this.mMarginDrawable.draw(canvas);
                }
                if (f5 > (float)(n2 + n3)) break;
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction() & 0xFF;
        if (n2 != 3 && n2 != 1) {
            if (n2 != 0) {
                if (this.mIsBeingDragged) {
                    return true;
                }
                if (this.mIsUnableToDrag) {
                    return false;
                }
            }
            if (n2 != 0) {
                if (n2 != 2) {
                    if (n2 == 6) {
                        this.onSecondaryPointerUp(motionEvent);
                    }
                } else {
                    n2 = this.mActivePointerId;
                    if (n2 != -1) {
                        n2 = motionEvent.findPointerIndex(n2);
                        float f2 = motionEvent.getX(n2);
                        float f3 = f2 - this.mLastMotionX;
                        float f4 = Math.abs(f3);
                        float f5 = motionEvent.getY(n2);
                        float f6 = Math.abs(f5 - this.mInitialMotionY);
                        if (f3 != 0.0f && !this.isGutterDrag(this.mLastMotionX, f3) && this.canScroll((View)this, false, (int)f3, (int)f2, (int)f5)) {
                            this.mLastMotionX = f2;
                            this.mLastMotionY = f5;
                            this.mIsUnableToDrag = true;
                            return false;
                        }
                        if (f4 > (float)this.mTouchSlop && f4 * 0.5f > f6) {
                            this.mIsBeingDragged = true;
                            this.requestParentDisallowInterceptTouchEvent(true);
                            this.setScrollState(1);
                            f4 = f3 > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                            this.mLastMotionX = f4;
                            this.mLastMotionY = f5;
                            this.setScrollingCacheEnabled(true);
                        } else if (f6 > (float)this.mTouchSlop) {
                            this.mIsUnableToDrag = true;
                        }
                        if (this.mIsBeingDragged && this.performDrag(f2)) {
                            ViewCompat.postInvalidateOnAnimation((View)this);
                        }
                    }
                }
            } else {
                float f7;
                this.mInitialMotionX = f7 = motionEvent.getX();
                this.mLastMotionX = f7;
                this.mInitialMotionY = f7 = motionEvent.getY();
                this.mLastMotionY = f7;
                this.mActivePointerId = motionEvent.getPointerId(0);
                this.mIsUnableToDrag = false;
                this.mIsScrollStarted = true;
                this.mScroller.computeScrollOffset();
                if (this.mScrollState == 2 && Math.abs(this.mScroller.getFinalX() - this.mScroller.getCurrX()) > this.mCloseEnough) {
                    this.mScroller.abortAnimation();
                    this.mPopulatePending = false;
                    this.populate();
                    this.mIsBeingDragged = true;
                    this.requestParentDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                } else {
                    this.completeScroll(false);
                    this.mIsBeingDragged = false;
                }
            }
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            this.mVelocityTracker.addMovement(motionEvent);
            return this.mIsBeingDragged;
        }
        this.resetTouch();
        return false;
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        Object object;
        int n6;
        Object object2;
        int n7 = this.getChildCount();
        int n8 = n4 - n2;
        int n9 = n5 - n3;
        n3 = this.getPaddingLeft();
        n2 = this.getPaddingTop();
        int n10 = this.getPaddingRight();
        n5 = this.getPaddingBottom();
        int n11 = this.getScrollX();
        int n12 = 0;
        for (int i2 = 0; i2 < n7; ++i2) {
            object2 = this.getChildAt(i2);
            n6 = n3;
            int n13 = n10;
            int n14 = n2;
            int n15 = n5;
            n4 = n12;
            if (object2.getVisibility() != 8) {
                object = (LayoutParams)object2.getLayoutParams();
                n6 = n3;
                n13 = n10;
                n14 = n2;
                n15 = n5;
                n4 = n12;
                if (object.isDecor) {
                    n4 = object.gravity & 7;
                    n15 = object.gravity & 0x70;
                    if (n4 != 1) {
                        if (n4 != 3) {
                            if (n4 != 5) {
                                n4 = n3;
                                n6 = n3;
                            } else {
                                n4 = n8 - n10 - object2.getMeasuredWidth();
                                n10 += object2.getMeasuredWidth();
                                n6 = n3;
                            }
                        } else {
                            n6 = object2.getMeasuredWidth();
                            n4 = n3;
                            n6 += n3;
                        }
                    } else {
                        n4 = Math.max((n8 - object2.getMeasuredWidth()) / 2, n3);
                        n6 = n3;
                    }
                    if (n15 != 16) {
                        if (n15 != 48) {
                            if (n15 != 80) {
                                n3 = n2;
                            } else {
                                n3 = n9 - n5 - object2.getMeasuredHeight();
                                n5 += object2.getMeasuredHeight();
                            }
                        } else {
                            n15 = object2.getMeasuredHeight();
                            n3 = n2;
                            n2 = n15 + n2;
                        }
                    } else {
                        n3 = Math.max((n9 - object2.getMeasuredHeight()) / 2, n2);
                    }
                    object2.layout(n4 += n11, n3, object2.getMeasuredWidth() + n4, n3 + object2.getMeasuredHeight());
                    n4 = n12 + 1;
                    n15 = n5;
                    n14 = n2;
                    n13 = n10;
                }
            }
            n3 = n6;
            n10 = n13;
            n2 = n14;
            n5 = n15;
            n12 = n4;
        }
        for (n4 = 0; n4 < n7; ++n4) {
            ItemInfo itemInfo;
            object = this.getChildAt(n4);
            if (object.getVisibility() == 8) continue;
            object2 = (LayoutParams)object.getLayoutParams();
            if (object2.isDecor || (itemInfo = this.infoForChild((View)object)) == null) continue;
            float f2 = n8 - n3 - n10;
            n6 = (int)(itemInfo.offset * f2) + n3;
            if (object2.needsMeasure) {
                object2.needsMeasure = false;
                object.measure(View.MeasureSpec.makeMeasureSpec((int)((int)(f2 * object2.widthFactor)), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(n9 - n2 - n5), (int)0x40000000));
            }
            object.layout(n6, n2, object.getMeasuredWidth() + n6, object.getMeasuredHeight() + n2);
        }
        this.mTopPageBounds = n2;
        this.mBottomPageBounds = n9 - n5;
        this.mDecorChildCount = n12;
        if (this.mFirstLayout) {
            this.scrollToItem(this.mCurItem, false, 0, false);
        }
        this.mFirstLayout = false;
    }

    /*
     * Unable to fully structure code
     */
    protected void onMeasure(int var1_1, int var2_2) {
        this.setMeasuredDimension(ViewPager.getDefaultSize((int)0, (int)var1_1), ViewPager.getDefaultSize((int)0, (int)var2_2));
        var3_3 = this.getMeasuredWidth();
        this.mGutterSize = Math.min(var3_3 / 10, this.mDefaultGutterSize);
        var4_4 = this.getPaddingLeft();
        var1_1 = this.getPaddingRight();
        var5_5 = this.getMeasuredHeight();
        var2_2 = this.getPaddingTop();
        var6_6 = this.getPaddingBottom();
        var7_7 = this.getChildCount();
        var2_2 = var5_5 - var2_2 - var6_6;
        var1_1 = var3_3 - var4_4 - var1_1;
        var6_6 = 0;
        while (true) {
            block12: {
                block13: {
                    var8_8 = 1;
                    var9_9 = 0x40000000;
                    if (var6_6 >= var7_7) break;
                    var10_10 = this.getChildAt(var6_6);
                    var4_4 = var1_1;
                    var3_3 = var2_2;
                    if (var10_10.getVisibility() == 8) break block12;
                    var11_11 = (LayoutParams)var10_10.getLayoutParams();
                    var4_4 = var1_1;
                    var3_3 = var2_2;
                    if (var11_11 == null) break block12;
                    var4_4 = var1_1;
                    var3_3 = var2_2;
                    if (!var11_11.isDecor) break block12;
                    var3_3 = var11_11.gravity & 7;
                    var4_4 = var11_11.gravity & 112;
                    var12_12 = var4_4 == 48 || var4_4 == 80;
                    var5_5 = var8_8;
                    if (var3_3 != 3) {
                        var5_5 = var3_3 == 5 ? var8_8 : 0;
                    }
                    var3_3 = -2147483648;
                    if (!var12_12) break block13;
                    var4_4 = 0x40000000;
                    ** GOTO lbl-1000
                }
                var4_4 = var3_3;
                if (var5_5 != 0) {
                    var8_8 = 0x40000000;
                    var4_4 = var3_3;
                    var3_3 = var8_8;
                } else lbl-1000:
                // 2 sources

                {
                    var3_3 = -2147483648;
                }
                if (var11_11.width != -2) {
                    var4_4 = var11_11.width != -1 ? var11_11.width : var1_1;
                    var8_8 = 0x40000000;
                    var13_13 = var4_4;
                } else {
                    var13_13 = var1_1;
                    var8_8 = var4_4;
                }
                if (var11_11.height != -2) {
                    var3_3 = var11_11.height != -1 ? var11_11.height : var2_2;
                } else {
                    var4_4 = var2_2;
                    var9_9 = var3_3;
                    var3_3 = var4_4;
                }
                var10_10.measure(View.MeasureSpec.makeMeasureSpec((int)var13_13, (int)var8_8), View.MeasureSpec.makeMeasureSpec((int)var3_3, (int)var9_9));
                if (var12_12) {
                    var3_3 = var2_2 - var10_10.getMeasuredHeight();
                    var4_4 = var1_1;
                } else {
                    var4_4 = var1_1;
                    var3_3 = var2_2;
                    if (var5_5 != 0) {
                        var4_4 = var1_1 - var10_10.getMeasuredWidth();
                        var3_3 = var2_2;
                    }
                }
            }
            ++var6_6;
            var1_1 = var4_4;
            var2_2 = var3_3;
        }
        this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)var1_1, (int)0x40000000);
        this.mChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)var2_2, (int)0x40000000);
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        var3_3 = this.getChildCount();
        for (var2_2 = 0; var2_2 < var3_3; ++var2_2) {
            var10_10 = this.getChildAt(var2_2);
            if (var10_10.getVisibility() == 8 || (var11_11 = (LayoutParams)var10_10.getLayoutParams()) != null && var11_11.isDecor) continue;
            var10_10.measure(View.MeasureSpec.makeMeasureSpec((int)((int)((float)var1_1 * var11_11.widthFactor)), (int)0x40000000), this.mChildHeightMeasureSpec);
        }
    }

    protected void onPageScrolled(int n2, float f2, int n3) {
        Object object;
        int n4 = this.mDecorChildCount;
        int n5 = 0;
        if (n4 > 0) {
            int n6 = this.getScrollX();
            n4 = this.getPaddingLeft();
            int n7 = this.getPaddingRight();
            int n8 = this.getWidth();
            int n9 = this.getChildCount();
            for (int i2 = 0; i2 < n9; ++i2) {
                View view = this.getChildAt(i2);
                object = (LayoutParams)view.getLayoutParams();
                if (!object.isDecor) continue;
                int n10 = object.gravity & 7;
                if (n10 != 1) {
                    int n11;
                    if (n10 != 3) {
                        if (n10 != 5) {
                            n11 = n4;
                            n10 = n4;
                            n4 = n11;
                        } else {
                            n10 = n8 - n7 - view.getMeasuredWidth();
                            n7 += view.getMeasuredWidth();
                        }
                    } else {
                        n11 = view.getWidth() + n4;
                        n10 = n4;
                        n4 = n11;
                    }
                } else {
                    n10 = Math.max((n8 - view.getMeasuredWidth()) / 2, n4);
                }
                n10 = n10 + n6 - view.getLeft();
                if (n10 == 0) continue;
                view.offsetLeftAndRight(n10);
            }
        }
        this.dispatchOnPageScrolled(n2, f2, n3);
        if (this.mPageTransformer != null) {
            n4 = this.getScrollX();
            n3 = this.getChildCount();
            for (n2 = n5; n2 < n3; ++n2) {
                object = this.getChildAt(n2);
                if (((LayoutParams)object.getLayoutParams()).isDecor) continue;
                f2 = (float)(object.getLeft() - n4) / (float)this.getClientWidth();
                this.mPageTransformer.transformPage((View)object, f2);
            }
        }
        this.mCalledSuper = true;
    }

    protected boolean onRequestFocusInDescendants(int n2, Rect rect) {
        int n3;
        int n4 = this.getChildCount();
        int n5 = -1;
        if ((n2 & 2) != 0) {
            n5 = n4;
            n4 = 0;
            n3 = 1;
        } else {
            --n4;
            n3 = -1;
        }
        while (n4 != n5) {
            ItemInfo itemInfo;
            View view = this.getChildAt(n4);
            if (view.getVisibility() == 0 && (itemInfo = this.infoForChild(view)) != null && itemInfo.position == this.mCurItem && view.requestFocus(n2, rect)) {
                return true;
            }
            n4 += n3;
        }
        return false;
    }

    public void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        object = (SavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        PagerAdapter pagerAdapter = this.mAdapter;
        if (pagerAdapter != null) {
            pagerAdapter.restoreState(object.adapterState, object.loader);
            this.setCurrentItemInternal(object.position, false, true);
        } else {
            this.mRestoredCurItem = object.position;
            this.mRestoredAdapterState = object.adapterState;
            this.mRestoredClassLoader = object.loader;
        }
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.position = this.mCurItem;
        PagerAdapter pagerAdapter = this.mAdapter;
        if (pagerAdapter != null) {
            savedState.adapterState = pagerAdapter.saveState();
        }
        return savedState;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (n2 != n4) {
            n3 = this.mPageMargin;
            this.recomputeScrollPosition(n2, n4, n3, n3);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        block16: {
            block20: {
                block17: {
                    block18: {
                        block19: {
                            if (this.mFakeDragging) {
                                return true;
                            }
                            var2_2 = var1_1.getAction();
                            var3_3 = false;
                            if (var2_2 == 0 && var1_1.getEdgeFlags() != 0) {
                                return false;
                            }
                            var4_4 /* !! */  = this.mAdapter;
                            if (var4_4 /* !! */  == null || var4_4 /* !! */ .getCount() == 0) break block16;
                            if (this.mVelocityTracker == null) {
                                this.mVelocityTracker = VelocityTracker.obtain();
                            }
                            this.mVelocityTracker.addMovement(var1_1);
                            var2_2 = var1_1.getAction() & 255;
                            if (var2_2 == 0) break block17;
                            if (var2_2 == 1) break block18;
                            if (var2_2 == 2) break block19;
                            if (var2_2 != 3) {
                                if (var2_2 != 5) {
                                    if (var2_2 == 6) {
                                        this.onSecondaryPointerUp(var1_1);
                                        this.mLastMotionX = var1_1.getX(var1_1.findPointerIndex(this.mActivePointerId));
                                    }
                                } else {
                                    var2_2 = var1_1.getActionIndex();
                                    this.mLastMotionX = var1_1.getX(var2_2);
                                    this.mActivePointerId = var1_1.getPointerId(var2_2);
                                }
                            } else if (this.mIsBeingDragged) {
                                this.scrollToItem(this.mCurItem, true, 0, false);
                                var3_3 = this.resetTouch();
                            }
                            break block20;
                        }
                        if (this.mIsBeingDragged) ** GOTO lbl52
                        var2_2 = var1_1.findPointerIndex(this.mActivePointerId);
                        if (var2_2 == -1) {
                            var3_3 = this.resetTouch();
                        } else {
                            var5_5 = var1_1.getX(var2_2);
                            var6_8 = Math.abs(var5_5 - this.mLastMotionX);
                            var7_9 = var1_1.getY(var2_2);
                            var8_11 = Math.abs(var7_9 - this.mLastMotionY);
                            if (var6_8 > (float)this.mTouchSlop && var6_8 > var8_11) {
                                this.mIsBeingDragged = true;
                                this.requestParentDisallowInterceptTouchEvent(true);
                                var8_11 = this.mInitialMotionX;
                                var5_5 = var5_5 - var8_11 > 0.0f ? var8_11 + (float)this.mTouchSlop : var8_11 - (float)this.mTouchSlop;
                                this.mLastMotionX = var5_5;
                                this.mLastMotionY = var7_9;
                                this.setScrollState(1);
                                this.setScrollingCacheEnabled(true);
                                var4_4 /* !! */  = this.getParent();
                                if (var4_4 /* !! */  != null) {
                                    var4_4 /* !! */ .requestDisallowInterceptTouchEvent(true);
                                }
                            }
lbl52:
                            // 6 sources

                            if (this.mIsBeingDragged) {
                                var3_3 = false | this.performDrag(var1_1.getX(var1_1.findPointerIndex(this.mActivePointerId)));
                            }
                        }
                        break block20;
                    }
                    if (this.mIsBeingDragged) {
                        var4_4 /* !! */  = this.mVelocityTracker;
                        var4_4 /* !! */ .computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                        var2_2 = (int)var4_4 /* !! */ .getXVelocity(this.mActivePointerId);
                        this.mPopulatePending = true;
                        var9_12 = this.getClientWidth();
                        var10_13 = this.getScrollX();
                        var4_4 /* !! */  = this.infoForCurrentScrollPosition();
                        var7_10 = this.mPageMargin;
                        var5_6 = var9_12;
                        this.setCurrentItemInternal(this.determineTargetPage(var4_4 /* !! */ .position, ((float)var10_13 / var5_6 - var4_4 /* !! */ .offset) / (var4_4 /* !! */ .widthFactor + (var7_10 /= var5_6)), var2_2, (int)(var1_1.getX(var1_1.findPointerIndex(this.mActivePointerId)) - this.mInitialMotionX)), true, true, var2_2);
                        var3_3 = this.resetTouch();
                    }
                    break block20;
                }
                this.mScroller.abortAnimation();
                this.mPopulatePending = false;
                this.populate();
                this.mInitialMotionX = var5_7 = var1_1.getX();
                this.mLastMotionX = var5_7;
                this.mInitialMotionY = var5_7 = var1_1.getY();
                this.mLastMotionY = var5_7;
                this.mActivePointerId = var1_1.getPointerId(0);
            }
            if (var3_3) {
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
            return true;
        }
        return false;
    }

    boolean pageLeft() {
        int n2 = this.mCurItem;
        if (n2 > 0) {
            this.setCurrentItem(n2 - 1, true);
            return true;
        }
        return false;
    }

    boolean pageRight() {
        PagerAdapter pagerAdapter = this.mAdapter;
        if (pagerAdapter != null && this.mCurItem < pagerAdapter.getCount() - 1) {
            this.setCurrentItem(this.mCurItem + 1, true);
            return true;
        }
        return false;
    }

    void populate() {
        this.populate(this.mCurItem);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void populate(int var1_1) {
        block20: {
            block21: {
                block26: {
                    block18: {
                        var2_2 = this.mCurItem;
                        if (var2_2 != var1_1) {
                            var3_3 = this.infoForPosition(var2_2);
                            this.mCurItem = var1_1;
                        } else {
                            var3_3 = null;
                        }
                        if (this.mAdapter == null) {
                            this.sortChildDrawingOrder();
                            return;
                        }
                        if (this.mPopulatePending) {
                            this.sortChildDrawingOrder();
                            return;
                        }
                        if (this.getWindowToken() == null) {
                            return;
                        }
                        this.mAdapter.startUpdate((ViewGroup)this);
                        var1_1 = this.mOffscreenPageLimit;
                        var4_4 = Math.max(0, this.mCurItem - var1_1);
                        var5_5 = this.mAdapter.getCount();
                        var6_6 = Math.min(var5_5 - 1, this.mCurItem + var1_1);
                        if (var5_5 != this.mExpectedAdapterCount) break block20;
                        for (var1_1 = 0; var1_1 < this.mItems.size(); ++var1_1) {
                            var7_7 /* !! */  = this.mItems.get(var1_1);
                            if (var7_7 /* !! */ .position < this.mCurItem) continue;
                            if (var7_7 /* !! */ .position != this.mCurItem) break;
                            break block18;
                        }
                        var7_7 /* !! */  = null;
                    }
                    var8_10 = var7_7 /* !! */ ;
                    if (var7_7 /* !! */  == null) {
                        var8_10 = var7_7 /* !! */ ;
                        if (var5_5 > 0) {
                            var8_10 = this.addNewItem(this.mCurItem, var1_1);
                        }
                    }
                    if (var8_10 == null) break block21;
                    var2_2 = var1_1 - 1;
                    var7_7 /* !! */  = var2_2 >= 0 ? this.mItems.get(var2_2) : null;
                    var9_11 = this.getClientWidth();
                    var10_12 = var9_11 <= 0 ? 0.0f : 2.0f - var8_10.widthFactor + (float)this.getPaddingLeft() / (float)var9_11;
                    var12_14 = 0.0f;
                    var13_15 /* !! */  = var7_7 /* !! */ ;
                    for (var11_13 = this.mCurItem - 1; var11_13 >= 0; --var11_13) {
                        block23: {
                            block24: {
                                block25: {
                                    block22: {
                                        if (!(var12_14 >= var10_12) || var11_13 >= var4_4) break block22;
                                        if (var13_15 /* !! */  == null) break;
                                        var14_16 = var12_14;
                                        var15_17 = var1_1;
                                        var7_7 /* !! */  = var13_15 /* !! */ ;
                                        var16_18 = var2_2;
                                        if (var11_13 != var13_15 /* !! */ .position) break block23;
                                        var14_16 = var12_14;
                                        var15_17 = var1_1--;
                                        var7_7 /* !! */  = var13_15 /* !! */ ;
                                        var16_18 = var2_2;
                                        if (var13_15 /* !! */ .scrolling) break block23;
                                        this.mItems.remove(var2_2);
                                        this.mAdapter.destroyItem((ViewGroup)this, var11_13, var13_15 /* !! */ .object);
                                        var14_16 = var12_14;
                                        var16_18 = var1_1;
                                        var15_17 = --var2_2;
                                        if (var2_2 < 0) ** GOTO lbl-1000
                                        var7_7 /* !! */  = this.mItems.get(var2_2);
                                        var14_16 = var12_14;
                                        break block24;
                                    }
                                    if (var13_15 /* !! */  == null || var11_13 != var13_15 /* !! */ .position) break block25;
                                    var14_16 = var12_14 += var13_15 /* !! */ .widthFactor;
                                    var16_18 = var1_1;
                                    var15_17 = --var2_2;
                                    if (var2_2 < 0) ** GOTO lbl-1000
                                    var7_7 /* !! */  = this.mItems.get(var2_2);
                                    var14_16 = var12_14;
                                    break block24;
                                }
                                var14_16 = var12_14 += this.addNewItem((int)var11_13, (int)(var2_2 + 1)).widthFactor;
                                var16_18 = ++var1_1;
                                var15_17 = var2_2;
                                if (var2_2 >= 0) {
                                    var7_7 /* !! */  = this.mItems.get(var2_2);
                                    var14_16 = var12_14;
                                } else lbl-1000:
                                // 3 sources

                                {
                                    var7_7 /* !! */  = null;
                                    var2_2 = var15_17;
                                    var1_1 = var16_18;
                                }
                            }
                            var16_18 = var2_2;
                            var15_17 = var1_1;
                        }
                        var12_14 = var14_16;
                        var1_1 = var15_17;
                        var13_15 /* !! */  = var7_7 /* !! */ ;
                        var2_2 = var16_18;
                    }
                    var12_14 = var8_10.widthFactor;
                    var16_18 = var1_1 + 1;
                    if (!(var12_14 < 2.0f)) break block26;
                    var7_7 /* !! */  = var16_18 < this.mItems.size() ? this.mItems.get(var16_18) : null;
                    var10_12 = var9_11 <= 0 ? 0.0f : (float)this.getPaddingRight() / (float)var9_11 + 2.0f;
                    var2_2 = this.mCurItem;
                    var13_15 /* !! */  = var7_7 /* !! */ ;
                    while ((var15_17 = var2_2 + 1) < var5_5) {
                        block19: {
                            block29: {
                                block27: {
                                    block28: {
                                        if (!(var12_14 >= var10_12) || var15_17 <= var6_6) break block27;
                                        if (var13_15 /* !! */  == null) break;
                                        var14_16 = var12_14;
                                        var2_2 = var16_18;
                                        var7_7 /* !! */  = var13_15 /* !! */ ;
                                        if (var15_17 != var13_15 /* !! */ .position) break block19;
                                        var14_16 = var12_14;
                                        var2_2 = var16_18;
                                        var7_7 /* !! */  = var13_15 /* !! */ ;
                                        if (var13_15 /* !! */ .scrolling) break block19;
                                        this.mItems.remove(var16_18);
                                        this.mAdapter.destroyItem((ViewGroup)this, var15_17, var13_15 /* !! */ .object);
                                        var14_16 = var12_14;
                                        var2_2 = var16_18;
                                        if (var16_18 >= this.mItems.size()) break block28;
                                        var7_7 /* !! */  = this.mItems.get(var16_18);
                                        var14_16 = var12_14;
                                        var2_2 = var16_18;
                                        break block19;
                                    }
lbl121:
                                    // 3 sources

                                    while (true) {
                                        var7_7 /* !! */  = null;
                                        break block19;
                                        break;
                                    }
                                }
                                if (var13_15 /* !! */  == null || var15_17 != var13_15 /* !! */ .position) break block29;
                                var14_16 = var12_14 += var13_15 /* !! */ .widthFactor;
                                var2_2 = ++var16_18;
                                if (var16_18 >= this.mItems.size()) ** GOTO lbl121
                                var7_7 /* !! */  = this.mItems.get(var16_18);
                                var14_16 = var12_14;
                                var2_2 = var16_18;
                                break block19;
                            }
                            var7_7 /* !! */  = this.addNewItem(var15_17, var16_18);
                            var14_16 = var12_14 += var7_7 /* !! */ .widthFactor;
                            var2_2 = ++var16_18;
                            if (var16_18 >= this.mItems.size()) ** continue;
                            var7_7 /* !! */  = this.mItems.get(var16_18);
                            var2_2 = var16_18;
                            var14_16 = var12_14;
                        }
                        var12_14 = var14_16;
                        var16_18 = var2_2;
                        var13_15 /* !! */  = var7_7 /* !! */ ;
                        var2_2 = var15_17;
                    }
                }
                this.calculatePageOffsets(var8_10, var1_1, (ItemInfo)var3_3);
                this.mAdapter.setPrimaryItem((ViewGroup)this, this.mCurItem, var8_10.object);
            }
            this.mAdapter.finishUpdate((ViewGroup)this);
            var2_2 = this.getChildCount();
            for (var1_1 = 0; var1_1 < var2_2; ++var1_1) {
                var3_3 = this.getChildAt(var1_1);
                var7_7 /* !! */  = (LayoutParams)var3_3.getLayoutParams();
                var7_7 /* !! */ .childIndex = var1_1;
                if (var7_7 /* !! */ .isDecor || var7_7 /* !! */ .widthFactor != 0.0f || (var3_3 = this.infoForChild((View)var3_3)) == null) continue;
                var7_7 /* !! */ .widthFactor = var3_3.widthFactor;
                var7_7 /* !! */ .position = var3_3.position;
            }
            this.sortChildDrawingOrder();
            if (this.hasFocus() && ((var7_7 /* !! */  = (var7_7 /* !! */  = this.findFocus()) != null ? this.infoForAnyChild((View)var7_7 /* !! */ ) : null) == null || var7_7 /* !! */ .position != this.mCurItem)) {
                for (var1_1 = 0; !(var1_1 >= this.getChildCount() || (var3_3 = this.infoForChild((View)(var7_7 /* !! */  = this.getChildAt(var1_1)))) != null && var3_3.position == this.mCurItem && var7_7 /* !! */ .requestFocus(2)); ++var1_1) {
                }
            }
            return;
        }
        try {
            var7_8 = this.getResources().getResourceName(this.getId());
        }
        catch (Resources.NotFoundException var7_9) {
            var7_8 = Integer.toHexString(this.getId());
        }
        var3_3 = new StringBuilder();
        var3_3.append("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: ");
        var3_3.append(this.mExpectedAdapterCount);
        var3_3.append(", found: ");
        var3_3.append(var5_5);
        var3_3.append(" Pager id: ");
        var3_3.append((String)var7_8);
        var3_3.append(" Pager class: ");
        var3_3.append(this.getClass());
        var3_3.append(" Problematic adapter: ");
        var3_3.append(this.mAdapter.getClass());
        var7_8 = new IllegalStateException(var3_3.toString());
        throw var7_8;
    }

    public void removeOnAdapterChangeListener(OnAdapterChangeListener onAdapterChangeListener) {
        List<OnAdapterChangeListener> list = this.mAdapterChangeListeners;
        if (list != null) {
            list.remove(onAdapterChangeListener);
        }
    }

    public void removeOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        List<OnPageChangeListener> list = this.mOnPageChangeListeners;
        if (list != null) {
            list.remove(onPageChangeListener);
        }
    }

    public void removeView(View view) {
        if (this.mInLayout) {
            this.removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    public void setAdapter(PagerAdapter pagerAdapter) {
        List<OnAdapterChangeListener> list;
        int n2;
        Object object = this.mAdapter;
        int n3 = 0;
        if (object != null) {
            object.setViewPagerObserver(null);
            this.mAdapter.startUpdate((ViewGroup)this);
            for (n2 = 0; n2 < this.mItems.size(); ++n2) {
                object = this.mItems.get(n2);
                this.mAdapter.destroyItem((ViewGroup)this, object.position, object.object);
            }
            this.mAdapter.finishUpdate((ViewGroup)this);
            this.mItems.clear();
            this.removeNonDecorViews();
            this.mCurItem = 0;
            this.scrollTo(0, 0);
        }
        object = this.mAdapter;
        this.mAdapter = pagerAdapter;
        this.mExpectedAdapterCount = 0;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new PagerObserver();
            }
            this.mAdapter.setViewPagerObserver((DataSetObserver)this.mObserver);
            this.mPopulatePending = false;
            boolean bl = this.mFirstLayout;
            this.mFirstLayout = true;
            this.mExpectedAdapterCount = this.mAdapter.getCount();
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else if (!bl) {
                this.populate();
            } else {
                this.requestLayout();
            }
        }
        if ((list = this.mAdapterChangeListeners) != null && !list.isEmpty()) {
            int n4 = this.mAdapterChangeListeners.size();
            for (n2 = n3; n2 < n4; ++n2) {
                this.mAdapterChangeListeners.get(n2).onAdapterChanged(this, (PagerAdapter)object, pagerAdapter);
            }
        }
    }

    public void setCurrentItem(int n2) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n2, this.mFirstLayout ^ true, false);
    }

    public void setCurrentItem(int n2, boolean bl) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n2, bl, false);
    }

    void setCurrentItemInternal(int n2, boolean bl, boolean bl2) {
        this.setCurrentItemInternal(n2, bl, bl2, 0);
    }

    void setCurrentItemInternal(int n2, boolean bl, boolean bl2, int n3) {
        PagerAdapter pagerAdapter = this.mAdapter;
        if (pagerAdapter != null && pagerAdapter.getCount() > 0) {
            int n4;
            if (!bl2 && this.mCurItem == n2 && this.mItems.size() != 0) {
                this.setScrollingCacheEnabled(false);
                return;
            }
            bl2 = true;
            if (n2 < 0) {
                n4 = 0;
            } else {
                n4 = n2;
                if (n2 >= this.mAdapter.getCount()) {
                    n4 = this.mAdapter.getCount() - 1;
                }
            }
            int n5 = this.mOffscreenPageLimit;
            n2 = this.mCurItem;
            if (n4 > n2 + n5 || n4 < n2 - n5) {
                for (n2 = 0; n2 < this.mItems.size(); ++n2) {
                    this.mItems.get((int)n2).scrolling = true;
                }
            }
            if (this.mCurItem == n4) {
                bl2 = false;
            }
            if (this.mFirstLayout) {
                this.mCurItem = n4;
                if (bl2) {
                    this.dispatchOnPageSelected(n4);
                }
                this.requestLayout();
            } else {
                this.populate(n4);
                this.scrollToItem(n4, bl, n3, bl2);
            }
            return;
        }
        this.setScrollingCacheEnabled(false);
    }

    OnPageChangeListener setInternalPageChangeListener(OnPageChangeListener onPageChangeListener) {
        OnPageChangeListener onPageChangeListener2 = this.mInternalPageChangeListener;
        this.mInternalPageChangeListener = onPageChangeListener;
        return onPageChangeListener2;
    }

    public void setOffscreenPageLimit(int n2) {
        int n3 = n2;
        if (n2 < 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Requested offscreen page limit ");
            stringBuilder.append(n2);
            stringBuilder.append(" too small; defaulting to ");
            stringBuilder.append(1);
            Log.w((String)TAG, (String)stringBuilder.toString());
            n3 = 1;
        }
        if (n3 != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = n3;
            this.populate();
        }
    }

    @Deprecated
    public void setOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
    }

    public void setPageMargin(int n2) {
        int n3 = this.mPageMargin;
        this.mPageMargin = n2;
        int n4 = this.getWidth();
        this.recomputeScrollPosition(n4, n4, n2, n3);
        this.requestLayout();
    }

    public void setPageMarginDrawable(int n2) {
        this.setPageMarginDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)n2));
    }

    public void setPageMarginDrawable(Drawable drawable2) {
        this.mMarginDrawable = drawable2;
        if (drawable2 != null) {
            this.refreshDrawableState();
        }
        boolean bl = drawable2 == null;
        this.setWillNotDraw(bl);
        this.invalidate();
    }

    public void setPageTransformer(boolean bl, PageTransformer pageTransformer) {
        this.setPageTransformer(bl, pageTransformer, 2);
    }

    public void setPageTransformer(boolean bl, PageTransformer pageTransformer, int n2) {
        int n3 = 1;
        boolean bl2 = pageTransformer != null;
        boolean bl3 = this.mPageTransformer != null;
        boolean bl4 = bl2 != bl3;
        this.mPageTransformer = pageTransformer;
        this.setChildrenDrawingOrderEnabled(bl2);
        if (bl2) {
            if (bl) {
                n3 = 2;
            }
            this.mDrawingOrder = n3;
            this.mPageTransformerLayerType = n2;
        } else {
            this.mDrawingOrder = 0;
        }
        if (bl4) {
            this.populate();
        }
    }

    void setScrollState(int n2) {
        if (this.mScrollState == n2) {
            return;
        }
        this.mScrollState = n2;
        if (this.mPageTransformer != null) {
            boolean bl = n2 != 0;
            this.enableLayers(bl);
        }
        this.dispatchOnScrollStateChanged(n2);
    }

    void smoothScrollTo(int n2, int n3) {
        this.smoothScrollTo(n2, n3, 0);
    }

    void smoothScrollTo(int n2, int n3, int n4) {
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        Scroller scroller = this.mScroller;
        int n5 = scroller != null && !scroller.isFinished() ? 1 : 0;
        if (n5 != 0) {
            n5 = this.mIsScrollStarted ? this.mScroller.getCurrX() : this.mScroller.getStartX();
            this.mScroller.abortAnimation();
            this.setScrollingCacheEnabled(false);
        } else {
            n5 = this.getScrollX();
        }
        int n6 = this.getScrollY();
        int n7 = n2 - n5;
        if (n7 == 0 && (n3 -= n6) == 0) {
            this.completeScroll(false);
            this.populate();
            this.setScrollState(0);
            return;
        }
        this.setScrollingCacheEnabled(true);
        this.setScrollState(2);
        int n8 = this.getClientWidth();
        n2 = n8 / 2;
        float f2 = Math.abs(n7);
        float f3 = n8;
        float f4 = Math.min(1.0f, f2 * 1.0f / f3);
        f2 = n2;
        f4 = this.distanceInfluenceForSnapDuration(f4);
        n2 = Math.abs(n4);
        if (n2 > 0) {
            n2 = Math.round(Math.abs((f2 + f4 * f2) / (float)n2) * 1000.0f) * 4;
        } else {
            f2 = this.mAdapter.getPageWidth(this.mCurItem);
            n2 = (int)(((float)Math.abs(n7) / (f3 * f2 + (float)this.mPageMargin) + 1.0f) * 100.0f);
        }
        n2 = Math.min(n2, 600);
        this.mIsScrollStarted = false;
        this.mScroller.startScroll(n5, n6, n7, n3, n2);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        boolean bl = super.verifyDrawable(drawable2) || drawable2 == this.mMarginDrawable;
        return bl;
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface DecorView {
    }

    static class ItemInfo {
        Object object;
        float offset;
        int position;
        boolean scrolling;
        float widthFactor;

        ItemInfo() {
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        int childIndex;
        public int gravity;
        public boolean isDecor;
        boolean needsMeasure;
        int position;
        float widthFactor = 0.0f;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = context.obtainStyledAttributes(attributeSet, LAYOUT_ATTRS);
            this.gravity = context.getInteger(0, 48);
            context.recycle();
        }
    }

    class MyAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        MyAccessibilityDelegate() {
        }

        private boolean canScroll() {
            PagerAdapter pagerAdapter = ViewPager.this.mAdapter;
            boolean bl = true;
            if (pagerAdapter == null || ViewPager.this.mAdapter.getCount() <= 1) {
                bl = false;
            }
            return bl;
        }

        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            accessibilityEvent.setClassName((CharSequence)ViewPager.class.getName());
            accessibilityEvent.setScrollable(this.canScroll());
            if (accessibilityEvent.getEventType() == 4096 && ViewPager.this.mAdapter != null) {
                accessibilityEvent.setItemCount(ViewPager.this.mAdapter.getCount());
                accessibilityEvent.setFromIndex(ViewPager.this.mCurItem);
                accessibilityEvent.setToIndex(ViewPager.this.mCurItem);
            }
        }

        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
            accessibilityNodeInfoCompat.setClassName((CharSequence)ViewPager.class.getName());
            accessibilityNodeInfoCompat.setScrollable(this.canScroll());
            if (ViewPager.this.canScrollHorizontally(1)) {
                accessibilityNodeInfoCompat.addAction(4096);
            }
            if (ViewPager.this.canScrollHorizontally(-1)) {
                accessibilityNodeInfoCompat.addAction(8192);
            }
        }

        public boolean performAccessibilityAction(View object, int n2, Bundle bundle) {
            if (super.performAccessibilityAction((View)object, n2, bundle)) {
                return true;
            }
            if (n2 != 4096) {
                if (n2 != 8192) {
                    return false;
                }
                if (ViewPager.this.canScrollHorizontally(-1)) {
                    object = ViewPager.this;
                    ((ViewPager)((Object)object)).setCurrentItem(((ViewPager)((Object)object)).mCurItem - 1);
                    return true;
                }
                return false;
            }
            if (ViewPager.this.canScrollHorizontally(1)) {
                object = ViewPager.this;
                ((ViewPager)((Object)object)).setCurrentItem(((ViewPager)((Object)object)).mCurItem + 1);
                return true;
            }
            return false;
        }
    }

    public static interface OnAdapterChangeListener {
        public void onAdapterChanged(ViewPager var1, PagerAdapter var2, PagerAdapter var3);
    }

    public static interface OnPageChangeListener {
        public void onPageScrollStateChanged(int var1);

        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);
    }

    public static interface PageTransformer {
        public void transformPage(View var1, float var2);
    }

    private class PagerObserver
    extends DataSetObserver {
        PagerObserver() {
        }

        public void onChanged() {
            ViewPager.this.dataSetChanged();
        }

        public void onInvalidated() {
            ViewPager.this.dataSetChanged();
        }
    }

    public static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        Parcelable adapterState;
        ClassLoader loader;
        int position;

        SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            ClassLoader classLoader2 = classLoader;
            if (classLoader == null) {
                classLoader2 = ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.position = parcel.readInt();
            this.adapterState = parcel.readParcelable(classLoader2);
            this.loader = classLoader2;
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("FragmentPager.SavedState{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode((Object)this)));
            stringBuilder.append(" position=");
            stringBuilder.append(this.position);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeInt(this.position);
            parcel.writeParcelable(this.adapterState, n2);
        }
    }

    public static class SimpleOnPageChangeListener
    implements OnPageChangeListener {
        @Override
        public void onPageScrollStateChanged(int n2) {
        }

        @Override
        public void onPageScrolled(int n2, float f2, int n3) {
        }

        @Override
        public void onPageSelected(int n2) {
        }
    }

    static class ViewPositionComparator
    implements Comparator<View> {
        ViewPositionComparator() {
        }

        @Override
        public int compare(View object, View object2) {
            object = (LayoutParams)object.getLayoutParams();
            object2 = (LayoutParams)object2.getLayoutParams();
            if (object.isDecor != object2.isDecor) {
                int n2 = object.isDecor ? 1 : -1;
                return n2;
            }
            return object.position - object2.position;
        }
    }
}

