/*
 * Decompiled with CFR 0.152.
 */
package androidx.viewpager.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.core.widget.TextViewCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Locale;

@ViewPager.DecorView
public class PagerTitleStrip
extends ViewGroup {
    private static final int[] ATTRS = new int[]{16842804, 16842901, 16842904, 16842927};
    private static final float SIDE_ALPHA = 0.6f;
    private static final int[] TEXT_ATTRS = new int[]{16843660};
    private static final int TEXT_SPACING = 16;
    TextView mCurrText;
    private int mGravity;
    private int mLastKnownCurrentPage = -1;
    float mLastKnownPositionOffset = -1.0f;
    TextView mNextText;
    private int mNonPrimaryAlpha;
    private final PageListener mPageListener = new PageListener();
    ViewPager mPager;
    TextView mPrevText;
    private int mScaledTextSpacing;
    int mTextColor;
    private boolean mUpdatingPositions;
    private boolean mUpdatingText;
    private WeakReference<PagerAdapter> mWatchingAdapter;

    public PagerTitleStrip(Context context) {
        this(context, null);
    }

    public PagerTitleStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n2;
        TextView textView;
        this.mPrevText = textView = new TextView(context);
        this.addView((View)textView);
        this.mCurrText = textView = new TextView(context);
        this.addView((View)textView);
        this.mNextText = textView = new TextView(context);
        this.addView((View)textView);
        attributeSet = context.obtainStyledAttributes(attributeSet, ATTRS);
        boolean bl = false;
        int n3 = attributeSet.getResourceId(0, 0);
        if (n3 != 0) {
            TextViewCompat.setTextAppearance(this.mPrevText, n3);
            TextViewCompat.setTextAppearance(this.mCurrText, n3);
            TextViewCompat.setTextAppearance(this.mNextText, n3);
        }
        if ((n2 = attributeSet.getDimensionPixelSize(1, 0)) != 0) {
            this.setTextSize(0, n2);
        }
        if (attributeSet.hasValue(2)) {
            n2 = attributeSet.getColor(2, 0);
            this.mPrevText.setTextColor(n2);
            this.mCurrText.setTextColor(n2);
            this.mNextText.setTextColor(n2);
        }
        this.mGravity = attributeSet.getInteger(3, 80);
        attributeSet.recycle();
        this.mTextColor = this.mCurrText.getTextColors().getDefaultColor();
        this.setNonPrimaryAlpha(0.6f);
        this.mPrevText.setEllipsize(TextUtils.TruncateAt.END);
        this.mCurrText.setEllipsize(TextUtils.TruncateAt.END);
        this.mNextText.setEllipsize(TextUtils.TruncateAt.END);
        if (n3 != 0) {
            attributeSet = context.obtainStyledAttributes(n3, TEXT_ATTRS);
            bl = attributeSet.getBoolean(0, false);
            attributeSet.recycle();
        }
        if (bl) {
            PagerTitleStrip.setSingleLineAllCaps(this.mPrevText);
            PagerTitleStrip.setSingleLineAllCaps(this.mCurrText);
            PagerTitleStrip.setSingleLineAllCaps(this.mNextText);
        } else {
            this.mPrevText.setSingleLine();
            this.mCurrText.setSingleLine();
            this.mNextText.setSingleLine();
        }
        this.mScaledTextSpacing = (int)(context.getResources().getDisplayMetrics().density * 16.0f);
    }

    private static void setSingleLineAllCaps(TextView textView) {
        textView.setTransformationMethod((TransformationMethod)new SingleLineAllCapsTransform(textView.getContext()));
    }

    int getMinHeight() {
        Drawable drawable2 = this.getBackground();
        int n2 = drawable2 != null ? drawable2.getIntrinsicHeight() : 0;
        return n2;
    }

    public int getTextSpacing() {
        return this.mScaledTextSpacing;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Object object = this.getParent();
        if (object instanceof ViewPager) {
            object = (ViewPager)((Object)object);
            PagerAdapter pagerAdapter = ((ViewPager)((Object)object)).getAdapter();
            ((ViewPager)((Object)object)).setInternalPageChangeListener(this.mPageListener);
            ((ViewPager)((Object)object)).addOnAdapterChangeListener(this.mPageListener);
            this.mPager = object;
            object = this.mWatchingAdapter;
            object = object != null ? (PagerAdapter)((Reference)object).get() : null;
            this.updateAdapter((PagerAdapter)object, pagerAdapter);
            return;
        }
        throw new IllegalStateException("PagerTitleStrip must be a direct child of a ViewPager.");
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ViewPager viewPager = this.mPager;
        if (viewPager != null) {
            this.updateAdapter(viewPager.getAdapter(), null);
            this.mPager.setInternalPageChangeListener(null);
            this.mPager.removeOnAdapterChangeListener(this.mPageListener);
            this.mPager = null;
        }
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        if (this.mPager != null) {
            float f2 = this.mLastKnownPositionOffset;
            if (!(f2 >= 0.0f)) {
                f2 = 0.0f;
            }
            this.updateTextPositions(this.mLastKnownCurrentPage, f2, true);
        }
    }

    protected void onMeasure(int n2, int n3) {
        if (View.MeasureSpec.getMode((int)n2) == 0x40000000) {
            int n4 = this.getPaddingTop() + this.getPaddingBottom();
            int n5 = PagerTitleStrip.getChildMeasureSpec((int)n3, (int)n4, (int)-2);
            int n6 = View.MeasureSpec.getSize((int)n2);
            n2 = PagerTitleStrip.getChildMeasureSpec((int)n2, (int)((int)((float)n6 * 0.2f)), (int)-2);
            this.mPrevText.measure(n2, n5);
            this.mCurrText.measure(n2, n5);
            this.mNextText.measure(n2, n5);
            if (View.MeasureSpec.getMode((int)n3) == 0x40000000) {
                n2 = View.MeasureSpec.getSize((int)n3);
            } else {
                n2 = this.mCurrText.getMeasuredHeight();
                n2 = Math.max(this.getMinHeight(), n2 + n4);
            }
            this.setMeasuredDimension(n6, View.resolveSizeAndState((int)n2, (int)n3, (int)(this.mCurrText.getMeasuredState() << 16)));
            return;
        }
        throw new IllegalStateException("Must measure with an exact width");
    }

    public void requestLayout() {
        if (!this.mUpdatingText) {
            super.requestLayout();
        }
    }

    public void setGravity(int n2) {
        this.mGravity = n2;
        this.requestLayout();
    }

    public void setNonPrimaryAlpha(float f2) {
        this.mNonPrimaryAlpha = (int)(f2 * 255.0f) & 0xFF;
        int n2 = this.mNonPrimaryAlpha << 24 | this.mTextColor & 0xFFFFFF;
        this.mPrevText.setTextColor(n2);
        this.mNextText.setTextColor(n2);
    }

    public void setTextColor(int n2) {
        this.mTextColor = n2;
        this.mCurrText.setTextColor(n2);
        n2 = this.mNonPrimaryAlpha << 24 | this.mTextColor & 0xFFFFFF;
        this.mPrevText.setTextColor(n2);
        this.mNextText.setTextColor(n2);
    }

    public void setTextSize(int n2, float f2) {
        this.mPrevText.setTextSize(n2, f2);
        this.mCurrText.setTextSize(n2, f2);
        this.mNextText.setTextSize(n2, f2);
    }

    public void setTextSpacing(int n2) {
        this.mScaledTextSpacing = n2;
        this.requestLayout();
    }

    void updateAdapter(PagerAdapter object, PagerAdapter pagerAdapter) {
        if (object != null) {
            object.unregisterDataSetObserver((DataSetObserver)this.mPageListener);
            this.mWatchingAdapter = null;
        }
        if (pagerAdapter != null) {
            pagerAdapter.registerDataSetObserver((DataSetObserver)this.mPageListener);
            this.mWatchingAdapter = new WeakReference<PagerAdapter>(pagerAdapter);
        }
        if ((object = this.mPager) != null) {
            this.mLastKnownCurrentPage = -1;
            this.mLastKnownPositionOffset = -1.0f;
            this.updateText(((ViewPager)((Object)object)).getCurrentItem(), pagerAdapter);
            this.requestLayout();
        }
    }

    void updateText(int n2, PagerAdapter pagerAdapter) {
        int n3 = pagerAdapter != null ? pagerAdapter.getCount() : 0;
        this.mUpdatingText = true;
        Object var4_4 = null;
        CharSequence charSequence = n2 >= 1 && pagerAdapter != null ? pagerAdapter.getPageTitle(n2 - 1) : null;
        this.mPrevText.setText(charSequence);
        TextView textView = this.mCurrText;
        charSequence = pagerAdapter != null && n2 < n3 ? pagerAdapter.getPageTitle(n2) : null;
        textView.setText(charSequence);
        int n4 = n2 + 1;
        charSequence = var4_4;
        if (n4 < n3) {
            charSequence = var4_4;
            if (pagerAdapter != null) {
                charSequence = pagerAdapter.getPageTitle(n4);
            }
        }
        this.mNextText.setText(charSequence);
        n4 = View.MeasureSpec.makeMeasureSpec((int)Math.max(0, (int)((float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) * 0.8f)), (int)Integer.MIN_VALUE);
        n3 = View.MeasureSpec.makeMeasureSpec((int)Math.max(0, this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)Integer.MIN_VALUE);
        this.mPrevText.measure(n4, n3);
        this.mCurrText.measure(n4, n3);
        this.mNextText.measure(n4, n3);
        this.mLastKnownCurrentPage = n2;
        if (!this.mUpdatingPositions) {
            this.updateTextPositions(n2, this.mLastKnownPositionOffset, false);
        }
        this.mUpdatingText = false;
    }

    void updateTextPositions(int n2, float f2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        block6: {
            int n12;
            int n13;
            block7: {
                int n14;
                int n15;
                block4: {
                    block5: {
                        float f3;
                        if (n2 != this.mLastKnownCurrentPage) {
                            this.updateText(n2, this.mPager.getAdapter());
                        } else if (!bl && f2 == this.mLastKnownPositionOffset) {
                            return;
                        }
                        this.mUpdatingPositions = true;
                        n11 = this.mPrevText.getMeasuredWidth();
                        n10 = this.mCurrText.getMeasuredWidth();
                        n9 = this.mNextText.getMeasuredWidth();
                        n8 = n10 / 2;
                        n7 = this.getWidth();
                        n15 = this.getHeight();
                        n6 = this.getPaddingLeft();
                        n5 = this.getPaddingRight();
                        n2 = this.getPaddingTop();
                        n4 = this.getPaddingBottom();
                        n3 = n5 + n8;
                        float f4 = f3 = 0.5f + f2;
                        if (f3 > 1.0f) {
                            f4 = f3 - 1.0f;
                        }
                        n3 = n7 - n3 - (int)((float)(n7 - (n6 + n8) - n3) * f4) - n8;
                        n8 = n10 + n3;
                        n13 = this.mPrevText.getBaseline();
                        n10 = this.mCurrText.getBaseline();
                        n12 = this.mNextText.getBaseline();
                        int n16 = Math.max(Math.max(n13, n10), n12);
                        n13 = n16 - n13;
                        n10 = n16 - n10;
                        n12 = n16 - n12;
                        n16 = this.mPrevText.getMeasuredHeight();
                        int n17 = this.mCurrText.getMeasuredHeight();
                        n14 = this.mNextText.getMeasuredHeight();
                        n14 = Math.max(Math.max(n16 + n13, n17 + n10), n14 + n12);
                        n16 = this.mGravity & 0x70;
                        if (n16 == 16) break block4;
                        if (n16 == 80) break block5;
                        n4 = n13 + n2;
                        n10 += n2;
                        n2 += n12;
                        break block6;
                    }
                    n2 = n15 - n4 - n14;
                    break block7;
                }
                n2 = (n15 - n2 - n4 - n14) / 2;
            }
            n4 = n13 + n2;
            n10 += n2;
            n2 += n12;
        }
        TextView textView = this.mCurrText;
        textView.layout(n3, n10, n8, textView.getMeasuredHeight() + n10);
        n10 = Math.min(n6, n3 - this.mScaledTextSpacing - n11);
        textView = this.mPrevText;
        textView.layout(n10, n4, n11 + n10, textView.getMeasuredHeight() + n4);
        n4 = Math.max(n7 - n5 - n9, n8 + this.mScaledTextSpacing);
        textView = this.mNextText;
        textView.layout(n4, n2, n4 + n9, textView.getMeasuredHeight() + n2);
        this.mLastKnownPositionOffset = f2;
        this.mUpdatingPositions = false;
    }

    private class PageListener
    extends DataSetObserver
    implements ViewPager.OnPageChangeListener,
    ViewPager.OnAdapterChangeListener {
        private int mScrollState;

        PageListener() {
        }

        @Override
        public void onAdapterChanged(ViewPager viewPager, PagerAdapter pagerAdapter, PagerAdapter pagerAdapter2) {
            PagerTitleStrip.this.updateAdapter(pagerAdapter, pagerAdapter2);
        }

        public void onChanged() {
            PagerTitleStrip pagerTitleStrip = PagerTitleStrip.this;
            pagerTitleStrip.updateText(pagerTitleStrip.mPager.getCurrentItem(), PagerTitleStrip.this.mPager.getAdapter());
            float f2 = PagerTitleStrip.this.mLastKnownPositionOffset;
            float f3 = 0.0f;
            if (f2 >= 0.0f) {
                f3 = PagerTitleStrip.this.mLastKnownPositionOffset;
            }
            pagerTitleStrip = PagerTitleStrip.this;
            pagerTitleStrip.updateTextPositions(pagerTitleStrip.mPager.getCurrentItem(), f3, true);
        }

        @Override
        public void onPageScrollStateChanged(int n2) {
            this.mScrollState = n2;
        }

        @Override
        public void onPageScrolled(int n2, float f2, int n3) {
            n3 = n2;
            if (f2 > 0.5f) {
                n3 = n2 + 1;
            }
            PagerTitleStrip.this.updateTextPositions(n3, f2, false);
        }

        @Override
        public void onPageSelected(int n2) {
            if (this.mScrollState == 0) {
                PagerTitleStrip pagerTitleStrip = PagerTitleStrip.this;
                pagerTitleStrip.updateText(pagerTitleStrip.mPager.getCurrentItem(), PagerTitleStrip.this.mPager.getAdapter());
                float f2 = PagerTitleStrip.this.mLastKnownPositionOffset;
                float f3 = 0.0f;
                if (f2 >= 0.0f) {
                    f3 = PagerTitleStrip.this.mLastKnownPositionOffset;
                }
                pagerTitleStrip = PagerTitleStrip.this;
                pagerTitleStrip.updateTextPositions(pagerTitleStrip.mPager.getCurrentItem(), f3, true);
            }
        }
    }

    private static class SingleLineAllCapsTransform
    extends SingleLineTransformationMethod {
        private Locale mLocale;

        SingleLineAllCapsTransform(Context context) {
            this.mLocale = context.getResources().getConfiguration().locale;
        }

        public CharSequence getTransformation(CharSequence charSequence, View view) {
            charSequence = (charSequence = super.getTransformation(charSequence, view)) != null ? charSequence.toString().toUpperCase(this.mLocale) : null;
            return charSequence;
        }
    }
}

