/*
 * Decompiled with CFR 0.152.
 */
package androidx.swiperefreshlayout.widget;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.core.util.Preconditions;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CircularProgressDrawable
extends Drawable
implements Animatable {
    private static final int ANIMATION_DURATION = 1332;
    private static final int ARROW_HEIGHT = 5;
    private static final int ARROW_HEIGHT_LARGE = 6;
    private static final int ARROW_WIDTH = 10;
    private static final int ARROW_WIDTH_LARGE = 12;
    private static final float CENTER_RADIUS = 7.5f;
    private static final float CENTER_RADIUS_LARGE = 11.0f;
    private static final int[] COLORS;
    private static final float COLOR_CHANGE_OFFSET = 0.75f;
    public static final int DEFAULT = 1;
    private static final float GROUP_FULL_ROTATION = 216.0f;
    public static final int LARGE = 0;
    private static final Interpolator LINEAR_INTERPOLATOR;
    private static final Interpolator MATERIAL_INTERPOLATOR;
    private static final float MAX_PROGRESS_ARC = 0.8f;
    private static final float MIN_PROGRESS_ARC = 0.01f;
    private static final float RING_ROTATION = 0.20999998f;
    private static final float SHRINK_OFFSET = 0.5f;
    private static final float STROKE_WIDTH = 2.5f;
    private static final float STROKE_WIDTH_LARGE = 3.0f;
    private Animator mAnimator;
    boolean mFinishing;
    private Resources mResources;
    private final Ring mRing;
    private float mRotation;
    float mRotationCount;

    static {
        LINEAR_INTERPOLATOR = new LinearInterpolator();
        MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
        COLORS = new int[]{-16777216};
    }

    public CircularProgressDrawable(Context context) {
        this.mResources = ((Context)Preconditions.checkNotNull((Object)context)).getResources();
        this.mRing = new Ring();
        this.mRing.setColors(COLORS);
        this.setStrokeWidth(2.5f);
        this.setupAnimators();
    }

    private void applyFinishTranslation(float f2, Ring ring) {
        this.updateRingColor(f2, ring);
        float f3 = (float)(Math.floor(ring.getStartingRotation() / 0.8f) + 1.0);
        ring.setStartTrim(ring.getStartingStartTrim() + (ring.getStartingEndTrim() - 0.01f - ring.getStartingStartTrim()) * f2);
        ring.setEndTrim(ring.getStartingEndTrim());
        ring.setRotation(ring.getStartingRotation() + (f3 - ring.getStartingRotation()) * f2);
    }

    private int evaluateColorChange(float f2, int n2, int n3) {
        int n4 = n2 >> 24 & 0xFF;
        int n5 = n2 >> 16 & 0xFF;
        int n6 = n2 >> 8 & 0xFF;
        return n4 + (int)((float)((n3 >> 24 & 0xFF) - n4) * f2) << 24 | n5 + (int)((float)((n3 >> 16 & 0xFF) - n5) * f2) << 16 | n6 + (int)((float)((n3 >> 8 & 0xFF) - n6) * f2) << 8 | (n2 &= 0xFF) + (int)(f2 * (float)((n3 & 0xFF) - n2));
    }

    private float getRotation() {
        return this.mRotation;
    }

    private void setRotation(float f2) {
        this.mRotation = f2;
    }

    private void setSizeParameters(float f2, float f3, float f4, float f5) {
        Ring ring = this.mRing;
        float f6 = this.mResources.getDisplayMetrics().density;
        ring.setStrokeWidth(f3 * f6);
        ring.setCenterRadius(f2 * f6);
        ring.setColorIndex(0);
        ring.setArrowDimensions(f4 * f6, f5 * f6);
    }

    private void setupAnimators() {
        final Ring ring = this.mRing;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f2 = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                CircularProgressDrawable.this.updateRingColor(f2, ring);
                CircularProgressDrawable.this.applyTransformation(f2, ring, false);
                CircularProgressDrawable.this.invalidateSelf();
            }
        });
        valueAnimator.setRepeatCount(-1);
        valueAnimator.setRepeatMode(1);
        valueAnimator.setInterpolator((TimeInterpolator)LINEAR_INTERPOLATOR);
        valueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
            }

            public void onAnimationRepeat(Animator object) {
                CircularProgressDrawable.this.applyTransformation(1.0f, ring, true);
                ring.storeOriginals();
                ring.goToNextColor();
                if (CircularProgressDrawable.this.mFinishing) {
                    CircularProgressDrawable.this.mFinishing = false;
                    object.cancel();
                    object.setDuration(1332L);
                    object.start();
                    ring.setShowArrow(false);
                } else {
                    object = CircularProgressDrawable.this;
                    object.mRotationCount += 1.0f;
                }
            }

            public void onAnimationStart(Animator animator) {
                CircularProgressDrawable.this.mRotationCount = 0.0f;
            }
        });
        this.mAnimator = valueAnimator;
    }

    void applyTransformation(float f2, Ring ring, boolean bl) {
        if (this.mFinishing) {
            this.applyFinishTranslation(f2, ring);
        } else if (f2 != 1.0f || bl) {
            float f3;
            float f4;
            float f5 = ring.getStartingRotation();
            if (f2 < 0.5f) {
                f4 = f2 / 0.5f;
                f3 = ring.getStartingStartTrim();
                f4 = MATERIAL_INTERPOLATOR.getInterpolation(f4) * 0.79f + 0.01f + f3;
            } else {
                f3 = (f2 - 0.5f) / 0.5f;
                f4 = ring.getStartingStartTrim() + 0.79f;
                f3 = f4 - ((1.0f - MATERIAL_INTERPOLATOR.getInterpolation(f3)) * 0.79f + 0.01f);
            }
            float f6 = this.mRotationCount;
            ring.setStartTrim(f3);
            ring.setEndTrim(f4);
            ring.setRotation(f5 + 0.20999998f * f2);
            this.setRotation((f2 + f6) * 216.0f);
        }
    }

    public void draw(Canvas canvas) {
        Rect rect = this.getBounds();
        canvas.save();
        canvas.rotate(this.mRotation, rect.exactCenterX(), rect.exactCenterY());
        this.mRing.draw(canvas, rect);
        canvas.restore();
    }

    public int getAlpha() {
        return this.mRing.getAlpha();
    }

    public boolean getArrowEnabled() {
        return this.mRing.getShowArrow();
    }

    public float getArrowHeight() {
        return this.mRing.getArrowHeight();
    }

    public float getArrowScale() {
        return this.mRing.getArrowScale();
    }

    public float getArrowWidth() {
        return this.mRing.getArrowWidth();
    }

    public int getBackgroundColor() {
        return this.mRing.getBackgroundColor();
    }

    public float getCenterRadius() {
        return this.mRing.getCenterRadius();
    }

    public int[] getColorSchemeColors() {
        return this.mRing.getColors();
    }

    public float getEndTrim() {
        return this.mRing.getEndTrim();
    }

    public int getOpacity() {
        return -3;
    }

    public float getProgressRotation() {
        return this.mRing.getRotation();
    }

    public float getStartTrim() {
        return this.mRing.getStartTrim();
    }

    public Paint.Cap getStrokeCap() {
        return this.mRing.getStrokeCap();
    }

    public float getStrokeWidth() {
        return this.mRing.getStrokeWidth();
    }

    public boolean isRunning() {
        return this.mAnimator.isRunning();
    }

    public void setAlpha(int n2) {
        this.mRing.setAlpha(n2);
        this.invalidateSelf();
    }

    public void setArrowDimensions(float f2, float f3) {
        this.mRing.setArrowDimensions(f2, f3);
        this.invalidateSelf();
    }

    public void setArrowEnabled(boolean bl) {
        this.mRing.setShowArrow(bl);
        this.invalidateSelf();
    }

    public void setArrowScale(float f2) {
        this.mRing.setArrowScale(f2);
        this.invalidateSelf();
    }

    public void setBackgroundColor(int n2) {
        this.mRing.setBackgroundColor(n2);
        this.invalidateSelf();
    }

    public void setCenterRadius(float f2) {
        this.mRing.setCenterRadius(f2);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mRing.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public void setColorSchemeColors(int ... nArray) {
        this.mRing.setColors(nArray);
        this.mRing.setColorIndex(0);
        this.invalidateSelf();
    }

    public void setProgressRotation(float f2) {
        this.mRing.setRotation(f2);
        this.invalidateSelf();
    }

    public void setStartEndTrim(float f2, float f3) {
        this.mRing.setStartTrim(f2);
        this.mRing.setEndTrim(f3);
        this.invalidateSelf();
    }

    public void setStrokeCap(Paint.Cap cap) {
        this.mRing.setStrokeCap(cap);
        this.invalidateSelf();
    }

    public void setStrokeWidth(float f2) {
        this.mRing.setStrokeWidth(f2);
        this.invalidateSelf();
    }

    public void setStyle(int n2) {
        if (n2 == 0) {
            this.setSizeParameters(11.0f, 3.0f, 12.0f, 6.0f);
        } else {
            this.setSizeParameters(7.5f, 2.5f, 10.0f, 5.0f);
        }
        this.invalidateSelf();
    }

    public void start() {
        this.mAnimator.cancel();
        this.mRing.storeOriginals();
        if (this.mRing.getEndTrim() != this.mRing.getStartTrim()) {
            this.mFinishing = true;
            this.mAnimator.setDuration(666L);
            this.mAnimator.start();
        } else {
            this.mRing.setColorIndex(0);
            this.mRing.resetOriginals();
            this.mAnimator.setDuration(1332L);
            this.mAnimator.start();
        }
    }

    public void stop() {
        this.mAnimator.cancel();
        this.setRotation(0.0f);
        this.mRing.setShowArrow(false);
        this.mRing.setColorIndex(0);
        this.mRing.resetOriginals();
        this.invalidateSelf();
    }

    void updateRingColor(float f2, Ring ring) {
        if (f2 > 0.75f) {
            ring.setColor(this.evaluateColorChange((f2 - 0.75f) / 0.25f, ring.getStartingColor(), ring.getNextColor()));
        } else {
            ring.setColor(ring.getStartingColor());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProgressDrawableSize {
    }

    private static class Ring {
        int mAlpha = 255;
        Path mArrow;
        int mArrowHeight;
        final Paint mArrowPaint;
        float mArrowScale = 1.0f;
        int mArrowWidth;
        final Paint mCirclePaint;
        int mColorIndex;
        int[] mColors;
        int mCurrentColor;
        float mEndTrim = 0.0f;
        final Paint mPaint;
        float mRingCenterRadius;
        float mRotation = 0.0f;
        boolean mShowArrow;
        float mStartTrim = 0.0f;
        float mStartingEndTrim;
        float mStartingRotation;
        float mStartingStartTrim;
        float mStrokeWidth = 5.0f;
        final RectF mTempBounds = new RectF();

        Ring() {
            this.mPaint = new Paint();
            this.mArrowPaint = new Paint();
            this.mCirclePaint = new Paint();
            this.mPaint.setStrokeCap(Paint.Cap.SQUARE);
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mArrowPaint.setStyle(Paint.Style.FILL);
            this.mArrowPaint.setAntiAlias(true);
            this.mCirclePaint.setColor(0);
        }

        void draw(Canvas canvas, Rect rect) {
            RectF rectF = this.mTempBounds;
            float f2 = this.mRingCenterRadius;
            float f3 = this.mStrokeWidth / 2.0f + f2;
            if (f2 <= 0.0f) {
                f3 = (float)Math.min(rect.width(), rect.height()) / 2.0f - Math.max((float)this.mArrowWidth * this.mArrowScale / 2.0f, this.mStrokeWidth / 2.0f);
            }
            rectF.set((float)rect.centerX() - f3, (float)rect.centerY() - f3, (float)rect.centerX() + f3, (float)rect.centerY() + f3);
            f3 = this.mStartTrim;
            f2 = this.mRotation;
            f3 = (f3 + f2) * 360.0f;
            f2 = (this.mEndTrim + f2) * 360.0f - f3;
            this.mPaint.setColor(this.mCurrentColor);
            this.mPaint.setAlpha(this.mAlpha);
            float f4 = this.mStrokeWidth / 2.0f;
            rectF.inset(f4, f4);
            canvas.drawCircle(rectF.centerX(), rectF.centerY(), rectF.width() / 2.0f, this.mCirclePaint);
            f4 = -f4;
            rectF.inset(f4, f4);
            canvas.drawArc(rectF, f3, f2, false, this.mPaint);
            this.drawTriangle(canvas, f3, f2, rectF);
        }

        void drawTriangle(Canvas canvas, float f2, float f3, RectF rectF) {
            if (this.mShowArrow) {
                Path path = this.mArrow;
                if (path == null) {
                    this.mArrow = new Path();
                    this.mArrow.setFillType(Path.FillType.EVEN_ODD);
                } else {
                    path.reset();
                }
                float f4 = Math.min(rectF.width(), rectF.height()) / 2.0f;
                float f5 = (float)this.mArrowWidth * this.mArrowScale / 2.0f;
                this.mArrow.moveTo(0.0f, 0.0f);
                this.mArrow.lineTo((float)this.mArrowWidth * this.mArrowScale, 0.0f);
                path = this.mArrow;
                float f6 = this.mArrowWidth;
                float f7 = this.mArrowScale;
                path.lineTo(f6 * f7 / 2.0f, (float)this.mArrowHeight * f7);
                this.mArrow.offset(f4 + rectF.centerX() - f5, rectF.centerY() + this.mStrokeWidth / 2.0f);
                this.mArrow.close();
                this.mArrowPaint.setColor(this.mCurrentColor);
                this.mArrowPaint.setAlpha(this.mAlpha);
                canvas.save();
                canvas.rotate(f2 + f3, rectF.centerX(), rectF.centerY());
                canvas.drawPath(this.mArrow, this.mArrowPaint);
                canvas.restore();
            }
        }

        int getAlpha() {
            return this.mAlpha;
        }

        float getArrowHeight() {
            return this.mArrowHeight;
        }

        float getArrowScale() {
            return this.mArrowScale;
        }

        float getArrowWidth() {
            return this.mArrowWidth;
        }

        int getBackgroundColor() {
            return this.mCirclePaint.getColor();
        }

        float getCenterRadius() {
            return this.mRingCenterRadius;
        }

        int[] getColors() {
            return this.mColors;
        }

        float getEndTrim() {
            return this.mEndTrim;
        }

        int getNextColor() {
            return this.mColors[this.getNextColorIndex()];
        }

        int getNextColorIndex() {
            return (this.mColorIndex + 1) % this.mColors.length;
        }

        float getRotation() {
            return this.mRotation;
        }

        boolean getShowArrow() {
            return this.mShowArrow;
        }

        float getStartTrim() {
            return this.mStartTrim;
        }

        int getStartingColor() {
            return this.mColors[this.mColorIndex];
        }

        float getStartingEndTrim() {
            return this.mStartingEndTrim;
        }

        float getStartingRotation() {
            return this.mStartingRotation;
        }

        float getStartingStartTrim() {
            return this.mStartingStartTrim;
        }

        Paint.Cap getStrokeCap() {
            return this.mPaint.getStrokeCap();
        }

        float getStrokeWidth() {
            return this.mStrokeWidth;
        }

        void goToNextColor() {
            this.setColorIndex(this.getNextColorIndex());
        }

        void resetOriginals() {
            this.mStartingStartTrim = 0.0f;
            this.mStartingEndTrim = 0.0f;
            this.mStartingRotation = 0.0f;
            this.setStartTrim(0.0f);
            this.setEndTrim(0.0f);
            this.setRotation(0.0f);
        }

        void setAlpha(int n2) {
            this.mAlpha = n2;
        }

        void setArrowDimensions(float f2, float f3) {
            this.mArrowWidth = (int)f2;
            this.mArrowHeight = (int)f3;
        }

        void setArrowScale(float f2) {
            if (f2 != this.mArrowScale) {
                this.mArrowScale = f2;
            }
        }

        void setBackgroundColor(int n2) {
            this.mCirclePaint.setColor(n2);
        }

        void setCenterRadius(float f2) {
            this.mRingCenterRadius = f2;
        }

        void setColor(int n2) {
            this.mCurrentColor = n2;
        }

        void setColorFilter(ColorFilter colorFilter) {
            this.mPaint.setColorFilter(colorFilter);
        }

        void setColorIndex(int n2) {
            this.mColorIndex = n2;
            this.mCurrentColor = this.mColors[this.mColorIndex];
        }

        void setColors(int[] nArray) {
            this.mColors = nArray;
            this.setColorIndex(0);
        }

        void setEndTrim(float f2) {
            this.mEndTrim = f2;
        }

        void setRotation(float f2) {
            this.mRotation = f2;
        }

        void setShowArrow(boolean bl) {
            if (this.mShowArrow != bl) {
                this.mShowArrow = bl;
            }
        }

        void setStartTrim(float f2) {
            this.mStartTrim = f2;
        }

        void setStrokeCap(Paint.Cap cap) {
            this.mPaint.setStrokeCap(cap);
        }

        void setStrokeWidth(float f2) {
            this.mStrokeWidth = f2;
            this.mPaint.setStrokeWidth(f2);
        }

        void storeOriginals() {
            this.mStartingStartTrim = this.mStartTrim;
            this.mStartingEndTrim = this.mEndTrim;
            this.mStartingRotation = this.mRotation;
        }
    }
}

