/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import androidx.sqlite.db.SupportSQLiteDatabase;
import java.io.File;
import java.io.IOException;
import java.util.List;

public interface SupportSQLiteOpenHelper {
    public void close();

    public String getDatabaseName();

    public SupportSQLiteDatabase getReadableDatabase();

    public SupportSQLiteDatabase getWritableDatabase();

    public void setWriteAheadLoggingEnabled(boolean var1);

    public static abstract class Callback {
        private static final String TAG = "SupportSQLite";
        public final int version;

        public Callback(int n2) {
            this.version = n2;
        }

        private void deleteDatabaseFile(String string2) {
            if (!string2.equalsIgnoreCase(":memory:") && string2.trim().length() != 0) {
                Comparable<StringBuilder> comparable;
                block7: {
                    comparable = new StringBuilder();
                    ((StringBuilder)comparable).append("deleting the database file: ");
                    ((StringBuilder)comparable).append(string2);
                    Log.w((String)TAG, (String)((StringBuilder)comparable).toString());
                    if (Build.VERSION.SDK_INT < 16) break block7;
                    comparable = new Comparable<StringBuilder>(string2);
                    SQLiteDatabase.deleteDatabase((File)comparable);
                }
                try {
                    comparable = new Comparable<StringBuilder>(string2);
                    if (!((File)comparable).delete()) {
                        comparable = new Comparable<StringBuilder>();
                        ((StringBuilder)comparable).append("Could not delete the database file ");
                        ((StringBuilder)comparable).append(string2);
                        Log.e((String)TAG, (String)((StringBuilder)comparable).toString());
                    }
                }
                catch (Exception exception) {
                    try {
                        Log.e((String)TAG, (String)"error while deleting corrupted database file", (Throwable)exception);
                    }
                    catch (Exception exception2) {
                        Log.w((String)TAG, (String)"delete failed: ", (Throwable)exception2);
                    }
                }
            }
        }

        public void onConfigure(SupportSQLiteDatabase supportSQLiteDatabase) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onCorruption(SupportSQLiteDatabase object) {
            StringBuilder stringBuilder;
            Object object2;
            block13: {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Corruption reported by sqlite on database: ");
                ((StringBuilder)object2).append(object.getPath());
                Log.e((String)TAG, (String)((StringBuilder)object2).toString());
                if (!object.isOpen()) {
                    this.deleteDatabaseFile(object.getPath());
                    return;
                }
                object2 = null;
                stringBuilder = null;
                try {
                    try {
                        List list = object.getAttachedDbs();
                        object2 = list;
                    }
                    catch (SQLiteException sQLiteException) {}
                    break block13;
                }
                catch (Throwable throwable) {}
                if (stringBuilder != null) {
                    object = stringBuilder.iterator();
                    while (object.hasNext()) {
                        this.deleteDatabaseFile((String)((Pair)object.next()).second);
                    }
                    throw throwable;
                } else {
                    this.deleteDatabaseFile(object.getPath());
                }
                throw throwable;
            }
            stringBuilder = object2;
            try {
                object.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (object2 != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    this.deleteDatabaseFile((String)((Pair)object.next()).second);
                }
                return;
            } else {
                this.deleteDatabaseFile(object.getPath());
            }
        }

        public abstract void onCreate(SupportSQLiteDatabase var1);

        public void onDowngrade(SupportSQLiteDatabase object, int n2, int n3) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Can't downgrade database from version ");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(" to ");
            ((StringBuilder)object).append(n3);
            throw new SQLiteException(((StringBuilder)object).toString());
        }

        public void onOpen(SupportSQLiteDatabase supportSQLiteDatabase) {
        }

        public abstract void onUpgrade(SupportSQLiteDatabase var1, int var2, int var3);
    }

    public static class Configuration {
        public final Callback callback;
        public final Context context;
        public final String name;

        Configuration(Context context, String string2, Callback callback2) {
            this.context = context;
            this.name = string2;
            this.callback = callback2;
        }

        public static Builder builder(Context context) {
            return new Builder(context);
        }

        public static class Builder {
            Callback mCallback;
            Context mContext;
            String mName;

            Builder(Context context) {
                this.mContext = context;
            }

            public Configuration build() {
                Callback callback2 = this.mCallback;
                if (callback2 != null) {
                    Context context = this.mContext;
                    if (context != null) {
                        return new Configuration(context, this.mName, callback2);
                    }
                    throw new IllegalArgumentException("Must set a non-null context to create the configuration.");
                }
                throw new IllegalArgumentException("Must set a callback to create the configuration.");
            }

            public Builder callback(Callback callback2) {
                this.mCallback = callback2;
                return this;
            }

            public Builder name(String string2) {
                this.mName = string2;
                return this;
            }
        }
    }

    public static interface Factory {
        public SupportSQLiteOpenHelper create(Configuration var1);
    }
}

