/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.paging;

import android.database.Cursor;
import androidx.paging.PositionalDataSource;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class LimitOffsetDataSource<T>
extends PositionalDataSource<T> {
    private final String mCountQuery;
    private final RoomDatabase mDb;
    private final boolean mInTransaction;
    private final String mLimitOffsetQuery;
    private final InvalidationTracker.Observer mObserver;
    private final RoomSQLiteQuery mSourceQuery;

    protected LimitOffsetDataSource(RoomDatabase roomDatabase, RoomSQLiteQuery object, boolean bl, String ... stringArray) {
        this.mDb = roomDatabase;
        this.mSourceQuery = object;
        this.mInTransaction = bl;
        object = new StringBuilder();
        ((StringBuilder)object).append("SELECT COUNT(*) FROM ( ");
        ((StringBuilder)object).append(this.mSourceQuery.getSql());
        ((StringBuilder)object).append(" )");
        this.mCountQuery = ((StringBuilder)object).toString();
        object = new StringBuilder();
        ((StringBuilder)object).append("SELECT * FROM ( ");
        ((StringBuilder)object).append(this.mSourceQuery.getSql());
        ((StringBuilder)object).append(" ) LIMIT ? OFFSET ?");
        this.mLimitOffsetQuery = ((StringBuilder)object).toString();
        this.mObserver = new InvalidationTracker.Observer(stringArray){

            public void onInvalidated(Set<String> set) {
                LimitOffsetDataSource.this.invalidate();
            }
        };
        roomDatabase.getInvalidationTracker().addWeakObserver(this.mObserver);
    }

    protected LimitOffsetDataSource(RoomDatabase roomDatabase, SupportSQLiteQuery supportSQLiteQuery, boolean bl, String ... stringArray) {
        this(roomDatabase, RoomSQLiteQuery.copyFrom((SupportSQLiteQuery)supportSQLiteQuery), bl, stringArray);
    }

    private RoomSQLiteQuery getSQLiteQuery(int n2, int n3) {
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)this.mLimitOffsetQuery, (int)(this.mSourceQuery.getArgCount() + 2));
        roomSQLiteQuery.copyArgumentsFrom(this.mSourceQuery);
        roomSQLiteQuery.bindLong(roomSQLiteQuery.getArgCount() - 1, (long)n3);
        roomSQLiteQuery.bindLong(roomSQLiteQuery.getArgCount(), (long)n2);
        return roomSQLiteQuery;
    }

    protected abstract List<T> convertRows(Cursor var1);

    public int countItems() {
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)this.mCountQuery, (int)this.mSourceQuery.getArgCount());
        roomSQLiteQuery.copyArgumentsFrom(this.mSourceQuery);
        Cursor cursor = this.mDb.query((SupportSQLiteQuery)roomSQLiteQuery);
        try {
            if (cursor.moveToFirst()) {
                int n2 = cursor.getInt(0);
                return n2;
            }
            return 0;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    public boolean isInvalid() {
        this.mDb.getInvalidationTracker().refreshVersionsSync();
        return super.isInvalid();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadInitial(PositionalDataSource.LoadInitialParams object, PositionalDataSource.LoadInitialCallback<T> loadInitialCallback) {
        void var2_5;
        RoomSQLiteQuery roomSQLiteQuery;
        block9: {
            int n2;
            int n3;
            Cursor cursor;
            block10: {
                Object object2;
                block8: {
                    roomSQLiteQuery = Collections.emptyList();
                    this.mDb.beginTransaction();
                    object2 = null;
                    cursor = null;
                    Object var6_9 = null;
                    try {
                        n3 = this.countItems();
                        if (n3 == 0) break block8;
                        n2 = LimitOffsetDataSource.computeInitialLoadPosition((PositionalDataSource.LoadInitialParams)object, (int)n3);
                        roomSQLiteQuery = this.getSQLiteQuery(n2, LimitOffsetDataSource.computeInitialLoadSize((PositionalDataSource.LoadInitialParams)object, (int)n2, (int)n3));
                        object = var6_9;
                    }
                    catch (Throwable throwable) {
                        roomSQLiteQuery = null;
                        object = cursor;
                        break block9;
                    }
                    try {
                        cursor = this.mDb.query((SupportSQLiteQuery)roomSQLiteQuery);
                        object = cursor;
                        object2 = this.convertRows(cursor);
                        object = cursor;
                        this.mDb.setTransactionSuccessful();
                        object = object2;
                        break block10;
                    }
                    catch (Throwable throwable) {
                        break block9;
                    }
                }
                object = roomSQLiteQuery;
                roomSQLiteQuery = null;
                n2 = 0;
                cursor = object2;
            }
            if (cursor != null) {
                cursor.close();
            }
            this.mDb.endTransaction();
            if (roomSQLiteQuery != null) {
                roomSQLiteQuery.release();
            }
            loadInitialCallback.onResult((List)object, n2, n3);
            return;
        }
        if (object != null) {
            object.close();
        }
        this.mDb.endTransaction();
        if (roomSQLiteQuery != null) {
            roomSQLiteQuery.release();
        }
        throw var2_5;
    }

    public List<T> loadRange(int n2, int n3) {
        RoomSQLiteQuery roomSQLiteQuery = this.getSQLiteQuery(n2, n3);
        if (this.mInTransaction) {
            List<T> list;
            block9: {
                Cursor cursor;
                this.mDb.beginTransaction();
                Cursor cursor2 = null;
                try {
                    cursor2 = cursor = this.mDb.query((SupportSQLiteQuery)roomSQLiteQuery);
                }
                catch (Throwable throwable) {
                    if (cursor2 != null) {
                        cursor2.close();
                    }
                    this.mDb.endTransaction();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                list = this.convertRows(cursor);
                cursor2 = cursor;
                this.mDb.setTransactionSuccessful();
                if (cursor == null) break block9;
                cursor.close();
            }
            this.mDb.endTransaction();
            roomSQLiteQuery.release();
            return list;
        }
        Cursor cursor = this.mDb.query((SupportSQLiteQuery)roomSQLiteQuery);
        try {
            List<T> list = this.convertRows(cursor);
            return list;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    public void loadRange(PositionalDataSource.LoadRangeParams loadRangeParams, PositionalDataSource.LoadRangeCallback<T> loadRangeCallback) {
        loadRangeCallback.onResult(this.loadRange(loadRangeParams.startPosition, loadRangeParams.loadSize));
    }
}

