/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.app.ActivityManager;
import android.content.Context;
import android.database.Cursor;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.collection.SparseArrayCompat;
import androidx.core.app.ActivityManagerCompat;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.Room;
import androidx.room.TransactionExecutor;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class RoomDatabase {
    private static final String DB_IMPL_SUFFIX = "_Impl";
    public static final int MAX_BIND_PARAMETER_CNT = 999;
    private boolean mAllowMainThreadQueries;
    private final Map<String, Object> mBackingFieldMap;
    @Deprecated
    protected List<Callback> mCallbacks;
    private final ReentrantReadWriteLock mCloseLock = new ReentrantReadWriteLock();
    @Deprecated
    protected volatile SupportSQLiteDatabase mDatabase;
    private final InvalidationTracker mInvalidationTracker;
    private SupportSQLiteOpenHelper mOpenHelper;
    private Executor mQueryExecutor;
    private final ThreadLocal<Integer> mSuspendingTransactionId = new ThreadLocal();
    private Executor mTransactionExecutor;
    boolean mWriteAheadLoggingEnabled;

    public RoomDatabase() {
        this.mBackingFieldMap = new ConcurrentHashMap<String, Object>();
        this.mInvalidationTracker = this.createInvalidationTracker();
    }

    private static boolean isMainThread() {
        boolean bl = Looper.getMainLooper().getThread() == Thread.currentThread();
        return bl;
    }

    public void assertNotMainThread() {
        if (this.mAllowMainThreadQueries) {
            return;
        }
        if (!RoomDatabase.isMainThread()) {
            return;
        }
        throw new IllegalStateException("Cannot access database on the main thread since it may potentially lock the UI for a long period of time.");
    }

    public void assertNotSuspendingTransaction() {
        if (!this.inTransaction() && this.mSuspendingTransactionId.get() != null) {
            throw new IllegalStateException("Cannot access database on a different coroutine context inherited from a suspending transaction.");
        }
    }

    @Deprecated
    public void beginTransaction() {
        this.assertNotMainThread();
        SupportSQLiteDatabase supportSQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        this.mInvalidationTracker.syncTriggers(supportSQLiteDatabase);
        supportSQLiteDatabase.beginTransaction();
    }

    public abstract void clearAllTables();

    public void close() {
        if (this.isOpen()) {
            ReentrantReadWriteLock.WriteLock writeLock = this.mCloseLock.writeLock();
            try {
                writeLock.lock();
                this.mInvalidationTracker.stopMultiInstanceInvalidation();
                this.mOpenHelper.close();
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    public SupportSQLiteStatement compileStatement(String string2) {
        this.assertNotMainThread();
        this.assertNotSuspendingTransaction();
        return this.mOpenHelper.getWritableDatabase().compileStatement(string2);
    }

    protected abstract InvalidationTracker createInvalidationTracker();

    protected abstract SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration var1);

    @Deprecated
    public void endTransaction() {
        this.mOpenHelper.getWritableDatabase().endTransaction();
        if (!this.inTransaction()) {
            this.mInvalidationTracker.refreshVersionsAsync();
        }
    }

    Map<String, Object> getBackingFieldMap() {
        return this.mBackingFieldMap;
    }

    Lock getCloseLock() {
        return this.mCloseLock.readLock();
    }

    public InvalidationTracker getInvalidationTracker() {
        return this.mInvalidationTracker;
    }

    public SupportSQLiteOpenHelper getOpenHelper() {
        return this.mOpenHelper;
    }

    public Executor getQueryExecutor() {
        return this.mQueryExecutor;
    }

    ThreadLocal<Integer> getSuspendingTransactionId() {
        return this.mSuspendingTransactionId;
    }

    public Executor getTransactionExecutor() {
        return this.mTransactionExecutor;
    }

    public boolean inTransaction() {
        return this.mOpenHelper.getWritableDatabase().inTransaction();
    }

    public void init(DatabaseConfiguration databaseConfiguration) {
        this.mOpenHelper = this.createOpenHelper(databaseConfiguration);
        int n2 = Build.VERSION.SDK_INT;
        boolean bl = false;
        boolean bl2 = false;
        if (n2 >= 16) {
            bl = bl2;
            if (databaseConfiguration.journalMode == JournalMode.WRITE_AHEAD_LOGGING) {
                bl = true;
            }
            this.mOpenHelper.setWriteAheadLoggingEnabled(bl);
        }
        this.mCallbacks = databaseConfiguration.callbacks;
        this.mQueryExecutor = databaseConfiguration.queryExecutor;
        this.mTransactionExecutor = new TransactionExecutor(databaseConfiguration.transactionExecutor);
        this.mAllowMainThreadQueries = databaseConfiguration.allowMainThreadQueries;
        this.mWriteAheadLoggingEnabled = bl;
        if (databaseConfiguration.multiInstanceInvalidation) {
            this.mInvalidationTracker.startMultiInstanceInvalidation(databaseConfiguration.context, databaseConfiguration.name);
        }
    }

    protected void internalInitInvalidationTracker(SupportSQLiteDatabase supportSQLiteDatabase) {
        this.mInvalidationTracker.internalInit(supportSQLiteDatabase);
    }

    public boolean isOpen() {
        SupportSQLiteDatabase supportSQLiteDatabase = this.mDatabase;
        boolean bl = supportSQLiteDatabase != null && supportSQLiteDatabase.isOpen();
        return bl;
    }

    public Cursor query(SupportSQLiteQuery supportSQLiteQuery) {
        this.assertNotMainThread();
        this.assertNotSuspendingTransaction();
        return this.mOpenHelper.getWritableDatabase().query(supportSQLiteQuery);
    }

    public Cursor query(String string2, Object[] objectArray) {
        return this.mOpenHelper.getWritableDatabase().query((SupportSQLiteQuery)new SimpleSQLiteQuery(string2, objectArray));
    }

    /*
     * Exception decompiling
     */
    public <V> V runInTransaction(Callable<V> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 26->30)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void runInTransaction(Runnable runnable2) {
        this.beginTransaction();
        try {
            runnable2.run();
            this.setTransactionSuccessful();
            return;
        }
        finally {
            this.endTransaction();
        }
    }

    @Deprecated
    public void setTransactionSuccessful() {
        this.mOpenHelper.getWritableDatabase().setTransactionSuccessful();
    }

    public static class Builder<T extends RoomDatabase> {
        private boolean mAllowDestructiveMigrationOnDowngrade;
        private boolean mAllowMainThreadQueries;
        private ArrayList<Callback> mCallbacks;
        private final Context mContext;
        private final Class<T> mDatabaseClass;
        private SupportSQLiteOpenHelper.Factory mFactory;
        private JournalMode mJournalMode;
        private final MigrationContainer mMigrationContainer;
        private Set<Integer> mMigrationStartAndEndVersions;
        private Set<Integer> mMigrationsNotRequiredFrom;
        private boolean mMultiInstanceInvalidation;
        private final String mName;
        private Executor mQueryExecutor;
        private boolean mRequireMigration;
        private Executor mTransactionExecutor;

        Builder(Context context, Class<T> clazz, String string2) {
            this.mContext = context;
            this.mDatabaseClass = clazz;
            this.mName = string2;
            this.mJournalMode = JournalMode.AUTOMATIC;
            this.mRequireMigration = true;
            this.mMigrationContainer = new MigrationContainer();
        }

        public Builder<T> addCallback(Callback callback2) {
            if (this.mCallbacks == null) {
                this.mCallbacks = new ArrayList();
            }
            this.mCallbacks.add(callback2);
            return this;
        }

        public Builder<T> addMigrations(Migration ... migrationArray) {
            if (this.mMigrationStartAndEndVersions == null) {
                this.mMigrationStartAndEndVersions = new HashSet<Integer>();
            }
            int n2 = migrationArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Migration migration = migrationArray[i2];
                this.mMigrationStartAndEndVersions.add(migration.startVersion);
                this.mMigrationStartAndEndVersions.add(migration.endVersion);
            }
            this.mMigrationContainer.addMigrations(migrationArray);
            return this;
        }

        public Builder<T> allowMainThreadQueries() {
            this.mAllowMainThreadQueries = true;
            return this;
        }

        public T build() {
            if (this.mContext != null) {
                if (this.mDatabaseClass != null) {
                    Object object;
                    Object object2;
                    if (this.mQueryExecutor == null && this.mTransactionExecutor == null) {
                        object2 = ArchTaskExecutor.getIOThreadExecutor();
                        this.mTransactionExecutor = object2;
                        this.mQueryExecutor = object2;
                    } else {
                        object2 = this.mQueryExecutor;
                        if (object2 != null && this.mTransactionExecutor == null) {
                            this.mTransactionExecutor = object2;
                        } else if (this.mQueryExecutor == null && (object2 = this.mTransactionExecutor) != null) {
                            this.mQueryExecutor = object2;
                        }
                    }
                    object2 = this.mMigrationStartAndEndVersions;
                    if (object2 != null && this.mMigrationsNotRequiredFrom != null) {
                        object = object2.iterator();
                        while (object.hasNext()) {
                            object2 = (Integer)object.next();
                            if (!this.mMigrationsNotRequiredFrom.contains(object2)) continue;
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Inconsistency detected. A Migration was supplied to addMigration(Migration... migrations) that has a start or end version equal to a start version supplied to fallbackToDestructiveMigrationFrom(int... startVersions). Start version: ");
                            ((StringBuilder)object).append(object2);
                            throw new IllegalArgumentException(((StringBuilder)object).toString());
                        }
                    }
                    if (this.mFactory == null) {
                        this.mFactory = new FrameworkSQLiteOpenHelperFactory();
                    }
                    object2 = this.mContext;
                    object2 = new DatabaseConfiguration((Context)object2, this.mName, this.mFactory, this.mMigrationContainer, this.mCallbacks, this.mAllowMainThreadQueries, this.mJournalMode.resolve((Context)object2), this.mQueryExecutor, this.mTransactionExecutor, this.mMultiInstanceInvalidation, this.mRequireMigration, this.mAllowDestructiveMigrationOnDowngrade, this.mMigrationsNotRequiredFrom);
                    object = (RoomDatabase)Room.getGeneratedImplementation(this.mDatabaseClass, (String)RoomDatabase.DB_IMPL_SUFFIX);
                    ((RoomDatabase)object).init((DatabaseConfiguration)object2);
                    return (T)object;
                }
                throw new IllegalArgumentException("Must provide an abstract class that extends RoomDatabase");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot provide null context for the database.");
            throw illegalArgumentException;
        }

        public Builder<T> enableMultiInstanceInvalidation() {
            boolean bl = this.mName != null;
            this.mMultiInstanceInvalidation = bl;
            return this;
        }

        public Builder<T> fallbackToDestructiveMigration() {
            this.mRequireMigration = false;
            this.mAllowDestructiveMigrationOnDowngrade = true;
            return this;
        }

        public Builder<T> fallbackToDestructiveMigrationFrom(int ... nArray) {
            if (this.mMigrationsNotRequiredFrom == null) {
                this.mMigrationsNotRequiredFrom = new HashSet<Integer>(nArray.length);
            }
            for (int n2 : nArray) {
                this.mMigrationsNotRequiredFrom.add(n2);
            }
            return this;
        }

        public Builder<T> fallbackToDestructiveMigrationOnDowngrade() {
            this.mRequireMigration = true;
            this.mAllowDestructiveMigrationOnDowngrade = true;
            return this;
        }

        public Builder<T> openHelperFactory(SupportSQLiteOpenHelper.Factory factory) {
            this.mFactory = factory;
            return this;
        }

        public Builder<T> setJournalMode(JournalMode journalMode) {
            this.mJournalMode = journalMode;
            return this;
        }

        public Builder<T> setQueryExecutor(Executor executor) {
            this.mQueryExecutor = executor;
            return this;
        }

        public Builder<T> setTransactionExecutor(Executor executor) {
            this.mTransactionExecutor = executor;
            return this;
        }
    }

    public static abstract class Callback {
        public void onCreate(SupportSQLiteDatabase supportSQLiteDatabase) {
        }

        public void onOpen(SupportSQLiteDatabase supportSQLiteDatabase) {
        }
    }

    public static enum JournalMode {
        AUTOMATIC,
        TRUNCATE,
        WRITE_AHEAD_LOGGING;


        JournalMode resolve(Context context) {
            if (this != AUTOMATIC) {
                return this;
            }
            if (Build.VERSION.SDK_INT >= 16 && (context = (ActivityManager)context.getSystemService("activity")) != null && !ActivityManagerCompat.isLowRamDevice((ActivityManager)context)) {
                return WRITE_AHEAD_LOGGING;
            }
            return TRUNCATE;
        }
    }

    public static class MigrationContainer {
        private SparseArrayCompat<SparseArrayCompat<Migration>> mMigrations = new SparseArrayCompat();

        private void addMigration(Migration migration) {
            SparseArrayCompat sparseArrayCompat;
            int n2 = migration.startVersion;
            int n3 = migration.endVersion;
            SparseArrayCompat sparseArrayCompat2 = sparseArrayCompat = (SparseArrayCompat)this.mMigrations.get(n2);
            if (sparseArrayCompat == null) {
                sparseArrayCompat2 = new SparseArrayCompat();
                this.mMigrations.put(n2, (Object)sparseArrayCompat2);
            }
            if ((sparseArrayCompat = (Migration)sparseArrayCompat2.get(n3)) != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Overriding migration ");
                stringBuilder.append(sparseArrayCompat);
                stringBuilder.append(" with ");
                stringBuilder.append(migration);
                Log.w((String)"ROOM", (String)stringBuilder.toString());
            }
            sparseArrayCompat2.append(n3, (Object)migration);
        }

        /*
         * Enabled aggressive block sorting
         */
        private List<Migration> findUpMigrationPath(List<Migration> list, boolean bl, int n2, int n3) {
            boolean bl2;
            int n4;
            int n5;
            if (bl) {
                n5 = -1;
                n4 = n2;
            } else {
                n5 = 1;
                n4 = n2;
            }
            do {
                int n6;
                boolean bl3;
                int n7;
                SparseArrayCompat sparseArrayCompat;
                if (bl ? n4 < n3 : n4 > n3) {
                    sparseArrayCompat = (SparseArrayCompat)this.mMigrations.get(n4);
                    if (sparseArrayCompat == null) {
                        return null;
                    }
                    n7 = sparseArrayCompat.size();
                    bl3 = false;
                    if (bl) {
                        n2 = n7 - 1;
                        n7 = -1;
                    } else {
                        n2 = 0;
                    }
                } else {
                    return list;
                }
                while (true) {
                    bl2 = bl3;
                    n6 = n4;
                    if (n2 == n7) break;
                    n6 = sparseArrayCompat.keyAt(n2);
                    bl2 = bl ? n6 <= n3 && n6 > n4 : n6 >= n3 && n6 < n4;
                    if (bl2) {
                        list.add((Migration)sparseArrayCompat.valueAt(n2));
                        bl2 = true;
                        break;
                    }
                    n2 += n5;
                }
                n4 = n6;
            } while (bl2);
            return null;
        }

        public void addMigrations(Migration ... migrationArray) {
            int n2 = migrationArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.addMigration(migrationArray[i2]);
            }
        }

        public List<Migration> findMigrationPath(int n2, int n3) {
            if (n2 == n3) {
                return Collections.emptyList();
            }
            boolean bl = n3 > n2;
            return this.findUpMigrationPath(new ArrayList<Migration>(), bl, n2, n3);
        }
    }
}

