/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.view.View;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

class ViewBoundsCheck {
    static final int CVE_PVE_POS = 12;
    static final int CVE_PVS_POS = 8;
    static final int CVS_PVE_POS = 4;
    static final int CVS_PVS_POS = 0;
    static final int EQ = 2;
    static final int FLAG_CVE_EQ_PVE = 8192;
    static final int FLAG_CVE_EQ_PVS = 512;
    static final int FLAG_CVE_GT_PVE = 4096;
    static final int FLAG_CVE_GT_PVS = 256;
    static final int FLAG_CVE_LT_PVE = 16384;
    static final int FLAG_CVE_LT_PVS = 1024;
    static final int FLAG_CVS_EQ_PVE = 32;
    static final int FLAG_CVS_EQ_PVS = 2;
    static final int FLAG_CVS_GT_PVE = 16;
    static final int FLAG_CVS_GT_PVS = 1;
    static final int FLAG_CVS_LT_PVE = 64;
    static final int FLAG_CVS_LT_PVS = 4;
    static final int GT = 1;
    static final int LT = 4;
    static final int MASK = 7;
    BoundFlags mBoundFlags;
    final Callback mCallback;

    ViewBoundsCheck(Callback callback2) {
        this.mCallback = callback2;
        this.mBoundFlags = new BoundFlags();
    }

    View findOneViewWithinBoundFlags(int n2, int n3, int n4, int n5) {
        int n6 = this.mCallback.getParentStart();
        int n7 = this.mCallback.getParentEnd();
        int n8 = n3 > n2 ? 1 : -1;
        View view = null;
        while (n2 != n3) {
            View view2 = this.mCallback.getChildAt(n2);
            int n9 = this.mCallback.getChildStart(view2);
            int n10 = this.mCallback.getChildEnd(view2);
            this.mBoundFlags.setBounds(n6, n7, n9, n10);
            if (n4 != 0) {
                this.mBoundFlags.resetFlags();
                this.mBoundFlags.addFlags(n4);
                if (this.mBoundFlags.boundsMatch()) {
                    return view2;
                }
            }
            View view3 = view;
            if (n5 != 0) {
                this.mBoundFlags.resetFlags();
                this.mBoundFlags.addFlags(n5);
                view3 = view;
                if (this.mBoundFlags.boundsMatch()) {
                    view3 = view2;
                }
            }
            n2 += n8;
            view = view3;
        }
        return view;
    }

    boolean isViewWithinBoundFlags(View view, int n2) {
        this.mBoundFlags.setBounds(this.mCallback.getParentStart(), this.mCallback.getParentEnd(), this.mCallback.getChildStart(view), this.mCallback.getChildEnd(view));
        if (n2 != 0) {
            this.mBoundFlags.resetFlags();
            this.mBoundFlags.addFlags(n2);
            return this.mBoundFlags.boundsMatch();
        }
        return false;
    }

    static class BoundFlags {
        int mBoundFlags = 0;
        int mChildEnd;
        int mChildStart;
        int mRvEnd;
        int mRvStart;

        BoundFlags() {
        }

        void addFlags(int n2) {
            this.mBoundFlags = n2 | this.mBoundFlags;
        }

        boolean boundsMatch() {
            int n2 = this.mBoundFlags;
            if ((n2 & 7) != 0 && (n2 & this.compare(this.mChildStart, this.mRvStart) << 0) == 0) {
                return false;
            }
            n2 = this.mBoundFlags;
            if ((n2 & 0x70) != 0 && (n2 & this.compare(this.mChildStart, this.mRvEnd) << 4) == 0) {
                return false;
            }
            n2 = this.mBoundFlags;
            if ((n2 & 0x700) != 0 && (n2 & this.compare(this.mChildEnd, this.mRvStart) << 8) == 0) {
                return false;
            }
            n2 = this.mBoundFlags;
            return (n2 & 0x7000) == 0 || (n2 & this.compare(this.mChildEnd, this.mRvEnd) << 12) != 0;
        }

        int compare(int n2, int n3) {
            if (n2 > n3) {
                return 1;
            }
            if (n2 == n3) {
                return 2;
            }
            return 4;
        }

        void resetFlags() {
            this.mBoundFlags = 0;
        }

        void setBounds(int n2, int n3, int n4, int n5) {
            this.mRvStart = n2;
            this.mRvEnd = n3;
            this.mChildStart = n4;
            this.mChildEnd = n5;
        }
    }

    static interface Callback {
        public View getChildAt(int var1);

        public int getChildEnd(View var1);

        public int getChildStart(View var1);

        public int getParentEnd();

        public int getParentStart();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ViewBounds {
    }
}

