/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.recyclerview.widget.LayoutState;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.ScrollbarHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class StaggeredGridLayoutManager
extends RecyclerView.LayoutManager
implements RecyclerView.SmoothScroller.ScrollVectorProvider {
    static final boolean DEBUG = false;
    @Deprecated
    public static final int GAP_HANDLING_LAZY = 1;
    public static final int GAP_HANDLING_MOVE_ITEMS_BETWEEN_SPANS = 2;
    public static final int GAP_HANDLING_NONE = 0;
    public static final int HORIZONTAL = 0;
    static final int INVALID_OFFSET = Integer.MIN_VALUE;
    private static final float MAX_SCROLL_FACTOR = 0.33333334f;
    private static final String TAG = "StaggeredGridLManager";
    public static final int VERTICAL = 1;
    private final AnchorInfo mAnchorInfo;
    private final Runnable mCheckForGapsRunnable;
    private int mFullSizeSpec;
    private int mGapStrategy = 2;
    private boolean mLaidOutInvalidFullSpan = false;
    private boolean mLastLayoutFromEnd;
    private boolean mLastLayoutRTL;
    private final LayoutState mLayoutState;
    LazySpanLookup mLazySpanLookup;
    private int mOrientation;
    private SavedState mPendingSavedState;
    int mPendingScrollPosition = -1;
    int mPendingScrollPositionOffset = Integer.MIN_VALUE;
    private int[] mPrefetchDistances;
    OrientationHelper mPrimaryOrientation;
    private BitSet mRemainingSpans;
    boolean mReverseLayout = false;
    OrientationHelper mSecondaryOrientation;
    boolean mShouldReverseLayout = false;
    private int mSizePerSpan;
    private boolean mSmoothScrollbarEnabled = true;
    private int mSpanCount = -1;
    Span[] mSpans;
    private final Rect mTmpRect;

    public StaggeredGridLayoutManager(int n2, int n3) {
        this.mLazySpanLookup = new LazySpanLookup();
        this.mTmpRect = new Rect();
        this.mAnchorInfo = new AnchorInfo();
        this.mCheckForGapsRunnable = new Runnable(){

            @Override
            public void run() {
                StaggeredGridLayoutManager.this.checkForGaps();
            }
        };
        this.mOrientation = n3;
        this.setSpanCount(n2);
        this.mLayoutState = new LayoutState();
        this.createOrientationHelpers();
    }

    public StaggeredGridLayoutManager(Context object, AttributeSet attributeSet, int n2, int n3) {
        this.mLazySpanLookup = new LazySpanLookup();
        this.mTmpRect = new Rect();
        this.mAnchorInfo = new AnchorInfo();
        this.mCheckForGapsRunnable = new /* invalid duplicate definition of identical inner class */;
        object = StaggeredGridLayoutManager.getProperties(object, attributeSet, n2, n3);
        this.setOrientation(object.orientation);
        this.setSpanCount(object.spanCount);
        this.setReverseLayout(object.reverseLayout);
        this.mLayoutState = new LayoutState();
        this.createOrientationHelpers();
    }

    private void appendViewToAllSpans(View view) {
        for (int i2 = this.mSpanCount - 1; i2 >= 0; --i2) {
            this.mSpans[i2].appendToSpan(view);
        }
    }

    private void applyPendingSavedState(AnchorInfo anchorInfo) {
        if (this.mPendingSavedState.mSpanOffsetsSize > 0) {
            if (this.mPendingSavedState.mSpanOffsetsSize == this.mSpanCount) {
                for (int i2 = 0; i2 < this.mSpanCount; ++i2) {
                    int n2;
                    this.mSpans[i2].clear();
                    int n3 = n2 = this.mPendingSavedState.mSpanOffsets[i2];
                    if (n2 != Integer.MIN_VALUE) {
                        n3 = this.mPendingSavedState.mAnchorLayoutFromEnd ? this.mPrimaryOrientation.getEndAfterPadding() : this.mPrimaryOrientation.getStartAfterPadding();
                        n3 = n2 + n3;
                    }
                    this.mSpans[i2].setLine(n3);
                }
            } else {
                this.mPendingSavedState.invalidateSpanInfo();
                SavedState savedState = this.mPendingSavedState;
                savedState.mAnchorPosition = savedState.mVisibleAnchorPosition;
            }
        }
        this.mLastLayoutRTL = this.mPendingSavedState.mLastLayoutRTL;
        this.setReverseLayout(this.mPendingSavedState.mReverseLayout);
        this.resolveShouldLayoutReverse();
        if (this.mPendingSavedState.mAnchorPosition != -1) {
            this.mPendingScrollPosition = this.mPendingSavedState.mAnchorPosition;
            anchorInfo.mLayoutFromEnd = this.mPendingSavedState.mAnchorLayoutFromEnd;
        } else {
            anchorInfo.mLayoutFromEnd = this.mShouldReverseLayout;
        }
        if (this.mPendingSavedState.mSpanLookupSize > 1) {
            this.mLazySpanLookup.mData = this.mPendingSavedState.mSpanLookup;
            this.mLazySpanLookup.mFullSpanItems = this.mPendingSavedState.mFullSpanItems;
        }
    }

    private void attachViewToSpans(View view, LayoutParams layoutParams, LayoutState layoutState) {
        if (layoutState.mLayoutDirection == 1) {
            if (layoutParams.mFullSpan) {
                this.appendViewToAllSpans(view);
            } else {
                layoutParams.mSpan.appendToSpan(view);
            }
        } else if (layoutParams.mFullSpan) {
            this.prependViewToAllSpans(view);
        } else {
            layoutParams.mSpan.prependToSpan(view);
        }
    }

    private int calculateScrollDirectionForPosition(int n2) {
        int n3 = this.getChildCount();
        int n4 = -1;
        if (n3 == 0) {
            if (this.mShouldReverseLayout) {
                n4 = 1;
            }
            return n4;
        }
        boolean bl = n2 < this.getFirstChildPosition();
        if (bl == this.mShouldReverseLayout) {
            n4 = 1;
        }
        return n4;
    }

    private boolean checkSpanForGap(Span span) {
        if (this.mShouldReverseLayout) {
            if (span.getEndLine() < this.mPrimaryOrientation.getEndAfterPadding()) {
                return span.getLayoutParams((View)span.mViews.get((int)(span.mViews.size() - 1))).mFullSpan ^ true;
            }
        } else if (span.getStartLine() > this.mPrimaryOrientation.getStartAfterPadding()) {
            return span.getLayoutParams((View)span.mViews.get((int)0)).mFullSpan ^ true;
        }
        return false;
    }

    private int computeScrollExtent(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        return ScrollbarHelper.computeScrollExtent((RecyclerView.State)state, (OrientationHelper)this.mPrimaryOrientation, (View)this.findFirstVisibleItemClosestToStart(this.mSmoothScrollbarEnabled ^ true), (View)this.findFirstVisibleItemClosestToEnd(this.mSmoothScrollbarEnabled ^ true), (RecyclerView.LayoutManager)this, (boolean)this.mSmoothScrollbarEnabled);
    }

    private int computeScrollOffset(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        return ScrollbarHelper.computeScrollOffset((RecyclerView.State)state, (OrientationHelper)this.mPrimaryOrientation, (View)this.findFirstVisibleItemClosestToStart(this.mSmoothScrollbarEnabled ^ true), (View)this.findFirstVisibleItemClosestToEnd(this.mSmoothScrollbarEnabled ^ true), (RecyclerView.LayoutManager)this, (boolean)this.mSmoothScrollbarEnabled, (boolean)this.mShouldReverseLayout);
    }

    private int computeScrollRange(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        return ScrollbarHelper.computeScrollRange((RecyclerView.State)state, (OrientationHelper)this.mPrimaryOrientation, (View)this.findFirstVisibleItemClosestToStart(this.mSmoothScrollbarEnabled ^ true), (View)this.findFirstVisibleItemClosestToEnd(this.mSmoothScrollbarEnabled ^ true), (RecyclerView.LayoutManager)this, (boolean)this.mSmoothScrollbarEnabled);
    }

    private int convertFocusDirectionToLayoutDirection(int n2) {
        int n3 = -1;
        int n4 = 1;
        int n5 = 1;
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 17) {
                    if (n2 != 33) {
                        if (n2 != 66) {
                            if (n2 != 130) {
                                return Integer.MIN_VALUE;
                            }
                            n2 = this.mOrientation == 1 ? n5 : Integer.MIN_VALUE;
                            return n2;
                        }
                        n2 = this.mOrientation == 0 ? n4 : Integer.MIN_VALUE;
                        return n2;
                    }
                    if (this.mOrientation != 1) {
                        n3 = Integer.MIN_VALUE;
                    }
                    return n3;
                }
                if (this.mOrientation != 0) {
                    n3 = Integer.MIN_VALUE;
                }
                return n3;
            }
            if (this.mOrientation == 1) {
                return 1;
            }
            if (this.isLayoutRTL()) {
                return -1;
            }
            return 1;
        }
        if (this.mOrientation == 1) {
            return -1;
        }
        if (this.isLayoutRTL()) {
            return 1;
        }
        return -1;
    }

    private LazySpanLookup.FullSpanItem createFullSpanItemFromEnd(int n2) {
        LazySpanLookup.FullSpanItem fullSpanItem = new LazySpanLookup.FullSpanItem();
        fullSpanItem.mGapPerSpan = new int[this.mSpanCount];
        for (int i2 = 0; i2 < this.mSpanCount; ++i2) {
            fullSpanItem.mGapPerSpan[i2] = n2 - this.mSpans[i2].getEndLine(n2);
        }
        return fullSpanItem;
    }

    private LazySpanLookup.FullSpanItem createFullSpanItemFromStart(int n2) {
        LazySpanLookup.FullSpanItem fullSpanItem = new LazySpanLookup.FullSpanItem();
        fullSpanItem.mGapPerSpan = new int[this.mSpanCount];
        for (int i2 = 0; i2 < this.mSpanCount; ++i2) {
            fullSpanItem.mGapPerSpan[i2] = this.mSpans[i2].getStartLine(n2) - n2;
        }
        return fullSpanItem;
    }

    private void createOrientationHelpers() {
        this.mPrimaryOrientation = OrientationHelper.createOrientationHelper(this, this.mOrientation);
        this.mSecondaryOrientation = OrientationHelper.createOrientationHelper(this, 1 - this.mOrientation);
    }

    private int fill(RecyclerView.Recycler recycler, LayoutState layoutState, RecyclerView.State state) {
        this.mRemainingSpans.set(0, this.mSpanCount, true);
        int n2 = this.mLayoutState.mInfinite ? (layoutState.mLayoutDirection == 1 ? Integer.MAX_VALUE : Integer.MIN_VALUE) : (layoutState.mLayoutDirection == 1 ? layoutState.mEndLine + layoutState.mAvailable : layoutState.mStartLine - layoutState.mAvailable);
        this.updateAllRemainingSpans(layoutState.mLayoutDirection, n2);
        int n3 = this.mShouldReverseLayout ? this.mPrimaryOrientation.getEndAfterPadding() : this.mPrimaryOrientation.getStartAfterPadding();
        int n4 = 0;
        while (layoutState.hasMore(state) && (this.mLayoutState.mInfinite || !this.mRemainingSpans.isEmpty())) {
            int n5;
            LazySpanLookup.FullSpanItem fullSpanItem;
            int n6;
            Span span;
            View view = layoutState.next(recycler);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n7 = layoutParams.getViewLayoutPosition();
            n4 = this.mLazySpanLookup.getSpan(n7);
            int n8 = n4 == -1 ? 1 : 0;
            if (n8 != 0) {
                span = layoutParams.mFullSpan ? this.mSpans[0] : this.getNextSpan(layoutState);
                this.mLazySpanLookup.setSpan(n7, span);
            } else {
                span = this.mSpans[n4];
            }
            layoutParams.mSpan = span;
            if (layoutState.mLayoutDirection == 1) {
                this.addView(view);
            } else {
                this.addView(view, 0);
            }
            this.measureChildWithDecorationsAndMargin(view, layoutParams, false);
            if (layoutState.mLayoutDirection == 1) {
                n4 = layoutParams.mFullSpan ? this.getMaxEnd(n3) : span.getEndLine(n3);
                n6 = this.mPrimaryOrientation.getDecoratedMeasurement(view);
                if (n8 != 0 && layoutParams.mFullSpan) {
                    fullSpanItem = this.createFullSpanItemFromEnd(n4);
                    fullSpanItem.mGapDir = -1;
                    fullSpanItem.mPosition = n7;
                    this.mLazySpanLookup.addFullSpanItem(fullSpanItem);
                }
                n6 += n4;
                n5 = n4;
            } else {
                n4 = layoutParams.mFullSpan ? this.getMinStart(n3) : span.getStartLine(n3);
                n5 = n4 - this.mPrimaryOrientation.getDecoratedMeasurement(view);
                if (n8 != 0 && layoutParams.mFullSpan) {
                    fullSpanItem = this.createFullSpanItemFromStart(n4);
                    fullSpanItem.mGapDir = 1;
                    fullSpanItem.mPosition = n7;
                    this.mLazySpanLookup.addFullSpanItem(fullSpanItem);
                }
                n6 = n4;
            }
            if (layoutParams.mFullSpan && layoutState.mItemDirection == -1) {
                if (n8 != 0) {
                    this.mLaidOutInvalidFullSpan = true;
                } else {
                    boolean bl = layoutState.mLayoutDirection == 1 ? this.areAllEndsEqual() : this.areAllStartsEqual();
                    if (bl ^ true) {
                        fullSpanItem = this.mLazySpanLookup.getFullSpanItem(n7);
                        if (fullSpanItem != null) {
                            fullSpanItem.mHasUnwantedGapAfter = true;
                        }
                        this.mLaidOutInvalidFullSpan = true;
                    }
                }
            }
            this.attachViewToSpans(view, layoutParams, layoutState);
            if (this.isLayoutRTL() && this.mOrientation == 1) {
                n4 = layoutParams.mFullSpan ? this.mSecondaryOrientation.getEndAfterPadding() : this.mSecondaryOrientation.getEndAfterPadding() - (this.mSpanCount - 1 - span.mIndex) * this.mSizePerSpan;
                n7 = this.mSecondaryOrientation.getDecoratedMeasurement(view);
                n8 = n4;
                n7 = n4 - n7;
                n4 = n8;
            } else {
                n4 = layoutParams.mFullSpan ? this.mSecondaryOrientation.getStartAfterPadding() : span.mIndex * this.mSizePerSpan + this.mSecondaryOrientation.getStartAfterPadding();
                n7 = this.mSecondaryOrientation.getDecoratedMeasurement(view);
                n8 = n4;
                n4 = n7 + n4;
                n7 = n8;
            }
            if (this.mOrientation == 1) {
                this.layoutDecoratedWithMargins(view, n7, n5, n4, n6);
            } else {
                this.layoutDecoratedWithMargins(view, n5, n7, n6, n4);
            }
            if (layoutParams.mFullSpan) {
                this.updateAllRemainingSpans(this.mLayoutState.mLayoutDirection, n2);
            } else {
                this.updateRemainingSpans(span, this.mLayoutState.mLayoutDirection, n2);
            }
            this.recycle(recycler, this.mLayoutState);
            if (this.mLayoutState.mStopInFocusable && view.hasFocusable()) {
                if (layoutParams.mFullSpan) {
                    this.mRemainingSpans.clear();
                } else {
                    this.mRemainingSpans.set(span.mIndex, false);
                }
            }
            n4 = 1;
        }
        n3 = 0;
        if (n4 == 0) {
            this.recycle(recycler, this.mLayoutState);
        }
        if (this.mLayoutState.mLayoutDirection == -1) {
            n2 = this.getMinStart(this.mPrimaryOrientation.getStartAfterPadding());
            n2 = this.mPrimaryOrientation.getStartAfterPadding() - n2;
        } else {
            n2 = this.getMaxEnd(this.mPrimaryOrientation.getEndAfterPadding()) - this.mPrimaryOrientation.getEndAfterPadding();
        }
        n4 = n3;
        if (n2 > 0) {
            n4 = Math.min(layoutState.mAvailable, n2);
        }
        return n4;
    }

    private int findFirstReferenceChildPosition(int n2) {
        int n3 = this.getChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.getPosition(this.getChildAt(i2));
            if (n4 < 0 || n4 >= n2) continue;
            return n4;
        }
        return 0;
    }

    private int findLastReferenceChildPosition(int n2) {
        for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
            int n3 = this.getPosition(this.getChildAt(i2));
            if (n3 < 0 || n3 >= n2) continue;
            return n3;
        }
        return 0;
    }

    private void fixEndGap(RecyclerView.Recycler recycler, RecyclerView.State state, boolean bl) {
        int n2 = this.getMaxEnd(Integer.MIN_VALUE);
        if (n2 == Integer.MIN_VALUE) {
            return;
        }
        n2 = this.mPrimaryOrientation.getEndAfterPadding() - n2;
        if (n2 > 0) {
            n2 -= -this.scrollBy(-n2, recycler, state);
            if (bl && n2 > 0) {
                this.mPrimaryOrientation.offsetChildren(n2);
            }
        }
    }

    private void fixStartGap(RecyclerView.Recycler recycler, RecyclerView.State state, boolean bl) {
        int n2 = this.getMinStart(Integer.MAX_VALUE);
        if (n2 == Integer.MAX_VALUE) {
            return;
        }
        if ((n2 -= this.mPrimaryOrientation.getStartAfterPadding()) > 0) {
            n2 -= this.scrollBy(n2, recycler, state);
            if (bl && n2 > 0) {
                this.mPrimaryOrientation.offsetChildren(-n2);
            }
        }
    }

    private int getMaxEnd(int n2) {
        int n3 = this.mSpans[0].getEndLine(n2);
        for (int i2 = 1; i2 < this.mSpanCount; ++i2) {
            int n4 = this.mSpans[i2].getEndLine(n2);
            int n5 = n3;
            if (n4 > n3) {
                n5 = n4;
            }
            n3 = n5;
        }
        return n3;
    }

    private int getMaxStart(int n2) {
        int n3 = this.mSpans[0].getStartLine(n2);
        for (int i2 = 1; i2 < this.mSpanCount; ++i2) {
            int n4 = this.mSpans[i2].getStartLine(n2);
            int n5 = n3;
            if (n4 > n3) {
                n5 = n4;
            }
            n3 = n5;
        }
        return n3;
    }

    private int getMinEnd(int n2) {
        int n3 = this.mSpans[0].getEndLine(n2);
        for (int i2 = 1; i2 < this.mSpanCount; ++i2) {
            int n4 = this.mSpans[i2].getEndLine(n2);
            int n5 = n3;
            if (n4 < n3) {
                n5 = n4;
            }
            n3 = n5;
        }
        return n3;
    }

    private int getMinStart(int n2) {
        int n3 = this.mSpans[0].getStartLine(n2);
        for (int i2 = 1; i2 < this.mSpanCount; ++i2) {
            int n4 = this.mSpans[i2].getStartLine(n2);
            int n5 = n3;
            if (n4 < n3) {
                n5 = n4;
            }
            n3 = n5;
        }
        return n3;
    }

    private Span getNextSpan(LayoutState object) {
        int n2;
        int n3;
        boolean bl = this.preferLastSpan(object.mLayoutDirection);
        int n4 = -1;
        if (bl) {
            n3 = this.mSpanCount - 1;
            n2 = -1;
        } else {
            n3 = 0;
            n4 = this.mSpanCount;
            n2 = 1;
        }
        int n5 = object.mLayoutDirection;
        Span span = null;
        object = null;
        if (n5 == 1) {
            int n6 = Integer.MAX_VALUE;
            int n7 = this.mPrimaryOrientation.getStartAfterPadding();
            for (n5 = n3; n5 != n4; n5 += n2) {
                span = this.mSpans[n5];
                int n8 = span.getEndLine(n7);
                n3 = n6;
                if (n8 < n6) {
                    object = span;
                    n3 = n8;
                }
                n6 = n3;
            }
            return object;
        }
        int n9 = Integer.MIN_VALUE;
        int n10 = this.mPrimaryOrientation.getEndAfterPadding();
        object = span;
        for (n5 = n3; n5 != n4; n5 += n2) {
            span = this.mSpans[n5];
            int n11 = span.getStartLine(n10);
            n3 = n9;
            if (n11 > n9) {
                object = span;
                n3 = n11;
            }
            n9 = n3;
        }
        return object;
    }

    private void handleUpdate(int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        block10: {
            block9: {
                block7: {
                    block8: {
                        n7 = this.mShouldReverseLayout ? this.getLastChildPosition() : this.getFirstChildPosition();
                        if (n4 != 8) break block7;
                        if (n2 >= n3) break block8;
                        n6 = n3 + 1;
                        break block9;
                    }
                    n5 = n2 + 1;
                    n6 = n3;
                    break block10;
                }
                n6 = n2 + n3;
            }
            n5 = n6;
            n6 = n2;
        }
        this.mLazySpanLookup.invalidateAfter(n6);
        if (n4 != 1) {
            if (n4 != 2) {
                if (n4 == 8) {
                    this.mLazySpanLookup.offsetForRemoval(n2, 1);
                    this.mLazySpanLookup.offsetForAddition(n3, 1);
                }
            } else {
                this.mLazySpanLookup.offsetForRemoval(n2, n3);
            }
        } else {
            this.mLazySpanLookup.offsetForAddition(n2, n3);
        }
        if (n5 <= n7) {
            return;
        }
        n2 = this.mShouldReverseLayout ? this.getFirstChildPosition() : this.getLastChildPosition();
        if (n6 <= n2) {
            this.requestLayout();
        }
    }

    private void measureChildWithDecorationsAndMargin(View view, int n2, int n3, boolean bl) {
        this.calculateItemDecorationsForChild(view, this.mTmpRect);
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        n2 = this.updateSpecWithExtra(n2, layoutParams.leftMargin + this.mTmpRect.left, layoutParams.rightMargin + this.mTmpRect.right);
        n3 = this.updateSpecWithExtra(n3, layoutParams.topMargin + this.mTmpRect.top, layoutParams.bottomMargin + this.mTmpRect.bottom);
        bl = bl ? this.shouldReMeasureChild(view, n2, n3, layoutParams) : this.shouldMeasureChild(view, n2, n3, layoutParams);
        if (bl) {
            view.measure(n2, n3);
        }
    }

    private void measureChildWithDecorationsAndMargin(View view, LayoutParams layoutParams, boolean bl) {
        if (layoutParams.mFullSpan) {
            if (this.mOrientation == 1) {
                this.measureChildWithDecorationsAndMargin(view, this.mFullSizeSpec, StaggeredGridLayoutManager.getChildMeasureSpec(this.getHeight(), this.getHeightMode(), this.getPaddingTop() + this.getPaddingBottom(), layoutParams.height, true), bl);
            } else {
                this.measureChildWithDecorationsAndMargin(view, StaggeredGridLayoutManager.getChildMeasureSpec(this.getWidth(), this.getWidthMode(), this.getPaddingLeft() + this.getPaddingRight(), layoutParams.width, true), this.mFullSizeSpec, bl);
            }
        } else if (this.mOrientation == 1) {
            this.measureChildWithDecorationsAndMargin(view, StaggeredGridLayoutManager.getChildMeasureSpec(this.mSizePerSpan, this.getWidthMode(), 0, layoutParams.width, false), StaggeredGridLayoutManager.getChildMeasureSpec(this.getHeight(), this.getHeightMode(), this.getPaddingTop() + this.getPaddingBottom(), layoutParams.height, true), bl);
        } else {
            this.measureChildWithDecorationsAndMargin(view, StaggeredGridLayoutManager.getChildMeasureSpec(this.getWidth(), this.getWidthMode(), this.getPaddingLeft() + this.getPaddingRight(), layoutParams.width, true), StaggeredGridLayoutManager.getChildMeasureSpec(this.mSizePerSpan, this.getHeightMode(), 0, layoutParams.height, false), bl);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void onLayoutChildren(RecyclerView.Recycler var1_1, RecyclerView.State var2_2, boolean var3_3) {
        var4_4 = this.mAnchorInfo;
        if ((this.mPendingSavedState != null || this.mPendingScrollPosition != -1) && var2_2.getItemCount() == 0) {
            this.removeAndRecycleAllViews(var1_1);
            var4_4.reset();
            return;
        }
        var5_5 = var4_4.mValid;
        var6_6 = 1;
        var7_7 = var5_5 && this.mPendingScrollPosition == -1 && this.mPendingSavedState == null ? 0 : 1;
        if (var7_7 != 0) {
            var4_4.reset();
            if (this.mPendingSavedState != null) {
                this.applyPendingSavedState(var4_4);
            } else {
                this.resolveShouldLayoutReverse();
                var4_4.mLayoutFromEnd = this.mShouldReverseLayout;
            }
            this.updateAnchorInfoForLayout(var2_2, var4_4);
            var4_4.mValid = true;
        }
        if (this.mPendingSavedState == null && this.mPendingScrollPosition == -1 && (var4_4.mLayoutFromEnd != this.mLastLayoutFromEnd || this.isLayoutRTL() != this.mLastLayoutRTL)) {
            this.mLazySpanLookup.clear();
            var4_4.mInvalidateOffsets = true;
        }
        if (this.getChildCount() > 0 && ((var8_8 = this.mPendingSavedState) == null || var8_8.mSpanOffsetsSize < 1)) {
            if (var4_4.mInvalidateOffsets) {
                for (var7_7 = 0; var7_7 < this.mSpanCount; ++var7_7) {
                    this.mSpans[var7_7].clear();
                    if (var4_4.mOffset == -2147483648) continue;
                    this.mSpans[var7_7].setLine(var4_4.mOffset);
                }
            } else if (var7_7 == 0 && this.mAnchorInfo.mSpanReferenceLines != null) {
                for (var7_7 = 0; var7_7 < this.mSpanCount; ++var7_7) {
                    var8_8 = this.mSpans[var7_7];
                    var8_8.clear();
                    var8_8.setLine(this.mAnchorInfo.mSpanReferenceLines[var7_7]);
                }
            } else {
                for (var7_7 = 0; var7_7 < this.mSpanCount; ++var7_7) {
                    this.mSpans[var7_7].cacheReferenceLineAndClear(this.mShouldReverseLayout, var4_4.mOffset);
                }
                this.mAnchorInfo.saveSpanReferenceLines(this.mSpans);
            }
        }
        this.detachAndScrapAttachedViews(var1_1);
        this.mLayoutState.mRecycle = false;
        this.mLaidOutInvalidFullSpan = false;
        this.updateMeasureSpecs(this.mSecondaryOrientation.getTotalSpace());
        this.updateLayoutState(var4_4.mPosition, var2_2);
        if (var4_4.mLayoutFromEnd) {
            this.setLayoutStateDirection(-1);
            this.fill(var1_1, this.mLayoutState, var2_2);
            this.setLayoutStateDirection(1);
            this.mLayoutState.mCurrentPosition = var4_4.mPosition + this.mLayoutState.mItemDirection;
            this.fill(var1_1, this.mLayoutState, var2_2);
        } else {
            this.setLayoutStateDirection(1);
            this.fill(var1_1, this.mLayoutState, var2_2);
            this.setLayoutStateDirection(-1);
            this.mLayoutState.mCurrentPosition = var4_4.mPosition + this.mLayoutState.mItemDirection;
            this.fill(var1_1, this.mLayoutState, var2_2);
        }
        this.repositionToWrapContentIfNecessary();
        if (this.getChildCount() > 0) {
            if (this.mShouldReverseLayout) {
                this.fixEndGap(var1_1, var2_2, true);
                this.fixStartGap(var1_1, var2_2, false);
            } else {
                this.fixStartGap(var1_1, var2_2, true);
                this.fixEndGap(var1_1, var2_2, false);
            }
        }
        if (!var3_3 || var2_2.isPreLayout() || (var7_7 = this.mGapStrategy != 0 && this.getChildCount() > 0 && (this.mLaidOutInvalidFullSpan != false || this.hasGapsToFix() != null) ? 1 : 0) == 0) ** GOTO lbl-1000
        this.removeCallbacks(this.mCheckForGapsRunnable);
        if (this.checkForGaps()) {
            var7_7 = var6_6;
        } else lbl-1000:
        // 2 sources

        {
            var7_7 = 0;
        }
        if (var2_2.isPreLayout()) {
            this.mAnchorInfo.reset();
        }
        this.mLastLayoutFromEnd = var4_4.mLayoutFromEnd;
        this.mLastLayoutRTL = this.isLayoutRTL();
        if (var7_7 != 0) {
            this.mAnchorInfo.reset();
            this.onLayoutChildren(var1_1, var2_2, false);
        }
    }

    private boolean preferLastSpan(int n2) {
        int n3 = this.mOrientation;
        boolean bl = true;
        boolean bl2 = true;
        if (n3 == 0) {
            boolean bl3 = n2 == -1;
            bl3 = bl3 != this.mShouldReverseLayout ? bl2 : false;
            return bl3;
        }
        boolean bl4 = n2 == -1;
        bl4 = bl4 == this.mShouldReverseLayout;
        bl4 = bl4 == this.isLayoutRTL() ? bl : false;
        return bl4;
    }

    private void prependViewToAllSpans(View view) {
        for (int i2 = this.mSpanCount - 1; i2 >= 0; --i2) {
            this.mSpans[i2].prependToSpan(view);
        }
    }

    private void recycle(RecyclerView.Recycler recycler, LayoutState layoutState) {
        if (layoutState.mRecycle && !layoutState.mInfinite) {
            if (layoutState.mAvailable == 0) {
                if (layoutState.mLayoutDirection == -1) {
                    this.recycleFromEnd(recycler, layoutState.mEndLine);
                } else {
                    this.recycleFromStart(recycler, layoutState.mStartLine);
                }
            } else if (layoutState.mLayoutDirection == -1) {
                int n2 = layoutState.mStartLine - this.getMaxStart(layoutState.mStartLine);
                n2 = n2 < 0 ? layoutState.mEndLine : layoutState.mEndLine - Math.min(n2, layoutState.mAvailable);
                this.recycleFromEnd(recycler, n2);
            } else {
                int n3 = this.getMinEnd(layoutState.mEndLine) - layoutState.mEndLine;
                if (n3 < 0) {
                    n3 = layoutState.mStartLine;
                } else {
                    int n4 = layoutState.mStartLine;
                    n3 = Math.min(n3, layoutState.mAvailable) + n4;
                }
                this.recycleFromStart(recycler, n3);
            }
        }
    }

    private void recycleFromEnd(RecyclerView.Recycler recycler, int n2) {
        View view;
        for (int i2 = this.getChildCount() - 1; i2 >= 0 && this.mPrimaryOrientation.getDecoratedStart(view = this.getChildAt(i2)) >= n2 && this.mPrimaryOrientation.getTransformedStartWithDecoration(view) >= n2; --i2) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.mFullSpan) {
                int n3 = 0;
                int n4 = 0;
                while (true) {
                    if (n4 >= this.mSpanCount) break;
                    if (this.mSpans[n4].mViews.size() == 1) {
                        return;
                    }
                    ++n4;
                }
                for (int i3 = n3; i3 < this.mSpanCount; ++i3) {
                    this.mSpans[i3].popEnd();
                }
            } else {
                if (layoutParams.mSpan.mViews.size() == 1) {
                    return;
                }
                layoutParams.mSpan.popEnd();
            }
            this.removeAndRecycleView(view, recycler);
        }
    }

    private void recycleFromStart(RecyclerView.Recycler recycler, int n2) {
        while (this.getChildCount() > 0) {
            int n3 = 0;
            View view = this.getChildAt(0);
            if (this.mPrimaryOrientation.getDecoratedEnd(view) > n2 || this.mPrimaryOrientation.getTransformedEndWithDecoration(view) > n2) break;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.mFullSpan) {
                int n4 = 0;
                while (true) {
                    if (n4 >= this.mSpanCount) break;
                    if (this.mSpans[n4].mViews.size() == 1) {
                        return;
                    }
                    ++n4;
                }
                for (int i2 = n3; i2 < this.mSpanCount; ++i2) {
                    this.mSpans[i2].popStart();
                }
            } else {
                if (layoutParams.mSpan.mViews.size() == 1) {
                    return;
                }
                layoutParams.mSpan.popStart();
            }
            this.removeAndRecycleView(view, recycler);
        }
    }

    private void repositionToWrapContentIfNecessary() {
        int n2;
        Object object;
        int n3;
        if (this.mSecondaryOrientation.getMode() == 0x40000000) {
            return;
        }
        int n4 = this.getChildCount();
        int n5 = 0;
        float f2 = 0.0f;
        for (n3 = 0; n3 < n4; ++n3) {
            object = this.getChildAt(n3);
            float f3 = this.mSecondaryOrientation.getDecoratedMeasurement((View)object);
            if (f3 < f2) continue;
            float f4 = f3;
            if (((LayoutParams)object.getLayoutParams()).isFullSpan()) {
                f4 = f3 * 1.0f / (float)this.mSpanCount;
            }
            f2 = Math.max(f2, f4);
        }
        int n6 = this.mSizePerSpan;
        n3 = n2 = Math.round(f2 * (float)this.mSpanCount);
        if (this.mSecondaryOrientation.getMode() == Integer.MIN_VALUE) {
            n3 = Math.min(n2, this.mSecondaryOrientation.getTotalSpace());
        }
        this.updateMeasureSpecs(n3);
        if (this.mSizePerSpan == n6) {
            return;
        }
        for (n3 = n5; n3 < n4; ++n3) {
            View view = this.getChildAt(n3);
            object = (LayoutParams)view.getLayoutParams();
            if (object.mFullSpan) continue;
            if (this.isLayoutRTL() && this.mOrientation == 1) {
                view.offsetLeftAndRight(-(this.mSpanCount - 1 - object.mSpan.mIndex) * this.mSizePerSpan - -(this.mSpanCount - 1 - object.mSpan.mIndex) * n6);
                continue;
            }
            n5 = object.mSpan.mIndex * this.mSizePerSpan;
            n2 = object.mSpan.mIndex * n6;
            if (this.mOrientation == 1) {
                view.offsetLeftAndRight(n5 - n2);
                continue;
            }
            view.offsetTopAndBottom(n5 - n2);
        }
    }

    private void resolveShouldLayoutReverse() {
        this.mShouldReverseLayout = this.mOrientation != 1 && this.isLayoutRTL() ? this.mReverseLayout ^ true : this.mReverseLayout;
    }

    private void setLayoutStateDirection(int n2) {
        LayoutState layoutState = this.mLayoutState;
        layoutState.mLayoutDirection = n2;
        boolean bl = this.mShouldReverseLayout;
        int n3 = 1;
        boolean bl2 = n2 == -1;
        n2 = bl == bl2 ? n3 : -1;
        layoutState.mItemDirection = n2;
    }

    private void updateAllRemainingSpans(int n2, int n3) {
        for (int i2 = 0; i2 < this.mSpanCount; ++i2) {
            if (this.mSpans[i2].mViews.isEmpty()) continue;
            this.updateRemainingSpans(this.mSpans[i2], n2, n3);
        }
    }

    private boolean updateAnchorFromChildren(RecyclerView.State state, AnchorInfo anchorInfo) {
        int n2 = this.mLastLayoutFromEnd ? this.findLastReferenceChildPosition(state.getItemCount()) : this.findFirstReferenceChildPosition(state.getItemCount());
        anchorInfo.mPosition = n2;
        anchorInfo.mOffset = Integer.MIN_VALUE;
        return true;
    }

    private void updateLayoutState(int n2, RecyclerView.State state) {
        boolean bl;
        int n3;
        boolean bl2;
        block7: {
            block6: {
                block4: {
                    block5: {
                        LayoutState layoutState = this.mLayoutState;
                        bl2 = false;
                        layoutState.mAvailable = 0;
                        layoutState.mCurrentPosition = n2;
                        if (!this.isSmoothScrolling() || (n3 = state.getTargetScrollPosition()) == -1) break block4;
                        boolean bl3 = this.mShouldReverseLayout;
                        bl = n3 < n2;
                        if (bl3 != bl) break block5;
                        n2 = this.mPrimaryOrientation.getTotalSpace();
                        break block6;
                    }
                    n3 = this.mPrimaryOrientation.getTotalSpace();
                    n2 = 0;
                    break block7;
                }
                n2 = 0;
            }
            n3 = 0;
        }
        if (this.getClipToPadding()) {
            this.mLayoutState.mStartLine = this.mPrimaryOrientation.getStartAfterPadding() - n3;
            this.mLayoutState.mEndLine = this.mPrimaryOrientation.getEndAfterPadding() + n2;
        } else {
            this.mLayoutState.mEndLine = this.mPrimaryOrientation.getEnd() + n2;
            this.mLayoutState.mStartLine = -n3;
        }
        state = this.mLayoutState;
        ((LayoutState)state).mStopInFocusable = false;
        ((LayoutState)state).mRecycle = true;
        bl = bl2;
        if (this.mPrimaryOrientation.getMode() == 0) {
            bl = bl2;
            if (this.mPrimaryOrientation.getEnd() == 0) {
                bl = true;
            }
        }
        ((LayoutState)state).mInfinite = bl;
    }

    private void updateRemainingSpans(Span span, int n2, int n3) {
        int n4 = span.getDeletedSize();
        if (n2 == -1) {
            if (span.getStartLine() + n4 <= n3) {
                this.mRemainingSpans.set(span.mIndex, false);
            }
        } else if (span.getEndLine() - n4 >= n3) {
            this.mRemainingSpans.set(span.mIndex, false);
        }
    }

    private int updateSpecWithExtra(int n2, int n3, int n4) {
        if (n3 == 0 && n4 == 0) {
            return n2;
        }
        int n5 = View.MeasureSpec.getMode((int)n2);
        if (n5 != Integer.MIN_VALUE && n5 != 0x40000000) {
            return n2;
        }
        return View.MeasureSpec.makeMeasureSpec((int)Math.max(0, View.MeasureSpec.getSize((int)n2) - n3 - n4), (int)n5);
    }

    boolean areAllEndsEqual() {
        int n2 = this.mSpans[0].getEndLine(Integer.MIN_VALUE);
        for (int i2 = 1; i2 < this.mSpanCount; ++i2) {
            if (this.mSpans[i2].getEndLine(Integer.MIN_VALUE) == n2) continue;
            return false;
        }
        return true;
    }

    boolean areAllStartsEqual() {
        int n2 = this.mSpans[0].getStartLine(Integer.MIN_VALUE);
        for (int i2 = 1; i2 < this.mSpanCount; ++i2) {
            if (this.mSpans[i2].getStartLine(Integer.MIN_VALUE) == n2) continue;
            return false;
        }
        return true;
    }

    @Override
    public void assertNotInLayoutOrScroll(String string2) {
        if (this.mPendingSavedState == null) {
            super.assertNotInLayoutOrScroll(string2);
        }
    }

    @Override
    public boolean canScrollHorizontally() {
        boolean bl = this.mOrientation == 0;
        return bl;
    }

    @Override
    public boolean canScrollVertically() {
        int n2 = this.mOrientation;
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    boolean checkForGaps() {
        if (this.getChildCount() != 0 && this.mGapStrategy != 0 && this.isAttachedToWindow()) {
            int n2;
            int n3;
            if (this.mShouldReverseLayout) {
                n3 = this.getLastChildPosition();
                n2 = this.getFirstChildPosition();
            } else {
                n3 = this.getFirstChildPosition();
                n2 = this.getLastChildPosition();
            }
            if (n3 == 0 && this.hasGapsToFix() != null) {
                this.mLazySpanLookup.clear();
                this.requestSimpleAnimationsInNextLayout();
                this.requestLayout();
                return true;
            }
            if (!this.mLaidOutInvalidFullSpan) {
                return false;
            }
            int n4 = this.mShouldReverseLayout ? -1 : 1;
            Object object = this.mLazySpanLookup;
            if ((object = ((LazySpanLookup)object).getFirstFullSpanItemInRange(n3, ++n2, n4, true)) == null) {
                this.mLaidOutInvalidFullSpan = false;
                this.mLazySpanLookup.forceInvalidateAfter(n2);
                return false;
            }
            LazySpanLookup.FullSpanItem fullSpanItem = this.mLazySpanLookup.getFirstFullSpanItemInRange(n3, ((LazySpanLookup.FullSpanItem)object).mPosition, n4 * -1, true);
            if (fullSpanItem == null) {
                this.mLazySpanLookup.forceInvalidateAfter(((LazySpanLookup.FullSpanItem)object).mPosition);
            } else {
                this.mLazySpanLookup.forceInvalidateAfter(fullSpanItem.mPosition + 1);
            }
            this.requestSimpleAnimationsInNextLayout();
            this.requestLayout();
            return true;
        }
        return false;
    }

    @Override
    public boolean checkLayoutParams(RecyclerView.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    @Override
    public void collectAdjacentPrefetchPositions(int n2, int n3, RecyclerView.State state, RecyclerView.LayoutManager.LayoutPrefetchRegistry layoutPrefetchRegistry) {
        if (this.mOrientation != 0) {
            n2 = n3;
        }
        if (this.getChildCount() != 0 && n2 != 0) {
            this.prepareLayoutStateForDelta(n2, state);
            Object object = this.mPrefetchDistances;
            if (object == null || ((int[])object).length < this.mSpanCount) {
                this.mPrefetchDistances = new int[this.mSpanCount];
            }
            int n4 = 0;
            n2 = 0;
            for (n3 = 0; n3 < this.mSpanCount; ++n3) {
                int n5;
                int n6;
                if (this.mLayoutState.mItemDirection == -1) {
                    n6 = this.mLayoutState.mStartLine;
                    n5 = this.mSpans[n3].getStartLine(this.mLayoutState.mStartLine);
                } else {
                    n6 = this.mSpans[n3].getEndLine(this.mLayoutState.mEndLine);
                    n5 = this.mLayoutState.mEndLine;
                }
                n6 -= n5;
                n5 = n2;
                if (n6 >= 0) {
                    this.mPrefetchDistances[n2] = n6;
                    n5 = n2 + 1;
                }
                n2 = n5;
            }
            Arrays.sort(this.mPrefetchDistances, 0, n2);
            for (n3 = n4; n3 < n2 && this.mLayoutState.hasMore(state); ++n3) {
                layoutPrefetchRegistry.addPosition(this.mLayoutState.mCurrentPosition, this.mPrefetchDistances[n3]);
                object = this.mLayoutState;
                object.mCurrentPosition += this.mLayoutState.mItemDirection;
            }
        }
    }

    @Override
    public int computeHorizontalScrollExtent(RecyclerView.State state) {
        return this.computeScrollExtent(state);
    }

    @Override
    public int computeHorizontalScrollOffset(RecyclerView.State state) {
        return this.computeScrollOffset(state);
    }

    @Override
    public int computeHorizontalScrollRange(RecyclerView.State state) {
        return this.computeScrollRange(state);
    }

    @Override
    public PointF computeScrollVectorForPosition(int n2) {
        n2 = this.calculateScrollDirectionForPosition(n2);
        PointF pointF = new PointF();
        if (n2 == 0) {
            return null;
        }
        if (this.mOrientation == 0) {
            pointF.x = n2;
            pointF.y = 0.0f;
        } else {
            pointF.x = 0.0f;
            pointF.y = n2;
        }
        return pointF;
    }

    @Override
    public int computeVerticalScrollExtent(RecyclerView.State state) {
        return this.computeScrollExtent(state);
    }

    @Override
    public int computeVerticalScrollOffset(RecyclerView.State state) {
        return this.computeScrollOffset(state);
    }

    @Override
    public int computeVerticalScrollRange(RecyclerView.State state) {
        return this.computeScrollRange(state);
    }

    public int[] findFirstCompletelyVisibleItemPositions(int[] object) {
        block5: {
            block4: {
                block3: {
                    if (object != null) break block3;
                    object = new int[this.mSpanCount];
                    break block4;
                }
                if (((int[])object).length < this.mSpanCount) break block5;
            }
            for (int i2 = 0; i2 < this.mSpanCount; ++i2) {
                object[i2] = this.mSpans[i2].findFirstCompletelyVisibleItemPosition();
            }
            return object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Provided int[]'s size must be more than or equal to span count. Expected:");
        stringBuilder.append(this.mSpanCount);
        stringBuilder.append(", array size:");
        stringBuilder.append(((int[])object).length);
        object = new IllegalArgumentException(stringBuilder.toString());
        throw object;
    }

    View findFirstVisibleItemClosestToEnd(boolean bl) {
        int n2 = this.mPrimaryOrientation.getStartAfterPadding();
        int n3 = this.mPrimaryOrientation.getEndAfterPadding();
        View view = null;
        for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
            View view2 = this.getChildAt(i2);
            int n4 = this.mPrimaryOrientation.getDecoratedStart(view2);
            int n5 = this.mPrimaryOrientation.getDecoratedEnd(view2);
            View view3 = view;
            if (n5 > n2) {
                if (n4 >= n3) {
                    view3 = view;
                } else if (n5 > n3 && bl) {
                    view3 = view;
                    if (view == null) {
                        view3 = view2;
                    }
                } else {
                    return view2;
                }
            }
            view = view3;
        }
        return view;
    }

    View findFirstVisibleItemClosestToStart(boolean bl) {
        int n2 = this.mPrimaryOrientation.getStartAfterPadding();
        int n3 = this.mPrimaryOrientation.getEndAfterPadding();
        int n4 = this.getChildCount();
        View view = null;
        for (int i2 = 0; i2 < n4; ++i2) {
            View view2 = this.getChildAt(i2);
            int n5 = this.mPrimaryOrientation.getDecoratedStart(view2);
            View view3 = view;
            if (this.mPrimaryOrientation.getDecoratedEnd(view2) > n2) {
                if (n5 >= n3) {
                    view3 = view;
                } else if (n5 < n2 && bl) {
                    view3 = view;
                    if (view == null) {
                        view3 = view2;
                    }
                } else {
                    return view2;
                }
            }
            view = view3;
        }
        return view;
    }

    int findFirstVisibleItemPositionInt() {
        View view = this.mShouldReverseLayout ? this.findFirstVisibleItemClosestToEnd(true) : this.findFirstVisibleItemClosestToStart(true);
        int n2 = view == null ? -1 : this.getPosition(view);
        return n2;
    }

    public int[] findFirstVisibleItemPositions(int[] object) {
        block5: {
            block4: {
                block3: {
                    if (object != null) break block3;
                    object = new int[this.mSpanCount];
                    break block4;
                }
                if (((int[])object).length < this.mSpanCount) break block5;
            }
            for (int i2 = 0; i2 < this.mSpanCount; ++i2) {
                object[i2] = this.mSpans[i2].findFirstVisibleItemPosition();
            }
            return object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Provided int[]'s size must be more than or equal to span count. Expected:");
        stringBuilder.append(this.mSpanCount);
        stringBuilder.append(", array size:");
        stringBuilder.append(((int[])object).length);
        object = new IllegalArgumentException(stringBuilder.toString());
        throw object;
    }

    public int[] findLastCompletelyVisibleItemPositions(int[] object) {
        block5: {
            block4: {
                block3: {
                    if (object != null) break block3;
                    object = new int[this.mSpanCount];
                    break block4;
                }
                if (((int[])object).length < this.mSpanCount) break block5;
            }
            for (int i2 = 0; i2 < this.mSpanCount; ++i2) {
                object[i2] = this.mSpans[i2].findLastCompletelyVisibleItemPosition();
            }
            return object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Provided int[]'s size must be more than or equal to span count. Expected:");
        stringBuilder.append(this.mSpanCount);
        stringBuilder.append(", array size:");
        stringBuilder.append(((int[])object).length);
        object = new IllegalArgumentException(stringBuilder.toString());
        throw object;
    }

    public int[] findLastVisibleItemPositions(int[] object) {
        block5: {
            block4: {
                block3: {
                    if (object != null) break block3;
                    object = new int[this.mSpanCount];
                    break block4;
                }
                if (((int[])object).length < this.mSpanCount) break block5;
            }
            for (int i2 = 0; i2 < this.mSpanCount; ++i2) {
                object[i2] = this.mSpans[i2].findLastVisibleItemPosition();
            }
            return object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Provided int[]'s size must be more than or equal to span count. Expected:");
        stringBuilder.append(this.mSpanCount);
        stringBuilder.append(", array size:");
        stringBuilder.append(((int[])object).length);
        object = new IllegalArgumentException(stringBuilder.toString());
        throw object;
    }

    @Override
    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        if (this.mOrientation == 0) {
            return new LayoutParams(-2, -1);
        }
        return new LayoutParams(-1, -2);
    }

    @Override
    public RecyclerView.LayoutParams generateLayoutParams(Context context, AttributeSet attributeSet) {
        return new LayoutParams(context, attributeSet);
    }

    @Override
    public RecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    @Override
    public int getColumnCountForAccessibility(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            return this.mSpanCount;
        }
        return super.getColumnCountForAccessibility(recycler, state);
    }

    int getFirstChildPosition() {
        int n2 = this.getChildCount();
        int n3 = 0;
        if (n2 != 0) {
            n3 = this.getPosition(this.getChildAt(0));
        }
        return n3;
    }

    public int getGapStrategy() {
        return this.mGapStrategy;
    }

    int getLastChildPosition() {
        int n2 = this.getChildCount();
        n2 = n2 == 0 ? 0 : this.getPosition(this.getChildAt(n2 - 1));
        return n2;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public boolean getReverseLayout() {
        return this.mReverseLayout;
    }

    @Override
    public int getRowCountForAccessibility(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 0) {
            return this.mSpanCount;
        }
        return super.getRowCountForAccessibility(recycler, state);
    }

    public int getSpanCount() {
        return this.mSpanCount;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    View hasGapsToFix() {
        var1_1 = this.getChildCount() - 1;
        var2_2 = new BitSet(this.mSpanCount);
        var2_2.set(0, this.mSpanCount, true);
        var3_3 = this.mOrientation;
        var4_4 = -1;
        var3_3 = var3_3 == 1 && this.isLayoutRTL() != false ? 1 : -1;
        if (this.mShouldReverseLayout) {
            var5_5 = -1;
        } else {
            var5_5 = var1_1 + 1;
            var1_1 = 0;
        }
        var6_6 = var1_1;
        if (var1_1 < var5_5) {
            var4_4 = 1;
            var6_6 = var1_1;
        }
        while (var6_6 != var5_5) {
            block12: {
                block13: {
                    var7_7 = this.getChildAt(var6_6);
                    var8_8 = (LayoutParams)var7_7.getLayoutParams();
                    if (var2_2.get(var8_8.mSpan.mIndex)) {
                        if (this.checkSpanForGap(var8_8.mSpan)) {
                            return var7_7;
                        }
                        var2_2.clear(var8_8.mSpan.mIndex);
                    }
                    if (var8_8.mFullSpan || (var1_1 = var6_6 + var4_4) == var5_5) break block12;
                    var9_9 /* !! */  = this.getChildAt(var1_1);
                    if (!this.mShouldReverseLayout) break block13;
                    var10_10 = this.mPrimaryOrientation.getDecoratedEnd(var7_7);
                    if (var10_10 < (var1_1 = this.mPrimaryOrientation.getDecoratedEnd(var9_9 /* !! */ ))) {
                        return var7_7;
                    }
                    if (var10_10 != var1_1) ** GOTO lbl-1000
                    ** GOTO lbl-1000
                }
                var1_1 = this.mPrimaryOrientation.getDecoratedStart(var7_7);
                if (var1_1 > (var10_10 = this.mPrimaryOrientation.getDecoratedStart(var9_9 /* !! */ ))) {
                    return var7_7;
                }
                if (var1_1 == var10_10) lbl-1000:
                // 2 sources

                {
                    var1_1 = 1;
                } else lbl-1000:
                // 2 sources

                {
                    var1_1 = 0;
                }
                if (var1_1 != 0) {
                    var9_9 /* !! */  = (LayoutParams)var9_9 /* !! */ .getLayoutParams();
                    var1_1 = var8_8.mSpan.mIndex - var9_9 /* !! */ .mSpan.mIndex < 0 ? 1 : 0;
                    if (var1_1 != (var10_10 = var3_3 < 0 ? 1 : 0)) {
                        return var7_7;
                    }
                }
            }
            var6_6 += var4_4;
        }
        return null;
    }

    public void invalidateSpanAssignments() {
        this.mLazySpanLookup.clear();
        this.requestLayout();
    }

    @Override
    public boolean isAutoMeasureEnabled() {
        boolean bl = this.mGapStrategy != 0;
        return bl;
    }

    boolean isLayoutRTL() {
        int n2 = this.getLayoutDirection();
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void offsetChildrenHorizontal(int n2) {
        super.offsetChildrenHorizontal(n2);
        for (int i2 = 0; i2 < this.mSpanCount; ++i2) {
            this.mSpans[i2].onOffset(n2);
        }
    }

    @Override
    public void offsetChildrenVertical(int n2) {
        super.offsetChildrenVertical(n2);
        for (int i2 = 0; i2 < this.mSpanCount; ++i2) {
            this.mSpans[i2].onOffset(n2);
        }
    }

    @Override
    public void onDetachedFromWindow(RecyclerView recyclerView, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(recyclerView, recycler);
        this.removeCallbacks(this.mCheckForGapsRunnable);
        for (int i2 = 0; i2 < this.mSpanCount; ++i2) {
            this.mSpans[i2].clear();
        }
        recyclerView.requestLayout();
    }

    @Override
    public View onFocusSearchFailed(View view, int n2, RecyclerView.Recycler recycler, RecyclerView.State state) {
        int n3;
        if (this.getChildCount() == 0) {
            return null;
        }
        if ((view = this.findContainingItemView(view)) == null) {
            return null;
        }
        this.resolveShouldLayoutReverse();
        int n4 = this.convertFocusDirectionToLayoutDirection(n2);
        if (n4 == Integer.MIN_VALUE) {
            return null;
        }
        Object object = (LayoutParams)view.getLayoutParams();
        boolean bl = ((LayoutParams)((Object)object)).mFullSpan;
        object = ((LayoutParams)((Object)object)).mSpan;
        n2 = n4 == 1 ? this.getLastChildPosition() : this.getFirstChildPosition();
        this.updateLayoutState(n2, state);
        this.setLayoutStateDirection(n4);
        LayoutState layoutState = this.mLayoutState;
        layoutState.mCurrentPosition = layoutState.mItemDirection + n2;
        this.mLayoutState.mAvailable = (int)((float)this.mPrimaryOrientation.getTotalSpace() * 0.33333334f);
        layoutState = this.mLayoutState;
        layoutState.mStopInFocusable = true;
        int n5 = 0;
        layoutState.mRecycle = false;
        this.fill(recycler, layoutState, state);
        this.mLastLayoutFromEnd = this.mShouldReverseLayout;
        if (!bl && (recycler = ((Span)object).getFocusableViewAfter(n2, n4)) != null && recycler != view) {
            return recycler;
        }
        if (this.preferLastSpan(n4)) {
            for (n3 = this.mSpanCount - 1; n3 >= 0; --n3) {
                recycler = this.mSpans[n3].getFocusableViewAfter(n2, n4);
                if (recycler == null || recycler == view) continue;
                return recycler;
            }
        } else {
            for (n3 = 0; n3 < this.mSpanCount; ++n3) {
                recycler = this.mSpans[n3].getFocusableViewAfter(n2, n4);
                if (recycler == null || recycler == view) continue;
                return recycler;
            }
        }
        int n6 = this.mReverseLayout;
        n2 = n4 == -1 ? 1 : 0;
        n2 = (n6 ^ 1) == n2 ? 1 : 0;
        if (!bl && (recycler = this.findViewByPosition(n3 = n2 != 0 ? ((Span)object).findFirstPartiallyVisibleItemPosition() : ((Span)object).findLastPartiallyVisibleItemPosition())) != null && recycler != view) {
            return recycler;
        }
        if (this.preferLastSpan(n4)) {
            for (n3 = this.mSpanCount - 1; n3 >= 0; --n3) {
                if (n3 == ((Span)object).mIndex || (recycler = this.findViewByPosition(n5 = n2 != 0 ? this.mSpans[n3].findFirstPartiallyVisibleItemPosition() : this.mSpans[n3].findLastPartiallyVisibleItemPosition())) == null || recycler == view) continue;
                return recycler;
            }
        } else {
            for (n3 = n5; n3 < this.mSpanCount; ++n3) {
                n5 = n2 != 0 ? this.mSpans[n3].findFirstPartiallyVisibleItemPosition() : this.mSpans[n3].findLastPartiallyVisibleItemPosition();
                recycler = this.findViewByPosition(n5);
                if (recycler == null || recycler == view) continue;
                return recycler;
            }
        }
        return null;
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        if (this.getChildCount() > 0) {
            View view = this.findFirstVisibleItemClosestToStart(false);
            View view2 = this.findFirstVisibleItemClosestToEnd(false);
            if (view != null && view2 != null) {
                int n2;
                int n3 = this.getPosition(view);
                if (n3 < (n2 = this.getPosition(view2))) {
                    accessibilityEvent.setFromIndex(n3);
                    accessibilityEvent.setToIndex(n2);
                } else {
                    accessibilityEvent.setFromIndex(n2);
                    accessibilityEvent.setToIndex(n3);
                }
            }
        }
    }

    @Override
    public void onInitializeAccessibilityNodeInfoForItem(RecyclerView.Recycler object, RecyclerView.State state, View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
        object = view.getLayoutParams();
        if (!(object instanceof LayoutParams)) {
            super.onInitializeAccessibilityNodeInfoForItem(view, accessibilityNodeInfoCompat);
            return;
        }
        object = (LayoutParams)((Object)object);
        if (this.mOrientation == 0) {
            int n2 = ((LayoutParams)((Object)object)).getSpanIndex();
            int n3 = ((LayoutParams)((Object)object)).mFullSpan ? this.mSpanCount : 1;
            accessibilityNodeInfoCompat.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)n2, (int)n3, (int)-1, (int)-1, (boolean)false, (boolean)false));
        } else {
            int n4 = ((LayoutParams)((Object)object)).getSpanIndex();
            int n5 = ((LayoutParams)((Object)object)).mFullSpan ? this.mSpanCount : 1;
            accessibilityNodeInfoCompat.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)-1, (int)-1, (int)n4, (int)n5, (boolean)false, (boolean)false));
        }
    }

    @Override
    public void onItemsAdded(RecyclerView recyclerView, int n2, int n3) {
        this.handleUpdate(n2, n3, 1);
    }

    @Override
    public void onItemsChanged(RecyclerView recyclerView) {
        this.mLazySpanLookup.clear();
        this.requestLayout();
    }

    @Override
    public void onItemsMoved(RecyclerView recyclerView, int n2, int n3, int n4) {
        this.handleUpdate(n2, n3, 8);
    }

    @Override
    public void onItemsRemoved(RecyclerView recyclerView, int n2, int n3) {
        this.handleUpdate(n2, n3, 2);
    }

    @Override
    public void onItemsUpdated(RecyclerView recyclerView, int n2, int n3, Object object) {
        this.handleUpdate(n2, n3, 4);
    }

    @Override
    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.onLayoutChildren(recycler, state, true);
    }

    @Override
    public void onLayoutCompleted(RecyclerView.State state) {
        super.onLayoutCompleted(state);
        this.mPendingScrollPosition = -1;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.mPendingSavedState = null;
        this.mAnchorInfo.reset();
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof SavedState) {
            this.mPendingSavedState = (SavedState)parcelable;
            this.requestLayout();
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        SavedState savedState;
        block11: {
            block7: {
                Object object = this.mPendingSavedState;
                if (object != null) {
                    return new SavedState((SavedState)object);
                }
                savedState = new SavedState();
                savedState.mReverseLayout = this.mReverseLayout;
                savedState.mAnchorLayoutFromEnd = this.mLastLayoutFromEnd;
                savedState.mLastLayoutRTL = this.mLastLayoutRTL;
                object = this.mLazySpanLookup;
                int n2 = 0;
                if (object != null && ((LazySpanLookup)object).mData != null) {
                    savedState.mSpanLookup = this.mLazySpanLookup.mData;
                    savedState.mSpanLookupSize = savedState.mSpanLookup.length;
                    savedState.mFullSpanItems = this.mLazySpanLookup.mFullSpanItems;
                } else {
                    savedState.mSpanLookupSize = 0;
                }
                if (this.getChildCount() <= 0) break block7;
                int n3 = this.mLastLayoutFromEnd ? this.getLastChildPosition() : this.getFirstChildPosition();
                savedState.mAnchorPosition = n3;
                savedState.mVisibleAnchorPosition = this.findFirstVisibleItemPositionInt();
                savedState.mSpanOffsetsSize = n3 = this.mSpanCount;
                savedState.mSpanOffsets = new int[n3];
                while (n2 < this.mSpanCount) {
                    block9: {
                        int n4;
                        block10: {
                            block8: {
                                if (!this.mLastLayoutFromEnd) break block8;
                                n3 = n4 = this.mSpans[n2].getEndLine(Integer.MIN_VALUE);
                                if (n4 == Integer.MIN_VALUE) break block9;
                                n3 = this.mPrimaryOrientation.getEndAfterPadding();
                                break block10;
                            }
                            n3 = n4 = this.mSpans[n2].getStartLine(Integer.MIN_VALUE);
                            if (n4 == Integer.MIN_VALUE) break block9;
                            n3 = this.mPrimaryOrientation.getStartAfterPadding();
                        }
                        n3 = n4 - n3;
                    }
                    savedState.mSpanOffsets[n2] = n3;
                    ++n2;
                }
                break block11;
            }
            savedState.mAnchorPosition = -1;
            savedState.mVisibleAnchorPosition = -1;
            savedState.mSpanOffsetsSize = 0;
        }
        return savedState;
    }

    @Override
    public void onScrollStateChanged(int n2) {
        if (n2 == 0) {
            this.checkForGaps();
        }
    }

    void prepareLayoutStateForDelta(int n2, RecyclerView.State state) {
        int n3;
        int n4;
        if (n2 > 0) {
            n4 = this.getLastChildPosition();
            n3 = 1;
        } else {
            n4 = this.getFirstChildPosition();
            n3 = -1;
        }
        this.mLayoutState.mRecycle = true;
        this.updateLayoutState(n4, state);
        this.setLayoutStateDirection(n3);
        state = this.mLayoutState;
        ((LayoutState)state).mCurrentPosition = n4 + ((LayoutState)state).mItemDirection;
        this.mLayoutState.mAvailable = Math.abs(n2);
    }

    int scrollBy(int n2, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() != 0 && n2 != 0) {
            this.prepareLayoutStateForDelta(n2, state);
            int n3 = this.fill(recycler, this.mLayoutState, state);
            if (this.mLayoutState.mAvailable >= n3) {
                n2 = n2 < 0 ? -n3 : n3;
            }
            this.mPrimaryOrientation.offsetChildren(-n2);
            this.mLastLayoutFromEnd = this.mShouldReverseLayout;
            state = this.mLayoutState;
            ((LayoutState)state).mAvailable = 0;
            this.recycle(recycler, (LayoutState)state);
            return n2;
        }
        return 0;
    }

    @Override
    public int scrollHorizontallyBy(int n2, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.scrollBy(n2, recycler, state);
    }

    @Override
    public void scrollToPosition(int n2) {
        SavedState savedState = this.mPendingSavedState;
        if (savedState != null && savedState.mAnchorPosition != n2) {
            this.mPendingSavedState.invalidateAnchorPositionInfo();
        }
        this.mPendingScrollPosition = n2;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.requestLayout();
    }

    public void scrollToPositionWithOffset(int n2, int n3) {
        SavedState savedState = this.mPendingSavedState;
        if (savedState != null) {
            savedState.invalidateAnchorPositionInfo();
        }
        this.mPendingScrollPosition = n2;
        this.mPendingScrollPositionOffset = n3;
        this.requestLayout();
    }

    @Override
    public int scrollVerticallyBy(int n2, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.scrollBy(n2, recycler, state);
    }

    public void setGapStrategy(int n2) {
        this.assertNotInLayoutOrScroll(null);
        if (n2 == this.mGapStrategy) {
            return;
        }
        if (n2 != 0 && n2 != 2) {
            throw new IllegalArgumentException("invalid gap strategy. Must be GAP_HANDLING_NONE or GAP_HANDLING_MOVE_ITEMS_BETWEEN_SPANS");
        }
        this.mGapStrategy = n2;
        this.requestLayout();
    }

    @Override
    public void setMeasuredDimension(Rect rect, int n2, int n3) {
        int n4 = this.getPaddingLeft() + this.getPaddingRight();
        int n5 = this.getPaddingTop() + this.getPaddingBottom();
        if (this.mOrientation == 1) {
            n3 = StaggeredGridLayoutManager.chooseSize(n3, rect.height() + n5, this.getMinimumHeight());
            n2 = StaggeredGridLayoutManager.chooseSize(n2, this.mSizePerSpan * this.mSpanCount + n4, this.getMinimumWidth());
        } else {
            n2 = StaggeredGridLayoutManager.chooseSize(n2, rect.width() + n4, this.getMinimumWidth());
            n3 = StaggeredGridLayoutManager.chooseSize(n3, this.mSizePerSpan * this.mSpanCount + n5, this.getMinimumHeight());
        }
        this.setMeasuredDimension(n2, n3);
    }

    public void setOrientation(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("invalid orientation.");
        }
        this.assertNotInLayoutOrScroll(null);
        if (n2 == this.mOrientation) {
            return;
        }
        this.mOrientation = n2;
        OrientationHelper orientationHelper = this.mPrimaryOrientation;
        this.mPrimaryOrientation = this.mSecondaryOrientation;
        this.mSecondaryOrientation = orientationHelper;
        this.requestLayout();
    }

    public void setReverseLayout(boolean bl) {
        this.assertNotInLayoutOrScroll(null);
        SavedState savedState = this.mPendingSavedState;
        if (savedState != null && savedState.mReverseLayout != bl) {
            this.mPendingSavedState.mReverseLayout = bl;
        }
        this.mReverseLayout = bl;
        this.requestLayout();
    }

    public void setSpanCount(int n2) {
        this.assertNotInLayoutOrScroll(null);
        if (n2 != this.mSpanCount) {
            this.invalidateSpanAssignments();
            this.mSpanCount = n2;
            this.mRemainingSpans = new BitSet(this.mSpanCount);
            this.mSpans = new Span[this.mSpanCount];
            for (n2 = 0; n2 < this.mSpanCount; ++n2) {
                this.mSpans[n2] = new Span(n2);
            }
            this.requestLayout();
        }
    }

    @Override
    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int n2) {
        recyclerView = new LinearSmoothScroller(recyclerView.getContext());
        recyclerView.setTargetPosition(n2);
        this.startSmoothScroll((RecyclerView.SmoothScroller)((Object)recyclerView));
    }

    @Override
    public boolean supportsPredictiveItemAnimations() {
        boolean bl = this.mPendingSavedState == null;
        return bl;
    }

    boolean updateAnchorFromPendingData(RecyclerView.State object, AnchorInfo anchorInfo) {
        int n2;
        boolean bl = ((RecyclerView.State)object).isPreLayout();
        boolean bl2 = false;
        if (!bl && (n2 = this.mPendingScrollPosition) != -1) {
            if (n2 >= 0 && n2 < ((RecyclerView.State)object).getItemCount()) {
                object = this.mPendingSavedState;
                if (object != null && ((SavedState)object).mAnchorPosition != -1 && this.mPendingSavedState.mSpanOffsetsSize >= 1) {
                    anchorInfo.mOffset = Integer.MIN_VALUE;
                    anchorInfo.mPosition = this.mPendingScrollPosition;
                } else {
                    object = this.findViewByPosition(this.mPendingScrollPosition);
                    if (object != null) {
                        n2 = this.mShouldReverseLayout ? this.getLastChildPosition() : this.getFirstChildPosition();
                        anchorInfo.mPosition = n2;
                        if (this.mPendingScrollPositionOffset != Integer.MIN_VALUE) {
                            anchorInfo.mOffset = anchorInfo.mLayoutFromEnd ? this.mPrimaryOrientation.getEndAfterPadding() - this.mPendingScrollPositionOffset - this.mPrimaryOrientation.getDecoratedEnd((View)object) : this.mPrimaryOrientation.getStartAfterPadding() + this.mPendingScrollPositionOffset - this.mPrimaryOrientation.getDecoratedStart((View)object);
                            return true;
                        }
                        if (this.mPrimaryOrientation.getDecoratedMeasurement((View)object) > this.mPrimaryOrientation.getTotalSpace()) {
                            n2 = anchorInfo.mLayoutFromEnd ? this.mPrimaryOrientation.getEndAfterPadding() : this.mPrimaryOrientation.getStartAfterPadding();
                            anchorInfo.mOffset = n2;
                            return true;
                        }
                        n2 = this.mPrimaryOrientation.getDecoratedStart((View)object) - this.mPrimaryOrientation.getStartAfterPadding();
                        if (n2 < 0) {
                            anchorInfo.mOffset = -n2;
                            return true;
                        }
                        n2 = this.mPrimaryOrientation.getEndAfterPadding() - this.mPrimaryOrientation.getDecoratedEnd((View)object);
                        if (n2 < 0) {
                            anchorInfo.mOffset = n2;
                            return true;
                        }
                        anchorInfo.mOffset = Integer.MIN_VALUE;
                    } else {
                        anchorInfo.mPosition = this.mPendingScrollPosition;
                        n2 = this.mPendingScrollPositionOffset;
                        if (n2 == Integer.MIN_VALUE) {
                            if (this.calculateScrollDirectionForPosition(anchorInfo.mPosition) == 1) {
                                bl2 = true;
                            }
                            anchorInfo.mLayoutFromEnd = bl2;
                            anchorInfo.assignCoordinateFromPadding();
                        } else {
                            anchorInfo.assignCoordinateFromPadding(n2);
                        }
                        anchorInfo.mInvalidateOffsets = true;
                    }
                }
                return true;
            }
            this.mPendingScrollPosition = -1;
            this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        }
        return false;
    }

    void updateAnchorInfoForLayout(RecyclerView.State state, AnchorInfo anchorInfo) {
        if (this.updateAnchorFromPendingData(state, anchorInfo)) {
            return;
        }
        if (this.updateAnchorFromChildren(state, anchorInfo)) {
            return;
        }
        anchorInfo.assignCoordinateFromPadding();
        anchorInfo.mPosition = 0;
    }

    void updateMeasureSpecs(int n2) {
        this.mSizePerSpan = n2 / this.mSpanCount;
        this.mFullSizeSpec = View.MeasureSpec.makeMeasureSpec((int)n2, (int)this.mSecondaryOrientation.getMode());
    }

    class AnchorInfo {
        boolean mInvalidateOffsets;
        boolean mLayoutFromEnd;
        int mOffset;
        int mPosition;
        int[] mSpanReferenceLines;
        boolean mValid;

        AnchorInfo() {
            this.reset();
        }

        void assignCoordinateFromPadding() {
            int n2 = this.mLayoutFromEnd ? StaggeredGridLayoutManager.this.mPrimaryOrientation.getEndAfterPadding() : StaggeredGridLayoutManager.this.mPrimaryOrientation.getStartAfterPadding();
            this.mOffset = n2;
        }

        void assignCoordinateFromPadding(int n2) {
            this.mOffset = this.mLayoutFromEnd ? StaggeredGridLayoutManager.this.mPrimaryOrientation.getEndAfterPadding() - n2 : StaggeredGridLayoutManager.this.mPrimaryOrientation.getStartAfterPadding() + n2;
        }

        void reset() {
            this.mPosition = -1;
            this.mOffset = Integer.MIN_VALUE;
            this.mLayoutFromEnd = false;
            this.mInvalidateOffsets = false;
            this.mValid = false;
            int[] nArray = this.mSpanReferenceLines;
            if (nArray != null) {
                Arrays.fill(nArray, -1);
            }
        }

        void saveSpanReferenceLines(Span[] spanArray) {
            int n2 = spanArray.length;
            int[] nArray = this.mSpanReferenceLines;
            if (nArray == null || nArray.length < n2) {
                this.mSpanReferenceLines = new int[StaggeredGridLayoutManager.this.mSpans.length];
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mSpanReferenceLines[i2] = spanArray[i2].getStartLine(Integer.MIN_VALUE);
            }
        }
    }

    public static class LayoutParams
    extends RecyclerView.LayoutParams {
        public static final int INVALID_SPAN_ID = -1;
        boolean mFullSpan;
        Span mSpan;

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(RecyclerView.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public final int getSpanIndex() {
            Span span = this.mSpan;
            if (span == null) {
                return -1;
            }
            return span.mIndex;
        }

        public boolean isFullSpan() {
            return this.mFullSpan;
        }

        public void setFullSpan(boolean bl) {
            this.mFullSpan = bl;
        }
    }

    static class LazySpanLookup {
        private static final int MIN_SIZE = 10;
        int[] mData;
        List<FullSpanItem> mFullSpanItems;

        LazySpanLookup() {
        }

        private int invalidateFullSpansAfter(int n2) {
            int n3;
            FullSpanItem fullSpanItem;
            block5: {
                if (this.mFullSpanItems == null) {
                    return -1;
                }
                fullSpanItem = this.getFullSpanItem(n2);
                if (fullSpanItem != null) {
                    this.mFullSpanItems.remove(fullSpanItem);
                }
                int n4 = this.mFullSpanItems.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    if (this.mFullSpanItems.get((int)n3).mPosition < n2) {
                        continue;
                    }
                    break block5;
                }
                n3 = -1;
            }
            if (n3 != -1) {
                fullSpanItem = this.mFullSpanItems.get(n3);
                this.mFullSpanItems.remove(n3);
                return fullSpanItem.mPosition;
            }
            return -1;
        }

        private void offsetFullSpansForAddition(int n2, int n3) {
            List<FullSpanItem> list = this.mFullSpanItems;
            if (list == null) {
                return;
            }
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                list = this.mFullSpanItems.get(i2);
                if (((FullSpanItem)((Object)list)).mPosition < n2) continue;
                ((FullSpanItem)((Object)list)).mPosition += n3;
            }
        }

        private void offsetFullSpansForRemoval(int n2, int n3) {
            List<FullSpanItem> list = this.mFullSpanItems;
            if (list == null) {
                return;
            }
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                list = this.mFullSpanItems.get(i2);
                if (((FullSpanItem)((Object)list)).mPosition < n2) continue;
                if (((FullSpanItem)((Object)list)).mPosition < n2 + n3) {
                    this.mFullSpanItems.remove(i2);
                    continue;
                }
                ((FullSpanItem)((Object)list)).mPosition -= n3;
            }
        }

        public void addFullSpanItem(FullSpanItem fullSpanItem) {
            if (this.mFullSpanItems == null) {
                this.mFullSpanItems = new ArrayList<FullSpanItem>();
            }
            int n2 = this.mFullSpanItems.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                FullSpanItem fullSpanItem2 = this.mFullSpanItems.get(i2);
                if (fullSpanItem2.mPosition == fullSpanItem.mPosition) {
                    this.mFullSpanItems.remove(i2);
                }
                if (fullSpanItem2.mPosition < fullSpanItem.mPosition) continue;
                this.mFullSpanItems.add(i2, fullSpanItem);
                return;
            }
            this.mFullSpanItems.add(fullSpanItem);
        }

        void clear() {
            int[] nArray = this.mData;
            if (nArray != null) {
                Arrays.fill(nArray, -1);
            }
            this.mFullSpanItems = null;
        }

        void ensureSize(int n2) {
            int[] nArray = this.mData;
            if (nArray == null) {
                this.mData = new int[Math.max(n2, 10) + 1];
                Arrays.fill(this.mData, -1);
            } else if (n2 >= nArray.length) {
                this.mData = new int[this.sizeForPosition(n2)];
                System.arraycopy(nArray, 0, this.mData, 0, nArray.length);
                int[] nArray2 = this.mData;
                Arrays.fill(nArray2, nArray.length, nArray2.length, -1);
            }
        }

        int forceInvalidateAfter(int n2) {
            List<FullSpanItem> list = this.mFullSpanItems;
            if (list != null) {
                for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                    if (this.mFullSpanItems.get((int)i2).mPosition < n2) continue;
                    this.mFullSpanItems.remove(i2);
                }
            }
            return this.invalidateAfter(n2);
        }

        public FullSpanItem getFirstFullSpanItemInRange(int n2, int n3, int n4, boolean bl) {
            List<FullSpanItem> list = this.mFullSpanItems;
            if (list == null) {
                return null;
            }
            int n5 = list.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                list = this.mFullSpanItems.get(i2);
                if (((FullSpanItem)((Object)list)).mPosition >= n3) {
                    return null;
                }
                if (((FullSpanItem)((Object)list)).mPosition < n2 || n4 != 0 && ((FullSpanItem)((Object)list)).mGapDir != n4 && (!bl || !((FullSpanItem)((Object)list)).mHasUnwantedGapAfter)) continue;
                return list;
            }
            return null;
        }

        public FullSpanItem getFullSpanItem(int n2) {
            List<FullSpanItem> list = this.mFullSpanItems;
            if (list == null) {
                return null;
            }
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                list = this.mFullSpanItems.get(i2);
                if (((FullSpanItem)((Object)list)).mPosition != n2) continue;
                return list;
            }
            return null;
        }

        int getSpan(int n2) {
            int[] nArray = this.mData;
            if (nArray != null && n2 < nArray.length) {
                return nArray[n2];
            }
            return -1;
        }

        int invalidateAfter(int n2) {
            int[] nArray = this.mData;
            if (nArray == null) {
                return -1;
            }
            if (n2 >= nArray.length) {
                return -1;
            }
            int n3 = this.invalidateFullSpansAfter(n2);
            if (n3 == -1) {
                nArray = this.mData;
                Arrays.fill(nArray, n2, nArray.length, -1);
                return this.mData.length;
            }
            nArray = this.mData;
            Arrays.fill(nArray, n2, ++n3, -1);
            return n3;
        }

        void offsetForAddition(int n2, int n3) {
            int[] nArray = this.mData;
            if (nArray != null && n2 < nArray.length) {
                int n4 = n2 + n3;
                this.ensureSize(n4);
                nArray = this.mData;
                System.arraycopy(nArray, n2, nArray, n4, nArray.length - n2 - n3);
                Arrays.fill(this.mData, n2, n4, -1);
                this.offsetFullSpansForAddition(n2, n3);
            }
        }

        void offsetForRemoval(int n2, int n3) {
            int[] nArray = this.mData;
            if (nArray != null && n2 < nArray.length) {
                int n4 = n2 + n3;
                this.ensureSize(n4);
                nArray = this.mData;
                System.arraycopy(nArray, n4, nArray, n2, nArray.length - n2 - n3);
                nArray = this.mData;
                Arrays.fill(nArray, nArray.length - n3, nArray.length, -1);
                this.offsetFullSpansForRemoval(n2, n3);
            }
        }

        void setSpan(int n2, Span span) {
            this.ensureSize(n2);
            this.mData[n2] = span.mIndex;
        }

        int sizeForPosition(int n2) {
            int n3;
            for (n3 = this.mData.length; n3 <= n2; n3 *= 2) {
            }
            return n3;
        }

        static class FullSpanItem
        implements Parcelable {
            public static final Parcelable.Creator<FullSpanItem> CREATOR = new Parcelable.Creator<FullSpanItem>(){

                public FullSpanItem createFromParcel(Parcel parcel) {
                    return new FullSpanItem(parcel);
                }

                public FullSpanItem[] newArray(int n2) {
                    return new FullSpanItem[n2];
                }
            };
            int mGapDir;
            int[] mGapPerSpan;
            boolean mHasUnwantedGapAfter;
            int mPosition;

            FullSpanItem() {
            }

            FullSpanItem(Parcel parcel) {
                this.mPosition = parcel.readInt();
                this.mGapDir = parcel.readInt();
                int n2 = parcel.readInt();
                boolean bl = true;
                if (n2 != 1) {
                    bl = false;
                }
                this.mHasUnwantedGapAfter = bl;
                n2 = parcel.readInt();
                if (n2 > 0) {
                    this.mGapPerSpan = new int[n2];
                    parcel.readIntArray(this.mGapPerSpan);
                }
            }

            public int describeContents() {
                return 0;
            }

            int getGapForSpan(int n2) {
                int[] nArray = this.mGapPerSpan;
                n2 = nArray == null ? 0 : nArray[n2];
                return n2;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("FullSpanItem{mPosition=");
                stringBuilder.append(this.mPosition);
                stringBuilder.append(", mGapDir=");
                stringBuilder.append(this.mGapDir);
                stringBuilder.append(", mHasUnwantedGapAfter=");
                stringBuilder.append(this.mHasUnwantedGapAfter);
                stringBuilder.append(", mGapPerSpan=");
                stringBuilder.append(Arrays.toString(this.mGapPerSpan));
                stringBuilder.append('}');
                return stringBuilder.toString();
            }

            public void writeToParcel(Parcel parcel, int n2) {
                parcel.writeInt(this.mPosition);
                parcel.writeInt(this.mGapDir);
                parcel.writeInt(this.mHasUnwantedGapAfter ? 1 : 0);
                int[] nArray = this.mGapPerSpan;
                if (nArray != null && nArray.length > 0) {
                    parcel.writeInt(nArray.length);
                    parcel.writeIntArray(this.mGapPerSpan);
                } else {
                    parcel.writeInt(0);
                }
            }
        }
    }

    public static class SavedState
    implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        boolean mAnchorLayoutFromEnd;
        int mAnchorPosition;
        List<LazySpanLookup.FullSpanItem> mFullSpanItems;
        boolean mLastLayoutRTL;
        boolean mReverseLayout;
        int[] mSpanLookup;
        int mSpanLookupSize;
        int[] mSpanOffsets;
        int mSpanOffsetsSize;
        int mVisibleAnchorPosition;

        public SavedState() {
        }

        SavedState(Parcel parcel) {
            this.mAnchorPosition = parcel.readInt();
            this.mVisibleAnchorPosition = parcel.readInt();
            int n2 = this.mSpanOffsetsSize = parcel.readInt();
            if (n2 > 0) {
                this.mSpanOffsets = new int[n2];
                parcel.readIntArray(this.mSpanOffsets);
            }
            if ((n2 = (this.mSpanLookupSize = parcel.readInt())) > 0) {
                this.mSpanLookup = new int[n2];
                parcel.readIntArray(this.mSpanLookup);
            }
            n2 = parcel.readInt();
            boolean bl = false;
            boolean bl2 = n2 == 1;
            this.mReverseLayout = bl2;
            bl2 = parcel.readInt() == 1;
            this.mAnchorLayoutFromEnd = bl2;
            bl2 = bl;
            if (parcel.readInt() == 1) {
                bl2 = true;
            }
            this.mLastLayoutRTL = bl2;
            this.mFullSpanItems = parcel.readArrayList(LazySpanLookup.FullSpanItem.class.getClassLoader());
        }

        public SavedState(SavedState savedState) {
            this.mSpanOffsetsSize = savedState.mSpanOffsetsSize;
            this.mAnchorPosition = savedState.mAnchorPosition;
            this.mVisibleAnchorPosition = savedState.mVisibleAnchorPosition;
            this.mSpanOffsets = savedState.mSpanOffsets;
            this.mSpanLookupSize = savedState.mSpanLookupSize;
            this.mSpanLookup = savedState.mSpanLookup;
            this.mReverseLayout = savedState.mReverseLayout;
            this.mAnchorLayoutFromEnd = savedState.mAnchorLayoutFromEnd;
            this.mLastLayoutRTL = savedState.mLastLayoutRTL;
            this.mFullSpanItems = savedState.mFullSpanItems;
        }

        public int describeContents() {
            return 0;
        }

        void invalidateAnchorPositionInfo() {
            this.mSpanOffsets = null;
            this.mSpanOffsetsSize = 0;
            this.mAnchorPosition = -1;
            this.mVisibleAnchorPosition = -1;
        }

        void invalidateSpanInfo() {
            this.mSpanOffsets = null;
            this.mSpanOffsetsSize = 0;
            this.mSpanLookupSize = 0;
            this.mSpanLookup = null;
            this.mFullSpanItems = null;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeInt(this.mAnchorPosition);
            parcel.writeInt(this.mVisibleAnchorPosition);
            parcel.writeInt(this.mSpanOffsetsSize);
            if (this.mSpanOffsetsSize > 0) {
                parcel.writeIntArray(this.mSpanOffsets);
            }
            parcel.writeInt(this.mSpanLookupSize);
            if (this.mSpanLookupSize > 0) {
                parcel.writeIntArray(this.mSpanLookup);
            }
            parcel.writeInt(this.mReverseLayout ? 1 : 0);
            parcel.writeInt(this.mAnchorLayoutFromEnd ? 1 : 0);
            parcel.writeInt(this.mLastLayoutRTL ? 1 : 0);
            parcel.writeList(this.mFullSpanItems);
        }
    }

    class Span {
        static final int INVALID_LINE = Integer.MIN_VALUE;
        int mCachedEnd;
        int mCachedStart;
        int mDeletedSize = 0;
        final int mIndex;
        ArrayList<View> mViews = new ArrayList();

        Span(int n2) {
            this.mCachedStart = Integer.MIN_VALUE;
            this.mCachedEnd = Integer.MIN_VALUE;
            this.mIndex = n2;
        }

        void appendToSpan(View view) {
            LayoutParams layoutParams = this.getLayoutParams(view);
            layoutParams.mSpan = this;
            this.mViews.add(view);
            this.mCachedEnd = Integer.MIN_VALUE;
            if (this.mViews.size() == 1) {
                this.mCachedStart = Integer.MIN_VALUE;
            }
            if (layoutParams.isItemRemoved() || layoutParams.isItemChanged()) {
                this.mDeletedSize += StaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedMeasurement(view);
            }
        }

        void cacheReferenceLineAndClear(boolean bl, int n2) {
            int n3 = bl ? this.getEndLine(Integer.MIN_VALUE) : this.getStartLine(Integer.MIN_VALUE);
            this.clear();
            if (n3 == Integer.MIN_VALUE) {
                return;
            }
            if (bl && n3 < StaggeredGridLayoutManager.this.mPrimaryOrientation.getEndAfterPadding() || !bl && n3 > StaggeredGridLayoutManager.this.mPrimaryOrientation.getStartAfterPadding()) {
                return;
            }
            int n4 = n3;
            if (n2 != Integer.MIN_VALUE) {
                n4 = n3 + n2;
            }
            this.mCachedEnd = n4;
            this.mCachedStart = n4;
        }

        void calculateCachedEnd() {
            Object object = this.mViews;
            View view = ((ArrayList)object).get(((ArrayList)object).size() - 1);
            object = this.getLayoutParams(view);
            this.mCachedEnd = StaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedEnd(view);
            if (((LayoutParams)((Object)object)).mFullSpan && (object = StaggeredGridLayoutManager.this.mLazySpanLookup.getFullSpanItem(((RecyclerView.LayoutParams)((Object)object)).getViewLayoutPosition())) != null && ((LazySpanLookup.FullSpanItem)object).mGapDir == 1) {
                this.mCachedEnd += ((LazySpanLookup.FullSpanItem)object).getGapForSpan(this.mIndex);
            }
        }

        void calculateCachedStart() {
            View view = this.mViews.get(0);
            Object object = this.getLayoutParams(view);
            this.mCachedStart = StaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedStart(view);
            if (((LayoutParams)((Object)object)).mFullSpan && (object = StaggeredGridLayoutManager.this.mLazySpanLookup.getFullSpanItem(((RecyclerView.LayoutParams)((Object)object)).getViewLayoutPosition())) != null && ((LazySpanLookup.FullSpanItem)object).mGapDir == -1) {
                this.mCachedStart -= ((LazySpanLookup.FullSpanItem)object).getGapForSpan(this.mIndex);
            }
        }

        void clear() {
            this.mViews.clear();
            this.invalidateCache();
            this.mDeletedSize = 0;
        }

        public int findFirstCompletelyVisibleItemPosition() {
            int n2 = StaggeredGridLayoutManager.this.mReverseLayout ? this.findOneVisibleChild(this.mViews.size() - 1, -1, true) : this.findOneVisibleChild(0, this.mViews.size(), true);
            return n2;
        }

        public int findFirstPartiallyVisibleItemPosition() {
            int n2 = StaggeredGridLayoutManager.this.mReverseLayout ? this.findOnePartiallyVisibleChild(this.mViews.size() - 1, -1, true) : this.findOnePartiallyVisibleChild(0, this.mViews.size(), true);
            return n2;
        }

        public int findFirstVisibleItemPosition() {
            int n2 = StaggeredGridLayoutManager.this.mReverseLayout ? this.findOneVisibleChild(this.mViews.size() - 1, -1, false) : this.findOneVisibleChild(0, this.mViews.size(), false);
            return n2;
        }

        public int findLastCompletelyVisibleItemPosition() {
            int n2 = StaggeredGridLayoutManager.this.mReverseLayout ? this.findOneVisibleChild(0, this.mViews.size(), true) : this.findOneVisibleChild(this.mViews.size() - 1, -1, true);
            return n2;
        }

        public int findLastPartiallyVisibleItemPosition() {
            int n2 = StaggeredGridLayoutManager.this.mReverseLayout ? this.findOnePartiallyVisibleChild(0, this.mViews.size(), true) : this.findOnePartiallyVisibleChild(this.mViews.size() - 1, -1, true);
            return n2;
        }

        public int findLastVisibleItemPosition() {
            int n2 = StaggeredGridLayoutManager.this.mReverseLayout ? this.findOneVisibleChild(0, this.mViews.size(), false) : this.findOneVisibleChild(this.mViews.size() - 1, -1, false);
            return n2;
        }

        int findOnePartiallyOrCompletelyVisibleChild(int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
            int n4 = StaggeredGridLayoutManager.this.mPrimaryOrientation.getStartAfterPadding();
            int n5 = StaggeredGridLayoutManager.this.mPrimaryOrientation.getEndAfterPadding();
            int n6 = n3 > n2 ? 1 : -1;
            while (n2 != n3) {
                View view = this.mViews.get(n2);
                int n7 = StaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedStart(view);
                int n8 = StaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedEnd(view);
                boolean bl4 = false;
                boolean bl5 = bl3 ? n7 <= n5 : n7 < n5;
                if (bl3 ? n8 >= n4 : n8 > n4) {
                    bl4 = true;
                }
                if (bl5 && bl4) {
                    if (bl && bl2) {
                        if (n7 >= n4 && n8 <= n5) {
                            return StaggeredGridLayoutManager.this.getPosition(view);
                        }
                    } else {
                        if (bl2) {
                            return StaggeredGridLayoutManager.this.getPosition(view);
                        }
                        if (n7 < n4 || n8 > n5) {
                            return StaggeredGridLayoutManager.this.getPosition(view);
                        }
                    }
                }
                n2 += n6;
            }
            return -1;
        }

        int findOnePartiallyVisibleChild(int n2, int n3, boolean bl) {
            return this.findOnePartiallyOrCompletelyVisibleChild(n2, n3, false, false, bl);
        }

        int findOneVisibleChild(int n2, int n3, boolean bl) {
            return this.findOnePartiallyOrCompletelyVisibleChild(n2, n3, bl, true, false);
        }

        public int getDeletedSize() {
            return this.mDeletedSize;
        }

        int getEndLine() {
            int n2 = this.mCachedEnd;
            if (n2 != Integer.MIN_VALUE) {
                return n2;
            }
            this.calculateCachedEnd();
            return this.mCachedEnd;
        }

        int getEndLine(int n2) {
            int n3 = this.mCachedEnd;
            if (n3 != Integer.MIN_VALUE) {
                return n3;
            }
            if (this.mViews.size() == 0) {
                return n2;
            }
            this.calculateCachedEnd();
            return this.mCachedEnd;
        }

        public View getFocusableViewAfter(int n2, int n3) {
            View view;
            block10: {
                view = null;
                View view2 = null;
                if (n3 == -1) {
                    int n4 = this.mViews.size();
                    n3 = 0;
                    while (true) {
                        view = view2;
                        if (n3 >= n4) break block10;
                        View view3 = this.mViews.get(n3);
                        if (StaggeredGridLayoutManager.this.mReverseLayout) {
                            view = view2;
                            if (StaggeredGridLayoutManager.this.getPosition(view3) <= n2) break block10;
                        }
                        if (!StaggeredGridLayoutManager.this.mReverseLayout && StaggeredGridLayoutManager.this.getPosition(view3) >= n2) {
                            view = view2;
                        } else {
                            view = view2;
                            if (view3.hasFocusable()) {
                                ++n3;
                                view2 = view3;
                                continue;
                            }
                        }
                        break block10;
                        break;
                    }
                }
                n3 = this.mViews.size() - 1;
                view2 = view;
                while (true) {
                    view = view2;
                    if (n3 < 0) break;
                    View view4 = this.mViews.get(n3);
                    if (StaggeredGridLayoutManager.this.mReverseLayout) {
                        view = view2;
                        if (StaggeredGridLayoutManager.this.getPosition(view4) >= n2) break;
                    }
                    if (!StaggeredGridLayoutManager.this.mReverseLayout && StaggeredGridLayoutManager.this.getPosition(view4) <= n2) {
                        view = view2;
                        break;
                    }
                    view = view2;
                    if (!view4.hasFocusable()) break;
                    --n3;
                    view2 = view4;
                }
            }
            return view;
        }

        LayoutParams getLayoutParams(View view) {
            return (LayoutParams)view.getLayoutParams();
        }

        int getStartLine() {
            int n2 = this.mCachedStart;
            if (n2 != Integer.MIN_VALUE) {
                return n2;
            }
            this.calculateCachedStart();
            return this.mCachedStart;
        }

        int getStartLine(int n2) {
            int n3 = this.mCachedStart;
            if (n3 != Integer.MIN_VALUE) {
                return n3;
            }
            if (this.mViews.size() == 0) {
                return n2;
            }
            this.calculateCachedStart();
            return this.mCachedStart;
        }

        void invalidateCache() {
            this.mCachedStart = Integer.MIN_VALUE;
            this.mCachedEnd = Integer.MIN_VALUE;
        }

        void onOffset(int n2) {
            int n3 = this.mCachedStart;
            if (n3 != Integer.MIN_VALUE) {
                this.mCachedStart = n3 + n2;
            }
            if ((n3 = this.mCachedEnd) != Integer.MIN_VALUE) {
                this.mCachedEnd = n3 + n2;
            }
        }

        void popEnd() {
            int n2 = this.mViews.size();
            View view = this.mViews.remove(n2 - 1);
            LayoutParams layoutParams = this.getLayoutParams(view);
            layoutParams.mSpan = null;
            if (layoutParams.isItemRemoved() || layoutParams.isItemChanged()) {
                this.mDeletedSize -= StaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedMeasurement(view);
            }
            if (n2 == 1) {
                this.mCachedStart = Integer.MIN_VALUE;
            }
            this.mCachedEnd = Integer.MIN_VALUE;
        }

        void popStart() {
            View view = this.mViews.remove(0);
            LayoutParams layoutParams = this.getLayoutParams(view);
            layoutParams.mSpan = null;
            if (this.mViews.size() == 0) {
                this.mCachedEnd = Integer.MIN_VALUE;
            }
            if (layoutParams.isItemRemoved() || layoutParams.isItemChanged()) {
                this.mDeletedSize -= StaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedMeasurement(view);
            }
            this.mCachedStart = Integer.MIN_VALUE;
        }

        void prependToSpan(View view) {
            LayoutParams layoutParams = this.getLayoutParams(view);
            layoutParams.mSpan = this;
            this.mViews.add(0, view);
            this.mCachedStart = Integer.MIN_VALUE;
            if (this.mViews.size() == 1) {
                this.mCachedEnd = Integer.MIN_VALUE;
            }
            if (layoutParams.isItemRemoved() || layoutParams.isItemChanged()) {
                this.mDeletedSize += StaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedMeasurement(view);
            }
        }

        void setLine(int n2) {
            this.mCachedStart = n2;
            this.mCachedEnd = n2;
        }
    }
}

