/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.Observable;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.FocusFinder;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Interpolator;
import android.widget.EdgeEffect;
import android.widget.OverScroller;
import androidx.core.os.TraceCompat;
import androidx.core.util.Preconditions;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.MotionEventCompat;
import androidx.core.view.NestedScrollingChild2;
import androidx.core.view.NestedScrollingChild3;
import androidx.core.view.NestedScrollingChildHelper;
import androidx.core.view.ScrollingView;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewConfigurationCompat;
import androidx.core.view.accessibility.AccessibilityEventCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.EdgeEffectCompat;
import androidx.customview.view.AbsSavedState;
import androidx.recyclerview.R;
import androidx.recyclerview.widget.AdapterHelper;
import androidx.recyclerview.widget.ChildHelper;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.FastScroller;
import androidx.recyclerview.widget.GapWorker;
import androidx.recyclerview.widget.RecyclerViewAccessibilityDelegate;
import androidx.recyclerview.widget.ViewBoundsCheck;
import androidx.recyclerview.widget.ViewInfoStore;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RecyclerView
extends ViewGroup
implements ScrollingView,
NestedScrollingChild2,
NestedScrollingChild3 {
    static final boolean ALLOW_SIZE_IN_UNSPECIFIED_SPEC;
    static final boolean ALLOW_THREAD_GAP_WORK;
    static final boolean DEBUG = false;
    static final int DEFAULT_ORIENTATION = 1;
    static final boolean DISPATCH_TEMP_DETACH = false;
    private static final boolean FORCE_ABS_FOCUS_SEARCH_DIRECTION;
    static final boolean FORCE_INVALIDATE_DISPLAY_LIST;
    static final long FOREVER_NS = Long.MAX_VALUE;
    public static final int HORIZONTAL = 0;
    private static final boolean IGNORE_DETACHED_FOCUSED_CHILD;
    private static final int INVALID_POINTER = -1;
    public static final int INVALID_TYPE = -1;
    private static final Class<?>[] LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE;
    static final int MAX_SCROLL_DURATION = 2000;
    private static final int[] NESTED_SCROLLING_ATTRS;
    public static final long NO_ID = -1L;
    public static final int NO_POSITION = -1;
    static final boolean POST_UPDATES_ON_ANIMATION;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_SETTLING = 2;
    static final String TAG = "RecyclerView";
    public static final int TOUCH_SLOP_DEFAULT = 0;
    public static final int TOUCH_SLOP_PAGING = 1;
    static final String TRACE_BIND_VIEW_TAG = "RV OnBindView";
    static final String TRACE_CREATE_VIEW_TAG = "RV CreateView";
    private static final String TRACE_HANDLE_ADAPTER_UPDATES_TAG = "RV PartialInvalidate";
    static final String TRACE_NESTED_PREFETCH_TAG = "RV Nested Prefetch";
    private static final String TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG = "RV FullInvalidate";
    private static final String TRACE_ON_LAYOUT_TAG = "RV OnLayout";
    static final String TRACE_PREFETCH_TAG = "RV Prefetch";
    static final String TRACE_SCROLL_TAG = "RV Scroll";
    public static final int UNDEFINED_DURATION = Integer.MIN_VALUE;
    static final boolean VERBOSE_TRACING = false;
    public static final int VERTICAL = 1;
    static final Interpolator sQuinticInterpolator;
    RecyclerViewAccessibilityDelegate mAccessibilityDelegate;
    private final AccessibilityManager mAccessibilityManager;
    Adapter mAdapter;
    AdapterHelper mAdapterHelper;
    boolean mAdapterUpdateDuringMeasure;
    private EdgeEffect mBottomGlow;
    private ChildDrawingOrderCallback mChildDrawingOrderCallback;
    ChildHelper mChildHelper;
    boolean mClipToPadding;
    boolean mDataSetHasChangedAfterLayout = false;
    boolean mDispatchItemsChangedEvent = false;
    private int mDispatchScrollCounter = 0;
    private int mEatenAccessibilityChangeFlags;
    private EdgeEffectFactory mEdgeEffectFactory;
    boolean mEnableFastScroller;
    boolean mFirstLayoutComplete;
    GapWorker mGapWorker;
    boolean mHasFixedSize;
    private boolean mIgnoreMotionEventTillDown;
    private int mInitialTouchX;
    private int mInitialTouchY;
    private int mInterceptRequestLayoutDepth = 0;
    private OnItemTouchListener mInterceptingOnItemTouchListener;
    boolean mIsAttached;
    ItemAnimator mItemAnimator;
    private ItemAnimator.ItemAnimatorListener mItemAnimatorListener;
    private Runnable mItemAnimatorRunner;
    final ArrayList<ItemDecoration> mItemDecorations;
    boolean mItemsAddedOrRemoved;
    boolean mItemsChanged;
    private int mLastTouchX;
    private int mLastTouchY;
    LayoutManager mLayout;
    private int mLayoutOrScrollCounter = 0;
    boolean mLayoutSuppressed;
    boolean mLayoutWasDefered;
    private EdgeEffect mLeftGlow;
    private final int mMaxFlingVelocity;
    private final int mMinFlingVelocity;
    private final int[] mMinMaxLayoutPositions;
    private final int[] mNestedOffsets;
    private final RecyclerViewDataObserver mObserver = new RecyclerViewDataObserver();
    private List<OnChildAttachStateChangeListener> mOnChildAttachStateListeners;
    private OnFlingListener mOnFlingListener;
    private final ArrayList<OnItemTouchListener> mOnItemTouchListeners;
    final List<ViewHolder> mPendingAccessibilityImportanceChange;
    private SavedState mPendingSavedState;
    boolean mPostedAnimatorRunner;
    GapWorker.LayoutPrefetchRegistryImpl mPrefetchRegistry;
    private boolean mPreserveFocusAfterLayout;
    final Recycler mRecycler = new Recycler();
    RecyclerListener mRecyclerListener;
    final int[] mReusableIntPair;
    private EdgeEffect mRightGlow;
    private float mScaledHorizontalScrollFactor;
    private float mScaledVerticalScrollFactor;
    private OnScrollListener mScrollListener;
    private List<OnScrollListener> mScrollListeners;
    private final int[] mScrollOffset;
    private int mScrollPointerId = -1;
    private int mScrollState = 0;
    private NestedScrollingChildHelper mScrollingChildHelper;
    final State mState;
    final Rect mTempRect;
    private final Rect mTempRect2;
    final RectF mTempRectF;
    private EdgeEffect mTopGlow;
    private int mTouchSlop;
    final Runnable mUpdateChildViewsRunnable;
    private VelocityTracker mVelocityTracker;
    final ViewFlinger mViewFlinger;
    private final ViewInfoStore.ProcessCallback mViewInfoProcessCallback;
    final ViewInfoStore mViewInfoStore = new ViewInfoStore();

    static {
        NESTED_SCROLLING_ATTRS = new int[]{16843830};
        boolean bl = Build.VERSION.SDK_INT == 18 || Build.VERSION.SDK_INT == 19 || Build.VERSION.SDK_INT == 20;
        FORCE_INVALIDATE_DISPLAY_LIST = bl;
        bl = Build.VERSION.SDK_INT >= 23;
        ALLOW_SIZE_IN_UNSPECIFIED_SPEC = bl;
        bl = Build.VERSION.SDK_INT >= 16;
        POST_UPDATES_ON_ANIMATION = bl;
        bl = Build.VERSION.SDK_INT >= 21;
        ALLOW_THREAD_GAP_WORK = bl;
        bl = Build.VERSION.SDK_INT <= 15;
        FORCE_ABS_FOCUS_SEARCH_DIRECTION = bl;
        bl = Build.VERSION.SDK_INT <= 15;
        IGNORE_DETACHED_FOCUSED_CHILD = bl;
        LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class, Integer.TYPE, Integer.TYPE};
        sQuinticInterpolator = new Interpolator(){

            public float getInterpolation(float f2) {
                return (f2 -= 1.0f) * f2 * f2 * f2 * f2 + 1.0f;
            }
        };
    }

    public RecyclerView(Context context) {
        this(context, null);
    }

    public RecyclerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.recyclerViewStyle);
    }

    public RecyclerView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mUpdateChildViewsRunnable = new Runnable(){

            @Override
            public void run() {
                if (RecyclerView.this.mFirstLayoutComplete && !RecyclerView.this.isLayoutRequested()) {
                    if (!RecyclerView.this.mIsAttached) {
                        RecyclerView.this.requestLayout();
                        return;
                    }
                    if (RecyclerView.this.mLayoutSuppressed) {
                        RecyclerView.this.mLayoutWasDefered = true;
                        return;
                    }
                    RecyclerView.this.consumePendingUpdateOperations();
                }
            }
        };
        this.mTempRect = new Rect();
        this.mTempRect2 = new Rect();
        this.mTempRectF = new RectF();
        this.mItemDecorations = new ArrayList();
        this.mOnItemTouchListeners = new ArrayList();
        this.mEdgeEffectFactory = new EdgeEffectFactory();
        this.mItemAnimator = new DefaultItemAnimator();
        this.mScaledHorizontalScrollFactor = Float.MIN_VALUE;
        this.mScaledVerticalScrollFactor = Float.MIN_VALUE;
        boolean bl = true;
        this.mPreserveFocusAfterLayout = true;
        this.mViewFlinger = new ViewFlinger();
        Object object = ALLOW_THREAD_GAP_WORK ? new GapWorker.LayoutPrefetchRegistryImpl() : null;
        this.mPrefetchRegistry = object;
        this.mState = new State();
        this.mItemsAddedOrRemoved = false;
        this.mItemsChanged = false;
        this.mItemAnimatorListener = new ItemAnimatorRestoreListener();
        this.mPostedAnimatorRunner = false;
        this.mMinMaxLayoutPositions = new int[2];
        this.mScrollOffset = new int[2];
        this.mNestedOffsets = new int[2];
        this.mReusableIntPair = new int[2];
        this.mPendingAccessibilityImportanceChange = new ArrayList<ViewHolder>();
        this.mItemAnimatorRunner = new Runnable(){

            @Override
            public void run() {
                if (RecyclerView.this.mItemAnimator != null) {
                    RecyclerView.this.mItemAnimator.runPendingAnimations();
                }
                RecyclerView.this.mPostedAnimatorRunner = false;
            }
        };
        this.mViewInfoProcessCallback = new ViewInfoStore.ProcessCallback(){

            public void processAppeared(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2) {
                RecyclerView.this.animateAppearance(viewHolder, itemHolderInfo, itemHolderInfo2);
            }

            public void processDisappeared(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2) {
                RecyclerView.this.mRecycler.unscrapView(viewHolder);
                RecyclerView.this.animateDisappearance(viewHolder, itemHolderInfo, itemHolderInfo2);
            }

            public void processPersistent(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2) {
                viewHolder.setIsRecyclable(false);
                if (RecyclerView.this.mDataSetHasChangedAfterLayout) {
                    if (RecyclerView.this.mItemAnimator.animateChange(viewHolder, viewHolder, itemHolderInfo, itemHolderInfo2)) {
                        RecyclerView.this.postAnimationRunner();
                    }
                } else if (RecyclerView.this.mItemAnimator.animatePersistence(viewHolder, itemHolderInfo, itemHolderInfo2)) {
                    RecyclerView.this.postAnimationRunner();
                }
            }

            public void unused(ViewHolder viewHolder) {
                RecyclerView.this.mLayout.removeAndRecycleView(viewHolder.itemView, RecyclerView.this.mRecycler);
            }
        };
        this.setScrollContainer(true);
        this.setFocusableInTouchMode(true);
        object = ViewConfiguration.get((Context)context);
        this.mTouchSlop = object.getScaledTouchSlop();
        this.mScaledHorizontalScrollFactor = ViewConfigurationCompat.getScaledHorizontalScrollFactor((ViewConfiguration)object, context);
        this.mScaledVerticalScrollFactor = ViewConfigurationCompat.getScaledVerticalScrollFactor((ViewConfiguration)object, context);
        this.mMinFlingVelocity = object.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = object.getScaledMaximumFlingVelocity();
        boolean bl2 = this.getOverScrollMode() == 2;
        this.setWillNotDraw(bl2);
        this.mItemAnimator.setListener(this.mItemAnimatorListener);
        this.initAdapterManager();
        this.initChildrenHelper();
        this.initAutofill();
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, 1);
        }
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.setAccessibilityDelegateCompat(new RecyclerViewAccessibilityDelegate(this));
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.RecyclerView, n2, 0);
        if (Build.VERSION.SDK_INT >= 29) {
            this.saveAttributeDataForStyleable(context, R.styleable.RecyclerView, attributeSet, typedArray, n2, 0);
        }
        object = typedArray.getString(R.styleable.RecyclerView_layoutManager);
        if (typedArray.getInt(R.styleable.RecyclerView_android_descendantFocusability, -1) == -1) {
            this.setDescendantFocusability(262144);
        }
        this.mClipToPadding = typedArray.getBoolean(R.styleable.RecyclerView_android_clipToPadding, true);
        this.mEnableFastScroller = typedArray.getBoolean(R.styleable.RecyclerView_fastScrollEnabled, false);
        if (this.mEnableFastScroller) {
            this.initFastScroller((StateListDrawable)typedArray.getDrawable(R.styleable.RecyclerView_fastScrollVerticalThumbDrawable), typedArray.getDrawable(R.styleable.RecyclerView_fastScrollVerticalTrackDrawable), (StateListDrawable)typedArray.getDrawable(R.styleable.RecyclerView_fastScrollHorizontalThumbDrawable), typedArray.getDrawable(R.styleable.RecyclerView_fastScrollHorizontalTrackDrawable));
        }
        typedArray.recycle();
        this.createLayoutManager(context, (String)object, attributeSet, n2, 0);
        bl2 = bl;
        if (Build.VERSION.SDK_INT >= 21) {
            object = context.obtainStyledAttributes(attributeSet, NESTED_SCROLLING_ATTRS, n2, 0);
            if (Build.VERSION.SDK_INT >= 29) {
                this.saveAttributeDataForStyleable(context, NESTED_SCROLLING_ATTRS, attributeSet, (TypedArray)object, n2, 0);
            }
            bl2 = object.getBoolean(0, true);
            object.recycle();
        }
        this.setNestedScrollingEnabled(bl2);
    }

    private void addAnimatingView(ViewHolder viewHolder) {
        View view = viewHolder.itemView;
        boolean bl = view.getParent() == this;
        this.mRecycler.unscrapView(this.getChildViewHolder(view));
        if (viewHolder.isTmpDetached()) {
            this.mChildHelper.attachViewToParent(view, -1, view.getLayoutParams(), true);
        } else if (!bl) {
            this.mChildHelper.addView(view, true);
        } else {
            this.mChildHelper.hide(view);
        }
    }

    private void animateChange(ViewHolder viewHolder, ViewHolder viewHolder2, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2, boolean bl, boolean bl2) {
        viewHolder.setIsRecyclable(false);
        if (bl) {
            this.addAnimatingView(viewHolder);
        }
        if (viewHolder != viewHolder2) {
            if (bl2) {
                this.addAnimatingView(viewHolder2);
            }
            viewHolder.mShadowedHolder = viewHolder2;
            this.addAnimatingView(viewHolder);
            this.mRecycler.unscrapView(viewHolder);
            viewHolder2.setIsRecyclable(false);
            viewHolder2.mShadowingHolder = viewHolder;
        }
        if (this.mItemAnimator.animateChange(viewHolder, viewHolder2, itemHolderInfo, itemHolderInfo2)) {
            this.postAnimationRunner();
        }
    }

    private void cancelScroll() {
        this.resetScroll();
        this.setScrollState(0);
    }

    static void clearNestedRecyclerViewIfNotNested(ViewHolder viewHolder) {
        if (viewHolder.mNestedRecyclerView != null) {
            View view = (View)viewHolder.mNestedRecyclerView.get();
            while (view != null) {
                if (view == viewHolder.itemView) {
                    return;
                }
                if ((view = view.getParent()) instanceof View) continue;
                view = null;
            }
            viewHolder.mNestedRecyclerView = null;
        }
    }

    /*
     * Loose catch block
     */
    private void createLayoutManager(Context object, String object2, AttributeSet attributeSet, int n2, int n3) {
        block12: {
            if (object2 == null || ((String)(object2 = ((String)object2).trim())).isEmpty()) break block12;
            String string2 = this.getFullClassName((Context)object, (String)object2);
            object2 = this.isInEditMode() ? ((Object)((Object)this)).getClass().getClassLoader() : object.getClassLoader();
            Class<LayoutManager> clazz = Class.forName(string2, false, (ClassLoader)object2).asSubclass(LayoutManager.class);
            IllegalStateException illegalStateException = null;
            try {
                object2 = clazz.getConstructor(LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object2 = clazz.getConstructor(new Class[0]);
                object = illegalStateException;
            }
            object = new Object[]{object, attributeSet, n2, n3};
            ((Constructor)object2).setAccessible(true);
            this.setLayoutManager((LayoutManager)((Constructor)object2).newInstance((Object[])object));
            {
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        noSuchMethodException.initCause(noSuchMethodException);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(attributeSet.getPositionDescription());
                        stringBuilder.append(": Error creating LayoutManager ");
                        stringBuilder.append(string2);
                        illegalStateException = new IllegalStateException(stringBuilder.toString(), noSuchMethodException);
                        throw illegalStateException;
                    }
                    catch (ClassCastException classCastException) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append(attributeSet.getPositionDescription());
                        ((StringBuilder)object).append(": Class is not a LayoutManager ");
                        ((StringBuilder)object).append(string2);
                        throw new IllegalStateException(((StringBuilder)object).toString(), classCastException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append(attributeSet.getPositionDescription());
                        ((StringBuilder)object).append(": Cannot access non-public constructor ");
                        ((StringBuilder)object).append(string2);
                        throw new IllegalStateException(((StringBuilder)object).toString(), illegalAccessException);
                    }
                    catch (InstantiationException instantiationException) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append(attributeSet.getPositionDescription());
                        ((StringBuilder)object).append(": Could not instantiate the LayoutManager: ");
                        ((StringBuilder)object).append(string2);
                        throw new IllegalStateException(((StringBuilder)object).toString(), instantiationException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append(attributeSet.getPositionDescription());
                        ((StringBuilder)object).append(": Could not instantiate the LayoutManager: ");
                        ((StringBuilder)object).append(string2);
                        throw new IllegalStateException(((StringBuilder)object).toString(), invocationTargetException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append(attributeSet.getPositionDescription());
                        ((StringBuilder)object2).append(": Unable to find LayoutManager ");
                        ((StringBuilder)object2).append(string2);
                        throw new IllegalStateException(((StringBuilder)object2).toString(), classNotFoundException);
                    }
                }
            }
        }
    }

    private boolean didChildRangeChange(int n2, int n3) {
        this.findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        int[] nArray = this.mMinMaxLayoutPositions;
        boolean bl = false;
        if (nArray[0] != n2 || nArray[1] != n3) {
            bl = true;
        }
        return bl;
    }

    private void dispatchContentChangedIfNecessary() {
        int n2 = this.mEatenAccessibilityChangeFlags;
        this.mEatenAccessibilityChangeFlags = 0;
        if (n2 != 0 && this.isAccessibilityEnabled()) {
            AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain();
            accessibilityEvent.setEventType(2048);
            AccessibilityEventCompat.setContentChangeTypes((AccessibilityEvent)accessibilityEvent, (int)n2);
            this.sendAccessibilityEventUnchecked(accessibilityEvent);
        }
    }

    private void dispatchLayoutStep1() {
        Object object;
        int n2;
        int n3;
        Object object2 = this.mState;
        boolean bl = true;
        ((State)object2).assertLayoutStep(1);
        this.fillRemainingScrollValues(this.mState);
        this.mState.mIsMeasuring = false;
        this.startInterceptRequestLayout();
        this.mViewInfoStore.clear();
        this.onEnterLayoutOrScroll();
        this.processAdapterUpdatesAndSetAnimationFlags();
        this.saveFocusInfo();
        object2 = this.mState;
        if (!((State)object2).mRunSimpleAnimations || !this.mItemsChanged) {
            bl = false;
        }
        ((State)object2).mTrackOldChangeHolders = bl;
        this.mItemsChanged = false;
        this.mItemsAddedOrRemoved = false;
        object2 = this.mState;
        ((State)object2).mInPreLayout = ((State)object2).mRunPredictiveAnimations;
        this.mState.mItemCount = this.mAdapter.getItemCount();
        this.findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        if (this.mState.mRunSimpleAnimations) {
            n3 = this.mChildHelper.getChildCount();
            for (n2 = 0; n2 < n3; ++n2) {
                object = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(n2));
                if (((ViewHolder)object).shouldIgnore() || ((ViewHolder)object).isInvalid() && !this.mAdapter.hasStableIds()) continue;
                object2 = this.mItemAnimator.recordPreLayoutInformation(this.mState, (ViewHolder)object, ItemAnimator.buildAdapterChangeFlagsForAnimations((ViewHolder)object), ((ViewHolder)object).getUnmodifiedPayloads());
                this.mViewInfoStore.addToPreLayout((ViewHolder)object, (ItemAnimator.ItemHolderInfo)object2);
                if (!this.mState.mTrackOldChangeHolders || !((ViewHolder)object).isUpdated() || ((ViewHolder)object).isRemoved() || ((ViewHolder)object).shouldIgnore() || ((ViewHolder)object).isInvalid()) continue;
                long l2 = this.getChangedHolderKey((ViewHolder)object);
                this.mViewInfoStore.addToOldChangeHolders(l2, (ViewHolder)object);
            }
        }
        if (this.mState.mRunPredictiveAnimations) {
            this.saveOldPositions();
            bl = this.mState.mStructureChanged;
            object2 = this.mState;
            ((State)object2).mStructureChanged = false;
            this.mLayout.onLayoutChildren(this.mRecycler, (State)object2);
            this.mState.mStructureChanged = bl;
            for (n2 = 0; n2 < this.mChildHelper.getChildCount(); ++n2) {
                object2 = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(n2));
                if (((ViewHolder)object2).shouldIgnore() || this.mViewInfoStore.isInPreLayout((ViewHolder)object2)) continue;
                int n4 = ItemAnimator.buildAdapterChangeFlagsForAnimations((ViewHolder)object2);
                bl = ((ViewHolder)object2).hasAnyOfTheFlags(8192);
                n3 = n4;
                if (!bl) {
                    n3 = n4 | 0x1000;
                }
                object = this.mItemAnimator.recordPreLayoutInformation(this.mState, (ViewHolder)object2, n3, ((ViewHolder)object2).getUnmodifiedPayloads());
                if (bl) {
                    this.recordAnimationInfoIfBouncedHiddenView((ViewHolder)object2, (ItemAnimator.ItemHolderInfo)object);
                    continue;
                }
                this.mViewInfoStore.addToAppearedInPreLayoutHolders((ViewHolder)object2, (ItemAnimator.ItemHolderInfo)object);
            }
            this.clearOldPositions();
        } else {
            this.clearOldPositions();
        }
        this.onExitLayoutOrScroll();
        this.stopInterceptRequestLayout(false);
        this.mState.mLayoutStep = 2;
    }

    private void dispatchLayoutStep2() {
        this.startInterceptRequestLayout();
        this.onEnterLayoutOrScroll();
        this.mState.assertLayoutStep(6);
        this.mAdapterHelper.consumeUpdatesInOnePass();
        this.mState.mItemCount = this.mAdapter.getItemCount();
        State state = this.mState;
        state.mDeletedInvisibleItemCountSincePreviousLayout = 0;
        state.mInPreLayout = false;
        this.mLayout.onLayoutChildren(this.mRecycler, state);
        state = this.mState;
        state.mStructureChanged = false;
        this.mPendingSavedState = null;
        boolean bl = state.mRunSimpleAnimations && this.mItemAnimator != null;
        state.mRunSimpleAnimations = bl;
        this.mState.mLayoutStep = 4;
        this.onExitLayoutOrScroll();
        this.stopInterceptRequestLayout(false);
    }

    private void dispatchLayoutStep3() {
        this.mState.assertLayoutStep(4);
        this.startInterceptRequestLayout();
        this.onEnterLayoutOrScroll();
        Object object = this.mState;
        ((State)object).mLayoutStep = 1;
        if (((State)object).mRunSimpleAnimations) {
            for (int i2 = this.mChildHelper.getChildCount() - 1; i2 >= 0; --i2) {
                ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i2));
                if (viewHolder.shouldIgnore()) continue;
                long l2 = this.getChangedHolderKey(viewHolder);
                ItemAnimator.ItemHolderInfo itemHolderInfo = this.mItemAnimator.recordPostLayoutInformation(this.mState, viewHolder);
                object = this.mViewInfoStore.getFromOldChangeHolders(l2);
                if (object != null && !((ViewHolder)object).shouldIgnore()) {
                    boolean bl = this.mViewInfoStore.isDisappearing((ViewHolder)object);
                    boolean bl2 = this.mViewInfoStore.isDisappearing(viewHolder);
                    if (bl && object == viewHolder) {
                        this.mViewInfoStore.addToPostLayout(viewHolder, itemHolderInfo);
                        continue;
                    }
                    ItemAnimator.ItemHolderInfo itemHolderInfo2 = this.mViewInfoStore.popFromPreLayout((ViewHolder)object);
                    this.mViewInfoStore.addToPostLayout(viewHolder, itemHolderInfo);
                    itemHolderInfo = this.mViewInfoStore.popFromPostLayout(viewHolder);
                    if (itemHolderInfo2 == null) {
                        this.handleMissingPreInfoForChangeError(l2, viewHolder, (ViewHolder)object);
                        continue;
                    }
                    this.animateChange((ViewHolder)object, viewHolder, itemHolderInfo2, itemHolderInfo, bl, bl2);
                    continue;
                }
                this.mViewInfoStore.addToPostLayout(viewHolder, itemHolderInfo);
            }
            this.mViewInfoStore.process(this.mViewInfoProcessCallback);
        }
        this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
        object = this.mState;
        ((State)object).mPreviousLayoutItemCount = ((State)object).mItemCount;
        this.mDataSetHasChangedAfterLayout = false;
        this.mDispatchItemsChangedEvent = false;
        object = this.mState;
        ((State)object).mRunSimpleAnimations = false;
        ((State)object).mRunPredictiveAnimations = false;
        this.mLayout.mRequestedSimpleAnimations = false;
        if (this.mRecycler.mChangedScrap != null) {
            this.mRecycler.mChangedScrap.clear();
        }
        if (this.mLayout.mPrefetchMaxObservedInInitialPrefetch) {
            object = this.mLayout;
            ((LayoutManager)object).mPrefetchMaxCountObserved = 0;
            ((LayoutManager)object).mPrefetchMaxObservedInInitialPrefetch = false;
            this.mRecycler.updateViewCacheSize();
        }
        this.mLayout.onLayoutCompleted(this.mState);
        this.onExitLayoutOrScroll();
        this.stopInterceptRequestLayout(false);
        this.mViewInfoStore.clear();
        object = this.mMinMaxLayoutPositions;
        if (this.didChildRangeChange((int)object[0], (int)object[1])) {
            this.dispatchOnScrolled(0, 0);
        }
        this.recoverFocusFromState();
        this.resetFocusInfo();
    }

    private boolean dispatchToOnItemTouchListeners(MotionEvent motionEvent) {
        OnItemTouchListener onItemTouchListener = this.mInterceptingOnItemTouchListener;
        if (onItemTouchListener == null) {
            if (motionEvent.getAction() == 0) {
                return false;
            }
            return this.findInterceptingOnItemTouchListener(motionEvent);
        }
        onItemTouchListener.onTouchEvent(this, motionEvent);
        int n2 = motionEvent.getAction();
        if (n2 == 3 || n2 == 1) {
            this.mInterceptingOnItemTouchListener = null;
        }
        return true;
    }

    private boolean findInterceptingOnItemTouchListener(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction();
        int n3 = this.mOnItemTouchListeners.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            OnItemTouchListener onItemTouchListener = this.mOnItemTouchListeners.get(i2);
            if (!onItemTouchListener.onInterceptTouchEvent(this, motionEvent) || n2 == 3) continue;
            this.mInterceptingOnItemTouchListener = onItemTouchListener;
            return true;
        }
        return false;
    }

    private void findMinMaxChildLayoutPositions(int[] nArray) {
        int n2 = this.mChildHelper.getChildCount();
        if (n2 == 0) {
            nArray[0] = -1;
            nArray[1] = -1;
            return;
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5;
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i2));
            if (viewHolder.shouldIgnore()) {
                n5 = n4;
            } else {
                int n6 = viewHolder.getLayoutPosition();
                int n7 = n3;
                if (n6 < n3) {
                    n7 = n6;
                }
                n3 = n7;
                n5 = n4;
                if (n6 > n4) {
                    n5 = n6;
                    n3 = n7;
                }
            }
            n4 = n5;
        }
        nArray[0] = n3;
        nArray[1] = n4;
    }

    static RecyclerView findNestedRecyclerView(View object) {
        if (!(object instanceof ViewGroup)) {
            return null;
        }
        if (object instanceof RecyclerView) {
            return (RecyclerView)((Object)object);
        }
        ViewGroup viewGroup = (ViewGroup)object;
        int n2 = viewGroup.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = RecyclerView.findNestedRecyclerView(viewGroup.getChildAt(i2));
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private View findNextViewToFocus() {
        ViewHolder viewHolder;
        int n2 = this.mState.mFocusedItemPosition != -1 ? this.mState.mFocusedItemPosition : 0;
        int n3 = this.mState.getItemCount();
        for (int i2 = n2; i2 < n3 && (viewHolder = this.findViewHolderForAdapterPosition(i2)) != null; ++i2) {
            if (!viewHolder.itemView.hasFocusable()) continue;
            return viewHolder.itemView;
        }
        for (n2 = Math.min(n3, n2) - 1; n2 >= 0; --n2) {
            viewHolder = this.findViewHolderForAdapterPosition(n2);
            if (viewHolder == null) {
                return null;
            }
            if (!viewHolder.itemView.hasFocusable()) continue;
            return viewHolder.itemView;
        }
        return null;
    }

    static ViewHolder getChildViewHolderInt(View view) {
        if (view == null) {
            return null;
        }
        return ((LayoutParams)view.getLayoutParams()).mViewHolder;
    }

    static void getDecoratedBoundsWithMarginsInt(View view, Rect rect) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        Rect rect2 = layoutParams.mDecorInsets;
        rect.set(view.getLeft() - rect2.left - layoutParams.leftMargin, view.getTop() - rect2.top - layoutParams.topMargin, view.getRight() + rect2.right + layoutParams.rightMargin, view.getBottom() + rect2.bottom + layoutParams.bottomMargin);
    }

    private int getDeepestFocusedViewWithId(View view) {
        int n2 = view.getId();
        while (!view.isFocused() && view instanceof ViewGroup && view.hasFocus()) {
            View view2;
            view = view2 = ((ViewGroup)view).getFocusedChild();
            if (view2.getId() == -1) continue;
            n2 = view2.getId();
            view = view2;
        }
        return n2;
    }

    private String getFullClassName(Context object, String string2) {
        if (string2.charAt(0) == '.') {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(object.getPackageName());
            stringBuilder.append(string2);
            return stringBuilder.toString();
        }
        if (string2.contains(".")) {
            return string2;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(RecyclerView.class.getPackage().getName());
        ((StringBuilder)object).append('.');
        ((StringBuilder)object).append(string2);
        return ((StringBuilder)object).toString();
    }

    private NestedScrollingChildHelper getScrollingChildHelper() {
        if (this.mScrollingChildHelper == null) {
            this.mScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        }
        return this.mScrollingChildHelper;
    }

    private void handleMissingPreInfoForChangeError(long l2, ViewHolder viewHolder, ViewHolder object) {
        Object object2;
        int n2 = this.mChildHelper.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            object2 = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i2));
            if (object2 == viewHolder || this.getChangedHolderKey((ViewHolder)object2) != l2) continue;
            object = this.mAdapter;
            if (object != null && ((Adapter)object).hasStableIds()) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Two different ViewHolders have the same stable ID. Stable IDs in your adapter MUST BE unique and SHOULD NOT change.\n ViewHolder 1:");
                ((StringBuilder)object).append(object2);
                ((StringBuilder)object).append(" \n View Holder 2:");
                ((StringBuilder)object).append(viewHolder);
                ((StringBuilder)object).append(this.exceptionLabel());
                throw new IllegalStateException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Two different ViewHolders have the same change ID. This might happen due to inconsistent Adapter update events or if the LayoutManager lays out the same View multiple times.\n ViewHolder 1:");
            ((StringBuilder)object).append(object2);
            ((StringBuilder)object).append(" \n View Holder 2:");
            ((StringBuilder)object).append(viewHolder);
            ((StringBuilder)object).append(this.exceptionLabel());
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("Problem while matching changed view holders with the newones. The pre-layout information for the change holder ");
        ((StringBuilder)object2).append(object);
        ((StringBuilder)object2).append(" cannot be found but it is necessary for ");
        ((StringBuilder)object2).append(viewHolder);
        ((StringBuilder)object2).append(this.exceptionLabel());
        Log.e((String)TAG, (String)((StringBuilder)object2).toString());
    }

    private boolean hasUpdatedView() {
        int n2 = this.mChildHelper.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i2));
            if (viewHolder == null || viewHolder.shouldIgnore() || !viewHolder.isUpdated()) continue;
            return true;
        }
        return false;
    }

    private void initAutofill() {
        if (ViewCompat.getImportantForAutofill((View)this) == 0) {
            ViewCompat.setImportantForAutofill((View)this, 8);
        }
    }

    private void initChildrenHelper() {
        this.mChildHelper = new ChildHelper(new ChildHelper.Callback(){

            @Override
            public void addView(View view, int n2) {
                RecyclerView.this.addView(view, n2);
                RecyclerView.this.dispatchChildAttached(view);
            }

            @Override
            public void attachViewToParent(View object, int n2, ViewGroup.LayoutParams layoutParams) {
                ViewHolder viewHolder = RecyclerView.getChildViewHolderInt((View)object);
                if (viewHolder != null) {
                    if (!viewHolder.isTmpDetached() && !viewHolder.shouldIgnore()) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Called attach on a child which is not detached: ");
                        ((StringBuilder)object).append(viewHolder);
                        ((StringBuilder)object).append(RecyclerView.this.exceptionLabel());
                        throw new IllegalArgumentException(((StringBuilder)object).toString());
                    }
                    viewHolder.clearTmpDetachFlag();
                }
                RecyclerView.this.attachViewToParent((View)object, n2, layoutParams);
            }

            @Override
            public void detachViewFromParent(int n2) {
                Object object = this.getChildAt(n2);
                if (object != null && (object = RecyclerView.getChildViewHolderInt((View)object)) != null) {
                    if (((ViewHolder)object).isTmpDetached() && !((ViewHolder)object).shouldIgnore()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("called detach on an already detached child ");
                        stringBuilder.append(object);
                        stringBuilder.append(RecyclerView.this.exceptionLabel());
                        throw new IllegalArgumentException(stringBuilder.toString());
                    }
                    ((ViewHolder)object).addFlags(256);
                }
                RecyclerView.this.detachViewFromParent(n2);
            }

            @Override
            public View getChildAt(int n2) {
                return RecyclerView.this.getChildAt(n2);
            }

            @Override
            public int getChildCount() {
                return RecyclerView.this.getChildCount();
            }

            @Override
            public ViewHolder getChildViewHolder(View view) {
                return RecyclerView.getChildViewHolderInt(view);
            }

            @Override
            public int indexOfChild(View view) {
                return RecyclerView.this.indexOfChild(view);
            }

            @Override
            public void onEnteredHiddenState(View object) {
                if ((object = RecyclerView.getChildViewHolderInt((View)object)) != null) {
                    ((ViewHolder)object).onEnteredHiddenState(RecyclerView.this);
                }
            }

            @Override
            public void onLeftHiddenState(View object) {
                if ((object = RecyclerView.getChildViewHolderInt((View)object)) != null) {
                    ((ViewHolder)object).onLeftHiddenState(RecyclerView.this);
                }
            }

            @Override
            public void removeAllViews() {
                int n2 = this.getChildCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    View view = this.getChildAt(i2);
                    RecyclerView.this.dispatchChildDetached(view);
                    view.clearAnimation();
                }
                RecyclerView.this.removeAllViews();
            }

            @Override
            public void removeViewAt(int n2) {
                View view = RecyclerView.this.getChildAt(n2);
                if (view != null) {
                    RecyclerView.this.dispatchChildDetached(view);
                    view.clearAnimation();
                }
                RecyclerView.this.removeViewAt(n2);
            }
        });
    }

    private boolean isPreferredNextFocus(View object, View view, int n2) {
        boolean bl;
        block21: {
            block26: {
                int n3;
                int n4;
                int n5;
                boolean bl2;
                block23: {
                    block25: {
                        block24: {
                            boolean bl3;
                            boolean bl4;
                            boolean bl5;
                            boolean bl6;
                            boolean bl7;
                            block22: {
                                bl7 = false;
                                bl6 = false;
                                bl5 = false;
                                bl4 = false;
                                bl2 = false;
                                bl3 = false;
                                bl = bl2;
                                if (view == null) break block21;
                                if (view != this) break block22;
                                bl = bl2;
                                break block21;
                            }
                            if (this.findContainingItemView(view) == null) {
                                return false;
                            }
                            if (object == null) {
                                return true;
                            }
                            if (this.findContainingItemView((View)object) == null) {
                                return true;
                            }
                            this.mTempRect.set(0, 0, object.getWidth(), object.getHeight());
                            this.mTempRect2.set(0, 0, view.getWidth(), view.getHeight());
                            this.offsetDescendantRectToMyCoords((View)object, this.mTempRect);
                            this.offsetDescendantRectToMyCoords(view, this.mTempRect2);
                            n5 = this.mLayout.getLayoutDirection();
                            n4 = -1;
                            n3 = n5 == 1 ? -1 : 1;
                            n5 = (this.mTempRect.left < this.mTempRect2.left || this.mTempRect.right <= this.mTempRect2.left) && this.mTempRect.right < this.mTempRect2.right ? 1 : ((this.mTempRect.right > this.mTempRect2.right || this.mTempRect.left >= this.mTempRect2.right) && this.mTempRect.left > this.mTempRect2.left ? -1 : 0);
                            if ((this.mTempRect.top < this.mTempRect2.top || this.mTempRect.bottom <= this.mTempRect2.top) && this.mTempRect.bottom < this.mTempRect2.bottom) {
                                n4 = 1;
                            } else if (this.mTempRect.bottom <= this.mTempRect2.bottom && this.mTempRect.top < this.mTempRect2.bottom || this.mTempRect.top <= this.mTempRect2.top) {
                                n4 = 0;
                            }
                            if (n2 == 1) break block23;
                            if (n2 != 2) {
                                if (n2 != 17) {
                                    if (n2 != 33) {
                                        if (n2 != 66) {
                                            if (n2 == 130) {
                                                bl = bl3;
                                                if (n4 > 0) {
                                                    bl = true;
                                                }
                                                return bl;
                                            }
                                            object = new StringBuilder();
                                            ((StringBuilder)object).append("Invalid direction: ");
                                            ((StringBuilder)object).append(n2);
                                            ((StringBuilder)object).append(this.exceptionLabel());
                                            throw new IllegalArgumentException(((StringBuilder)object).toString());
                                        }
                                        bl = bl7;
                                        if (n5 > 0) {
                                            bl = true;
                                        }
                                        return bl;
                                    }
                                    bl = bl6;
                                    if (n4 < 0) {
                                        bl = true;
                                    }
                                    return bl;
                                }
                                bl = bl5;
                                if (n5 < 0) {
                                    bl = true;
                                }
                                return bl;
                            }
                            if (n4 > 0) break block24;
                            bl = bl4;
                            if (n4 != 0) break block25;
                            bl = bl4;
                            if (n5 * n3 < 0) break block25;
                        }
                        bl = true;
                    }
                    return bl;
                }
                if (n4 < 0) break block26;
                bl = bl2;
                if (n4 != 0) break block21;
                bl = bl2;
                if (n5 * n3 > 0) break block21;
            }
            bl = true;
        }
        return bl;
    }

    private void onPointerUp(MotionEvent motionEvent) {
        int n2 = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(n2) == this.mScrollPointerId) {
            int n3;
            n2 = n2 == 0 ? 1 : 0;
            this.mScrollPointerId = motionEvent.getPointerId(n2);
            this.mLastTouchX = n3 = (int)(motionEvent.getX(n2) + 0.5f);
            this.mInitialTouchX = n3;
            this.mLastTouchY = n2 = (int)(motionEvent.getY(n2) + 0.5f);
            this.mInitialTouchY = n2;
        }
    }

    private boolean predictiveItemAnimationsEnabled() {
        boolean bl = this.mItemAnimator != null && this.mLayout.supportsPredictiveItemAnimations();
        return bl;
    }

    private void processAdapterUpdatesAndSetAnimationFlags() {
        if (this.mDataSetHasChangedAfterLayout) {
            this.mAdapterHelper.reset();
            if (this.mDispatchItemsChangedEvent) {
                this.mLayout.onItemsChanged(this);
            }
        }
        if (this.predictiveItemAnimationsEnabled()) {
            this.mAdapterHelper.preProcess();
        } else {
            this.mAdapterHelper.consumeUpdatesInOnePass();
        }
        boolean bl = this.mItemsAddedOrRemoved;
        boolean bl2 = false;
        boolean bl3 = bl || this.mItemsChanged;
        State state = this.mState;
        bl = !(!this.mFirstLayoutComplete || this.mItemAnimator == null || !this.mDataSetHasChangedAfterLayout && !bl3 && !this.mLayout.mRequestedSimpleAnimations || this.mDataSetHasChangedAfterLayout && !this.mAdapter.hasStableIds());
        state.mRunSimpleAnimations = bl;
        state = this.mState;
        bl = bl2;
        if (state.mRunSimpleAnimations) {
            bl = bl2;
            if (bl3) {
                bl = bl2;
                if (!this.mDataSetHasChangedAfterLayout) {
                    bl = bl2;
                    if (this.predictiveItemAnimationsEnabled()) {
                        bl = true;
                    }
                }
            }
        }
        state.mRunPredictiveAnimations = bl;
    }

    /*
     * Unable to fully structure code
     */
    private void pullGlows(float var1_1, float var2_2, float var3_3, float var4_4) {
        var5_5 = true;
        if (var2_2 < 0.0f) {
            this.ensureLeftGlow();
            EdgeEffectCompat.onPull((EdgeEffect)this.mLeftGlow, (float)(-var2_2 / (float)this.getWidth()), (float)(1.0f - var3_3 / (float)this.getHeight()));
lbl5:
            // 2 sources

            while (true) {
                var6_6 = true;
                break;
            }
        } else {
            if (var2_2 > 0.0f) {
                this.ensureRightGlow();
                EdgeEffectCompat.onPull((EdgeEffect)this.mRightGlow, (float)(var2_2 / (float)this.getWidth()), (float)(var3_3 / (float)this.getHeight()));
                ** continue;
            }
            var6_6 = false;
        }
        if (var4_4 < 0.0f) {
            this.ensureTopGlow();
            EdgeEffectCompat.onPull((EdgeEffect)this.mTopGlow, (float)(-var4_4 / (float)this.getHeight()), (float)(var1_1 / (float)this.getWidth()));
            var6_6 = var5_5;
        } else if (var4_4 > 0.0f) {
            this.ensureBottomGlow();
            EdgeEffectCompat.onPull((EdgeEffect)this.mBottomGlow, (float)(var4_4 / (float)this.getHeight()), (float)(1.0f - var1_1 / (float)this.getWidth()));
            var6_6 = var5_5;
        }
        if (var6_6 || var2_2 != 0.0f || var4_4 != 0.0f) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private void recoverFocusFromState() {
        if (this.mPreserveFocusAfterLayout && this.mAdapter != null && this.hasFocus() && this.getDescendantFocusability() != 393216 && (this.getDescendantFocusability() != 131072 || !this.isFocused())) {
            Object object;
            if (!this.isFocused()) {
                object = this.getFocusedChild();
                if (IGNORE_DETACHED_FOCUSED_CHILD && (object.getParent() == null || !object.hasFocus())) {
                    if (this.mChildHelper.getChildCount() == 0) {
                        this.requestFocus();
                        return;
                    }
                } else if (!this.mChildHelper.isHidden((View)object)) {
                    return;
                }
            }
            long l2 = this.mState.mFocusedItemId;
            View view = null;
            object = l2 != -1L && this.mAdapter.hasStableIds() ? this.findViewHolderForItemId(this.mState.mFocusedItemId) : null;
            if (object != null && !this.mChildHelper.isHidden(object.itemView) && object.itemView.hasFocusable()) {
                object = object.itemView;
            } else {
                object = view;
                if (this.mChildHelper.getChildCount() > 0) {
                    object = this.findNextViewToFocus();
                }
            }
            if (object != null) {
                if ((long)this.mState.mFocusedSubChildId != -1L && (view = object.findViewById(this.mState.mFocusedSubChildId)) != null && view.isFocusable()) {
                    object = view;
                }
                object.requestFocus();
            }
        }
    }

    private void releaseGlows() {
        boolean bl;
        EdgeEffect edgeEffect = this.mLeftGlow;
        if (edgeEffect != null) {
            edgeEffect.onRelease();
            bl = this.mLeftGlow.isFinished();
        } else {
            bl = false;
        }
        edgeEffect = this.mTopGlow;
        boolean bl2 = bl;
        if (edgeEffect != null) {
            edgeEffect.onRelease();
            bl2 = bl | this.mTopGlow.isFinished();
        }
        edgeEffect = this.mRightGlow;
        bl = bl2;
        if (edgeEffect != null) {
            edgeEffect.onRelease();
            bl = bl2 | this.mRightGlow.isFinished();
        }
        edgeEffect = this.mBottomGlow;
        bl2 = bl;
        if (edgeEffect != null) {
            edgeEffect.onRelease();
            bl2 = bl | this.mBottomGlow.isFinished();
        }
        if (bl2) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private void requestChildOnScreen(View view, View view2) {
        Rect rect;
        Object object = view2 != null ? view2 : view;
        this.mTempRect.set(0, 0, object.getWidth(), object.getHeight());
        object = object.getLayoutParams();
        if (object instanceof LayoutParams) {
            object = (LayoutParams)((Object)object);
            if (!((LayoutParams)((Object)object)).mInsetsDirty) {
                object = ((LayoutParams)((Object)object)).mDecorInsets;
                rect = this.mTempRect;
                rect.left -= ((Rect)object).left;
                rect = this.mTempRect;
                rect.right += ((Rect)object).right;
                rect = this.mTempRect;
                rect.top -= ((Rect)object).top;
                rect = this.mTempRect;
                rect.bottom += ((Rect)object).bottom;
            }
        }
        if (view2 != null) {
            this.offsetDescendantRectToMyCoords(view2, this.mTempRect);
            this.offsetRectIntoDescendantCoords(view, this.mTempRect);
        }
        object = this.mLayout;
        rect = this.mTempRect;
        boolean bl = this.mFirstLayoutComplete;
        boolean bl2 = view2 == null;
        ((LayoutManager)object).requestChildRectangleOnScreen(this, view, rect, bl ^ true, bl2);
    }

    private void resetFocusInfo() {
        State state = this.mState;
        state.mFocusedItemId = -1L;
        state.mFocusedItemPosition = -1;
        state.mFocusedSubChildId = -1;
    }

    private void resetScroll() {
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.clear();
        }
        this.stopNestedScroll(0);
        this.releaseGlows();
    }

    private void saveFocusInfo() {
        boolean bl = this.mPreserveFocusAfterLayout;
        Object object = null;
        Object object2 = bl && this.hasFocus() && this.mAdapter != null ? this.getFocusedChild() : null;
        if ((object2 = object2 == null ? object : this.findContainingViewHolder((View)object2)) == null) {
            this.resetFocusInfo();
        } else {
            object = this.mState;
            long l2 = this.mAdapter.hasStableIds() ? ((ViewHolder)object2).getItemId() : -1L;
            ((State)object).mFocusedItemId = l2;
            object = this.mState;
            int n2 = this.mDataSetHasChangedAfterLayout ? -1 : (((ViewHolder)object2).isRemoved() ? ((ViewHolder)object2).mOldPosition : ((ViewHolder)object2).getAdapterPosition());
            ((State)object).mFocusedItemPosition = n2;
            this.mState.mFocusedSubChildId = this.getDeepestFocusedViewWithId(((ViewHolder)object2).itemView);
        }
    }

    private void setAdapterInternal(Adapter object, boolean bl, boolean bl2) {
        Adapter adapter = this.mAdapter;
        if (adapter != null) {
            adapter.unregisterAdapterDataObserver(this.mObserver);
            this.mAdapter.onDetachedFromRecyclerView(this);
        }
        if (!bl || bl2) {
            this.removeAndRecycleViews();
        }
        this.mAdapterHelper.reset();
        adapter = this.mAdapter;
        this.mAdapter = object;
        if (object != null) {
            ((Adapter)object).registerAdapterDataObserver(this.mObserver);
            ((Adapter)object).onAttachedToRecyclerView(this);
        }
        if ((object = this.mLayout) != null) {
            ((LayoutManager)object).onAdapterChanged(adapter, this.mAdapter);
        }
        this.mRecycler.onAdapterChanged(adapter, this.mAdapter, bl);
        this.mState.mStructureChanged = true;
    }

    private void stopScrollersInternal() {
        this.mViewFlinger.stop();
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager != null) {
            layoutManager.stopSmoothScroller();
        }
    }

    void absorbGlows(int n2, int n3) {
        if (n2 < 0) {
            this.ensureLeftGlow();
            if (this.mLeftGlow.isFinished()) {
                this.mLeftGlow.onAbsorb(-n2);
            }
        } else if (n2 > 0) {
            this.ensureRightGlow();
            if (this.mRightGlow.isFinished()) {
                this.mRightGlow.onAbsorb(n2);
            }
        }
        if (n3 < 0) {
            this.ensureTopGlow();
            if (this.mTopGlow.isFinished()) {
                this.mTopGlow.onAbsorb(-n3);
            }
        } else if (n3 > 0) {
            this.ensureBottomGlow();
            if (this.mBottomGlow.isFinished()) {
                this.mBottomGlow.onAbsorb(n3);
            }
        }
        if (n2 != 0 || n3 != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void addFocusables(ArrayList<View> arrayList, int n2, int n3) {
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager == null || !layoutManager.onAddFocusables(this, arrayList, n2, n3)) {
            super.addFocusables(arrayList, n2, n3);
        }
    }

    public void addItemDecoration(ItemDecoration itemDecoration) {
        this.addItemDecoration(itemDecoration, -1);
    }

    public void addItemDecoration(ItemDecoration itemDecoration, int n2) {
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager != null) {
            layoutManager.assertNotInLayoutOrScroll("Cannot add item decoration during a scroll  or layout");
        }
        if (this.mItemDecorations.isEmpty()) {
            this.setWillNotDraw(false);
        }
        if (n2 < 0) {
            this.mItemDecorations.add(itemDecoration);
        } else {
            this.mItemDecorations.add(n2, itemDecoration);
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    public void addOnChildAttachStateChangeListener(OnChildAttachStateChangeListener onChildAttachStateChangeListener) {
        if (this.mOnChildAttachStateListeners == null) {
            this.mOnChildAttachStateListeners = new ArrayList<OnChildAttachStateChangeListener>();
        }
        this.mOnChildAttachStateListeners.add(onChildAttachStateChangeListener);
    }

    public void addOnItemTouchListener(OnItemTouchListener onItemTouchListener) {
        this.mOnItemTouchListeners.add(onItemTouchListener);
    }

    public void addOnScrollListener(OnScrollListener onScrollListener) {
        if (this.mScrollListeners == null) {
            this.mScrollListeners = new ArrayList<OnScrollListener>();
        }
        this.mScrollListeners.add(onScrollListener);
    }

    void animateAppearance(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2) {
        viewHolder.setIsRecyclable(false);
        if (this.mItemAnimator.animateAppearance(viewHolder, itemHolderInfo, itemHolderInfo2)) {
            this.postAnimationRunner();
        }
    }

    void animateDisappearance(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2) {
        this.addAnimatingView(viewHolder);
        viewHolder.setIsRecyclable(false);
        if (this.mItemAnimator.animateDisappearance(viewHolder, itemHolderInfo, itemHolderInfo2)) {
            this.postAnimationRunner();
        }
    }

    void assertInLayoutOrScroll(String charSequence) {
        if (!this.isComputingLayout()) {
            if (charSequence == null) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Cannot call this method unless RecyclerView is computing a layout or scrolling");
                ((StringBuilder)charSequence).append(this.exceptionLabel());
                throw new IllegalStateException(((StringBuilder)charSequence).toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence);
            stringBuilder.append(this.exceptionLabel());
            throw new IllegalStateException(stringBuilder.toString());
        }
    }

    void assertNotInLayoutOrScroll(String charSequence) {
        if (this.isComputingLayout()) {
            if (charSequence == null) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Cannot call this method while RecyclerView is computing a layout or scrolling");
                ((StringBuilder)charSequence).append(this.exceptionLabel());
                throw new IllegalStateException(((StringBuilder)charSequence).toString());
            }
            throw new IllegalStateException((String)charSequence);
        }
        if (this.mDispatchScrollCounter > 0) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("");
            ((StringBuilder)charSequence).append(this.exceptionLabel());
            Log.w((String)TAG, (String)"Cannot call this method in a scroll callback. Scroll callbacks mightbe run during a measure & layout pass where you cannot change theRecyclerView data. Any method call that might change the structureof the RecyclerView or the adapter contents should be postponed tothe next frame.", (Throwable)new IllegalStateException(((StringBuilder)charSequence).toString()));
        }
    }

    boolean canReuseUpdatedViewHolder(ViewHolder viewHolder) {
        ItemAnimator itemAnimator = this.mItemAnimator;
        boolean bl = itemAnimator == null || itemAnimator.canReuseUpdatedViewHolder(viewHolder, viewHolder.getUnmodifiedPayloads());
        return bl;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        boolean bl = layoutParams instanceof LayoutParams && this.mLayout.checkLayoutParams((LayoutParams)layoutParams);
        return bl;
    }

    void clearOldPositions() {
        int n2 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i2));
            if (viewHolder.shouldIgnore()) continue;
            viewHolder.clearOldPosition();
        }
        this.mRecycler.clearOldPositions();
    }

    public void clearOnChildAttachStateChangeListeners() {
        List<OnChildAttachStateChangeListener> list = this.mOnChildAttachStateListeners;
        if (list != null) {
            list.clear();
        }
    }

    public void clearOnScrollListeners() {
        List<OnScrollListener> list = this.mScrollListeners;
        if (list != null) {
            list.clear();
        }
    }

    public int computeHorizontalScrollExtent() {
        LayoutManager layoutManager = this.mLayout;
        int n2 = 0;
        if (layoutManager == null) {
            return 0;
        }
        if (layoutManager.canScrollHorizontally()) {
            n2 = this.mLayout.computeHorizontalScrollExtent(this.mState);
        }
        return n2;
    }

    public int computeHorizontalScrollOffset() {
        LayoutManager layoutManager = this.mLayout;
        int n2 = 0;
        if (layoutManager == null) {
            return 0;
        }
        if (layoutManager.canScrollHorizontally()) {
            n2 = this.mLayout.computeHorizontalScrollOffset(this.mState);
        }
        return n2;
    }

    public int computeHorizontalScrollRange() {
        LayoutManager layoutManager = this.mLayout;
        int n2 = 0;
        if (layoutManager == null) {
            return 0;
        }
        if (layoutManager.canScrollHorizontally()) {
            n2 = this.mLayout.computeHorizontalScrollRange(this.mState);
        }
        return n2;
    }

    public int computeVerticalScrollExtent() {
        LayoutManager layoutManager = this.mLayout;
        int n2 = 0;
        if (layoutManager == null) {
            return 0;
        }
        if (layoutManager.canScrollVertically()) {
            n2 = this.mLayout.computeVerticalScrollExtent(this.mState);
        }
        return n2;
    }

    public int computeVerticalScrollOffset() {
        LayoutManager layoutManager = this.mLayout;
        int n2 = 0;
        if (layoutManager == null) {
            return 0;
        }
        if (layoutManager.canScrollVertically()) {
            n2 = this.mLayout.computeVerticalScrollOffset(this.mState);
        }
        return n2;
    }

    public int computeVerticalScrollRange() {
        LayoutManager layoutManager = this.mLayout;
        int n2 = 0;
        if (layoutManager == null) {
            return 0;
        }
        if (layoutManager.canScrollVertically()) {
            n2 = this.mLayout.computeVerticalScrollRange(this.mState);
        }
        return n2;
    }

    void considerReleasingGlowsOnScroll(int n2, int n3) {
        boolean bl;
        EdgeEffect edgeEffect = this.mLeftGlow;
        if (edgeEffect != null && !edgeEffect.isFinished() && n2 > 0) {
            this.mLeftGlow.onRelease();
            bl = this.mLeftGlow.isFinished();
        } else {
            bl = false;
        }
        edgeEffect = this.mRightGlow;
        boolean bl2 = bl;
        if (edgeEffect != null) {
            bl2 = bl;
            if (!edgeEffect.isFinished()) {
                bl2 = bl;
                if (n2 < 0) {
                    this.mRightGlow.onRelease();
                    bl2 = bl | this.mRightGlow.isFinished();
                }
            }
        }
        edgeEffect = this.mTopGlow;
        bl = bl2;
        if (edgeEffect != null) {
            bl = bl2;
            if (!edgeEffect.isFinished()) {
                bl = bl2;
                if (n3 > 0) {
                    this.mTopGlow.onRelease();
                    bl = bl2 | this.mTopGlow.isFinished();
                }
            }
        }
        edgeEffect = this.mBottomGlow;
        bl2 = bl;
        if (edgeEffect != null) {
            bl2 = bl;
            if (!edgeEffect.isFinished()) {
                bl2 = bl;
                if (n3 < 0) {
                    this.mBottomGlow.onRelease();
                    bl2 = bl | this.mBottomGlow.isFinished();
                }
            }
        }
        if (bl2) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    void consumePendingUpdateOperations() {
        if (this.mFirstLayoutComplete && !this.mDataSetHasChangedAfterLayout) {
            if (!this.mAdapterHelper.hasPendingUpdates()) {
                return;
            }
            if (this.mAdapterHelper.hasAnyUpdateTypes(4) && !this.mAdapterHelper.hasAnyUpdateTypes(11)) {
                TraceCompat.beginSection((String)TRACE_HANDLE_ADAPTER_UPDATES_TAG);
                this.startInterceptRequestLayout();
                this.onEnterLayoutOrScroll();
                this.mAdapterHelper.preProcess();
                if (!this.mLayoutWasDefered) {
                    if (this.hasUpdatedView()) {
                        this.dispatchLayout();
                    } else {
                        this.mAdapterHelper.consumePostponedUpdates();
                    }
                }
                this.stopInterceptRequestLayout(true);
                this.onExitLayoutOrScroll();
                TraceCompat.endSection();
            } else if (this.mAdapterHelper.hasPendingUpdates()) {
                TraceCompat.beginSection((String)TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG);
                this.dispatchLayout();
                TraceCompat.endSection();
            }
            return;
        }
        TraceCompat.beginSection((String)TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG);
        this.dispatchLayout();
        TraceCompat.endSection();
    }

    void defaultOnMeasure(int n2, int n3) {
        this.setMeasuredDimension(LayoutManager.chooseSize(n2, this.getPaddingLeft() + this.getPaddingRight(), ViewCompat.getMinimumWidth((View)this)), LayoutManager.chooseSize(n3, this.getPaddingTop() + this.getPaddingBottom(), ViewCompat.getMinimumHeight((View)this)));
    }

    void dispatchChildAttached(View view) {
        ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
        this.onChildAttachedToWindow(view);
        Object object = this.mAdapter;
        if (object != null && viewHolder != null) {
            ((Adapter)object).onViewAttachedToWindow(viewHolder);
        }
        if ((object = this.mOnChildAttachStateListeners) != null) {
            for (int i2 = object.size() - 1; i2 >= 0; --i2) {
                this.mOnChildAttachStateListeners.get(i2).onChildViewAttachedToWindow(view);
            }
        }
    }

    void dispatchChildDetached(View view) {
        Object object = RecyclerView.getChildViewHolderInt(view);
        this.onChildDetachedFromWindow(view);
        Adapter adapter = this.mAdapter;
        if (adapter != null && object != null) {
            adapter.onViewDetachedFromWindow(object);
        }
        if ((object = this.mOnChildAttachStateListeners) != null) {
            for (int i2 = object.size() - 1; i2 >= 0; --i2) {
                this.mOnChildAttachStateListeners.get(i2).onChildViewDetachedFromWindow(view);
            }
        }
    }

    void dispatchLayout() {
        if (this.mAdapter == null) {
            Log.e((String)TAG, (String)"No adapter attached; skipping layout");
            return;
        }
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"No layout manager attached; skipping layout");
            return;
        }
        State state = this.mState;
        state.mIsMeasuring = false;
        if (state.mLayoutStep == 1) {
            this.dispatchLayoutStep1();
            this.mLayout.setExactMeasureSpecsFrom(this);
            this.dispatchLayoutStep2();
        } else if (!this.mAdapterHelper.hasUpdates() && this.mLayout.getWidth() == this.getWidth() && this.mLayout.getHeight() == this.getHeight()) {
            this.mLayout.setExactMeasureSpecsFrom(this);
        } else {
            this.mLayout.setExactMeasureSpecsFrom(this);
            this.dispatchLayoutStep2();
        }
        this.dispatchLayoutStep3();
    }

    public boolean dispatchNestedFling(float f2, float f3, boolean bl) {
        return this.getScrollingChildHelper().dispatchNestedFling(f2, f3, bl);
    }

    public boolean dispatchNestedPreFling(float f2, float f3) {
        return this.getScrollingChildHelper().dispatchNestedPreFling(f2, f3);
    }

    public boolean dispatchNestedPreScroll(int n2, int n3, int[] nArray, int[] nArray2) {
        return this.getScrollingChildHelper().dispatchNestedPreScroll(n2, n3, nArray, nArray2);
    }

    public boolean dispatchNestedPreScroll(int n2, int n3, int[] nArray, int[] nArray2, int n4) {
        return this.getScrollingChildHelper().dispatchNestedPreScroll(n2, n3, nArray, nArray2, n4);
    }

    public final void dispatchNestedScroll(int n2, int n3, int n4, int n5, int[] nArray, int n6, int[] nArray2) {
        this.getScrollingChildHelper().dispatchNestedScroll(n2, n3, n4, n5, nArray, n6, nArray2);
    }

    public boolean dispatchNestedScroll(int n2, int n3, int n4, int n5, int[] nArray) {
        return this.getScrollingChildHelper().dispatchNestedScroll(n2, n3, n4, n5, nArray);
    }

    public boolean dispatchNestedScroll(int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        return this.getScrollingChildHelper().dispatchNestedScroll(n2, n3, n4, n5, nArray, n6);
    }

    void dispatchOnScrollStateChanged(int n2) {
        Object object = this.mLayout;
        if (object != null) {
            ((LayoutManager)object).onScrollStateChanged(n2);
        }
        this.onScrollStateChanged(n2);
        object = this.mScrollListener;
        if (object != null) {
            ((OnScrollListener)object).onScrollStateChanged(this, n2);
        }
        if ((object = this.mScrollListeners) != null) {
            for (int i2 = object.size() - 1; i2 >= 0; --i2) {
                this.mScrollListeners.get(i2).onScrollStateChanged(this, n2);
            }
        }
    }

    void dispatchOnScrolled(int n2, int n3) {
        ++this.mDispatchScrollCounter;
        int n4 = this.getScrollX();
        int n5 = this.getScrollY();
        this.onScrollChanged(n4, n5, n4 - n2, n5 - n3);
        this.onScrolled(n2, n3);
        Object object = this.mScrollListener;
        if (object != null) {
            ((OnScrollListener)object).onScrolled(this, n2, n3);
        }
        if ((object = this.mScrollListeners) != null) {
            for (n5 = object.size() - 1; n5 >= 0; --n5) {
                this.mScrollListeners.get(n5).onScrolled(this, n2, n3);
            }
        }
        --this.mDispatchScrollCounter;
    }

    void dispatchPendingImportantForAccessibilityChanges() {
        for (int i2 = this.mPendingAccessibilityImportanceChange.size() - 1; i2 >= 0; --i2) {
            int n2;
            ViewHolder viewHolder = this.mPendingAccessibilityImportanceChange.get(i2);
            if (viewHolder.itemView.getParent() != this || viewHolder.shouldIgnore() || (n2 = viewHolder.mPendingAccessibilityState) == -1) continue;
            ViewCompat.setImportantForAccessibility(viewHolder.itemView, n2);
            viewHolder.mPendingAccessibilityState = -1;
        }
        this.mPendingAccessibilityImportanceChange.clear();
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        this.onPopulateAccessibilityEvent(accessibilityEvent);
        return true;
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        this.dispatchThawSelfOnly(sparseArray);
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        this.dispatchFreezeSelfOnly(sparseArray);
    }

    public void draw(Canvas canvas) {
        int n2;
        int n3;
        super.draw(canvas);
        int n4 = this.mItemDecorations.size();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            this.mItemDecorations.get(n3).onDrawOver(canvas, this, this.mState);
        }
        EdgeEffect edgeEffect = this.mLeftGlow;
        if (edgeEffect != null && !edgeEffect.isFinished()) {
            n2 = canvas.save();
            n3 = this.mClipToPadding ? this.getPaddingBottom() : 0;
            canvas.rotate(270.0f);
            canvas.translate((float)(-this.getHeight() + n3), 0.0f);
            edgeEffect = this.mLeftGlow;
            n4 = edgeEffect != null && edgeEffect.draw(canvas) ? 1 : 0;
            canvas.restoreToCount(n2);
        } else {
            n4 = 0;
        }
        edgeEffect = this.mTopGlow;
        n3 = n4;
        if (edgeEffect != null) {
            n3 = n4;
            if (!edgeEffect.isFinished()) {
                n2 = canvas.save();
                if (this.mClipToPadding) {
                    canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
                }
                n3 = (edgeEffect = this.mTopGlow) != null && edgeEffect.draw(canvas) ? 1 : 0;
                n3 = n4 | n3;
                canvas.restoreToCount(n2);
            }
        }
        edgeEffect = this.mRightGlow;
        n4 = n3;
        if (edgeEffect != null) {
            n4 = n3;
            if (!edgeEffect.isFinished()) {
                n2 = canvas.save();
                int n6 = this.getWidth();
                n4 = this.mClipToPadding ? this.getPaddingTop() : 0;
                canvas.rotate(90.0f);
                canvas.translate((float)(-n4), (float)(-n6));
                edgeEffect = this.mRightGlow;
                n4 = edgeEffect != null && edgeEffect.draw(canvas) ? 1 : 0;
                n4 = n3 | n4;
                canvas.restoreToCount(n2);
            }
        }
        if ((edgeEffect = this.mBottomGlow) != null && !edgeEffect.isFinished()) {
            n2 = canvas.save();
            canvas.rotate(180.0f);
            if (this.mClipToPadding) {
                canvas.translate((float)(-this.getWidth() + this.getPaddingRight()), (float)(-this.getHeight() + this.getPaddingBottom()));
            } else {
                canvas.translate((float)(-this.getWidth()), (float)(-this.getHeight()));
            }
            edgeEffect = this.mBottomGlow;
            n3 = n5;
            if (edgeEffect != null) {
                n3 = n5;
                if (edgeEffect.draw(canvas)) {
                    n3 = 1;
                }
            }
            n3 |= n4;
            canvas.restoreToCount(n2);
        } else {
            n3 = n4;
        }
        n4 = n3;
        if (n3 == 0) {
            n4 = n3;
            if (this.mItemAnimator != null) {
                n4 = n3;
                if (this.mItemDecorations.size() > 0) {
                    n4 = n3;
                    if (this.mItemAnimator.isRunning()) {
                        n4 = 1;
                    }
                }
            }
        }
        if (n4 != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public boolean drawChild(Canvas canvas, View view, long l2) {
        return super.drawChild(canvas, view, l2);
    }

    void ensureBottomGlow() {
        if (this.mBottomGlow != null) {
            return;
        }
        this.mBottomGlow = this.mEdgeEffectFactory.createEdgeEffect(this, 3);
        if (this.mClipToPadding) {
            this.mBottomGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
        } else {
            this.mBottomGlow.setSize(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    void ensureLeftGlow() {
        if (this.mLeftGlow != null) {
            return;
        }
        this.mLeftGlow = this.mEdgeEffectFactory.createEdgeEffect(this, 0);
        if (this.mClipToPadding) {
            this.mLeftGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
        } else {
            this.mLeftGlow.setSize(this.getMeasuredHeight(), this.getMeasuredWidth());
        }
    }

    void ensureRightGlow() {
        if (this.mRightGlow != null) {
            return;
        }
        this.mRightGlow = this.mEdgeEffectFactory.createEdgeEffect(this, 2);
        if (this.mClipToPadding) {
            this.mRightGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
        } else {
            this.mRightGlow.setSize(this.getMeasuredHeight(), this.getMeasuredWidth());
        }
    }

    void ensureTopGlow() {
        if (this.mTopGlow != null) {
            return;
        }
        this.mTopGlow = this.mEdgeEffectFactory.createEdgeEffect(this, 1);
        if (this.mClipToPadding) {
            this.mTopGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
        } else {
            this.mTopGlow.setSize(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    String exceptionLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ");
        stringBuilder.append(super.toString());
        stringBuilder.append(", adapter:");
        stringBuilder.append(this.mAdapter);
        stringBuilder.append(", layout:");
        stringBuilder.append(this.mLayout);
        stringBuilder.append(", context:");
        stringBuilder.append(this.getContext());
        return stringBuilder.toString();
    }

    final void fillRemainingScrollValues(State state) {
        if (this.getScrollState() == 2) {
            OverScroller overScroller = this.mViewFlinger.mOverScroller;
            state.mRemainingScrollHorizontal = overScroller.getFinalX() - overScroller.getCurrX();
            state.mRemainingScrollVertical = overScroller.getFinalY() - overScroller.getCurrY();
        } else {
            state.mRemainingScrollHorizontal = 0;
            state.mRemainingScrollVertical = 0;
        }
    }

    public View findChildViewUnder(float f2, float f3) {
        for (int i2 = this.mChildHelper.getChildCount() - 1; i2 >= 0; --i2) {
            View view = this.mChildHelper.getChildAt(i2);
            float f4 = view.getTranslationX();
            float f5 = view.getTranslationY();
            if (!(f2 >= (float)view.getLeft() + f4) || !(f2 <= (float)view.getRight() + f4) || !(f3 >= (float)view.getTop() + f5) || !(f3 <= (float)view.getBottom() + f5)) continue;
            return view;
        }
        return null;
    }

    public View findContainingItemView(View view) {
        ViewParent viewParent = view.getParent();
        while (viewParent != null && viewParent != this && viewParent instanceof View) {
            view = (View)viewParent;
            viewParent = view.getParent();
        }
        if (viewParent != this) {
            view = null;
        }
        return view;
    }

    public ViewHolder findContainingViewHolder(View object) {
        object = (object = this.findContainingItemView((View)object)) == null ? null : this.getChildViewHolder((View)object);
        return object;
    }

    public ViewHolder findViewHolderForAdapterPosition(int n2) {
        boolean bl = this.mDataSetHasChangedAfterLayout;
        ViewHolder viewHolder = null;
        if (bl) {
            return null;
        }
        int n3 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            ViewHolder viewHolder2 = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i2));
            ViewHolder viewHolder3 = viewHolder;
            if (viewHolder2 != null) {
                viewHolder3 = viewHolder;
                if (!viewHolder2.isRemoved()) {
                    viewHolder3 = viewHolder;
                    if (this.getAdapterPositionFor(viewHolder2) == n2) {
                        if (this.mChildHelper.isHidden(viewHolder2.itemView)) {
                            viewHolder3 = viewHolder2;
                        } else {
                            return viewHolder2;
                        }
                    }
                }
            }
            viewHolder = viewHolder3;
        }
        return viewHolder;
    }

    public ViewHolder findViewHolderForItemId(long l2) {
        Adapter adapter = this.mAdapter;
        ViewHolder viewHolder = null;
        ViewHolder viewHolder2 = null;
        ViewHolder viewHolder3 = viewHolder;
        if (adapter != null) {
            if (!adapter.hasStableIds()) {
                viewHolder3 = viewHolder;
            } else {
                int n2 = this.mChildHelper.getUnfilteredChildCount();
                int n3 = 0;
                while (true) {
                    viewHolder3 = viewHolder2;
                    if (n3 >= n2) break;
                    viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(n3));
                    viewHolder3 = viewHolder2;
                    if (viewHolder != null) {
                        viewHolder3 = viewHolder2;
                        if (!viewHolder.isRemoved()) {
                            viewHolder3 = viewHolder2;
                            if (viewHolder.getItemId() == l2) {
                                if (this.mChildHelper.isHidden(viewHolder.itemView)) {
                                    viewHolder3 = viewHolder;
                                } else {
                                    return viewHolder;
                                }
                            }
                        }
                    }
                    ++n3;
                    viewHolder2 = viewHolder3;
                }
            }
        }
        return viewHolder3;
    }

    public ViewHolder findViewHolderForLayoutPosition(int n2) {
        return this.findViewHolderForPosition(n2, false);
    }

    @Deprecated
    public ViewHolder findViewHolderForPosition(int n2) {
        return this.findViewHolderForPosition(n2, false);
    }

    /*
     * Unable to fully structure code
     */
    ViewHolder findViewHolderForPosition(int var1_1, boolean var2_2) {
        var3_3 = this.mChildHelper.getUnfilteredChildCount();
        var4_4 = null;
        for (var5_5 = 0; var5_5 < var3_3; ++var5_5) {
            block5: {
                block6: {
                    var6_6 = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(var5_5));
                    var7_7 = var4_4;
                    if (var6_6 == null) break block5;
                    var7_7 = var4_4;
                    if (var6_6.isRemoved()) break block5;
                    if (!var2_2) break block6;
                    if (var6_6.mPosition == var1_1) ** GOTO lbl-1000
                    var7_7 = var4_4;
                    break block5;
                }
                if (var6_6.getLayoutPosition() != var1_1) {
                    var7_7 = var4_4;
                } else if (this.mChildHelper.isHidden(var6_6.itemView)) {
                    var7_7 = var6_6;
                } else {
                    return var6_6;
                }
            }
            var4_4 = var7_7;
        }
        return var4_4;
    }

    public boolean fling(int n2, int n3) {
        int n4;
        int n5;
        boolean bl;
        boolean bl2;
        int n6;
        Object object;
        block17: {
            block16: {
                block15: {
                    block14: {
                        object = this.mLayout;
                        n6 = 0;
                        if (object == null) {
                            Log.e((String)TAG, (String)"Cannot fling without a LayoutManager set. Call setLayoutManager with a non-null argument.");
                            return false;
                        }
                        if (this.mLayoutSuppressed) {
                            return false;
                        }
                        bl2 = ((LayoutManager)object).canScrollHorizontally();
                        bl = this.mLayout.canScrollVertically();
                        if (!bl2) break block14;
                        n5 = n2;
                        if (Math.abs(n2) >= this.mMinFlingVelocity) break block15;
                    }
                    n5 = 0;
                }
                if (!bl) break block16;
                n4 = n3;
                if (Math.abs(n3) >= this.mMinFlingVelocity) break block17;
            }
            n4 = 0;
        }
        if (n5 == 0 && n4 == 0) {
            return false;
        }
        float f2 = n5;
        float f3 = n4;
        if (!this.dispatchNestedPreFling(f2, f3)) {
            boolean bl3 = bl2 || bl;
            this.dispatchNestedFling(f2, f3, bl3);
            object = this.mOnFlingListener;
            if (object != null && ((OnFlingListener)object).onFling(n5, n4)) {
                return true;
            }
            if (bl3) {
                n2 = n6;
                if (bl2) {
                    n2 = 1;
                }
                n3 = n2;
                if (bl) {
                    n3 = n2 | 2;
                }
                this.startNestedScroll(n3, 1);
                n2 = this.mMaxFlingVelocity;
                n2 = Math.max(-n2, Math.min(n5, n2));
                n3 = this.mMaxFlingVelocity;
                n3 = Math.max(-n3, Math.min(n4, n3));
                this.mViewFlinger.fling(n2, n3);
                return true;
            }
        }
        return false;
    }

    public View focusSearch(View view, int n2) {
        View view2 = this.mLayout.onInterceptFocusSearch(view, n2);
        if (view2 != null) {
            return view2;
        }
        int n3 = this.mAdapter != null && this.mLayout != null && !this.isComputingLayout() && !this.mLayoutSuppressed ? 1 : 0;
        view2 = FocusFinder.getInstance();
        if (n3 != 0 && (n2 == 2 || n2 == 1)) {
            int n4;
            int n5;
            if (this.mLayout.canScrollVertically()) {
                n5 = n2 == 2 ? 130 : 33;
                n4 = view2.findNextFocus((ViewGroup)this, view, n5) == null ? 1 : 0;
                n3 = n4;
                if (FORCE_ABS_FOCUS_SEARCH_DIRECTION) {
                    n2 = n5;
                    n3 = n4;
                }
            } else {
                n3 = 0;
            }
            int n6 = n3;
            n4 = n2;
            if (n3 == 0) {
                n6 = n3;
                n4 = n2;
                if (this.mLayout.canScrollHorizontally()) {
                    n3 = this.mLayout.getLayoutDirection() == 1 ? 1 : 0;
                    n5 = n2 == 2 ? 1 : 0;
                    n3 = (n3 ^ n5) != 0 ? 66 : 17;
                    n5 = view2.findNextFocus((ViewGroup)this, view, n3) == null ? 1 : 0;
                    n6 = n5;
                    n4 = n2;
                    if (FORCE_ABS_FOCUS_SEARCH_DIRECTION) {
                        n4 = n3;
                        n6 = n5;
                    }
                }
            }
            if (n6 != 0) {
                this.consumePendingUpdateOperations();
                if (this.findContainingItemView(view) == null) {
                    return null;
                }
                this.startInterceptRequestLayout();
                this.mLayout.onFocusSearchFailed(view, n4, this.mRecycler, this.mState);
                this.stopInterceptRequestLayout(false);
            }
            view2 = view2.findNextFocus((ViewGroup)this, view, n4);
            n2 = n4;
        } else if ((view2 = view2.findNextFocus((ViewGroup)this, view, n2)) == null && n3 != 0) {
            this.consumePendingUpdateOperations();
            if (this.findContainingItemView(view) == null) {
                return null;
            }
            this.startInterceptRequestLayout();
            view2 = this.mLayout.onFocusSearchFailed(view, n2, this.mRecycler, this.mState);
            this.stopInterceptRequestLayout(false);
        }
        if (view2 != null && !view2.hasFocusable()) {
            if (this.getFocusedChild() == null) {
                return super.focusSearch(view, n2);
            }
            this.requestChildOnScreen(view2, null);
            return view;
        }
        if (!this.isPreferredNextFocus(view, view2, n2)) {
            view2 = super.focusSearch(view, n2);
        }
        return view2;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        Object object = this.mLayout;
        if (object != null) {
            return ((LayoutManager)object).generateDefaultLayoutParams();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("RecyclerView has no LayoutManager");
        ((StringBuilder)object).append(this.exceptionLabel());
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet object) {
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager != null) {
            return layoutManager.generateLayoutParams(this.getContext(), (AttributeSet)object);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("RecyclerView has no LayoutManager");
        ((StringBuilder)object).append(this.exceptionLabel());
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams object) {
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager != null) {
            return layoutManager.generateLayoutParams((ViewGroup.LayoutParams)object);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("RecyclerView has no LayoutManager");
        ((StringBuilder)object).append(this.exceptionLabel());
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    public CharSequence getAccessibilityClassName() {
        return "androidx.recyclerview.widget.RecyclerView";
    }

    public Adapter getAdapter() {
        return this.mAdapter;
    }

    int getAdapterPositionFor(ViewHolder viewHolder) {
        if (!viewHolder.hasAnyOfTheFlags(524) && viewHolder.isBound()) {
            return this.mAdapterHelper.applyPendingUpdatesToPosition(viewHolder.mPosition);
        }
        return -1;
    }

    public int getBaseline() {
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager != null) {
            return layoutManager.getBaseline();
        }
        return super.getBaseline();
    }

    long getChangedHolderKey(ViewHolder viewHolder) {
        long l2 = this.mAdapter.hasStableIds() ? viewHolder.getItemId() : (long)viewHolder.mPosition;
        return l2;
    }

    public int getChildAdapterPosition(View object) {
        int n2 = (object = RecyclerView.getChildViewHolderInt((View)object)) != null ? ((ViewHolder)object).getAdapterPosition() : -1;
        return n2;
    }

    protected int getChildDrawingOrder(int n2, int n3) {
        ChildDrawingOrderCallback childDrawingOrderCallback = this.mChildDrawingOrderCallback;
        if (childDrawingOrderCallback == null) {
            return super.getChildDrawingOrder(n2, n3);
        }
        return childDrawingOrderCallback.onGetChildDrawingOrder(n2, n3);
    }

    public long getChildItemId(View object) {
        long l2;
        Adapter adapter = this.mAdapter;
        long l3 = l2 = -1L;
        if (adapter != null) {
            if (!adapter.hasStableIds()) {
                l3 = l2;
            } else {
                object = RecyclerView.getChildViewHolderInt((View)object);
                l3 = l2;
                if (object != null) {
                    l3 = ((ViewHolder)object).getItemId();
                }
            }
        }
        return l3;
    }

    public int getChildLayoutPosition(View object) {
        int n2 = (object = RecyclerView.getChildViewHolderInt((View)object)) != null ? ((ViewHolder)object).getLayoutPosition() : -1;
        return n2;
    }

    @Deprecated
    public int getChildPosition(View view) {
        return this.getChildAdapterPosition(view);
    }

    public ViewHolder getChildViewHolder(View view) {
        Object object = view.getParent();
        if (object != null && object != this) {
            object = new StringBuilder();
            ((StringBuilder)object).append("View ");
            ((StringBuilder)object).append(view);
            ((StringBuilder)object).append(" is not a direct child of ");
            ((StringBuilder)object).append((Object)this);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        return RecyclerView.getChildViewHolderInt(view);
    }

    public boolean getClipToPadding() {
        return this.mClipToPadding;
    }

    public RecyclerViewAccessibilityDelegate getCompatAccessibilityDelegate() {
        return this.mAccessibilityDelegate;
    }

    public void getDecoratedBoundsWithMargins(View view, Rect rect) {
        RecyclerView.getDecoratedBoundsWithMarginsInt(view, rect);
    }

    public EdgeEffectFactory getEdgeEffectFactory() {
        return this.mEdgeEffectFactory;
    }

    public ItemAnimator getItemAnimator() {
        return this.mItemAnimator;
    }

    Rect getItemDecorInsetsForChild(View view) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (!layoutParams.mInsetsDirty) {
            return layoutParams.mDecorInsets;
        }
        if (this.mState.isPreLayout() && (layoutParams.isItemChanged() || layoutParams.isViewInvalid())) {
            return layoutParams.mDecorInsets;
        }
        Rect rect = layoutParams.mDecorInsets;
        rect.set(0, 0, 0, 0);
        int n2 = this.mItemDecorations.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mTempRect.set(0, 0, 0, 0);
            this.mItemDecorations.get(i2).getItemOffsets(this.mTempRect, view, this, this.mState);
            rect.left += this.mTempRect.left;
            rect.top += this.mTempRect.top;
            rect.right += this.mTempRect.right;
            rect.bottom += this.mTempRect.bottom;
        }
        layoutParams.mInsetsDirty = false;
        return rect;
    }

    public ItemDecoration getItemDecorationAt(int n2) {
        int n3 = this.getItemDecorationCount();
        if (n2 >= 0 && n2 < n3) {
            return this.mItemDecorations.get(n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2);
        stringBuilder.append(" is an invalid index for size ");
        stringBuilder.append(n3);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int getItemDecorationCount() {
        return this.mItemDecorations.size();
    }

    public LayoutManager getLayoutManager() {
        return this.mLayout;
    }

    public int getMaxFlingVelocity() {
        return this.mMaxFlingVelocity;
    }

    public int getMinFlingVelocity() {
        return this.mMinFlingVelocity;
    }

    long getNanoTime() {
        if (ALLOW_THREAD_GAP_WORK) {
            return System.nanoTime();
        }
        return 0L;
    }

    public OnFlingListener getOnFlingListener() {
        return this.mOnFlingListener;
    }

    public boolean getPreserveFocusAfterLayout() {
        return this.mPreserveFocusAfterLayout;
    }

    public RecycledViewPool getRecycledViewPool() {
        return this.mRecycler.getRecycledViewPool();
    }

    public int getScrollState() {
        return this.mScrollState;
    }

    public boolean hasFixedSize() {
        return this.mHasFixedSize;
    }

    public boolean hasNestedScrollingParent() {
        return this.getScrollingChildHelper().hasNestedScrollingParent();
    }

    public boolean hasNestedScrollingParent(int n2) {
        return this.getScrollingChildHelper().hasNestedScrollingParent(n2);
    }

    public boolean hasPendingAdapterUpdates() {
        boolean bl = !this.mFirstLayoutComplete || this.mDataSetHasChangedAfterLayout || this.mAdapterHelper.hasPendingUpdates();
        return bl;
    }

    void initAdapterManager() {
        this.mAdapterHelper = new AdapterHelper(new AdapterHelper.Callback(){

            void dispatchUpdate(AdapterHelper.UpdateOp updateOp) {
                int n2 = updateOp.cmd;
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 != 4) {
                            if (n2 == 8) {
                                RecyclerView.this.mLayout.onItemsMoved(RecyclerView.this, updateOp.positionStart, updateOp.itemCount, 1);
                            }
                        } else {
                            RecyclerView.this.mLayout.onItemsUpdated(RecyclerView.this, updateOp.positionStart, updateOp.itemCount, updateOp.payload);
                        }
                    } else {
                        RecyclerView.this.mLayout.onItemsRemoved(RecyclerView.this, updateOp.positionStart, updateOp.itemCount);
                    }
                } else {
                    RecyclerView.this.mLayout.onItemsAdded(RecyclerView.this, updateOp.positionStart, updateOp.itemCount);
                }
            }

            public ViewHolder findViewHolder(int n2) {
                ViewHolder viewHolder = RecyclerView.this.findViewHolderForPosition(n2, true);
                if (viewHolder == null) {
                    return null;
                }
                if (RecyclerView.this.mChildHelper.isHidden(viewHolder.itemView)) {
                    return null;
                }
                return viewHolder;
            }

            public void markViewHoldersUpdated(int n2, int n3, Object object) {
                RecyclerView.this.viewRangeUpdate(n2, n3, object);
                RecyclerView.this.mItemsChanged = true;
            }

            public void offsetPositionsForAdd(int n2, int n3) {
                RecyclerView.this.offsetPositionRecordsForInsert(n2, n3);
                RecyclerView.this.mItemsAddedOrRemoved = true;
            }

            public void offsetPositionsForMove(int n2, int n3) {
                RecyclerView.this.offsetPositionRecordsForMove(n2, n3);
                RecyclerView.this.mItemsAddedOrRemoved = true;
            }

            public void offsetPositionsForRemovingInvisible(int n2, int n3) {
                RecyclerView.this.offsetPositionRecordsForRemove(n2, n3, true);
                Object object = RecyclerView.this;
                object.mItemsAddedOrRemoved = true;
                object = object.mState;
                ((State)object).mDeletedInvisibleItemCountSincePreviousLayout += n3;
            }

            public void offsetPositionsForRemovingLaidOutOrNewView(int n2, int n3) {
                RecyclerView.this.offsetPositionRecordsForRemove(n2, n3, false);
                RecyclerView.this.mItemsAddedOrRemoved = true;
            }

            public void onDispatchFirstPass(AdapterHelper.UpdateOp updateOp) {
                this.dispatchUpdate(updateOp);
            }

            public void onDispatchSecondPass(AdapterHelper.UpdateOp updateOp) {
                this.dispatchUpdate(updateOp);
            }
        });
    }

    void initFastScroller(StateListDrawable object, Drawable drawable2, StateListDrawable stateListDrawable, Drawable drawable3) {
        if (object != null && drawable2 != null && stateListDrawable != null && drawable3 != null) {
            Resources resources = this.getContext().getResources();
            new FastScroller(this, (StateListDrawable)object, drawable2, stateListDrawable, drawable3, resources.getDimensionPixelSize(R.dimen.fastscroll_default_thickness), resources.getDimensionPixelSize(R.dimen.fastscroll_minimum_range), resources.getDimensionPixelOffset(R.dimen.fastscroll_margin));
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Trying to set fast scroller without both required drawables.");
        ((StringBuilder)object).append(this.exceptionLabel());
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    void invalidateGlows() {
        this.mBottomGlow = null;
        this.mTopGlow = null;
        this.mRightGlow = null;
        this.mLeftGlow = null;
    }

    public void invalidateItemDecorations() {
        if (this.mItemDecorations.size() == 0) {
            return;
        }
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager != null) {
            layoutManager.assertNotInLayoutOrScroll("Cannot invalidate item decorations during a scroll or layout");
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    boolean isAccessibilityEnabled() {
        AccessibilityManager accessibilityManager = this.mAccessibilityManager;
        boolean bl = accessibilityManager != null && accessibilityManager.isEnabled();
        return bl;
    }

    public boolean isAnimating() {
        ItemAnimator itemAnimator = this.mItemAnimator;
        boolean bl = itemAnimator != null && itemAnimator.isRunning();
        return bl;
    }

    public boolean isAttachedToWindow() {
        return this.mIsAttached;
    }

    public boolean isComputingLayout() {
        boolean bl = this.mLayoutOrScrollCounter > 0;
        return bl;
    }

    @Deprecated
    public boolean isLayoutFrozen() {
        return this.isLayoutSuppressed();
    }

    public final boolean isLayoutSuppressed() {
        return this.mLayoutSuppressed;
    }

    public boolean isNestedScrollingEnabled() {
        return this.getScrollingChildHelper().isNestedScrollingEnabled();
    }

    void jumpToPositionForSmoothScroller(int n2) {
        if (this.mLayout == null) {
            return;
        }
        this.setScrollState(2);
        this.mLayout.scrollToPosition(n2);
        this.awakenScrollBars();
    }

    void markItemDecorInsetsDirty() {
        int n2 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((LayoutParams)this.mChildHelper.getUnfilteredChildAt((int)i2).getLayoutParams()).mInsetsDirty = true;
        }
        this.mRecycler.markItemDecorInsetsDirty();
    }

    void markKnownViewsInvalid() {
        int n2 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i2));
            if (viewHolder == null || viewHolder.shouldIgnore()) continue;
            viewHolder.addFlags(6);
        }
        this.markItemDecorInsetsDirty();
        this.mRecycler.markKnownViewsInvalid();
    }

    public void offsetChildrenHorizontal(int n2) {
        int n3 = this.mChildHelper.getChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.mChildHelper.getChildAt(i2).offsetLeftAndRight(n2);
        }
    }

    public void offsetChildrenVertical(int n2) {
        int n3 = this.mChildHelper.getChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.mChildHelper.getChildAt(i2).offsetTopAndBottom(n2);
        }
    }

    void offsetPositionRecordsForInsert(int n2, int n3) {
        int n4 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i2));
            if (viewHolder == null || viewHolder.shouldIgnore() || viewHolder.mPosition < n2) continue;
            viewHolder.offsetPosition(n3, false);
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForInsert(n2, n3);
        this.requestLayout();
    }

    void offsetPositionRecordsForMove(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = this.mChildHelper.getUnfilteredChildCount();
        if (n2 < n3) {
            n6 = n2;
            n5 = n3;
            n4 = -1;
        } else {
            n5 = n2;
            n6 = n3;
            n4 = 1;
        }
        for (int i2 = 0; i2 < n7; ++i2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i2));
            if (viewHolder == null || viewHolder.mPosition < n6 || viewHolder.mPosition > n5) continue;
            if (viewHolder.mPosition == n2) {
                viewHolder.offsetPosition(n3 - n2, false);
            } else {
                viewHolder.offsetPosition(n4, false);
            }
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForMove(n2, n3);
        this.requestLayout();
    }

    void offsetPositionRecordsForRemove(int n2, int n3, boolean bl) {
        int n4 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i2));
            if (viewHolder == null || viewHolder.shouldIgnore()) continue;
            if (viewHolder.mPosition >= n2 + n3) {
                viewHolder.offsetPosition(-n3, bl);
                this.mState.mStructureChanged = true;
                continue;
            }
            if (viewHolder.mPosition < n2) continue;
            viewHolder.flagRemovedAndOffsetPosition(n2 - 1, -n3, bl);
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForRemove(n2, n3, bl);
        this.requestLayout();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mLayoutOrScrollCounter = 0;
        boolean bl = true;
        this.mIsAttached = true;
        if (!this.mFirstLayoutComplete || this.isLayoutRequested()) {
            bl = false;
        }
        this.mFirstLayoutComplete = bl;
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager != null) {
            layoutManager.dispatchAttachedToWindow(this);
        }
        this.mPostedAnimatorRunner = false;
        if (ALLOW_THREAD_GAP_WORK) {
            this.mGapWorker = (GapWorker)GapWorker.sGapWorker.get();
            if (this.mGapWorker == null) {
                float f2;
                this.mGapWorker = new GapWorker();
                layoutManager = ViewCompat.getDisplay((View)this);
                if (this.isInEditMode() || layoutManager == null || !((f2 = layoutManager.getRefreshRate()) >= 30.0f)) {
                    f2 = 60.0f;
                }
                this.mGapWorker.mFrameIntervalNs = (long)(1.0E9f / f2);
                GapWorker.sGapWorker.set(this.mGapWorker);
            }
            this.mGapWorker.add(this);
        }
    }

    public void onChildAttachedToWindow(View view) {
    }

    public void onChildDetachedFromWindow(View view) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Object object = this.mItemAnimator;
        if (object != null) {
            ((ItemAnimator)object).endAnimations();
        }
        this.stopScroll();
        this.mIsAttached = false;
        object = this.mLayout;
        if (object != null) {
            ((LayoutManager)object).dispatchDetachedFromWindow(this, this.mRecycler);
        }
        this.mPendingAccessibilityImportanceChange.clear();
        this.removeCallbacks(this.mItemAnimatorRunner);
        this.mViewInfoStore.onDetach();
        if (ALLOW_THREAD_GAP_WORK && (object = this.mGapWorker) != null) {
            object.remove(this);
            this.mGapWorker = null;
        }
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int n2 = this.mItemDecorations.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mItemDecorations.get(i2).onDraw(canvas, this, this.mState);
        }
    }

    void onEnterLayoutOrScroll() {
        ++this.mLayoutOrScrollCounter;
    }

    void onExitLayoutOrScroll() {
        this.onExitLayoutOrScroll(true);
    }

    void onExitLayoutOrScroll(boolean bl) {
        --this.mLayoutOrScrollCounter;
        if (this.mLayoutOrScrollCounter < 1) {
            this.mLayoutOrScrollCounter = 0;
            if (bl) {
                this.dispatchContentChangedIfNecessary();
                this.dispatchPendingImportantForAccessibilityChanges();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean onGenericMotionEvent(MotionEvent var1_1) {
        block5: {
            block7: {
                block8: {
                    block6: {
                        if (this.mLayout == null) {
                            return false;
                        }
                        if (this.mLayoutSuppressed) {
                            return false;
                        }
                        if (var1_1.getAction() != 8) break block5;
                        if ((var1_1.getSource() & 2) == 0) break block6;
                        var2_2 = this.mLayout.canScrollVertically() != false ? -var1_1.getAxisValue(9) : 0.0f;
                        var3_3 = var2_2;
                        if (!this.mLayout.canScrollHorizontally()) ** GOTO lbl25
                        var4_4 = var1_1.getAxisValue(10);
                        var3_3 = var2_2;
                        var2_2 = var4_4;
                        break block7;
                    }
                    if ((var1_1.getSource() & 0x400000) == 0) ** GOTO lbl-1000
                    var2_2 = var1_1.getAxisValue(26);
                    if (!this.mLayout.canScrollVertically()) break block8;
                    var3_3 = -var2_2;
                    ** GOTO lbl25
                }
                if (this.mLayout.canScrollHorizontally()) {
                    var3_3 = 0.0f;
                } else lbl-1000:
                // 2 sources

                {
                    var3_3 = 0.0f;
lbl25:
                    // 3 sources

                    var2_2 = 0.0f;
                }
            }
            if (var3_3 != 0.0f || var2_2 != 0.0f) {
                this.scrollByInternal((int)(var2_2 * this.mScaledHorizontalScrollFactor), (int)(var3_3 * this.mScaledVerticalScrollFactor), var1_1);
            }
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent object) {
        boolean bl = this.mLayoutSuppressed;
        boolean bl2 = false;
        if (bl) {
            return false;
        }
        this.mInterceptingOnItemTouchListener = null;
        if (this.findInterceptingOnItemTouchListener((MotionEvent)object)) {
            this.cancelScroll();
            return true;
        }
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager == null) {
            return false;
        }
        boolean bl3 = layoutManager.canScrollHorizontally();
        bl = this.mLayout.canScrollVertically();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(object);
        int n2 = object.getActionMasked();
        int n3 = object.getActionIndex();
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 != 5) {
                            if (n2 == 6) {
                                this.onPointerUp((MotionEvent)object);
                            }
                        } else {
                            this.mScrollPointerId = object.getPointerId(n3);
                            this.mLastTouchX = n2 = (int)(object.getX(n3) + 0.5f);
                            this.mInitialTouchX = n2;
                            this.mLastTouchY = n3 = (int)(object.getY(n3) + 0.5f);
                            this.mInitialTouchY = n3;
                        }
                    } else {
                        this.cancelScroll();
                    }
                } else {
                    n2 = object.findPointerIndex(this.mScrollPointerId);
                    if (n2 < 0) {
                        object = new StringBuilder();
                        object.append("Error processing scroll; pointer index for id ");
                        object.append(this.mScrollPointerId);
                        object.append(" not found. Did any MotionEvents get skipped?");
                        Log.e((String)TAG, (String)object.toString());
                        return false;
                    }
                    n3 = (int)(object.getX(n2) + 0.5f);
                    int n4 = (int)(object.getY(n2) + 0.5f);
                    if (this.mScrollState != 1) {
                        n2 = this.mInitialTouchX;
                        int n5 = this.mInitialTouchY;
                        if (bl3 && Math.abs(n3 - n2) > this.mTouchSlop) {
                            this.mLastTouchX = n3;
                            n3 = 1;
                        } else {
                            n3 = 0;
                        }
                        n2 = n3;
                        if (bl) {
                            n2 = n3;
                            if (Math.abs(n4 - n5) > this.mTouchSlop) {
                                this.mLastTouchY = n4;
                                n2 = 1;
                            }
                        }
                        if (n2 != 0) {
                            this.setScrollState(1);
                        }
                    }
                }
            } else {
                this.mVelocityTracker.clear();
                this.stopNestedScroll(0);
            }
        } else {
            if (this.mIgnoreMotionEventTillDown) {
                this.mIgnoreMotionEventTillDown = false;
            }
            this.mScrollPointerId = object.getPointerId(0);
            this.mLastTouchX = n3 = (int)(object.getX() + 0.5f);
            this.mInitialTouchX = n3;
            this.mLastTouchY = n3 = (int)(object.getY() + 0.5f);
            this.mInitialTouchY = n3;
            if (this.mScrollState == 2) {
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.setScrollState(1);
                this.stopNestedScroll(1);
            }
            object = this.mNestedOffsets;
            object[1] = (MotionEvent)false;
            object[0] = (MotionEvent)false;
            n3 = bl3 ? 1 : 0;
            n2 = n3;
            if (bl) {
                n2 = n3 | 2;
            }
            this.startNestedScroll(n2, 0);
        }
        if (this.mScrollState == 1) {
            bl2 = true;
        }
        return bl2;
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        TraceCompat.beginSection((String)TRACE_ON_LAYOUT_TAG);
        this.dispatchLayout();
        TraceCompat.endSection();
        this.mFirstLayoutComplete = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onMeasure(int n2, int n3) {
        Object object = this.mLayout;
        if (object == null) {
            this.defaultOnMeasure(n2, n3);
            return;
        }
        boolean bl = ((LayoutManager)object).isAutoMeasureEnabled();
        boolean bl2 = false;
        if (bl) {
            int n4 = View.MeasureSpec.getMode((int)n2);
            int n5 = View.MeasureSpec.getMode((int)n3);
            this.mLayout.onMeasure(this.mRecycler, this.mState, n2, n3);
            boolean bl3 = bl2;
            if (n4 == 0x40000000) {
                bl3 = bl2;
                if (n5 == 0x40000000) {
                    return;
                }
            }
            if (bl3) return;
            if (this.mAdapter == null) return;
            if (this.mState.mLayoutStep == 1) {
                this.dispatchLayoutStep1();
            }
            this.mLayout.setMeasureSpecs(n2, n3);
            this.mState.mIsMeasuring = true;
            this.dispatchLayoutStep2();
            this.mLayout.setMeasuredDimensionFromChildren(n2, n3);
            if (!this.mLayout.shouldMeasureTwice()) return;
            this.mLayout.setMeasureSpecs(View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000));
            this.mState.mIsMeasuring = true;
            this.dispatchLayoutStep2();
            this.mLayout.setMeasuredDimensionFromChildren(n2, n3);
            return;
        } else {
            if (this.mHasFixedSize) {
                this.mLayout.onMeasure(this.mRecycler, this.mState, n2, n3);
                return;
            }
            if (this.mAdapterUpdateDuringMeasure) {
                this.startInterceptRequestLayout();
                this.onEnterLayoutOrScroll();
                this.processAdapterUpdatesAndSetAnimationFlags();
                this.onExitLayoutOrScroll();
                if (this.mState.mRunPredictiveAnimations) {
                    this.mState.mInPreLayout = true;
                } else {
                    this.mAdapterHelper.consumeUpdatesInOnePass();
                    this.mState.mInPreLayout = false;
                }
                this.mAdapterUpdateDuringMeasure = false;
                this.stopInterceptRequestLayout(false);
            } else if (this.mState.mRunPredictiveAnimations) {
                this.setMeasuredDimension(this.getMeasuredWidth(), this.getMeasuredHeight());
                return;
            }
            object = this.mAdapter;
            this.mState.mItemCount = object != null ? ((Adapter)object).getItemCount() : 0;
            this.startInterceptRequestLayout();
            this.mLayout.onMeasure(this.mRecycler, this.mState, n2, n3);
            this.stopInterceptRequestLayout(false);
            this.mState.mInPreLayout = false;
        }
    }

    protected boolean onRequestFocusInDescendants(int n2, Rect rect) {
        if (this.isComputingLayout()) {
            return false;
        }
        return super.onRequestFocusInDescendants(n2, rect);
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        this.mPendingSavedState = (SavedState)parcelable;
        super.onRestoreInstanceState(this.mPendingSavedState.getSuperState());
        if (this.mLayout != null && this.mPendingSavedState.mLayoutState != null) {
            this.mLayout.onRestoreInstanceState(this.mPendingSavedState.mLayoutState);
        }
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        Object object = this.mPendingSavedState;
        if (object != null) {
            savedState.copyFrom((SavedState)((Object)object));
        } else {
            object = this.mLayout;
            savedState.mLayoutState = object != null ? ((LayoutManager)object).onSaveInstanceState() : null;
        }
        return savedState;
    }

    public void onScrollStateChanged(int n2) {
    }

    public void onScrolled(int n2, int n3) {
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (n2 != n4 || n3 != n5) {
            this.invalidateGlows();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        block23: {
            block27: {
                block24: {
                    block25: {
                        block29: {
                            block28: {
                                block26: {
                                    var2_2 = this.mLayoutSuppressed;
                                    var3_3 = 0;
                                    if (var2_2 || this.mIgnoreMotionEventTillDown) break block23;
                                    if (this.dispatchToOnItemTouchListeners((MotionEvent)var1_1)) {
                                        this.cancelScroll();
                                        return true;
                                    }
                                    var4_4 = this.mLayout;
                                    if (var4_4 == null) {
                                        return false;
                                    }
                                    var2_2 = var4_4.canScrollHorizontally();
                                    var5_5 = this.mLayout.canScrollVertically();
                                    if (this.mVelocityTracker == null) {
                                        this.mVelocityTracker = VelocityTracker.obtain();
                                    }
                                    var6_6 = var1_1.getActionMasked();
                                    var7_7 = var1_1.getActionIndex();
                                    if (var6_6 == 0) {
                                        var4_4 = this.mNestedOffsets;
                                        var4_4[1] = false;
                                        var4_4[0] = false;
                                    }
                                    var4_4 = MotionEvent.obtain((MotionEvent)var1_1);
                                    var8_8 = this.mNestedOffsets;
                                    var4_4.offsetLocation((float)var8_8[0], (float)var8_8[1]);
                                    if (var6_6 == 0) break block24;
                                    if (var6_6 == 1) break block25;
                                    if (var6_6 == 2) break block26;
                                    if (var6_6 != 3) {
                                        if (var6_6 != 5) {
                                            if (var6_6 != 6) {
                                                var9_9 = var3_3;
                                            } else {
                                                this.onPointerUp((MotionEvent)var1_1);
                                                var9_9 = var3_3;
                                            }
                                        } else {
                                            this.mScrollPointerId = var1_1.getPointerId(var7_7);
                                            this.mLastTouchX = var6_6 = (int)(var1_1.getX(var7_7) + 0.5f);
                                            this.mInitialTouchX = var6_6;
                                            this.mLastTouchY = var7_7 = (int)(var1_1.getY(var7_7) + 0.5f);
                                            this.mInitialTouchY = var7_7;
                                            var9_9 = var3_3;
                                        }
                                    } else {
                                        this.cancelScroll();
                                        var9_9 = var3_3;
                                    }
                                    break block27;
                                }
                                var7_7 = var1_1.findPointerIndex(this.mScrollPointerId);
                                if (var7_7 < 0) {
                                    var1_1 = new StringBuilder();
                                    var1_1.append("Error processing scroll; pointer index for id ");
                                    var1_1.append(this.mScrollPointerId);
                                    var1_1.append(" not found. Did any MotionEvents get skipped?");
                                    Log.e((String)"RecyclerView", (String)var1_1.toString());
                                    return false;
                                }
                                var10_10 = (int)(var1_1.getX(var7_7) + 0.5f);
                                var11_11 = (int)(var1_1.getY(var7_7) + 0.5f);
                                var7_7 = this.mLastTouchX - var10_10;
                                var9_9 = this.mLastTouchY - var11_11;
                                var12_12 = var7_7;
                                var6_6 = var9_9;
                                if (this.mScrollState == 1) break block28;
                                var13_13 = var7_7;
                                if (!var2_2) ** GOTO lbl-1000
                                var7_7 = var7_7 > 0 ? Math.max(0, var7_7 - this.mTouchSlop) : Math.min(0, var7_7 + this.mTouchSlop);
                                var13_13 = var7_7;
                                if (var7_7 != 0) {
                                    var6_6 = 1;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var6_6 = 0;
                                    var7_7 = var13_13;
                                }
                                var13_13 = var9_9;
                                var14_14 = var6_6;
                                if (var5_5) {
                                    var12_12 = var9_9 > 0 ? Math.max(0, var9_9 - this.mTouchSlop) : Math.min(0, var9_9 + this.mTouchSlop);
                                    var13_13 = var12_12;
                                    var14_14 = var6_6;
                                    if (var12_12 != 0) {
                                        var14_14 = 1;
                                        var13_13 = var12_12;
                                    }
                                }
                                var12_12 = var7_7;
                                var6_6 = var13_13;
                                if (var14_14 != 0) {
                                    this.setScrollState(1);
                                    var6_6 = var13_13;
                                    var12_12 = var7_7;
                                }
                            }
                            var13_13 = var6_6;
                            var9_9 = var3_3;
                            if (this.mScrollState != 1) break block27;
                            var8_8 = this.mReusableIntPair;
                            var8_8[0] = 0;
                            var8_8[1] = 0;
                            var9_9 = var2_2 != false ? var12_12 : 0;
                            var14_14 = var5_5 != false ? var13_13 : 0;
                            var6_6 = var12_12;
                            var7_7 = var13_13;
                            if (this.dispatchNestedPreScroll(var9_9, var14_14, this.mReusableIntPair, this.mScrollOffset, 0)) {
                                var8_8 = this.mReusableIntPair;
                                var6_6 = var12_12 - var8_8[0];
                                var7_7 = var13_13 - var8_8[1];
                                var15_15 = this.mNestedOffsets;
                                var13_13 = var15_15[0];
                                var8_8 = this.mScrollOffset;
                                var15_15[0] = var13_13 + var8_8[0];
                                var15_15[1] = var15_15[1] + var8_8[1];
                                this.getParent().requestDisallowInterceptTouchEvent(true);
                            }
                            var8_8 = this.mScrollOffset;
                            this.mLastTouchX = var10_10 - var8_8[0];
                            this.mLastTouchY = var11_11 - var8_8[1];
                            var13_13 = var2_2 != false ? var6_6 : 0;
                            if (this.scrollByInternal(var13_13, var12_12 = var5_5 != false ? var7_7 : 0, (MotionEvent)var1_1)) {
                                this.getParent().requestDisallowInterceptTouchEvent(true);
                            }
                            var9_9 = var3_3;
                            if (this.mGapWorker == null) break block27;
                            if (var6_6 != 0) break block29;
                            var9_9 = var3_3;
                            if (var7_7 == 0) break block27;
                        }
                        this.mGapWorker.postFromTraversal(this, var6_6, var7_7);
                        var9_9 = var3_3;
                        break block27;
                    }
                    this.mVelocityTracker.addMovement((MotionEvent)var4_4);
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxFlingVelocity);
                    var16_16 = var2_2 != false ? -this.mVelocityTracker.getXVelocity(this.mScrollPointerId) : 0.0f;
                    var17_17 = var5_5 != false ? -this.mVelocityTracker.getYVelocity(this.mScrollPointerId) : 0.0f;
                    if (var16_16 == 0.0f && var17_17 == 0.0f || !this.fling((int)var16_16, (int)var17_17)) {
                        this.setScrollState(0);
                    }
                    this.resetScroll();
                    var9_9 = 1;
                    break block27;
                }
                this.mScrollPointerId = var1_1.getPointerId(0);
                this.mLastTouchX = var7_7 = (int)(var1_1.getX() + 0.5f);
                this.mInitialTouchX = var7_7;
                this.mLastTouchY = var7_7 = (int)(var1_1.getY() + 0.5f);
                this.mInitialTouchY = var7_7;
                var7_7 = var2_2 != false ? 1 : 0;
                var6_6 = var7_7;
                if (var5_5) {
                    var6_6 = var7_7 | 2;
                }
                this.startNestedScroll(var6_6, 0);
                var9_9 = var3_3;
            }
            if (var9_9 == 0) {
                this.mVelocityTracker.addMovement((MotionEvent)var4_4);
            }
            var4_4.recycle();
            return true;
        }
        return false;
    }

    void postAnimationRunner() {
        if (!this.mPostedAnimatorRunner && this.mIsAttached) {
            ViewCompat.postOnAnimation((View)this, this.mItemAnimatorRunner);
            this.mPostedAnimatorRunner = true;
        }
    }

    void processDataSetCompletelyChanged(boolean bl) {
        this.mDispatchItemsChangedEvent = bl | this.mDispatchItemsChangedEvent;
        this.mDataSetHasChangedAfterLayout = true;
        this.markKnownViewsInvalid();
    }

    void recordAnimationInfoIfBouncedHiddenView(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo) {
        viewHolder.setFlags(0, 8192);
        if (this.mState.mTrackOldChangeHolders && viewHolder.isUpdated() && !viewHolder.isRemoved() && !viewHolder.shouldIgnore()) {
            long l2 = this.getChangedHolderKey(viewHolder);
            this.mViewInfoStore.addToOldChangeHolders(l2, viewHolder);
        }
        this.mViewInfoStore.addToPreLayout(viewHolder, itemHolderInfo);
    }

    void removeAndRecycleViews() {
        Object object = this.mItemAnimator;
        if (object != null) {
            ((ItemAnimator)object).endAnimations();
        }
        if ((object = this.mLayout) != null) {
            ((LayoutManager)object).removeAndRecycleAllViews(this.mRecycler);
            this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
        }
        this.mRecycler.clear();
    }

    boolean removeAnimatingView(View object) {
        this.startInterceptRequestLayout();
        boolean bl = this.mChildHelper.removeViewIfHidden((View)object);
        if (bl) {
            object = RecyclerView.getChildViewHolderInt(object);
            this.mRecycler.unscrapView((ViewHolder)object);
            this.mRecycler.recycleViewHolderInternal((ViewHolder)object);
        }
        this.stopInterceptRequestLayout(bl ^ true);
        return bl;
    }

    protected void removeDetachedView(View object, boolean bl) {
        ViewHolder viewHolder = RecyclerView.getChildViewHolderInt((View)object);
        if (viewHolder != null) {
            if (viewHolder.isTmpDetached()) {
                viewHolder.clearTmpDetachFlag();
            } else if (!viewHolder.shouldIgnore()) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Called removeDetachedView with a view which is not flagged as tmp detached.");
                ((StringBuilder)object).append(viewHolder);
                ((StringBuilder)object).append(this.exceptionLabel());
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
        }
        object.clearAnimation();
        this.dispatchChildDetached((View)object);
        super.removeDetachedView((View)object, bl);
    }

    public void removeItemDecoration(ItemDecoration itemDecoration) {
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager != null) {
            layoutManager.assertNotInLayoutOrScroll("Cannot remove item decoration during a scroll  or layout");
        }
        this.mItemDecorations.remove(itemDecoration);
        if (this.mItemDecorations.isEmpty()) {
            boolean bl = this.getOverScrollMode() == 2;
            this.setWillNotDraw(bl);
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    public void removeItemDecorationAt(int n2) {
        int n3 = this.getItemDecorationCount();
        if (n2 >= 0 && n2 < n3) {
            this.removeItemDecoration(this.getItemDecorationAt(n2));
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2);
        stringBuilder.append(" is an invalid index for size ");
        stringBuilder.append(n3);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public void removeOnChildAttachStateChangeListener(OnChildAttachStateChangeListener onChildAttachStateChangeListener) {
        List<OnChildAttachStateChangeListener> list = this.mOnChildAttachStateListeners;
        if (list == null) {
            return;
        }
        list.remove(onChildAttachStateChangeListener);
    }

    public void removeOnItemTouchListener(OnItemTouchListener onItemTouchListener) {
        this.mOnItemTouchListeners.remove(onItemTouchListener);
        if (this.mInterceptingOnItemTouchListener == onItemTouchListener) {
            this.mInterceptingOnItemTouchListener = null;
        }
    }

    public void removeOnScrollListener(OnScrollListener onScrollListener) {
        List<OnScrollListener> list = this.mScrollListeners;
        if (list != null) {
            list.remove(onScrollListener);
        }
    }

    void repositionShadowingViews() {
        int n2 = this.mChildHelper.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.mChildHelper.getChildAt(i2);
            ViewHolder viewHolder = this.getChildViewHolder(view);
            if (viewHolder == null || viewHolder.mShadowingHolder == null) continue;
            viewHolder = viewHolder.mShadowingHolder.itemView;
            int n3 = view.getLeft();
            int n4 = view.getTop();
            if (n3 == viewHolder.getLeft() && n4 == viewHolder.getTop()) continue;
            viewHolder.layout(n3, n4, viewHolder.getWidth() + n3, viewHolder.getHeight() + n4);
        }
    }

    public void requestChildFocus(View view, View view2) {
        if (!this.mLayout.onRequestChildFocus(this, this.mState, view, view2) && view2 != null) {
            this.requestChildOnScreen(view, view2);
        }
        super.requestChildFocus(view, view2);
    }

    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        return this.mLayout.requestChildRectangleOnScreen(this, view, rect, bl);
    }

    public void requestDisallowInterceptTouchEvent(boolean bl) {
        int n2 = this.mOnItemTouchListeners.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mOnItemTouchListeners.get(i2).onRequestDisallowInterceptTouchEvent(bl);
        }
        super.requestDisallowInterceptTouchEvent(bl);
    }

    public void requestLayout() {
        if (this.mInterceptRequestLayoutDepth == 0 && !this.mLayoutSuppressed) {
            super.requestLayout();
        } else {
            this.mLayoutWasDefered = true;
        }
    }

    void saveOldPositions() {
        int n2 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i2));
            if (viewHolder.shouldIgnore()) continue;
            viewHolder.saveOldPosition();
        }
    }

    public void scrollBy(int n2, int n3) {
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager == null) {
            Log.e((String)TAG, (String)"Cannot scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        if (this.mLayoutSuppressed) {
            return;
        }
        boolean bl = layoutManager.canScrollHorizontally();
        boolean bl2 = this.mLayout.canScrollVertically();
        if (bl || bl2) {
            if (!bl) {
                n2 = 0;
            }
            if (!bl2) {
                n3 = 0;
            }
            this.scrollByInternal(n2, n3, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean scrollByInternal(int n2, int n3, MotionEvent motionEvent) {
        void var7_13;
        void var6_9;
        Object object;
        Object object2;
        this.consumePendingUpdateOperations();
        Object object3 = this.mAdapter;
        boolean bl = true;
        if (object3 != null) {
            object3 = this.mReusableIntPair;
            object3[0] = false;
            object3[1] = false;
            this.scrollStep(n2, n3, (int[])object3);
            object3 = this.mReusableIntPair;
            Object n7 = object3[0];
            Object object4 = object3[1];
            object2 = object4;
            object = n7;
            int n4 = n2 - n7;
            int n5 = n3 - object4;
        } else {
            object = 0;
            object2 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
        }
        if (!this.mItemDecorations.isEmpty()) {
            this.invalidate();
        }
        object3 = this.mReusableIntPair;
        object3[0] = false;
        object3[1] = false;
        this.dispatchNestedScroll((int)object, (int)object2, (int)var6_9, (int)var7_13, this.mScrollOffset, 0, (int[])object3);
        object3 = this.mReusableIntPair;
        Object object5 = object3[0];
        Object object6 = object3[1];
        boolean bl4 = object3[0] != false || object3[1] != false;
        int n6 = this.mLastTouchX;
        int[] nArray = this.mScrollOffset;
        this.mLastTouchX = n6 - nArray[0];
        this.mLastTouchY -= nArray[1];
        object3 = this.mNestedOffsets;
        object3[0] = object3[0] + nArray[0];
        object3[1] = object3[1] + nArray[1];
        if (this.getOverScrollMode() != 2) {
            if (motionEvent != null && !MotionEventCompat.isFromSource((MotionEvent)motionEvent, (int)8194)) {
                this.pullGlows(motionEvent.getX(), (float)(var6_9 - object5), motionEvent.getY(), (float)(var7_13 - object6));
            }
            this.considerReleasingGlowsOnScroll(n2, n3);
        }
        if (object != 0 || object2 != 0) {
            this.dispatchOnScrolled((int)object, (int)object2);
        }
        if (!this.awakenScrollBars()) {
            this.invalidate();
        }
        boolean bl5 = bl;
        if (!bl4) {
            bl5 = bl;
            if (object == 0) {
                bl5 = object2 != 0 ? bl : false;
            }
        }
        return bl5;
    }

    void scrollStep(int n2, int n3, int[] nArray) {
        this.startInterceptRequestLayout();
        this.onEnterLayoutOrScroll();
        TraceCompat.beginSection((String)TRACE_SCROLL_TAG);
        this.fillRemainingScrollValues(this.mState);
        n2 = n2 != 0 ? this.mLayout.scrollHorizontallyBy(n2, this.mRecycler, this.mState) : 0;
        n3 = n3 != 0 ? this.mLayout.scrollVerticallyBy(n3, this.mRecycler, this.mState) : 0;
        TraceCompat.endSection();
        this.repositionShadowingViews();
        this.onExitLayoutOrScroll();
        this.stopInterceptRequestLayout(false);
        if (nArray != null) {
            nArray[0] = n2;
            nArray[1] = n3;
        }
    }

    public void scrollTo(int n2, int n3) {
        Log.w((String)TAG, (String)"RecyclerView does not support scrolling to an absolute position. Use scrollToPosition instead");
    }

    public void scrollToPosition(int n2) {
        if (this.mLayoutSuppressed) {
            return;
        }
        this.stopScroll();
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager == null) {
            Log.e((String)TAG, (String)"Cannot scroll to position a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        layoutManager.scrollToPosition(n2);
        this.awakenScrollBars();
    }

    public void sendAccessibilityEventUnchecked(AccessibilityEvent accessibilityEvent) {
        if (this.shouldDeferAccessibilityEvent(accessibilityEvent)) {
            return;
        }
        super.sendAccessibilityEventUnchecked(accessibilityEvent);
    }

    public void setAccessibilityDelegateCompat(RecyclerViewAccessibilityDelegate recyclerViewAccessibilityDelegate) {
        this.mAccessibilityDelegate = recyclerViewAccessibilityDelegate;
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)this.mAccessibilityDelegate);
    }

    public void setAdapter(Adapter adapter) {
        this.setLayoutFrozen(false);
        this.setAdapterInternal(adapter, false, true);
        this.processDataSetCompletelyChanged(false);
        this.requestLayout();
    }

    public void setChildDrawingOrderCallback(ChildDrawingOrderCallback childDrawingOrderCallback) {
        if (childDrawingOrderCallback == this.mChildDrawingOrderCallback) {
            return;
        }
        this.mChildDrawingOrderCallback = childDrawingOrderCallback;
        boolean bl = this.mChildDrawingOrderCallback != null;
        this.setChildrenDrawingOrderEnabled(bl);
    }

    boolean setChildImportantForAccessibilityInternal(ViewHolder viewHolder, int n2) {
        if (this.isComputingLayout()) {
            viewHolder.mPendingAccessibilityState = n2;
            this.mPendingAccessibilityImportanceChange.add(viewHolder);
            return false;
        }
        ViewCompat.setImportantForAccessibility(viewHolder.itemView, n2);
        return true;
    }

    public void setClipToPadding(boolean bl) {
        if (bl != this.mClipToPadding) {
            this.invalidateGlows();
        }
        this.mClipToPadding = bl;
        super.setClipToPadding(bl);
        if (this.mFirstLayoutComplete) {
            this.requestLayout();
        }
    }

    public void setEdgeEffectFactory(EdgeEffectFactory edgeEffectFactory) {
        Preconditions.checkNotNull((Object)edgeEffectFactory);
        this.mEdgeEffectFactory = edgeEffectFactory;
        this.invalidateGlows();
    }

    public void setHasFixedSize(boolean bl) {
        this.mHasFixedSize = bl;
    }

    public void setItemAnimator(ItemAnimator itemAnimator) {
        ItemAnimator itemAnimator2 = this.mItemAnimator;
        if (itemAnimator2 != null) {
            itemAnimator2.endAnimations();
            this.mItemAnimator.setListener(null);
        }
        if ((itemAnimator = (this.mItemAnimator = itemAnimator)) != null) {
            itemAnimator.setListener(this.mItemAnimatorListener);
        }
    }

    public void setItemViewCacheSize(int n2) {
        this.mRecycler.setViewCacheSize(n2);
    }

    @Deprecated
    public void setLayoutFrozen(boolean bl) {
        this.suppressLayout(bl);
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        Object object;
        if (layoutManager == this.mLayout) {
            return;
        }
        this.stopScroll();
        if (this.mLayout != null) {
            object = this.mItemAnimator;
            if (object != null) {
                ((ItemAnimator)object).endAnimations();
            }
            this.mLayout.removeAndRecycleAllViews(this.mRecycler);
            this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
            this.mRecycler.clear();
            if (this.mIsAttached) {
                this.mLayout.dispatchDetachedFromWindow(this, this.mRecycler);
            }
            this.mLayout.setRecyclerView(null);
            this.mLayout = null;
        } else {
            this.mRecycler.clear();
        }
        this.mChildHelper.removeAllViewsUnfiltered();
        this.mLayout = layoutManager;
        if (layoutManager != null) {
            if (layoutManager.mRecyclerView == null) {
                this.mLayout.setRecyclerView(this);
                if (this.mIsAttached) {
                    this.mLayout.dispatchAttachedToWindow(this);
                }
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append("LayoutManager ");
                ((StringBuilder)object).append(layoutManager);
                ((StringBuilder)object).append(" is already attached to a RecyclerView:");
                ((StringBuilder)object).append(layoutManager.mRecyclerView.exceptionLabel());
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
        }
        this.mRecycler.updateViewCacheSize();
        this.requestLayout();
    }

    @Deprecated
    public void setLayoutTransition(LayoutTransition layoutTransition) {
        if (Build.VERSION.SDK_INT < 18) {
            if (layoutTransition == null) {
                this.suppressLayout(false);
                return;
            }
            if (layoutTransition.getAnimator(0) == null && layoutTransition.getAnimator(1) == null && layoutTransition.getAnimator(2) == null && layoutTransition.getAnimator(3) == null && layoutTransition.getAnimator(4) == null) {
                this.suppressLayout(true);
                return;
            }
        }
        if (layoutTransition == null) {
            super.setLayoutTransition(null);
            return;
        }
        throw new IllegalArgumentException("Providing a LayoutTransition into RecyclerView is not supported. Please use setItemAnimator() instead for animating changes to the items in this RecyclerView");
    }

    public void setNestedScrollingEnabled(boolean bl) {
        this.getScrollingChildHelper().setNestedScrollingEnabled(bl);
    }

    public void setOnFlingListener(OnFlingListener onFlingListener) {
        this.mOnFlingListener = onFlingListener;
    }

    @Deprecated
    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mScrollListener = onScrollListener;
    }

    public void setPreserveFocusAfterLayout(boolean bl) {
        this.mPreserveFocusAfterLayout = bl;
    }

    public void setRecycledViewPool(RecycledViewPool recycledViewPool) {
        this.mRecycler.setRecycledViewPool(recycledViewPool);
    }

    public void setRecyclerListener(RecyclerListener recyclerListener) {
        this.mRecyclerListener = recyclerListener;
    }

    void setScrollState(int n2) {
        if (n2 == this.mScrollState) {
            return;
        }
        this.mScrollState = n2;
        if (n2 != 2) {
            this.stopScrollersInternal();
        }
        this.dispatchOnScrollStateChanged(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setScrollingTouchSlop(int n2) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        if (n2 != 0) {
            if (n2 == 1) {
                this.mTouchSlop = viewConfiguration.getScaledPagingTouchSlop();
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("setScrollingTouchSlop(): bad argument constant ");
            stringBuilder.append(n2);
            stringBuilder.append("; using default value");
            Log.w((String)TAG, (String)stringBuilder.toString());
        }
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
    }

    public void setViewCacheExtension(ViewCacheExtension viewCacheExtension) {
        this.mRecycler.setViewCacheExtension(viewCacheExtension);
    }

    boolean shouldDeferAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (this.isComputingLayout()) {
            int n2 = accessibilityEvent != null ? AccessibilityEventCompat.getContentChangeTypes((AccessibilityEvent)accessibilityEvent) : 0;
            int n3 = n2;
            if (n2 == 0) {
                n3 = 0;
            }
            this.mEatenAccessibilityChangeFlags = n3 | this.mEatenAccessibilityChangeFlags;
            return true;
        }
        return false;
    }

    public void smoothScrollBy(int n2, int n3) {
        this.smoothScrollBy(n2, n3, null);
    }

    public void smoothScrollBy(int n2, int n3, Interpolator interpolator2) {
        this.smoothScrollBy(n2, n3, interpolator2, Integer.MIN_VALUE);
    }

    public void smoothScrollBy(int n2, int n3, Interpolator interpolator2, int n4) {
        this.smoothScrollBy(n2, n3, interpolator2, n4, false);
    }

    void smoothScrollBy(int n2, int n3, Interpolator interpolator2, int n4, boolean bl) {
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager == null) {
            Log.e((String)TAG, (String)"Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        if (this.mLayoutSuppressed) {
            return;
        }
        boolean bl2 = layoutManager.canScrollHorizontally();
        int n5 = 0;
        int n6 = n2;
        if (!bl2) {
            n6 = 0;
        }
        if (!this.mLayout.canScrollVertically()) {
            n3 = 0;
        }
        if (n6 != 0 || n3 != 0) {
            n2 = n4 != Integer.MIN_VALUE && n4 <= 0 ? 0 : 1;
            if (n2 != 0) {
                if (bl) {
                    n2 = n5;
                    if (n6 != 0) {
                        n2 = 1;
                    }
                    n5 = n2;
                    if (n3 != 0) {
                        n5 = n2 | 2;
                    }
                    this.startNestedScroll(n5, 1);
                }
                this.mViewFlinger.smoothScrollBy(n6, n3, n4, interpolator2);
            } else {
                this.scrollBy(n6, n3);
            }
        }
    }

    public void smoothScrollToPosition(int n2) {
        if (this.mLayoutSuppressed) {
            return;
        }
        LayoutManager layoutManager = this.mLayout;
        if (layoutManager == null) {
            Log.e((String)TAG, (String)"Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        layoutManager.smoothScrollToPosition(this, this.mState, n2);
    }

    void startInterceptRequestLayout() {
        ++this.mInterceptRequestLayoutDepth;
        if (this.mInterceptRequestLayoutDepth == 1 && !this.mLayoutSuppressed) {
            this.mLayoutWasDefered = false;
        }
    }

    public boolean startNestedScroll(int n2) {
        return this.getScrollingChildHelper().startNestedScroll(n2);
    }

    public boolean startNestedScroll(int n2, int n3) {
        return this.getScrollingChildHelper().startNestedScroll(n2, n3);
    }

    void stopInterceptRequestLayout(boolean bl) {
        if (this.mInterceptRequestLayoutDepth < 1) {
            this.mInterceptRequestLayoutDepth = 1;
        }
        if (!bl && !this.mLayoutSuppressed) {
            this.mLayoutWasDefered = false;
        }
        if (this.mInterceptRequestLayoutDepth == 1) {
            if (bl && this.mLayoutWasDefered && !this.mLayoutSuppressed && this.mLayout != null && this.mAdapter != null) {
                this.dispatchLayout();
            }
            if (!this.mLayoutSuppressed) {
                this.mLayoutWasDefered = false;
            }
        }
        --this.mInterceptRequestLayoutDepth;
    }

    public void stopNestedScroll() {
        this.getScrollingChildHelper().stopNestedScroll();
    }

    public void stopNestedScroll(int n2) {
        this.getScrollingChildHelper().stopNestedScroll(n2);
    }

    public void stopScroll() {
        this.setScrollState(0);
        this.stopScrollersInternal();
    }

    public final void suppressLayout(boolean bl) {
        if (bl != this.mLayoutSuppressed) {
            this.assertNotInLayoutOrScroll("Do not suppressLayout in layout or scroll");
            if (!bl) {
                this.mLayoutSuppressed = false;
                if (this.mLayoutWasDefered && this.mLayout != null && this.mAdapter != null) {
                    this.requestLayout();
                }
                this.mLayoutWasDefered = false;
            } else {
                long l2 = SystemClock.uptimeMillis();
                this.onTouchEvent(MotionEvent.obtain((long)l2, (long)l2, (int)3, (float)0.0f, (float)0.0f, (int)0));
                this.mLayoutSuppressed = true;
                this.mIgnoreMotionEventTillDown = true;
                this.stopScroll();
            }
        }
    }

    public void swapAdapter(Adapter adapter, boolean bl) {
        this.setLayoutFrozen(false);
        this.setAdapterInternal(adapter, true, bl);
        this.processDataSetCompletelyChanged(true);
        this.requestLayout();
    }

    void viewRangeUpdate(int n2, int n3, Object object) {
        int n4 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            View view = this.mChildHelper.getUnfilteredChildAt(i2);
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (viewHolder == null || viewHolder.shouldIgnore() || viewHolder.mPosition < n2 || viewHolder.mPosition >= n2 + n3) continue;
            viewHolder.addFlags(2);
            viewHolder.addChangePayload(object);
            ((LayoutParams)view.getLayoutParams()).mInsetsDirty = true;
        }
        this.mRecycler.viewRangeUpdate(n2, n3);
    }

    public static abstract class Adapter<VH extends ViewHolder> {
        private boolean mHasStableIds = false;
        private final AdapterDataObservable mObservable = new AdapterDataObservable();

        public final void bindViewHolder(VH object, int n2) {
            ((ViewHolder)object).mPosition = n2;
            if (this.hasStableIds()) {
                ((ViewHolder)object).mItemId = this.getItemId(n2);
            }
            ((ViewHolder)object).setFlags(1, 519);
            TraceCompat.beginSection((String)RecyclerView.TRACE_BIND_VIEW_TAG);
            this.onBindViewHolder(object, n2, ((ViewHolder)object).getUnmodifiedPayloads());
            ((ViewHolder)object).clearPayload();
            object = ((ViewHolder)object).itemView.getLayoutParams();
            if (object instanceof LayoutParams) {
                ((LayoutParams)((Object)object)).mInsetsDirty = true;
            }
            TraceCompat.endSection();
        }

        public final VH createViewHolder(ViewGroup object, int n2) {
            try {
                TraceCompat.beginSection((String)RecyclerView.TRACE_CREATE_VIEW_TAG);
                object = this.onCreateViewHolder((ViewGroup)object, n2);
                if (object.itemView.getParent() == null) {
                    object.mItemViewType = n2;
                    return (VH)object;
                }
                object = new IllegalStateException("ViewHolder views must not be attached when created. Ensure that you are not passing 'true' to the attachToRoot parameter of LayoutInflater.inflate(..., boolean attachToRoot)");
                throw object;
            }
            finally {
                TraceCompat.endSection();
            }
        }

        public abstract int getItemCount();

        public long getItemId(int n2) {
            return -1L;
        }

        public int getItemViewType(int n2) {
            return 0;
        }

        public final boolean hasObservers() {
            return this.mObservable.hasObservers();
        }

        public final boolean hasStableIds() {
            return this.mHasStableIds;
        }

        public final void notifyDataSetChanged() {
            this.mObservable.notifyChanged();
        }

        public final void notifyItemChanged(int n2) {
            this.mObservable.notifyItemRangeChanged(n2, 1);
        }

        public final void notifyItemChanged(int n2, Object object) {
            this.mObservable.notifyItemRangeChanged(n2, 1, object);
        }

        public final void notifyItemInserted(int n2) {
            this.mObservable.notifyItemRangeInserted(n2, 1);
        }

        public final void notifyItemMoved(int n2, int n3) {
            this.mObservable.notifyItemMoved(n2, n3);
        }

        public final void notifyItemRangeChanged(int n2, int n3) {
            this.mObservable.notifyItemRangeChanged(n2, n3);
        }

        public final void notifyItemRangeChanged(int n2, int n3, Object object) {
            this.mObservable.notifyItemRangeChanged(n2, n3, object);
        }

        public final void notifyItemRangeInserted(int n2, int n3) {
            this.mObservable.notifyItemRangeInserted(n2, n3);
        }

        public final void notifyItemRangeRemoved(int n2, int n3) {
            this.mObservable.notifyItemRangeRemoved(n2, n3);
        }

        public final void notifyItemRemoved(int n2) {
            this.mObservable.notifyItemRangeRemoved(n2, 1);
        }

        public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        }

        public abstract void onBindViewHolder(VH var1, int var2);

        public void onBindViewHolder(VH VH, int n2, List<Object> list) {
            this.onBindViewHolder(VH, n2);
        }

        public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

        public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        }

        public boolean onFailedToRecycleView(VH VH) {
            return false;
        }

        public void onViewAttachedToWindow(VH VH) {
        }

        public void onViewDetachedFromWindow(VH VH) {
        }

        public void onViewRecycled(VH VH) {
        }

        public void registerAdapterDataObserver(AdapterDataObserver adapterDataObserver) {
            this.mObservable.registerObserver(adapterDataObserver);
        }

        public void setHasStableIds(boolean bl) {
            if (!this.hasObservers()) {
                this.mHasStableIds = bl;
                return;
            }
            throw new IllegalStateException("Cannot change whether this adapter has stable IDs while the adapter has registered observers.");
        }

        public void unregisterAdapterDataObserver(AdapterDataObserver adapterDataObserver) {
            this.mObservable.unregisterObserver(adapterDataObserver);
        }
    }

    static class AdapterDataObservable
    extends Observable<AdapterDataObserver> {
        AdapterDataObservable() {
        }

        public boolean hasObservers() {
            return this.mObservers.isEmpty() ^ true;
        }

        public void notifyChanged() {
            for (int i2 = this.mObservers.size() - 1; i2 >= 0; --i2) {
                ((AdapterDataObserver)this.mObservers.get(i2)).onChanged();
            }
        }

        public void notifyItemMoved(int n2, int n3) {
            for (int i2 = this.mObservers.size() - 1; i2 >= 0; --i2) {
                ((AdapterDataObserver)this.mObservers.get(i2)).onItemRangeMoved(n2, n3, 1);
            }
        }

        public void notifyItemRangeChanged(int n2, int n3) {
            this.notifyItemRangeChanged(n2, n3, null);
        }

        public void notifyItemRangeChanged(int n2, int n3, Object object) {
            for (int i2 = this.mObservers.size() - 1; i2 >= 0; --i2) {
                ((AdapterDataObserver)this.mObservers.get(i2)).onItemRangeChanged(n2, n3, object);
            }
        }

        public void notifyItemRangeInserted(int n2, int n3) {
            for (int i2 = this.mObservers.size() - 1; i2 >= 0; --i2) {
                ((AdapterDataObserver)this.mObservers.get(i2)).onItemRangeInserted(n2, n3);
            }
        }

        public void notifyItemRangeRemoved(int n2, int n3) {
            for (int i2 = this.mObservers.size() - 1; i2 >= 0; --i2) {
                ((AdapterDataObserver)this.mObservers.get(i2)).onItemRangeRemoved(n2, n3);
            }
        }
    }

    public static abstract class AdapterDataObserver {
        public void onChanged() {
        }

        public void onItemRangeChanged(int n2, int n3) {
        }

        public void onItemRangeChanged(int n2, int n3, Object object) {
            this.onItemRangeChanged(n2, n3);
        }

        public void onItemRangeInserted(int n2, int n3) {
        }

        public void onItemRangeMoved(int n2, int n3, int n4) {
        }

        public void onItemRangeRemoved(int n2, int n3) {
        }
    }

    public static interface ChildDrawingOrderCallback {
        public int onGetChildDrawingOrder(int var1, int var2);
    }

    public static class EdgeEffectFactory {
        public static final int DIRECTION_BOTTOM = 3;
        public static final int DIRECTION_LEFT = 0;
        public static final int DIRECTION_RIGHT = 2;
        public static final int DIRECTION_TOP = 1;

        protected EdgeEffect createEdgeEffect(RecyclerView recyclerView, int n2) {
            return new EdgeEffect(recyclerView.getContext());
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface EdgeDirection {
        }
    }

    public static abstract class ItemAnimator {
        public static final int FLAG_APPEARED_IN_PRE_LAYOUT = 4096;
        public static final int FLAG_CHANGED = 2;
        public static final int FLAG_INVALIDATED = 4;
        public static final int FLAG_MOVED = 2048;
        public static final int FLAG_REMOVED = 8;
        private long mAddDuration = 120L;
        private long mChangeDuration = 250L;
        private ArrayList<ItemAnimatorFinishedListener> mFinishedListeners = new ArrayList();
        private ItemAnimatorListener mListener = null;
        private long mMoveDuration = 250L;
        private long mRemoveDuration = 120L;

        static int buildAdapterChangeFlagsForAnimations(ViewHolder viewHolder) {
            int n2 = viewHolder.mFlags & 0xE;
            if (viewHolder.isInvalid()) {
                return 4;
            }
            int n3 = n2;
            if ((n2 & 4) == 0) {
                int n4 = viewHolder.getOldPosition();
                int n5 = viewHolder.getAdapterPosition();
                n3 = n2;
                if (n4 != -1) {
                    n3 = n2;
                    if (n5 != -1) {
                        n3 = n2;
                        if (n4 != n5) {
                            n3 = n2 | 0x800;
                        }
                    }
                }
            }
            return n3;
        }

        public abstract boolean animateAppearance(ViewHolder var1, ItemHolderInfo var2, ItemHolderInfo var3);

        public abstract boolean animateChange(ViewHolder var1, ViewHolder var2, ItemHolderInfo var3, ItemHolderInfo var4);

        public abstract boolean animateDisappearance(ViewHolder var1, ItemHolderInfo var2, ItemHolderInfo var3);

        public abstract boolean animatePersistence(ViewHolder var1, ItemHolderInfo var2, ItemHolderInfo var3);

        public boolean canReuseUpdatedViewHolder(ViewHolder viewHolder) {
            return true;
        }

        public boolean canReuseUpdatedViewHolder(ViewHolder viewHolder, List<Object> list) {
            return this.canReuseUpdatedViewHolder(viewHolder);
        }

        public final void dispatchAnimationFinished(ViewHolder viewHolder) {
            this.onAnimationFinished(viewHolder);
            ItemAnimatorListener itemAnimatorListener = this.mListener;
            if (itemAnimatorListener != null) {
                itemAnimatorListener.onAnimationFinished(viewHolder);
            }
        }

        public final void dispatchAnimationStarted(ViewHolder viewHolder) {
            this.onAnimationStarted(viewHolder);
        }

        public final void dispatchAnimationsFinished() {
            int n2 = this.mFinishedListeners.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mFinishedListeners.get(i2).onAnimationsFinished();
            }
            this.mFinishedListeners.clear();
        }

        public abstract void endAnimation(ViewHolder var1);

        public abstract void endAnimations();

        public long getAddDuration() {
            return this.mAddDuration;
        }

        public long getChangeDuration() {
            return this.mChangeDuration;
        }

        public long getMoveDuration() {
            return this.mMoveDuration;
        }

        public long getRemoveDuration() {
            return this.mRemoveDuration;
        }

        public abstract boolean isRunning();

        public final boolean isRunning(ItemAnimatorFinishedListener itemAnimatorFinishedListener) {
            boolean bl = this.isRunning();
            if (itemAnimatorFinishedListener != null) {
                if (!bl) {
                    itemAnimatorFinishedListener.onAnimationsFinished();
                } else {
                    this.mFinishedListeners.add(itemAnimatorFinishedListener);
                }
            }
            return bl;
        }

        public ItemHolderInfo obtainHolderInfo() {
            return new ItemHolderInfo();
        }

        public void onAnimationFinished(ViewHolder viewHolder) {
        }

        public void onAnimationStarted(ViewHolder viewHolder) {
        }

        public ItemHolderInfo recordPostLayoutInformation(State state, ViewHolder viewHolder) {
            return this.obtainHolderInfo().setFrom(viewHolder);
        }

        public ItemHolderInfo recordPreLayoutInformation(State state, ViewHolder viewHolder, int n2, List<Object> list) {
            return this.obtainHolderInfo().setFrom(viewHolder);
        }

        public abstract void runPendingAnimations();

        public void setAddDuration(long l2) {
            this.mAddDuration = l2;
        }

        public void setChangeDuration(long l2) {
            this.mChangeDuration = l2;
        }

        void setListener(ItemAnimatorListener itemAnimatorListener) {
            this.mListener = itemAnimatorListener;
        }

        public void setMoveDuration(long l2) {
            this.mMoveDuration = l2;
        }

        public void setRemoveDuration(long l2) {
            this.mRemoveDuration = l2;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AdapterChanges {
        }

        public static interface ItemAnimatorFinishedListener {
            public void onAnimationsFinished();
        }

        static interface ItemAnimatorListener {
            public void onAnimationFinished(ViewHolder var1);
        }

        public static class ItemHolderInfo {
            public int bottom;
            public int changeFlags;
            public int left;
            public int right;
            public int top;

            public ItemHolderInfo setFrom(ViewHolder viewHolder) {
                return this.setFrom(viewHolder, 0);
            }

            public ItemHolderInfo setFrom(ViewHolder viewHolder, int n2) {
                viewHolder = viewHolder.itemView;
                this.left = viewHolder.getLeft();
                this.top = viewHolder.getTop();
                this.right = viewHolder.getRight();
                this.bottom = viewHolder.getBottom();
                return this;
            }
        }
    }

    private class ItemAnimatorRestoreListener
    implements ItemAnimator.ItemAnimatorListener {
        ItemAnimatorRestoreListener() {
        }

        @Override
        public void onAnimationFinished(ViewHolder viewHolder) {
            viewHolder.setIsRecyclable(true);
            if (viewHolder.mShadowedHolder != null && viewHolder.mShadowingHolder == null) {
                viewHolder.mShadowedHolder = null;
            }
            viewHolder.mShadowingHolder = null;
            if (!viewHolder.shouldBeKeptAsChild() && !RecyclerView.this.removeAnimatingView(viewHolder.itemView) && viewHolder.isTmpDetached()) {
                RecyclerView.this.removeDetachedView(viewHolder.itemView, false);
            }
        }
    }

    public static abstract class ItemDecoration {
        @Deprecated
        public void getItemOffsets(Rect rect, int n2, RecyclerView recyclerView) {
            rect.set(0, 0, 0, 0);
        }

        public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, State state) {
            this.getItemOffsets(rect, ((LayoutParams)view.getLayoutParams()).getViewLayoutPosition(), recyclerView);
        }

        @Deprecated
        public void onDraw(Canvas canvas, RecyclerView recyclerView) {
        }

        public void onDraw(Canvas canvas, RecyclerView recyclerView, State state) {
            this.onDraw(canvas, recyclerView);
        }

        @Deprecated
        public void onDrawOver(Canvas canvas, RecyclerView recyclerView) {
        }

        public void onDrawOver(Canvas canvas, RecyclerView recyclerView, State state) {
            this.onDrawOver(canvas, recyclerView);
        }
    }

    public static abstract class LayoutManager {
        boolean mAutoMeasure = false;
        ChildHelper mChildHelper;
        private int mHeight;
        private int mHeightMode;
        ViewBoundsCheck mHorizontalBoundCheck;
        private final ViewBoundsCheck.Callback mHorizontalBoundCheckCallback = new ViewBoundsCheck.Callback(){

            @Override
            public View getChildAt(int n2) {
                return LayoutManager.this.getChildAt(n2);
            }

            @Override
            public int getChildEnd(View view) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                return LayoutManager.this.getDecoratedRight(view) + layoutParams.rightMargin;
            }

            @Override
            public int getChildStart(View view) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                return LayoutManager.this.getDecoratedLeft(view) - layoutParams.leftMargin;
            }

            @Override
            public int getParentEnd() {
                return LayoutManager.this.getWidth() - LayoutManager.this.getPaddingRight();
            }

            @Override
            public int getParentStart() {
                return LayoutManager.this.getPaddingLeft();
            }
        };
        boolean mIsAttachedToWindow = false;
        private boolean mItemPrefetchEnabled = true;
        private boolean mMeasurementCacheEnabled = true;
        int mPrefetchMaxCountObserved;
        boolean mPrefetchMaxObservedInInitialPrefetch;
        RecyclerView mRecyclerView;
        boolean mRequestedSimpleAnimations = false;
        SmoothScroller mSmoothScroller;
        ViewBoundsCheck mVerticalBoundCheck;
        private final ViewBoundsCheck.Callback mVerticalBoundCheckCallback = new ViewBoundsCheck.Callback(){

            @Override
            public View getChildAt(int n2) {
                return LayoutManager.this.getChildAt(n2);
            }

            @Override
            public int getChildEnd(View view) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                return LayoutManager.this.getDecoratedBottom(view) + layoutParams.bottomMargin;
            }

            @Override
            public int getChildStart(View view) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                return LayoutManager.this.getDecoratedTop(view) - layoutParams.topMargin;
            }

            @Override
            public int getParentEnd() {
                return LayoutManager.this.getHeight() - LayoutManager.this.getPaddingBottom();
            }

            @Override
            public int getParentStart() {
                return LayoutManager.this.getPaddingTop();
            }
        };
        private int mWidth;
        private int mWidthMode;

        public LayoutManager() {
            this.mHorizontalBoundCheck = new ViewBoundsCheck(this.mHorizontalBoundCheckCallback);
            this.mVerticalBoundCheck = new ViewBoundsCheck(this.mVerticalBoundCheckCallback);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void addViewInt(View view, int n2, boolean bl) {
            LayoutParams layoutParams;
            ViewHolder viewHolder;
            block12: {
                block11: {
                    viewHolder = RecyclerView.getChildViewHolderInt(view);
                    if (!bl && !viewHolder.isRemoved()) {
                        this.mRecyclerView.mViewInfoStore.removeFromDisappearedInLayout(viewHolder);
                    } else {
                        this.mRecyclerView.mViewInfoStore.addToDisappearedInLayout(viewHolder);
                    }
                    layoutParams = (LayoutParams)view.getLayoutParams();
                    if (viewHolder.wasReturnedFromScrap() || viewHolder.isScrap()) break block11;
                    if (view.getParent() == this.mRecyclerView) {
                        int n3 = this.mChildHelper.indexOfChild(view);
                        int n4 = n2;
                        if (n2 == -1) {
                            n4 = this.mChildHelper.getChildCount();
                        }
                        if (n3 == -1) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Added View has RecyclerView as parent but view is not a real child. Unfiltered index:");
                            stringBuilder.append(this.mRecyclerView.indexOfChild(view));
                            stringBuilder.append(this.mRecyclerView.exceptionLabel());
                            throw new IllegalStateException(stringBuilder.toString());
                        }
                        if (n3 != n4) {
                            this.mRecyclerView.mLayout.moveView(n3, n4);
                        }
                        break block12;
                    } else {
                        this.mChildHelper.addView(view, n2, false);
                        layoutParams.mInsetsDirty = true;
                        SmoothScroller smoothScroller = this.mSmoothScroller;
                        if (smoothScroller != null && smoothScroller.isRunning()) {
                            this.mSmoothScroller.onChildAttachedToWindow(view);
                        }
                    }
                    break block12;
                }
                if (viewHolder.isScrap()) {
                    viewHolder.unScrap();
                } else {
                    viewHolder.clearReturnedFromScrapFlag();
                }
                this.mChildHelper.attachViewToParent(view, n2, view.getLayoutParams(), false);
            }
            if (layoutParams.mPendingInvalidate) {
                viewHolder.itemView.invalidate();
                layoutParams.mPendingInvalidate = false;
            }
        }

        public static int chooseSize(int n2, int n3, int n4) {
            int n5 = View.MeasureSpec.getMode((int)n2);
            n2 = View.MeasureSpec.getSize((int)n2);
            if (n5 != Integer.MIN_VALUE) {
                if (n5 != 0x40000000) {
                    n2 = Math.max(n3, n4);
                }
                return n2;
            }
            return Math.min(n2, Math.max(n3, n4));
        }

        private void detachViewInternal(int n2, View view) {
            this.mChildHelper.detachViewFromParent(n2);
        }

        public static int getChildMeasureSpec(int n2, int n3, int n4, int n5, boolean bl) {
            block7: {
                int n6;
                block6: {
                    int n7;
                    block10: {
                        block9: {
                            block8: {
                                block5: {
                                    block4: {
                                        n6 = 0;
                                        n7 = Math.max(0, n2 - n4);
                                        if (!bl) break block4;
                                        if (n5 >= 0) break block5;
                                        if (n5 != -1) break block6;
                                        if (n3 != Integer.MIN_VALUE && (n3 == 0 || n3 != 0x40000000)) {
                                            n3 = 0;
                                            n2 = 0;
                                        } else {
                                            n2 = n7;
                                        }
                                        n4 = n2;
                                        n2 = n3;
                                        break block7;
                                    }
                                    if (n5 < 0) break block8;
                                }
                                n4 = n5;
                                n2 = 0x40000000;
                                break block7;
                            }
                            if (n5 != -1) break block9;
                            n2 = n3;
                            n4 = n7;
                            break block7;
                        }
                        if (n5 != -2) break block6;
                        if (n3 == Integer.MIN_VALUE) break block10;
                        n4 = n7;
                        n2 = n6;
                        if (n3 != 0x40000000) break block7;
                    }
                    n2 = Integer.MIN_VALUE;
                    n4 = n7;
                    break block7;
                }
                n4 = 0;
                n2 = n6;
            }
            return View.MeasureSpec.makeMeasureSpec((int)n4, (int)n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Deprecated
        public static int getChildMeasureSpec(int n2, int n3, int n4, boolean bl) {
            block10: {
                int n5;
                block5: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block4: {
                                        n5 = 0;
                                        n2 = Math.max(0, n2 - n3);
                                        if (!bl) break block4;
                                        if (n4 < 0) break block5;
                                        break block6;
                                    }
                                    if (n4 < 0) break block7;
                                }
                                n2 = n4;
                                break block8;
                            }
                            if (n4 != -1) break block9;
                        }
                        n3 = 0x40000000;
                        return View.MeasureSpec.makeMeasureSpec((int)n2, (int)n3);
                    }
                    if (n4 == -2) break block10;
                }
                n2 = 0;
                n3 = n5;
                return View.MeasureSpec.makeMeasureSpec((int)n2, (int)n3);
            }
            n3 = Integer.MIN_VALUE;
            return View.MeasureSpec.makeMeasureSpec((int)n2, (int)n3);
        }

        private int[] getChildRectangleOnScreenScrollAmount(View view, Rect rect) {
            int n2 = this.getPaddingLeft();
            int n3 = this.getPaddingTop();
            int n4 = this.getWidth();
            int n5 = this.getPaddingRight();
            int n6 = this.getHeight();
            int n7 = this.getPaddingBottom();
            int n8 = view.getLeft() + rect.left - view.getScrollX();
            int n9 = view.getTop() + rect.top - view.getScrollY();
            int n10 = rect.width();
            int n11 = rect.height();
            int n12 = n8 - n2;
            n2 = Math.min(0, n12);
            int n13 = n9 - n3;
            n3 = Math.min(0, n13);
            n8 = n10 + n8 - (n4 - n5);
            n10 = Math.max(0, n8);
            n6 = Math.max(0, n11 + n9 - (n6 - n7));
            if (this.getLayoutDirection() == 1) {
                n2 = n10 != 0 ? n10 : Math.max(n2, n8);
            } else if (n2 == 0) {
                n2 = Math.min(n12, n10);
            }
            if (n3 == 0) {
                n3 = Math.min(n13, n6);
            }
            return new int[]{n2, n3};
        }

        public static Properties getProperties(Context context, AttributeSet attributeSet, int n2, int n3) {
            Properties properties = new Properties();
            context = context.obtainStyledAttributes(attributeSet, R.styleable.RecyclerView, n2, n3);
            properties.orientation = context.getInt(R.styleable.RecyclerView_android_orientation, 1);
            properties.spanCount = context.getInt(R.styleable.RecyclerView_spanCount, 1);
            properties.reverseLayout = context.getBoolean(R.styleable.RecyclerView_reverseLayout, false);
            properties.stackFromEnd = context.getBoolean(R.styleable.RecyclerView_stackFromEnd, false);
            context.recycle();
            return properties;
        }

        private boolean isFocusedChildVisibleAfterScrolling(RecyclerView recyclerView, int n2, int n3) {
            View view = recyclerView.getFocusedChild();
            if (view == null) {
                return false;
            }
            int n4 = this.getPaddingLeft();
            int n5 = this.getPaddingTop();
            int n6 = this.getWidth();
            int n7 = this.getPaddingRight();
            int n8 = this.getHeight();
            int n9 = this.getPaddingBottom();
            recyclerView = this.mRecyclerView.mTempRect;
            this.getDecoratedBoundsWithMargins(view, (Rect)recyclerView);
            return ((Rect)recyclerView).left - n2 < n6 - n7 && ((Rect)recyclerView).right - n2 > n4 && ((Rect)recyclerView).top - n3 < n8 - n9 && ((Rect)recyclerView).bottom - n3 > n5;
            {
            }
        }

        private static boolean isMeasurementUpToDate(int n2, int n3, int n4) {
            int n5 = View.MeasureSpec.getMode((int)n3);
            n3 = View.MeasureSpec.getSize((int)n3);
            boolean bl = false;
            boolean bl2 = false;
            if (n4 > 0 && n2 != n4) {
                return false;
            }
            if (n5 != Integer.MIN_VALUE) {
                if (n5 != 0) {
                    if (n5 != 0x40000000) {
                        return false;
                    }
                    if (n3 == n2) {
                        bl2 = true;
                    }
                    return bl2;
                }
                return true;
            }
            bl2 = bl;
            if (n3 >= n2) {
                bl2 = true;
            }
            return bl2;
        }

        private void scrapOrRecycleView(Recycler recycler, int n2, View view) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (viewHolder.shouldIgnore()) {
                return;
            }
            if (viewHolder.isInvalid() && !viewHolder.isRemoved() && !this.mRecyclerView.mAdapter.hasStableIds()) {
                this.removeViewAt(n2);
                recycler.recycleViewHolderInternal(viewHolder);
            } else {
                this.detachViewAt(n2);
                recycler.scrapView(view);
                this.mRecyclerView.mViewInfoStore.onViewDetached(viewHolder);
            }
        }

        public void addDisappearingView(View view) {
            this.addDisappearingView(view, -1);
        }

        public void addDisappearingView(View view, int n2) {
            this.addViewInt(view, n2, true);
        }

        public void addView(View view) {
            this.addView(view, -1);
        }

        public void addView(View view, int n2) {
            this.addViewInt(view, n2, false);
        }

        public void assertInLayoutOrScroll(String string2) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                recyclerView.assertInLayoutOrScroll(string2);
            }
        }

        public void assertNotInLayoutOrScroll(String string2) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                recyclerView.assertNotInLayoutOrScroll(string2);
            }
        }

        public void attachView(View view) {
            this.attachView(view, -1);
        }

        public void attachView(View view, int n2) {
            this.attachView(view, n2, (LayoutParams)view.getLayoutParams());
        }

        public void attachView(View view, int n2, LayoutParams layoutParams) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (viewHolder.isRemoved()) {
                this.mRecyclerView.mViewInfoStore.addToDisappearedInLayout(viewHolder);
            } else {
                this.mRecyclerView.mViewInfoStore.removeFromDisappearedInLayout(viewHolder);
            }
            this.mChildHelper.attachViewToParent(view, n2, (ViewGroup.LayoutParams)layoutParams, viewHolder.isRemoved());
        }

        public void calculateItemDecorationsForChild(View view, Rect rect) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView == null) {
                rect.set(0, 0, 0, 0);
                return;
            }
            rect.set(recyclerView.getItemDecorInsetsForChild(view));
        }

        public boolean canScrollHorizontally() {
            return false;
        }

        public boolean canScrollVertically() {
            return false;
        }

        public boolean checkLayoutParams(LayoutParams layoutParams) {
            boolean bl = layoutParams != null;
            return bl;
        }

        public void collectAdjacentPrefetchPositions(int n2, int n3, State state, LayoutPrefetchRegistry layoutPrefetchRegistry) {
        }

        public void collectInitialPrefetchPositions(int n2, LayoutPrefetchRegistry layoutPrefetchRegistry) {
        }

        public int computeHorizontalScrollExtent(State state) {
            return 0;
        }

        public int computeHorizontalScrollOffset(State state) {
            return 0;
        }

        public int computeHorizontalScrollRange(State state) {
            return 0;
        }

        public int computeVerticalScrollExtent(State state) {
            return 0;
        }

        public int computeVerticalScrollOffset(State state) {
            return 0;
        }

        public int computeVerticalScrollRange(State state) {
            return 0;
        }

        public void detachAndScrapAttachedViews(Recycler recycler) {
            for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                this.scrapOrRecycleView(recycler, i2, this.getChildAt(i2));
            }
        }

        public void detachAndScrapView(View view, Recycler recycler) {
            this.scrapOrRecycleView(recycler, this.mChildHelper.indexOfChild(view), view);
        }

        public void detachAndScrapViewAt(int n2, Recycler recycler) {
            this.scrapOrRecycleView(recycler, n2, this.getChildAt(n2));
        }

        public void detachView(View view) {
            int n2 = this.mChildHelper.indexOfChild(view);
            if (n2 >= 0) {
                this.detachViewInternal(n2, view);
            }
        }

        public void detachViewAt(int n2) {
            this.detachViewInternal(n2, this.getChildAt(n2));
        }

        void dispatchAttachedToWindow(RecyclerView recyclerView) {
            this.mIsAttachedToWindow = true;
            this.onAttachedToWindow(recyclerView);
        }

        void dispatchDetachedFromWindow(RecyclerView recyclerView, Recycler recycler) {
            this.mIsAttachedToWindow = false;
            this.onDetachedFromWindow(recyclerView, recycler);
        }

        public void endAnimation(View view) {
            if (this.mRecyclerView.mItemAnimator != null) {
                this.mRecyclerView.mItemAnimator.endAnimation(RecyclerView.getChildViewHolderInt(view));
            }
        }

        public View findContainingItemView(View view) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView == null) {
                return null;
            }
            if ((view = recyclerView.findContainingItemView(view)) == null) {
                return null;
            }
            if (this.mChildHelper.isHidden(view)) {
                return null;
            }
            return view;
        }

        public View findViewByPosition(int n2) {
            int n3 = this.getChildCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                View view = this.getChildAt(i2);
                ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
                if (viewHolder == null || viewHolder.getLayoutPosition() != n2 || viewHolder.shouldIgnore() || !this.mRecyclerView.mState.isPreLayout() && viewHolder.isRemoved()) continue;
                return view;
            }
            return null;
        }

        public abstract LayoutParams generateDefaultLayoutParams();

        public LayoutParams generateLayoutParams(Context context, AttributeSet attributeSet) {
            return new LayoutParams(context, attributeSet);
        }

        public LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
            if (layoutParams instanceof LayoutParams) {
                return new LayoutParams((LayoutParams)layoutParams);
            }
            if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                return new LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
            }
            return new LayoutParams(layoutParams);
        }

        public int getBaseline() {
            return -1;
        }

        public int getBottomDecorationHeight(View view) {
            return ((LayoutParams)view.getLayoutParams()).mDecorInsets.bottom;
        }

        public View getChildAt(int n2) {
            ChildHelper childHelper = this.mChildHelper;
            childHelper = childHelper != null ? childHelper.getChildAt(n2) : null;
            return childHelper;
        }

        public int getChildCount() {
            ChildHelper childHelper = this.mChildHelper;
            int n2 = childHelper != null ? childHelper.getChildCount() : 0;
            return n2;
        }

        public boolean getClipToPadding() {
            RecyclerView recyclerView = this.mRecyclerView;
            boolean bl = recyclerView != null && recyclerView.mClipToPadding;
            return bl;
        }

        public int getColumnCountForAccessibility(Recycler object, State state) {
            int n2;
            object = this.mRecyclerView;
            int n3 = n2 = 1;
            if (object != null) {
                if (((RecyclerView)((Object)object)).mAdapter == null) {
                    n3 = n2;
                } else {
                    n3 = n2;
                    if (this.canScrollHorizontally()) {
                        n3 = this.mRecyclerView.mAdapter.getItemCount();
                    }
                }
            }
            return n3;
        }

        public int getDecoratedBottom(View view) {
            return view.getBottom() + this.getBottomDecorationHeight(view);
        }

        public void getDecoratedBoundsWithMargins(View view, Rect rect) {
            RecyclerView.getDecoratedBoundsWithMarginsInt(view, rect);
        }

        public int getDecoratedLeft(View view) {
            return view.getLeft() - this.getLeftDecorationWidth(view);
        }

        public int getDecoratedMeasuredHeight(View view) {
            Rect rect = ((LayoutParams)view.getLayoutParams()).mDecorInsets;
            return view.getMeasuredHeight() + rect.top + rect.bottom;
        }

        public int getDecoratedMeasuredWidth(View view) {
            Rect rect = ((LayoutParams)view.getLayoutParams()).mDecorInsets;
            return view.getMeasuredWidth() + rect.left + rect.right;
        }

        public int getDecoratedRight(View view) {
            return view.getRight() + this.getRightDecorationWidth(view);
        }

        public int getDecoratedTop(View view) {
            return view.getTop() - this.getTopDecorationHeight(view);
        }

        public View getFocusedChild() {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView == null) {
                return null;
            }
            if ((recyclerView = recyclerView.getFocusedChild()) != null && !this.mChildHelper.isHidden((View)recyclerView)) {
                return recyclerView;
            }
            return null;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public int getHeightMode() {
            return this.mHeightMode;
        }

        public int getItemCount() {
            Object object = this.mRecyclerView;
            object = object != null ? object.getAdapter() : null;
            int n2 = object != null ? ((Adapter)object).getItemCount() : 0;
            return n2;
        }

        public int getItemViewType(View view) {
            return RecyclerView.getChildViewHolderInt(view).getItemViewType();
        }

        public int getLayoutDirection() {
            return ViewCompat.getLayoutDirection((View)this.mRecyclerView);
        }

        public int getLeftDecorationWidth(View view) {
            return ((LayoutParams)view.getLayoutParams()).mDecorInsets.left;
        }

        public int getMinimumHeight() {
            return ViewCompat.getMinimumHeight((View)this.mRecyclerView);
        }

        public int getMinimumWidth() {
            return ViewCompat.getMinimumWidth((View)this.mRecyclerView);
        }

        public int getPaddingBottom() {
            RecyclerView recyclerView = this.mRecyclerView;
            int n2 = recyclerView != null ? recyclerView.getPaddingBottom() : 0;
            return n2;
        }

        public int getPaddingEnd() {
            RecyclerView recyclerView = this.mRecyclerView;
            int n2 = recyclerView != null ? ViewCompat.getPaddingEnd((View)recyclerView) : 0;
            return n2;
        }

        public int getPaddingLeft() {
            RecyclerView recyclerView = this.mRecyclerView;
            int n2 = recyclerView != null ? recyclerView.getPaddingLeft() : 0;
            return n2;
        }

        public int getPaddingRight() {
            RecyclerView recyclerView = this.mRecyclerView;
            int n2 = recyclerView != null ? recyclerView.getPaddingRight() : 0;
            return n2;
        }

        public int getPaddingStart() {
            RecyclerView recyclerView = this.mRecyclerView;
            int n2 = recyclerView != null ? ViewCompat.getPaddingStart((View)recyclerView) : 0;
            return n2;
        }

        public int getPaddingTop() {
            RecyclerView recyclerView = this.mRecyclerView;
            int n2 = recyclerView != null ? recyclerView.getPaddingTop() : 0;
            return n2;
        }

        public int getPosition(View view) {
            return ((LayoutParams)view.getLayoutParams()).getViewLayoutPosition();
        }

        public int getRightDecorationWidth(View view) {
            return ((LayoutParams)view.getLayoutParams()).mDecorInsets.right;
        }

        public int getRowCountForAccessibility(Recycler object, State state) {
            int n2;
            object = this.mRecyclerView;
            int n3 = n2 = 1;
            if (object != null) {
                if (((RecyclerView)((Object)object)).mAdapter == null) {
                    n3 = n2;
                } else {
                    n3 = n2;
                    if (this.canScrollVertically()) {
                        n3 = this.mRecyclerView.mAdapter.getItemCount();
                    }
                }
            }
            return n3;
        }

        public int getSelectionModeForAccessibility(Recycler recycler, State state) {
            return 0;
        }

        public int getTopDecorationHeight(View view) {
            return ((LayoutParams)view.getLayoutParams()).mDecorInsets.top;
        }

        public void getTransformedBoundingBox(View view, boolean bl, Rect rect) {
            Rect rect2;
            if (bl) {
                rect2 = ((LayoutParams)view.getLayoutParams()).mDecorInsets;
                rect.set(-rect2.left, -rect2.top, view.getWidth() + rect2.right, view.getHeight() + rect2.bottom);
            } else {
                rect.set(0, 0, view.getWidth(), view.getHeight());
            }
            if (this.mRecyclerView != null && (rect2 = view.getMatrix()) != null && !rect2.isIdentity()) {
                RectF rectF = this.mRecyclerView.mTempRectF;
                rectF.set(rect);
                rect2.mapRect(rectF);
                rect.set((int)Math.floor(rectF.left), (int)Math.floor(rectF.top), (int)Math.ceil(rectF.right), (int)Math.ceil(rectF.bottom));
            }
            rect.offset(view.getLeft(), view.getTop());
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getWidthMode() {
            return this.mWidthMode;
        }

        boolean hasFlexibleChildInBothOrientations() {
            int n2 = this.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                ViewGroup.LayoutParams layoutParams = this.getChildAt(i2).getLayoutParams();
                if (layoutParams.width >= 0 || layoutParams.height >= 0) continue;
                return true;
            }
            return false;
        }

        public boolean hasFocus() {
            RecyclerView recyclerView = this.mRecyclerView;
            boolean bl = recyclerView != null && recyclerView.hasFocus();
            return bl;
        }

        public void ignoreView(View object) {
            RecyclerView recyclerView;
            ViewParent viewParent = object.getParent();
            if (viewParent == (recyclerView = this.mRecyclerView) && recyclerView.indexOfChild((View)object) != -1) {
                object = RecyclerView.getChildViewHolderInt((View)object);
                ((ViewHolder)object).addFlags(128);
                this.mRecyclerView.mViewInfoStore.removeViewHolder((ViewHolder)object);
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("View should be fully attached to be ignored");
            ((StringBuilder)object).append(this.mRecyclerView.exceptionLabel());
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }

        public boolean isAttachedToWindow() {
            return this.mIsAttachedToWindow;
        }

        public boolean isAutoMeasureEnabled() {
            return this.mAutoMeasure;
        }

        public boolean isFocused() {
            RecyclerView recyclerView = this.mRecyclerView;
            boolean bl = recyclerView != null && recyclerView.isFocused();
            return bl;
        }

        public final boolean isItemPrefetchEnabled() {
            return this.mItemPrefetchEnabled;
        }

        public boolean isLayoutHierarchical(Recycler recycler, State state) {
            return false;
        }

        public boolean isMeasurementCacheEnabled() {
            return this.mMeasurementCacheEnabled;
        }

        public boolean isSmoothScrolling() {
            SmoothScroller smoothScroller = this.mSmoothScroller;
            boolean bl = smoothScroller != null && smoothScroller.isRunning();
            return bl;
        }

        public boolean isViewPartiallyVisible(View view, boolean bl, boolean bl2) {
            bl2 = this.mHorizontalBoundCheck.isViewWithinBoundFlags(view, 24579) && this.mVerticalBoundCheck.isViewWithinBoundFlags(view, 24579);
            if (bl) {
                return bl2;
            }
            return bl2 ^ true;
        }

        public void layoutDecorated(View view, int n2, int n3, int n4, int n5) {
            Rect rect = ((LayoutParams)view.getLayoutParams()).mDecorInsets;
            view.layout(n2 + rect.left, n3 + rect.top, n4 - rect.right, n5 - rect.bottom);
        }

        public void layoutDecoratedWithMargins(View view, int n2, int n3, int n4, int n5) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            Rect rect = layoutParams.mDecorInsets;
            view.layout(n2 + rect.left + layoutParams.leftMargin, n3 + rect.top + layoutParams.topMargin, n4 - rect.right - layoutParams.rightMargin, n5 - rect.bottom - layoutParams.bottomMargin);
        }

        public void measureChild(View view, int n2, int n3) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            Rect rect = this.mRecyclerView.getItemDecorInsetsForChild(view);
            int n4 = rect.left;
            int n5 = rect.right;
            int n6 = rect.top;
            int n7 = rect.bottom;
            n2 = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getWidthMode(), this.getPaddingLeft() + this.getPaddingRight() + (n2 + (n4 + n5)), layoutParams.width, this.canScrollHorizontally());
            if (this.shouldMeasureChild(view, n2, n3 = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getHeightMode(), this.getPaddingTop() + this.getPaddingBottom() + (n3 + (n6 + n7)), layoutParams.height, this.canScrollVertically()), layoutParams)) {
                view.measure(n2, n3);
            }
        }

        public void measureChildWithMargins(View view, int n2, int n3) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            Rect rect = this.mRecyclerView.getItemDecorInsetsForChild(view);
            int n4 = rect.left;
            int n5 = rect.right;
            int n6 = rect.top;
            int n7 = rect.bottom;
            n2 = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getWidthMode(), this.getPaddingLeft() + this.getPaddingRight() + layoutParams.leftMargin + layoutParams.rightMargin + (n2 + (n4 + n5)), layoutParams.width, this.canScrollHorizontally());
            if (this.shouldMeasureChild(view, n2, n3 = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getHeightMode(), this.getPaddingTop() + this.getPaddingBottom() + layoutParams.topMargin + layoutParams.bottomMargin + (n3 + (n6 + n7)), layoutParams.height, this.canScrollVertically()), layoutParams)) {
                view.measure(n2, n3);
            }
        }

        public void moveView(int n2, int n3) {
            Object object = this.getChildAt(n2);
            if (object != null) {
                this.detachViewAt(n2);
                this.attachView((View)object, n3);
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot move a child from non-existing index:");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(this.mRecyclerView.toString());
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }

        public void offsetChildrenHorizontal(int n2) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                recyclerView.offsetChildrenHorizontal(n2);
            }
        }

        public void offsetChildrenVertical(int n2) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                recyclerView.offsetChildrenVertical(n2);
            }
        }

        public void onAdapterChanged(Adapter adapter, Adapter adapter2) {
        }

        public boolean onAddFocusables(RecyclerView recyclerView, ArrayList<View> arrayList, int n2, int n3) {
            return false;
        }

        public void onAttachedToWindow(RecyclerView recyclerView) {
        }

        @Deprecated
        public void onDetachedFromWindow(RecyclerView recyclerView) {
        }

        public void onDetachedFromWindow(RecyclerView recyclerView, Recycler recycler) {
            this.onDetachedFromWindow(recyclerView);
        }

        public View onFocusSearchFailed(View view, int n2, Recycler recycler, State state) {
            return null;
        }

        public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            this.onInitializeAccessibilityEvent(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, accessibilityEvent);
        }

        public void onInitializeAccessibilityEvent(Recycler object, State state, AccessibilityEvent accessibilityEvent) {
            object = this.mRecyclerView;
            if (object != null && accessibilityEvent != null) {
                boolean bl;
                boolean bl2 = bl = true;
                if (!object.canScrollVertically(1)) {
                    bl2 = bl;
                    if (!this.mRecyclerView.canScrollVertically(-1)) {
                        bl2 = bl;
                        if (!this.mRecyclerView.canScrollHorizontally(-1)) {
                            bl2 = this.mRecyclerView.canScrollHorizontally(1) ? bl : false;
                        }
                    }
                }
                accessibilityEvent.setScrollable(bl2);
                if (this.mRecyclerView.mAdapter != null) {
                    accessibilityEvent.setItemCount(this.mRecyclerView.mAdapter.getItemCount());
                }
            }
        }

        void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            this.onInitializeAccessibilityNodeInfo(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, accessibilityNodeInfoCompat);
        }

        public void onInitializeAccessibilityNodeInfo(Recycler recycler, State state, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            if (this.mRecyclerView.canScrollVertically(-1) || this.mRecyclerView.canScrollHorizontally(-1)) {
                accessibilityNodeInfoCompat.addAction(8192);
                accessibilityNodeInfoCompat.setScrollable(true);
            }
            if (this.mRecyclerView.canScrollVertically(1) || this.mRecyclerView.canScrollHorizontally(1)) {
                accessibilityNodeInfoCompat.addAction(4096);
                accessibilityNodeInfoCompat.setScrollable(true);
            }
            accessibilityNodeInfoCompat.setCollectionInfo((Object)AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)this.getRowCountForAccessibility(recycler, state), (int)this.getColumnCountForAccessibility(recycler, state), (boolean)this.isLayoutHierarchical(recycler, state), (int)this.getSelectionModeForAccessibility(recycler, state)));
        }

        void onInitializeAccessibilityNodeInfoForItem(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (viewHolder != null && !viewHolder.isRemoved() && !this.mChildHelper.isHidden(viewHolder.itemView)) {
                this.onInitializeAccessibilityNodeInfoForItem(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, view, accessibilityNodeInfoCompat);
            }
        }

        public void onInitializeAccessibilityNodeInfoForItem(Recycler recycler, State state, View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            int n2 = this.canScrollVertically() ? this.getPosition(view) : 0;
            int n3 = this.canScrollHorizontally() ? this.getPosition(view) : 0;
            accessibilityNodeInfoCompat.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)n2, (int)1, (int)n3, (int)1, (boolean)false, (boolean)false));
        }

        public View onInterceptFocusSearch(View view, int n2) {
            return null;
        }

        public void onItemsAdded(RecyclerView recyclerView, int n2, int n3) {
        }

        public void onItemsChanged(RecyclerView recyclerView) {
        }

        public void onItemsMoved(RecyclerView recyclerView, int n2, int n3, int n4) {
        }

        public void onItemsRemoved(RecyclerView recyclerView, int n2, int n3) {
        }

        public void onItemsUpdated(RecyclerView recyclerView, int n2, int n3) {
        }

        public void onItemsUpdated(RecyclerView recyclerView, int n2, int n3, Object object) {
            this.onItemsUpdated(recyclerView, n2, n3);
        }

        public void onLayoutChildren(Recycler recycler, State state) {
            Log.e((String)RecyclerView.TAG, (String)"You must override onLayoutChildren(Recycler recycler, State state) ");
        }

        public void onLayoutCompleted(State state) {
        }

        public void onMeasure(Recycler recycler, State state, int n2, int n3) {
            this.mRecyclerView.defaultOnMeasure(n2, n3);
        }

        @Deprecated
        public boolean onRequestChildFocus(RecyclerView recyclerView, View view, View view2) {
            boolean bl = this.isSmoothScrolling() || recyclerView.isComputingLayout();
            return bl;
        }

        public boolean onRequestChildFocus(RecyclerView recyclerView, State state, View view, View view2) {
            return this.onRequestChildFocus(recyclerView, view, view2);
        }

        public void onRestoreInstanceState(Parcelable parcelable) {
        }

        public Parcelable onSaveInstanceState() {
            return null;
        }

        public void onScrollStateChanged(int n2) {
        }

        void onSmoothScrollerStopped(SmoothScroller smoothScroller) {
            if (this.mSmoothScroller == smoothScroller) {
                this.mSmoothScroller = null;
            }
        }

        boolean performAccessibilityAction(int n2, Bundle bundle) {
            return this.performAccessibilityAction(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, n2, bundle);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public boolean performAccessibilityAction(Recycler var1_1, State var2_2, int var3_3, Bundle var4_4) {
            block6: {
                block4: {
                    block5: {
                        var1_1 /* !! */  = this.mRecyclerView;
                        if (var1_1 /* !! */  == null) {
                            return false;
                        }
                        if (var3_3 == 4096) break block4;
                        if (var3_3 == 8192) break block5;
                        var3_3 = 0;
                        var5_5 = 0;
                        break block6;
                    }
                    var3_3 = var1_1 /* !! */ .canScrollVertically(-1) != false ? -(this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) : 0;
                    var5_5 = var3_3;
                    if (!this.mRecyclerView.canScrollHorizontally(-1)) ** GOTO lbl-1000
                    var5_5 = -(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
                    ** GOTO lbl20
                }
                var3_3 = var1_1 /* !! */ .canScrollVertically(1) != false ? this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() : 0;
                var5_5 = var3_3;
                if (this.mRecyclerView.canScrollHorizontally(1)) {
                    var5_5 = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
lbl20:
                    // 2 sources

                    var6_6 = var3_3;
                    var3_3 = var5_5;
                    var5_5 = var6_6;
                } else lbl-1000:
                // 2 sources

                {
                    var3_3 = 0;
                }
            }
            if (var5_5 == 0 && var3_3 == 0) {
                return false;
            }
            this.mRecyclerView.smoothScrollBy(var3_3, var5_5, null, -2147483648, true);
            return true;
        }

        boolean performAccessibilityActionForItem(View view, int n2, Bundle bundle) {
            return this.performAccessibilityActionForItem(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, view, n2, bundle);
        }

        public boolean performAccessibilityActionForItem(Recycler recycler, State state, View view, int n2, Bundle bundle) {
            return false;
        }

        public void postOnAnimation(Runnable runnable2) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                ViewCompat.postOnAnimation((View)recyclerView, runnable2);
            }
        }

        public void removeAllViews() {
            for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                this.mChildHelper.removeViewAt(i2);
            }
        }

        public void removeAndRecycleAllViews(Recycler recycler) {
            for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                if (RecyclerView.getChildViewHolderInt(this.getChildAt(i2)).shouldIgnore()) continue;
                this.removeAndRecycleViewAt(i2, recycler);
            }
        }

        void removeAndRecycleScrapInt(Recycler recycler) {
            int n2 = recycler.getScrapCount();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                View view = recycler.getScrapViewAt(i2);
                ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
                if (viewHolder.shouldIgnore()) continue;
                viewHolder.setIsRecyclable(false);
                if (viewHolder.isTmpDetached()) {
                    this.mRecyclerView.removeDetachedView(view, false);
                }
                if (this.mRecyclerView.mItemAnimator != null) {
                    this.mRecyclerView.mItemAnimator.endAnimation(viewHolder);
                }
                viewHolder.setIsRecyclable(true);
                recycler.quickRecycleScrapView(view);
            }
            recycler.clearScrap();
            if (n2 > 0) {
                this.mRecyclerView.invalidate();
            }
        }

        public void removeAndRecycleView(View view, Recycler recycler) {
            this.removeView(view);
            recycler.recycleView(view);
        }

        public void removeAndRecycleViewAt(int n2, Recycler recycler) {
            View view = this.getChildAt(n2);
            this.removeViewAt(n2);
            recycler.recycleView(view);
        }

        public boolean removeCallbacks(Runnable runnable2) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                return recyclerView.removeCallbacks(runnable2);
            }
            return false;
        }

        public void removeDetachedView(View view) {
            this.mRecyclerView.removeDetachedView(view, false);
        }

        public void removeView(View view) {
            this.mChildHelper.removeView(view);
        }

        public void removeViewAt(int n2) {
            if (this.getChildAt(n2) != null) {
                this.mChildHelper.removeViewAt(n2);
            }
        }

        public boolean requestChildRectangleOnScreen(RecyclerView recyclerView, View view, Rect rect, boolean bl) {
            return this.requestChildRectangleOnScreen(recyclerView, view, rect, bl, false);
        }

        public boolean requestChildRectangleOnScreen(RecyclerView recyclerView, View object, Rect rect, boolean bl, boolean bl2) {
            object = this.getChildRectangleOnScreenScrollAmount((View)object, rect);
            View view = object[0];
            View view2 = object[1];
            if (bl2 && !this.isFocusedChildVisibleAfterScrolling(recyclerView, (int)view, (int)view2) || view == false && view2 == false) {
                return false;
            }
            if (bl) {
                recyclerView.scrollBy((int)view, (int)view2);
            } else {
                recyclerView.smoothScrollBy((int)view, (int)view2);
            }
            return true;
        }

        public void requestLayout() {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                recyclerView.requestLayout();
            }
        }

        public void requestSimpleAnimationsInNextLayout() {
            this.mRequestedSimpleAnimations = true;
        }

        public int scrollHorizontallyBy(int n2, Recycler recycler, State state) {
            return 0;
        }

        public void scrollToPosition(int n2) {
        }

        public int scrollVerticallyBy(int n2, Recycler recycler, State state) {
            return 0;
        }

        @Deprecated
        public void setAutoMeasureEnabled(boolean bl) {
            this.mAutoMeasure = bl;
        }

        void setExactMeasureSpecsFrom(RecyclerView recyclerView) {
            this.setMeasureSpecs(View.MeasureSpec.makeMeasureSpec((int)recyclerView.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)recyclerView.getHeight(), (int)0x40000000));
        }

        public final void setItemPrefetchEnabled(boolean bl) {
            if (bl != this.mItemPrefetchEnabled) {
                this.mItemPrefetchEnabled = bl;
                this.mPrefetchMaxCountObserved = 0;
                RecyclerView recyclerView = this.mRecyclerView;
                if (recyclerView != null) {
                    recyclerView.mRecycler.updateViewCacheSize();
                }
            }
        }

        void setMeasureSpecs(int n2, int n3) {
            this.mWidth = View.MeasureSpec.getSize((int)n2);
            this.mWidthMode = View.MeasureSpec.getMode((int)n2);
            if (this.mWidthMode == 0 && !ALLOW_SIZE_IN_UNSPECIFIED_SPEC) {
                this.mWidth = 0;
            }
            this.mHeight = View.MeasureSpec.getSize((int)n3);
            this.mHeightMode = View.MeasureSpec.getMode((int)n3);
            if (this.mHeightMode == 0 && !ALLOW_SIZE_IN_UNSPECIFIED_SPEC) {
                this.mHeight = 0;
            }
        }

        public void setMeasuredDimension(int n2, int n3) {
            this.mRecyclerView.setMeasuredDimension(n2, n3);
        }

        public void setMeasuredDimension(Rect rect, int n2, int n3) {
            int n4 = rect.width();
            int n5 = this.getPaddingLeft();
            int n6 = this.getPaddingRight();
            int n7 = rect.height();
            int n8 = this.getPaddingTop();
            int n9 = this.getPaddingBottom();
            this.setMeasuredDimension(LayoutManager.chooseSize(n2, n4 + n5 + n6, this.getMinimumWidth()), LayoutManager.chooseSize(n3, n7 + n8 + n9, this.getMinimumHeight()));
        }

        void setMeasuredDimensionFromChildren(int n2, int n3) {
            int n4 = this.getChildCount();
            if (n4 == 0) {
                this.mRecyclerView.defaultOnMeasure(n2, n3);
                return;
            }
            int n5 = Integer.MAX_VALUE;
            int n6 = Integer.MAX_VALUE;
            int n7 = Integer.MIN_VALUE;
            int n8 = Integer.MIN_VALUE;
            for (int i2 = 0; i2 < n4; ++i2) {
                View view = this.getChildAt(i2);
                Rect rect = this.mRecyclerView.mTempRect;
                this.getDecoratedBoundsWithMargins(view, rect);
                int n9 = n5;
                if (rect.left < n5) {
                    n9 = rect.left;
                }
                int n10 = n7;
                if (rect.right > n7) {
                    n10 = rect.right;
                }
                n7 = n6;
                if (rect.top < n6) {
                    n7 = rect.top;
                }
                int n11 = n8;
                if (rect.bottom > n8) {
                    n11 = rect.bottom;
                }
                n6 = n7;
                n5 = n9;
                n7 = n10;
                n8 = n11;
            }
            this.mRecyclerView.mTempRect.set(n5, n6, n7, n8);
            this.setMeasuredDimension(this.mRecyclerView.mTempRect, n2, n3);
        }

        public void setMeasurementCacheEnabled(boolean bl) {
            this.mMeasurementCacheEnabled = bl;
        }

        void setRecyclerView(RecyclerView recyclerView) {
            if (recyclerView == null) {
                this.mRecyclerView = null;
                this.mChildHelper = null;
                this.mWidth = 0;
                this.mHeight = 0;
            } else {
                this.mRecyclerView = recyclerView;
                this.mChildHelper = recyclerView.mChildHelper;
                this.mWidth = recyclerView.getWidth();
                this.mHeight = recyclerView.getHeight();
            }
            this.mWidthMode = 0x40000000;
            this.mHeightMode = 0x40000000;
        }

        boolean shouldMeasureChild(View view, int n2, int n3, LayoutParams layoutParams) {
            boolean bl = view.isLayoutRequested() || !this.mMeasurementCacheEnabled || !LayoutManager.isMeasurementUpToDate(view.getWidth(), n2, layoutParams.width) || !LayoutManager.isMeasurementUpToDate(view.getHeight(), n3, layoutParams.height);
            return bl;
        }

        boolean shouldMeasureTwice() {
            return false;
        }

        boolean shouldReMeasureChild(View view, int n2, int n3, LayoutParams layoutParams) {
            boolean bl = !(this.mMeasurementCacheEnabled && LayoutManager.isMeasurementUpToDate(view.getMeasuredWidth(), n2, layoutParams.width) && LayoutManager.isMeasurementUpToDate(view.getMeasuredHeight(), n3, layoutParams.height));
            return bl;
        }

        public void smoothScrollToPosition(RecyclerView recyclerView, State state, int n2) {
            Log.e((String)RecyclerView.TAG, (String)"You must override smoothScrollToPosition to support smooth scrolling");
        }

        public void startSmoothScroll(SmoothScroller smoothScroller) {
            SmoothScroller smoothScroller2 = this.mSmoothScroller;
            if (smoothScroller2 != null && smoothScroller != smoothScroller2 && smoothScroller2.isRunning()) {
                this.mSmoothScroller.stop();
            }
            this.mSmoothScroller = smoothScroller;
            this.mSmoothScroller.start(this.mRecyclerView, this);
        }

        public void stopIgnoringView(View object) {
            object = RecyclerView.getChildViewHolderInt((View)object);
            ((ViewHolder)object).stopIgnoring();
            ((ViewHolder)object).resetInternal();
            ((ViewHolder)object).addFlags(4);
        }

        void stopSmoothScroller() {
            SmoothScroller smoothScroller = this.mSmoothScroller;
            if (smoothScroller != null) {
                smoothScroller.stop();
            }
        }

        public boolean supportsPredictiveItemAnimations() {
            return false;
        }

        public static interface LayoutPrefetchRegistry {
            public void addPosition(int var1, int var2);
        }

        public static class Properties {
            public int orientation;
            public boolean reverseLayout;
            public int spanCount;
            public boolean stackFromEnd;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        final Rect mDecorInsets = new Rect();
        boolean mInsetsDirty = true;
        boolean mPendingInvalidate = false;
        ViewHolder mViewHolder;

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.LayoutParams)layoutParams);
        }

        public int getViewAdapterPosition() {
            return this.mViewHolder.getAdapterPosition();
        }

        public int getViewLayoutPosition() {
            return this.mViewHolder.getLayoutPosition();
        }

        @Deprecated
        public int getViewPosition() {
            return this.mViewHolder.getPosition();
        }

        public boolean isItemChanged() {
            return this.mViewHolder.isUpdated();
        }

        public boolean isItemRemoved() {
            return this.mViewHolder.isRemoved();
        }

        public boolean isViewInvalid() {
            return this.mViewHolder.isInvalid();
        }

        public boolean viewNeedsUpdate() {
            return this.mViewHolder.needsUpdate();
        }
    }

    public static interface OnChildAttachStateChangeListener {
        public void onChildViewAttachedToWindow(View var1);

        public void onChildViewDetachedFromWindow(View var1);
    }

    public static abstract class OnFlingListener {
        public abstract boolean onFling(int var1, int var2);
    }

    public static interface OnItemTouchListener {
        public boolean onInterceptTouchEvent(RecyclerView var1, MotionEvent var2);

        public void onRequestDisallowInterceptTouchEvent(boolean var1);

        public void onTouchEvent(RecyclerView var1, MotionEvent var2);
    }

    public static abstract class OnScrollListener {
        public void onScrollStateChanged(RecyclerView recyclerView, int n2) {
        }

        public void onScrolled(RecyclerView recyclerView, int n2, int n3) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }

    public static class RecycledViewPool {
        private static final int DEFAULT_MAX_SCRAP = 5;
        private int mAttachCount = 0;
        SparseArray<ScrapData> mScrap = new SparseArray();

        private ScrapData getScrapDataForType(int n2) {
            ScrapData scrapData;
            ScrapData scrapData2 = scrapData = (ScrapData)this.mScrap.get(n2);
            if (scrapData == null) {
                scrapData2 = new ScrapData();
                this.mScrap.put(n2, (Object)scrapData2);
            }
            return scrapData2;
        }

        void attach() {
            ++this.mAttachCount;
        }

        public void clear() {
            for (int i2 = 0; i2 < this.mScrap.size(); ++i2) {
                ((ScrapData)this.mScrap.valueAt((int)i2)).mScrapHeap.clear();
            }
        }

        void detach() {
            --this.mAttachCount;
        }

        void factorInBindTime(int n2, long l2) {
            ScrapData scrapData = this.getScrapDataForType(n2);
            scrapData.mBindRunningAverageNs = this.runningAverage(scrapData.mBindRunningAverageNs, l2);
        }

        void factorInCreateTime(int n2, long l2) {
            ScrapData scrapData = this.getScrapDataForType(n2);
            scrapData.mCreateRunningAverageNs = this.runningAverage(scrapData.mCreateRunningAverageNs, l2);
        }

        public ViewHolder getRecycledView(int n2) {
            Object object = (ScrapData)this.mScrap.get(n2);
            if (object != null && !((ScrapData)object).mScrapHeap.isEmpty()) {
                object = ((ScrapData)object).mScrapHeap;
                for (n2 = ((ArrayList)object).size() - 1; n2 >= 0; --n2) {
                    if (((ViewHolder)((ArrayList)object).get(n2)).isAttachedToTransitionOverlay()) continue;
                    return (ViewHolder)((ArrayList)object).remove(n2);
                }
            }
            return null;
        }

        public int getRecycledViewCount(int n2) {
            return this.getScrapDataForType((int)n2).mScrapHeap.size();
        }

        void onAdapterChanged(Adapter adapter, Adapter adapter2, boolean bl) {
            if (adapter != null) {
                this.detach();
            }
            if (!bl && this.mAttachCount == 0) {
                this.clear();
            }
            if (adapter2 != null) {
                this.attach();
            }
        }

        public void putRecycledView(ViewHolder viewHolder) {
            int n2 = viewHolder.getItemViewType();
            ArrayList<ViewHolder> arrayList = this.getScrapDataForType((int)n2).mScrapHeap;
            if (((ScrapData)this.mScrap.get((int)n2)).mMaxScrap <= arrayList.size()) {
                return;
            }
            viewHolder.resetInternal();
            arrayList.add(viewHolder);
        }

        long runningAverage(long l2, long l3) {
            if (l2 == 0L) {
                return l3;
            }
            return l2 / 4L * 3L + l3 / 4L;
        }

        public void setMaxRecycledViews(int n2, int n3) {
            Object object = this.getScrapDataForType(n2);
            ((ScrapData)object).mMaxScrap = n3;
            object = ((ScrapData)object).mScrapHeap;
            while (((ArrayList)object).size() > n3) {
                ((ArrayList)object).remove(((ArrayList)object).size() - 1);
            }
        }

        int size() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.mScrap.size(); ++i2) {
                ArrayList<ViewHolder> arrayList = ((ScrapData)this.mScrap.valueAt((int)i2)).mScrapHeap;
                int n3 = n2;
                if (arrayList != null) {
                    n3 = n2 + arrayList.size();
                }
                n2 = n3;
            }
            return n2;
        }

        boolean willBindInTime(int n2, long l2, long l3) {
            long l4 = this.getScrapDataForType((int)n2).mBindRunningAverageNs;
            boolean bl = l4 == 0L || l2 + l4 < l3;
            return bl;
        }

        boolean willCreateInTime(int n2, long l2, long l3) {
            long l4 = this.getScrapDataForType((int)n2).mCreateRunningAverageNs;
            boolean bl = l4 == 0L || l2 + l4 < l3;
            return bl;
        }

        static class ScrapData {
            long mBindRunningAverageNs = 0L;
            long mCreateRunningAverageNs = 0L;
            int mMaxScrap = 5;
            final ArrayList<ViewHolder> mScrapHeap = new ArrayList();

            ScrapData() {
            }
        }
    }

    public final class Recycler {
        static final int DEFAULT_CACHE_SIZE = 2;
        final ArrayList<ViewHolder> mAttachedScrap = new ArrayList();
        final ArrayList<ViewHolder> mCachedViews = new ArrayList();
        ArrayList<ViewHolder> mChangedScrap = null;
        RecycledViewPool mRecyclerPool;
        private int mRequestedCacheMax = 2;
        private final List<ViewHolder> mUnmodifiableAttachedScrap = Collections.unmodifiableList(this.mAttachedScrap);
        private ViewCacheExtension mViewCacheExtension;
        int mViewCacheMax = 2;

        private void attachAccessibilityDelegateOnBind(ViewHolder viewHolder) {
            if (RecyclerView.this.isAccessibilityEnabled()) {
                View view = viewHolder.itemView;
                if (ViewCompat.getImportantForAccessibility(view) == 0) {
                    ViewCompat.setImportantForAccessibility(view, 1);
                }
                if (RecyclerView.this.mAccessibilityDelegate == null) {
                    return;
                }
                viewHolder = RecyclerView.this.mAccessibilityDelegate.getItemDelegate();
                if (viewHolder instanceof RecyclerViewAccessibilityDelegate.ItemDelegate) {
                    ((RecyclerViewAccessibilityDelegate.ItemDelegate)viewHolder).saveOriginalDelegate(view);
                }
                ViewCompat.setAccessibilityDelegate(view, (AccessibilityDelegateCompat)viewHolder);
            }
        }

        private void invalidateDisplayListInt(ViewGroup viewGroup, boolean bl) {
            int n2;
            for (n2 = viewGroup.getChildCount() - 1; n2 >= 0; --n2) {
                View view = viewGroup.getChildAt(n2);
                if (!(view instanceof ViewGroup)) continue;
                this.invalidateDisplayListInt((ViewGroup)view, true);
            }
            if (!bl) {
                return;
            }
            if (viewGroup.getVisibility() == 4) {
                viewGroup.setVisibility(0);
                viewGroup.setVisibility(4);
            } else {
                n2 = viewGroup.getVisibility();
                viewGroup.setVisibility(4);
                viewGroup.setVisibility(n2);
            }
        }

        private void invalidateDisplayListInt(ViewHolder viewHolder) {
            if (viewHolder.itemView instanceof ViewGroup) {
                this.invalidateDisplayListInt((ViewGroup)viewHolder.itemView, false);
            }
        }

        private boolean tryBindViewHolderByDeadline(ViewHolder viewHolder, int n2, int n3, long l2) {
            viewHolder.mOwnerRecyclerView = RecyclerView.this;
            int n4 = viewHolder.getItemViewType();
            long l3 = RecyclerView.this.getNanoTime();
            if (l2 != Long.MAX_VALUE && !this.mRecyclerPool.willBindInTime(n4, l3, l2)) {
                return false;
            }
            RecyclerView.this.mAdapter.bindViewHolder(viewHolder, n2);
            l2 = RecyclerView.this.getNanoTime();
            this.mRecyclerPool.factorInBindTime(viewHolder.getItemViewType(), l2 - l3);
            this.attachAccessibilityDelegateOnBind(viewHolder);
            if (RecyclerView.this.mState.isPreLayout()) {
                viewHolder.mPreLayoutPosition = n3;
            }
            return true;
        }

        void addViewHolderToRecycledViewPool(ViewHolder viewHolder, boolean bl) {
            RecyclerView.clearNestedRecyclerViewIfNotNested(viewHolder);
            View view = viewHolder.itemView;
            if (RecyclerView.this.mAccessibilityDelegate != null) {
                Object object = RecyclerView.this.mAccessibilityDelegate.getItemDelegate();
                object = object instanceof RecyclerViewAccessibilityDelegate.ItemDelegate ? ((RecyclerViewAccessibilityDelegate.ItemDelegate)object).getAndRemoveOriginalDelegateForItem(view) : null;
                ViewCompat.setAccessibilityDelegate(view, object);
            }
            if (bl) {
                this.dispatchViewRecycled(viewHolder);
            }
            viewHolder.mOwnerRecyclerView = null;
            this.getRecycledViewPool().putRecycledView(viewHolder);
        }

        public void bindViewToPosition(View object, int n2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt((View)object);
            if (viewHolder != null) {
                int n3 = RecyclerView.this.mAdapterHelper.findPositionOffset(n2);
                if (n3 >= 0 && n3 < RecyclerView.this.mAdapter.getItemCount()) {
                    this.tryBindViewHolderByDeadline(viewHolder, n3, n2, Long.MAX_VALUE);
                    object = viewHolder.itemView.getLayoutParams();
                    if (object == null) {
                        object = (LayoutParams)RecyclerView.this.generateDefaultLayoutParams();
                        viewHolder.itemView.setLayoutParams((ViewGroup.LayoutParams)object);
                    } else if (!RecyclerView.this.checkLayoutParams((ViewGroup.LayoutParams)object)) {
                        object = (LayoutParams)RecyclerView.this.generateLayoutParams((ViewGroup.LayoutParams)object);
                        viewHolder.itemView.setLayoutParams((ViewGroup.LayoutParams)object);
                    } else {
                        object = (LayoutParams)((Object)object);
                    }
                    boolean bl = true;
                    ((LayoutParams)((Object)object)).mInsetsDirty = true;
                    ((LayoutParams)((Object)object)).mViewHolder = viewHolder;
                    if (viewHolder.itemView.getParent() != null) {
                        bl = false;
                    }
                    ((LayoutParams)((Object)object)).mPendingInvalidate = bl;
                    return;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Inconsistency detected. Invalid item position ");
                ((StringBuilder)object).append(n2);
                ((StringBuilder)object).append("(offset:");
                ((StringBuilder)object).append(n3);
                ((StringBuilder)object).append(").state:");
                ((StringBuilder)object).append(RecyclerView.this.mState.getItemCount());
                ((StringBuilder)object).append(RecyclerView.this.exceptionLabel());
                throw new IndexOutOfBoundsException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("The view does not have a ViewHolder. You cannot pass arbitrary views to this method, they should be created by the Adapter");
            ((StringBuilder)object).append(RecyclerView.this.exceptionLabel());
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }

        public void clear() {
            this.mAttachedScrap.clear();
            this.recycleAndClearCachedViews();
        }

        void clearOldPositions() {
            int n2;
            int n3 = this.mCachedViews.size();
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                this.mCachedViews.get(n2).clearOldPosition();
            }
            n3 = this.mAttachedScrap.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.mAttachedScrap.get(n2).clearOldPosition();
            }
            ArrayList<ViewHolder> arrayList = this.mChangedScrap;
            if (arrayList != null) {
                n3 = arrayList.size();
                for (n2 = n4; n2 < n3; ++n2) {
                    this.mChangedScrap.get(n2).clearOldPosition();
                }
            }
        }

        void clearScrap() {
            this.mAttachedScrap.clear();
            ArrayList<ViewHolder> arrayList = this.mChangedScrap;
            if (arrayList != null) {
                arrayList.clear();
            }
        }

        public int convertPreLayoutPositionToPostLayout(int n2) {
            if (n2 >= 0 && n2 < RecyclerView.this.mState.getItemCount()) {
                if (!RecyclerView.this.mState.isPreLayout()) {
                    return n2;
                }
                return RecyclerView.this.mAdapterHelper.findPositionOffset(n2);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("invalid position ");
            stringBuilder.append(n2);
            stringBuilder.append(". State item count is ");
            stringBuilder.append(RecyclerView.this.mState.getItemCount());
            stringBuilder.append(RecyclerView.this.exceptionLabel());
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }

        void dispatchViewRecycled(ViewHolder viewHolder) {
            if (RecyclerView.this.mRecyclerListener != null) {
                RecyclerView.this.mRecyclerListener.onViewRecycled(viewHolder);
            }
            if (RecyclerView.this.mAdapter != null) {
                RecyclerView.this.mAdapter.onViewRecycled(viewHolder);
            }
            if (RecyclerView.this.mState != null) {
                RecyclerView.this.mViewInfoStore.removeViewHolder(viewHolder);
            }
        }

        ViewHolder getChangedScrapViewForPosition(int n2) {
            int n3;
            Object object = this.mChangedScrap;
            if (object != null && (n3 = ((ArrayList)object).size()) != 0) {
                int n4 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    object = this.mChangedScrap.get(i2);
                    if (((ViewHolder)object).wasReturnedFromScrap() || ((ViewHolder)object).getLayoutPosition() != n2) continue;
                    ((ViewHolder)object).addFlags(32);
                    return object;
                }
                if (RecyclerView.this.mAdapter.hasStableIds() && (n2 = RecyclerView.this.mAdapterHelper.findPositionOffset(n2)) > 0 && n2 < RecyclerView.this.mAdapter.getItemCount()) {
                    long l2 = RecyclerView.this.mAdapter.getItemId(n2);
                    for (n2 = n4; n2 < n3; ++n2) {
                        object = this.mChangedScrap.get(n2);
                        if (((ViewHolder)object).wasReturnedFromScrap() || ((ViewHolder)object).getItemId() != l2) continue;
                        ((ViewHolder)object).addFlags(32);
                        return object;
                    }
                }
            }
            return null;
        }

        RecycledViewPool getRecycledViewPool() {
            if (this.mRecyclerPool == null) {
                this.mRecyclerPool = new RecycledViewPool();
            }
            return this.mRecyclerPool;
        }

        int getScrapCount() {
            return this.mAttachedScrap.size();
        }

        public List<ViewHolder> getScrapList() {
            return this.mUnmodifiableAttachedScrap;
        }

        ViewHolder getScrapOrCachedViewForId(long l2, int n2, boolean bl) {
            ViewHolder viewHolder;
            int n3;
            for (n3 = this.mAttachedScrap.size() - 1; n3 >= 0; --n3) {
                viewHolder = this.mAttachedScrap.get(n3);
                if (viewHolder.getItemId() != l2 || viewHolder.wasReturnedFromScrap()) continue;
                if (n2 == viewHolder.getItemViewType()) {
                    viewHolder.addFlags(32);
                    if (viewHolder.isRemoved() && !RecyclerView.this.mState.isPreLayout()) {
                        viewHolder.setFlags(2, 14);
                    }
                    return viewHolder;
                }
                if (bl) continue;
                this.mAttachedScrap.remove(n3);
                RecyclerView.this.removeDetachedView(viewHolder.itemView, false);
                this.quickRecycleScrapView(viewHolder.itemView);
            }
            for (n3 = this.mCachedViews.size() - 1; n3 >= 0; --n3) {
                viewHolder = this.mCachedViews.get(n3);
                if (viewHolder.getItemId() != l2 || viewHolder.isAttachedToTransitionOverlay()) continue;
                if (n2 == viewHolder.getItemViewType()) {
                    if (!bl) {
                        this.mCachedViews.remove(n3);
                    }
                    return viewHolder;
                }
                if (bl) continue;
                this.recycleCachedViewAt(n3);
                return null;
            }
            return null;
        }

        ViewHolder getScrapOrHiddenOrCachedHolderForPosition(int n2, boolean bl) {
            Object object;
            ViewHolder viewHolder;
            int n3;
            int n4 = this.mAttachedScrap.size();
            int n5 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                viewHolder = this.mAttachedScrap.get(n3);
                if (viewHolder.wasReturnedFromScrap() || viewHolder.getLayoutPosition() != n2 || viewHolder.isInvalid() || !RecyclerView.this.mState.mInPreLayout && viewHolder.isRemoved()) continue;
                viewHolder.addFlags(32);
                return viewHolder;
            }
            if (!bl && (object = RecyclerView.this.mChildHelper.findHiddenNonRemovedView(n2)) != null) {
                viewHolder = RecyclerView.getChildViewHolderInt((View)object);
                RecyclerView.this.mChildHelper.unhide((View)object);
                n2 = RecyclerView.this.mChildHelper.indexOfChild((View)object);
                if (n2 != -1) {
                    RecyclerView.this.mChildHelper.detachViewFromParent(n2);
                    this.scrapView((View)object);
                    viewHolder.addFlags(8224);
                    return viewHolder;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("layout index should not be -1 after unhiding a view:");
                ((StringBuilder)object).append(viewHolder);
                ((StringBuilder)object).append(RecyclerView.this.exceptionLabel());
                throw new IllegalStateException(((StringBuilder)object).toString());
            }
            n4 = this.mCachedViews.size();
            for (n3 = n5; n3 < n4; ++n3) {
                viewHolder = this.mCachedViews.get(n3);
                if (viewHolder.isInvalid() || viewHolder.getLayoutPosition() != n2 || viewHolder.isAttachedToTransitionOverlay()) continue;
                if (!bl) {
                    this.mCachedViews.remove(n3);
                }
                return viewHolder;
            }
            return null;
        }

        View getScrapViewAt(int n2) {
            return this.mAttachedScrap.get((int)n2).itemView;
        }

        public View getViewForPosition(int n2) {
            return this.getViewForPosition(n2, false);
        }

        View getViewForPosition(int n2, boolean bl) {
            return this.tryGetViewHolderForPositionByDeadline((int)n2, (boolean)bl, (long)Long.MAX_VALUE).itemView;
        }

        void markItemDecorInsetsDirty() {
            int n2 = this.mCachedViews.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                LayoutParams layoutParams = (LayoutParams)this.mCachedViews.get((int)i2).itemView.getLayoutParams();
                if (layoutParams == null) continue;
                layoutParams.mInsetsDirty = true;
            }
        }

        void markKnownViewsInvalid() {
            int n2 = this.mCachedViews.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ViewHolder viewHolder = this.mCachedViews.get(i2);
                if (viewHolder == null) continue;
                viewHolder.addFlags(6);
                viewHolder.addChangePayload(null);
            }
            if (RecyclerView.this.mAdapter == null || !RecyclerView.this.mAdapter.hasStableIds()) {
                this.recycleAndClearCachedViews();
            }
        }

        void offsetPositionRecordsForInsert(int n2, int n3) {
            int n4 = this.mCachedViews.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                ViewHolder viewHolder = this.mCachedViews.get(i2);
                if (viewHolder == null || viewHolder.mPosition < n2) continue;
                viewHolder.offsetPosition(n3, true);
            }
        }

        void offsetPositionRecordsForMove(int n2, int n3) {
            int n4;
            int n5;
            int n6;
            if (n2 < n3) {
                n6 = n2;
                n5 = n3;
                n4 = -1;
            } else {
                n5 = n2;
                n6 = n3;
                n4 = 1;
            }
            int n7 = this.mCachedViews.size();
            for (int i2 = 0; i2 < n7; ++i2) {
                ViewHolder viewHolder = this.mCachedViews.get(i2);
                if (viewHolder == null || viewHolder.mPosition < n6 || viewHolder.mPosition > n5) continue;
                if (viewHolder.mPosition == n2) {
                    viewHolder.offsetPosition(n3 - n2, false);
                    continue;
                }
                viewHolder.offsetPosition(n4, false);
            }
        }

        void offsetPositionRecordsForRemove(int n2, int n3, boolean bl) {
            for (int i2 = this.mCachedViews.size() - 1; i2 >= 0; --i2) {
                ViewHolder viewHolder = this.mCachedViews.get(i2);
                if (viewHolder == null) continue;
                if (viewHolder.mPosition >= n2 + n3) {
                    viewHolder.offsetPosition(-n3, bl);
                    continue;
                }
                if (viewHolder.mPosition < n2) continue;
                viewHolder.addFlags(8);
                this.recycleCachedViewAt(i2);
            }
        }

        void onAdapterChanged(Adapter adapter, Adapter adapter2, boolean bl) {
            this.clear();
            this.getRecycledViewPool().onAdapterChanged(adapter, adapter2, bl);
        }

        void quickRecycleScrapView(View object) {
            object = RecyclerView.getChildViewHolderInt((View)object);
            ((ViewHolder)object).mScrapContainer = null;
            ((ViewHolder)object).mInChangeScrap = false;
            ((ViewHolder)object).clearReturnedFromScrapFlag();
            this.recycleViewHolderInternal((ViewHolder)object);
        }

        void recycleAndClearCachedViews() {
            for (int i2 = this.mCachedViews.size() - 1; i2 >= 0; --i2) {
                this.recycleCachedViewAt(i2);
            }
            this.mCachedViews.clear();
            if (ALLOW_THREAD_GAP_WORK) {
                RecyclerView.this.mPrefetchRegistry.clearPrefetchPositions();
            }
        }

        void recycleCachedViewAt(int n2) {
            this.addViewHolderToRecycledViewPool(this.mCachedViews.get(n2), true);
            this.mCachedViews.remove(n2);
        }

        public void recycleView(View view) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (viewHolder.isTmpDetached()) {
                RecyclerView.this.removeDetachedView(view, false);
            }
            if (viewHolder.isScrap()) {
                viewHolder.unScrap();
            } else if (viewHolder.wasReturnedFromScrap()) {
                viewHolder.clearReturnedFromScrapFlag();
            }
            this.recycleViewHolderInternal(viewHolder);
            if (RecyclerView.this.mItemAnimator != null && !viewHolder.isRecyclable()) {
                RecyclerView.this.mItemAnimator.endAnimation(viewHolder);
            }
        }

        void recycleViewHolderInternal(ViewHolder object) {
            boolean bl = ((ViewHolder)object).isScrap();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl && ((ViewHolder)object).itemView.getParent() == null) {
                if (!((ViewHolder)object).isTmpDetached()) {
                    if (!((ViewHolder)object).shouldIgnore()) {
                        int n2;
                        bl2 = ((ViewHolder)object).doesTransientStatePreventRecycling();
                        int n3 = RecyclerView.this.mAdapter != null && bl2 && RecyclerView.this.mAdapter.onFailedToRecycleView(object) ? 1 : 0;
                        if (n3 == 0 && !((ViewHolder)object).isRecyclable()) {
                            n2 = 0;
                        } else {
                            if (this.mViewCacheMax > 0 && !((ViewHolder)object).hasAnyOfTheFlags(526)) {
                                n3 = n2 = this.mCachedViews.size();
                                if (n2 >= this.mViewCacheMax) {
                                    n3 = n2;
                                    if (n2 > 0) {
                                        this.recycleCachedViewAt(0);
                                        n3 = n2 - 1;
                                    }
                                }
                                n2 = n3;
                                if (ALLOW_THREAD_GAP_WORK) {
                                    n2 = n3;
                                    if (n3 > 0) {
                                        n2 = n3--;
                                        if (!RecyclerView.this.mPrefetchRegistry.lastPrefetchIncludedPosition(((ViewHolder)object).mPosition)) {
                                            while (n3 >= 0 && RecyclerView.this.mPrefetchRegistry.lastPrefetchIncludedPosition(n2 = this.mCachedViews.get((int)n3).mPosition)) {
                                                --n3;
                                            }
                                            n2 = n3 + 1;
                                        }
                                    }
                                }
                                this.mCachedViews.add(n2, (ViewHolder)object);
                                n3 = 1;
                            } else {
                                n3 = 0;
                            }
                            n2 = n3;
                            if (n3 == 0) {
                                this.addViewHolderToRecycledViewPool((ViewHolder)object, true);
                                bl3 = true;
                                n2 = n3;
                            }
                        }
                        RecyclerView.this.mViewInfoStore.removeViewHolder((ViewHolder)object);
                        if (n2 == 0 && !bl3 && bl2) {
                            ((ViewHolder)object).mOwnerRecyclerView = null;
                        }
                        return;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Trying to recycle an ignored view holder. You should first call stopIgnoringView(view) before calling recycle.");
                    ((StringBuilder)object).append(RecyclerView.this.exceptionLabel());
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Tmp detached view should be removed from RecyclerView before it can be recycled: ");
                stringBuilder.append(object);
                stringBuilder.append(RecyclerView.this.exceptionLabel());
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Scrapped or attached views may not be recycled. isScrap:");
            stringBuilder.append(((ViewHolder)object).isScrap());
            stringBuilder.append(" isAttached:");
            if (((ViewHolder)object).itemView.getParent() != null) {
                bl2 = true;
            }
            stringBuilder.append(bl2);
            stringBuilder.append(RecyclerView.this.exceptionLabel());
            object = new IllegalArgumentException(stringBuilder.toString());
            throw object;
        }

        void scrapView(View object) {
            if (!((ViewHolder)(object = RecyclerView.getChildViewHolderInt((View)object))).hasAnyOfTheFlags(12) && ((ViewHolder)object).isUpdated() && !RecyclerView.this.canReuseUpdatedViewHolder((ViewHolder)object)) {
                if (this.mChangedScrap == null) {
                    this.mChangedScrap = new ArrayList();
                }
                ((ViewHolder)object).setScrapContainer(this, true);
                this.mChangedScrap.add((ViewHolder)object);
            } else {
                if (((ViewHolder)object).isInvalid() && !((ViewHolder)object).isRemoved() && !RecyclerView.this.mAdapter.hasStableIds()) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Called scrap view with an invalid view. Invalid views cannot be reused from scrap, they should rebound from recycler pool.");
                    ((StringBuilder)object).append(RecyclerView.this.exceptionLabel());
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                ((ViewHolder)object).setScrapContainer(this, false);
                this.mAttachedScrap.add((ViewHolder)object);
            }
        }

        void setRecycledViewPool(RecycledViewPool recycledViewPool) {
            RecycledViewPool recycledViewPool2 = this.mRecyclerPool;
            if (recycledViewPool2 != null) {
                recycledViewPool2.detach();
            }
            this.mRecyclerPool = recycledViewPool;
            if (this.mRecyclerPool != null && RecyclerView.this.getAdapter() != null) {
                this.mRecyclerPool.attach();
            }
        }

        void setViewCacheExtension(ViewCacheExtension viewCacheExtension) {
            this.mViewCacheExtension = viewCacheExtension;
        }

        public void setViewCacheSize(int n2) {
            this.mRequestedCacheMax = n2;
            this.updateViewCacheSize();
        }

        /*
         * Unable to fully structure code
         */
        ViewHolder tryGetViewHolderForPositionByDeadline(int var1_1, boolean var2_2, long var3_3) {
            block29: {
                block36: {
                    block35: {
                        block33: {
                            block34: {
                                block32: {
                                    block31: {
                                        block30: {
                                            if (var1_1 < 0 || var1_1 >= RecyclerView.this.mState.getItemCount()) break block29;
                                            var5_4 = RecyclerView.this.mState.isPreLayout();
                                            var6_5 = true;
                                            if (!var5_4) break block30;
                                            var8_7 = var7_6 = this.getChangedScrapViewForPosition(var1_1);
                                            if (var7_6 == null) break block31;
                                            var9_9 = 1;
                                            break block32;
                                        }
                                        var8_7 = null;
                                    }
                                    var9_9 = 0;
                                    var7_6 = var8_7;
                                }
                                var8_7 = var7_6;
                                var10_10 = var9_9;
                                if (var7_6 == null) {
                                    var8_7 = var7_6 = this.getScrapOrHiddenOrCachedHolderForPosition(var1_1, var2_2);
                                    var10_10 = var9_9;
                                    if (var7_6 != null) {
                                        if (!this.validateViewHolderForOffsetPosition((ViewHolder)var7_6)) {
                                            if (!var2_2) {
                                                var7_6.addFlags(4);
                                                if (var7_6.isScrap()) {
                                                    RecyclerView.this.removeDetachedView(var7_6.itemView, false);
                                                    var7_6.unScrap();
                                                } else if (var7_6.wasReturnedFromScrap()) {
                                                    var7_6.clearReturnedFromScrapFlag();
                                                }
                                                this.recycleViewHolderInternal((ViewHolder)var7_6);
                                            }
                                            var8_7 = null;
                                            var10_10 = var9_9;
                                        } else {
                                            var10_10 = 1;
                                            var8_7 = var7_6;
                                        }
                                    }
                                }
                                var11_11 = var8_7;
                                var12_12 = var10_10;
                                if (var8_7 != null) break block33;
                                var12_12 = RecyclerView.this.mAdapterHelper.findPositionOffset(var1_1);
                                if (var12_12 < 0 || var12_12 >= RecyclerView.this.mAdapter.getItemCount()) break block34;
                                var13_13 = RecyclerView.this.mAdapter.getItemViewType(var12_12);
                                var7_6 = var8_7;
                                var9_9 = var10_10;
                                if (RecyclerView.this.mAdapter.hasStableIds()) {
                                    var7_6 = var8_7 = this.getScrapOrCachedViewForId(RecyclerView.this.mAdapter.getItemId(var12_12), var13_13, var2_2);
                                    var9_9 = var10_10;
                                    if (var8_7 != null) {
                                        var8_7.mPosition = var12_12;
                                        var9_9 = 1;
                                        var7_6 = var8_7;
                                    }
                                }
                                var8_7 = var7_6;
                                if (var7_6 == null) {
                                    var11_11 = this.mViewCacheExtension;
                                    var8_7 = var7_6;
                                    if (var11_11 != null) {
                                        var11_11 = var11_11.getViewForPositionAndType(this, var1_1, var13_13);
                                        var8_7 = var7_6;
                                        if (var11_11 != null) {
                                            var8_7 = RecyclerView.this.getChildViewHolder((View)var11_11);
                                            if (var8_7 != null) {
                                                if (var8_7.shouldIgnore()) {
                                                    var8_7 = new StringBuilder();
                                                    var8_7.append("getViewForPositionAndType returned a view that is ignored. You must call stopIgnoring before returning this view.");
                                                    var8_7.append(RecyclerView.this.exceptionLabel());
                                                    throw new IllegalArgumentException(var8_7.toString());
                                                }
                                            } else {
                                                var8_7 = new StringBuilder();
                                                var8_7.append("getViewForPositionAndType returned a view which does not have a ViewHolder");
                                                var8_7.append(RecyclerView.this.exceptionLabel());
                                                throw new IllegalArgumentException(var8_7.toString());
                                            }
                                        }
                                    }
                                }
                                var7_6 = var8_7;
                                if (var8_7 == null) {
                                    var7_6 = var8_7 = this.getRecycledViewPool().getRecycledView(var13_13);
                                    if (var8_7 != null) {
                                        var8_7.resetInternal();
                                        var7_6 = var8_7;
                                        if (RecyclerView.FORCE_INVALIDATE_DISPLAY_LIST) {
                                            this.invalidateDisplayListInt((ViewHolder)var8_7);
                                            var7_6 = var8_7;
                                        }
                                    }
                                }
                                var11_11 = var7_6;
                                var12_12 = var9_9;
                                if (var7_6 != null) break block33;
                                var14_14 = RecyclerView.this.getNanoTime();
                                if (var3_3 != 0x7FFFFFFFFFFFFFFFL && !this.mRecyclerPool.willCreateInTime(var13_13, var14_14, var3_3)) {
                                    return null;
                                }
                                var7_6 = RecyclerView.this.mAdapter.createViewHolder(RecyclerView.this, var13_13);
                                if (RecyclerView.ALLOW_THREAD_GAP_WORK && (var8_7 = RecyclerView.findNestedRecyclerView(var7_6.itemView)) != null) {
                                    var7_6.mNestedRecyclerView = new WeakReference<Object>(var8_7);
                                }
                                var16_15 = RecyclerView.this.getNanoTime();
                                this.mRecyclerPool.factorInCreateTime(var13_13, var16_15 - var14_14);
                                break block35;
                            }
                            var8_7 = new StringBuilder();
                            var8_7.append("Inconsistency detected. Invalid item position ");
                            var8_7.append(var1_1);
                            var8_7.append("(offset:");
                            var8_7.append(var12_12);
                            var8_7.append(").state:");
                            var8_7.append(RecyclerView.this.mState.getItemCount());
                            var8_7.append(RecyclerView.this.exceptionLabel());
                            throw new IndexOutOfBoundsException(var8_7.toString());
                        }
                        var7_6 = var11_11;
                        var9_9 = var12_12;
                    }
                    if (var9_9 != 0 && !RecyclerView.this.mState.isPreLayout() && var7_6.hasAnyOfTheFlags(8192)) {
                        var7_6.setFlags(0, 8192);
                        if (RecyclerView.this.mState.mRunSimpleAnimations) {
                            var10_10 = ItemAnimator.buildAdapterChangeFlagsForAnimations((ViewHolder)var7_6);
                            var8_7 = RecyclerView.this.mItemAnimator.recordPreLayoutInformation(RecyclerView.this.mState, (ViewHolder)var7_6, var10_10 | 4096, var7_6.getUnmodifiedPayloads());
                            RecyclerView.this.recordAnimationInfoIfBouncedHiddenView((ViewHolder)var7_6, (ItemAnimator.ItemHolderInfo)var8_7);
                        }
                    }
                    if (!RecyclerView.this.mState.isPreLayout() || !var7_6.isBound()) break block36;
                    var7_6.mPreLayoutPosition = var1_1;
                    ** GOTO lbl-1000
                }
                if (var7_6.isBound() && !var7_6.needsUpdate() && !var7_6.isInvalid()) lbl-1000:
                // 2 sources

                {
                    var2_2 = false;
                } else {
                    var2_2 = this.tryBindViewHolderByDeadline((ViewHolder)var7_6, RecyclerView.this.mAdapterHelper.findPositionOffset(var1_1), var1_1, var3_3);
                }
                var8_7 = var7_6.itemView.getLayoutParams();
                if (var8_7 == null) {
                    var8_7 = (LayoutParams)RecyclerView.this.generateDefaultLayoutParams();
                    var7_6.itemView.setLayoutParams((ViewGroup.LayoutParams)var8_7);
                } else if (!RecyclerView.this.checkLayoutParams((ViewGroup.LayoutParams)var8_7)) {
                    var8_7 = (LayoutParams)RecyclerView.this.generateLayoutParams((ViewGroup.LayoutParams)var8_7);
                    var7_6.itemView.setLayoutParams((ViewGroup.LayoutParams)var8_7);
                } else {
                    var8_7 = (LayoutParams)var8_7;
                }
                var8_7.mViewHolder = var7_6;
                var2_2 = var9_9 != 0 && var2_2 != false ? var6_5 : false;
                var8_7.mPendingInvalidate = var2_2;
                return var7_6;
            }
            var8_8 = new StringBuilder();
            var8_8.append("Invalid item position ");
            var8_8.append(var1_1);
            var8_8.append("(");
            var8_8.append(var1_1);
            var8_8.append("). Item count:");
            var8_8.append(RecyclerView.this.mState.getItemCount());
            var8_8.append(RecyclerView.this.exceptionLabel());
            throw new IndexOutOfBoundsException(var8_8.toString());
        }

        void unscrapView(ViewHolder viewHolder) {
            if (viewHolder.mInChangeScrap) {
                this.mChangedScrap.remove(viewHolder);
            } else {
                this.mAttachedScrap.remove(viewHolder);
            }
            viewHolder.mScrapContainer = null;
            viewHolder.mInChangeScrap = false;
            viewHolder.clearReturnedFromScrapFlag();
        }

        void updateViewCacheSize() {
            int n2 = RecyclerView.this.mLayout != null ? RecyclerView.this.mLayout.mPrefetchMaxCountObserved : 0;
            this.mViewCacheMax = this.mRequestedCacheMax + n2;
            for (n2 = this.mCachedViews.size() - 1; n2 >= 0 && this.mCachedViews.size() > this.mViewCacheMax; --n2) {
                this.recycleCachedViewAt(n2);
            }
        }

        boolean validateViewHolderForOffsetPosition(ViewHolder viewHolder) {
            if (viewHolder.isRemoved()) {
                return RecyclerView.this.mState.isPreLayout();
            }
            if (viewHolder.mPosition >= 0 && viewHolder.mPosition < RecyclerView.this.mAdapter.getItemCount()) {
                boolean bl = RecyclerView.this.mState.isPreLayout();
                boolean bl2 = false;
                if (!bl && RecyclerView.this.mAdapter.getItemViewType(viewHolder.mPosition) != viewHolder.getItemViewType()) {
                    return false;
                }
                if (RecyclerView.this.mAdapter.hasStableIds()) {
                    if (viewHolder.getItemId() == RecyclerView.this.mAdapter.getItemId(viewHolder.mPosition)) {
                        bl2 = true;
                    }
                    return bl2;
                }
                return true;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Inconsistency detected. Invalid view holder adapter position");
            stringBuilder.append(viewHolder);
            stringBuilder.append(RecyclerView.this.exceptionLabel());
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }

        void viewRangeUpdate(int n2, int n3) {
            for (int i2 = this.mCachedViews.size() - 1; i2 >= 0; --i2) {
                int n4;
                ViewHolder viewHolder = this.mCachedViews.get(i2);
                if (viewHolder == null || (n4 = viewHolder.mPosition) < n2 || n4 >= n3 + n2) continue;
                viewHolder.addFlags(2);
                this.recycleCachedViewAt(i2);
            }
        }
    }

    public static interface RecyclerListener {
        public void onViewRecycled(ViewHolder var1);
    }

    private class RecyclerViewDataObserver
    extends AdapterDataObserver {
        RecyclerViewDataObserver() {
        }

        @Override
        public void onChanged() {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            RecyclerView.this.mState.mStructureChanged = true;
            RecyclerView.this.processDataSetCompletelyChanged(true);
            if (!RecyclerView.this.mAdapterHelper.hasPendingUpdates()) {
                RecyclerView.this.requestLayout();
            }
        }

        @Override
        public void onItemRangeChanged(int n2, int n3, Object object) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.onItemRangeChanged(n2, n3, object)) {
                this.triggerUpdateProcessor();
            }
        }

        @Override
        public void onItemRangeInserted(int n2, int n3) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.onItemRangeInserted(n2, n3)) {
                this.triggerUpdateProcessor();
            }
        }

        @Override
        public void onItemRangeMoved(int n2, int n3, int n4) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.onItemRangeMoved(n2, n3, n4)) {
                this.triggerUpdateProcessor();
            }
        }

        @Override
        public void onItemRangeRemoved(int n2, int n3) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.onItemRangeRemoved(n2, n3)) {
                this.triggerUpdateProcessor();
            }
        }

        void triggerUpdateProcessor() {
            if (POST_UPDATES_ON_ANIMATION && RecyclerView.this.mHasFixedSize && RecyclerView.this.mIsAttached) {
                RecyclerView recyclerView = RecyclerView.this;
                ViewCompat.postOnAnimation((View)recyclerView, recyclerView.mUpdateChildViewsRunnable);
            } else {
                RecyclerView recyclerView = RecyclerView.this;
                recyclerView.mAdapterUpdateDuringMeasure = true;
                recyclerView.requestLayout();
            }
        }
    }

    public static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        Parcelable mLayoutState;

        SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            if (classLoader == null) {
                classLoader = LayoutManager.class.getClassLoader();
            }
            this.mLayoutState = parcel.readParcelable(classLoader);
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        void copyFrom(SavedState savedState) {
            this.mLayoutState = savedState.mLayoutState;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeParcelable(this.mLayoutState, 0);
        }
    }

    public static class SimpleOnItemTouchListener
    implements OnItemTouchListener {
        @Override
        public boolean onInterceptTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
            return false;
        }

        @Override
        public void onRequestDisallowInterceptTouchEvent(boolean bl) {
        }

        @Override
        public void onTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
        }
    }

    public static abstract class SmoothScroller {
        private LayoutManager mLayoutManager;
        private boolean mPendingInitialRun;
        private RecyclerView mRecyclerView;
        private final Action mRecyclingAction = new Action(0, 0);
        private boolean mRunning;
        private boolean mStarted;
        private int mTargetPosition = -1;
        private View mTargetView;

        public PointF computeScrollVectorForPosition(int n2) {
            Object object = this.getLayoutManager();
            if (object instanceof ScrollVectorProvider) {
                return ((ScrollVectorProvider)object).computeScrollVectorForPosition(n2);
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("You should override computeScrollVectorForPosition when the LayoutManager does not implement ");
            ((StringBuilder)object).append(ScrollVectorProvider.class.getCanonicalName());
            Log.w((String)RecyclerView.TAG, (String)((StringBuilder)object).toString());
            return null;
        }

        public View findViewByPosition(int n2) {
            return this.mRecyclerView.mLayout.findViewByPosition(n2);
        }

        public int getChildCount() {
            return this.mRecyclerView.mLayout.getChildCount();
        }

        public int getChildPosition(View view) {
            return this.mRecyclerView.getChildLayoutPosition(view);
        }

        public LayoutManager getLayoutManager() {
            return this.mLayoutManager;
        }

        public int getTargetPosition() {
            return this.mTargetPosition;
        }

        @Deprecated
        public void instantScrollToPosition(int n2) {
            this.mRecyclerView.scrollToPosition(n2);
        }

        public boolean isPendingInitialRun() {
            return this.mPendingInitialRun;
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        protected void normalize(PointF pointF) {
            float f2 = (float)Math.sqrt(pointF.x * pointF.x + pointF.y * pointF.y);
            pointF.x /= f2;
            pointF.y /= f2;
        }

        void onAnimation(int n2, int n3) {
            View view;
            RecyclerView recyclerView = this.mRecyclerView;
            if (this.mTargetPosition == -1 || recyclerView == null) {
                this.stop();
            }
            if (this.mPendingInitialRun && this.mTargetView == null && this.mLayoutManager != null && (view = this.computeScrollVectorForPosition(this.mTargetPosition)) != null && (view.x != 0.0f || view.y != 0.0f)) {
                recyclerView.scrollStep((int)Math.signum(view.x), (int)Math.signum(view.y), null);
            }
            this.mPendingInitialRun = false;
            view = this.mTargetView;
            if (view != null) {
                if (this.getChildPosition(view) == this.mTargetPosition) {
                    this.onTargetFound(this.mTargetView, recyclerView.mState, this.mRecyclingAction);
                    this.mRecyclingAction.runIfNecessary(recyclerView);
                    this.stop();
                } else {
                    Log.e((String)RecyclerView.TAG, (String)"Passed over target position while smooth scrolling.");
                    this.mTargetView = null;
                }
            }
            if (this.mRunning) {
                this.onSeekTargetStep(n2, n3, recyclerView.mState, this.mRecyclingAction);
                boolean bl = this.mRecyclingAction.hasJumpTarget();
                this.mRecyclingAction.runIfNecessary(recyclerView);
                if (bl && this.mRunning) {
                    this.mPendingInitialRun = true;
                    recyclerView.mViewFlinger.postOnAnimation();
                }
            }
        }

        protected void onChildAttachedToWindow(View view) {
            if (this.getChildPosition(view) == this.getTargetPosition()) {
                this.mTargetView = view;
            }
        }

        protected abstract void onSeekTargetStep(int var1, int var2, State var3, Action var4);

        protected abstract void onStart();

        protected abstract void onStop();

        protected abstract void onTargetFound(View var1, State var2, Action var3);

        public void setTargetPosition(int n2) {
            this.mTargetPosition = n2;
        }

        void start(RecyclerView recyclerView, LayoutManager layoutManager) {
            recyclerView.mViewFlinger.stop();
            if (this.mStarted) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("An instance of ");
                stringBuilder.append(this.getClass().getSimpleName());
                stringBuilder.append(" was started more than once. Each instance of");
                stringBuilder.append(this.getClass().getSimpleName());
                stringBuilder.append(" is intended to only be used once. You should create a new instance for each use.");
                Log.w((String)RecyclerView.TAG, (String)stringBuilder.toString());
            }
            this.mRecyclerView = recyclerView;
            this.mLayoutManager = layoutManager;
            if (this.mTargetPosition != -1) {
                this.mRecyclerView.mState.mTargetPosition = this.mTargetPosition;
                this.mRunning = true;
                this.mPendingInitialRun = true;
                this.mTargetView = this.findViewByPosition(this.getTargetPosition());
                this.onStart();
                this.mRecyclerView.mViewFlinger.postOnAnimation();
                this.mStarted = true;
                return;
            }
            throw new IllegalArgumentException("Invalid target position");
        }

        protected final void stop() {
            if (!this.mRunning) {
                return;
            }
            this.mRunning = false;
            this.onStop();
            this.mRecyclerView.mState.mTargetPosition = -1;
            this.mTargetView = null;
            this.mTargetPosition = -1;
            this.mPendingInitialRun = false;
            this.mLayoutManager.onSmoothScrollerStopped(this);
            this.mLayoutManager = null;
            this.mRecyclerView = null;
        }

        public static class Action {
            public static final int UNDEFINED_DURATION = Integer.MIN_VALUE;
            private boolean mChanged = false;
            private int mConsecutiveUpdates = 0;
            private int mDuration;
            private int mDx;
            private int mDy;
            private Interpolator mInterpolator;
            private int mJumpToPosition = -1;

            public Action(int n2, int n3) {
                this(n2, n3, Integer.MIN_VALUE, null);
            }

            public Action(int n2, int n3, int n4) {
                this(n2, n3, n4, null);
            }

            public Action(int n2, int n3, int n4, Interpolator interpolator2) {
                this.mDx = n2;
                this.mDy = n3;
                this.mDuration = n4;
                this.mInterpolator = interpolator2;
            }

            private void validate() {
                if (this.mInterpolator != null && this.mDuration < 1) {
                    throw new IllegalStateException("If you provide an interpolator, you must set a positive duration");
                }
                if (this.mDuration >= 1) {
                    return;
                }
                throw new IllegalStateException("Scroll duration must be a positive number");
            }

            public int getDuration() {
                return this.mDuration;
            }

            public int getDx() {
                return this.mDx;
            }

            public int getDy() {
                return this.mDy;
            }

            public Interpolator getInterpolator() {
                return this.mInterpolator;
            }

            boolean hasJumpTarget() {
                boolean bl = this.mJumpToPosition >= 0;
                return bl;
            }

            public void jumpTo(int n2) {
                this.mJumpToPosition = n2;
            }

            void runIfNecessary(RecyclerView recyclerView) {
                int n2 = this.mJumpToPosition;
                if (n2 >= 0) {
                    this.mJumpToPosition = -1;
                    recyclerView.jumpToPositionForSmoothScroller(n2);
                    this.mChanged = false;
                    return;
                }
                if (this.mChanged) {
                    this.validate();
                    recyclerView.mViewFlinger.smoothScrollBy(this.mDx, this.mDy, this.mDuration, this.mInterpolator);
                    ++this.mConsecutiveUpdates;
                    if (this.mConsecutiveUpdates > 10) {
                        Log.e((String)RecyclerView.TAG, (String)"Smooth Scroll action is being updated too frequently. Make sure you are not changing it unless necessary");
                    }
                    this.mChanged = false;
                } else {
                    this.mConsecutiveUpdates = 0;
                }
            }

            public void setDuration(int n2) {
                this.mChanged = true;
                this.mDuration = n2;
            }

            public void setDx(int n2) {
                this.mChanged = true;
                this.mDx = n2;
            }

            public void setDy(int n2) {
                this.mChanged = true;
                this.mDy = n2;
            }

            public void setInterpolator(Interpolator interpolator2) {
                this.mChanged = true;
                this.mInterpolator = interpolator2;
            }

            public void update(int n2, int n3, int n4, Interpolator interpolator2) {
                this.mDx = n2;
                this.mDy = n3;
                this.mDuration = n4;
                this.mInterpolator = interpolator2;
                this.mChanged = true;
            }
        }

        public static interface ScrollVectorProvider {
            public PointF computeScrollVectorForPosition(int var1);
        }
    }

    public static class State {
        static final int STEP_ANIMATIONS = 4;
        static final int STEP_LAYOUT = 2;
        static final int STEP_START = 1;
        private SparseArray<Object> mData;
        int mDeletedInvisibleItemCountSincePreviousLayout = 0;
        long mFocusedItemId;
        int mFocusedItemPosition;
        int mFocusedSubChildId;
        boolean mInPreLayout = false;
        boolean mIsMeasuring = false;
        int mItemCount = 0;
        int mLayoutStep = 1;
        int mPreviousLayoutItemCount = 0;
        int mRemainingScrollHorizontal;
        int mRemainingScrollVertical;
        boolean mRunPredictiveAnimations = false;
        boolean mRunSimpleAnimations = false;
        boolean mStructureChanged = false;
        int mTargetPosition = -1;
        boolean mTrackOldChangeHolders = false;

        void assertLayoutStep(int n2) {
            if ((this.mLayoutStep & n2) != 0) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Layout state should be one of ");
            stringBuilder.append(Integer.toBinaryString(n2));
            stringBuilder.append(" but it is ");
            stringBuilder.append(Integer.toBinaryString(this.mLayoutStep));
            throw new IllegalStateException(stringBuilder.toString());
        }

        public boolean didStructureChange() {
            return this.mStructureChanged;
        }

        public <T> T get(int n2) {
            SparseArray<Object> sparseArray = this.mData;
            if (sparseArray == null) {
                return null;
            }
            return (T)sparseArray.get(n2);
        }

        public int getItemCount() {
            int n2 = this.mInPreLayout ? this.mPreviousLayoutItemCount - this.mDeletedInvisibleItemCountSincePreviousLayout : this.mItemCount;
            return n2;
        }

        public int getRemainingScrollHorizontal() {
            return this.mRemainingScrollHorizontal;
        }

        public int getRemainingScrollVertical() {
            return this.mRemainingScrollVertical;
        }

        public int getTargetScrollPosition() {
            return this.mTargetPosition;
        }

        public boolean hasTargetScrollPosition() {
            boolean bl = this.mTargetPosition != -1;
            return bl;
        }

        public boolean isMeasuring() {
            return this.mIsMeasuring;
        }

        public boolean isPreLayout() {
            return this.mInPreLayout;
        }

        void prepareForNestedPrefetch(Adapter adapter) {
            this.mLayoutStep = 1;
            this.mItemCount = adapter.getItemCount();
            this.mInPreLayout = false;
            this.mTrackOldChangeHolders = false;
            this.mIsMeasuring = false;
        }

        public void put(int n2, Object object) {
            if (this.mData == null) {
                this.mData = new SparseArray();
            }
            this.mData.put(n2, object);
        }

        public void remove(int n2) {
            SparseArray<Object> sparseArray = this.mData;
            if (sparseArray == null) {
                return;
            }
            sparseArray.remove(n2);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("State{mTargetPosition=");
            stringBuilder.append(this.mTargetPosition);
            stringBuilder.append(", mData=");
            stringBuilder.append(this.mData);
            stringBuilder.append(", mItemCount=");
            stringBuilder.append(this.mItemCount);
            stringBuilder.append(", mIsMeasuring=");
            stringBuilder.append(this.mIsMeasuring);
            stringBuilder.append(", mPreviousLayoutItemCount=");
            stringBuilder.append(this.mPreviousLayoutItemCount);
            stringBuilder.append(", mDeletedInvisibleItemCountSincePreviousLayout=");
            stringBuilder.append(this.mDeletedInvisibleItemCountSincePreviousLayout);
            stringBuilder.append(", mStructureChanged=");
            stringBuilder.append(this.mStructureChanged);
            stringBuilder.append(", mInPreLayout=");
            stringBuilder.append(this.mInPreLayout);
            stringBuilder.append(", mRunSimpleAnimations=");
            stringBuilder.append(this.mRunSimpleAnimations);
            stringBuilder.append(", mRunPredictiveAnimations=");
            stringBuilder.append(this.mRunPredictiveAnimations);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        public boolean willRunPredictiveAnimations() {
            return this.mRunPredictiveAnimations;
        }

        public boolean willRunSimpleAnimations() {
            return this.mRunSimpleAnimations;
        }
    }

    public static abstract class ViewCacheExtension {
        public abstract View getViewForPositionAndType(Recycler var1, int var2, int var3);
    }

    class ViewFlinger
    implements Runnable {
        private boolean mEatRunOnAnimationRequest = false;
        Interpolator mInterpolator = sQuinticInterpolator;
        private int mLastFlingX;
        private int mLastFlingY;
        OverScroller mOverScroller;
        private boolean mReSchedulePostAnimationCallback = false;

        ViewFlinger() {
            this.mOverScroller = new OverScroller(RecyclerView.this.getContext(), sQuinticInterpolator);
        }

        private int computeScrollDuration(int n2, int n3, int n4, int n5) {
            int n6;
            int n7 = Math.abs(n2);
            boolean bl = n7 > (n6 = Math.abs(n3));
            n4 = (int)Math.sqrt(n4 * n4 + n5 * n5);
            n3 = (int)Math.sqrt(n2 * n2 + n3 * n3);
            RecyclerView recyclerView = RecyclerView.this;
            n2 = bl ? recyclerView.getWidth() : recyclerView.getHeight();
            n5 = n2 / 2;
            float f2 = n3;
            float f3 = n2;
            float f4 = Math.min(1.0f, f2 * 1.0f / f3);
            f2 = n5;
            f4 = this.distanceInfluenceForSnapDuration(f4);
            if (n4 > 0) {
                n2 = Math.round(Math.abs((f2 + f4 * f2) / (float)n4) * 1000.0f) * 4;
            } else {
                n2 = bl ? n7 : n6;
                n2 = (int)(((float)n2 / f3 + 1.0f) * 300.0f);
            }
            return Math.min(n2, 2000);
        }

        private float distanceInfluenceForSnapDuration(float f2) {
            return (float)Math.sin((f2 - 0.5f) * 0.47123894f);
        }

        private void internalPostOnAnimation() {
            RecyclerView.this.removeCallbacks(this);
            ViewCompat.postOnAnimation((View)RecyclerView.this, this);
        }

        public void fling(int n2, int n3) {
            RecyclerView.this.setScrollState(2);
            this.mLastFlingY = 0;
            this.mLastFlingX = 0;
            if (this.mInterpolator != sQuinticInterpolator) {
                this.mInterpolator = sQuinticInterpolator;
                this.mOverScroller = new OverScroller(RecyclerView.this.getContext(), sQuinticInterpolator);
            }
            this.mOverScroller.fling(0, 0, n2, n3, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.postOnAnimation();
        }

        void postOnAnimation() {
            if (this.mEatRunOnAnimationRequest) {
                this.mReSchedulePostAnimationCallback = true;
            } else {
                this.internalPostOnAnimation();
            }
        }

        @Override
        public void run() {
            if (RecyclerView.this.mLayout == null) {
                this.stop();
                return;
            }
            this.mReSchedulePostAnimationCallback = false;
            this.mEatRunOnAnimationRequest = true;
            RecyclerView.this.consumePendingUpdateOperations();
            Object object = this.mOverScroller;
            if (object.computeScrollOffset()) {
                int n2;
                int n3;
                int n4 = object.getCurrX();
                int n5 = object.getCurrY();
                int n6 = n4 - this.mLastFlingX;
                int n7 = n5 - this.mLastFlingY;
                this.mLastFlingX = n4;
                this.mLastFlingY = n5;
                RecyclerView.this.mReusableIntPair[0] = 0;
                RecyclerView.this.mReusableIntPair[1] = 0;
                Object object2 = RecyclerView.this;
                n5 = n6;
                n4 = n7;
                if (((RecyclerView)((Object)object2)).dispatchNestedPreScroll(n6, n7, ((RecyclerView)((Object)object2)).mReusableIntPair, null, 1)) {
                    n5 = n6 - RecyclerView.this.mReusableIntPair[0];
                    n4 = n7 - RecyclerView.this.mReusableIntPair[1];
                }
                if (RecyclerView.this.getOverScrollMode() != 2) {
                    RecyclerView.this.considerReleasingGlowsOnScroll(n5, n4);
                }
                if (RecyclerView.this.mAdapter != null) {
                    RecyclerView.this.mReusableIntPair[0] = 0;
                    RecyclerView.this.mReusableIntPair[1] = 0;
                    object2 = RecyclerView.this;
                    ((RecyclerView)((Object)object2)).scrollStep(n5, n4, ((RecyclerView)((Object)object2)).mReusableIntPair);
                    n3 = RecyclerView.this.mReusableIntPair[0];
                    n2 = RecyclerView.this.mReusableIntPair[1];
                    int n8 = n5 - n3;
                    int n9 = n4 - n2;
                    object2 = RecyclerView.this.mLayout.mSmoothScroller;
                    n5 = n3;
                    n6 = n8;
                    n4 = n2;
                    n7 = n9;
                    if (object2 != null) {
                        n5 = n3;
                        n6 = n8;
                        n4 = n2;
                        n7 = n9;
                        if (!((SmoothScroller)object2).isPendingInitialRun()) {
                            n5 = n3;
                            n6 = n8;
                            n4 = n2;
                            n7 = n9;
                            if (((SmoothScroller)object2).isRunning()) {
                                n4 = RecyclerView.this.mState.getItemCount();
                                if (n4 == 0) {
                                    ((SmoothScroller)object2).stop();
                                    n5 = n3;
                                    n6 = n8;
                                    n4 = n2;
                                    n7 = n9;
                                } else if (((SmoothScroller)object2).getTargetPosition() >= n4) {
                                    ((SmoothScroller)object2).setTargetPosition(n4 - 1);
                                    ((SmoothScroller)object2).onAnimation(n3, n2);
                                    n5 = n3;
                                    n6 = n8;
                                    n4 = n2;
                                    n7 = n9;
                                } else {
                                    ((SmoothScroller)object2).onAnimation(n3, n2);
                                    n5 = n3;
                                    n6 = n8;
                                    n4 = n2;
                                    n7 = n9;
                                }
                            }
                        }
                    }
                } else {
                    n2 = 0;
                    n6 = 0;
                    n7 = n4;
                    n4 = n6;
                    n6 = n5;
                    n5 = n2;
                }
                if (!RecyclerView.this.mItemDecorations.isEmpty()) {
                    RecyclerView.this.invalidate();
                }
                RecyclerView.this.mReusableIntPair[0] = 0;
                RecyclerView.this.mReusableIntPair[1] = 0;
                object2 = RecyclerView.this;
                ((RecyclerView)((Object)object2)).dispatchNestedScroll(n5, n4, n6, n7, null, 1, ((RecyclerView)((Object)object2)).mReusableIntPair);
                n3 = n6 - RecyclerView.this.mReusableIntPair[0];
                n2 = n7 - RecyclerView.this.mReusableIntPair[1];
                if (n5 != 0 || n4 != 0) {
                    RecyclerView.this.dispatchOnScrolled(n5, n4);
                }
                if (!RecyclerView.this.awakenScrollBars()) {
                    RecyclerView.this.invalidate();
                }
                n7 = object.getCurrX() == object.getFinalX() ? 1 : 0;
                n6 = object.getCurrY() == object.getFinalY() ? 1 : 0;
                n7 = !object.isFinished() && (n7 == 0 && n3 == 0 || n6 == 0 && n2 == 0) ? 0 : 1;
                object2 = RecyclerView.this.mLayout.mSmoothScroller;
                n6 = object2 != null && ((SmoothScroller)object2).isPendingInitialRun() ? 1 : 0;
                if (n6 == 0 && n7 != 0) {
                    if (RecyclerView.this.getOverScrollMode() != 2) {
                        n5 = (int)object.getCurrVelocity();
                        n4 = n3 < 0 ? -n5 : (n3 > 0 ? n5 : 0);
                        if (n2 < 0) {
                            n5 = -n5;
                        } else if (n2 <= 0) {
                            n5 = 0;
                        }
                        RecyclerView.this.absorbGlows(n4, n5);
                    }
                    if (ALLOW_THREAD_GAP_WORK) {
                        RecyclerView.this.mPrefetchRegistry.clearPrefetchPositions();
                    }
                } else {
                    this.postOnAnimation();
                    if (RecyclerView.this.mGapWorker != null) {
                        RecyclerView.this.mGapWorker.postFromTraversal(RecyclerView.this, n5, n4);
                    }
                }
            }
            if ((object = RecyclerView.this.mLayout.mSmoothScroller) != null && ((SmoothScroller)object).isPendingInitialRun()) {
                ((SmoothScroller)object).onAnimation(0, 0);
            }
            this.mEatRunOnAnimationRequest = false;
            if (this.mReSchedulePostAnimationCallback) {
                this.internalPostOnAnimation();
            } else {
                RecyclerView.this.setScrollState(0);
                RecyclerView.this.stopNestedScroll(1);
            }
        }

        public void smoothScrollBy(int n2, int n3, int n4, Interpolator interpolator2) {
            int n5 = n4;
            if (n4 == Integer.MIN_VALUE) {
                n5 = this.computeScrollDuration(n2, n3, 0, 0);
            }
            Interpolator interpolator3 = interpolator2;
            if (interpolator2 == null) {
                interpolator3 = sQuinticInterpolator;
            }
            if (this.mInterpolator != interpolator3) {
                this.mInterpolator = interpolator3;
                this.mOverScroller = new OverScroller(RecyclerView.this.getContext(), interpolator3);
            }
            this.mLastFlingY = 0;
            this.mLastFlingX = 0;
            RecyclerView.this.setScrollState(2);
            this.mOverScroller.startScroll(0, 0, n2, n3, n5);
            if (Build.VERSION.SDK_INT < 23) {
                this.mOverScroller.computeScrollOffset();
            }
            this.postOnAnimation();
        }

        public void stop() {
            RecyclerView.this.removeCallbacks(this);
            this.mOverScroller.abortAnimation();
        }
    }

    public static abstract class ViewHolder {
        static final int FLAG_ADAPTER_FULLUPDATE = 1024;
        static final int FLAG_ADAPTER_POSITION_UNKNOWN = 512;
        static final int FLAG_APPEARED_IN_PRE_LAYOUT = 4096;
        static final int FLAG_BOUNCED_FROM_HIDDEN_LIST = 8192;
        static final int FLAG_BOUND = 1;
        static final int FLAG_IGNORE = 128;
        static final int FLAG_INVALID = 4;
        static final int FLAG_MOVED = 2048;
        static final int FLAG_NOT_RECYCLABLE = 16;
        static final int FLAG_REMOVED = 8;
        static final int FLAG_RETURNED_FROM_SCRAP = 32;
        static final int FLAG_TMP_DETACHED = 256;
        static final int FLAG_UPDATE = 2;
        private static final List<Object> FULLUPDATE_PAYLOADS = Collections.emptyList();
        static final int PENDING_ACCESSIBILITY_STATE_NOT_SET = -1;
        public final View itemView;
        int mFlags;
        boolean mInChangeScrap = false;
        private int mIsRecyclableCount = 0;
        long mItemId = -1L;
        int mItemViewType = -1;
        WeakReference<RecyclerView> mNestedRecyclerView;
        int mOldPosition = -1;
        RecyclerView mOwnerRecyclerView;
        List<Object> mPayloads = null;
        int mPendingAccessibilityState = -1;
        int mPosition = -1;
        int mPreLayoutPosition = -1;
        Recycler mScrapContainer = null;
        ViewHolder mShadowedHolder = null;
        ViewHolder mShadowingHolder = null;
        List<Object> mUnmodifiedPayloads = null;
        private int mWasImportantForAccessibilityBeforeHidden = 0;

        public ViewHolder(View view) {
            if (view != null) {
                this.itemView = view;
                return;
            }
            throw new IllegalArgumentException("itemView may not be null");
        }

        private void createPayloadsIfNeeded() {
            if (this.mPayloads == null) {
                this.mPayloads = new ArrayList<Object>();
                this.mUnmodifiedPayloads = Collections.unmodifiableList(this.mPayloads);
            }
        }

        void addChangePayload(Object object) {
            if (object == null) {
                this.addFlags(1024);
            } else if ((0x400 & this.mFlags) == 0) {
                this.createPayloadsIfNeeded();
                this.mPayloads.add(object);
            }
        }

        void addFlags(int n2) {
            this.mFlags = n2 | this.mFlags;
        }

        void clearOldPosition() {
            this.mOldPosition = -1;
            this.mPreLayoutPosition = -1;
        }

        void clearPayload() {
            List<Object> list = this.mPayloads;
            if (list != null) {
                list.clear();
            }
            this.mFlags &= 0xFFFFFBFF;
        }

        void clearReturnedFromScrapFlag() {
            this.mFlags &= 0xFFFFFFDF;
        }

        void clearTmpDetachFlag() {
            this.mFlags &= 0xFFFFFEFF;
        }

        boolean doesTransientStatePreventRecycling() {
            boolean bl = (this.mFlags & 0x10) == 0 && ViewCompat.hasTransientState(this.itemView);
            return bl;
        }

        void flagRemovedAndOffsetPosition(int n2, int n3, boolean bl) {
            this.addFlags(8);
            this.offsetPosition(n3, bl);
            this.mPosition = n2;
        }

        public final int getAdapterPosition() {
            RecyclerView recyclerView = this.mOwnerRecyclerView;
            if (recyclerView == null) {
                return -1;
            }
            return recyclerView.getAdapterPositionFor(this);
        }

        public final long getItemId() {
            return this.mItemId;
        }

        public final int getItemViewType() {
            return this.mItemViewType;
        }

        public final int getLayoutPosition() {
            int n2;
            int n3 = n2 = this.mPreLayoutPosition;
            if (n2 == -1) {
                n3 = this.mPosition;
            }
            return n3;
        }

        public final int getOldPosition() {
            return this.mOldPosition;
        }

        @Deprecated
        public final int getPosition() {
            int n2;
            int n3 = n2 = this.mPreLayoutPosition;
            if (n2 == -1) {
                n3 = this.mPosition;
            }
            return n3;
        }

        List<Object> getUnmodifiedPayloads() {
            if ((this.mFlags & 0x400) == 0) {
                List<Object> list = this.mPayloads;
                if (list != null && list.size() != 0) {
                    return this.mUnmodifiedPayloads;
                }
                return FULLUPDATE_PAYLOADS;
            }
            return FULLUPDATE_PAYLOADS;
        }

        boolean hasAnyOfTheFlags(int n2) {
            boolean bl = (n2 & this.mFlags) != 0;
            return bl;
        }

        boolean isAdapterPositionUnknown() {
            boolean bl = (this.mFlags & 0x200) != 0 || this.isInvalid();
            return bl;
        }

        boolean isAttachedToTransitionOverlay() {
            boolean bl = this.itemView.getParent() != null && this.itemView.getParent() != this.mOwnerRecyclerView;
            return bl;
        }

        boolean isBound() {
            int n2 = this.mFlags;
            boolean bl = true;
            if ((n2 & 1) == 0) {
                bl = false;
            }
            return bl;
        }

        boolean isInvalid() {
            boolean bl = (this.mFlags & 4) != 0;
            return bl;
        }

        public final boolean isRecyclable() {
            boolean bl = (this.mFlags & 0x10) == 0 && !ViewCompat.hasTransientState(this.itemView);
            return bl;
        }

        boolean isRemoved() {
            boolean bl = (this.mFlags & 8) != 0;
            return bl;
        }

        boolean isScrap() {
            boolean bl = this.mScrapContainer != null;
            return bl;
        }

        boolean isTmpDetached() {
            boolean bl = (this.mFlags & 0x100) != 0;
            return bl;
        }

        boolean isUpdated() {
            boolean bl = (this.mFlags & 2) != 0;
            return bl;
        }

        boolean needsUpdate() {
            boolean bl = (this.mFlags & 2) != 0;
            return bl;
        }

        void offsetPosition(int n2, boolean bl) {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
            if (this.mPreLayoutPosition == -1) {
                this.mPreLayoutPosition = this.mPosition;
            }
            if (bl) {
                this.mPreLayoutPosition += n2;
            }
            this.mPosition += n2;
            if (this.itemView.getLayoutParams() != null) {
                ((LayoutParams)this.itemView.getLayoutParams()).mInsetsDirty = true;
            }
        }

        void onEnteredHiddenState(RecyclerView recyclerView) {
            int n2 = this.mPendingAccessibilityState;
            this.mWasImportantForAccessibilityBeforeHidden = n2 != -1 ? n2 : ViewCompat.getImportantForAccessibility(this.itemView);
            recyclerView.setChildImportantForAccessibilityInternal(this, 4);
        }

        void onLeftHiddenState(RecyclerView recyclerView) {
            recyclerView.setChildImportantForAccessibilityInternal(this, this.mWasImportantForAccessibilityBeforeHidden);
            this.mWasImportantForAccessibilityBeforeHidden = 0;
        }

        void resetInternal() {
            this.mFlags = 0;
            this.mPosition = -1;
            this.mOldPosition = -1;
            this.mItemId = -1L;
            this.mPreLayoutPosition = -1;
            this.mIsRecyclableCount = 0;
            this.mShadowedHolder = null;
            this.mShadowingHolder = null;
            this.clearPayload();
            this.mWasImportantForAccessibilityBeforeHidden = 0;
            this.mPendingAccessibilityState = -1;
            RecyclerView.clearNestedRecyclerViewIfNotNested(this);
        }

        void saveOldPosition() {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
        }

        void setFlags(int n2, int n3) {
            this.mFlags = n2 & n3 | this.mFlags & ~n3;
        }

        public final void setIsRecyclable(boolean bl) {
            int n2 = this.mIsRecyclableCount;
            n2 = bl ? --n2 : ++n2;
            n2 = this.mIsRecyclableCount = n2;
            if (n2 < 0) {
                this.mIsRecyclableCount = 0;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("isRecyclable decremented below 0: unmatched pair of setIsRecyable() calls for ");
                stringBuilder.append(this);
                Log.e((String)"View", (String)stringBuilder.toString());
            } else if (!bl && n2 == 1) {
                this.mFlags |= 0x10;
            } else if (bl && this.mIsRecyclableCount == 0) {
                this.mFlags &= 0xFFFFFFEF;
            }
        }

        void setScrapContainer(Recycler recycler, boolean bl) {
            this.mScrapContainer = recycler;
            this.mInChangeScrap = bl;
        }

        boolean shouldBeKeptAsChild() {
            boolean bl = (this.mFlags & 0x10) != 0;
            return bl;
        }

        boolean shouldIgnore() {
            boolean bl = (this.mFlags & 0x80) != 0;
            return bl;
        }

        void stopIgnoring() {
            this.mFlags &= 0xFFFFFF7F;
        }

        public String toString() {
            CharSequence charSequence = this.getClass().isAnonymousClass() ? "ViewHolder" : this.getClass().getSimpleName();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence);
            stringBuilder.append("{");
            stringBuilder.append(Integer.toHexString(this.hashCode()));
            stringBuilder.append(" position=");
            stringBuilder.append(this.mPosition);
            stringBuilder.append(" id=");
            stringBuilder.append(this.mItemId);
            stringBuilder.append(", oldPos=");
            stringBuilder.append(this.mOldPosition);
            stringBuilder.append(", pLpos:");
            stringBuilder.append(this.mPreLayoutPosition);
            stringBuilder = new StringBuilder(stringBuilder.toString());
            if (this.isScrap()) {
                stringBuilder.append(" scrap ");
                charSequence = this.mInChangeScrap ? "[changeScrap]" : "[attachedScrap]";
                stringBuilder.append((String)charSequence);
            }
            if (this.isInvalid()) {
                stringBuilder.append(" invalid");
            }
            if (!this.isBound()) {
                stringBuilder.append(" unbound");
            }
            if (this.needsUpdate()) {
                stringBuilder.append(" update");
            }
            if (this.isRemoved()) {
                stringBuilder.append(" removed");
            }
            if (this.shouldIgnore()) {
                stringBuilder.append(" ignored");
            }
            if (this.isTmpDetached()) {
                stringBuilder.append(" tmpDetached");
            }
            if (!this.isRecyclable()) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(" not recyclable(");
                ((StringBuilder)charSequence).append(this.mIsRecyclableCount);
                ((StringBuilder)charSequence).append(")");
                stringBuilder.append(((StringBuilder)charSequence).toString());
            }
            if (this.isAdapterPositionUnknown()) {
                stringBuilder.append(" undefined adapter position");
            }
            if (this.itemView.getParent() == null) {
                stringBuilder.append(" no parent");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        void unScrap() {
            this.mScrapContainer.unscrapView(this);
        }

        boolean wasReturnedFromScrap() {
            boolean bl = (this.mFlags & 0x20) != 0;
            return bl;
        }
    }
}

