/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.graphics.PointF;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;

public class PagerSnapHelper
extends SnapHelper {
    private static final int MAX_SCROLL_ON_FLING_DURATION = 100;
    private OrientationHelper mHorizontalHelper;
    private OrientationHelper mVerticalHelper;

    private int distanceToCenter(RecyclerView.LayoutManager layoutManager, View view, OrientationHelper orientationHelper) {
        return orientationHelper.getDecoratedStart(view) + orientationHelper.getDecoratedMeasurement(view) / 2 - (orientationHelper.getStartAfterPadding() + orientationHelper.getTotalSpace() / 2);
    }

    private View findCenterView(RecyclerView.LayoutManager layoutManager, OrientationHelper orientationHelper) {
        int n2 = layoutManager.getChildCount();
        View view = null;
        if (n2 == 0) {
            return null;
        }
        int n3 = orientationHelper.getStartAfterPadding();
        int n4 = orientationHelper.getTotalSpace() / 2;
        int n5 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            View view2 = layoutManager.getChildAt(i2);
            int n6 = Math.abs(orientationHelper.getDecoratedStart(view2) + orientationHelper.getDecoratedMeasurement(view2) / 2 - (n3 + n4));
            int n7 = n5;
            if (n6 < n5) {
                view = view2;
                n7 = n6;
            }
            n5 = n7;
        }
        return view;
    }

    private OrientationHelper getHorizontalHelper(RecyclerView.LayoutManager layoutManager) {
        OrientationHelper orientationHelper = this.mHorizontalHelper;
        if (orientationHelper == null || orientationHelper.mLayoutManager != layoutManager) {
            this.mHorizontalHelper = OrientationHelper.createHorizontalHelper(layoutManager);
        }
        return this.mHorizontalHelper;
    }

    private OrientationHelper getOrientationHelper(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager.canScrollVertically()) {
            return this.getVerticalHelper(layoutManager);
        }
        if (layoutManager.canScrollHorizontally()) {
            return this.getHorizontalHelper(layoutManager);
        }
        return null;
    }

    private OrientationHelper getVerticalHelper(RecyclerView.LayoutManager layoutManager) {
        OrientationHelper orientationHelper = this.mVerticalHelper;
        if (orientationHelper == null || orientationHelper.mLayoutManager != layoutManager) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper(layoutManager);
        }
        return this.mVerticalHelper;
    }

    private boolean isForwardFling(RecyclerView.LayoutManager layoutManager, int n2, int n3) {
        boolean bl = layoutManager.canScrollHorizontally();
        boolean bl2 = true;
        boolean bl3 = true;
        if (bl) {
            if (n2 <= 0) {
                bl3 = false;
            }
            return bl3;
        }
        bl3 = n3 > 0 ? bl2 : false;
        return bl3;
    }

    private boolean isReverseLayout(RecyclerView.LayoutManager object) {
        int n2 = ((RecyclerView.LayoutManager)object).getItemCount();
        if (object instanceof RecyclerView.SmoothScroller.ScrollVectorProvider) {
            object = (RecyclerView.SmoothScroller.ScrollVectorProvider)object;
            boolean bl = true;
            if ((object = object.computeScrollVectorForPosition(n2 - 1)) != null) {
                boolean bl2 = bl;
                if (!(((PointF)object).x < 0.0f)) {
                    bl2 = ((PointF)object).y < 0.0f ? bl : false;
                }
                return bl2;
            }
        }
        return false;
    }

    public int[] calculateDistanceToFinalSnap(RecyclerView.LayoutManager layoutManager, View view) {
        int[] nArray = new int[]{layoutManager.canScrollHorizontally() ? this.distanceToCenter(layoutManager, view, this.getHorizontalHelper(layoutManager)) : 0, layoutManager.canScrollVertically() ? this.distanceToCenter(layoutManager, view, this.getVerticalHelper(layoutManager)) : 0};
        return nArray;
    }

    protected LinearSmoothScroller createSnapScroller(RecyclerView.LayoutManager layoutManager) {
        if (!(layoutManager instanceof RecyclerView.SmoothScroller.ScrollVectorProvider)) {
            return null;
        }
        return new LinearSmoothScroller(this.mRecyclerView.getContext()){

            protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
                return 100.0f / (float)displayMetrics.densityDpi;
            }

            protected int calculateTimeForScrolling(int n2) {
                return Math.min(100, super.calculateTimeForScrolling(n2));
            }

            protected void onTargetFound(View object, RecyclerView.State object2, RecyclerView.SmoothScroller.Action action) {
                object2 = PagerSnapHelper.this;
                object = ((PagerSnapHelper)((Object)object2)).calculateDistanceToFinalSnap(((PagerSnapHelper)((Object)object2)).mRecyclerView.getLayoutManager(), (View)object);
                View view = object[0];
                View view2 = object[1];
                int n2 = this.calculateTimeForDeceleration(Math.max(Math.abs((int)view), Math.abs((int)view2)));
                if (n2 > 0) {
                    action.update((int)view, (int)view2, n2, (Interpolator)this.mDecelerateInterpolator);
                }
            }
        };
    }

    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager.canScrollVertically()) {
            return this.findCenterView(layoutManager, this.getVerticalHelper(layoutManager));
        }
        if (layoutManager.canScrollHorizontally()) {
            return this.findCenterView(layoutManager, this.getHorizontalHelper(layoutManager));
        }
        return null;
    }

    public int findTargetSnapPosition(RecyclerView.LayoutManager layoutManager, int n2, int n3) {
        int n4 = layoutManager.getItemCount();
        if (n4 == 0) {
            return -1;
        }
        OrientationHelper orientationHelper = this.getOrientationHelper(layoutManager);
        if (orientationHelper == null) {
            return -1;
        }
        int n5 = layoutManager.getChildCount();
        View view = null;
        View view2 = null;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n8;
            View view3;
            View view4 = layoutManager.getChildAt(i2);
            if (view4 == null) {
                view3 = view;
                n8 = n7;
            } else {
                int n9 = this.distanceToCenter(layoutManager, view4, orientationHelper);
                View view5 = view2;
                int n10 = n6;
                if (n9 <= 0) {
                    view5 = view2;
                    n10 = n6;
                    if (n9 > n6) {
                        view5 = view4;
                        n10 = n9;
                    }
                }
                view2 = view5;
                n6 = n10;
                view3 = view;
                n8 = n7;
                if (n9 >= 0) {
                    view2 = view5;
                    n6 = n10;
                    view3 = view;
                    n8 = n7;
                    if (n9 < n7) {
                        n8 = n9;
                        view3 = view4;
                        n6 = n10;
                        view2 = view5;
                    }
                }
            }
            view = view3;
            n7 = n8;
        }
        boolean bl = this.isForwardFling(layoutManager, n2, n3);
        if (bl && view != null) {
            return layoutManager.getPosition(view);
        }
        if (!bl && view2 != null) {
            return layoutManager.getPosition(view2);
        }
        if (!bl) {
            view2 = view;
        }
        if (view2 == null) {
            return -1;
        }
        n3 = layoutManager.getPosition(view2);
        n2 = this.isReverseLayout(layoutManager) == bl ? -1 : 1;
        if ((n2 = n3 + n2) >= 0 && n2 < n4) {
            return n2;
        }
        return -1;
    }
}

