/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.content.Context;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.ScrollbarHelper;
import java.util.List;

public class LinearLayoutManager
extends RecyclerView.LayoutManager
implements ItemTouchHelper.ViewDropHandler,
RecyclerView.SmoothScroller.ScrollVectorProvider {
    static final boolean DEBUG = false;
    public static final int HORIZONTAL = 0;
    public static final int INVALID_OFFSET = Integer.MIN_VALUE;
    private static final float MAX_SCROLL_FACTOR = 0.33333334f;
    private static final String TAG = "LinearLayoutManager";
    public static final int VERTICAL = 1;
    final AnchorInfo mAnchorInfo;
    private int mInitialPrefetchItemCount = 2;
    private boolean mLastStackFromEnd;
    private final LayoutChunkResult mLayoutChunkResult;
    private LayoutState mLayoutState;
    int mOrientation = 1;
    OrientationHelper mOrientationHelper;
    SavedState mPendingSavedState = null;
    int mPendingScrollPosition = -1;
    int mPendingScrollPositionOffset = Integer.MIN_VALUE;
    private boolean mRecycleChildrenOnDetach;
    private int[] mReusableIntPair;
    private boolean mReverseLayout = false;
    boolean mShouldReverseLayout = false;
    private boolean mSmoothScrollbarEnabled = true;
    private boolean mStackFromEnd = false;

    public LinearLayoutManager(Context context) {
        this(context, 1, false);
    }

    public LinearLayoutManager(Context context, int n2, boolean bl) {
        this.mAnchorInfo = new AnchorInfo();
        this.mLayoutChunkResult = new LayoutChunkResult();
        this.mReusableIntPair = new int[2];
        this.setOrientation(n2);
        this.setReverseLayout(bl);
    }

    public LinearLayoutManager(Context object, AttributeSet attributeSet, int n2, int n3) {
        this.mAnchorInfo = new AnchorInfo();
        this.mLayoutChunkResult = new LayoutChunkResult();
        this.mReusableIntPair = new int[2];
        object = LinearLayoutManager.getProperties(object, attributeSet, n2, n3);
        this.setOrientation(object.orientation);
        this.setReverseLayout(object.reverseLayout);
        this.setStackFromEnd(object.stackFromEnd);
    }

    private int computeScrollExtent(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        this.ensureLayoutState();
        return ScrollbarHelper.computeScrollExtent((RecyclerView.State)state, (OrientationHelper)this.mOrientationHelper, (View)this.findFirstVisibleChildClosestToStart(this.mSmoothScrollbarEnabled ^ true, true), (View)this.findFirstVisibleChildClosestToEnd(this.mSmoothScrollbarEnabled ^ true, true), (RecyclerView.LayoutManager)this, (boolean)this.mSmoothScrollbarEnabled);
    }

    private int computeScrollOffset(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        this.ensureLayoutState();
        return ScrollbarHelper.computeScrollOffset((RecyclerView.State)state, (OrientationHelper)this.mOrientationHelper, (View)this.findFirstVisibleChildClosestToStart(this.mSmoothScrollbarEnabled ^ true, true), (View)this.findFirstVisibleChildClosestToEnd(this.mSmoothScrollbarEnabled ^ true, true), (RecyclerView.LayoutManager)this, (boolean)this.mSmoothScrollbarEnabled, (boolean)this.mShouldReverseLayout);
    }

    private int computeScrollRange(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        this.ensureLayoutState();
        return ScrollbarHelper.computeScrollRange((RecyclerView.State)state, (OrientationHelper)this.mOrientationHelper, (View)this.findFirstVisibleChildClosestToStart(this.mSmoothScrollbarEnabled ^ true, true), (View)this.findFirstVisibleChildClosestToEnd(this.mSmoothScrollbarEnabled ^ true, true), (RecyclerView.LayoutManager)this, (boolean)this.mSmoothScrollbarEnabled);
    }

    private View findFirstPartiallyOrCompletelyInvisibleChild() {
        return this.findOnePartiallyOrCompletelyInvisibleChild(0, this.getChildCount());
    }

    private View findFirstReferenceChild(RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.findReferenceChild(recycler, state, 0, this.getChildCount(), state.getItemCount());
    }

    private View findLastPartiallyOrCompletelyInvisibleChild() {
        return this.findOnePartiallyOrCompletelyInvisibleChild(this.getChildCount() - 1, -1);
    }

    private View findLastReferenceChild(RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.findReferenceChild(recycler, state, this.getChildCount() - 1, -1, state.getItemCount());
    }

    private View findPartiallyOrCompletelyInvisibleChildClosestToEnd() {
        View view = this.mShouldReverseLayout ? this.findFirstPartiallyOrCompletelyInvisibleChild() : this.findLastPartiallyOrCompletelyInvisibleChild();
        return view;
    }

    private View findPartiallyOrCompletelyInvisibleChildClosestToStart() {
        View view = this.mShouldReverseLayout ? this.findLastPartiallyOrCompletelyInvisibleChild() : this.findFirstPartiallyOrCompletelyInvisibleChild();
        return view;
    }

    private View findReferenceChildClosestToEnd(RecyclerView.Recycler recycler, RecyclerView.State state) {
        recycler = this.mShouldReverseLayout ? this.findFirstReferenceChild(recycler, state) : this.findLastReferenceChild(recycler, state);
        return recycler;
    }

    private View findReferenceChildClosestToStart(RecyclerView.Recycler recycler, RecyclerView.State state) {
        recycler = this.mShouldReverseLayout ? this.findLastReferenceChild(recycler, state) : this.findFirstReferenceChild(recycler, state);
        return recycler;
    }

    private int fixLayoutEndGap(int n2, RecyclerView.Recycler recycler, RecyclerView.State state, boolean bl) {
        int n3 = this.mOrientationHelper.getEndAfterPadding() - n2;
        if (n3 > 0) {
            n3 = -this.scrollBy(-n3, recycler, state);
            if (bl && (n2 = this.mOrientationHelper.getEndAfterPadding() - (n2 + n3)) > 0) {
                this.mOrientationHelper.offsetChildren(n2);
                return n2 + n3;
            }
            return n3;
        }
        return 0;
    }

    private int fixLayoutStartGap(int n2, RecyclerView.Recycler recycler, RecyclerView.State state, boolean bl) {
        int n3 = n2 - this.mOrientationHelper.getStartAfterPadding();
        if (n3 > 0) {
            int n4;
            n3 = n4 = -this.scrollBy(n3, recycler, state);
            if (bl) {
                n2 = n2 + n4 - this.mOrientationHelper.getStartAfterPadding();
                n3 = n4;
                if (n2 > 0) {
                    this.mOrientationHelper.offsetChildren(-n2);
                    n3 = n4 - n2;
                }
            }
            return n3;
        }
        return 0;
    }

    private View getChildClosestToEnd() {
        int n2 = this.mShouldReverseLayout ? 0 : this.getChildCount() - 1;
        return this.getChildAt(n2);
    }

    private View getChildClosestToStart() {
        int n2 = this.mShouldReverseLayout ? this.getChildCount() - 1 : 0;
        return this.getChildAt(n2);
    }

    private void layoutForPredictiveAnimations(RecyclerView.Recycler recycler, RecyclerView.State state, int n2, int n3) {
        if (state.willRunPredictiveAnimations() && this.getChildCount() != 0 && !state.isPreLayout() && this.supportsPredictiveItemAnimations()) {
            Object object;
            List<RecyclerView.ViewHolder> list = recycler.getScrapList();
            int n4 = list.size();
            int n5 = this.getPosition(this.getChildAt(0));
            int n6 = 0;
            int n7 = 0;
            for (int i2 = 0; i2 < n4; ++i2) {
                object = list.get(i2);
                if (((RecyclerView.ViewHolder)object).isRemoved()) continue;
                int n8 = ((RecyclerView.ViewHolder)object).getLayoutPosition();
                int n9 = 1;
                boolean bl = n8 < n5;
                if (bl != this.mShouldReverseLayout) {
                    n9 = -1;
                }
                if (n9 == -1) {
                    n6 += this.mOrientationHelper.getDecoratedMeasurement(((RecyclerView.ViewHolder)object).itemView);
                    continue;
                }
                n7 += this.mOrientationHelper.getDecoratedMeasurement(((RecyclerView.ViewHolder)object).itemView);
            }
            this.mLayoutState.mScrapList = list;
            if (n6 > 0) {
                this.updateLayoutStateToFillStart(this.getPosition(this.getChildClosestToStart()), n2);
                object = this.mLayoutState;
                ((LayoutState)object).mExtraFillSpace = n6;
                ((LayoutState)object).mAvailable = 0;
                ((LayoutState)object).assignPositionFromScrapList();
                this.fill(recycler, this.mLayoutState, state, false);
            }
            if (n7 > 0) {
                this.updateLayoutStateToFillEnd(this.getPosition(this.getChildClosestToEnd()), n3);
                object = this.mLayoutState;
                ((LayoutState)object).mExtraFillSpace = n7;
                ((LayoutState)object).mAvailable = 0;
                ((LayoutState)object).assignPositionFromScrapList();
                this.fill(recycler, this.mLayoutState, state, false);
            }
            this.mLayoutState.mScrapList = null;
        }
    }

    private void logChildren() {
        Log.d((String)TAG, (String)"internal representation of views on the screen");
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            View view = this.getChildAt(i2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("item ");
            stringBuilder.append(this.getPosition(view));
            stringBuilder.append(", coord:");
            stringBuilder.append(this.mOrientationHelper.getDecoratedStart(view));
            Log.d((String)TAG, (String)stringBuilder.toString());
        }
        Log.d((String)TAG, (String)"==============");
    }

    private void recycleByLayoutState(RecyclerView.Recycler recycler, LayoutState layoutState) {
        if (layoutState.mRecycle && !layoutState.mInfinite) {
            int n2 = layoutState.mScrollingOffset;
            int n3 = layoutState.mNoRecycleSpace;
            if (layoutState.mLayoutDirection == -1) {
                this.recycleViewsFromEnd(recycler, n2, n3);
            } else {
                this.recycleViewsFromStart(recycler, n2, n3);
            }
        }
    }

    private void recycleChildren(RecyclerView.Recycler recycler, int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        if (n3 > n2) {
            --n3;
            while (n3 >= n2) {
                this.removeAndRecycleViewAt(n3, recycler);
                --n3;
            }
        } else {
            for (int i2 = n2; i2 > n3; --i2) {
                this.removeAndRecycleViewAt(i2, recycler);
            }
        }
    }

    private void recycleViewsFromEnd(RecyclerView.Recycler recycler, int n2, int n3) {
        int n4 = this.getChildCount();
        if (n2 < 0) {
            return;
        }
        int n5 = this.mOrientationHelper.getEnd() - n2 + n3;
        if (this.mShouldReverseLayout) {
            for (n2 = 0; n2 < n4; ++n2) {
                View view = this.getChildAt(n2);
                if (this.mOrientationHelper.getDecoratedStart(view) >= n5 && this.mOrientationHelper.getTransformedStartWithDecoration(view) >= n5) {
                    continue;
                }
                this.recycleChildren(recycler, 0, n2);
                return;
            }
        } else {
            for (n2 = n3 = n4 - 1; n2 >= 0; --n2) {
                View view = this.getChildAt(n2);
                if (this.mOrientationHelper.getDecoratedStart(view) >= n5 && this.mOrientationHelper.getTransformedStartWithDecoration(view) >= n5) {
                    continue;
                }
                this.recycleChildren(recycler, n3, n2);
                break;
            }
        }
    }

    private void recycleViewsFromStart(RecyclerView.Recycler recycler, int n2, int n3) {
        if (n2 < 0) {
            return;
        }
        int n4 = n2 - n3;
        n3 = this.getChildCount();
        if (this.mShouldReverseLayout) {
            for (n2 = --n3; n2 >= 0; --n2) {
                View view = this.getChildAt(n2);
                if (this.mOrientationHelper.getDecoratedEnd(view) <= n4 && this.mOrientationHelper.getTransformedEndWithDecoration(view) <= n4) {
                    continue;
                }
                this.recycleChildren(recycler, n3, n2);
                return;
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                View view = this.getChildAt(n2);
                if (this.mOrientationHelper.getDecoratedEnd(view) <= n4 && this.mOrientationHelper.getTransformedEndWithDecoration(view) <= n4) {
                    continue;
                }
                this.recycleChildren(recycler, 0, n2);
                break;
            }
        }
    }

    private void resolveShouldLayoutReverse() {
        this.mShouldReverseLayout = this.mOrientation != 1 && this.isLayoutRTL() ? this.mReverseLayout ^ true : this.mReverseLayout;
    }

    private boolean updateAnchorFromChildren(RecyclerView.Recycler recycler, RecyclerView.State state, AnchorInfo anchorInfo) {
        int n2 = this.getChildCount();
        int n3 = 0;
        if (n2 == 0) {
            return false;
        }
        View view = this.getFocusedChild();
        if (view != null && anchorInfo.isViewValidAsAnchor(view, state)) {
            anchorInfo.assignFromViewAndKeepVisibleRect(view, this.getPosition(view));
            return true;
        }
        if (this.mLastStackFromEnd != this.mStackFromEnd) {
            return false;
        }
        recycler = anchorInfo.mLayoutFromEnd ? this.findReferenceChildClosestToEnd(recycler, state) : this.findReferenceChildClosestToStart(recycler, state);
        if (recycler != null) {
            anchorInfo.assignFromView((View)recycler, this.getPosition((View)recycler));
            if (!state.isPreLayout() && this.supportsPredictiveItemAnimations()) {
                if (this.mOrientationHelper.getDecoratedStart((View)recycler) >= this.mOrientationHelper.getEndAfterPadding() || this.mOrientationHelper.getDecoratedEnd((View)recycler) < this.mOrientationHelper.getStartAfterPadding()) {
                    n3 = 1;
                }
                if (n3 != 0) {
                    n3 = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() : this.mOrientationHelper.getStartAfterPadding();
                    anchorInfo.mCoordinate = n3;
                }
            }
            return true;
        }
        return false;
    }

    private boolean updateAnchorFromPendingData(RecyclerView.State object, AnchorInfo anchorInfo) {
        int n2;
        boolean bl = ((RecyclerView.State)object).isPreLayout();
        boolean bl2 = false;
        if (!bl && (n2 = this.mPendingScrollPosition) != -1) {
            if (n2 >= 0 && n2 < ((RecyclerView.State)object).getItemCount()) {
                anchorInfo.mPosition = this.mPendingScrollPosition;
                object = this.mPendingSavedState;
                if (object != null && ((SavedState)object).hasValidAnchor()) {
                    anchorInfo.mLayoutFromEnd = this.mPendingSavedState.mAnchorLayoutFromEnd;
                    anchorInfo.mCoordinate = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() - this.mPendingSavedState.mAnchorOffset : this.mOrientationHelper.getStartAfterPadding() + this.mPendingSavedState.mAnchorOffset;
                    return true;
                }
                if (this.mPendingScrollPositionOffset == Integer.MIN_VALUE) {
                    object = this.findViewByPosition(this.mPendingScrollPosition);
                    if (object != null) {
                        if (this.mOrientationHelper.getDecoratedMeasurement((View)object) > this.mOrientationHelper.getTotalSpace()) {
                            anchorInfo.assignCoordinateFromPadding();
                            return true;
                        }
                        if (this.mOrientationHelper.getDecoratedStart((View)object) - this.mOrientationHelper.getStartAfterPadding() < 0) {
                            anchorInfo.mCoordinate = this.mOrientationHelper.getStartAfterPadding();
                            anchorInfo.mLayoutFromEnd = false;
                            return true;
                        }
                        if (this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd((View)object) < 0) {
                            anchorInfo.mCoordinate = this.mOrientationHelper.getEndAfterPadding();
                            anchorInfo.mLayoutFromEnd = true;
                            return true;
                        }
                        n2 = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getDecoratedEnd((View)object) + this.mOrientationHelper.getTotalSpaceChange() : this.mOrientationHelper.getDecoratedStart((View)object);
                        anchorInfo.mCoordinate = n2;
                    } else {
                        if (this.getChildCount() > 0) {
                            n2 = this.getPosition(this.getChildAt(0));
                            bl = this.mPendingScrollPosition < n2;
                            if (bl == this.mShouldReverseLayout) {
                                bl2 = true;
                            }
                            anchorInfo.mLayoutFromEnd = bl2;
                        }
                        anchorInfo.assignCoordinateFromPadding();
                    }
                    return true;
                }
                anchorInfo.mLayoutFromEnd = bl = this.mShouldReverseLayout;
                anchorInfo.mCoordinate = bl ? this.mOrientationHelper.getEndAfterPadding() - this.mPendingScrollPositionOffset : this.mOrientationHelper.getStartAfterPadding() + this.mPendingScrollPositionOffset;
                return true;
            }
            this.mPendingScrollPosition = -1;
            this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        }
        return false;
    }

    private void updateAnchorInfoForLayout(RecyclerView.Recycler recycler, RecyclerView.State state, AnchorInfo anchorInfo) {
        if (this.updateAnchorFromPendingData(state, anchorInfo)) {
            return;
        }
        if (this.updateAnchorFromChildren(recycler, state, anchorInfo)) {
            return;
        }
        anchorInfo.assignCoordinateFromPadding();
        int n2 = this.mStackFromEnd ? state.getItemCount() - 1 : 0;
        anchorInfo.mPosition = n2;
    }

    private void updateLayoutState(int n2, int n3, boolean bl, RecyclerView.State object) {
        this.mLayoutState.mInfinite = this.resolveIsInfinite();
        this.mLayoutState.mLayoutDirection = n2;
        Object object2 = this.mReusableIntPair;
        boolean bl2 = false;
        object2[0] = 0;
        object2[1] = 0;
        this.calculateExtraLayoutSpace((RecyclerView.State)object, (int[])object2);
        int n4 = Math.max(0, this.mReusableIntPair[0]);
        int n5 = Math.max(0, this.mReusableIntPair[1]);
        if (n2 == 1) {
            bl2 = true;
        }
        object = this.mLayoutState;
        n2 = bl2 ? n5 : n4;
        ((LayoutState)object).mExtraFillSpace = n2;
        object = this.mLayoutState;
        if (bl2) {
            n5 = n4;
        }
        ((LayoutState)object).mNoRecycleSpace = n5;
        n2 = -1;
        if (bl2) {
            object = this.mLayoutState;
            ((LayoutState)object).mExtraFillSpace += this.mOrientationHelper.getEndPadding();
            object2 = this.getChildClosestToEnd();
            object = this.mLayoutState;
            if (!this.mShouldReverseLayout) {
                n2 = 1;
            }
            ((LayoutState)object).mItemDirection = n2;
            this.mLayoutState.mCurrentPosition = this.getPosition((View)object2) + this.mLayoutState.mItemDirection;
            this.mLayoutState.mOffset = this.mOrientationHelper.getDecoratedEnd((View)object2);
            n2 = this.mOrientationHelper.getDecoratedEnd((View)object2) - this.mOrientationHelper.getEndAfterPadding();
        } else {
            object = this.getChildClosestToStart();
            object2 = this.mLayoutState;
            object2.mExtraFillSpace += this.mOrientationHelper.getStartAfterPadding();
            object2 = this.mLayoutState;
            if (this.mShouldReverseLayout) {
                n2 = 1;
            }
            object2.mItemDirection = n2;
            this.mLayoutState.mCurrentPosition = this.getPosition((View)object) + this.mLayoutState.mItemDirection;
            this.mLayoutState.mOffset = this.mOrientationHelper.getDecoratedStart((View)object);
            n2 = -this.mOrientationHelper.getDecoratedStart((View)object) + this.mOrientationHelper.getStartAfterPadding();
        }
        object = this.mLayoutState;
        ((LayoutState)object).mAvailable = n3;
        if (bl) {
            ((LayoutState)object).mAvailable -= n2;
        }
        this.mLayoutState.mScrollingOffset = n2;
    }

    private void updateLayoutStateToFillEnd(int n2, int n3) {
        this.mLayoutState.mAvailable = this.mOrientationHelper.getEndAfterPadding() - n3;
        LayoutState layoutState = this.mLayoutState;
        int n4 = this.mShouldReverseLayout ? -1 : 1;
        layoutState.mItemDirection = n4;
        layoutState = this.mLayoutState;
        layoutState.mCurrentPosition = n2;
        layoutState.mLayoutDirection = 1;
        layoutState.mOffset = n3;
        layoutState.mScrollingOffset = Integer.MIN_VALUE;
    }

    private void updateLayoutStateToFillEnd(AnchorInfo anchorInfo) {
        this.updateLayoutStateToFillEnd(anchorInfo.mPosition, anchorInfo.mCoordinate);
    }

    private void updateLayoutStateToFillStart(int n2, int n3) {
        this.mLayoutState.mAvailable = n3 - this.mOrientationHelper.getStartAfterPadding();
        LayoutState layoutState = this.mLayoutState;
        layoutState.mCurrentPosition = n2;
        n2 = this.mShouldReverseLayout ? 1 : -1;
        layoutState.mItemDirection = n2;
        layoutState = this.mLayoutState;
        layoutState.mLayoutDirection = -1;
        layoutState.mOffset = n3;
        layoutState.mScrollingOffset = Integer.MIN_VALUE;
    }

    private void updateLayoutStateToFillStart(AnchorInfo anchorInfo) {
        this.updateLayoutStateToFillStart(anchorInfo.mPosition, anchorInfo.mCoordinate);
    }

    @Override
    public void assertNotInLayoutOrScroll(String string2) {
        if (this.mPendingSavedState == null) {
            super.assertNotInLayoutOrScroll(string2);
        }
    }

    protected void calculateExtraLayoutSpace(RecyclerView.State state, int[] nArray) {
        int n2;
        int n3;
        int n4 = this.getExtraLayoutSpace(state);
        if (this.mLayoutState.mLayoutDirection == -1) {
            n3 = 0;
            n2 = n4;
        } else {
            n2 = 0;
            n3 = n4;
        }
        nArray[0] = n2;
        nArray[1] = n3;
    }

    @Override
    public boolean canScrollHorizontally() {
        boolean bl = this.mOrientation == 0;
        return bl;
    }

    @Override
    public boolean canScrollVertically() {
        int n2 = this.mOrientation;
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void collectAdjacentPrefetchPositions(int n2, int n3, RecyclerView.State state, RecyclerView.LayoutManager.LayoutPrefetchRegistry layoutPrefetchRegistry) {
        if (this.mOrientation != 0) {
            n2 = n3;
        }
        if (this.getChildCount() != 0 && n2 != 0) {
            this.ensureLayoutState();
            n3 = n2 > 0 ? 1 : -1;
            this.updateLayoutState(n3, Math.abs(n2), true, state);
            this.collectPrefetchPositionsForLayoutState(state, this.mLayoutState, layoutPrefetchRegistry);
        }
    }

    @Override
    public void collectInitialPrefetchPositions(int n2, RecyclerView.LayoutManager.LayoutPrefetchRegistry layoutPrefetchRegistry) {
        int n3;
        int n4;
        boolean bl;
        SavedState savedState = this.mPendingSavedState;
        int n5 = -1;
        if (savedState != null && savedState.hasValidAnchor()) {
            bl = this.mPendingSavedState.mAnchorLayoutFromEnd;
            n4 = this.mPendingSavedState.mAnchorPosition;
        } else {
            this.resolveShouldLayoutReverse();
            boolean bl2 = this.mShouldReverseLayout;
            n3 = this.mPendingScrollPosition;
            bl = bl2;
            n4 = n3;
            if (n3 == -1) {
                if (bl2) {
                    n4 = n2 - 1;
                    bl = bl2;
                } else {
                    n4 = 0;
                    bl = bl2;
                }
            }
        }
        if (!bl) {
            n5 = 1;
        }
        for (n3 = 0; n3 < this.mInitialPrefetchItemCount && n4 >= 0 && n4 < n2; n4 += n5, ++n3) {
            layoutPrefetchRegistry.addPosition(n4, 0);
        }
    }

    void collectPrefetchPositionsForLayoutState(RecyclerView.State state, LayoutState layoutState, RecyclerView.LayoutManager.LayoutPrefetchRegistry layoutPrefetchRegistry) {
        int n2 = layoutState.mCurrentPosition;
        if (n2 >= 0 && n2 < state.getItemCount()) {
            layoutPrefetchRegistry.addPosition(n2, Math.max(0, layoutState.mScrollingOffset));
        }
    }

    @Override
    public int computeHorizontalScrollExtent(RecyclerView.State state) {
        return this.computeScrollExtent(state);
    }

    @Override
    public int computeHorizontalScrollOffset(RecyclerView.State state) {
        return this.computeScrollOffset(state);
    }

    @Override
    public int computeHorizontalScrollRange(RecyclerView.State state) {
        return this.computeScrollRange(state);
    }

    @Override
    public PointF computeScrollVectorForPosition(int n2) {
        if (this.getChildCount() == 0) {
            return null;
        }
        boolean bl = false;
        int n3 = this.getPosition(this.getChildAt(0));
        int n4 = 1;
        if (n2 < n3) {
            bl = true;
        }
        n2 = n4;
        if (bl != this.mShouldReverseLayout) {
            n2 = -1;
        }
        if (this.mOrientation == 0) {
            return new PointF((float)n2, 0.0f);
        }
        return new PointF(0.0f, (float)n2);
    }

    @Override
    public int computeVerticalScrollExtent(RecyclerView.State state) {
        return this.computeScrollExtent(state);
    }

    @Override
    public int computeVerticalScrollOffset(RecyclerView.State state) {
        return this.computeScrollOffset(state);
    }

    @Override
    public int computeVerticalScrollRange(RecyclerView.State state) {
        return this.computeScrollRange(state);
    }

    int convertFocusDirectionToLayoutDirection(int n2) {
        int n3 = -1;
        int n4 = 1;
        int n5 = 1;
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 17) {
                    if (n2 != 33) {
                        if (n2 != 66) {
                            if (n2 != 130) {
                                return Integer.MIN_VALUE;
                            }
                            n2 = this.mOrientation == 1 ? n5 : Integer.MIN_VALUE;
                            return n2;
                        }
                        n2 = this.mOrientation == 0 ? n4 : Integer.MIN_VALUE;
                        return n2;
                    }
                    if (this.mOrientation != 1) {
                        n3 = Integer.MIN_VALUE;
                    }
                    return n3;
                }
                if (this.mOrientation != 0) {
                    n3 = Integer.MIN_VALUE;
                }
                return n3;
            }
            if (this.mOrientation == 1) {
                return 1;
            }
            if (this.isLayoutRTL()) {
                return -1;
            }
            return 1;
        }
        if (this.mOrientation == 1) {
            return -1;
        }
        if (this.isLayoutRTL()) {
            return 1;
        }
        return -1;
    }

    LayoutState createLayoutState() {
        return new LayoutState();
    }

    void ensureLayoutState() {
        if (this.mLayoutState == null) {
            this.mLayoutState = this.createLayoutState();
        }
    }

    int fill(RecyclerView.Recycler recycler, LayoutState layoutState, RecyclerView.State state, boolean bl) {
        int n2 = layoutState.mAvailable;
        if (layoutState.mScrollingOffset != Integer.MIN_VALUE) {
            if (layoutState.mAvailable < 0) {
                layoutState.mScrollingOffset += layoutState.mAvailable;
            }
            this.recycleByLayoutState(recycler, layoutState);
        }
        int n3 = layoutState.mAvailable + layoutState.mExtraFillSpace;
        LayoutChunkResult layoutChunkResult = this.mLayoutChunkResult;
        while ((layoutState.mInfinite || n3 > 0) && layoutState.hasMore(state)) {
            int n4;
            block9: {
                block8: {
                    layoutChunkResult.resetInternal();
                    this.layoutChunk(recycler, state, layoutState, layoutChunkResult);
                    if (layoutChunkResult.mFinished) break;
                    layoutState.mOffset += layoutChunkResult.mConsumed * layoutState.mLayoutDirection;
                    if (!layoutChunkResult.mIgnoreConsumed || layoutState.mScrapList != null) break block8;
                    n4 = n3;
                    if (state.isPreLayout()) break block9;
                }
                layoutState.mAvailable -= layoutChunkResult.mConsumed;
                n4 = n3 - layoutChunkResult.mConsumed;
            }
            if (layoutState.mScrollingOffset != Integer.MIN_VALUE) {
                layoutState.mScrollingOffset += layoutChunkResult.mConsumed;
                if (layoutState.mAvailable < 0) {
                    layoutState.mScrollingOffset += layoutState.mAvailable;
                }
                this.recycleByLayoutState(recycler, layoutState);
            }
            n3 = n4;
            if (!bl) continue;
            n3 = n4;
            if (!layoutChunkResult.mFocusable) continue;
        }
        return n2 - layoutState.mAvailable;
    }

    public int findFirstCompletelyVisibleItemPosition() {
        View view = this.findOneVisibleChild(0, this.getChildCount(), true, false);
        int n2 = view == null ? -1 : this.getPosition(view);
        return n2;
    }

    View findFirstVisibleChildClosestToEnd(boolean bl, boolean bl2) {
        if (this.mShouldReverseLayout) {
            return this.findOneVisibleChild(0, this.getChildCount(), bl, bl2);
        }
        return this.findOneVisibleChild(this.getChildCount() - 1, -1, bl, bl2);
    }

    View findFirstVisibleChildClosestToStart(boolean bl, boolean bl2) {
        if (this.mShouldReverseLayout) {
            return this.findOneVisibleChild(this.getChildCount() - 1, -1, bl, bl2);
        }
        return this.findOneVisibleChild(0, this.getChildCount(), bl, bl2);
    }

    public int findFirstVisibleItemPosition() {
        View view = this.findOneVisibleChild(0, this.getChildCount(), false, true);
        int n2 = view == null ? -1 : this.getPosition(view);
        return n2;
    }

    public int findLastCompletelyVisibleItemPosition() {
        int n2 = this.getChildCount();
        int n3 = -1;
        View view = this.findOneVisibleChild(n2 - 1, -1, true, false);
        if (view != null) {
            n3 = this.getPosition(view);
        }
        return n3;
    }

    public int findLastVisibleItemPosition() {
        int n2 = this.getChildCount();
        int n3 = -1;
        View view = this.findOneVisibleChild(n2 - 1, -1, false, true);
        if (view != null) {
            n3 = this.getPosition(view);
        }
        return n3;
    }

    View findOnePartiallyOrCompletelyInvisibleChild(int n2, int n3) {
        int n4;
        this.ensureLayoutState();
        int n5 = n3 > n2 ? 1 : (n3 < n2 ? -1 : 0);
        if (n5 == 0) {
            return this.getChildAt(n2);
        }
        if (this.mOrientationHelper.getDecoratedStart(this.getChildAt(n2)) < this.mOrientationHelper.getStartAfterPadding()) {
            n5 = 16644;
            n4 = 16388;
        } else {
            n5 = 4161;
            n4 = 4097;
        }
        View view = this.mOrientation == 0 ? this.mHorizontalBoundCheck.findOneViewWithinBoundFlags(n2, n3, n5, n4) : this.mVerticalBoundCheck.findOneViewWithinBoundFlags(n2, n3, n5, n4);
        return view;
    }

    View findOneVisibleChild(int n2, int n3, boolean bl, boolean bl2) {
        this.ensureLayoutState();
        int n4 = 320;
        int n5 = bl ? 24579 : 320;
        if (!bl2) {
            n4 = 0;
        }
        View view = this.mOrientation == 0 ? this.mHorizontalBoundCheck.findOneViewWithinBoundFlags(n2, n3, n5, n4) : this.mVerticalBoundCheck.findOneViewWithinBoundFlags(n2, n3, n5, n4);
        return view;
    }

    View findReferenceChild(RecyclerView.Recycler recycler, RecyclerView.State object, int n2, int n3, int n4) {
        this.ensureLayoutState();
        int n5 = this.mOrientationHelper.getStartAfterPadding();
        int n6 = this.mOrientationHelper.getEndAfterPadding();
        int n7 = n3 > n2 ? 1 : -1;
        object = null;
        recycler = null;
        while (n2 != n3) {
            View view = this.getChildAt(n2);
            int n8 = this.getPosition(view);
            Object object2 = object;
            RecyclerView.Recycler recycler2 = recycler;
            if (n8 >= 0) {
                object2 = object;
                recycler2 = recycler;
                if (n8 < n4) {
                    if (((RecyclerView.LayoutParams)view.getLayoutParams()).isItemRemoved()) {
                        object2 = object;
                        recycler2 = recycler;
                        if (recycler == null) {
                            recycler2 = view;
                            object2 = object;
                        }
                    } else {
                        if (this.mOrientationHelper.getDecoratedStart(view) < n6 && this.mOrientationHelper.getDecoratedEnd(view) >= n5) {
                            return view;
                        }
                        object2 = object;
                        recycler2 = recycler;
                        if (object == null) {
                            object2 = view;
                            recycler2 = recycler;
                        }
                    }
                }
            }
            n2 += n7;
            object = object2;
            recycler = recycler2;
        }
        if (object == null) {
            object = recycler;
        }
        return object;
    }

    @Override
    public View findViewByPosition(int n2) {
        View view;
        int n3 = this.getChildCount();
        if (n3 == 0) {
            return null;
        }
        int n4 = n2 - this.getPosition(this.getChildAt(0));
        if (n4 >= 0 && n4 < n3 && this.getPosition(view = this.getChildAt(n4)) == n2) {
            return view;
        }
        return super.findViewByPosition(n2);
    }

    @Override
    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    @Deprecated
    protected int getExtraLayoutSpace(RecyclerView.State state) {
        if (state.hasTargetScrollPosition()) {
            return this.mOrientationHelper.getTotalSpace();
        }
        return 0;
    }

    public int getInitialPrefetchItemCount() {
        return this.mInitialPrefetchItemCount;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public boolean getRecycleChildrenOnDetach() {
        return this.mRecycleChildrenOnDetach;
    }

    public boolean getReverseLayout() {
        return this.mReverseLayout;
    }

    public boolean getStackFromEnd() {
        return this.mStackFromEnd;
    }

    @Override
    public boolean isAutoMeasureEnabled() {
        return true;
    }

    protected boolean isLayoutRTL() {
        int n2 = this.getLayoutDirection();
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    public boolean isSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    void layoutChunk(RecyclerView.Recycler object, RecyclerView.State state, LayoutState layoutState, LayoutChunkResult layoutChunkResult) {
        int n2;
        int n3;
        int n4;
        int n5;
        state = layoutState.next((RecyclerView.Recycler)object);
        if (state == null) {
            layoutChunkResult.mFinished = true;
            return;
        }
        object = (RecyclerView.LayoutParams)state.getLayoutParams();
        if (layoutState.mScrapList == null) {
            boolean bl = this.mShouldReverseLayout;
            boolean bl2 = layoutState.mLayoutDirection == -1;
            if (bl == bl2) {
                this.addView((View)state);
            } else {
                this.addView((View)state, 0);
            }
        } else {
            boolean bl = this.mShouldReverseLayout;
            boolean bl3 = layoutState.mLayoutDirection == -1;
            if (bl == bl3) {
                this.addDisappearingView((View)state);
            } else {
                this.addDisappearingView((View)state, 0);
            }
        }
        this.measureChildWithMargins((View)state, 0, 0);
        layoutChunkResult.mConsumed = this.mOrientationHelper.getDecoratedMeasurement((View)state);
        if (this.mOrientation == 1) {
            if (this.isLayoutRTL()) {
                n5 = this.getWidth() - this.getPaddingRight();
                n4 = n5 - this.mOrientationHelper.getDecoratedMeasurementInOther((View)state);
            } else {
                n4 = this.getPaddingLeft();
                n5 = this.mOrientationHelper.getDecoratedMeasurementInOther((View)state) + n4;
            }
            if (layoutState.mLayoutDirection == -1) {
                n3 = layoutState.mOffset;
                int n6 = layoutState.mOffset - layoutChunkResult.mConsumed;
                n2 = n5;
                n5 = n6;
            } else {
                int n7 = layoutState.mOffset;
                n3 = layoutState.mOffset + layoutChunkResult.mConsumed;
                n2 = n5;
                n5 = n7;
            }
        } else {
            n4 = this.getPaddingTop();
            n5 = this.mOrientationHelper.getDecoratedMeasurementInOther((View)state) + n4;
            if (layoutState.mLayoutDirection == -1) {
                n2 = layoutState.mOffset;
                int n8 = layoutState.mOffset;
                int n9 = layoutChunkResult.mConsumed;
                int n10 = n4;
                n3 = n5;
                n4 = n8 - n9;
                n5 = n10;
            } else {
                int n11 = layoutState.mOffset;
                n2 = layoutState.mOffset + layoutChunkResult.mConsumed;
                n3 = n5;
                n5 = n4;
                n4 = n11;
            }
        }
        this.layoutDecoratedWithMargins((View)state, n4, n5, n2, n3);
        if (((RecyclerView.LayoutParams)((Object)object)).isItemRemoved() || ((RecyclerView.LayoutParams)((Object)object)).isItemChanged()) {
            layoutChunkResult.mIgnoreConsumed = true;
        }
        layoutChunkResult.mFocusable = state.hasFocusable();
    }

    void onAnchorReady(RecyclerView.Recycler recycler, RecyclerView.State state, AnchorInfo anchorInfo, int n2) {
    }

    @Override
    public void onDetachedFromWindow(RecyclerView recyclerView, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(recyclerView, recycler);
        if (this.mRecycleChildrenOnDetach) {
            this.removeAndRecycleAllViews(recycler);
            recycler.clear();
        }
    }

    @Override
    public View onFocusSearchFailed(View object, int n2, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.resolveShouldLayoutReverse();
        if (this.getChildCount() == 0) {
            return null;
        }
        if ((n2 = this.convertFocusDirectionToLayoutDirection(n2)) == Integer.MIN_VALUE) {
            return null;
        }
        this.ensureLayoutState();
        this.updateLayoutState(n2, (int)((float)this.mOrientationHelper.getTotalSpace() * 0.33333334f), false, state);
        object = this.mLayoutState;
        object.mScrollingOffset = Integer.MIN_VALUE;
        object.mRecycle = false;
        this.fill(recycler, (LayoutState)object, state, true);
        object = n2 == -1 ? this.findPartiallyOrCompletelyInvisibleChildClosestToStart() : this.findPartiallyOrCompletelyInvisibleChildClosestToEnd();
        recycler = n2 == -1 ? this.getChildClosestToStart() : this.getChildClosestToEnd();
        if (recycler.hasFocusable()) {
            if (object == null) {
                return null;
            }
            return recycler;
        }
        return object;
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        if (this.getChildCount() > 0) {
            accessibilityEvent.setFromIndex(this.findFirstVisibleItemPosition());
            accessibilityEvent.setToIndex(this.findLastVisibleItemPosition());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        Object object = this.mPendingSavedState;
        int n2 = -1;
        if ((object != null || this.mPendingScrollPosition != -1) && state.getItemCount() == 0) {
            this.removeAndRecycleAllViews(recycler);
            return;
        }
        object = this.mPendingSavedState;
        if (object != null && ((SavedState)object).hasValidAnchor()) {
            this.mPendingScrollPosition = this.mPendingSavedState.mAnchorPosition;
        }
        this.ensureLayoutState();
        this.mLayoutState.mRecycle = false;
        this.resolveShouldLayoutReverse();
        object = this.getFocusedChild();
        if (this.mAnchorInfo.mValid && this.mPendingScrollPosition == -1 && this.mPendingSavedState == null) {
            if (object != null && (this.mOrientationHelper.getDecoratedStart((View)object) >= this.mOrientationHelper.getEndAfterPadding() || this.mOrientationHelper.getDecoratedEnd((View)object) <= this.mOrientationHelper.getStartAfterPadding())) {
                this.mAnchorInfo.assignFromViewAndKeepVisibleRect((View)object, this.getPosition((View)object));
            }
        } else {
            this.mAnchorInfo.reset();
            object = this.mAnchorInfo;
            ((AnchorInfo)object).mLayoutFromEnd = this.mShouldReverseLayout ^ this.mStackFromEnd;
            this.updateAnchorInfoForLayout(recycler, state, (AnchorInfo)object);
            this.mAnchorInfo.mValid = true;
        }
        object = this.mLayoutState;
        int n3 = ((LayoutState)object).mLastScrollDelta >= 0 ? 1 : -1;
        ((LayoutState)object).mLayoutDirection = n3;
        object = this.mReusableIntPair;
        object[0] = false;
        object[1] = false;
        this.calculateExtraLayoutSpace(state, (int[])object);
        int n4 = Math.max(0, this.mReusableIntPair[0]) + this.mOrientationHelper.getStartAfterPadding();
        int n5 = Math.max(0, this.mReusableIntPair[1]) + this.mOrientationHelper.getEndPadding();
        n3 = n4;
        int n6 = n5;
        if (state.isPreLayout()) {
            int n7 = this.mPendingScrollPosition;
            n3 = n4;
            n6 = n5;
            if (n7 != -1) {
                n3 = n4;
                n6 = n5;
                if (this.mPendingScrollPositionOffset != Integer.MIN_VALUE) {
                    object = this.findViewByPosition(n7);
                    n3 = n4;
                    n6 = n5;
                    if (object != null) {
                        if (this.mShouldReverseLayout) {
                            n3 = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd((View)object);
                            n6 = this.mPendingScrollPositionOffset;
                        } else {
                            n6 = this.mOrientationHelper.getDecoratedStart((View)object) - this.mOrientationHelper.getStartAfterPadding();
                            n3 = this.mPendingScrollPositionOffset;
                        }
                        if ((n3 -= n6) > 0) {
                            n3 = n4 + n3;
                            n6 = n5;
                        } else {
                            n6 = n5 - n3;
                            n3 = n4;
                        }
                    }
                }
            }
        }
        if (this.mAnchorInfo.mLayoutFromEnd ? this.mShouldReverseLayout : !this.mShouldReverseLayout) {
            n2 = 1;
        }
        this.onAnchorReady(recycler, state, this.mAnchorInfo, n2);
        this.detachAndScrapAttachedViews(recycler);
        this.mLayoutState.mInfinite = this.resolveIsInfinite();
        this.mLayoutState.mIsPreLayout = state.isPreLayout();
        this.mLayoutState.mNoRecycleSpace = 0;
        if (this.mAnchorInfo.mLayoutFromEnd) {
            this.updateLayoutStateToFillStart(this.mAnchorInfo);
            object = this.mLayoutState;
            ((LayoutState)object).mExtraFillSpace = n3;
            this.fill(recycler, (LayoutState)object, state, false);
            n2 = this.mLayoutState.mOffset;
            n4 = this.mLayoutState.mCurrentPosition;
            n3 = n6;
            if (this.mLayoutState.mAvailable > 0) {
                n3 = n6 + this.mLayoutState.mAvailable;
            }
            this.updateLayoutStateToFillEnd(this.mAnchorInfo);
            object = this.mLayoutState;
            ((LayoutState)object).mExtraFillSpace = n3;
            ((LayoutState)object).mCurrentPosition += this.mLayoutState.mItemDirection;
            this.fill(recycler, this.mLayoutState, state, false);
            n5 = this.mLayoutState.mOffset;
            n6 = n2;
            n3 = n5;
            if (this.mLayoutState.mAvailable > 0) {
                n3 = this.mLayoutState.mAvailable;
                this.updateLayoutStateToFillStart(n4, n2);
                object = this.mLayoutState;
                ((LayoutState)object).mExtraFillSpace = n3;
                this.fill(recycler, (LayoutState)object, state, false);
                n6 = this.mLayoutState.mOffset;
                n3 = n5;
            }
        } else {
            this.updateLayoutStateToFillEnd(this.mAnchorInfo);
            object = this.mLayoutState;
            ((LayoutState)object).mExtraFillSpace = n6;
            this.fill(recycler, (LayoutState)object, state, false);
            n2 = this.mLayoutState.mOffset;
            n4 = this.mLayoutState.mCurrentPosition;
            n6 = n3;
            if (this.mLayoutState.mAvailable > 0) {
                n6 = n3 + this.mLayoutState.mAvailable;
            }
            this.updateLayoutStateToFillStart(this.mAnchorInfo);
            object = this.mLayoutState;
            ((LayoutState)object).mExtraFillSpace = n6;
            ((LayoutState)object).mCurrentPosition += this.mLayoutState.mItemDirection;
            this.fill(recycler, this.mLayoutState, state, false);
            n6 = n5 = this.mLayoutState.mOffset;
            n3 = n2;
            if (this.mLayoutState.mAvailable > 0) {
                n3 = this.mLayoutState.mAvailable;
                this.updateLayoutStateToFillEnd(n4, n2);
                object = this.mLayoutState;
                ((LayoutState)object).mExtraFillSpace = n3;
                this.fill(recycler, (LayoutState)object, state, false);
                n3 = this.mLayoutState.mOffset;
                n6 = n5;
            }
        }
        n5 = n6;
        n2 = n3;
        if (this.getChildCount() > 0) {
            if (this.mShouldReverseLayout ^ this.mStackFromEnd) {
                n5 = this.fixLayoutEndGap(n3, recycler, state, true);
                n2 = n6 + n5;
                n3 += n5;
                n6 = this.fixLayoutStartGap(n2, recycler, state, false);
            } else {
                n5 = this.fixLayoutStartGap(n6, recycler, state, true);
                n2 = n6 + n5;
                n6 = this.fixLayoutEndGap(n3 += n5, recycler, state, false);
            }
            n5 = n2 + n6;
            n2 = n3 + n6;
        }
        this.layoutForPredictiveAnimations(recycler, state, n5, n2);
        if (!state.isPreLayout()) {
            this.mOrientationHelper.onLayoutComplete();
        } else {
            this.mAnchorInfo.reset();
        }
        this.mLastStackFromEnd = this.mStackFromEnd;
    }

    @Override
    public void onLayoutCompleted(RecyclerView.State state) {
        super.onLayoutCompleted(state);
        this.mPendingSavedState = null;
        this.mPendingScrollPosition = -1;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.mAnchorInfo.reset();
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof SavedState) {
            this.mPendingSavedState = (SavedState)parcelable;
            this.requestLayout();
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        SavedState savedState = this.mPendingSavedState;
        if (savedState != null) {
            return new SavedState(savedState);
        }
        savedState = new SavedState();
        if (this.getChildCount() > 0) {
            boolean bl;
            this.ensureLayoutState();
            savedState.mAnchorLayoutFromEnd = bl = this.mLastStackFromEnd ^ this.mShouldReverseLayout;
            if (bl) {
                View view = this.getChildClosestToEnd();
                savedState.mAnchorOffset = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(view);
                savedState.mAnchorPosition = this.getPosition(view);
            } else {
                View view = this.getChildClosestToStart();
                savedState.mAnchorPosition = this.getPosition(view);
                savedState.mAnchorOffset = this.mOrientationHelper.getDecoratedStart(view) - this.mOrientationHelper.getStartAfterPadding();
            }
        } else {
            savedState.invalidateAnchor();
        }
        return savedState;
    }

    public void prepareForDrop(View view, View view2, int n2, int n3) {
        this.assertNotInLayoutOrScroll("Cannot drop a view during a scroll or layout calculation");
        this.ensureLayoutState();
        this.resolveShouldLayoutReverse();
        n2 = this.getPosition(view);
        n3 = this.getPosition(view2);
        n2 = n2 < n3 ? 1 : -1;
        if (this.mShouldReverseLayout) {
            if (n2 == 1) {
                this.scrollToPositionWithOffset(n3, this.mOrientationHelper.getEndAfterPadding() - (this.mOrientationHelper.getDecoratedStart(view2) + this.mOrientationHelper.getDecoratedMeasurement(view)));
            } else {
                this.scrollToPositionWithOffset(n3, this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(view2));
            }
        } else if (n2 == -1) {
            this.scrollToPositionWithOffset(n3, this.mOrientationHelper.getDecoratedStart(view2));
        } else {
            this.scrollToPositionWithOffset(n3, this.mOrientationHelper.getDecoratedEnd(view2) - this.mOrientationHelper.getDecoratedMeasurement(view));
        }
    }

    boolean resolveIsInfinite() {
        boolean bl = this.mOrientationHelper.getMode() == 0 && this.mOrientationHelper.getEnd() == 0;
        return bl;
    }

    int scrollBy(int n2, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() != 0 && n2 != 0) {
            this.ensureLayoutState();
            this.mLayoutState.mRecycle = true;
            int n3 = n2 > 0 ? 1 : -1;
            int n4 = Math.abs(n2);
            this.updateLayoutState(n3, n4, true, state);
            int n5 = this.mLayoutState.mScrollingOffset + this.fill(recycler, this.mLayoutState, state, false);
            if (n5 < 0) {
                return 0;
            }
            if (n4 > n5) {
                n2 = n3 * n5;
            }
            this.mOrientationHelper.offsetChildren(-n2);
            this.mLayoutState.mLastScrollDelta = n2;
            return n2;
        }
        return 0;
    }

    @Override
    public int scrollHorizontallyBy(int n2, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            return 0;
        }
        return this.scrollBy(n2, recycler, state);
    }

    @Override
    public void scrollToPosition(int n2) {
        this.mPendingScrollPosition = n2;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        SavedState savedState = this.mPendingSavedState;
        if (savedState != null) {
            savedState.invalidateAnchor();
        }
        this.requestLayout();
    }

    public void scrollToPositionWithOffset(int n2, int n3) {
        this.mPendingScrollPosition = n2;
        this.mPendingScrollPositionOffset = n3;
        SavedState savedState = this.mPendingSavedState;
        if (savedState != null) {
            savedState.invalidateAnchor();
        }
        this.requestLayout();
    }

    @Override
    public int scrollVerticallyBy(int n2, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 0) {
            return 0;
        }
        return this.scrollBy(n2, recycler, state);
    }

    public void setInitialPrefetchItemCount(int n2) {
        this.mInitialPrefetchItemCount = n2;
    }

    public void setOrientation(int n2) {
        if (n2 != 0 && n2 != 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("invalid orientation:");
            stringBuilder.append(n2);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.assertNotInLayoutOrScroll(null);
        if (n2 != this.mOrientation || this.mOrientationHelper == null) {
            this.mAnchorInfo.mOrientationHelper = this.mOrientationHelper = OrientationHelper.createOrientationHelper(this, n2);
            this.mOrientation = n2;
            this.requestLayout();
        }
    }

    public void setRecycleChildrenOnDetach(boolean bl) {
        this.mRecycleChildrenOnDetach = bl;
    }

    public void setReverseLayout(boolean bl) {
        this.assertNotInLayoutOrScroll(null);
        if (bl == this.mReverseLayout) {
            return;
        }
        this.mReverseLayout = bl;
        this.requestLayout();
    }

    public void setSmoothScrollbarEnabled(boolean bl) {
        this.mSmoothScrollbarEnabled = bl;
    }

    public void setStackFromEnd(boolean bl) {
        this.assertNotInLayoutOrScroll(null);
        if (this.mStackFromEnd == bl) {
            return;
        }
        this.mStackFromEnd = bl;
        this.requestLayout();
    }

    @Override
    boolean shouldMeasureTwice() {
        boolean bl = this.getHeightMode() != 0x40000000 && this.getWidthMode() != 0x40000000 && this.hasFlexibleChildInBothOrientations();
        return bl;
    }

    @Override
    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int n2) {
        recyclerView = new LinearSmoothScroller(recyclerView.getContext());
        recyclerView.setTargetPosition(n2);
        this.startSmoothScroll((RecyclerView.SmoothScroller)((Object)recyclerView));
    }

    @Override
    public boolean supportsPredictiveItemAnimations() {
        boolean bl = this.mPendingSavedState == null && this.mLastStackFromEnd == this.mStackFromEnd;
        return bl;
    }

    void validateChildOrder() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("validating child count ");
        stringBuilder.append(this.getChildCount());
        Log.d((String)TAG, (String)stringBuilder.toString());
        if (this.getChildCount() < 1) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.getPosition(this.getChildAt(0));
        int n3 = this.mOrientationHelper.getDecoratedStart(this.getChildAt(0));
        if (this.mShouldReverseLayout) {
            for (int i2 = 1; i2 < this.getChildCount(); ++i2) {
                stringBuilder = this.getChildAt(i2);
                int n4 = this.getPosition((View)stringBuilder);
                int n5 = this.mOrientationHelper.getDecoratedStart((View)stringBuilder);
                if (n4 < n2) {
                    this.logChildren();
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("detected invalid position. loc invalid? ");
                    if (n5 < n3) {
                        bl2 = true;
                    }
                    stringBuilder.append(bl2);
                    throw new RuntimeException(stringBuilder.toString());
                }
                if (n5 <= n3) {
                    continue;
                }
                this.logChildren();
                throw new RuntimeException("detected invalid location");
            }
        } else {
            for (int i3 = 1; i3 < this.getChildCount(); ++i3) {
                stringBuilder = this.getChildAt(i3);
                int n6 = this.getPosition((View)stringBuilder);
                int n7 = this.mOrientationHelper.getDecoratedStart((View)stringBuilder);
                if (n6 < n2) {
                    this.logChildren();
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("detected invalid position. loc invalid? ");
                    bl2 = bl;
                    if (n7 < n3) {
                        bl2 = true;
                    }
                    stringBuilder.append(bl2);
                    throw new RuntimeException(stringBuilder.toString());
                }
                if (n7 >= n3) {
                    continue;
                }
                this.logChildren();
                throw new RuntimeException("detected invalid location");
            }
        }
    }

    static class AnchorInfo {
        int mCoordinate;
        boolean mLayoutFromEnd;
        OrientationHelper mOrientationHelper;
        int mPosition;
        boolean mValid;

        AnchorInfo() {
            this.reset();
        }

        void assignCoordinateFromPadding() {
            int n2 = this.mLayoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() : this.mOrientationHelper.getStartAfterPadding();
            this.mCoordinate = n2;
        }

        public void assignFromView(View view, int n2) {
            this.mCoordinate = this.mLayoutFromEnd ? this.mOrientationHelper.getDecoratedEnd(view) + this.mOrientationHelper.getTotalSpaceChange() : this.mOrientationHelper.getDecoratedStart(view);
            this.mPosition = n2;
        }

        public void assignFromViewAndKeepVisibleRect(View view, int n2) {
            int n3 = this.mOrientationHelper.getTotalSpaceChange();
            if (n3 >= 0) {
                this.assignFromView(view, n2);
                return;
            }
            this.mPosition = n2;
            if (this.mLayoutFromEnd) {
                n2 = this.mOrientationHelper.getEndAfterPadding() - n3 - this.mOrientationHelper.getDecoratedEnd(view);
                this.mCoordinate = this.mOrientationHelper.getEndAfterPadding() - n2;
                if (n2 > 0) {
                    int n4 = this.mOrientationHelper.getDecoratedMeasurement(view);
                    n3 = this.mCoordinate;
                    int n5 = this.mOrientationHelper.getStartAfterPadding();
                    if ((n3 = n3 - n4 - (n5 + Math.min(this.mOrientationHelper.getDecoratedStart(view) - n5, 0))) < 0) {
                        this.mCoordinate += Math.min(n2, -n3);
                    }
                }
            } else {
                int n6 = this.mOrientationHelper.getDecoratedStart(view);
                n2 = n6 - this.mOrientationHelper.getStartAfterPadding();
                this.mCoordinate = n6;
                if (n2 > 0) {
                    int n7 = this.mOrientationHelper.getDecoratedMeasurement(view);
                    int n8 = this.mOrientationHelper.getEndAfterPadding();
                    int n9 = this.mOrientationHelper.getDecoratedEnd(view);
                    n3 = this.mOrientationHelper.getEndAfterPadding() - Math.min(0, n8 - n3 - n9) - (n6 + n7);
                    if (n3 < 0) {
                        this.mCoordinate -= Math.min(n2, -n3);
                    }
                }
            }
        }

        boolean isViewValidAsAnchor(View object, RecyclerView.State state) {
            boolean bl = !((RecyclerView.LayoutParams)((Object)(object = (RecyclerView.LayoutParams)object.getLayoutParams()))).isItemRemoved() && ((RecyclerView.LayoutParams)((Object)object)).getViewLayoutPosition() >= 0 && ((RecyclerView.LayoutParams)((Object)object)).getViewLayoutPosition() < state.getItemCount();
            return bl;
        }

        void reset() {
            this.mPosition = -1;
            this.mCoordinate = Integer.MIN_VALUE;
            this.mLayoutFromEnd = false;
            this.mValid = false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("AnchorInfo{mPosition=");
            stringBuilder.append(this.mPosition);
            stringBuilder.append(", mCoordinate=");
            stringBuilder.append(this.mCoordinate);
            stringBuilder.append(", mLayoutFromEnd=");
            stringBuilder.append(this.mLayoutFromEnd);
            stringBuilder.append(", mValid=");
            stringBuilder.append(this.mValid);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    protected static class LayoutChunkResult {
        public int mConsumed;
        public boolean mFinished;
        public boolean mFocusable;
        public boolean mIgnoreConsumed;

        protected LayoutChunkResult() {
        }

        void resetInternal() {
            this.mConsumed = 0;
            this.mFinished = false;
            this.mIgnoreConsumed = false;
            this.mFocusable = false;
        }
    }

    static class LayoutState {
        static final int INVALID_LAYOUT = Integer.MIN_VALUE;
        static final int ITEM_DIRECTION_HEAD = -1;
        static final int ITEM_DIRECTION_TAIL = 1;
        static final int LAYOUT_END = 1;
        static final int LAYOUT_START = -1;
        static final int SCROLLING_OFFSET_NaN = Integer.MIN_VALUE;
        static final String TAG = "LLM#LayoutState";
        int mAvailable;
        int mCurrentPosition;
        int mExtraFillSpace = 0;
        boolean mInfinite;
        boolean mIsPreLayout = false;
        int mItemDirection;
        int mLastScrollDelta;
        int mLayoutDirection;
        int mNoRecycleSpace = 0;
        int mOffset;
        boolean mRecycle = true;
        List<RecyclerView.ViewHolder> mScrapList = null;
        int mScrollingOffset;

        LayoutState() {
        }

        private View nextViewFromScrapList() {
            int n2 = this.mScrapList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                View view = this.mScrapList.get((int)i2).itemView;
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                if (layoutParams.isItemRemoved() || this.mCurrentPosition != layoutParams.getViewLayoutPosition()) continue;
                this.assignPositionFromScrapList(view);
                return view;
            }
            return null;
        }

        public void assignPositionFromScrapList() {
            this.assignPositionFromScrapList(null);
        }

        public void assignPositionFromScrapList(View view) {
            this.mCurrentPosition = (view = this.nextViewInLimitedList(view)) == null ? -1 : ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewLayoutPosition();
        }

        boolean hasMore(RecyclerView.State state) {
            int n2 = this.mCurrentPosition;
            boolean bl = n2 >= 0 && n2 < state.getItemCount();
            return bl;
        }

        void log() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("avail:");
            stringBuilder.append(this.mAvailable);
            stringBuilder.append(", ind:");
            stringBuilder.append(this.mCurrentPosition);
            stringBuilder.append(", dir:");
            stringBuilder.append(this.mItemDirection);
            stringBuilder.append(", offset:");
            stringBuilder.append(this.mOffset);
            stringBuilder.append(", layoutDir:");
            stringBuilder.append(this.mLayoutDirection);
            Log.d((String)TAG, (String)stringBuilder.toString());
        }

        View next(RecyclerView.Recycler recycler) {
            if (this.mScrapList != null) {
                return this.nextViewFromScrapList();
            }
            recycler = recycler.getViewForPosition(this.mCurrentPosition);
            this.mCurrentPosition += this.mItemDirection;
            return recycler;
        }

        public View nextViewInLimitedList(View view) {
            View view2;
            int n2 = this.mScrapList.size();
            View view3 = null;
            int n3 = Integer.MAX_VALUE;
            int n4 = 0;
            while (true) {
                view2 = view3;
                if (n4 >= n2) break;
                View view4 = this.mScrapList.get((int)n4).itemView;
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view4.getLayoutParams();
                view2 = view3;
                int n5 = n3;
                if (view4 != view) {
                    if (layoutParams.isItemRemoved()) {
                        view2 = view3;
                        n5 = n3;
                    } else {
                        int n6 = (layoutParams.getViewLayoutPosition() - this.mCurrentPosition) * this.mItemDirection;
                        if (n6 < 0) {
                            view2 = view3;
                            n5 = n3;
                        } else {
                            view2 = view3;
                            n5 = n3;
                            if (n6 < n3) {
                                view3 = view4;
                                if (n6 == 0) {
                                    view2 = view3;
                                    break;
                                }
                                n5 = n6;
                                view2 = view3;
                            }
                        }
                    }
                }
                ++n4;
                view3 = view2;
                n3 = n5;
            }
            return view2;
        }
    }

    public static class SavedState
    implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        boolean mAnchorLayoutFromEnd;
        int mAnchorOffset;
        int mAnchorPosition;

        public SavedState() {
        }

        SavedState(Parcel parcel) {
            this.mAnchorPosition = parcel.readInt();
            this.mAnchorOffset = parcel.readInt();
            int n2 = parcel.readInt();
            boolean bl = true;
            if (n2 != 1) {
                bl = false;
            }
            this.mAnchorLayoutFromEnd = bl;
        }

        public SavedState(SavedState savedState) {
            this.mAnchorPosition = savedState.mAnchorPosition;
            this.mAnchorOffset = savedState.mAnchorOffset;
            this.mAnchorLayoutFromEnd = savedState.mAnchorLayoutFromEnd;
        }

        public int describeContents() {
            return 0;
        }

        boolean hasValidAnchor() {
            boolean bl = this.mAnchorPosition >= 0;
            return bl;
        }

        void invalidateAnchor() {
            this.mAnchorPosition = -1;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeInt(this.mAnchorPosition);
            parcel.writeInt(this.mAnchorOffset);
            parcel.writeInt(this.mAnchorLayoutFromEnd ? 1 : 0);
        }
    }
}

