/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;

class ChildHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = "ChildrenHelper";
    final Bucket mBucket;
    final Callback mCallback;
    final List<View> mHiddenViews;

    ChildHelper(Callback callback2) {
        this.mCallback = callback2;
        this.mBucket = new Bucket();
        this.mHiddenViews = new ArrayList<View>();
    }

    private int getOffset(int n2) {
        int n3;
        if (n2 < 0) {
            return -1;
        }
        int n4 = this.mCallback.getChildCount();
        for (int i2 = n2; i2 < n4; i2 += n3) {
            n3 = n2 - (i2 - this.mBucket.countOnesBefore(i2));
            if (n3 != 0) continue;
            while (this.mBucket.get(i2)) {
                ++i2;
            }
            return i2;
        }
        return -1;
    }

    private void hideViewInternal(View view) {
        this.mHiddenViews.add(view);
        this.mCallback.onEnteredHiddenState(view);
    }

    private boolean unhideViewInternal(View view) {
        if (this.mHiddenViews.remove(view)) {
            this.mCallback.onLeftHiddenState(view);
            return true;
        }
        return false;
    }

    void addView(View view, int n2, boolean bl) {
        n2 = n2 < 0 ? this.mCallback.getChildCount() : this.getOffset(n2);
        this.mBucket.insert(n2, bl);
        if (bl) {
            this.hideViewInternal(view);
        }
        this.mCallback.addView(view, n2);
    }

    void addView(View view, boolean bl) {
        this.addView(view, -1, bl);
    }

    void attachViewToParent(View view, int n2, ViewGroup.LayoutParams layoutParams, boolean bl) {
        n2 = n2 < 0 ? this.mCallback.getChildCount() : this.getOffset(n2);
        this.mBucket.insert(n2, bl);
        if (bl) {
            this.hideViewInternal(view);
        }
        this.mCallback.attachViewToParent(view, n2, layoutParams);
    }

    void detachViewFromParent(int n2) {
        n2 = this.getOffset(n2);
        this.mBucket.remove(n2);
        this.mCallback.detachViewFromParent(n2);
    }

    View findHiddenNonRemovedView(int n2) {
        int n3 = this.mHiddenViews.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            View view = this.mHiddenViews.get(i2);
            RecyclerView.ViewHolder viewHolder = this.mCallback.getChildViewHolder(view);
            if (viewHolder.getLayoutPosition() != n2 || viewHolder.isInvalid() || viewHolder.isRemoved()) continue;
            return view;
        }
        return null;
    }

    View getChildAt(int n2) {
        n2 = this.getOffset(n2);
        return this.mCallback.getChildAt(n2);
    }

    int getChildCount() {
        return this.mCallback.getChildCount() - this.mHiddenViews.size();
    }

    View getUnfilteredChildAt(int n2) {
        return this.mCallback.getChildAt(n2);
    }

    int getUnfilteredChildCount() {
        return this.mCallback.getChildCount();
    }

    void hide(View view) {
        int n2 = this.mCallback.indexOfChild(view);
        if (n2 >= 0) {
            this.mBucket.set(n2);
            this.hideViewInternal(view);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("view is not a child, cannot hide ");
        stringBuilder.append(view);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    int indexOfChild(View view) {
        int n2 = this.mCallback.indexOfChild(view);
        if (n2 == -1) {
            return -1;
        }
        if (this.mBucket.get(n2)) {
            return -1;
        }
        return n2 - this.mBucket.countOnesBefore(n2);
    }

    boolean isHidden(View view) {
        return this.mHiddenViews.contains(view);
    }

    void removeAllViewsUnfiltered() {
        this.mBucket.reset();
        for (int i2 = this.mHiddenViews.size() - 1; i2 >= 0; --i2) {
            this.mCallback.onLeftHiddenState(this.mHiddenViews.get(i2));
            this.mHiddenViews.remove(i2);
        }
        this.mCallback.removeAllViews();
    }

    void removeView(View view) {
        int n2 = this.mCallback.indexOfChild(view);
        if (n2 < 0) {
            return;
        }
        if (this.mBucket.remove(n2)) {
            this.unhideViewInternal(view);
        }
        this.mCallback.removeViewAt(n2);
    }

    void removeViewAt(int n2) {
        View view = this.mCallback.getChildAt(n2 = this.getOffset(n2));
        if (view == null) {
            return;
        }
        if (this.mBucket.remove(n2)) {
            this.unhideViewInternal(view);
        }
        this.mCallback.removeViewAt(n2);
    }

    boolean removeViewIfHidden(View view) {
        int n2 = this.mCallback.indexOfChild(view);
        if (n2 == -1) {
            this.unhideViewInternal(view);
            return true;
        }
        if (this.mBucket.get(n2)) {
            this.mBucket.remove(n2);
            this.unhideViewInternal(view);
            this.mCallback.removeViewAt(n2);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mBucket.toString());
        stringBuilder.append(", hidden list:");
        stringBuilder.append(this.mHiddenViews.size());
        return stringBuilder.toString();
    }

    void unhide(View view) {
        int n2 = this.mCallback.indexOfChild(view);
        if (n2 >= 0) {
            if (this.mBucket.get(n2)) {
                this.mBucket.clear(n2);
                this.unhideViewInternal(view);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("trying to unhide a view that was not hidden");
            stringBuilder.append(view);
            throw new RuntimeException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("view is not a child, cannot hide ");
        stringBuilder.append(view);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    static class Bucket {
        static final int BITS_PER_WORD = 64;
        static final long LAST_BIT = Long.MIN_VALUE;
        long mData = 0L;
        Bucket mNext;

        Bucket() {
        }

        private void ensureNext() {
            if (this.mNext == null) {
                this.mNext = new Bucket();
            }
        }

        void clear(int n2) {
            if (n2 >= 64) {
                Bucket bucket = this.mNext;
                if (bucket != null) {
                    bucket.clear(n2 - 64);
                }
            } else {
                this.mData &= 1L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }

        int countOnesBefore(int n2) {
            Bucket bucket = this.mNext;
            if (bucket == null) {
                if (n2 >= 64) {
                    return Long.bitCount(this.mData);
                }
                return Long.bitCount(this.mData & (1L << n2) - 1L);
            }
            if (n2 < 64) {
                return Long.bitCount(this.mData & (1L << n2) - 1L);
            }
            return bucket.countOnesBefore(n2 - 64) + Long.bitCount(this.mData);
        }

        boolean get(int n2) {
            if (n2 >= 64) {
                this.ensureNext();
                return this.mNext.get(n2 - 64);
            }
            boolean bl = (this.mData & 1L << n2) != 0L;
            return bl;
        }

        void insert(int n2, boolean bl) {
            if (n2 >= 64) {
                this.ensureNext();
                this.mNext.insert(n2 - 64, bl);
            } else {
                boolean bl2 = (this.mData & Long.MIN_VALUE) != 0L;
                long l2 = (1L << n2) - 1L;
                long l3 = this.mData;
                this.mData = (l3 & (l2 ^ 0xFFFFFFFFFFFFFFFFL)) << 1 | l3 & l2;
                if (bl) {
                    this.set(n2);
                } else {
                    this.clear(n2);
                }
                if (bl2 || this.mNext != null) {
                    this.ensureNext();
                    this.mNext.insert(0, bl2);
                }
            }
        }

        boolean remove(int n2) {
            if (n2 >= 64) {
                this.ensureNext();
                return this.mNext.remove(n2 - 64);
            }
            long l2 = 1L << n2;
            boolean bl = (this.mData & l2) != 0L;
            this.mData &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            long l3 = this.mData;
            this.mData = Long.rotateRight(l3 & (--l2 ^ 0xFFFFFFFFFFFFFFFFL), 1) | l3 & l2;
            Bucket bucket = this.mNext;
            if (bucket != null) {
                if (bucket.get(0)) {
                    this.set(63);
                }
                this.mNext.remove(0);
            }
            return bl;
        }

        void reset() {
            this.mData = 0L;
            Bucket bucket = this.mNext;
            if (bucket != null) {
                bucket.reset();
            }
        }

        void set(int n2) {
            if (n2 >= 64) {
                this.ensureNext();
                this.mNext.set(n2 - 64);
            } else {
                this.mData |= 1L << n2;
            }
        }

        public String toString() {
            CharSequence charSequence;
            if (this.mNext == null) {
                charSequence = Long.toBinaryString(this.mData);
            } else {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(this.mNext.toString());
                ((StringBuilder)charSequence).append("xx");
                ((StringBuilder)charSequence).append(Long.toBinaryString(this.mData));
                charSequence = ((StringBuilder)charSequence).toString();
            }
            return charSequence;
        }
    }

    static interface Callback {
        public void addView(View var1, int var2);

        public void attachViewToParent(View var1, int var2, ViewGroup.LayoutParams var3);

        public void detachViewFromParent(int var1);

        public View getChildAt(int var1);

        public int getChildCount();

        public RecyclerView.ViewHolder getChildViewHolder(View var1);

        public int indexOfChild(View var1);

        public void onEnteredHiddenState(View var1);

        public void onLeftHiddenState(View var1);

        public void removeAllViews();

        public void removeViewAt(int var1);
    }
}

