/*
 * Decompiled with CFR 0.152.
 */
package androidx.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintDocumentInfo;
import android.print.PrintManager;
import android.print.pdf.PrintedPdfDocument;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PrintHelper {
    public static final int COLOR_MODE_COLOR = 2;
    public static final int COLOR_MODE_MONOCHROME = 1;
    static final boolean IS_MIN_MARGINS_HANDLING_CORRECT;
    private static final String LOG_TAG = "PrintHelper";
    private static final int MAX_PRINT_SIZE = 3500;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int ORIENTATION_PORTRAIT = 2;
    static final boolean PRINT_ACTIVITY_RESPECTS_ORIENTATION;
    public static final int SCALE_MODE_FILL = 2;
    public static final int SCALE_MODE_FIT = 1;
    int mColorMode = 2;
    final Context mContext;
    BitmapFactory.Options mDecodeOptions = null;
    final Object mLock = new Object();
    int mOrientation = 1;
    int mScaleMode = 2;

    static {
        int n2 = Build.VERSION.SDK_INT;
        boolean bl = false;
        boolean bl2 = n2 < 20 || Build.VERSION.SDK_INT > 23;
        PRINT_ACTIVITY_RESPECTS_ORIENTATION = bl2;
        bl2 = bl;
        if (Build.VERSION.SDK_INT != 23) {
            bl2 = true;
        }
        IS_MIN_MARGINS_HANDLING_CORRECT = bl2;
    }

    public PrintHelper(Context context) {
        this.mContext = context;
    }

    static Bitmap convertBitmapForColorMode(Bitmap bitmap, int n2) {
        if (n2 != 1) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(colorMatrix));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        canvas.setBitmap(null);
        return bitmap2;
    }

    private static PrintAttributes.Builder copyAttributes(PrintAttributes printAttributes) {
        PrintAttributes.Builder builder = new PrintAttributes.Builder().setMediaSize(printAttributes.getMediaSize()).setResolution(printAttributes.getResolution()).setMinMargins(printAttributes.getMinMargins());
        if (printAttributes.getColorMode() != 0) {
            builder.setColorMode(printAttributes.getColorMode());
        }
        if (Build.VERSION.SDK_INT >= 23 && printAttributes.getDuplexMode() != 0) {
            builder.setDuplexMode(printAttributes.getDuplexMode());
        }
        return builder;
    }

    static Matrix getMatrix(int n2, int n3, RectF rectF, int n4) {
        Matrix matrix = new Matrix();
        float f2 = rectF.width();
        float f3 = n2;
        f2 /= f3;
        f2 = n4 == 2 ? Math.max(f2, rectF.height() / (float)n3) : Math.min(f2, rectF.height() / (float)n3);
        matrix.postScale(f2, f2);
        matrix.postTranslate((rectF.width() - f3 * f2) / 2.0f, (rectF.height() - (float)n3 * f2) / 2.0f);
        return matrix;
    }

    static boolean isPortrait(Bitmap bitmap) {
        boolean bl = bitmap.getWidth() <= bitmap.getHeight();
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap loadBitmap(Uri uri, BitmapFactory.Options options) throws FileNotFoundException {
        void var1_4;
        block8: {
            if (uri == null) throw new IllegalArgumentException("bad argument to loadBitmap");
            Object object = this.mContext;
            if (object == null) throw new IllegalArgumentException("bad argument to loadBitmap");
            Object var4_9 = null;
            try {
                object = object.getContentResolver().openInputStream(uri);
            }
            catch (Throwable throwable) {
                options = var4_9;
                break block8;
            }
            try {
                uri = BitmapFactory.decodeStream((InputStream)object, null, (BitmapFactory.Options)options);
                if (object == null) return uri;
            }
            catch (Throwable throwable) {
                options = object;
                break block8;
            }
            try {
                ((InputStream)object).close();
                return uri;
            }
            catch (IOException iOException) {
                Log.w((String)LOG_TAG, (String)"close fail ", (Throwable)iOException);
            }
            return uri;
        }
        if (options == null) throw var1_4;
        try {
            options.close();
            throw var1_4;
        }
        catch (IOException iOException) {
            Log.w((String)LOG_TAG, (String)"close fail ", (Throwable)iOException);
        }
        throw var1_4;
    }

    public static boolean systemSupportsPrint() {
        boolean bl = Build.VERSION.SDK_INT >= 19;
        return bl;
    }

    public int getColorMode() {
        return this.mColorMode;
    }

    public int getOrientation() {
        if (Build.VERSION.SDK_INT >= 19 && this.mOrientation == 0) {
            return 1;
        }
        return this.mOrientation;
    }

    public int getScaleMode() {
        return this.mScaleMode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Bitmap loadConstrainedBitmap(Uri object) throws FileNotFoundException {
        if (object != null && this.mContext != null) {
            BitmapFactory.Options options;
            Object object2 = new BitmapFactory.Options();
            object2.inJustDecodeBounds = true;
            this.loadBitmap((Uri)object, (BitmapFactory.Options)object2);
            int n2 = object2.outWidth;
            int n3 = object2.outHeight;
            if (n2 <= 0) return null;
            if (n3 <= 0) {
                return null;
            }
            int n4 = 1;
            for (int i2 = Math.max(n2, n3); i2 > 3500; i2 >>>= 1, n4 <<= 1) {
            }
            if (n4 <= 0) return null;
            if (Math.min(n2, n3) / n4 <= 0) {
                return null;
            }
            object2 = this.mLock;
            synchronized (object2) {
                this.mDecodeOptions = options = new BitmapFactory.Options();
                this.mDecodeOptions.inMutable = true;
                this.mDecodeOptions.inSampleSize = n4;
                options = this.mDecodeOptions;
            }
            try {
                object2 = this.loadBitmap((Uri)object, options);
                return object2;
            }
            finally {
                object = this.mLock;
                synchronized (object) {
                    this.mDecodeOptions = null;
                }
            }
        }
        object = new IllegalArgumentException("bad argument to getScaledBitmap");
        throw object;
    }

    public void printBitmap(String string2, Bitmap bitmap) {
        this.printBitmap(string2, bitmap, null);
    }

    public void printBitmap(String string2, Bitmap bitmap, OnPrintFinishCallback onPrintFinishCallback) {
        if (Build.VERSION.SDK_INT >= 19 && bitmap != null) {
            PrintManager printManager = (PrintManager)this.mContext.getSystemService("print");
            PrintAttributes.MediaSize mediaSize = PrintHelper.isPortrait(bitmap) ? PrintAttributes.MediaSize.UNKNOWN_PORTRAIT : PrintAttributes.MediaSize.UNKNOWN_LANDSCAPE;
            mediaSize = new PrintAttributes.Builder().setMediaSize(mediaSize).setColorMode(this.mColorMode).build();
            printManager.print(string2, (PrintDocumentAdapter)new PrintBitmapAdapter(string2, this.mScaleMode, bitmap, onPrintFinishCallback), (PrintAttributes)mediaSize);
        }
    }

    public void printBitmap(String string2, Uri uri) throws FileNotFoundException {
        this.printBitmap(string2, uri, null);
    }

    public void printBitmap(String string2, Uri object, OnPrintFinishCallback onPrintFinishCallback) throws FileNotFoundException {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        object = new PrintUriAdapter(string2, (Uri)object, onPrintFinishCallback, this.mScaleMode);
        PrintManager printManager = (PrintManager)this.mContext.getSystemService("print");
        onPrintFinishCallback = new PrintAttributes.Builder();
        onPrintFinishCallback.setColorMode(this.mColorMode);
        int n2 = this.mOrientation;
        if (n2 != 1 && n2 != 0) {
            if (n2 == 2) {
                onPrintFinishCallback.setMediaSize(PrintAttributes.MediaSize.UNKNOWN_PORTRAIT);
            }
        } else {
            onPrintFinishCallback.setMediaSize(PrintAttributes.MediaSize.UNKNOWN_LANDSCAPE);
        }
        printManager.print(string2, (PrintDocumentAdapter)object, onPrintFinishCallback.build());
    }

    public void setColorMode(int n2) {
        this.mColorMode = n2;
    }

    public void setOrientation(int n2) {
        this.mOrientation = n2;
    }

    public void setScaleMode(int n2) {
        this.mScaleMode = n2;
    }

    void writeBitmap(final PrintAttributes printAttributes, final int n2, final Bitmap bitmap, final ParcelFileDescriptor parcelFileDescriptor, final CancellationSignal cancellationSignal, final PrintDocumentAdapter.WriteResultCallback writeResultCallback) {
        final PrintAttributes printAttributes2 = IS_MIN_MARGINS_HANDLING_CORRECT ? printAttributes : PrintHelper.copyAttributes(printAttributes).setMinMargins(new PrintAttributes.Margins(0, 0, 0, 0)).build();
        new AsyncTask<Void, Void, Throwable>(){

            /*
             * Unable to fully structure code
             * Enabled aggressive exception aggregation
             */
            protected Throwable doInBackground(Void ... var1_1) {
                block27: {
                    block26: {
                        if (cancellationSignal.isCanceled()) {
                            return null;
                        }
                        var2_6 = new PrintedPdfDocument(PrintHelper.this.mContext, printAttributes2);
                        var3_8 = PrintHelper.convertBitmapForColorMode(bitmap, printAttributes2.getColorMode());
                        var4_9 = cancellationSignal.isCanceled();
                        if (!var4_9) break block26;
                        return null;
                    }
                    var5_10 = var2_6.startPage(1);
                    if (PrintHelper.IS_MIN_MARGINS_HANDLING_CORRECT) {
                        var1_1 /* !! */  = new RectF(var5_10.getInfo().getContentRect());
                    } else {
                        var6_11 = new PrintedPdfDocument(PrintHelper.this.mContext, printAttributes);
                        var7_12 = var6_11.startPage(1);
                        var1_1 /* !! */  = new RectF(var7_12.getInfo().getContentRect());
                        var6_11.finishPage(var7_12);
                        var6_11.close();
                    }
                    var7_12 = PrintHelper.getMatrix(var3_8.getWidth(), var3_8.getHeight(), var1_1 /* !! */ , n2);
                    if (!PrintHelper.IS_MIN_MARGINS_HANDLING_CORRECT) {
                        var7_12.postTranslate(var1_1 /* !! */ .left, var1_1 /* !! */ .top);
                        var5_10.getCanvas().clipRect(var1_1 /* !! */ );
                    }
                    var5_10.getCanvas().drawBitmap(var3_8, (Matrix)var7_12, null);
                    var2_6.finishPage(var5_10);
                    var4_9 = cancellationSignal.isCanceled();
                    if (!var4_9) break block27;
                    var2_6.close();
                    var1_1 /* !! */  = parcelFileDescriptor;
                    if (var1_1 /* !! */  != null) {
                        parcelFileDescriptor.close();
                    }
lbl36:
                    // 4 sources

                    while (true) {
                        if (var3_8 != bitmap) {
                            var3_8.recycle();
                        }
                        return null;
                    }
                }
                var1_1 /* !! */  = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
                var2_6.writeTo((OutputStream)var1_1 /* !! */ );
                try {
                    var2_6.close();
                    var1_1 /* !! */  = parcelFileDescriptor;
                    if (var1_1 /* !! */  != null) {
                        parcelFileDescriptor.close();
                    }
lbl50:
                    // 4 sources

                    while (true) {
                        if (var3_8 != bitmap) {
                            var3_8.recycle();
                        }
                        return null;
                    }
                    catch (Throwable var1_2) {
                        var2_6.close();
                        var2_6 = parcelFileDescriptor;
                        if (var2_6 != null) {
                            parcelFileDescriptor.close();
                        }
lbl60:
                        // 4 sources

                        while (true) {
                            if (var3_8 != bitmap) {
                                var3_8.recycle();
                            }
                            throw var1_2;
                        }
                    }
                }
                catch (Throwable var1_3) {
                    return var1_3;
                }
                {
                    catch (IOException var1_4) {
                        ** continue;
                    }
                }
                {
                    catch (IOException var1_5) {
                        ** continue;
                    }
                    {
                        catch (IOException var2_7) {
                            ** continue;
                        }
                    }
                }
            }

            protected void onPostExecute(Throwable throwable) {
                if (cancellationSignal.isCanceled()) {
                    writeResultCallback.onWriteCancelled();
                } else if (throwable == null) {
                    writeResultCallback.onWriteFinished(new PageRange[]{PageRange.ALL_PAGES});
                } else {
                    Log.e((String)PrintHelper.LOG_TAG, (String)"Error writing printed content", (Throwable)throwable);
                    writeResultCallback.onWriteFailed(null);
                }
            }
        }.execute((Object[])new Void[0]);
    }

    public static interface OnPrintFinishCallback {
        public void onFinish();
    }

    private class PrintBitmapAdapter
    extends PrintDocumentAdapter {
        private PrintAttributes mAttributes;
        private final Bitmap mBitmap;
        private final OnPrintFinishCallback mCallback;
        private final int mFittingMode;
        private final String mJobName;

        PrintBitmapAdapter(String string2, int n2, Bitmap bitmap, OnPrintFinishCallback onPrintFinishCallback) {
            this.mJobName = string2;
            this.mFittingMode = n2;
            this.mBitmap = bitmap;
            this.mCallback = onPrintFinishCallback;
        }

        public void onFinish() {
            OnPrintFinishCallback onPrintFinishCallback = this.mCallback;
            if (onPrintFinishCallback != null) {
                onPrintFinishCallback.onFinish();
            }
        }

        public void onLayout(PrintAttributes printAttributes, PrintAttributes printAttributes2, CancellationSignal cancellationSignal, PrintDocumentAdapter.LayoutResultCallback layoutResultCallback, Bundle bundle) {
            this.mAttributes = printAttributes2;
            layoutResultCallback.onLayoutFinished(new PrintDocumentInfo.Builder(this.mJobName).setContentType(1).setPageCount(1).build(), printAttributes2.equals((Object)printAttributes) ^ true);
        }

        public void onWrite(PageRange[] pageRangeArray, ParcelFileDescriptor parcelFileDescriptor, CancellationSignal cancellationSignal, PrintDocumentAdapter.WriteResultCallback writeResultCallback) {
            PrintHelper.this.writeBitmap(this.mAttributes, this.mFittingMode, this.mBitmap, parcelFileDescriptor, cancellationSignal, writeResultCallback);
        }
    }

    private class PrintUriAdapter
    extends PrintDocumentAdapter {
        PrintAttributes mAttributes;
        Bitmap mBitmap;
        final OnPrintFinishCallback mCallback;
        final int mFittingMode;
        final Uri mImageFile;
        final String mJobName;
        AsyncTask<Uri, Boolean, Bitmap> mLoadBitmap;

        PrintUriAdapter(String string2, Uri uri, OnPrintFinishCallback onPrintFinishCallback, int n2) {
            this.mJobName = string2;
            this.mImageFile = uri;
            this.mCallback = onPrintFinishCallback;
            this.mFittingMode = n2;
            this.mBitmap = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void cancelLoad() {
            Object object = PrintHelper.this.mLock;
            synchronized (object) {
                if (PrintHelper.this.mDecodeOptions != null) {
                    if (Build.VERSION.SDK_INT < 24) {
                        PrintHelper.this.mDecodeOptions.requestCancelDecode();
                    }
                    PrintHelper.this.mDecodeOptions = null;
                }
                return;
            }
        }

        public void onFinish() {
            super.onFinish();
            this.cancelLoad();
            Object object = this.mLoadBitmap;
            if (object != null) {
                object.cancel(true);
            }
            if ((object = this.mCallback) != null) {
                object.onFinish();
            }
            if ((object = this.mBitmap) != null) {
                object.recycle();
                this.mBitmap = null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void onLayout(final PrintAttributes printAttributes, final PrintAttributes printAttributes2, final CancellationSignal cancellationSignal, final PrintDocumentAdapter.LayoutResultCallback layoutResultCallback, Bundle bundle) {
            // MONITORENTER : this
            this.mAttributes = printAttributes2;
            // MONITOREXIT : this
            if (cancellationSignal.isCanceled()) {
                layoutResultCallback.onLayoutCancelled();
                return;
            }
            if (this.mBitmap != null) {
                layoutResultCallback.onLayoutFinished(new PrintDocumentInfo.Builder(this.mJobName).setContentType(1).setPageCount(1).build(), printAttributes2.equals((Object)printAttributes) ^ true);
                return;
            }
            this.mLoadBitmap = new AsyncTask<Uri, Boolean, Bitmap>(){

                protected Bitmap doInBackground(Uri ... bitmap) {
                    try {
                        bitmap = PrintHelper.this.loadConstrainedBitmap(PrintUriAdapter.this.mImageFile);
                        return bitmap;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return null;
                    }
                }

                protected void onCancelled(Bitmap bitmap) {
                    layoutResultCallback.onLayoutCancelled();
                    PrintUriAdapter.this.mLoadBitmap = null;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void onPostExecute(Bitmap object) {
                    Bitmap bitmap;
                    block10: {
                        PrintAttributes.MediaSize mediaSize;
                        block11: {
                            super.onPostExecute(object);
                            bitmap = object;
                            if (object == null) break block10;
                            if (!PRINT_ACTIVITY_RESPECTS_ORIENTATION) break block11;
                            bitmap = object;
                            if (PrintHelper.this.mOrientation != 0) break block10;
                        }
                        synchronized (this) {
                            mediaSize = PrintUriAdapter.this.mAttributes.getMediaSize();
                        }
                        bitmap = object;
                        if (mediaSize != null) {
                            bitmap = object;
                            if (mediaSize.isPortrait() != PrintHelper.isPortrait(object)) {
                                bitmap = new Matrix();
                                bitmap.postRotate(90.0f);
                                bitmap = Bitmap.createBitmap((Bitmap)object, (int)0, (int)0, (int)object.getWidth(), (int)object.getHeight(), (Matrix)bitmap, (boolean)true);
                            }
                        }
                    }
                    object = PrintUriAdapter.this;
                    object.mBitmap = bitmap;
                    if (bitmap != null) {
                        object = new PrintDocumentInfo.Builder(object.mJobName).setContentType(1).setPageCount(1).build();
                        boolean bl = printAttributes2.equals((Object)printAttributes);
                        layoutResultCallback.onLayoutFinished((PrintDocumentInfo)object, true ^ bl);
                    } else {
                        layoutResultCallback.onLayoutFailed(null);
                    }
                    PrintUriAdapter.this.mLoadBitmap = null;
                }

                protected void onPreExecute() {
                    cancellationSignal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

                        public void onCancel() {
                            PrintUriAdapter.this.cancelLoad();
                            this.cancel(false);
                        }
                    });
                }
            }.execute((Object[])new Uri[0]);
        }

        public void onWrite(PageRange[] pageRangeArray, ParcelFileDescriptor parcelFileDescriptor, CancellationSignal cancellationSignal, PrintDocumentAdapter.WriteResultCallback writeResultCallback) {
            PrintHelper.this.writeBitmap(this.mAttributes, this.mFittingMode, this.mBitmap, parcelFileDescriptor, cancellationSignal, writeResultCallback);
        }
    }
}

