/*
 * Decompiled with CFR 0.152.
 */
package androidx.multidex;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.CRC32;
import java.util.zip.ZipException;

final class ZipUtil {
    private static final int BUFFER_SIZE = 16384;
    private static final int ENDHDR = 22;
    private static final int ENDSIG = 101010256;

    ZipUtil() {
    }

    static long computeCrcOfCentralDir(RandomAccessFile randomAccessFile, CentralDirectory object) throws IOException {
        CRC32 cRC32 = new CRC32();
        long l2 = ((CentralDirectory)object).size;
        randomAccessFile.seek(((CentralDirectory)object).offset);
        int n2 = (int)Math.min(16384L, l2);
        object = new byte[16384];
        n2 = randomAccessFile.read((byte[])object, 0, n2);
        while (n2 != -1) {
            cRC32.update((byte[])object, 0, n2);
            if ((l2 -= (long)n2) == 0L) break;
            n2 = randomAccessFile.read((byte[])object, 0, (int)Math.min(16384L, l2));
        }
        return cRC32.getValue();
    }

    static CentralDirectory findCentralDirectory(RandomAccessFile object) throws IOException, ZipException {
        long l2 = ((RandomAccessFile)object).length() - 22L;
        long l3 = 0L;
        if (l2 >= 0L) {
            long l4 = l2 - 65536L;
            if (l4 >= 0L) {
                l3 = l4;
            }
            int n2 = Integer.reverseBytes(101010256);
            do {
                ((RandomAccessFile)object).seek(l2);
                if (((RandomAccessFile)object).readInt() != n2) continue;
                ((RandomAccessFile)object).skipBytes(2);
                ((RandomAccessFile)object).skipBytes(2);
                ((RandomAccessFile)object).skipBytes(2);
                ((RandomAccessFile)object).skipBytes(2);
                CentralDirectory centralDirectory = new CentralDirectory();
                centralDirectory.size = (long)Integer.reverseBytes(((RandomAccessFile)object).readInt()) & 0xFFFFFFFFL;
                centralDirectory.offset = (long)Integer.reverseBytes(((RandomAccessFile)object).readInt()) & 0xFFFFFFFFL;
                return centralDirectory;
            } while (--l2 >= l3);
            throw new ZipException("End Of Central Directory signature not found");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("File too short to be a zip file: ");
        stringBuilder.append(((RandomAccessFile)object).length());
        object = new ZipException(stringBuilder.toString());
        throw object;
    }

    static long getZipCrc(File object) throws IOException {
        object = new RandomAccessFile((File)object, "r");
        try {
            long l2 = ZipUtil.computeCrcOfCentralDir((RandomAccessFile)object, ZipUtil.findCentralDirectory((RandomAccessFile)object));
            return l2;
        }
        finally {
            ((RandomAccessFile)object).close();
        }
    }

    static class CentralDirectory {
        long offset;
        long size;

        CentralDirectory() {
        }
    }
}

