/*
 * Decompiled with CFR 0.152.
 */
package androidx.media;

import android.media.VolumeProvider;
import android.os.Build;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class VolumeProviderCompat {
    public static final int VOLUME_CONTROL_ABSOLUTE = 2;
    public static final int VOLUME_CONTROL_FIXED = 0;
    public static final int VOLUME_CONTROL_RELATIVE = 1;
    private Callback mCallback;
    private final String mControlId;
    private final int mControlType;
    private int mCurrentVolume;
    private final int mMaxVolume;
    private VolumeProvider mVolumeProviderFwk;

    public VolumeProviderCompat(int n2, int n3, int n4) {
        this(n2, n3, n4, null);
    }

    public VolumeProviderCompat(int n2, int n3, int n4, String string2) {
        this.mControlType = n2;
        this.mMaxVolume = n3;
        this.mCurrentVolume = n4;
        this.mControlId = string2;
    }

    public final int getCurrentVolume() {
        return this.mCurrentVolume;
    }

    public final int getMaxVolume() {
        return this.mMaxVolume;
    }

    public final int getVolumeControl() {
        return this.mControlType;
    }

    public final String getVolumeControlId() {
        return this.mControlId;
    }

    public Object getVolumeProvider() {
        if (this.mVolumeProviderFwk == null) {
            if (Build.VERSION.SDK_INT >= 30) {
                this.mVolumeProviderFwk = new VolumeProvider(this.mControlType, this.mMaxVolume, this.mCurrentVolume, this.mControlId){

                    public void onAdjustVolume(int n2) {
                        VolumeProviderCompat.this.onAdjustVolume(n2);
                    }

                    public void onSetVolumeTo(int n2) {
                        VolumeProviderCompat.this.onSetVolumeTo(n2);
                    }
                };
            } else if (Build.VERSION.SDK_INT >= 21) {
                this.mVolumeProviderFwk = new VolumeProvider(this.mControlType, this.mMaxVolume, this.mCurrentVolume){

                    public void onAdjustVolume(int n2) {
                        VolumeProviderCompat.this.onAdjustVolume(n2);
                    }

                    public void onSetVolumeTo(int n2) {
                        VolumeProviderCompat.this.onSetVolumeTo(n2);
                    }
                };
            }
        }
        return this.mVolumeProviderFwk;
    }

    public void onAdjustVolume(int n2) {
    }

    public void onSetVolumeTo(int n2) {
    }

    public void setCallback(Callback callback2) {
        this.mCallback = callback2;
    }

    public final void setCurrentVolume(int n2) {
        Callback callback2;
        this.mCurrentVolume = n2;
        if (Build.VERSION.SDK_INT >= 21) {
            ((VolumeProvider)this.getVolumeProvider()).setCurrentVolume(n2);
        }
        if ((callback2 = this.mCallback) != null) {
            callback2.onVolumeChanged(this);
        }
    }

    public static abstract class Callback {
        public abstract void onVolumeChanged(VolumeProviderCompat var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ControlType {
    }
}

