/*
 * Decompiled with CFR 0.152.
 */
package androidx.media;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.media.browse.MediaBrowser;
import android.media.session.MediaSession;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.service.media.MediaBrowserService;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.session.IMediaSession;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.os.ResultReceiver;
import android.text.TextUtils;
import android.util.Log;
import androidx.collection.ArrayMap;
import androidx.core.app.BundleCompat;
import androidx.core.util.Pair;
import androidx.media.MediaBrowserCompatUtils;
import androidx.media.MediaSessionManager;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class MediaBrowserServiceCompat
extends Service {
    static final boolean DEBUG = Log.isLoggable((String)"MBServiceCompat", (int)3);
    private static final float EPSILON = 1.0E-5f;
    public static final String KEY_MEDIA_ITEM = "media_item";
    public static final String KEY_SEARCH_RESULTS = "search_results";
    public static final int RESULT_ERROR = -1;
    static final int RESULT_FLAG_ON_LOAD_ITEM_NOT_IMPLEMENTED = 2;
    static final int RESULT_FLAG_ON_SEARCH_NOT_IMPLEMENTED = 4;
    static final int RESULT_FLAG_OPTION_NOT_HANDLED = 1;
    public static final int RESULT_OK = 0;
    public static final int RESULT_PROGRESS_UPDATE = 1;
    public static final String SERVICE_INTERFACE = "android.media.browse.MediaBrowserService";
    static final String TAG = "MBServiceCompat";
    final ConnectionRecord mConnectionFromFwk = new ConnectionRecord("android.media.session.MediaController", -1, -1, null, null);
    final ArrayMap<IBinder, ConnectionRecord> mConnections;
    ConnectionRecord mCurConnection;
    final ServiceHandler mHandler;
    private MediaBrowserServiceImpl mImpl;
    final ArrayList<ConnectionRecord> mPendingConnections = new ArrayList();
    MediaSessionCompat.Token mSession;

    public MediaBrowserServiceCompat() {
        this.mConnections = new ArrayMap();
        this.mHandler = new ServiceHandler();
    }

    void addSubscription(String string2, ConnectionRecord connectionRecord, IBinder iBinder, Bundle bundle) {
        List<Pair<IBinder, Bundle>> list = connectionRecord.subscriptions.get(string2);
        List<Pair<IBinder, Bundle>> list2 = list;
        if (list == null) {
            list2 = new ArrayList<Pair<IBinder, Bundle>>();
        }
        for (Pair pair : list2) {
            if (iBinder != pair.first || !MediaBrowserCompatUtils.areSameOptions((Bundle)bundle, (Bundle)((Bundle)pair.second))) continue;
            return;
        }
        list2.add(new Pair<IBinder, Bundle>(iBinder, bundle));
        connectionRecord.subscriptions.put(string2, list2);
        this.performLoadChildren(string2, connectionRecord, bundle, null);
        this.mCurConnection = connectionRecord;
        this.onSubscribe(string2, bundle);
        this.mCurConnection = null;
    }

    List<MediaBrowserCompat.MediaItem> applyOptions(List<MediaBrowserCompat.MediaItem> list, Bundle bundle) {
        if (list == null) {
            return null;
        }
        int n2 = bundle.getInt("android.media.browse.extra.PAGE", -1);
        int n3 = bundle.getInt("android.media.browse.extra.PAGE_SIZE", -1);
        if (n2 == -1 && n3 == -1) {
            return list;
        }
        int n4 = n3 * n2;
        int n5 = n4 + n3;
        if (n2 >= 0 && n3 >= 1 && n4 < list.size()) {
            n2 = n5;
            if (n5 > list.size()) {
                n2 = list.size();
            }
            return list.subList(n4, n2);
        }
        return Collections.emptyList();
    }

    public void attachToBaseContext(Context context) {
        this.attachBaseContext(context);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    public final Bundle getBrowserRootHints() {
        return this.mImpl.getBrowserRootHints();
    }

    public final MediaSessionManager.RemoteUserInfo getCurrentBrowserInfo() {
        return this.mImpl.getCurrentBrowserInfo();
    }

    public MediaSessionCompat.Token getSessionToken() {
        return this.mSession;
    }

    boolean isValidPackage(String string2, int n2) {
        if (string2 == null) {
            return false;
        }
        String[] stringArray = this.getPackageManager().getPackagesForUid(n2);
        int n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!stringArray[n2].equals(string2)) continue;
            return true;
        }
        return false;
    }

    public void notifyChildrenChanged(MediaSessionManager.RemoteUserInfo remoteUserInfo, String string2, Bundle bundle) {
        if (remoteUserInfo != null) {
            if (string2 != null) {
                if (bundle != null) {
                    this.mImpl.notifyChildrenChanged(remoteUserInfo, string2, bundle);
                    return;
                }
                throw new IllegalArgumentException("options cannot be null in notifyChildrenChanged");
            }
            throw new IllegalArgumentException("parentId cannot be null in notifyChildrenChanged");
        }
        throw new IllegalArgumentException("remoteUserInfo cannot be null in notifyChildrenChanged");
    }

    public void notifyChildrenChanged(String string2) {
        if (string2 != null) {
            this.mImpl.notifyChildrenChanged(string2, null);
            return;
        }
        throw new IllegalArgumentException("parentId cannot be null in notifyChildrenChanged");
    }

    public void notifyChildrenChanged(String string2, Bundle bundle) {
        if (string2 != null) {
            if (bundle != null) {
                this.mImpl.notifyChildrenChanged(string2, bundle);
                return;
            }
            throw new IllegalArgumentException("options cannot be null in notifyChildrenChanged");
        }
        throw new IllegalArgumentException("parentId cannot be null in notifyChildrenChanged");
    }

    public IBinder onBind(Intent intent) {
        return this.mImpl.onBind(intent);
    }

    public void onCreate() {
        super.onCreate();
        this.mImpl = Build.VERSION.SDK_INT >= 28 ? new MediaBrowserServiceImplApi28() : (Build.VERSION.SDK_INT >= 26 ? new MediaBrowserServiceImplApi26() : (Build.VERSION.SDK_INT >= 23 ? new MediaBrowserServiceImplApi23() : (Build.VERSION.SDK_INT >= 21 ? new MediaBrowserServiceImplApi21() : new MediaBrowserServiceImplBase())));
        this.mImpl.onCreate();
    }

    public void onCustomAction(String string2, Bundle bundle, Result<Bundle> result) {
        result.sendError(null);
    }

    public abstract BrowserRoot onGetRoot(String var1, int var2, Bundle var3);

    public abstract void onLoadChildren(String var1, Result<List<MediaBrowserCompat.MediaItem>> var2);

    public void onLoadChildren(String string2, Result<List<MediaBrowserCompat.MediaItem>> result, Bundle bundle) {
        result.setFlags(1);
        this.onLoadChildren(string2, result);
    }

    public void onLoadItem(String string2, Result<MediaBrowserCompat.MediaItem> result) {
        result.setFlags(2);
        result.sendResult(null);
    }

    public void onSearch(String string2, Bundle bundle, Result<List<MediaBrowserCompat.MediaItem>> result) {
        result.setFlags(4);
        result.sendResult(null);
    }

    public void onSubscribe(String string2, Bundle bundle) {
    }

    public void onUnsubscribe(String string2) {
    }

    void performCustomAction(String string2, Bundle bundle, ConnectionRecord object, ResultReceiver object2) {
        object2 = new Result<Bundle>((Object)string2, (ResultReceiver)object2){
            final /* synthetic */ ResultReceiver val$receiver;
            {
                this.val$receiver = resultReceiver;
                super(object);
            }

            @Override
            void onErrorSent(Bundle bundle) {
                this.val$receiver.send(-1, bundle);
            }

            @Override
            void onProgressUpdateSent(Bundle bundle) {
                this.val$receiver.send(1, bundle);
            }

            @Override
            void onResultSent(Bundle bundle) {
                this.val$receiver.send(0, bundle);
            }
        };
        this.mCurConnection = object;
        this.onCustomAction(string2, bundle, (Result<Bundle>)object2);
        this.mCurConnection = null;
        if (((Result)object2).isDone()) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("onCustomAction must call detach() or sendResult() or sendError() before returning for action=");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(" extras=");
        ((StringBuilder)object).append(bundle);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    void performLoadChildren(final String string2, final ConnectionRecord connectionRecord, Bundle object, Bundle object2) {
        object2 = new Result<List<MediaBrowserCompat.MediaItem>>((Object)string2, (Bundle)object, (Bundle)object2){
            final /* synthetic */ Bundle val$notifyChildrenChangedOptions;
            final /* synthetic */ Bundle val$subscribeOptions;
            {
                this.val$subscribeOptions = bundle;
                this.val$notifyChildrenChangedOptions = bundle2;
                super(object);
            }

            @Override
            void onResultSent(List<MediaBrowserCompat.MediaItem> object) {
                if (MediaBrowserServiceCompat.this.mConnections.get((Object)connectionRecord.callbacks.asBinder()) != connectionRecord) {
                    if (DEBUG) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Not sending onLoadChildren result for connection that has been disconnected. pkg=");
                        ((StringBuilder)object).append(connectionRecord.pkg);
                        ((StringBuilder)object).append(" id=");
                        ((StringBuilder)object).append(string2);
                        Log.d((String)MediaBrowserServiceCompat.TAG, (String)((StringBuilder)object).toString());
                    }
                    return;
                }
                List<MediaBrowserCompat.MediaItem> list = object;
                if ((this.getFlags() & 1) != 0) {
                    list = MediaBrowserServiceCompat.this.applyOptions((List<MediaBrowserCompat.MediaItem>)object, this.val$subscribeOptions);
                }
                try {
                    connectionRecord.callbacks.onLoadChildren(string2, list, this.val$subscribeOptions, this.val$notifyChildrenChangedOptions);
                }
                catch (RemoteException remoteException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Calling onLoadChildren() failed for id=");
                    stringBuilder.append(string2);
                    stringBuilder.append(" package=");
                    stringBuilder.append(connectionRecord.pkg);
                    Log.w((String)MediaBrowserServiceCompat.TAG, (String)stringBuilder.toString());
                }
            }
        };
        this.mCurConnection = connectionRecord;
        if (object == null) {
            this.onLoadChildren(string2, (Result<List<MediaBrowserCompat.MediaItem>>)object2);
        } else {
            this.onLoadChildren(string2, (Result<List<MediaBrowserCompat.MediaItem>>)object2, (Bundle)object);
        }
        this.mCurConnection = null;
        if (((Result)object2).isDone()) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("onLoadChildren must call detach() or sendResult() before returning for package=");
        ((StringBuilder)object).append(connectionRecord.pkg);
        ((StringBuilder)object).append(" id=");
        ((StringBuilder)object).append(string2);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    void performLoadItem(String string2, ConnectionRecord object, ResultReceiver object2) {
        object2 = new Result<MediaBrowserCompat.MediaItem>((Object)string2, (ResultReceiver)object2){
            final /* synthetic */ ResultReceiver val$receiver;
            {
                this.val$receiver = resultReceiver;
                super(object);
            }

            @Override
            void onResultSent(MediaBrowserCompat.MediaItem mediaItem) {
                if ((this.getFlags() & 2) != 0) {
                    this.val$receiver.send(-1, null);
                    return;
                }
                Bundle bundle = new Bundle();
                bundle.putParcelable(MediaBrowserServiceCompat.KEY_MEDIA_ITEM, (Parcelable)mediaItem);
                this.val$receiver.send(0, bundle);
            }
        };
        this.mCurConnection = object;
        this.onLoadItem(string2, (Result<MediaBrowserCompat.MediaItem>)object2);
        this.mCurConnection = null;
        if (((Result)object2).isDone()) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("onLoadItem must call detach() or sendResult() before returning for id=");
        ((StringBuilder)object).append(string2);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    void performSearch(String string2, Bundle object, ConnectionRecord connectionRecord, ResultReceiver object2) {
        object2 = new Result<List<MediaBrowserCompat.MediaItem>>((Object)string2, (ResultReceiver)object2){
            final /* synthetic */ ResultReceiver val$receiver;
            {
                this.val$receiver = resultReceiver;
                super(object);
            }

            @Override
            void onResultSent(List<MediaBrowserCompat.MediaItem> list) {
                if ((this.getFlags() & 4) == 0 && list != null) {
                    Bundle bundle = new Bundle();
                    bundle.putParcelableArray(MediaBrowserServiceCompat.KEY_SEARCH_RESULTS, (Parcelable[])list.toArray(new MediaBrowserCompat.MediaItem[0]));
                    this.val$receiver.send(0, bundle);
                    return;
                }
                this.val$receiver.send(-1, null);
            }
        };
        this.mCurConnection = connectionRecord;
        this.onSearch(string2, (Bundle)object, (Result<List<MediaBrowserCompat.MediaItem>>)object2);
        this.mCurConnection = null;
        if (((Result)object2).isDone()) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("onSearch must call detach() or sendResult() before returning for query=");
        ((StringBuilder)object).append(string2);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    boolean removeSubscription(String string2, ConnectionRecord connectionRecord, IBinder object) {
        boolean bl;
        block7: {
            bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            if (object == null) {
                object = connectionRecord.subscriptions.remove(string2);
                bl3 = object != null ? bl : false;
                this.mCurConnection = connectionRecord;
                this.onUnsubscribe(string2);
                this.mCurConnection = null;
                return bl3;
            }
            List<Pair<IBinder, Bundle>> list = connectionRecord.subscriptions.get(string2);
            bl = bl2;
            if (list == null) break block7;
            try {
                Iterator<Pair<IBinder, Bundle>> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    if (object != iterator2.next().first) continue;
                    iterator2.remove();
                    bl3 = true;
                }
                bl = bl3;
            }
            catch (Throwable throwable) {
                this.mCurConnection = connectionRecord;
                this.onUnsubscribe(string2);
                this.mCurConnection = null;
                throw throwable;
            }
            if (list.size() != 0) break block7;
            connectionRecord.subscriptions.remove(string2);
            bl = bl3;
        }
        this.mCurConnection = connectionRecord;
        this.onUnsubscribe(string2);
        this.mCurConnection = null;
        return bl;
    }

    public void setSessionToken(MediaSessionCompat.Token token) {
        if (token != null) {
            if (this.mSession == null) {
                this.mSession = token;
                this.mImpl.setSessionToken(token);
                return;
            }
            throw new IllegalStateException("The session token has already been set");
        }
        throw new IllegalArgumentException("Session token may not be null");
    }

    public static final class BrowserRoot {
        public static final String EXTRA_OFFLINE = "android.service.media.extra.OFFLINE";
        public static final String EXTRA_RECENT = "android.service.media.extra.RECENT";
        public static final String EXTRA_SUGGESTED = "android.service.media.extra.SUGGESTED";
        @Deprecated
        public static final String EXTRA_SUGGESTION_KEYWORDS = "android.service.media.extra.SUGGESTION_KEYWORDS";
        private final Bundle mExtras;
        private final String mRootId;

        public BrowserRoot(String string2, Bundle bundle) {
            if (string2 != null) {
                this.mRootId = string2;
                this.mExtras = bundle;
                return;
            }
            throw new IllegalArgumentException("The root id in BrowserRoot cannot be null. Use null for BrowserRoot instead");
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public String getRootId() {
            return this.mRootId;
        }
    }

    private class ConnectionRecord
    implements IBinder.DeathRecipient {
        public final MediaSessionManager.RemoteUserInfo browserInfo;
        public final ServiceCallbacks callbacks;
        public final int pid;
        public final String pkg;
        public BrowserRoot root;
        public final Bundle rootHints;
        public final HashMap<String, List<Pair<IBinder, Bundle>>> subscriptions = new HashMap();
        public final int uid;

        ConnectionRecord(String string2, int n2, int n3, Bundle bundle, ServiceCallbacks serviceCallbacks) {
            this.pkg = string2;
            this.pid = n2;
            this.uid = n3;
            this.browserInfo = new MediaSessionManager.RemoteUserInfo(string2, n2, n3);
            this.rootHints = bundle;
            this.callbacks = serviceCallbacks;
        }

        public void binderDied() {
            MediaBrowserServiceCompat.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaBrowserServiceCompat.this.mConnections.remove((Object)ConnectionRecord.this.callbacks.asBinder());
                }
            });
        }
    }

    static interface MediaBrowserServiceImpl {
        public Bundle getBrowserRootHints();

        public MediaSessionManager.RemoteUserInfo getCurrentBrowserInfo();

        public void notifyChildrenChanged(MediaSessionManager.RemoteUserInfo var1, String var2, Bundle var3);

        public void notifyChildrenChanged(String var1, Bundle var2);

        public IBinder onBind(Intent var1);

        public void onCreate();

        public void setSessionToken(MediaSessionCompat.Token var1);
    }

    class MediaBrowserServiceImplApi21
    implements MediaBrowserServiceImpl {
        Messenger mMessenger;
        final List<Bundle> mRootExtrasList = new ArrayList<Bundle>();
        MediaBrowserService mServiceFwk;

        MediaBrowserServiceImplApi21() {
        }

        @Override
        public Bundle getBrowserRootHints() {
            Messenger messenger = this.mMessenger;
            Bundle bundle = null;
            if (messenger == null) {
                return null;
            }
            if (MediaBrowserServiceCompat.this.mCurConnection != null) {
                if (MediaBrowserServiceCompat.this.mCurConnection.rootHints != null) {
                    bundle = new Bundle(MediaBrowserServiceCompat.this.mCurConnection.rootHints);
                }
                return bundle;
            }
            throw new IllegalStateException("This should be called inside of onGetRoot, onLoadChildren, onLoadItem, onSearch, or onCustomAction methods");
        }

        @Override
        public MediaSessionManager.RemoteUserInfo getCurrentBrowserInfo() {
            if (MediaBrowserServiceCompat.this.mCurConnection != null) {
                return MediaBrowserServiceCompat.this.mCurConnection.browserInfo;
            }
            throw new IllegalStateException("This should be called inside of onGetRoot, onLoadChildren, onLoadItem, onSearch, or onCustomAction methods");
        }

        @Override
        public void notifyChildrenChanged(MediaSessionManager.RemoteUserInfo remoteUserInfo, String string2, Bundle bundle) {
            this.notifyChildrenChangedForCompat(remoteUserInfo, string2, bundle);
        }

        @Override
        public void notifyChildrenChanged(String string2, Bundle bundle) {
            this.notifyChildrenChangedForFramework(string2, bundle);
            this.notifyChildrenChangedForCompat(string2, bundle);
        }

        void notifyChildrenChangedForCompat(final MediaSessionManager.RemoteUserInfo remoteUserInfo, final String string2, final Bundle bundle) {
            MediaBrowserServiceCompat.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (int i2 = 0; i2 < MediaBrowserServiceCompat.this.mConnections.size(); ++i2) {
                        ConnectionRecord connectionRecord = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.valueAt(i2);
                        if (!connectionRecord.browserInfo.equals((Object)remoteUserInfo)) continue;
                        MediaBrowserServiceImplApi21.this.notifyChildrenChangedForCompatOnHandler(connectionRecord, string2, bundle);
                    }
                }
            });
        }

        void notifyChildrenChangedForCompat(final String string2, final Bundle bundle) {
            MediaBrowserServiceCompat.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (Object object : MediaBrowserServiceCompat.this.mConnections.keySet()) {
                        object = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(object);
                        MediaBrowserServiceImplApi21.this.notifyChildrenChangedForCompatOnHandler((ConnectionRecord)object, string2, bundle);
                    }
                }
            });
        }

        void notifyChildrenChangedForCompatOnHandler(ConnectionRecord connectionRecord, String string2, Bundle bundle) {
            List<Pair<IBinder, Bundle>> list = connectionRecord.subscriptions.get(string2);
            if (list != null) {
                for (Pair pair : list) {
                    if (!MediaBrowserCompatUtils.hasDuplicatedItems((Bundle)bundle, (Bundle)((Bundle)pair.second))) continue;
                    MediaBrowserServiceCompat.this.performLoadChildren(string2, connectionRecord, (Bundle)pair.second, bundle);
                }
            }
        }

        void notifyChildrenChangedForFramework(String string2, Bundle bundle) {
            this.mServiceFwk.notifyChildrenChanged(string2);
        }

        @Override
        public IBinder onBind(Intent intent) {
            return this.mServiceFwk.onBind(intent);
        }

        @Override
        public void onCreate() {
            this.mServiceFwk = new MediaBrowserServiceApi21((Context)MediaBrowserServiceCompat.this);
            this.mServiceFwk.onCreate();
        }

        public BrowserRoot onGetRoot(String object, int n2, Bundle object2) {
            int n3;
            Object object3;
            ConnectionRecord connectionRecord;
            if (object2 != null && object2.getInt("extra_client_version", 0) != 0) {
                object2.remove("extra_client_version");
                this.mMessenger = new Messenger((Handler)MediaBrowserServiceCompat.this.mHandler);
                connectionRecord = new Bundle();
                connectionRecord.putInt("extra_service_version", 2);
                BundleCompat.putBinder((Bundle)connectionRecord, (String)"extra_messenger", (IBinder)this.mMessenger.getBinder());
                if (MediaBrowserServiceCompat.this.mSession != null) {
                    object3 = MediaBrowserServiceCompat.this.mSession.getExtraBinder();
                    object3 = object3 == null ? null : object3.asBinder();
                    BundleCompat.putBinder((Bundle)connectionRecord, (String)"extra_session_binder", (IBinder)object3);
                } else {
                    this.mRootExtrasList.add((Bundle)connectionRecord);
                }
                n3 = object2.getInt("extra_calling_pid", -1);
                object2.remove("extra_calling_pid");
                object3 = connectionRecord;
            } else {
                object3 = null;
                n3 = -1;
            }
            connectionRecord = new ConnectionRecord((String)object, n3, n2, (Bundle)object2, null);
            MediaBrowserServiceCompat mediaBrowserServiceCompat = MediaBrowserServiceCompat.this;
            mediaBrowserServiceCompat.mCurConnection = connectionRecord;
            object2 = mediaBrowserServiceCompat.onGetRoot((String)object, n2, (Bundle)object2);
            object = MediaBrowserServiceCompat.this;
            ((MediaBrowserServiceCompat)((Object)object)).mCurConnection = null;
            if (object2 == null) {
                return null;
            }
            if (this.mMessenger != null) {
                ((MediaBrowserServiceCompat)((Object)object)).mPendingConnections.add(connectionRecord);
            }
            if (object3 == null) {
                object = ((BrowserRoot)object2).getExtras();
            } else {
                object = object3;
                if (((BrowserRoot)object2).getExtras() != null) {
                    object3.putAll(((BrowserRoot)object2).getExtras());
                    object = object3;
                }
            }
            return new BrowserRoot(((BrowserRoot)object2).getRootId(), (Bundle)object);
        }

        public void onLoadChildren(String string2, final ResultWrapper<List<Parcel>> object) {
            object = new Result<List<MediaBrowserCompat.MediaItem>>((Object)string2){

                @Override
                public void detach() {
                    object.detach();
                }

                @Override
                void onResultSent(List<MediaBrowserCompat.MediaItem> parcel) {
                    if (parcel != null) {
                        ArrayList<MediaBrowserCompat.MediaItem> arrayList = new ArrayList<MediaBrowserCompat.MediaItem>();
                        Iterator<MediaBrowserCompat.MediaItem> iterator2 = parcel.iterator();
                        while (true) {
                            parcel = arrayList;
                            if (iterator2.hasNext()) {
                                MediaBrowserCompat.MediaItem mediaItem = iterator2.next();
                                parcel = Parcel.obtain();
                                mediaItem.writeToParcel(parcel, 0);
                                arrayList.add((MediaBrowserCompat.MediaItem)parcel);
                                continue;
                            }
                            break;
                        }
                    } else {
                        parcel = null;
                    }
                    object.sendResult(parcel);
                }
            };
            MediaBrowserServiceCompat mediaBrowserServiceCompat = MediaBrowserServiceCompat.this;
            mediaBrowserServiceCompat.mCurConnection = mediaBrowserServiceCompat.mConnectionFromFwk;
            MediaBrowserServiceCompat.this.onLoadChildren(string2, (Result<List<MediaBrowserCompat.MediaItem>>)object);
            MediaBrowserServiceCompat.this.mCurConnection = null;
        }

        @Override
        public void setSessionToken(final MediaSessionCompat.Token token) {
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                @Override
                public void run() {
                    if (!MediaBrowserServiceImplApi21.this.mRootExtrasList.isEmpty()) {
                        IMediaSession iMediaSession = token.getExtraBinder();
                        if (iMediaSession != null) {
                            Iterator<Bundle> iterator2 = MediaBrowserServiceImplApi21.this.mRootExtrasList.iterator();
                            while (iterator2.hasNext()) {
                                BundleCompat.putBinder((Bundle)iterator2.next(), (String)"extra_session_binder", (IBinder)iMediaSession.asBinder());
                            }
                        }
                        MediaBrowserServiceImplApi21.this.mRootExtrasList.clear();
                    }
                    MediaBrowserServiceImplApi21.this.mServiceFwk.setSessionToken((MediaSession.Token)token.getToken());
                }
            });
        }

        class MediaBrowserServiceApi21
        extends MediaBrowserService {
            MediaBrowserServiceApi21(Context context) {
                this.attachBaseContext(context);
            }

            public MediaBrowserService.BrowserRoot onGetRoot(String object, int n2, Bundle object2) {
                MediaSessionCompat.ensureClassLoader(object2);
                MediaBrowserServiceImplApi21 mediaBrowserServiceImplApi21 = MediaBrowserServiceImplApi21.this;
                Object var5_5 = null;
                object2 = object2 == null ? null : new Bundle(object2);
                object = mediaBrowserServiceImplApi21.onGetRoot((String)object, n2, (Bundle)object2);
                object = object == null ? var5_5 : new MediaBrowserService.BrowserRoot(((BrowserRoot)object).mRootId, ((BrowserRoot)object).mExtras);
                return object;
            }

            public void onLoadChildren(String string2, MediaBrowserService.Result<List<MediaBrowser.MediaItem>> result) {
                MediaBrowserServiceImplApi21.this.onLoadChildren(string2, new ResultWrapper<List<Parcel>>(result));
            }
        }
    }

    class MediaBrowserServiceImplApi23
    extends MediaBrowserServiceImplApi21 {
        MediaBrowserServiceImplApi23() {
        }

        @Override
        public void onCreate() {
            this.mServiceFwk = new MediaBrowserServiceApi23((Context)MediaBrowserServiceCompat.this);
            this.mServiceFwk.onCreate();
        }

        public void onLoadItem(String string2, final ResultWrapper<Parcel> object) {
            Result<MediaBrowserCompat.MediaItem> result = new Result<MediaBrowserCompat.MediaItem>((Object)string2){

                @Override
                public void detach() {
                    object.detach();
                }

                @Override
                void onResultSent(MediaBrowserCompat.MediaItem mediaItem) {
                    if (mediaItem == null) {
                        object.sendResult(null);
                    } else {
                        Parcel parcel = Parcel.obtain();
                        mediaItem.writeToParcel(parcel, 0);
                        object.sendResult(parcel);
                    }
                }
            };
            object = MediaBrowserServiceCompat.this;
            ((MediaBrowserServiceCompat)((Object)object)).mCurConnection = ((MediaBrowserServiceCompat)((Object)object)).mConnectionFromFwk;
            MediaBrowserServiceCompat.this.onLoadItem(string2, result);
            MediaBrowserServiceCompat.this.mCurConnection = null;
        }

        class MediaBrowserServiceApi23
        extends MediaBrowserServiceImplApi21.MediaBrowserServiceApi21 {
            MediaBrowserServiceApi23(Context context) {
                super(context);
            }

            public void onLoadItem(String string2, MediaBrowserService.Result<MediaBrowser.MediaItem> result) {
                MediaBrowserServiceImplApi23.this.onLoadItem(string2, new ResultWrapper<Parcel>(result));
            }
        }
    }

    class MediaBrowserServiceImplApi26
    extends MediaBrowserServiceImplApi23 {
        MediaBrowserServiceImplApi26() {
        }

        @Override
        public Bundle getBrowserRootHints() {
            if (MediaBrowserServiceCompat.this.mCurConnection != null) {
                if (MediaBrowserServiceCompat.this.mCurConnection == MediaBrowserServiceCompat.this.mConnectionFromFwk) {
                    return this.mServiceFwk.getBrowserRootHints();
                }
                Bundle bundle = MediaBrowserServiceCompat.this.mCurConnection.rootHints == null ? null : new Bundle(MediaBrowserServiceCompat.this.mCurConnection.rootHints);
                return bundle;
            }
            throw new IllegalStateException("This should be called inside of onGetRoot, onLoadChildren, onLoadItem, onSearch, or onCustomAction methods");
        }

        @Override
        void notifyChildrenChangedForFramework(String string2, Bundle bundle) {
            if (bundle != null) {
                this.mServiceFwk.notifyChildrenChanged(string2, bundle);
            } else {
                super.notifyChildrenChangedForFramework(string2, bundle);
            }
        }

        @Override
        public void onCreate() {
            this.mServiceFwk = new MediaBrowserServiceApi26((Context)MediaBrowserServiceCompat.this);
            this.mServiceFwk.onCreate();
        }

        public void onLoadChildren(String string2, final ResultWrapper<List<Parcel>> object, final Bundle bundle) {
            Result<List<MediaBrowserCompat.MediaItem>> result = new Result<List<MediaBrowserCompat.MediaItem>>((Object)string2){

                @Override
                public void detach() {
                    object.detach();
                }

                @Override
                void onResultSent(List<MediaBrowserCompat.MediaItem> list) {
                    if (list == null) {
                        object.sendResult(null);
                        return;
                    }
                    List<MediaBrowserCompat.MediaItem> list2 = list;
                    if ((this.getFlags() & 1) != 0) {
                        list2 = MediaBrowserServiceCompat.this.applyOptions(list, bundle);
                    }
                    list = new ArrayList<MediaBrowserCompat.MediaItem>();
                    for (MediaBrowserCompat.MediaItem mediaItem : list2) {
                        Parcel parcel = Parcel.obtain();
                        mediaItem.writeToParcel(parcel, 0);
                        list.add((MediaBrowserCompat.MediaItem)parcel);
                    }
                    object.sendResult(list);
                }
            };
            object = MediaBrowserServiceCompat.this;
            ((MediaBrowserServiceCompat)((Object)object)).mCurConnection = ((MediaBrowserServiceCompat)((Object)object)).mConnectionFromFwk;
            MediaBrowserServiceCompat.this.onLoadChildren(string2, result, bundle);
            MediaBrowserServiceCompat.this.mCurConnection = null;
        }

        class MediaBrowserServiceApi26
        extends MediaBrowserServiceImplApi23.MediaBrowserServiceApi23 {
            MediaBrowserServiceApi26(Context context) {
                super(context);
            }

            public void onLoadChildren(String string2, MediaBrowserService.Result<List<MediaBrowser.MediaItem>> result, Bundle bundle) {
                MediaSessionCompat.ensureClassLoader(bundle);
                MediaBrowserServiceCompat.this.mCurConnection = MediaBrowserServiceCompat.this.mConnectionFromFwk;
                MediaBrowserServiceImplApi26.this.onLoadChildren(string2, new ResultWrapper<List<Parcel>>(result), bundle);
                MediaBrowserServiceCompat.this.mCurConnection = null;
            }
        }
    }

    class MediaBrowserServiceImplApi28
    extends MediaBrowserServiceImplApi26 {
        MediaBrowserServiceImplApi28() {
        }

        @Override
        public MediaSessionManager.RemoteUserInfo getCurrentBrowserInfo() {
            if (MediaBrowserServiceCompat.this.mCurConnection != null) {
                if (MediaBrowserServiceCompat.this.mCurConnection == MediaBrowserServiceCompat.this.mConnectionFromFwk) {
                    return new MediaSessionManager.RemoteUserInfo(this.mServiceFwk.getCurrentBrowserInfo());
                }
                return MediaBrowserServiceCompat.this.mCurConnection.browserInfo;
            }
            throw new IllegalStateException("This should be called inside of onGetRoot, onLoadChildren, onLoadItem, onSearch, or onCustomAction methods");
        }
    }

    class MediaBrowserServiceImplBase
    implements MediaBrowserServiceImpl {
        private Messenger mMessenger;

        MediaBrowserServiceImplBase() {
        }

        @Override
        public Bundle getBrowserRootHints() {
            if (MediaBrowserServiceCompat.this.mCurConnection != null) {
                Bundle bundle = MediaBrowserServiceCompat.this.mCurConnection.rootHints == null ? null : new Bundle(MediaBrowserServiceCompat.this.mCurConnection.rootHints);
                return bundle;
            }
            throw new IllegalStateException("This should be called inside of onLoadChildren, onLoadItem, onSearch, or onCustomAction methods");
        }

        @Override
        public MediaSessionManager.RemoteUserInfo getCurrentBrowserInfo() {
            if (MediaBrowserServiceCompat.this.mCurConnection != null) {
                return MediaBrowserServiceCompat.this.mCurConnection.browserInfo;
            }
            throw new IllegalStateException("This should be called inside of onLoadChildren, onLoadItem, onSearch, or onCustomAction methods");
        }

        @Override
        public void notifyChildrenChanged(final MediaSessionManager.RemoteUserInfo remoteUserInfo, final String string2, final Bundle bundle) {
            MediaBrowserServiceCompat.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (int i2 = 0; i2 < MediaBrowserServiceCompat.this.mConnections.size(); ++i2) {
                        ConnectionRecord connectionRecord = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.valueAt(i2);
                        if (!connectionRecord.browserInfo.equals((Object)remoteUserInfo)) continue;
                        MediaBrowserServiceImplBase.this.notifyChildrenChangedOnHandler(connectionRecord, string2, bundle);
                        break;
                    }
                }
            });
        }

        @Override
        public void notifyChildrenChanged(final String string2, final Bundle bundle) {
            MediaBrowserServiceCompat.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (Object object : MediaBrowserServiceCompat.this.mConnections.keySet()) {
                        object = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(object);
                        MediaBrowserServiceImplBase.this.notifyChildrenChangedOnHandler((ConnectionRecord)object, string2, bundle);
                    }
                }
            });
        }

        void notifyChildrenChangedOnHandler(ConnectionRecord connectionRecord, String string2, Bundle bundle) {
            List<Pair<IBinder, Bundle>> list2 = connectionRecord.subscriptions.get(string2);
            if (list2 != null) {
                for (Pair<IBinder, Bundle> pair : list2) {
                    if (!MediaBrowserCompatUtils.hasDuplicatedItems((Bundle)bundle, (Bundle)((Bundle)pair.second))) continue;
                    MediaBrowserServiceCompat.this.performLoadChildren(string2, connectionRecord, (Bundle)pair.second, bundle);
                }
            }
        }

        @Override
        public IBinder onBind(Intent intent) {
            if (MediaBrowserServiceCompat.SERVICE_INTERFACE.equals(intent.getAction())) {
                return this.mMessenger.getBinder();
            }
            return null;
        }

        @Override
        public void onCreate() {
            this.mMessenger = new Messenger((Handler)MediaBrowserServiceCompat.this.mHandler);
        }

        @Override
        public void setSessionToken(final MediaSessionCompat.Token token) {
            MediaBrowserServiceCompat.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Iterator iterator2 = MediaBrowserServiceCompat.this.mConnections.values().iterator();
                    while (iterator2.hasNext()) {
                        ConnectionRecord connectionRecord = (ConnectionRecord)iterator2.next();
                        try {
                            connectionRecord.callbacks.onConnect(connectionRecord.root.getRootId(), token, connectionRecord.root.getExtras());
                        }
                        catch (RemoteException remoteException) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Connection for ");
                            stringBuilder.append(connectionRecord.pkg);
                            stringBuilder.append(" is no longer valid.");
                            Log.w((String)MediaBrowserServiceCompat.TAG, (String)stringBuilder.toString());
                            iterator2.remove();
                        }
                    }
                }
            });
        }
    }

    public static class Result<T> {
        private final Object mDebug;
        private boolean mDetachCalled;
        private int mFlags;
        private boolean mSendErrorCalled;
        private boolean mSendResultCalled;

        Result(Object object) {
            this.mDebug = object;
        }

        private void checkExtraFields(Bundle bundle) {
            float f2;
            if (bundle == null) {
                return;
            }
            if (bundle.containsKey("android.media.browse.extra.DOWNLOAD_PROGRESS") && ((f2 = bundle.getFloat("android.media.browse.extra.DOWNLOAD_PROGRESS")) < -1.0E-5f || f2 > 1.00001f)) {
                throw new IllegalArgumentException("The value of the EXTRA_DOWNLOAD_PROGRESS field must be a float number within [0.0, 1.0]");
            }
        }

        public void detach() {
            if (!this.mDetachCalled) {
                if (!this.mSendResultCalled) {
                    if (!this.mSendErrorCalled) {
                        this.mDetachCalled = true;
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("detach() called when sendError() had already been called for: ");
                    stringBuilder.append(this.mDebug);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("detach() called when sendResult() had already been called for: ");
                stringBuilder.append(this.mDebug);
                throw new IllegalStateException(stringBuilder.toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("detach() called when detach() had already been called for: ");
            stringBuilder.append(this.mDebug);
            throw new IllegalStateException(stringBuilder.toString());
        }

        int getFlags() {
            return this.mFlags;
        }

        boolean isDone() {
            boolean bl = this.mDetachCalled || this.mSendResultCalled || this.mSendErrorCalled;
            return bl;
        }

        void onErrorSent(Bundle object) {
            object = new StringBuilder();
            ((StringBuilder)object).append("It is not supported to send an error for ");
            ((StringBuilder)object).append(this.mDebug);
            throw new UnsupportedOperationException(((StringBuilder)object).toString());
        }

        void onProgressUpdateSent(Bundle object) {
            object = new StringBuilder();
            ((StringBuilder)object).append("It is not supported to send an interim update for ");
            ((StringBuilder)object).append(this.mDebug);
            throw new UnsupportedOperationException(((StringBuilder)object).toString());
        }

        void onResultSent(T t) {
        }

        public void sendError(Bundle object) {
            if (!this.mSendResultCalled && !this.mSendErrorCalled) {
                this.mSendErrorCalled = true;
                this.onErrorSent((Bundle)object);
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("sendError() called when either sendResult() or sendError() had already been called for: ");
            ((StringBuilder)object).append(this.mDebug);
            throw new IllegalStateException(((StringBuilder)object).toString());
        }

        public void sendProgressUpdate(Bundle object) {
            if (!this.mSendResultCalled && !this.mSendErrorCalled) {
                this.checkExtraFields((Bundle)object);
                this.onProgressUpdateSent((Bundle)object);
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("sendProgressUpdate() called when either sendResult() or sendError() had already been called for: ");
            ((StringBuilder)object).append(this.mDebug);
            throw new IllegalStateException(((StringBuilder)object).toString());
        }

        public void sendResult(T object) {
            if (!this.mSendResultCalled && !this.mSendErrorCalled) {
                this.mSendResultCalled = true;
                this.onResultSent(object);
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("sendResult() called when either sendResult() or sendError() had already been called for: ");
            ((StringBuilder)object).append(this.mDebug);
            throw new IllegalStateException(((StringBuilder)object).toString());
        }

        void setFlags(int n2) {
            this.mFlags = n2;
        }
    }

    static class ResultWrapper<T> {
        MediaBrowserService.Result mResultFwk;

        ResultWrapper(MediaBrowserService.Result result) {
            this.mResultFwk = result;
        }

        public void detach() {
            this.mResultFwk.detach();
        }

        List<MediaBrowser.MediaItem> parcelListToItemList(List<Parcel> parcel2) {
            if (parcel2 == null) {
                return null;
            }
            ArrayList<MediaBrowser.MediaItem> arrayList = new ArrayList<MediaBrowser.MediaItem>();
            for (Parcel parcel2 : parcel2) {
                parcel2.setDataPosition(0);
                arrayList.add((MediaBrowser.MediaItem)MediaBrowser.MediaItem.CREATOR.createFromParcel(parcel2));
                parcel2.recycle();
            }
            return arrayList;
        }

        public void sendResult(T object) {
            if (object instanceof List) {
                this.mResultFwk.sendResult(this.parcelListToItemList((List)object));
            } else if (object instanceof Parcel) {
                object = (Parcel)object;
                object.setDataPosition(0);
                this.mResultFwk.sendResult(MediaBrowser.MediaItem.CREATOR.createFromParcel(object));
                object.recycle();
            } else {
                this.mResultFwk.sendResult(null);
            }
        }
    }

    private class ServiceBinderImpl {
        ServiceBinderImpl() {
        }

        public void addSubscription(final String string2, final IBinder iBinder, final Bundle bundle, final ServiceCallbacks serviceCallbacks) {
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                @Override
                public void run() {
                    Object object = serviceCallbacks.asBinder();
                    if ((object = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(object)) == null) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("addSubscription for callback that isn't registered id=");
                        ((StringBuilder)object).append(string2);
                        Log.w((String)MediaBrowserServiceCompat.TAG, (String)((StringBuilder)object).toString());
                        return;
                    }
                    MediaBrowserServiceCompat.this.addSubscription(string2, (ConnectionRecord)object, iBinder, bundle);
                }
            });
        }

        public void connect(final String string2, final int n2, final int n3, Bundle object, final ServiceCallbacks serviceCallbacks) {
            if (MediaBrowserServiceCompat.this.isValidPackage(string2, n3)) {
                MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable((Bundle)object){
                    final /* synthetic */ Bundle val$rootHints;
                    {
                        this.val$rootHints = bundle;
                    }

                    @Override
                    public void run() {
                        ConnectionRecord connectionRecord;
                        Object object = serviceCallbacks.asBinder();
                        MediaBrowserServiceCompat.this.mConnections.remove(object);
                        MediaBrowserServiceCompat.this.mCurConnection = connectionRecord = new ConnectionRecord(string2, n2, n3, this.val$rootHints, serviceCallbacks);
                        connectionRecord.root = MediaBrowserServiceCompat.this.onGetRoot(string2, n3, this.val$rootHints);
                        MediaBrowserServiceCompat.this.mCurConnection = null;
                        if (connectionRecord.root == null) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("No root for client ");
                            ((StringBuilder)object).append(string2);
                            ((StringBuilder)object).append(" from service ");
                            ((StringBuilder)object).append(this.getClass().getName());
                            Log.i((String)MediaBrowserServiceCompat.TAG, (String)((StringBuilder)object).toString());
                            try {
                                serviceCallbacks.onConnectFailed();
                            }
                            catch (RemoteException remoteException) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("Calling onConnectFailed() failed. Ignoring. pkg=");
                                stringBuilder.append(string2);
                                Log.w((String)MediaBrowserServiceCompat.TAG, (String)stringBuilder.toString());
                            }
                        } else {
                            try {
                                MediaBrowserServiceCompat.this.mConnections.put(object, (Object)connectionRecord);
                                object.linkToDeath((IBinder.DeathRecipient)connectionRecord, 0);
                                if (MediaBrowserServiceCompat.this.mSession != null) {
                                    serviceCallbacks.onConnect(connectionRecord.root.getRootId(), MediaBrowserServiceCompat.this.mSession, connectionRecord.root.getExtras());
                                }
                            }
                            catch (RemoteException remoteException) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("Calling onConnect() failed. Dropping client. pkg=");
                                stringBuilder.append(string2);
                                Log.w((String)MediaBrowserServiceCompat.TAG, (String)stringBuilder.toString());
                                MediaBrowserServiceCompat.this.mConnections.remove(object);
                            }
                        }
                    }
                });
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Package/uid mismatch: uid=");
            ((StringBuilder)object).append(n3);
            ((StringBuilder)object).append(" package=");
            ((StringBuilder)object).append(string2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }

        public void disconnect(final ServiceCallbacks serviceCallbacks) {
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                @Override
                public void run() {
                    Object object = serviceCallbacks.asBinder();
                    if ((object = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.remove(object)) != null) {
                        object.callbacks.asBinder().unlinkToDeath((IBinder.DeathRecipient)object, 0);
                    }
                }
            });
        }

        public void getMediaItem(final String string2, final ResultReceiver resultReceiver, final ServiceCallbacks serviceCallbacks) {
            if (!TextUtils.isEmpty((CharSequence)string2) && resultReceiver != null) {
                MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                    @Override
                    public void run() {
                        Object object = serviceCallbacks.asBinder();
                        if ((object = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(object)) == null) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("getMediaItem for callback that isn't registered id=");
                            ((StringBuilder)object).append(string2);
                            Log.w((String)MediaBrowserServiceCompat.TAG, (String)((StringBuilder)object).toString());
                            return;
                        }
                        MediaBrowserServiceCompat.this.performLoadItem(string2, (ConnectionRecord)object, resultReceiver);
                    }
                });
            }
        }

        public void registerCallbacks(final ServiceCallbacks serviceCallbacks, final String string2, final int n2, final int n3, final Bundle bundle) {
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                @Override
                public void run() {
                    IBinder iBinder = serviceCallbacks.asBinder();
                    MediaBrowserServiceCompat.this.mConnections.remove((Object)iBinder);
                    Iterator<ConnectionRecord> iterator2 = MediaBrowserServiceCompat.this.mPendingConnections.iterator();
                    ConnectionRecord connectionRecord = null;
                    while (iterator2.hasNext()) {
                        ConnectionRecord connectionRecord2 = iterator2.next();
                        if (connectionRecord2.uid != n3) continue;
                        if (TextUtils.isEmpty((CharSequence)string2) || n2 <= 0) {
                            connectionRecord = new ConnectionRecord(connectionRecord2.pkg, connectionRecord2.pid, connectionRecord2.uid, bundle, serviceCallbacks);
                        }
                        iterator2.remove();
                    }
                    if (connectionRecord == null) {
                        connectionRecord = new ConnectionRecord(string2, n2, n3, bundle, serviceCallbacks);
                    }
                    MediaBrowserServiceCompat.this.mConnections.put((Object)iBinder, connectionRecord);
                    try {
                        iBinder.linkToDeath(connectionRecord, 0);
                    }
                    catch (RemoteException remoteException) {
                        Log.w((String)MediaBrowserServiceCompat.TAG, (String)"IBinder is already dead.");
                    }
                }
            });
        }

        public void removeSubscription(final String string2, final IBinder iBinder, final ServiceCallbacks serviceCallbacks) {
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                @Override
                public void run() {
                    Object object = serviceCallbacks.asBinder();
                    if ((object = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(object)) == null) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("removeSubscription for callback that isn't registered id=");
                        ((StringBuilder)object).append(string2);
                        Log.w((String)MediaBrowserServiceCompat.TAG, (String)((StringBuilder)object).toString());
                        return;
                    }
                    if (!MediaBrowserServiceCompat.this.removeSubscription(string2, (ConnectionRecord)object, iBinder)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("removeSubscription called for ");
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append(" which is not subscribed");
                        Log.w((String)MediaBrowserServiceCompat.TAG, (String)((StringBuilder)object).toString());
                    }
                }
            });
        }

        public void search(final String string2, final Bundle bundle, final ResultReceiver resultReceiver, final ServiceCallbacks serviceCallbacks) {
            if (!TextUtils.isEmpty((CharSequence)string2) && resultReceiver != null) {
                MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                    @Override
                    public void run() {
                        Object object = serviceCallbacks.asBinder();
                        if ((object = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(object)) == null) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("search for callback that isn't registered query=");
                            ((StringBuilder)object).append(string2);
                            Log.w((String)MediaBrowserServiceCompat.TAG, (String)((StringBuilder)object).toString());
                            return;
                        }
                        MediaBrowserServiceCompat.this.performSearch(string2, bundle, (ConnectionRecord)object, resultReceiver);
                    }
                });
            }
        }

        public void sendCustomAction(final String string2, final Bundle bundle, final ResultReceiver resultReceiver, final ServiceCallbacks serviceCallbacks) {
            if (!TextUtils.isEmpty((CharSequence)string2) && resultReceiver != null) {
                MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                    @Override
                    public void run() {
                        Object object = serviceCallbacks.asBinder();
                        if ((object = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(object)) == null) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("sendCustomAction for callback that isn't registered action=");
                            ((StringBuilder)object).append(string2);
                            ((StringBuilder)object).append(", extras=");
                            ((StringBuilder)object).append(bundle);
                            Log.w((String)MediaBrowserServiceCompat.TAG, (String)((StringBuilder)object).toString());
                            return;
                        }
                        MediaBrowserServiceCompat.this.performCustomAction(string2, bundle, (ConnectionRecord)object, resultReceiver);
                    }
                });
            }
        }

        public void unregisterCallbacks(final ServiceCallbacks serviceCallbacks) {
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                @Override
                public void run() {
                    IBinder iBinder = serviceCallbacks.asBinder();
                    ConnectionRecord connectionRecord = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.remove((Object)iBinder);
                    if (connectionRecord != null) {
                        iBinder.unlinkToDeath((IBinder.DeathRecipient)connectionRecord, 0);
                    }
                }
            });
        }
    }

    private static interface ServiceCallbacks {
        public IBinder asBinder();

        public void onConnect(String var1, MediaSessionCompat.Token var2, Bundle var3) throws RemoteException;

        public void onConnectFailed() throws RemoteException;

        public void onLoadChildren(String var1, List<MediaBrowserCompat.MediaItem> var2, Bundle var3, Bundle var4) throws RemoteException;
    }

    private static class ServiceCallbacksCompat
    implements ServiceCallbacks {
        final Messenger mCallbacks;

        ServiceCallbacksCompat(Messenger messenger) {
            this.mCallbacks = messenger;
        }

        private void sendRequest(int n2, Bundle bundle) throws RemoteException {
            Message message = Message.obtain();
            message.what = n2;
            message.arg1 = 2;
            message.setData(bundle);
            this.mCallbacks.send(message);
        }

        @Override
        public IBinder asBinder() {
            return this.mCallbacks.getBinder();
        }

        @Override
        public void onConnect(String string2, MediaSessionCompat.Token token, Bundle bundle) throws RemoteException {
            Bundle bundle2 = bundle;
            if (bundle == null) {
                bundle2 = new Bundle();
            }
            bundle2.putInt("extra_service_version", 2);
            bundle = new Bundle();
            bundle.putString("data_media_item_id", string2);
            bundle.putParcelable("data_media_session_token", (Parcelable)token);
            bundle.putBundle("data_root_hints", bundle2);
            this.sendRequest(1, bundle);
        }

        @Override
        public void onConnectFailed() throws RemoteException {
            this.sendRequest(2, null);
        }

        @Override
        public void onLoadChildren(String arrayList, List<MediaBrowserCompat.MediaItem> list, Bundle bundle, Bundle bundle2) throws RemoteException {
            Bundle bundle3 = new Bundle();
            bundle3.putString("data_media_item_id", (String)((Object)arrayList));
            bundle3.putBundle("data_options", bundle);
            bundle3.putBundle("data_notify_children_changed_options", bundle2);
            if (list != null) {
                arrayList = list instanceof ArrayList ? (ArrayList)list : new ArrayList<MediaBrowserCompat.MediaItem>(list);
                bundle3.putParcelableArrayList("data_media_item_list", arrayList);
            }
            this.sendRequest(3, bundle3);
        }
    }

    private final class ServiceHandler
    extends Handler {
        private final ServiceBinderImpl mServiceBinderImpl;

        ServiceHandler() {
            this.mServiceBinderImpl = new ServiceBinderImpl();
        }

        public void handleMessage(Message message) {
            Object object = message.getData();
            switch (message.what) {
                default: {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unhandled message: ");
                    ((StringBuilder)object).append(message);
                    ((StringBuilder)object).append("\n  Service version: ");
                    ((StringBuilder)object).append(2);
                    ((StringBuilder)object).append("\n  Client version: ");
                    ((StringBuilder)object).append(message.arg1);
                    Log.w((String)MediaBrowserServiceCompat.TAG, (String)((StringBuilder)object).toString());
                    break;
                }
                case 9: {
                    Bundle bundle = object.getBundle("data_custom_action_extras");
                    MediaSessionCompat.ensureClassLoader(bundle);
                    this.mServiceBinderImpl.sendCustomAction(object.getString("data_custom_action"), bundle, (ResultReceiver)object.getParcelable("data_result_receiver"), new ServiceCallbacksCompat(message.replyTo));
                    break;
                }
                case 8: {
                    Bundle bundle = object.getBundle("data_search_extras");
                    MediaSessionCompat.ensureClassLoader(bundle);
                    this.mServiceBinderImpl.search(object.getString("data_search_query"), bundle, (ResultReceiver)object.getParcelable("data_result_receiver"), new ServiceCallbacksCompat(message.replyTo));
                    break;
                }
                case 7: {
                    this.mServiceBinderImpl.unregisterCallbacks(new ServiceCallbacksCompat(message.replyTo));
                    break;
                }
                case 6: {
                    Bundle bundle = object.getBundle("data_root_hints");
                    MediaSessionCompat.ensureClassLoader(bundle);
                    this.mServiceBinderImpl.registerCallbacks(new ServiceCallbacksCompat(message.replyTo), object.getString("data_package_name"), object.getInt("data_calling_pid"), object.getInt("data_calling_uid"), bundle);
                    break;
                }
                case 5: {
                    this.mServiceBinderImpl.getMediaItem(object.getString("data_media_item_id"), (ResultReceiver)object.getParcelable("data_result_receiver"), new ServiceCallbacksCompat(message.replyTo));
                    break;
                }
                case 4: {
                    this.mServiceBinderImpl.removeSubscription(object.getString("data_media_item_id"), BundleCompat.getBinder((Bundle)object, (String)"data_callback_token"), new ServiceCallbacksCompat(message.replyTo));
                    break;
                }
                case 3: {
                    Bundle bundle = object.getBundle("data_options");
                    MediaSessionCompat.ensureClassLoader(bundle);
                    this.mServiceBinderImpl.addSubscription(object.getString("data_media_item_id"), BundleCompat.getBinder((Bundle)object, (String)"data_callback_token"), bundle, new ServiceCallbacksCompat(message.replyTo));
                    break;
                }
                case 2: {
                    this.mServiceBinderImpl.disconnect(new ServiceCallbacksCompat(message.replyTo));
                    break;
                }
                case 1: {
                    Bundle bundle = object.getBundle("data_root_hints");
                    MediaSessionCompat.ensureClassLoader(bundle);
                    this.mServiceBinderImpl.connect(object.getString("data_package_name"), object.getInt("data_calling_pid"), object.getInt("data_calling_uid"), bundle, new ServiceCallbacksCompat(message.replyTo));
                }
            }
        }

        public void postOrRun(Runnable runnable2) {
            if (Thread.currentThread() == this.getLooper().getThread()) {
                runnable2.run();
            } else {
                this.post(runnable2);
            }
        }

        public boolean sendMessageAtTime(Message message, long l2) {
            Bundle bundle = message.getData();
            bundle.setClassLoader(MediaBrowserCompat.class.getClassLoader());
            bundle.putInt("data_calling_uid", Binder.getCallingUid());
            int n2 = Binder.getCallingPid();
            if (n2 > 0) {
                bundle.putInt("data_calling_pid", n2);
            } else if (!bundle.containsKey("data_calling_pid")) {
                bundle.putInt("data_calling_pid", -1);
            }
            return super.sendMessageAtTime(message, l2);
        }
    }
}

