/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;

public class Transformations {
    private Transformations() {
    }

    public static <X, Y> LiveData<Y> map(LiveData<X> liveData, final Function<X, Y> function) {
        final MediatorLiveData mediatorLiveData = new MediatorLiveData();
        mediatorLiveData.addSource(liveData, new Observer<X>(){

            public void onChanged(X x2) {
                mediatorLiveData.setValue(function.apply(x2));
            }
        });
        return mediatorLiveData;
    }

    public static <X, Y> LiveData<Y> switchMap(LiveData<X> liveData, final Function<X, LiveData<Y>> function) {
        final MediatorLiveData mediatorLiveData = new MediatorLiveData();
        mediatorLiveData.addSource(liveData, new Observer<X>(){
            LiveData<Y> mSource;

            public void onChanged(X object) {
                object = this.mSource;
                LiveData liveData = (LiveData)function.apply(object);
                if (object == liveData) {
                    return;
                }
                if (object != null) {
                    mediatorLiveData.removeSource(object);
                }
                this.mSource = liveData;
                object = this.mSource;
                if (object != null) {
                    mediatorLiveData.addSource(object, new Observer<Y>(){

                        public void onChanged(Y y2) {
                            mediatorLiveData.setValue(y2);
                        }
                    });
                }
            }
        });
        return mediatorLiveData;
    }
}

